
/*****************************************************************************
 *
 *                          "tcp_debug.c"
 *                   -----------------------------
 *
 *  Version:    2.10
 *  File:    	..\..\tcp_debug.c
 *  Created:    14.08.2003
 *  Date:       24.04.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 12.11.2003 Version 2.02
 *			a.)	- first release
 *		2.) 17.06.2004 Version 2.04
 *			a.)	- add to display the "p_struct->last_tcp_state_machine"
 *
 *****************************************************************************/
#include "project.h"

#ifdef WEB_DEBUG_TCP_OFFLINE

#include <stdio.h>
#include <string.h>
#include <avr/pgmspace.h>
#include DEBUG_H_FILEPATH
#include WEB_DEBUG_H_FILEPATH
#include TCP_H_FILEPATH
#include TCP_DEBUG_H_FILEPATH


#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char tcp_debug_client_handle = TCP_WRONG_CONNECTIONS;
unsigned char tcp_debug_server_handle = TCP_WRONG_CONNECTIONS;

static PROGMEM char NewLine[] = "\n";

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void tcp_debug_display_socket_error(TCP_STRUCTURE * p_struct)
{
   if (p_struct->tcp_socket_error != p_struct->last_tcp_socket_error)
   {
      if (p_struct->tcp_socket_error & SOCK_ERR_ARP_TIMEOUT)
         printf_P(PSTR("arp_timeout "));
      if (p_struct->tcp_socket_error & SOCK_ERR_TCP_TIMEOUT)
         printf_P(PSTR("tcp_timeout "));
      if (p_struct->tcp_socket_error & SOCK_ERR_CONN_RESET)
         printf_P(PSTR("conn_reset "));
      if (p_struct->tcp_socket_error & SOCK_ERR_REMOTE)
         printf_P(PSTR("remote "));
      if (p_struct->tcp_socket_error & SOCK_ERR_TCP_SEQ)
         printf_P(PSTR("tcp_seq "));
      if (p_struct->tcp_socket_error & SOCK_ERR_TCP_ACK)
         printf_P(PSTR("tcp_ack "));
      if (p_struct->tcp_socket_error & SOCK_ERR_TCP)
         printf_P(PSTR("tcp "));
      printf_P(NewLine);
      p_struct->last_tcp_socket_error = p_struct->tcp_socket_error;
   }
}


void tcp_debug_display_flags(TCP_STRUCTURE * p_struct)
{
   if (p_struct->tcp_flags & TCP_FLAG_OPEN)
      printf_P(PSTR(" OPEN"));
   else
      printf_P(PSTR(" CLOSE"));
   if (p_struct->tcp_flags & TCP_FLAG_PASSIV)
      printf_P(PSTR(", PASSIV"));
   if (p_struct->tcp_flags & TCP_FLAG_ACTIVE)
      printf_P(PSTR(", ACTIVE"));
   if (p_struct->tcp_flags & TCP_FLAG_IP_ADDR_RESOLVED)
      printf_P(PSTR(", IP_ADDR_RESOLVED"));
   if (p_struct->tcp_flags & TCP_FLAG_CLOSE_REQUESTED)
      printf_P(PSTR(", CLOSE_REQUESTED"));
   if (p_struct->tcp_flags & TCP_FLAG_ABORT)
      printf_P(PSTR(", TCP_FLAG_ABORT"));
   if (p_struct->tcp_flags & TCP_FLAG_TIMER_RUNNING)
      printf_P(PSTR(", TIMER_RUNNING"));
   if (p_struct->tcp_flags & TCP_FLAG_TIMER_CTRL_RETRANSMIT)
      printf_P(PSTR(", TIMER_CTRL_RETRANSMIT"));
   printf_P(NewLine);
}


void tcp_debug_info(unsigned int port_number)
{
   unsigned char Lva, Lvb, display_count = 0;
   TCP_STRUCTURE *p_struct;

   p_struct = &tcp_struct[0];
   for (Lva = 0; Lva < TCP_MAX_CONNECTIONS; Lva++)
   {
      if ((port_number == 0) || (port_number == p_struct->tcp_port_local))
      {
         display_count++;
         printf_P(PSTR("tcp_connection: %u\n"), Lva);
         if (p_struct->tcp_socket_status & SOCK_ACTIV_OPEN)
            printf_P(PSTR(" socket_status: ACTIV_OPEN(Client)"));
         else
            printf_P(PSTR(" socket_status: PASSIV_OPEN(Server)"));
         if (p_struct->tcp_socket_status & SOCK_READY_CONNECT)
            printf_P(PSTR(", READY_CONNECT"));
         if (p_struct->tcp_socket_status & SOCK_CONNECTED)
            printf_P(PSTR(", CONNECTED"));
         if (p_struct->tcp_socket_status & SOCK_DISCONNECTING)
            printf_P(PSTR(", DISCONNECTING"));
         if (p_struct->tcp_socket_status & SOCK_DISCONNECTED)
            printf_P(PSTR(", DISCONNECTED"));
         if (p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
            printf_P(PSTR(", DATA_AVAILABLE"));
         printf_P(NewLine);
         if (p_struct->tcp_socket_error)
         {
            printf_P(PSTR(" socket_error: "));
            p_struct->last_tcp_socket_error = 0;
            tcp_debug_display_socket_error(p_struct);
         }
         printf_P(PSTR(" port-local, -remote : %u, %u\n"), p_struct->tcp_port_local,
                p_struct->tcp_port_remote);
         debug_print_ip(PSTR(" ip_remote"), p_struct->tcp_ip_remote);
         debug_print_mac(PSTR(" mac_remote"), p_struct->tcp_mac_remote);
         printf_P(PSTR(" flags      :"));
         tcp_debug_display_flags(p_struct);
         printf_P(PSTR(" state_machine     : %S\n"),
                pgm_read_word(&tcp_state_name[p_struct->tcp_state_machine]));
         printf_P(PSTR(" last_frame_sent   : %S\n"),
                pgm_read_word(&tcp_retransmit_name[p_struct->tcp_last_frame_sent]));
         printf_P(PSTR(" sequence next:%lu, unack:%lu, ack:%lu, win:%u\n"),
                p_struct->tcp_sequence_next, p_struct->tcp_sequence_unack,
                p_struct->tcp_sequence_ack, p_struct->tcp_window_local);
         printf_P(PSTR(" timer: %u / retry_counter: %u\n"), p_struct->tcp_timer,
                p_struct->tcp_retry_counter);
         printf_P(PSTR(" tx_buffer_status - Buffer: %uByte (H:%u D:%u)\n"),
                TCP_TX_BUFFER_COUNT * TCP_TX_SEGMENT_SIZE,
                TCP_ALL_HEADER_SIZE, TCP_TX_SEGMENT_SIZE);
         for (Lvb = 0; Lvb < TCP_TX_BUFFER_COUNT; Lvb++)
         {
            printf_P(PSTR("  %u.) "), Lvb);
            if (p_struct->tcp_tx[Lvb].flags & TCP_TX_FLAG_FREE)
               printf_P(PSTR("FREE, "));
            if (p_struct->tcp_tx[Lvb].flags & TCP_TX_FLAG_HALF_FULL)
               printf_P(PSTR("HALF_FULL, "));
            if (p_struct->tcp_tx[Lvb].flags & TCP_TX_FLAG_FULL)
               printf_P(PSTR("FULL, "));
            if (p_struct->tcp_tx[Lvb].flags & TCP_TX_FLAG_SENT)
               printf_P(PSTR("SENT, "));
            if (p_struct->tcp_tx[Lvb].flags & TCP_TX_FLAG_RETRANSMIT)
               printf_P(PSTR("RETRANSMIT, "));
            printf_P(PSTR(" data_count: %uByte age: %u\n"),
                   p_struct->tcp_tx[Lvb].data_count,
                   p_struct->tcp_tx[Lvb].age);
         }
         printf_P(PSTR(" rx_frame - Buffer:%u gap:%u\n"), TCP_RX_BUFFER_SIZE,
                p_struct->tcp_rx.gap);
#ifdef TCP_ALIVE_ACTIV_ENABLE
         printf_P(PSTR(" alive "));
         if (p_struct->tcp_alive_flag & TCP_ALIVE_FLAG_ENABLE)
            printf_P(PSTR("ENABLE"));
         else
            printf_P(PSTR("DISABLE"));
         if (p_struct->tcp_alive_flag & TCP_ALIVE_FLAG_OPEN)
            printf_P(PSTR(", OPEN"));
         else
            printf_P(PSTR(", CLOSE"));
         printf_P(PSTR(": %u0ms; timeout:%u0ms\n"), p_struct->tcp_alive_time * 5,
                (unsigned int) (TCP_ALIVE_TIMEOUT_FACTOR *
                                p_struct->tcp_alive_time) * 5);
#endif
         printf_P(PSTR(" last_state_machine: %S\n"),
                pgm_read_word(&tcp_state_name[p_struct->last_tcp_state_machine]));
         printf_P(PSTR(" receive-sequenz:%lu, relative:%lu\n"),
                p_struct->tcp_irs_number,
                p_struct->tcp_sequence_ack - p_struct->tcp_irs_number);
         printf_P(PSTR(" rx-ok:%lu, -wrong:%lu, -lost:%lu\n"),
                p_struct->tcp_rx_ok_data, p_struct->tcp_rx_wrong_data,
                p_struct->tcp_rx_lost_data);
         printf_P(PSTR(" send-sequenz:%lu, relative:%lu\n"),
                p_struct->tcp_iss_number,
                p_struct->tcp_sequence_next - p_struct->tcp_iss_number);
         printf_P(PSTR(" tx-ok:%lu, -repeat:%lu\n"), p_struct->tcp_tx_ok_data,
                p_struct->tcp_tx_repeat_data);
      }
      p_struct++;
   }
   if (display_count == 0)
   {
      printf_P(PSTR("no TCP-Port: %u\n"), port_number);
   }
}


unsigned char tcp_debug_buffer[TCP_TX_SEGMENT_SIZE];
void tcp_debug_client_server(void)
{
   TCP_STRUCTURE *p_struct;
   unsigned int tcp_data_count;

   p_struct = tcp_get_struct(tcp_debug_client_handle);
   if (p_struct == 0)
      tcp_debug_client_handle = TCP_WRONG_CONNECTIONS;
   else
   {
      if (p_struct->tcp_socket_status & SOCK_CONNECTED)
      {
         if (p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
         {
            tcp_rx_buffer_clear(tcp_debug_client_handle);
         }
      }
      else
      {
         if ((!
              (p_struct->
               tcp_socket_status & (SOCK_READY_CONNECT | SOCK_ACTIV_OPEN)))
             && (p_struct->tcp_socket_status & SOCK_DISCONNECTED))
         {
            printf_P(PSTR("\"tcp_debug_client_handle\" close\n"));
            tcp_debug_client_handle = TCP_WRONG_CONNECTIONS;
         }
      }
   }
   p_struct = tcp_get_struct(tcp_debug_server_handle);
   if (p_struct == 0)
      tcp_debug_server_handle = TCP_WRONG_CONNECTIONS;
   else
   {
      if (p_struct->tcp_socket_status & SOCK_CONNECTED)
      {
         if (p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
         {
            if (p_struct->tcp_port_local == TCP_PORT_ECHO)
            {
               tcp_data_count =
                  tcp_tx_buffer_write(tcp_debug_server_handle, 0x0, 0,
                                      TCP_TX_BUFFER_GET_SIZE);
               if (tcp_data_count > sizeof(tcp_debug_buffer))
                  tcp_data_count = sizeof(tcp_debug_buffer);
               tcp_rx_buffer_read(tcp_debug_server_handle, tcp_debug_buffer,
                                  &tcp_data_count, TCP_RX_BUFFER_READ_DATA);
               if (tcp_data_count)
                  tcp_data_count =
                     tcp_tx_buffer_write(tcp_debug_server_handle,
                                         tcp_debug_buffer, tcp_data_count,
                                         TCP_TX_BUFFER_WRITE_RAM_DATA);
            }
            else
               tcp_rx_buffer_clear(tcp_debug_server_handle);
         }
      }
      else
      {
         if (((!(p_struct->tcp_socket_status & SOCK_READY_CONNECT)) &&
              (p_struct->tcp_socket_status & SOCK_DISCONNECTED)) ||
             (p_struct->tcp_socket_error))
         {
            printf_P(PSTR("\"tcp_debug_server_handle\" close\n"));
            tcp_init_connection(tcp_debug_server_handle);
            tcp_debug_server_handle = TCP_WRONG_CONNECTIONS;
         }
      }
   }
}

void tcp_debug_help(void)
{
   printf_P(PSTR("\"tcp-info <number>\" - displays infos to TCP-Connection (example: \"tcp-info 0\")\n"));
   printf_P(PSTR("\"tcp-client <ip> <port>\" - open TCP-Client (example: \"tcp-client 172.16.50.3 9\")\n"));
   printf_P(PSTR("\"tcp-server <port>\" - open TCP-Server (example: \"tcp-server 9\")\n"));
   printf_P(PSTR("\"tcp-close\" - close Client and/or Server connections\n"));
#ifdef TCP_ALIVE_ACTIV_ENABLE
   printf_P(PSTR("\"tcp-alive <tcp-connection>\" - disable or enable TCP-Alive with 2000ms (example: \"tcp-alive 0\")\n"));
#endif
   printf_P(PSTR("\"tcp-isn <isn>\" - sets a new ISN (example: \"tcp-isn 0\")\n"));
}

void tcp_debug_do_cmd(unsigned char *command)
{
   unsigned char ip[4];
   unsigned int tcp_port = 0;
   TCP_STRUCTURE *p_struct;
   int data;

   if (strncmp_P(command, PSTR("help"), 4) == 0)
   {
      tcp_debug_help();
   }
   if (strncmp_P(command, PSTR("tcp-info"), 6) == 0)
   {
      data = debug_integer(command);
      if (data == -1)
         data = 0;
      tcp_debug_info(data);
   }
   if (strncmp_P(command, PSTR("tcp-client"), 7) == 0)
   {
      if (debug_string2ip(command, ip, &tcp_port) != 0)
      {
         if (tcp_port == 0)
            tcp_port = TCP_PORT_DISCARD;
         data = web_debug_flag;
         web_debug_flag |= WEB_DEBUG_TCP_BIT;
         tcp_debug_client_handle = tcp_active_open(ip, tcp_port, tcp_port);
         web_debug_flag = data; // resore web_debug_flag
      }
      else
         printf_P(PSTR("TCP-Client wrong parameter\n"));
   }
   if (strncmp_P(command, PSTR("tcp-server"), 5) == 0)
   {
      tcp_port = debug_integer(command);
      if (tcp_port == -1)
         tcp_port = TCP_PORT_DISCARD;
      data = web_debug_flag;
      web_debug_flag |= WEB_DEBUG_TCP_BIT;
      if (tcp_debug_server_handle != TCP_WRONG_CONNECTIONS)
      {
         tcp_abort(tcp_debug_server_handle);
         p_struct = tcp_get_struct(tcp_debug_server_handle);
         p_struct->tcp_flags &= ~TCP_FLAG_PASSIV;
      }
      tcp_debug_server_handle = tcp_passive_open(tcp_port);
      web_debug_flag = data;    // resore web_debug_flag
   }
   if (strncmp_P(command, PSTR("tcp-close"), 7) == 0)
   {
      data = web_debug_flag;
      web_debug_flag |= WEB_DEBUG_TCP_BIT;
      if (tcp_debug_client_handle != TCP_WRONG_CONNECTIONS)
      {
         printf_P(PSTR("TCP-Client close\n"));
         tcp_close(tcp_debug_client_handle);
         // tcp_debug_client_handle=TCP_WRONG_CONNECTIONS;
      }
      else if (tcp_debug_server_handle != TCP_WRONG_CONNECTIONS)
      {
         printf_P(PSTR("TCP-Server close\n"));
         tcp_close(tcp_debug_server_handle);
         // tcp_debug_server_handle=TCP_WRONG_CONNECTIONS;
      }
      else
         printf_P(PSTR("TCP-Client/Server nothing to close\n"));
      web_debug_flag = data;    // resore web_debug_flag
   }
   if (strncmp_P(command, PSTR("tcp-alive"), 5) == 0)
   {
#ifdef TCP_ALIVE_ACTIV_ENABLE
      data = debug_integer(command);
      if (data == -1)
         data = 0;
      if (tcp_get_struct(data))
      {
         tcp_alive_set_time(data, 40);
         if (tcp_struct[data].tcp_alive_flag)
         {
            tcp_alive_disable(data);
            printf_P(PSTR("TCP-Alive disable\n"));
         }
         else
         {
            tcp_alive_enable(data);
            printf_P(PSTR("TCP-Alive enable (2000ms)\n"));
         }
      }
      else
         printf_P(PSTR("TCP-Alive wrong TCP-Connection\n");
#else
      printf_P(PSTR("NO TCP-Alive enable\n"));
#endif
   }
   if (strncmp_P(command, PSTR("tcp-isn"), 6) == 0)
   {
      data = debug_integer(command);
      if (data == -1)
         data = 0xffff;
      tcp_isn_high_number = (unsigned int) data;
      printf_P(PSTR("tcp_isn_high_number: 0x%x\n"), tcp_isn_high_number);
   }
}
#endif // #ifdef WEB_DEBUG_TCP_OFFLINE
