
/*****************************************************************************
 *
 *                             "udp.c"
 *                   -----------------------------
 *
 *  Version:    2.04
 *  File:    	..\..\udp.c
 *  Created:    31.08.2002
 *  Date:       02.07.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	udp-send- and read functions
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *		2.) 08.01.2004 Version 2.03
 *		3.) 02.07.2004 Version 2.04
 *			a.)	- add IPSec Buffer size
 *
 *****************************************************************************/
#include "project.h"

#ifdef UDP_ENABLE

#include <stdio.h>
#ifndef __CODEVISIONAVR__
#include <string.h>
#include <avr/pgmspace.h>
#endif
#include HARDWARE_H_FILEPATH
#include DEVICE_H_FILEPATH
#include BUFFER_H_FILEPATH
#include ETHERNET_H_FILEPATH
#include UDP_H_FILEPATH
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
UDP_STRUCTURE udp_struct[UDP_MAX_CONNECTIONS];

#ifdef WEB_DEBUG_UDP
unsigned int udp_frame_count = 0;
#endif
#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void udp_prepare_data_frame(unsigned char udp_connection);

void udp_init(void)
{
   unsigned char Lva;

   memset(udp_struct, 0x0, sizeof(udp_struct));
   for (Lva = 0; Lva < UDP_MAX_CONNECTIONS; Lva++)
   {
      memset(udp_struct[Lva].udp_ip_remote, 0xff, IP_ADR_SIZE);
   }
}


UDP_STRUCTURE *udp_get_struct(unsigned char udp_connection)
{
   if ((udp_connection != UDP_WRONG_CONNECTIONS)
       && (udp_connection < UDP_MAX_CONNECTIONS))
      return &udp_struct[udp_connection];
   return 0x0;
}

unsigned char udp_open(unsigned int udp_local_port,
                       unsigned char *dest_mac_address,
                       unsigned char *dest_ip_address, unsigned int dest_port,
                       unsigned char udp_flag)
{
   unsigned char Lva;
   UDP_STRUCTURE *p_struct;

   p_struct = &udp_struct[0];
   for (Lva = 0; Lva < UDP_MAX_CONNECTIONS; Lva++)
   {
      if (!(p_struct->udp_flags & UDP_FLAG_OPEN))
      {
         p_struct->udp_flags = udp_flag | UDP_FLAG_OPEN | UDP_TX_BUF_FREE;
         p_struct->udp_port_local = udp_local_port;
         memset(p_struct->udp_mac_remote, 0xff, 6);
         memset(p_struct->udp_ip_remote, 0xff, IP_ADR_SIZE);
         if (udp_flag & UDP_FLAG_ACTIVE)
         {
            p_struct->udp_port_remote = dest_port;
#ifdef WEB_DEBUG_UDP
            if (web_debug_flag & WEB_DEBUG_UDP_BIT)
               printf_P(PSTR("UDP(%u,x) Active Open: %u\n"), Lva, udp_local_port);
#endif
            udp_bind(Lva, dest_mac_address, dest_ip_address);
         }
         else if (udp_flag & UDP_FLAG_PASSIV)
         {
#ifdef WEB_DEBUG_UDP
            if (web_debug_flag & WEB_DEBUG_UDP_BIT)
               printf_P(PSTR("UDP(%u,x) Passive Open: %u\n"), Lva, udp_local_port);
#endif
         }
         return Lva;
      }
      p_struct++;
   }
   return UDP_WRONG_CONNECTIONS;
}


void udp_close(unsigned char udp_connection)
{
   if (udp_get_struct(udp_connection))
      udp_struct[udp_connection].udp_flags &= UDP_DATA_AVAILABLE;
}

void udp_rx_buffer_release(unsigned char udp_connection)
{
   if (udp_get_struct(udp_connection))
      udp_struct[udp_connection].udp_flags &= ~UDP_DATA_AVAILABLE;
}

unsigned int udp_tx_buffer_prepare(unsigned char udp_connection,
                                   unsigned char *data, unsigned int datalen)
{
   UDP_STRUCTURE *p_struct;

   if (udp_get_struct(udp_connection))
   {
      p_struct = &udp_struct[udp_connection];
      if (p_struct->udp_flags & UDP_FLAG_OPEN)
      {
         if ((p_struct->udp_flags & UDP_TX_BUF_FREE) ||
             (p_struct->udp_flags & UDP_TX_BUF_HALF_FULL))
         {
            if (p_struct->udp_flags & UDP_TX_BUF_FREE)
            {
               p_struct->udp_tx_data_position =
                  &p_struct->udp_tx_frame[UDP_DATA_OFS];
               p_struct->udp_tx_data_count = 0;
            }
            if (datalen == 0)
            {
               datalen = UDP_TX_DATA_SIZE - p_struct->udp_tx_data_count;
               return datalen;
            }
            if (datalen > (UDP_TX_DATA_SIZE - p_struct->udp_tx_data_count))
               datalen = UDP_TX_DATA_SIZE - p_struct->udp_tx_data_count;
            if (data != 0x0)
            {
               memcpy(p_struct->udp_tx_data_position, data, datalen);
               p_struct->udp_tx_data_position += datalen;
            }
            p_struct->udp_tx_data_count += datalen;
            if (p_struct->udp_tx_data_count & 0x01)
               p_struct->udp_tx_frame[UDP_DATA_OFS +
                                      p_struct->udp_tx_data_count] = 0;
            p_struct->udp_flags &= ~UDP_TX_BUF_FREE;
            p_struct->udp_flags |= UDP_TX_BUF_FULL;
            if (p_struct->udp_tx_data_count < UDP_TX_DATA_SIZE)
               p_struct->udp_flags |= UDP_TX_BUF_HALF_FULL;
            return datalen;
         }
      }
   }
   return 0;
}


void udp_main(void)
{
   static unsigned char udp_connection = 0;
   unsigned char udp_connection_count = 0;
   UDP_STRUCTURE *p_struct;

   udp_connection_count = 0;
   while (udp_connection_count < UDP_MAX_CONNECTIONS)
   {
      udp_connection++;
      if (udp_connection >= UDP_MAX_CONNECTIONS)
         udp_connection = 0;
      p_struct = &udp_struct[udp_connection];
      if (p_struct->udp_flags & UDP_FLAG_OPEN)
         break;
      udp_connection_count++;
   }
   if (udp_connection_count >= UDP_MAX_CONNECTIONS)
      return;
   if (p_struct->udp_flags & UDP_FLAG_OPEN)
   {
      if ((p_struct->udp_flags & UDP_TX_BUF_FULL) &&
          (!(p_struct->udp_flags & UDP_DATA_AVAILABLE)))
         udp_prepare_data_frame(udp_connection);
   }
}


unsigned char udp_bind(unsigned char udp_connection,
                       unsigned char *dest_mac_address,
                       unsigned char *dest_ip_address)
{
   UDP_STRUCTURE *p_struct;

   if (udp_get_struct(udp_connection))
   {
      p_struct = &udp_struct[udp_connection];
      if (!(p_struct->udp_flags & UDP_FLAG_BIND))
      {
         if (dest_ip_address)
            memcpy(p_struct->udp_ip_remote, dest_ip_address, IP_ADR_SIZE);
#ifndef DEVICE_PPP
         if (dest_mac_address)
            memcpy(p_struct->udp_mac_remote, dest_mac_address, 6);
#endif
#ifdef WEB_DEBUG_UDP
         if (web_debug_flag & WEB_DEBUG_UDP_BIT)
         {
            printf_P(PSTR("UDP(%u,%u) Bind: %u<=>%u:"), udp_connection,
                   udp_frame_count, p_struct->udp_port_local,
                   p_struct->udp_port_remote);
            debug_print_ip(0x0, p_struct->udp_ip_remote);
         }
#endif
         p_struct->udp_flags |= UDP_FLAG_BIND;
         return 1;
      }
   }
   return 0;
}

void udp_unbind(unsigned char udp_connection)
{
   if (udp_get_struct(udp_connection))
      udp_struct[udp_connection].udp_flags &= ~UDP_FLAG_BIND;
}


void udp_process_frame(void)
{
   unsigned int udp_source_port;        // udp source port
   unsigned int udp_dest_port;
   unsigned int udp_data_count;
   unsigned char udp_connection;
   UDP_STRUCTURE *p_struct;

#ifdef WEB_DEBUG_UDP
   udp_frame_count++;
#endif
   udp_source_port = DEVICE_READ_IP_FRAME_16BIT();
   udp_dest_port = DEVICE_READ_IP_FRAME_16BIT();
   p_struct = &udp_struct[0];
   for (udp_connection = 0; udp_connection < UDP_MAX_CONNECTIONS;
        udp_connection++)
   {
      if (p_struct->udp_flags & UDP_FLAG_OPEN)
      {
         if (p_struct->udp_flags & UDP_FLAG_ACTIVE)
         {
            if ((udp_dest_port == p_struct->udp_port_local) &&
                (udp_source_port == p_struct->udp_port_remote) &&
                (!memcmp
                 (ip_of_last_frame, p_struct->udp_ip_remote, IP_ADR_SIZE)))
               break;
         }
         else if (p_struct->udp_flags & UDP_FLAG_PASSIV)
         {
            if (udp_dest_port == p_struct->udp_port_local)
            {
               if (p_struct->udp_flags & UDP_FLAG_BIND)
               {
                  p_struct->udp_port_remote = udp_source_port;

                  if (!memcmp
                      (ip_of_last_frame, p_struct->udp_ip_remote,
                       IP_ADR_SIZE))
                     break;
               }
               else
               {
                  if (p_struct->udp_port_remote != udp_source_port)
                  {

                     memcpy(p_struct->udp_ip_remote, ip_of_last_frame,
                            IP_ADR_SIZE);
                     p_struct->udp_port_remote = udp_source_port;
#ifndef DEVICE_PPP
                     memcpy(p_struct->udp_mac_remote, mac_of_last_frame, 6);
#endif
#ifdef WEB_DEBUG_UDP
                     if (web_debug_flag & WEB_DEBUG_UDP_BIT)
                     {
                        printf_P(PSTR("UDP(%u,%u) Open: %u=>%u "), udp_connection,
                               udp_frame_count, udp_source_port,
                               udp_dest_port);
                        debug_print_ip(PSTR(""), ip_of_last_frame);
                     }
#endif
                  }
                  break;
               }
            }
         }
      }
      p_struct++;
   }
   if (udp_connection >= UDP_MAX_CONNECTIONS)
   {
#ifdef WEB_DEBUG_UDP
      if (web_debug_flag & WEB_DEBUG_UDP_BIT)
      {
         static PROGMEM char KzNL[] = ")\n";
         static PROGMEM char Pu[] = "%u ";
         p_struct = &udp_struct[0];
         printf_P(PSTR("UDP(x,%u) Dest-Port: %u!=("), udp_frame_count, udp_dest_port);
         for (udp_connection = 0; udp_connection < UDP_MAX_CONNECTIONS;
              udp_connection++)
         {
            printf_P(Pu, p_struct->udp_port_local);
            p_struct++;
         }
         printf_P(KzNL);
         printf_P(PSTR("UDP(x,%u) IP: %u.%u.%u.%u != ("), udp_frame_count,
                ip_of_last_frame[0], ip_of_last_frame[1], ip_of_last_frame[2],
                ip_of_last_frame[3]);
         p_struct = &udp_struct[0];
         for (udp_connection = 0; udp_connection < UDP_MAX_CONNECTIONS;
              udp_connection++)
         {
            printf_P(PSTR("%u.%u.%u.%u "), p_struct->udp_ip_remote[0],
                   p_struct->udp_ip_remote[1], p_struct->udp_ip_remote[2],
                   p_struct->udp_ip_remote[3]);
            p_struct++;
         }
         printf_P(KzNL);
         p_struct = &udp_struct[0];
         printf_P(PSTR("UDP(x,%u) Source-Port: %u!=("), udp_frame_count,
                udp_source_port);
         for (udp_connection = 0; udp_connection < UDP_MAX_CONNECTIONS;
              udp_connection++)
         {
            printf_P(Pu, p_struct->udp_port_remote);
            p_struct++;
         }
         printf_P(KzNL);
      }
#endif
      return;
   }
   udp_data_count = DEVICE_READ_IP_FRAME_16BIT();
   udp_data_count -= UDP_HEADER_SIZE;
   if (udp_data_count > UDP_RX_DATA_SIZE)
   {
#ifdef WEB_DEBUG_UDP
      if (web_debug_flag & WEB_DEBUG_UDP_BIT)
         printf_P(PSTR("UDP(%u,%u) Frame too long: %u\n"), udp_connection,
                udp_frame_count, udp_data_count);
#endif
      udp_data_count = UDP_RX_DATA_SIZE;
      // return; // packet too large for us :...-(
   }
   DEVICE_READ_IP_FRAME_16BIT();
   if (!(p_struct->udp_flags & UDP_DATA_AVAILABLE))
   {
      DEVICE_READ_IP_FRAME_DATA(p_struct->udp_rx_frame, udp_data_count);
      p_struct->udp_rx_data_count = udp_data_count;
      p_struct->udp_flags |= UDP_DATA_AVAILABLE;
   }
   else
      DEVICE_READ_IP_FRAME_DUMMY(udp_data_count);
#ifdef WEB_DEBUG_UDP
   if (web_debug_flag & WEB_DEBUG_UDP_BIT)
      printf_P(PSTR("UDP(%u,%u) Read: %u=>%u (%u Byte)\n"), udp_connection,
             udp_frame_count, udp_source_port, udp_dest_port, udp_data_count);
#endif
}


void udp_prepare_data_frame(unsigned char udp_connection)
{
   UDP_STRUCTURE *p_struct;
   unsigned char ip_offset;

   p_struct = &udp_struct[udp_connection];
   HOST_NETWORK_ENDIAN_16BIT(&p_struct->udp_tx_frame[UDP_SRCPORT_OFS],
                             &p_struct->udp_port_local);
   HOST_NETWORK_ENDIAN_16BIT(&p_struct->udp_tx_frame[UDP_DESTPORT_OFS],
                             &p_struct->udp_port_remote);
   p_struct->udp_tx_all_count = UDP_HEADER_SIZE + p_struct->udp_tx_data_count;
   HOST_NETWORK_ENDIAN_16BIT(&p_struct->udp_tx_frame[UDP_LEN_OFS],
                             &p_struct->udp_tx_all_count);
   *(unsigned int *) &p_struct->udp_tx_frame[UDP_CHKSUM_OFS] = 0;
   p_struct->udp_tx_all_count += IP_HEADER_SIZE;
   if (ip_header_write
       (p_struct->udp_tx_frame, &p_struct->udp_tx_all_count, &ip_offset,
        IP_UDP_PROT, ip_address, p_struct->udp_ip_remote) == 0)
   {
#if defined(WEB_DEBUG_UDP)&&defined(IPSEC_ENABLE)
      if (web_debug_flag & WEB_DEBUG_UDP_BIT)
      {
         printf_P(PSTR("UDP(%u,%u) IP-Error\n"), udp_connection, udp_frame_count);
         web_debug_display_frame(p_struct->udp_tx_frame,
                                 p_struct->udp_tx_all_count + IPSEC_OFFSET +
                                 ETH_HEADER_SIZE, 0);
      }
#endif
      return;
   }
#ifdef ETHERNET_ENABLE
   memcpy(&p_struct->udp_tx_frame[(unsigned char) (ETH_DA_OFS + ip_offset)],
          p_struct->udp_mac_remote, 6);
   memcpy(&p_struct->udp_tx_frame[(unsigned char) (ETH_SA_OFS + ip_offset)],
          mac_address, 6);
   *(unsigned int *) &p_struct->
      udp_tx_frame[(unsigned char) (ETH_TYPE_OFS + ip_offset)] =
      SWAPB(IP_FRAME);
#else
   memset(&p_struct->udp_tx_frame[(unsigned char) (ETH_DA_OFS + ip_offset)],
          0x0, ETH_HEADER_SIZE);
#endif
   p_struct->udp_tx_all_count += ETH_HEADER_SIZE;
   if (buffer_write_command
       (p_struct->udp_tx_frame + ip_offset, p_struct->udp_tx_all_count))
   {
      p_struct->udp_flags &= ~(UDP_TX_BUF_FULL | UDP_TX_BUF_HALF_FULL);
      p_struct->udp_flags |= UDP_TX_BUF_FREE;
#ifdef WEB_DEBUG_UDP
      if (web_debug_flag & WEB_DEBUG_UDP_BIT)
      {
         printf_P(PSTR("UDP(%u,%u) Write: %u=>%u (%u Byte)\n"), udp_connection,
                udp_frame_count, p_struct->udp_port_local,
                p_struct->udp_port_remote, p_struct->udp_tx_data_count);
      }
#endif
   }
   else
   {
#ifdef WEB_DEBUG_UDP
      if (web_debug_flag & WEB_DEBUG_UDP_BIT)
      {
         printf_P(PSTR("UDP(%u,%u) ERROR Write Data:%u byte\n"), udp_connection,
                udp_frame_count, p_struct->udp_tx_data_count);
      }
#endif
   }
}


#ifdef WEB_DEBUG_UDP
void udp_display_flags(UDP_STRUCTURE * p_struct)
{
   if (p_struct->udp_flags & UDP_FLAG_OPEN)
      printf_P(PSTR(" OPEN"));
   else
      printf_P(PSTR(" CLOSE"));
   if (p_struct->udp_flags & UDP_FLAG_PASSIV)
      printf_P(PSTR(", PASSIV"));
   if (p_struct->udp_flags & UDP_FLAG_ACTIVE)
      printf(", ACTIVE"));
   if (p_struct->udp_flags & UDP_FLAG_BIND)
      printf_P(PSTR(", BIND"));
   if (p_struct->udp_flags & UDP_DATA_AVAILABLE)
      printf_P(PSTR(", DATA_AVAILABLE"));
   if (p_struct->udp_flags & UDP_TX_BUF_FREE)
      printf_P(PSTR(", TX_BUF_FREE"));
   if (p_struct->udp_flags & UDP_TX_BUF_HALF_FULL)
      printf_P(PSTR(", TX_BUF_HALF_FULL"));
   if (p_struct->udp_flags & UDP_TX_BUF_FULL)
      printf_P(PSTR(", TX_BUF_FULL"));
   printf_P(PSTR("\n"));
}


void udp_info(unsigned int port_number)
{
   unsigned char Lva, display_count = 0;
   UDP_STRUCTURE *p_struct;

   p_struct = &udp_struct[0];
   for (Lva = 0; Lva < UDP_MAX_CONNECTIONS; Lva++)
   {
      if ((port_number == 0) || (port_number == p_struct->udp_port_local))
      {
         display_count++;
         printf_P(PSTR("udp_connection: %u\n"), Lva);
         printf_P(PSTR(" flags      :"));
         udp_display_flags(p_struct);
         printf_P(PSTR(" port_local : %u\n"), p_struct->udp_port_local);
         printf_P(PSTR(" port_remote: %u\n"), p_struct->udp_port_remote);
         printf_P(PSTR(" ip_remote  : %u.%u.%u.%u\n"), p_struct->udp_ip_remote[0],
                p_struct->udp_ip_remote[1], p_struct->udp_ip_remote[2],
                p_struct->udp_ip_remote[3]);
         printf_P(PSTR(" tx_all_count: %u / tx_data_count: %u\n"),
                p_struct->udp_tx_all_count, p_struct->udp_tx_data_count);
         printf_P(PSTR(" tx_frame - H:%u D:%u\n"), UDP_ALL_HEADER_SIZE,
                UDP_TX_DATA_SIZE);
      }
      p_struct++;
   }
   if (display_count == 0)
      printf_P(PSTR("no UDP-Port: %u\n"), port_number);
}
#endif
#endif // #ifdef UDP_ENABLE
