
/*****************************************************************************
 *
 *                         "udp_client.c"
 *                   -----------------------------
 *
 *  Version:    2.09
 *  File:    	..\..\udp_client.c
 *  Created:    15.07.2002
 *  Date:       03.05.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	main-task for UDP sample
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 10.08.2004 Version 2.04
 *			a.)	-
 *
 *****************************************************************************/
#include "project.h"

#include <stdio.h>
#include <string.h>
#include <avr/wdt.h>
#include <avr/pgmspace.h>

#include SERVER_H_FILEPATH
#include ARP_RARP_H_FILEPATH
#include HARDWARE_H_FILEPATH
#include BUFFER_H_FILEPATH

#include UDP_H_FILEPATH
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char udp_client_server_ip[IP_ADR_SIZE] = IP_SERVER;
unsigned char udp_client_connection = UDP_WRONG_CONNECTIONS;
unsigned char udp_client_ok = 0;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif


unsigned char udp_client_send_message(void)
{
   static unsigned int udp_client_tx_count = 0;
   unsigned char udp_data[20];

   if (udp_client_ok)
   {
      sprintf_P(udp_data, PSTR("udp_client:%d"), udp_client_tx_count);
      if (udp_tx_buffer_prepare
          (udp_client_connection, udp_data, sizeof(udp_data)))
      {
         udp_client_tx_count++;
         return 1;
      }
   }
   return 0;
}

void udp_client_main(void)
{
   UDP_STRUCTURE *p_struct;

   if (udp_client_ok)
   {
      server_main();
      p_struct = udp_get_struct(udp_client_connection);
      if ((p_struct != 0) && (p_struct->udp_flags & UDP_DATA_AVAILABLE))
      {
         udp_client_send_message();
         udp_rx_buffer_release(udp_client_connection);
      }
   }
}

void udp_client_init(void)
{
   unsigned char c_delay = 200;
   unsigned char c_old;

   udp_client_ok = 0;
   server_init();
   if (server_ok)
   {
      arp_prepare_request(udp_client_server_ip, ARP_REQUEST_IP);
      memset(ip_of_last_frame, 0x0, IP_ADR_SIZE);
      c_old = (unsigned char) counter_10ms_16bit;
      while (1)
      {
#ifdef __CODEVISIONAVR__
#asm("wdr");
#else
         wdt_reset();
#endif
         ethernet_process();
         buffer_process();
         //idle();
         if (!memcmp(ip_of_last_frame, udp_client_server_ip, IP_ADR_SIZE))
         {
            // connect to Server-Port "UDP_CLIENT_PORT_SERVER" with
            // Client-Port "UDP_CLIENT_PORT_LOCAL"
            udp_client_connection =
               udp_open(UDP_CLIENT_PORT_LOCAL, mac_of_last_frame,
                        udp_client_server_ip, UDP_CLIENT_PORT_SERVER,
                        UDP_FLAG_ACTIVE);
            if (udp_client_connection == UDP_WRONG_CONNECTIONS)
            {
#ifdef WEB_DEBUG_UDP
               printf_P(PSTR("UDP Active Open Error (Port:%d)!!!!\n"),
                      UDP_CLIENT_PORT_SERVER);
#endif
               return;
            }
            udp_client_ok = 1;
            udp_client_send_message();
            return;
         }
         if (c_old != (unsigned char) counter_10ms_16bit)
         {
            c_old = (unsigned char) counter_10ms_16bit;
            if (c_delay > 0)
               c_delay--;
            else
               break;
         }
      }
   }
}
