
/*****************************************************************************
 *
 *                         "udp_server.c"
 *                   -----------------------------
 *
 *  Version:    2.04
 *  File:    	..\..\udp_server.c
 *  Created:    15.07.2002
 *  Date:       09.06.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	main-task for UDP sample
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 10.08.2004 Version 2.04
 *			a.)	-
 *
 *****************************************************************************/
#include "project.h"

#include <stdio.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>

#include HARDWARE_H_FILEPATH
#include BUFFER_H_FILEPATH
#include DEVICE_H_FILEPATH
#include ETHERNET_H_FILEPATH
#include UDP_H_FILEPATH
#include SERVER_H_FILEPATH
#include UDP_H_SERVER_FILEPATH


#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char udp_server_handle = UDP_WRONG_CONNECTIONS;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

unsigned char udp_server_send_message(unsigned char udp_connection)
{
   static unsigned int udp_server_tx_count = 0;
   unsigned char udp_data[20];

   sprintf_P(udp_data, PSTR("udp_server:%d"), udp_server_tx_count);
   if (udp_tx_buffer_prepare(udp_connection, udp_data, sizeof(udp_data)))
   {
      udp_server_tx_count++;
      return 1;
   }
   return 0;
}

void udp_server_main(void)
{
   UDP_STRUCTURE *p_struct;

   server_main();
   p_struct = udp_get_struct(udp_server_handle);
   if ((p_struct != 0) & (p_struct->udp_flags & UDP_DATA_AVAILABLE))
   {
#ifdef WEB_DEBUG_UDP
      debug_display_frame(p_struct->udp_rx_frame, p_struct->udp_rx_data_count, 0);
#endif
      udp_rx_buffer_release(udp_server_handle);
      udp_server_send_message(udp_server_handle);
   }
}

void udp_server_init(unsigned int port_number)
{
   server_init();
   udp_server_handle = udp_open(port_number, 0, 0, 0, UDP_FLAG_PASSIV);
   if (udp_server_handle == UDP_WRONG_CONNECTIONS)
   {
#ifdef WEB_DEBUG_UDP
      printf_P(PSTR("UDP(%u) Passiv Open Error!!!!\n"), port_number);
#endif
   }
}
