
/*****************************************************************************
 *
 *                        "web_debug.c"
 *                   -----------------------------
 *
 *  Version:    2.06
 *  File:    	..\source\..\web_debug.c
 *  Created:    23.04.2003
 *  Date:       21.01.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	Debug-functions for easyToWeb-Server
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 08.08.2003 Version 2.00
 *		2.) 08.08.2003 Version 2.01
 *			a.)	- function "web_debug_info(..)" supports now the macros "PROJECT_NAME",
 *				"PROJECT_VERSION" and "EASYTOWEB_VERSION"
 *		3.) 11.08.2003 Version 2.01
 *			a.)	- start of implementation of FTP-Server
 *		4.) 26.08.2003 Version 2.01
 *			a.)	- use now "cs8900_debug_do_cmd()" inside of "web_debug_command()"
 *		5.) 02.09.2003 Version 2.01
 *			a.)	- variable "web_debug_cmd" only visible inside of web_debug.c
 *			b.)	- variable "web_debug_flag" switch OFF all debug infos
 *			c.)	- function "web_debug_string2ip" and "web_debug_integer" with
 *                pointer to command-string;
 *		6.) 23.09.2003 Version 2.02
 *			a.)	- add debug functions for file system, see dataflash_file.c
 *		7.) 08.10.2003 Version 2.02
 *			a.)	- add debug functions for FTP functions, see ftp_server.c
 *		8.) 23.10.2003 Version 2.02
 *			a.)	- rename the terminal commands "ip-addr" to "ip", "gateway-addr" to "gateway" and
 *                "submask-addr" to "submask" ;
 *		9.) 11.11.2003 Version 2.02
 *			a.)	- disable the terminal command "endian"
 *			b.)	- new terminal command "help" and "time"
 *		10.) 19.11.2003 Version 2.03
 *			a.)	- function web_debug_command() has now a return value
 *                you can use the command-string for your own command-handler
 *		11.) 24.11.2003 Version 2.03
 *			a.)	- wrong commands inside of web_debug_do_cmd()
 *		12.) 02.12.2003 Version 2.03
 *			a.)	- the commands "ip", "gateway" and "submask" display the actual
 *                value, if use without parameter; example "ip" displays the actual ip-address
 *		13.) 26.02.2004 Version 2.03
 *			a.)	- web_debug_print_mac() prints MAC-Address to debug channel
 *		14.) 30.04.2004 Version 2.04
 *			a.)	- web_debug_ds2430_info() supports now the second DS2430A of eTW-AIO
 *			b.)	- rename web_debug_ds2430_info() to web_debug_1wire_info()
 *		15.) 21.01.2005 Version 2.06
 *			a.)	- divide the file web_debug.c in debug.c and web_debug.c
 *
 *****************************************************************************/
#include "project.h"

#ifdef WEB_DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef __CODEVISIONAVR__
#include <ds2430.h>
#include <sleep.h>
#else
//#include <avr/sleep.h>
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/wdt.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#endif

#include ICMP_H_FILEPATH
#include ARP_RARP_H_FILEPATH
#include BUFFER_H_FILEPATH

#include DEBUG_H_FILEPATH
#include IP_H_FILEPATH
#include WEB_DEBUG_H_FILEPATH
#include DEVICE_H_FILEPATH
//#ifdef WEB_DEBUG_CS8900
#include CS8900_DEBUG_H_FILEPATH
//#endif
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef TCP_ENABLE
#include TCP_H_FILEPATH
#endif
#ifdef WEB_DEBUG_ATI
#include ATI_DEBUG_H_FILEPATH
#endif
#ifdef WEB_DEBUG_PPP
#include PPP_DEBUG_H_FILEPATH
#endif
#ifdef WEB_DEBUG_TCP_OFFLINE
#include TCP_DEBUG_H_FILEPATH
#endif
#ifdef IP_ENABLE
#include IP_H_FILEPATH
#endif
#ifdef IPSEC_ENABLE
#include IPSEC_SA_DEBUG_H_FILEPATH
#endif
#ifdef DEBUG_DATAFLASH
#include DATAFLASH_DEBUG_H_FILEPATH
#endif
#ifdef DEBUG_DATAFLASH_FILE
#include DATAFLASH_FILE_DEBUG_H_FILEPATH
#endif
#ifdef FTP_ENABLE
#include FTP_SERVER_H_FILEPATH
#endif
#include UTIL_H_FILEPATH
#include HARDWARE_H_FILEPATH


#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned int web_debug_flag EEMEM = 0x0000;
unsigned int web_debug_flag_old EEMEM = 0xffff;

static PROGMEM char Con[] = " ON\n";
static PROGMEM char Coff[] = " OFF\n";

#ifdef __CODEVISIONAVR__
#pragma regalloc+

#pragma used+
#endif
void web_debug_do_cmd(unsigned char *command);
void web_debug_1wire_info(void);
void web_debug_display_addresses(void);

#ifdef __CODEVISIONAVR__
#pragma used-
#endif

void web_debug_init(void)
{
   debug_init();
}

unsigned char *web_debug_command(void)
{
   unsigned char *new_command = 0;

#ifdef DEBUG
   new_command = debug_get_command();
#endif
   if (new_command)
   {
      web_debug_do_cmd(new_command);
#ifdef WEB_DEBUG_ATI
      ati_debug_do_cmd(new_command);
#endif
#ifdef WEB_DEBUG_PPP
      ppp_debug_do_cmd(new_command);
#endif
#ifdef WEB_DEBUG_TCP_OFFLINE
      tcp_debug_do_cmd(new_command);
#endif
#ifdef DEBUG_DATAFLASH
      dataflash_debug_do_cmd(new_command);
#endif
#ifdef DEBUG_DATAFLASH_FILE
      dataflash_file_debug_do_cmd(new_command);
#endif
#ifdef WEB_DEBUG_CS8900
      cs8900_debug_do_cmd(new_command);
#endif
#ifdef WEB_DEBUG_FTP
      ftp_debug_do_cmd(new_command);
#endif
#if defined(IPSEC_ENABLE)&&defined(WEB_DEBUG_IPSEC)
      ipsec_sa_debug_do_cmd(new_command);
#endif
#ifdef WEB_DEBUG_BLUETOOTH
      bluetooth_debug_do_cmd(new_command);
#endif
   }
#ifdef WEB_DEBUG_TCP_OFFLINE
   tcp_debug_client_server();
#endif
   return new_command;
}

void web_debug_info(PGM_P info_string)
{
   debug_info(info_string);
   printf_P(PSTR("easyToWeb-Software: " EASYTOWEB_VERSION "\n"));
#ifdef DATAFLASH_ENABLE
#ifdef DEBUG_DATAFLASH
   dataflash_debug_info();
#endif
#endif
#ifdef DEVICE_CS8900
#ifdef WEB_DEBUG_CS8900
   cs8900_debug_info();
#endif
#endif
#ifndef DS2430_WRITE_PROM
   web_debug_1wire_info();
   web_debug_display_addresses();
#endif
   printf_P(PSTR("---- easyToWeb-Software ----\n"));
#ifdef DEVICE_PPP
   printf_P(PSTR("DEVICE_PPP\n"));
#endif
#ifdef DEVICE_3c509b
   printf_P(PSTR("DEVICE_3c509b\n"));
#endif
#ifdef DEVICE_CS8900
   printf_P(PSTR("DEVICE_CS8900\n"));
#endif
#ifdef CS8900_MEMORY
   printf_P(PSTR("CS8900_MEMORY\n"));
#endif
#ifdef CS8900_IO_PORT8
   printf_P(PSTR("CS8900_IO_PORT8\n"));
#endif
#ifdef CS8900_IO_PORT16
   printf_P(PSTR("CS8900_IO_PORT16\n"));
#endif
#ifdef CS8900_I2C_HW_8
   printf_PPSTR("CS8900_I2C_HW_8\n"));
#endif
#ifdef CS8900_I2C_HW_16
   printf_P(PSTR("CS8900_I2C_HW_16\n"));
#endif
#ifdef CS8900_I2C_SW_8
   prinf_P(PSTR("CS8900_I2C_SW_8\n"));
#endif
#ifdef CS8900_I2C_SW_16
   printf_P(PSTR("CS8900_I2C_SW_16\n"));
#endif
#ifdef ETHERNET_ENABLE
   printf_P(PSTR("ETHERNET_ENABLE\n"));
#endif
#ifdef ARP_ENABLE
   printf_P(PSTR("ARP_ENABLE\n"));
#endif
#ifdef IP_ENABLE
   printf_P(PSTR("IP_ENABLE\n"));
#endif
#ifdef IPSEC_ENABLE
   printf_P(PSTR("IPSEC_ENABLE\n"));
#endif
#ifdef ICMP_ENABLE
   printf_P(PSTR("ICMP_ENABLE\n"));
#endif
#ifdef UDP_ENABLE
   printf_P(PSTR("UDP_ENABLE\n"));
#endif
#ifdef BOOTP_ENABLE
   printf_P(PSTR("BOOTP_ENABLE\n"));
#endif
#ifdef TCP_ENABLE
   printf_P(PSTR("TCP_ENABLE\n"));
#endif
#ifdef HTTP_ENABLE
   printf_P(PSTR("HTTP_ENABLE\n"));
#endif
#ifdef FTP_ENABLE
   printf_P(PSTR("FTP_ENABLE\n"));
#endif
#ifdef DATAFLASH_ENABLE
   printf_P(PSTR("DATAFLASH_ENABLE\n"));
#endif
#ifdef DATAFLASH_FILE_ENABLE
   printf_P(PSTR("DATAFLASH_FILE_ENABLE\n"));
#endif
}


void web_debug_debug_info(void)
{
   printf_P(PSTR("---- easyToWeb-Software-Debug ----\n"));
#ifdef WEB_DEBUG
   printf_P(PSTR("WEB_DEBUG\n"));
#endif
#ifdef DEBUG_DATAFLASH
   printf_P(PSTR("DEBUG_DATAFLASH\n"));
#endif
#ifdef DEBUG_DATAFLASH_FILE
   printf("DEBUG_DATAFLASH_FILE");
   if (web_debug_flag & WEB_DEBUG_FILE_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_MEASURE
   printf_P(PSTR("WEB_DEBUG_MEASURE\n"));
#endif
#ifdef WEB_DEBUG_CS8900
   printf("WEB_DEBUG_CS8900");
   if (web_debug_flag & WEB_DEBUG_CS8900_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_ATI
   printf("WEB_DEBUG_ATI");
   if (web_debug_flag & WEB_DEBUG_ATI_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_PPP
   printf("WEB_DEBUG_PPP");
   if (web_debug_flag & WEB_DEBUG_PPP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_BUFFER
   printf("WEB_DEBUG_BUFFER");
   if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_ETHERNET
   printf("WEB_DEBUG_ETHERNET");
   if (web_debug_flag & WEB_DEBUG_ETHERNET_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_ARP
   printf("WEB_DEBUG_ARP");
   if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_RARP
   printf("WEB_DEBUG_RARP");
   if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_IP
   printf("WEB_DEBUG_IP");
   if (web_debug_flag & WEB_DEBUG_IP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_ICMP
   printf("WEB_DEBUG_ICMP");
   if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_TCP
   printf("WEB_DEBUG_TCP");
   if (web_debug_flag & WEB_DEBUG_TCP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_UDP
   printf("WEB_DEBUG_UDP");
   if (web_debug_flag & WEB_DEBUG_UDP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_BOOTP
   printf("WEB_DEBUG_BOOTP");
   if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_HTTP
   printf("WEB_DEBUG_HTTP");
   if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_FTP
   printf("WEB_DEBUG_FTP");
   if (web_debug_flag & WEB_DEBUG_FTP_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
#ifdef WEB_DEBUG_IPSEC
   printf("WEB_DEBUG_IPSEC");
   if (web_debug_flag & WEB_DEBUG_IPSEC_BIT)
      printf_P(Con);
   else
      printf_P(Coff);
#endif
}


void web_debug_1wire_info(void)
{
#if 0
   unsigned char Lva = 0, Lvb, dev_1wire, crc;
   unsigned char romcodes_1wire[MAX_1WIRE_DEVICES][9];

   dev_1wire = hardware_read_mac((char *)romcodes_1wire, 0x0, 0);
   if (dev_1wire)
   {
      printf_P(PSTR("%u-1WIRE-DEVICE:\n"), dev_1wire);
      while (Lva < dev_1wire)
      {
         if (romcodes_1wire[Lva][0] == DS2430_FAMILY_CODE)
         {
            crc = w1_dow_crc8(&romcodes_1wire[Lva][0], 7);
            if (crc == romcodes_1wire[Lva][7])
            {
               printf_P(PSTR("(%u)BIT07..00 - Family Code  : 0x%02x - DS2430A\n"),
                      Lva, romcodes_1wire[0][0]);
               printf_P(PSTR("(%u)BIT56..08 - Serial Number: 0x"), Lva);
               for (Lvb = 6; Lvb > 0; Lvb--)
                  printf_P(PSTR("%02x"), romcodes_1wire[Lva][Lvb]);
               printf_P(PSTR("\n"));
               printf_P(PSTR("(%u)BIT63..57 - CRC          : 0x%02x\n"), Lva,
                      romcodes_1wire[Lva][7]);
            }
            else
               printf_P(PSTR("(%u)CRC-Error: 0x%02x/0x%02x\n")), Lva,
                      romcodes_1wire[Lva][7], crc);
         }
         Lva++;
      }
   }
   else
      printf_P(PSTR("1-WIRE-DEVICE ERROR!!\n"));
#endif
}


void web_debug_display_addresses(void)
{
#ifdef DEVICE_CS8900
   if (hardware_read_CS8900_mac(0x0, 0x0, 0))
      printf_P(PSTR("MAC-Address from DS2430-PROM:\n"));
   else
      printf_P(PSTR("Default-MAC-Address:\n"));
   debug_print_mac(PSTR("MAC    "), mac_address);
#endif
#ifdef DEVICE_3c509b
   debug_print_mac(PSTR("MAC-address\nMAC    "), mac_address);
#endif
#ifdef IP_ENABLE
#ifdef BOOTP_ENABLE
   if (bootp_ok)
      printf_P(PSTR("BOOTP-Data:\n"));
   else
#ifdef ENABLE_EEPROM_ADDRESS
      printf_P(PSTR("IP, SUBMASK and GATEWAY from EEPROM:\n"));
#else
      printf_P(PSTR("Default-IP, -SUBMASK and -GATEWAY:\n"));
#endif
#else
#ifdef ENABLE_EEPROM_ADDRESS
   printf_P(PSTR("IP, SUBMASK and GATEWAY from EEPROM:\n"));
#else
   printf_P(PSTR("Default-IP, -SUBMASK and -GATEWAY:\n"));
#endif
#endif
   debug_print_ip(PSTR("IP     "), ip_address);
   debug_print_ip(PSTR("SUBMASK"), ip_subnet_mask);
   debug_print_ip(PSTR("GATEWAY"), ip_gateway);
#endif
}

unsigned char web_debug_switch(unsigned char *command)
{
   command = debug_search_parameter(command);
   if (command != 0x0)
   {
      if (strncmp_P(command, PSTR("clear"), 3) == 0)
      {
         printf_P(PSTR("WEB_DEBUG_xxxx ON\n"));
         web_debug_flag = 0xffff;
      }
      if (strncmp_P(command, PSTR("all"), 3) == 0)
      {
         if (web_debug_flag)
         {
            printf_P(PSTR("WEB_DEBUG_xxxx OFF\n"));
            web_debug_flag_old = web_debug_flag;
            web_debug_flag = 0x0;
         }
         else
         {
            printf_P(PSTR("WEB_DEBUG_xxxx ON\n"));
            web_debug_flag = web_debug_flag_old;
         }
      }
      if (strncmp_P(command, PSTR("cs8900"), 4) == 0)
      {
#ifdef WEB_DEBUG_CS8900
         web_debug_flag ^= WEB_DEBUG_CS8900_BIT;
         if (web_debug_flag & WEB_DEBUG_CS8900_BIT)
            printf_P(PSTR("WEB_DEBUG_CS8900 ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_CS8900 OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_CS8900\n"));
#endif
      }
      if (strncmp_P(command, PSTR("ati"), 3) == 0)
      {
#ifdef WEB_DEBUG_ATI
         web_debug_flag ^= WEB_DEBUG_ATI_BIT;
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("WEB_DEBUG_ATI ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_ATI OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_ATI\n"));
#endif
      }
      if (strncmp_P(command, PSTR("ppp"), 3) == 0)
      {
#ifdef WEB_DEBUG_PPP
         web_debug_flag ^= WEB_DEBUG_PPP_BIT;
         if (web_debug_flag & WEB_DEBUG_PPP_BIT)
            printf_P(PSTR("WEB_DEBUG_PPP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_PPP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_PPP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("buffer"), 4) == 0)
      {
#ifdef WEB_DEBUG_BUFFER
         web_debug_flag ^= WEB_DEBUG_BUFFER_BIT;
         if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
            printf_P(PSTR("WEB_DEBUG_BUFFER ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_BUFFER OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_BUFFER\n"));
#endif
      }
      if (strncmp_P(command, PSTR("ethernet"), 4) == 0)
      {
#ifdef WEB_DEBUG_ETHERNET
         web_debug_flag ^= WEB_DEBUG_ETHERNET_BIT;
         if (web_debug_flag & WEB_DEBUG_ETHERNET_BIT)
            printf_P(PSTR("WEB_DEBUG_ETHERNET ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_ETHERNET OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_ETHERNET\n"));
#endif
      }
      if ((strncmp_P(command, PSTR("arp"), 3) == 0)
          || (strncmp_P(command, PSTR("rarp"), 4) == 0))
      {
#if defined(WEB_DEBUG_ARP)||defined(WEB_DEBUG_RARP)
         web_debug_flag ^= WEB_DEBUG_ARP_RARP_BIT;
         if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
            printf_P(PSTR("WEB_DEBUG_ARP_RARP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_ARP_RARP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_ARP_RARP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("ipsec"), 5) == 0)
      {
#ifdef WEB_DEBUG_IPSEC
         web_debug_flag ^= WEB_DEBUG_IPSEC_BIT;
         if (web_debug_flag & WEB_DEBUG_IPSEC_BIT)
            printf_P(PSTR("WEB_DEBUG_IPSEC ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_IPSEC OFF\n"));
         return 1;
#else
         printf_P(PSTR("NO WEB_DEBUG_IPSEC\n"));
         return 1;
#endif
      }
      if (strncmp_P(command, PSTR("ip"), 2) == 0)
      {
#ifdef WEB_DEBUG_IP
         web_debug_flag ^= WEB_DEBUG_IP_BIT;
         if (web_debug_flag & WEB_DEBUG_IP_BIT)
            printf_P(PSTR("WEB_DEBUG_IP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_IP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_IP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("icmp"), 4) == 0)
      {
#ifdef WEB_DEBUG_ICMP
         web_debug_flag ^= WEB_DEBUG_ICMP_BIT;
         if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
            printf_P(PSTR("WEB_DEBUG_ICMP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_ICMP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_ICMP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("tcp"), 3) == 0)
      {
#ifdef WEB_DEBUG_TCP
         web_debug_flag ^= WEB_DEBUG_TCP_BIT;
         if (web_debug_flag & WEB_DEBUG_TCP_BIT)
            printf_P(PSTR("WEB_DEBUG_TCP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_TCP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_TCP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("udp"), 3) == 0)
      {
#ifdef WEB_DEBUG_UDP
         web_debug_flag ^= WEB_DEBUG_UDP_BIT;
         if (web_debug_flag & WEB_DEBUG_UDP_BIT)
            printf_P(PSTR("WEB_DEBUG_UDP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_UDP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_UDP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("bootp"), 3) == 0)
      {
#ifdef WEB_DEBUG_BOOTP
         web_debug_flag ^= WEB_DEBUG_BOOTP_BIT;
         if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
            printf_P(PSTR("WEB_DEBUG_BOOTP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_BOOTP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_BOOTP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("http"), 4) == 0)
      {
#ifdef WEB_DEBUG_HTTP
         web_debug_flag ^= WEB_DEBUG_HTTP_BIT;
         if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
            printf_P(PSTR("WEB_DEBUG_HTTP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_HTTP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_HTTP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("ftp"), 3) == 0)
      {
#ifdef WEB_DEBUG_FTP
         web_debug_flag ^= WEB_DEBUG_FTP_BIT;
         if (web_debug_flag & WEB_DEBUG_FTP_BIT)
            printf_P(PSTR("WEB_DEBUG_FTP ON\n"));
         else
            printf_P(PSTR("WEB_DEBUG_FTP OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_FTP\n"));
#endif
      }
      if (strncmp_P(command, PSTR("file"), 4) == 0)
      {
#ifdef DEBUG_DATAFLASH_FILE
         printf("WEB_DEBUG_FILE ");
         web_debug_flag ^= WEB_DEBUG_FILE_BIT;
         if (web_debug_flag & WEB_DEBUG_FILE_BIT)
            printf_P(PSTR("ON\n"));
         else
            printf_P(PSTR("OFF\n"));
#else
         printf_P(PSTR("NO WEB_DEBUG_FILE\n"));
#endif
      }
      return 1;
   }
   return 0;
}

void web_debug_help(void)
{
   printf_P(PSTR("\"info\" - all informations to the system (protocolls, debug)\n"));
   printf_P(PSTR("\"init\" - init the device (Ethernet, Modem)\n"));
   printf_P(PSTR
      ("\"debug <xxx>\" - enable/disable runtime debug (example: \"debug ip\")\n"));
#ifdef IP_ENABLE
   printf_P(PSTR
      ("\"ip <xxx.xxx.xxx.xxx>\" - new ip address (example: \"ip 172.16.50.169\")\n"));
   printf_P(PSTR
      ("\"submask <xxx.xxx.xxx.xxx>\" - new submask (example: \"ip 255.255.255.0\")\n"));
   printf_P(PSTR
      ("\"gateway <xxx.xxx.xxx.xxx>\" - new gateway address (example: \"ip 172.16.50.11\")\n"));
#endif
#ifdef WEB_DEBUG_MEASURE
   printf_P(PSTR("\"measure\" - display all measure data\n"));
#endif
#ifdef ICMP_ENABLE
   printf_P(PSTR
      ("\"ping <xxx.xxx.xxx.xxx>\" - send a ping (example: \"ping 172.16.50.11\")\n"));
#endif
#if defined(BOOTP_ENABLE)&& defined(WEB_DEBUG_BOOTP)
   printf_P(PSTR("\"bootp\" - displays the BootP infos\n"));
#endif
#if defined(UDP_ENABLE)&& defined(WEB_DEBUG_UDP)
   printf_P(PSTR("\"udp-info\" - displays the UDP infos\n"));
#endif
#if defined(ARP_ENABLE)&& defined(WEB_DEBUG_ARP)
   printf_P(PSTR("\"arp\" - starts a ARP Request (example: \"arp 172.16.50.11\")\n"));
#endif
#if defined(RARP_ENABLE)&& defined(WEB_DEBUG_RARP)
   printf_P(PSTR
      ("\"rarp\" - starts a RARP Request (example: \"rarp 00:50:c2:21:10:c0\")\n"));
#endif
}

void web_debug_time(void)
{
   unsigned long sec_buffer;
   unsigned char data;

   printf_P(PSTR("day : %u\n"), day_counter);
   cli();
   sec_buffer = second_counter;
   sei();
   data = (unsigned char) (sec_buffer / 3600);
   printf_P(PSTR("time: %02u:"), data);
   sec_buffer -= (unsigned long) data *3600;

   data = (unsigned char) (sec_buffer / 60);
   printf_P(PSTR("%02u:"), data);
   sec_buffer -= (unsigned int) data *60;

   printf_P(PSTR("%02u\n"), (unsigned char) sec_buffer);
}


#ifdef ICMP_ENABLE
void web_debug_ping(unsigned char *ip)
{
   unsigned char c_delay = 200;
   unsigned char c_old;

#ifdef ARP_ENABLE
   arp_prepare_request(ip, ARP_REQUEST_IP);
   memset(ip_of_last_frame, 0x0, IP_ADR_SIZE);
#endif
   c_old = (unsigned char) counter_10ms_16bit;
   while (1)
   {
#ifdef __CODEVISIONAVR__
#asm("wdr");
#else
      wdt_reset();
#endif
#ifdef DEVICE_PPP
      ppp_main();
      if (DEVICE_READ_READY())
      {
#ifdef IP_ENABLE
         ip_process_frame(0);
#endif
         ppp_data_clear();
      }
#else
      ethernet_process();
      buffer_process();
#endif
#ifdef __CODEVISIONAVR__
      idle();
#endif
#ifdef ETHERNET_ENABLE
      if (!memcmp(ip_of_last_frame, ip, IP_ADR_SIZE))
      {
         icmp_prepare_echo_request(ip, mac_of_last_frame, 0xae);
         return;
      }
#else
      icmp_prepare_echo_request(ip, 0, 0xae);
#endif
      if (c_old != (unsigned char) counter_10ms_16bit)
      {
         c_old = (unsigned char) counter_10ms_16bit;
         if (c_delay > 0)
            c_delay--;
         else
            break;
      }
   }
}
#endif

void web_debug_do_cmd(unsigned char *command)
{
#ifdef IP_ENABLE
   unsigned char ip[4];
#endif
#if defined(UDP_ENABLE)&& defined(WEB_DEBUG_UDP)
   unsigned int data;
#endif

   if (strncmp_P(command, PSTR("info"), 4) == 0)
   {
      web_debug_info(0x00);
      return;
   }
   if (strncmp_P(command, PSTR("init"), 4) == 0)
   {
      DEVICE_INIT();
      return;
   }
   if (strncmp_P(command, PSTR("debug"), 5) == 0)
   {
      if (web_debug_switch(command))
         return;
      web_debug_debug_info();
   }
   if (strncmp_P(command, PSTR("help"), 4) == 0)
   {
      web_debug_help();
      return;
   }
   if (strncmp_P(command, PSTR("time"), 4) == 0)
   {
      web_debug_time();
      return;
   }
#ifdef IP_ENABLE
   if (strncmp_P(command, PSTR("ip"), 2) == 0)
   {
      if (debug_string2ip(command, ip, 0x0) != 0)
      {
         debug_print_ip(PSTR("old IP"), ip_address);
         memcpy(ip_address, ip, sizeof(ip_address));
         debug_print_ip(PSTR("new IP"), ip_address);
#ifdef ENABLE_EEPROM_ADDRESS
         debug_print_ip_ee(PSTR("old eeprom IP"), eeprom_ip);
         memcpy2e(eeprom_ip, ip, sizeof(eeprom_ip));
         debug_print_ip_ee(PSTR("new eeprom IP"), eeprom_ip);
#endif
      }
      else
         debug_print_ip(PSTR("IP"), ip_address);
      return;
   }
   if (strncmp_P(command, PSTR("submask"), 7) == 0)
   {
      if (debug_string2ip(command, ip, 0x0) != 0)
      {
         debug_print_ip(PSTR("old SUBMASK"), ip_subnet_mask);
         memcpy(ip_subnet_mask, ip, sizeof(ip_subnet_mask));
         debug_print_ip(PSTR("new SUBMASK"), ip_subnet_mask);
#ifdef ENABLE_EEPROM_ADDRESS
         debug_print_ip_ee(PSTR("old eeprom SUBMASK"), eeprom_submask);
         memcpy2e(eeprom_submask, ip, sizeof(eeprom_submask));
         debug_print_ip_ee(PSTR("new eeprom SUBMASK"), eeprom_submask);
#endif
      }
      else
         debug_print_ip(PSTR("SUBMASK"), ip_subnet_mask);
      return;
   }
   if (strncmp_P(command, PSTR("gateway"), 7) == 0)
   {
      if (debug_string2ip(command, ip, 0x0) != 0)
      {
         debug_print_ip(PSTR("old GATEWAY"), ip_gateway);
         memcpy(ip_gateway, ip, sizeof(ip_gateway));
         debug_print_ip(PSTR("new GATEWAY"), ip_gateway);
#ifdef ENABLE_EEPROM_ADDRESS
         debug_print_ip_ee(PSTR("old eeprom GATEWAY"), eeprom_gateway);
         memcpy2e(eeprom_gateway, ip, sizeof(eeprom_gateway));
         debug_print_ip_ee(PSTR("new eeprom GATEWAY"), eeprom_gateway);
#endif
      }
      else
         debug_print_ip(PSTR("GATEWAY"), ip_gateway);
      return;
   }
#endif
#ifdef WEB_DEBUG_MEASURE
   if (strncmp_P(command, PSTR("measure"), 5) == 0)
   {
      measure_diplay();
      return;
   }
#endif
#ifdef ICMP_ENABLE
   if (strncmp_P(command, PSTR("ping"), 4) == 0)
   {
      if (debug_string2ip(command, ip, 0x0) != 0)
      {
         if ((web_debug_flag & WEB_DEBUG_ICMP_BIT) == 0)
            printf_P(PSTR
               ("enable icmp-debug with \"debug icmp\" to display the data\n"));
         web_debug_ping(ip);
      }
   }
#endif
#if defined(BOOTP_ENABLE)&& defined(WEB_DEBUG_BOOTP)
   if (strncmp_P(command, PSTR("bootp"), 5) == 0)
   {
      bootp_display();
   }
#endif
#if defined(UDP_ENABLE)&& defined(WEB_DEBUG_UDP)
   if (strncmp_P(command, PSTR("udp-info"), 5) == 0)
   {
      data = debug_integer(command);
      if (data == -1)
         data = 0;
      if (data >= UDP_MAX_CONNECTIONS)
         data = (UDP_MAX_CONNECTIONS - 1);
      udp_info(data);
   }
#endif
#if defined(ARP_ENABLE)&& defined(WEB_DEBUG_ARP)
   if (strncmp_P(command, PSTR("arp"), 3) == 0)
   {
      if (debug_string2ip(command, ip, 0x0) != 0)
      {
         if ((web_debug_flag & WEB_DEBUG_ARP_RARP_BIT) == 0)
            printf_P(PSTR
               ("enable arp-debug with \"debug arp\" to display the data\n"));
         arp_prepare_request(ip, ARP_REQUEST_IP);
      }
   }
#endif
#if defined(RARP_ENABLE)&& defined(WEB_DEBUG_RARP)
   if (strncmp_P(command, PSTR("rarp"), 4) == 0)
   {
      if ((web_debug_flag & WEB_DEBUG_ARP_RARP_BIT) == 0)
         printf_P(PSTR("enable rarp-debug with \"debug rarp\" to display the data\n"));
      rarp_prepare_request();
   }
#endif
}

#endif
