/*
 * DS18B20.c
 *
 *  Created on: 17.11.2011
 *      Author: cyblord
 */

#include <avr/io.h>
#include <compat/deprecated.h>
#include <util/delay.h>
#include <stdlib.h>
#include <string.h>
#include "ow.h"

#define DS_CMD_TEMP	0x44
#define DS_CMD_READ	0xBE

int16_t DS18B20_getRawTemp() {
	ow_reset();
	ow_write(OW_SKIP);
	ow_write(DS_CMD_TEMP);
	_delay_ms(1500);
	ow_reset();
	ow_write(OW_SKIP);
	ow_write(DS_CMD_READ);
	return ow_read_word();
}


void DS18B20_getTempAsText(int16_t t,char *s) {
	char tmp[10];
	int16_t t1=t/16;
	int16_t t2=abs(t % 16);
	t2*=10;
	t2/=16;

	itoa(t1,s,10);

	strcat(s,",");

	itoa(t2,tmp,10);
	strcat(s,tmp);
	tmp[0]=(char)223;
	tmp[1]='C';
	tmp[2]='\0';
	strcat(s,tmp);
}

