/*
 * main.c
 *
 *  Created on: 15.11.2011
 *      Author: cyblord
 */

#include <avr/io.h>
#include <compat/deprecated.h>
#include <util/delay.h>
#include <util/crc16.h>
#include <stdlib.h>
#include "lcd.h"
#include "ow.h"
#include "DS18B20.h"

#define DEVICE_COUNT	1
#define SCREEN_DELAY	4000

typedef uint8_t (*Device)(uint8_t familyCode);

Device devices[DEVICE_COUNT];

typedef struct ROM {
	uint8_t family;
	uint32_t serial_lo;
	uint16_t serial_hi;
	uint8_t crc;
} ROM;

char text[8];



void init() {
	sbi(DDRB,PB0);

	lcd_init();
	ow_init();
}

uint8_t readRom(ROM* rom) {
	ow_reset();
	ow_write(OW_READ);
	uint8_t crc=0;

	rom->family=ow_read_byte();
	crc=_crc_ibutton_update(crc,rom->family);

	rom->serial_lo=ow_read_long();
	crc=_crc_ibutton_update(crc,rom->serial_lo);
	crc=_crc_ibutton_update(crc,rom->serial_lo>>8);
	crc=_crc_ibutton_update(crc,rom->serial_lo>>16);
	crc=_crc_ibutton_update(crc,rom->serial_lo>>24);

	rom->serial_hi=ow_read_word();
	crc=_crc_ibutton_update(crc,rom->serial_hi);
	crc=_crc_ibutton_update(crc,rom->serial_hi>>8);

	rom->crc=ow_read_byte();
	crc=_crc_ibutton_update(crc,rom->crc);

	return crc==0;
}

void printHex(uint32_t x) {
	ultoa(x,text,16);
	lcd_print(text);
}

uint8_t DS18B20(uint8_t family) {
	if (family!=0x28) return 0;
	lcd_cprint("Device:");
	lcd_goto(2,0);
	lcd_print("DS18B20");
	int16_t temp=DS18B20_getRawTemp();
	_delay_ms(SCREEN_DELAY);
	lcd_cprint("Temp:");

	DS18B20_getTempAsText(temp,text);
	lcd_goto(2,0);
	lcd_print(text);
	lcd_print("     ");
	_delay_ms(SCREEN_DELAY*2);
	return 1;
}


int main() {
	init();

	devices[0]=DS18B20;

	ROM r;
	_delay_ms(1000);
	lcd_cprint("1Wire");
	lcd_goto(2,0);
	lcd_print("Display");
	_delay_ms(1000);


	while(1) {
		uint8_t ok;
		lcd_cprint("Ready..");
		do {
			ok=readRom(&r);
		}while(!ok);

		lcd_cprint("Family:");
		lcd_goto(2,0);
		lcd_print("0x");
		printHex(r.family);
		_delay_ms(SCREEN_DELAY);
		lcd_cprint("S:0x");
		printHex(r.serial_hi);
		lcd_goto(2,0);
		printHex(r.serial_lo);
		_delay_ms(SCREEN_DELAY);

		for (int i=0;i<DEVICE_COUNT;i++) {
			if (devices[i](r.family)>0) break;
		}
	}

	return 0;
}
