/*
 * ow.c
 *
 *  Created on: 28.10.2011
 *      Author: cyblord
 */

#include <avr/io.h>
#include <compat/deprecated.h>
#include "ow.h"
#include <util/delay.h>

#define wait_reset() (_delay_us(500));
#define wait_recovery() (_delay_us(2));
#define wait_write1() (_delay_us(5));
#define wait_write0() (_delay_us(80));

#define IS_OW() (bit_is_set(OW_PIN,OW))


void ow_rel() {
	sbi(OW_OUT,OW);
	cbi(OW_DIR,OW);
}

void ow_lo() {
	cbi(OW_OUT,OW);
	sbi(OW_DIR,OW);
}



void ow_init() {
	ow_rel();
}


void ow_reset() {
	ow_lo();
	wait_reset();
	ow_rel();
	wait_reset();
}


void ow_write(uint8_t data) {
	for (int i=0;i<8;i++) {
		if ((data & 1)>0) { // send 1
			ow_lo();
			wait_write1();
			ow_rel();
			wait_write0();
		}else { // send 0
			ow_lo();
			wait_write0();
			ow_rel();
		}
		data>>=1;
		wait_recovery();
	}
}


uint8_t ow_read_byte() {
	uint8_t result=0;
	for (int i=0;i<8;i++) {
		result>>=1;
		ow_lo();
		wait_recovery();
		ow_rel();
		_delay_us(8);
		//Sample
		if (IS_OW()) result |= 128;
		wait_write0();
	}
	return result;
}

uint16_t ow_read_word() {
	uint8_t b1=ow_read_byte();
	uint8_t b2=ow_read_byte();
	uint16_t result=b2;
	result<<=8;
	result+=b1;
	return result;
}

uint32_t ow_read_long() {
	uint16_t w1=ow_read_word();
	uint16_t w2=ow_read_word();
	uint32_t result=w2;
	result<<=16;
	result+=w1;
	return result;
}
