;
;
;
;   AVR-Video V4
;   Jan Baare 10.02.2005
;
;
;
;Serielles ASCII-Video Terminalprogramm fr ATMEGA-8 und Fernsehgert
; - 24 Zeilen zu je 28 Zeichen
; - PAL-kompatibles BAS Videosignal
; - Betrieb an jedem SW- oder Farbfernsehgert mit
;   Video-IN bzw. BAS-IN Anschluss oder ber SCART
; - RS-232 Eingang mit TTL-Pegel
; - einstellbare Baudrate bis 19800 Baud
; - 7-Bit ASCII Zeichensatz
; - Steuerzeichen CR, LF, FF
; - Cursorpositionierung, Scrollen
;
; - Luft auf dem ATMEGA-8 mit dem internen 8MHz RC-Oscillator.
; - keine externen Bauteile ausser drei Widerstnden
;   zur Pegelanpassung des Videosignales.
;
;Dieses Programm muss in den ATMEGA-8 geflasht werden.
;Es muss die Fuse-Einstellung 8MHZ int.RC-Clk gewhlt werden.
;
;An PortB0 (Pin14) einen Widerstand mit 560 Ohm anschliesen
;An POrtD6 (Pin12) einen Widerstand mit 1200 Ohm anschliessen
;AN GND (Pin8) einen Widerstand mit 100 Ohm anschliessen
;die freien Enden dieser drei Widerstnde verbinden ergibt das Video Signal.
;
;Der RSR232 Eingang wird an Rxd (Pin2) mit TTL-Pegel angeschlossen.
;Der RSR232 Ausgang TxD wird nicht benutzt.
;
;Die Baudrate kann ber drei Jumper an PortD2-4 (Pin4,5,6) eingestellt werden.
;Wenn nichts angeschlossen wird (Pins offen),ist 9600 Baud eingestellt.
;Die gewhlte Baudrate wird nach dem Einschalten bernommen,
;und wird auf dem Bldschirm angezeigt.
;Es werden die Parameter 8 Bits, 1 Stopbit, no Parity verwendet.
;
;Baudrateneinstellung:

;Pin 6 5 4  Baud
;---------------
;    1 1 1  9600
;    1 1 0 19800
;    1 0 1  4800
;    1 0 0  2400
;    0 1 1  1200
;    0 1 0   300
;    0 0 1   110
;    0 0 0  9600
;
;
;
;Folgende Steuerzeichen knnen genutzt werden:
;
;Zeichen Taste  Code-HEX  Code-DEZ  Funktion
;--------------------------------------------
; CR     Ctrl-J    0D        13     Cursor auf Anfang der Zeile setzen
; LF     Ctrl-M    0A        10     Cursor eine Zeile tiefer setzen
; FF     Ctrl-L    0C        12     Bildschirm lschen
; SO     Ctrl-N    0E        14     Cursor auf Spalte X setzen.
;                                   X ist das nchste Zeichen und muss kleiner 28dez sein
; SI     Ctrl-O    0F        15     Cursor auf Zeile Y setzen.
;                                   Y ist das nchste Zeichen und muss kleiner 24dez sein
;
;
;
;Dieses Programm ist ein reines Experiment
;Benutzung erfolgt auf eigene Gefahr
;Ich bernehme keine Gewhr fr Funktion oder mgliche Schden
;
;Alle Rechte vorbehalten. Jan Baare 10.02.2005
;
;

.LISTMAC

.NOLIST
.INCLUDE <m8def.inc>
.LIST

.DEF zero     = R3   ;0
.DEF ssreg    = R4   ;Save Satus Reg
.DEF t0rlv    = R5   ;Timer0 Reload Value
.DEF curpl    = R6   ;Cursorpos. in Charbuf
.DEF curph    = R7   ;
.DEF xlsi     = R8   ;XI(Interrupt) Save
.DEF xhsi     = R9  
.DEF ticks    = R10  ;15625 Hz Ticker
.DEF ibupw    = R11  ;Input Buffer Pointer Write
.DEF ibupr    = R12  ;dito Read
.DEF curbuf   = R13  ;Cursor Buffer


.DEF mpa      = R16  ;Akku A
.DEF mpb      = R17  ;     B
.DEF mpc      = R18  ;     C
.DEF zz       = R19  ;Zeilenzhler
.DEF fz       = R20  ;Framezhler
.DEF scroll   = R21  ;Scroll Flag / Count
.DEF clrs     = R22  ;CLS Flag /Count
.DEF posc     = R23  ;Position Char


.EQU hsyt  = 9       ;Horizontal Sync Time
.EQU vsyl  = 2       ;Vertical Sync Lines
.EQU cpl   = 28      ;Chars per line
.EQu txtl  = 24      ;text lines
.EQU poeql = 2       ;Post Vsync Equalizing Lines
.EQU ubll  = 30      ;upper blank lines
.EQU lbll  = 14      ;lower blank lines
.EQU ssv   = 24      ;Schwarzschulter vorne
.EQU ndatl = 4       ;Buffer Transfer Lines
.EQU CBSize= cpl*txtl;Charbufsize


.DSEG
;.ORG 0x60
Charbuf: .byte CBSize  ;ASCII Zeichenspeicher
        
Framebuf:.byte cpl * 7 ;Framebuffer fr 7 Bildzeilen

inbuf:   .byte 64      ;Eingangsuffer fr RSR232




;Horizontal-Sync, damit startet jede Zeile
;wird alle 64us per Timer0-Int aufgerufen
;erzeugt das H-Sync Signal
;Startet den 64us Timer neu
;Holt, falls ntig, ein neues Zeichen vom USART
;   und legt es im Input-Buffer ab
.macro hsync        
          nop                ;Laufzeitausgleich
          nop                 
          nop                 
          out tcnt0,t0rlv    ;Timer neu starten
          cbi portd,6        ;Syncsignal Lo setzen
          in ssreg,SREG      ;Statusreg retten
          mov curph,XH         ;X retten
          mov curpl,XL
       
          ldi mpb,hsyt       ;normale Hsynczeit
          in mpa,UCSRA       ;USART Status
          andi mpa,0x80      ;Neuer Char da ?
          breq hsync1        ;Nee -> HOP
          in mpa,UDR         ;USART Data
          ldi XH,HIGH(inbuf) ;X auf Start Input Buffer
          ldi XL, LOW(inbuf) 
          add XL,ibupw       ;Write-Pointer dazu
          adc XH,zero
          st X,mpa           ;neuen Char ablegen
          inc ibupw          ;Pointer weitersetzen
          ldi mpa,0x3f       ;Pointer wraparound
          and ibupw,mpa
          subi mpb,4         ;Zeit ausgleich fr Hsync 
          nop                ;  falls neuer Char da war
          nop
hsync1:   mov XH,xhsi        ;Restore X
          mov XL,xlsi
hsync2:   dec mpb            ;Restliche HSync-Zeit vertrdeln
          brne hsync2
          sbi portd,6        ;Syncsignal wieder auf HI
.endmacro                    ;Ende Hsync




;Ende der Interruptverarbeitung
;wird von den Zeilen-Subs angesprungen
;muss vor dem nchsten Timer-Int erreicht werden 
.macro endint
          mov xhsi,XH        ;Tausche X
          mov xlsi,XL
          mov XH,curph
          mov XL,curpl
          out SREG,ssreg     ;Restore StatusReg
          reti               ;und ab nach Hause
.endmacro




;Schiebt die Videodaten 
;   fr ein Zeichen aus Portb0 raus
.macro shiftout
        ld mpb,X+            ;Char holen
        out portb,mpb        ;lsb ausgeben
        lsr mpb        
        out portb,mpb        ;nchstes Pixel
        lsr mpb    
        out portb,mpb
        lsr mpb
        out portb,mpb
        lsr mpb    
        out portb,mpb        ;bit 6 ausgeben
        cbi portb,0          ;VideoSignal wieder auf lo
.endmacro




.CSEG
    
;Interrupt Vector Table
        rjmp RESET           ;Reset Handler
        rjmp RESET           ;EXT_INT0 ; IRQ0 Handler
        rjmp RESET           ;EXT_INT1 ; IRQ1 Handler
        rjmp RESET           ;TIM2_COMP ; Timer2 Compare Handler
        rjmp RESET           ;TIM2_OVF ; Timer2 Overflow Handler
        rjmp RESET           ;TIM1_CAPT ; Timer1 Capture Handler
        rjmp RESET           ;TIM1_COMPA ; Timer1 CompareA Handler
        rjmp RESET           ;TIM1_COMPB ; Timer1 CompareB Handler
        rjmp RESET           ;TIM1_OVF ; Timer1 Overflow Handler
        ijmp                 ;TIM0_OVF ; Timer0 Overflow Handler
        rjmp RESET           ;SPI_STC ; SPI Transfer Complete Handler
        rjmp RESET           ;USART_RXC ; USART RX Complete Handler
        rjmp RESET           ;USART_UDRE ; UDR Empty Handler
        rjmp RESET           ;USART_TXC ; USART TX Complete Handler
        rjmp RESET           ;ADC_CC ; ADC Conversion Complete Handler
        rjmp RESET           ;EE_RDY ; EEPROM Ready Handler
        rjmp RESET           ;ANA_COMP ; Analog Comparator Handler
        rjmp RESET           ;TWSI ; Two-wire Serial Interface Handler
        rjmp RESET           ;SPM_RDY ; Store Program Memory Ready Handler



;Jetzt gehts los
RESET:  ldi mpa,0xA2         ;Calibration Byte
        out osccal,mpa       ;  fr RC-Oscillator
        ldi mpa,high(RAMEND) ;SP setzen
        out SPH,mpa
        ldi mpa,low(RAMEND)
        out SPL,mpa


;Init IO-Ports
        ldi mpa,0           
        mov zero,mpa
        ldi mpa,1
        out ddrb,mpa         ;PortB0 Output, B1-B7 Input
        out portb,mpa
        ldi mpa,0            ;PortC 0-7 Input
        out portc,mpa
        ldi mpa,0x40         ;PortD6 Output, D0-D5 und D7 Input
        out ddrd,mpa
        ldi mpa,0xff         ;Pullups einschalten
        out portb,mpa  
        out portc,mpa
        out portd,mpa
        cbi portd,6          ;Video Out auf LO, Sync Out bleibt HI


;Zeichenspeicher mit Leerzeichen fllen
        ldi XH,HIGH(Charbuf)
        ldi XL, LOW(Charbuf)
        ldi mpc,' '
        ldi mpa,4
ldtst1: ldi mpb,168
ldtst2: st X+,mpc
        dec mpb
        brne ldtst2
        dec mpa
        brne ldtst1


;Begrungstext eintragen
        ldi ZH,HIGH(Initxt<<1)
        ldi ZL, LOW(Initxt<<1)
        ldi XH,HIGH(Charbuf)
        ldi XL, LOW(Charbuf)
        ldi mpb,84
inil1:  lpm mpc,Z+
        st X+,mpc
        dec mpb
        brne inil1


;RSR232 Input Buffer lschen
        ldi XH,HIGH(inbuf)
        ldi XL, LOW(inbuf)
        ldi mpa,64
inbufc: st X+,zero
        dec mpa
        brne inbufc


;Init USART
;Baudratenjumper einlesen und auswerten
;  und Baudrate anzeigen
        ;IO-Port lesen,
        ;Baudratenwerte aus Tabelle holen 
        in mpa,PIND
        andi mpa,0b00011100  ;nur die Bits 2-4 interessieren
        lsl mpa              ;Tabellenzeile ist 8 Bytes lang
        ldi ZH,HIGH(Baudtab<<1) ;auf Anfang der Tabelle
        ldi ZL, LOW(Baudtab<<1)
        add ZL,mpa           ;Baudratennr. mal acht dazu
        adc ZH,zero
        lpm mpa,Z+           ;Baudratenwerte fr USART holen
        lpm mpb,Z+
        ;USART Baudrate setzen
        out UBRRH,mpb
        out UBRRL,mpa
        ;Baudrate auf Screen anzeigen
        ldi XH,HIGH(Charbuf+56);Position auf Bildschirm
        ldi XL, LOW(Charbuf+56)
        ldi mpb,6            ;6 Zeichen
baudl:  lpm mpa,Z+           ;  holen
        st X+,mpa            ;  und im Charbuffer speichern
        dec mpb
        brne baudl           
        ;USART einstellen und starten
        ldi mpa,0x10         ;Receiver enable
        out UCSRB,mpa
        ldi mpa,0x86         ;8-Bit, 1 Stopbit, no Parity
        out UCSRC,mpa


;Init TIMER0 und starten
        ldi mpa,2
        out tccr0,mpa        ;timer 0 vorteiler auf clk/8
        ldi mpa,0-63         ;timer0 reload value 63us
        mov t0rlv,mpa        ;wird noch fter gebraucht
        out tcnt0,t0rlv
        in mpa,timsk         ;Timer interrupt mask
        ori mpa,1 
        out timsk,mpa        ;timer 0 interrupt enable


;Register vorbelegen / lschen
        clr ibupr
        clr ibupw
        ldi mpa,' '
        mov curbuf,mpa
        ldi XH,HIGH(Charbuf) 
        ldi XL, LOW(Charbuf) 
        mov curph,XH             
        mov curpl,XL
        clr scroll          ;kein Scrollen
        clr clrs            ;kein Cls
        clr posc            ;keine CursorPos Sequenz aktiv
        ldi ZH,HIGH(vsync1) ;Starten mit VSync-Zeilen
        ldi ZL, LOW(vsync1)
        ldi zz,vsyl         ;Anzahl Zeilen

        sei                 ;Int Enable - Feuer frei
         


;Das Hauptprogamm
;Okay, ist nicht viel, aber schn bersichtlich
mloop:  nop
        rjmp mloop
;Ende Hauptprogramm 
;was sonst noch zu tun ist, luft im Interrupt 


;Baudratenwerte fr USART
;  und Texte fr Anzeige
Baudtab:
 .DB 0x33,0x00," 9600 "   ;000  
 .DB 0xc0,0x11,"  110 "   ;001  
 .DB 0x82,0x06,"  300 "   ;010   
 .DB 0xa0,0x01," 1200 "   ;011  
 .DB 0xcf,0x00," 2400 "   ;100 
 .DB 0x67,0x00," 4800 "   ;101   
 .DB 0x19,0x00,"19200 "   ;110 
 .DB 0x33,0x00," 9600 "   ;111  


;Begrssungstext
Initxt:
 .DB " AVR Videoterminal V4 JB0205"
 .DB "                            "
 .DB "      Baud 8N1              "
 



;Vertical Sync
;damit fngt jedes Bild an
vsync1: hsync                ;Erstmal HSync
        cbi portd,6          ;Ok, gibt 'nen Glitch, egal
                             ;  aber so knnen wir den Hsync-Macro nutzen
        ;1/2 Zeile minus HSync-Zeit abwarten 
        ldi mpa,60        
vs1a:   dec mpa
        brne vs1a
        ;inv. Hsync-Impuls auf 1/2 Vsync-Zeile
        sbi portd,6          ;Sync auf HI
        ldi mpa,12           ;4,75us
vs1b:   dec mpa
        brne vs1b
        cbi portd,6          ;Sync auf LO
        ldi mpa,71           ;  fr den Rest der Zeile
vs1c:   dec mpa
        brne vs1c
        sbi portd,6          ;Sync zurck auf HI
        dec zz               ;noch mehr Vsync-Zeilen ?
        brne vs1d            ;  ja
        ldi ZH,HIGH(poeq)    ;danach kommen die
        ldi ZL,LOW(poeq)     ;  hinteren Ausgleichs-Zeilen
        ldi zz,poeql         ;Anzahl setzen
vs1d:   endint               ;und ab nach Hause



;Leerzeilen mit den Ausgleichsimpulsen
poeq:   hsync                ;Erstmal Hsync
        ldi mpa,72           ;1/2 Zeile abwarten
poeqb:  dec mpa 
        brne poeqb
        ;Hsync Impuls auf 1/2 Zeile
        cbi portd,6          ;Sync auf LO
        ldi mpa,12
poeqc:  dec mpa
        brne poeqc          
        sbi portd,6          ;Sync zuck auf HI

        dec zz               ;noch mehr Zeilen ?
        brne poeqd           ;ja
        ldi ZH,HIGH(leero)   ;danach kommen Leerzeilen
        ldi ZL,LOW(leero)
        ldi zz,ubll          ;Anzahl setzen
        inc ticks            ;15625Hz Ticker
poeqd:  endint               ;das wars



;Obere Leerzeilen
;Hier ist der Terminalprogrammteil mit
;untergebracht, weil hier viel Zeit brig ist
leero:  hsync                ;Immer zuerst Sync
        rcall term           ;Terminalteil ausfhren

leeroa: dec zz               ;noch mehr Leerzeilen ?
        brne leerob          ;  ja
        ldi ZH,HIGH(datl1)   ;als nchstes kommen 
        ldi ZL, LOW(datl1)   ;   Framebuffer-Fllzeilen
        ldi zz,ndatl         ;Anzahl Zeilen
        ldi fz,txtl          ;Anzahl Frames (Terminal-Zeilen)
        ldi YH,HIGH(Charbuf) ;Init Character-Bufferpointer
        ldi YL, LOW(Charbuf)
        ldi XH,HIGH(Framebuf);Init Frame-Bufferpointer
        ldi XL, LOW(Framebuf)
leerob: endint               ;und Tschss



;Untere Leerzeilen
leeru:  hsync                ;erst HSync
        nop                  ;Laufzeitausgleich
        nop
        rcall term           ;Terminalteil ausfhren
        dec zz               ;noch mehr Zeilen ?
        brne leerua          ;  ja
        ldi ZH,HIGH(vsync1)  ;Bild Ende
        ldi ZL,LOW(vsync1)   ;  jetzt kommt der nchste VSync
        ldi zz,vsyl          ;Anzahl Vsync Zeilen
leerua: endint               ;Das ging doch schnell



;Framebuffer-Fllzeilen liegen zwischen den Zeichen-Zeilen
;  hier werden die Zeichen fr die nchste Charline 
;  aus dem Character-Buffer geholt, und ber den
;  Character-Generator in Pixel-Daten umgesetzt,und im
;  Framebuffer fr die nchsten sieben Zeilen bereitgestellt.
datl1:  hsync                ;jaja, erstmal Hsync
        ldi mpb,cpl/ndatl    ;Zeichen pro Framebuffer
datl1b: ldi ZH,HIGH(Chargen<<1) ;Pointer auf Start
        ldi ZL, LOW(Chargen<<1) ;  Charactergenerator
        ld r0,Y+             ;ein ASCII-Char      
        ldi mpa,8            ;8 Byte pro Zeichen
        mul r0,mpa       
        add ZL,r0            ;Offset auf Pointer
        adc ZH,r1

        lpm mpa,Z+           ;erste Pixelzeile des Char
        st X,mpa             ;  in Framebuffer setzen
        subi XL,0-cpl        ;nchste Pixelzeile kommt in 
                             ;  zweite Screen-Zeile des Framebuf
        lpm mpa,Z+           ;zweite Pixelzeile
        st X,mpa             ;  in zweite Screen-Zeile FB
        subi XL,0-cpl
        lpm mpa,Z+
        st X,mpa
        subi XL,0-cpl
        lpm mpa,Z+
        st X,mpa
        subi XL,0-cpl
        lpm mpa,Z+
        st X,mpa
        subi XL,0-cpl
        lpm mpa,Z+
        st X,mpa
        subi XL,0-cpl
        lpm mpa,Z+           ;siebte Pixelzeile
        st X,mpa 
        subi XL,cpl*6-1      ;Framebuffer-Pointer auf nchste 
                             ;  Char Position in erster Screen-Zeile
        dec mpb              ;Framebuffer voll ?
        brne datl1b          ;  nee

        ldi ZH,HIGH(datl1)   ;wir sind in den Dat-Lines
        ldi ZL, LOW(datl1)   ;  das ist verlorengegangen
        dec zz               ;noch mehr davon ?
        brne datl1c          ;  ja
        ldi ZH,HIGH(line1)   ;Jetzt kommen Zeichen-Zeilen
        ldi ZL, LOW(line1)
        ldi zz,7             ;7 Stck
        ldi XH,HIGH(Framebuf);Init FrameBuffer-Pointer
        ldi XL, LOW(Framebuf)
datl1c: endint               ;das wars fr diesen Interrupt



;Zeichen Zeilen, hier werden 7 Pixelreihen fr eine Screen-Zeile
;aus dem Framebuffer geholt und so schnell wie mglich aus dem
;portB0 rausgeschoben. Das ist die eigentliche Video-Darstellung
line1:  hsync                ;Auch hier: erst HSync
        ;Schwarzschulter abwarten
        ldi mpa,ssv 
line1b: dec mpa
        brne line1b
        ;Pixeldaten fr 28 Chars rausschieben
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout
        shiftout

        dec zz               ;7 Zeilen fertig ?
        brne line1d          ;  nee
        dec fz               ;waren das alle Frames ?
        brne line1c          ;  nee, da kommen noch mehr
        ldi ZH,HIGH(leeru)  ;Ok, dann machen wir weiter
        ldi ZL, LOW(leeru)  ;  mit den unteren Leerzeilen
        ldi zz,lbll          ;Anzahl Leerzeilen
        endint               ;Zurck
        ;noch ein Frame, also vorher neue Pixel bereitstellen
line1c: ldi ZH,HIGH(datl1)   ;das machen wir mit Dat-Lines
        ldi ZL, LOW(datl1)
        ldi zz,ndatl         ;Anzahl Dat-Lines
        ldi XH,HIGH(Framebuf);Framebufferpointer auf Start
        ldi XL, LOW(Framebuf)
line1d: endint               ;Schnell weg - Zeit wird knapp




;Der Terminalprogrammteil
term:   ori clrs,0           ;sind wir am Bildschirm-Lschen ?
        brne clrscr          ;  ja
        cpi scroll,1         ;sind wir am Scrollen ?
        brlo charw           ;  nee
        breq scrlpb          ;letzte Scrollzeile, also neue Leerzeile
        ;Scrollen
        mov XH,curph         ;akt. Cursorposition im Charbuffer
        mov XL,curpl
        st X,curbuf          ;Restore Char auf Cursorposition
        dec scroll           ;nchste Scroll-Portion
        ldi mpa,12           ;gescrollt wird von unten nach oben
        sub mpa,scroll       ;  also mit letzter Zeile anfangen
        ldi mpb,28 * 2       ;eine Portion = zwei Zeilen
        mul mpb,mpa          ;akt. Portion mal Portionsgrsse
                             ;   = Scroll-Startposition im Buffer
        ldi YH,HIGH(Charbuf) ;Anfang Buffer
        ldi YL, LOW(Charbuf)  
        ldi XH,HIGH(Charbuf+28);Anfang zweite Zeile
        ldi XL, LOW(Charbuf+28)
        add YL,r0            ;plus Scrollstartposition
        adc YH,r1
        add XL,r0            ;auch plus Scrollstart
        adc XH,r1
        ldi mpb,28 * 2       ;scrolle 56 Zeichen also 2 Zeilen
scrlp:  ld mpa,X+            
        st Y+,mpa
        dec mpb
        brne scrlp           ;fertig
        
scrlpa: mov XH,curph         ;X wieder auf akt. Cursorpos.
        mov XL,curpl
        ;Cursor blinken lassen
        ldi mpa,'_'
        sbrc ticks,4         ;ca. 2Hz
        ldi mpa,' '
        st X,mpa
        ret          ;zurck zum INT-Handler


        ;letzte Zeile auf Bildschirm lschen
scrlpb: clr scroll           ;Scrollen ist fertig
        ldi YH,HIGH(Charbuf+cbsize-28);Pointer auf letzte Zeile
        ldi YL, LOW(Charbuf+cbsize-28);  im Character Buffer 
        ldi mpb,28           ;28 Zeichen lschen
        ldi mpa,' '          ;Lschen = Leerzeichen eintragen 
        mov curbuf,mpa       ;akt. Cursorpos lchen
scrlpc: st Y+,mpa            ;ein Zeichen lschen
        dec mpb
        brne scrlpc
        rjmp scrlpa          ;fertig


;Bildschirm lschen (zweizeilenweise)
clrscr: ldi mpb,28 * 2       ;zwei Zeilen
        dec clrs             ;nchstes Mal die nchsten zwei Zeilen
        mul mpb,clrs         ;errechen Offset zum Lschen
        
        ldi YH,HIGH(Charbuf) ;Start Zeichenspeicher
        ldi YL, LOW(Charbuf)
        mov curph,YH         ;   wird neue Cursorposition
        mov curpl,YL         ;      nach dem lschen
        add YL,r0            ;Start + Offset   
        adc YH,r1
        ldi mpa,' '          ;Lschen = Leerzeichen eintragen
        ldi mpb,28 * 2       ;zwei Zeilen lschen
clrlp:  st Y+,mpa            ;lschen
        dec mpb
        brne clrlp
        mov curbuf,mpa       ;Cursorbuffer auch lschen
        ;Cursor blinken lassen
        ldi mpa,'_'
        sbrc ticks,4         ;ca. 2 Hz
        ldi mpa,' '
        st X,mpa             ;auf akt. Cursorposition
        ret                  ;zurck um INT-Handler



;nchstes Zeichen aus Input Buffer holen
;(wenn noch eins da ist)
charw:  mov XH,curph         ;Pointer in Charbuf
        mov XL,curpl         ;  schon mal vorsorglich holen
        ldi YH,HIGH(inbuf)   ;RSR232-Input Buffer   
        ldi YL, LOW(inbuf) 
        add YL,ibupr         ;Bufferpointer-Read    
        adc YH,zero
        ld mpa,Y             ;Bufferinhalt lesen
        ori mpa,0            ;Char da ?
        breq charwb          ;  Nein
        ;ja, da ist eins
        ldi mpb,0     
        st Y,mpb             ;Platz im Buffer lschen 
        inc ibupr            ;Bufferpointer weitersetzen
        ldi mpb,0x3f        
        and ibupr,mpb        ;Bufferpointer wraparound


       ;Char auswerten
        cpi posc,'X'         ;sind wir in einer X-Cursorpos-Sequenz ?
        breq charXPz         ;  ja
        cpi posc,'Y'         ;sind wir in einer Y-Cursorpos-Sequenz ?
        breq charYPa         ;  ja

        andi mpa,0x7f        ;nur 7-Bit Ascii !!
        cpi mpa,0x0c         ;ist es FF ?
        breq char0c          ;Ja
        cpi mpa,0x0a         ;ist es LF ?
        breq char0a
        cpi mpa,0x0d         ;ist es CR ?
        breq char0d
        cpi mpa,0x0e         ;ist es SO Ctrl-N ?
        breq charYP
        cpi mpa,0x0f         ;ist es SI Ctrl-O ?
        breq charXP

        ;Es ist ein darstellbares Zeichen
        st X+,mpa           ;ab in den Zeichenspeicher damit
        ;sind wir em Bildschirmende ?
charwa: cpi XH,HIGH(Charbuf+cbsize)
        brlo charwc          ; nein sicher nicht
        cpi XL,LOW(Charbuf+cbsize)
        brlo charwc          ; nein
        ;ja, dann mssen wir scrollen
        ldi scroll,13        ;12 mal 2 Zeilen scrollen + Leerzeile
        ldi XH,HIGH(Charbuf+CBSize-28) ;neue Cursorposition wird 
        ldi XL, LOW(Charbuf+CBSize-28) ;  Anfang letzte Zeile sein

charwc: ld curbuf,X          ;save Char auf Cursorposition
        ;Cursoe blinken lassen
charwb: ldi mpa,'_'          ;--abwechselnd Unterstrich
        sbrc ticks,4         ;ca. 2Hz Blinkfrequenz
        ldi mpa,' '          ;--oder Leerzeichen
        st X,mpa             ;in den Zeichenspeicher auf Cursorpos.
        mov curph,XH
        mov curpl,XL
        ret          ;Zurck zum INT-Handler


;LF Cursor eine Zeile tiefer setzen
char0a: st X,curbuf          ;Restore Char auf akt. Cursorpos
        cpi XH,HIGH(Charbuf+cbsize-28);schon in der letzten Zeile ?
        brlo char0aa         ;  nein
        cpi XL,LOW(Charbuf+cbsize-28)
        brlo char0aa         ;  nein
        ldi scroll,13        ;  ja, dann scrollen
        rjmp charwb 
char0aa:adiw XH:XL,28        ;akt.Position + ZeichenproZeile
                             ;  = eine Zeile tiefer
        rjmp charwa                  



;CR Cursor auf Anfang der Zeile setzen
char0d: st X,curbuf          ;Restore Char auf akt. Cursorpos
        sbiw XH:XL,Charbuf/2 ;Berechne abs. Cursorpos im Buffer 
        sbiw XH:XL,Charbuf/2 ;  also ohne Mem-Offset
        mov mpb,XH
        mov mpc,XL
        ;berechne die atk. Cursor-Spalten Nr. 
char0da:sbiw XH:XL,28        ;Primitive Methode um den Rest
        brcc char0da         ;   von Division / 28 zu erhalten
        subi XL,0-28         ;     egal, hier ist Zeit genug
        clr XH
        sub mpc,XL           ;Cursorspaltennr. von 
        sbci mpb,0           ;   Cursorposition abziehen
        mov XH,mpb           ;   ergibt Cursor auf Anfang Zeile
        mov XL,mpc
        adiw XH:XL,Charbuf/2 ;Und den Speicher-Offset wieder dazu
        adiw XH:XL,Charbuf/2
        rjmp charwa          ;fertig



;FF Bildschirm-Lschen auslsen
char0c: ldi clrs,12          ;12 * 2 Zeilen lschen
        rjmp charwb



charxpz: rjmp charXPa        ;Zwischenstation



;Cursorpositionierungssequenz Y starten
charYP: ldi posc,'Y'
        rjmp charwb

charYPa:clr posc             ;Ende Corsorpos. Sequenz
        cpi mpa,24           ;neue Cursorposition > 24
        brsh charwb          ;  ja -> vergiss es!
        st X,curbuf          ;Restore Char auf Cursorpos
        ;berechne die akt. Cursor-Spalten Nr. 
        sbiw XH:XL,Charbuf/2 ;Berechne abs. Cursorpos im Buffer  
        sbiw XH:XL,Charbuf/2 ;  ohne Mem-Offset
charYPb:sbiw XH:XL,28        ;und nochmal die simple Division
        brcc charYPb         ;   weil sie so gut klappt
        subi XL,0-28         ;   ...bevor ich nachdenke...
        clr XH              
        ldi mpb,28           ;Anzahl Zeichen pro Zeile
        mul mpa,mpb          ;  mal neue Zeilennr.
        add XL,r0            ;    plus Spaltennr.
        adc XH,r1            
        adiw XH:XL,Charbuf/2 ;und noch dem MEM-Offset
        adiw XH:XL,Charbuf/2 
        rjmp charwc          ;schon haben wir die neue Cursorpos.



;Cursorpositionierungssequenz X starten
charXP: ldi posc,'X'
        rjmp charwb

;Cursor auf Spalte mpa setzen
charXPa:clr posc             ;Ende Corsorpos. Sequenz
        cpi mpa,28           ;neue Cursorposition > 28 ?
        brsh charwb          ;  ja -> nicht mit mir!
        st X,curbuf          ;Restore Char auf aktueller Cursorpos
        ;berechne die Startadresse der Zeile wo der Cursor drin steht 
        sbiw XH:XL,Charbuf/2 ;Berechne abs. Cursorpos im Buffer
        sbiw XH:XL,Charbuf/2 ;  ohne Mem-Offset
        mov mpb,XH           ;sichern
        mov mpc,XL
charXPb:sbiw XH:XL,28        ;Jaja, wieder die ALDI-Division
        brcc charXPb          
        subi XL,0-28          
        clr XH                 
        sub mpc,XL            
        sbci mpb,0
        ;neue X-Position auf Startadresse draufaddieren
        add mpc,mpa          ;neue xpos
        adc mpb,zero
        mov XH,mpb
        mov XL,mpc
        adiw XH:XL,Charbuf/2 ;MEM-Offset wieder drauf
        adiw XH:XL,Charbuf/2
        rjmp charwc          ;Cursor steht auf neuer Position



Chargen:   ;Charactergenerator

 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;  00
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x28,0x43,0x29,0x20,0x4a,0x41,0x4e,0x20  ;
 .DB 0x42,0x41,0x41,0x52,0x45,0x20,0x31,0x30  ;
 .DB 0x2e,0x30,0x32,0x2e,0x32,0x30,0x30,0x35  ;
 .DB 0x20,0x35,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
 .DB 0x0f,0x14,0x14,0x0c,0x14,0x15,0x0e,0x00  ;
  
 .DB 0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f  ;  10
 .DB 0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x00  ;
 .DB 0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00  ;
 .DB 0x1b,0x1b,0x1b,0x00,0x00,0x00,0x00,0x00  ;
 .DB 0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x00  ;
 .DB 0x03,0x03,0x03,0x00,0x03,0x03,0x03,0x00  ;
 .DB 0x18,0x18,0x18,0x00,0x03,0x03,0x03,0x00  ;
 .DB 0x1b,0x1b,0x1b,0x00,0x03,0x03,0x03,0x00  ;
 .DB 0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x00  ;
 .DB 0x03,0x03,0x03,0x00,0x18,0x18,0x18,0x00  ;
 .DB 0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00  ;
 .DB 0x1b,0x1b,0x1b,0x00,0x18,0x18,0x18,0x00  ;
 .DB 0x00,0x00,0x00,0x00,0x1b,0x1b,0x1b,0x00  ;
 .DB 0x03,0x03,0x03,0x00,0x1b,0x1b,0x1b,0x00  ;
 .DB 0x18,0x18,0x18,0x00,0x1b,0x1b,0x1b,0x00  ;
 .DB 0x1b,0x1b,0x1b,0x00,0x1b,0x1b,0x1b,0x00  ;
 
 .DB 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  ;  20
 .DB 0x04,0x04,0x04,0x04,0x00,0x00,0x04,0x00  ;!
 .DB 0x0a,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00  ;"
 .DB 0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0x00  ;#
 .DB 0x04,0x1e,0x05,0x0e,0x14,0x0f,0x04,0x00  ;$
 .DB 0x03,0x13,0x08,0x04,0x02,0x19,0x18,0x00  ;%
 .DB 0x06,0x09,0x05,0x02,0x15,0x09,0x16,0x00  ;&
 .DB 0x06,0x04,0x02,0x00,0x00,0x00,0x00,0x00  ;'
 .DB 0x08,0x04,0x02,0x02,0x02,0x04,0x08,0x00  ;(
 .DB 0x02,0x04,0x08,0x08,0x08,0x04,0x02,0x00  ;)
 .DB 0x00,0x04,0x15,0x0e,0x15,0x04,0x00,0x00  ;*
 .DB 0x00,0x04,0x04,0x1f,0x04,0x04,0x00,0x00  ;+
 .DB 0x00,0x00,0x00,0x00,0x06,0x04,0x02,0x00  ;,
 .DB 0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00  ;-
 .DB 0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x00  ;.
 .DB 0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00  ;/

 .DB 0x0e,0x11,0x19,0x15,0x13,0x11,0x0e,0x00  ;0  30
 .DB 0x04,0x06,0x04,0x04,0x04,0x04,0x0e,0x00  ;1
 .DB 0x0e,0x11,0x10,0x08,0x04,0x02,0x1f,0x00  ;2
 .DB 0x1f,0x08,0x04,0x08,0x10,0x11,0x0e,0x00  ;3
 .DB 0x08,0x0c,0x0a,0x09,0x1f,0x08,0x08,0x00  ;4
 .DB 0x1f,0x01,0x0f,0x10,0x10,0x11,0x0e,0x00  ;5
 .DB 0x0c,0x02,0x01,0x0f,0x11,0x11,0x0e,0x00  ;6
 .DB 0x1f,0x10,0x08,0x04,0x02,0x02,0x02,0x00  ;7
 .DB 0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00  ;8
 .DB 0x0e,0x11,0x11,0x1e,0x10,0x08,0x06,0x00  ;9
 .DB 0x00,0x06,0x06,0x00,0x06,0x06,0x00,0x00  ;:
 .DB 0x00,0x06,0x06,0x00,0x06,0x04,0x02,0x00  ;;
 .DB 0x08,0x04,0x02,0x01,0x02,0x04,0x08,0x00  ;<
 .DB 0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,0x00  ;=
 .DB 0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00  ;>
 .DB 0x0e,0x11,0x10,0x08,0x04,0x00,0x04,0x00  ;?

 .DB 0x0e,0x11,0x10,0x16,0x15,0x15,0x0e,0x00  ;@  40
 .DB 0x0e,0x11,0x11,0x11,0x1f,0x11,0x11,0x00  ;A
 .DB 0x0f,0x11,0x11,0x0F,0x11,0x11,0x0F,0x00  ;B
 .DB 0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00  ;C
 .DB 0x07,0x09,0x11,0x11,0x11,0x09,0x07,0x00  ;D
 .DB 0x1f,0x01,0x01,0x0f,0x01,0x01,0x1f,0x00  ;E
 .DB 0x1f,0x01,0x01,0x0F,0x01,0x01,0x01,0x00  ;F
 .DB 0x0e,0x11,0x01,0x1d,0x11,0x11,0x1e,0x00  ;G
 .DB 0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00  ;H
 .DB 0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00  ;I
 .DB 0x1c,0x08,0x08,0x08,0x08,0x09,0x06,0x00  ;J
 .DB 0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00  ;K
 .DB 0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00  ;L
 .DB 0x11,0x1b,0x15,0x15,0x11,0x11,0x11,0x00  ;M
 .DB 0x11,0x11,0x13,0x15,0x19,0x11,0x11,0x00  ;N
 .DB 0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00  ;O

 .DB 0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00  ;P  50
 .DB 0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00  ;Q
 .DB 0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00  ;R
 .DB 0x1e,0x01,0x01,0x0e,0x10,0x10,0x0f,0x00  ;S
 .DB 0x1f,0x04,0x04,0x04,0x04,0x04,0x04,0x00  ;T
 .DB 0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00  ;U
 .DB 0x11,0x11,0x11,0x11,0x11,0x0a,0x04,0x00  ;V
 .DB 0x11,0x11,0x11,0x15,0x15,0x15,0x0a,0x00  ;W
 .DB 0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00  ;X
 .DB 0x11,0x11,0x11,0x0a,0x04,0x04,0x04,0x00  ;Y
 .DB 0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00  ;Z
 .DB 0x07,0x01,0x01,0x01,0x01,0x01,0x07,0x00  ;[
 .DB 0x11,0x0a,0x1f,0x04,0x1f,0x04,0x04,0x00  ;
 .DB 0x0e,0x08,0x08,0x08,0x08,0x08,0x0e,0x00  ;]
 .DB 0x04,0x0a,0x11,0x00,0x00,0x00,0x00,0x00  ;^
 .DB 0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00  ;_
 
 .DB 0x02,0x04,0x08,0x00,0x00,0x00,0x00,0x00  ;`  60
 .DB 0x00,0x00,0x0e,0x10,0x0e,0x11,0x1e,0x00  ;a
 .DB 0x01,0x01,0x0d,0x13,0x11,0x11,0x0F,0x00  ;b
 .DB 0x00,0x00,0x0e,0x01,0x01,0x11,0x0e,0x00  ;c
 .DB 0x10,0x10,0x16,0x19,0x11,0x11,0x1e,0x00  ;d
 .DB 0x00,0x00,0x0e,0x11,0x1f,0x01,0x0e,0x00  ;e
 .DB 0x0c,0x12,0x02,0x07,0x02,0x02,0x02,0x00  ;f
 .DB 0x00,0x1e,0x11,0x11,0x1e,0x10,0x0e,0x00  ;g
 .DB 0x01,0x01,0x0d,0x13,0x11,0x11,0x11,0x00  ;h
 .DB 0x04,0x00,0x06,0x04,0x04,0x04,0x0e,0x00  ;i
 .DB 0x08,0x00,0x0c,0x08,0x08,0x09,0x06,0x00  ;j
 .DB 0x01,0x01,0x09,0x05,0x03,0x05,0x09,0x00  ;k
 .DB 0x06,0x04,0x04,0x04,0x04,0x04,0x0e,0x00  ;l
 .DB 0x00,0x00,0x0b,0x15,0x15,0x11,0x11,0x00  ;m
 .DB 0x00,0x00,0x0d,0x13,0x11,0x11,0x11,0x00  ;n
 .DB 0x00,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00  ;o

 .DB 0x00,0x00,0x0f,0x11,0x0f,0x01,0x01,0x00  ;p  70
 .DB 0x00,0x00,0x16,0x19,0x1e,0x10,0x10,0x00  ;q
 .DB 0x00,0x00,0x0d,0x13,0x01,0x01,0x01,0x00  ;r
 .DB 0x00,0x00,0x0e,0x01,0x0e,0x10,0x0f,0x00  ;s
 .DB 0x02,0x02,0x07,0x02,0x02,0x12,0x0c,0x00  ;t
 .DB 0x00,0x00,0x11,0x11,0x11,0x19,0x16,0x00  ;u
 .DB 0x00,0x00,0x11,0x11,0x11,0x0a,0x04,0x00  ;v
 .DB 0x00,0x00,0x11,0x11,0x15,0x15,0x0a,0x00  ;w
 .DB 0x00,0x00,0x11,0x0a,0x04,0x0a,0x11,0x00  ;x
 .DB 0x00,0x00,0x11,0x11,0x1e,0x10,0x0e,0x00  ;y
 .DB 0x00,0x00,0x1f,0x08,0x04,0x02,0x1f,0x00  ;z
 .DB 0x08,0x04,0x04,0x02,0x04,0x04,0x08,0x00  ;{
 .DB 0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00  ;|
 .DB 0x02,0x04,0x04,0x08,0x04,0x04,0x02,0x00  ;}
 .DB 0x00,0x04,0x08,0x1f,0x08,0x04,0x00,0x00  ;->
 .DB 0x00,0x04,0x02,0x1f,0x02,0x04,0x00,0x00  ;<-
  


;ENDE