#ifndef _MCA25_H_
#define _MCA25_H_

#include <avr/io.h>

#define USE_MCA25_CAM 1
#define USE_WEBCAM_LEDS 1

#define CAM_BUFFER_LEN 512	
#define MCA25_COMM_BUFFER_LEN 40

#define MCA25_RESET_PORT     PORTD
#define MCA25_RESET_PORT_DIR DDRD
#define MCA25_RESET_PIN      PD6
#define MCA25_RESET_HI() MCA25_RESET_PORT|=(1<<MCA25_RESET_PIN);
#define MCA25_RESET_LO() MCA25_RESET_PORT&=~(1<<MCA25_RESET_PIN);

typedef struct {
  unsigned char       init:3;
  unsigned char       busy:1;
  unsigned char   skip_pic:1;
  unsigned char        ret:1;
  unsigned char first_data:1;
} mca25_t;

char mca25_init(void);
char mca25_configure(void);
void mca25_grab_data(char *buffer, unsigned int *datalen, char *frametype);
void mca25_grab_jpeg(char res);
void mca25_start_image_grab(void);
unsigned char mca25_copy_data(char *buffer, unsigned int *len);
void mca25_pgm_send(PGM_P pointer, unsigned int len);

#endif
