/*****************************************************************************
*  Simple Application using uIP 0.9
*****************************************************************************/

#include "compiler.h"
#include "services.h"
#include <avr/io.h>
#include <avr/pgmspace.h>
#include "mca25.h"
#include "delay.h"
#include "uipopt.h"
#include "uip.h"
#include "uip_arp.h"
#include <string.h>

#define HTTP_NOGET   0
#define HTTP_GET     1
#define HTTP_FILE    2
#define RAW_FILE     3
#define HTTP_GET_404 4
#define HTTP_GET_PIC 5
#define HTTP_PIC     6


extern mca25_t mca25_stat;
extern unsigned char mca25_buf[CAM_BUFFER_LEN];


prog_char index_html[] = {
"<head>"
"<style type=\"text/css\">"
"div{width: 660px;border: 1px solid black;background: #e0e0e0;padding: 2px;}"
"#t{font-size: 18px; border-bottom: 0; margin-top: 8px;}"
"#c{width: 660px;border: 1px solid black;background: #e0e0e0; padding: 2px;"
"text-align: center;height: 480px;border-top: 0;border-bottom: 0;}"
"#d{border: 1px solid black;}"
"#f{font-size: 14px;border-top: 0; text-align: right; padding-bottom: 5px;}"
"#r{ background: #c0c0c0; border: 1px solid black; padding-left: 10px; padding-right: 10px;" "text-decoration: none; margin-right: 10px; }"
"#r:hover{ background: #707070;}"
"#w{visibility: visible; border: 1px solid white; position: absolute; background: #000000; color: #ffffff; top:200px; left:430px; width:150px; height:50px; z-index:1; }"
"</style>"
"<script language=\"Javascript\" type=\"text/javascript\">"
"function wait(i){"
"if (document.getElementById) "
"document.getElementById(\"w\").style.visibility = (i==1?\"visible\":\"hidden\"); "
"}\n"
"function cam(){"
  "wait(1);"
	"if (document.getElementById) "
	"document.getElementById(\"d\").src = \"/cam?t=\"+Math.floor(100+Math.random()*899); "
	"setTimeout(\"wait(0);\",9000);"
"}\n"
"function cam2(val){"
	"wait(1);"
	"if (document.getElementById) "
	"document.getElementById(\"d\").src = \"/cam?v=\"+val+\"&t=\"+Math.floor(100+Math.random()*899); "
	"setTimeout(\"wait(0);\",9500);"
"}\n"
"</script>"
"</head>"
"<body bgcolor=\"#336699\" vlink=\"#000000\" alink=\"#000000\" link=\"#000000\" onLoad=\"wait(0);\">"
"<center>"
"<div id=\"t\">AVRipcam</div>"
"<div id=\"c\">"
"<div id=\"w\"><br>bitte warten...</div>"
"<img id=\"d\" name=\"cam\" src=\"cam.jpg\" height=\"480\" width=\"640\" alt=\"loading...\"></div>"
"<div id=\"f\">"
//"<a id=\"r\" href=\"javascript:cam();\">reload...</a>"
"</div>"
//please do not remove this link: thnx
"mehr &uuml;ber die <a href=\"http://avr.auctionant.de/avr-ip-webcam/\">avr ip webcam</a>"
"</center></body></html>"
"\r\n\r\n%EOF" //%EOF = Ende des Files
};


prog_char error_404[]={"<html><body bgcolor=\"white\"><center><h1>404 - file not found"
                       "</h1></center></body></html>\r\n\r\n"};


u8_t chk4getend(void) {
 if (uip_datalen()<5) return 1;
 return !strncmp_P((const char*)uip_appdata+uip_datalen()-4,PSTR("\r\n\r\n"),4);
}


u8_t strncmp_PP(prog_char* ptr1, prog_char* ptr2, u8_t len)
{
 while(len--) if (pgm_read_byte(ptr1++)!=pgm_read_byte(ptr2++)) return 1;
 return 0;
}


void sendraw_P(prog_char* dataptr_P, u16_t dataleft)
{
 memcpy_P((u8_t*)uip_appdata,dataptr_P,(dataleft>uip_mss())?uip_mss():dataleft);
 uip_send(uip_appdata,dataleft);
}


prog_char* sendhtml_P(struct http_state* s)
{
 u16_t i;
 prog_char* ptr=s->dataptr_P;
 
 for (i=0; i<uip_mss(); i++) {
  if ((*(uip_appdata+i)=pgm_read_byte(ptr++)) =='%') {
    if (strncmp_PP((prog_char*)PSTR("EOF"),ptr,3) == 0) {ptr=(prog_char*)0; break;}
  }
 }
 if (i) uip_send(uip_appdata,i);
 return ptr;
}


void start_pic_trans(struct http_state* s,unsigned int *len) {
 if (chk4getend()) {
   if (mca25_stat.init) {
     // do something here - create a message for user
     uip_abort();
     return;
   }
   if (mca25_stat.busy) {
     uip_close();
     return;
   }
   s->state=HTTP_PIC;
   mca25_stat.busy=1;
   mca25_copy_data(mca25_buf,len);
   uip_send(mca25_buf,*len);
 }
}


void httpd(void) {
   
   static unsigned int len=0;
   static char ret=1;
  
   struct http_state *s;
   s = (struct http_state *)uip_conn->appstate;

   if(uip_connected()) {
     s->state=HTTP_NOGET;
     return;
   }
   
   if(uip_newdata()) {
     switch (s->state) {

     case HTTP_NOGET:
      if (strncmp_P((const char*)uip_appdata,PSTR("GET /"),5)) uip_abort();
      if (uip_appdata[5]==' ') {
         s->state=HTTP_GET;
         if (chk4getend()) {
           s->dataptr_P=(prog_char*)index_html;
           s->state=HTTP_FILE;
           s->nxtdatptr_P=sendhtml_P(s);
         }
         break;  
      }
      if (!strncmp_P((const char*)uip_appdata+5,PSTR("cam.jpg"),7)) {
         s->state=HTTP_GET_PIC;
         start_pic_trans(s,&len);
         break;
      }
      
      s->state=HTTP_GET_404;
      if (chk4getend()) {
        s->state=RAW_FILE;
        s->dataptr_P=(prog_char*)error_404;
        s->dataleft=sizeof(error_404);
        sendraw_P(s->dataptr_P,s->dataleft);
      }
      break;        

     case HTTP_GET_404:
      if (chk4getend()) {
        s->state=RAW_FILE;
        s->dataptr_P=(prog_char*)error_404;
        s->dataleft=sizeof(error_404);
        sendraw_P(s->dataptr_P,s->dataleft);
      }
      break;        

     case HTTP_GET:
      if (chk4getend()) {
        s->dataptr_P=(prog_char*)index_html;
        s->state=HTTP_FILE;
        s->nxtdatptr_P=sendhtml_P(s);
      }
      break;

     case HTTP_GET_PIC:
      start_pic_trans(s,&len); 
      break;

     }
   }
 

   if(uip_rexmit()) {
     switch (s->state) {
     
     case HTTP_FILE:
      s->nxtdatptr_P=sendhtml_P(s);
      break;
    
     case RAW_FILE:
      sendraw_P(s->dataptr_P,s->dataleft);
      break;

     case HTTP_PIC:
      uip_send(mca25_buf,len);
      break;
     }    
     return;
   }

   if(uip_acked()) {
   
     switch (s->state) {
     
     case RAW_FILE:
      if(s->dataleft < uip_mss()) {
         uip_close();
	 break;
      }
      s->dataptr_P+=uip_conn->len;
      s->dataleft-=uip_conn->len;
      sendraw_P(s->dataptr_P,s->dataleft);
      break;
     
     case HTTP_FILE:
      if(s->nxtdatptr_P) {
        s->dataptr_P=s->nxtdatptr_P;
        s->nxtdatptr_P=sendhtml_P(s);
	break;
      }
      uip_close();
      break;

      case HTTP_PIC:
       if (ret) { 
         ret=mca25_copy_data(mca25_buf,&len);
         uip_send(mca25_buf,len);
         return;  
       }
       ret=1;
       mca25_stat.busy=0;
       uip_close(); 
       break; 
     }
   }
   
   if((uip_aborted()||uip_timedout()) && mca25_stat.busy) {
     while (mca25_copy_data(mca25_buf,&len)); 
     mca25_stat.busy=0;
     ret=1;
   }
   
}


void services_init(void) {
   
   uip_listen(HTONS(80));
}


void services_main(void) {
  
 switch(uip_conn->lport) {

  case HTONS(80):
   httpd();
   break;

  default:
   uip_abort();
   break;
  }  
}
