/*#######################################################################################
Copyright (C) 2004 Ulrich Radig

Bei Fragen und Verbesserungen wendet euch per EMail an

mail@ulrichradig.de

oder im Forum meiner Web Page : www.ulrichradig.de


Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
GNU General Public License, wie von der Free Software Foundation verffentlicht, 
weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
(nach Ihrer Option) jeder spteren Version. 

Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
Programm erhalten haben. 
Falls nicht, schreiben Sie an die Free Software Foundation, 
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
#######################################################################################*/

#include <lpc213x.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "uart.h"
#include "printf_P.h"
#include "viclowlevel.h"
#include "pal.h"

void SystemInit(void)
{
	// --- enable and connect the PLL (Phase Locked Loop) ---
	// a. set multiplier and divider
	PLLCFG = MSEL | (1<<PSEL1) | (0<<PSEL0);
	// b. enable PLL
	PLLCON = (1<<PLLE);
	// c. feed sequence
	PLLFEED = PLL_FEED1;
	PLLFEED = PLL_FEED2;
	// d. wait for PLL lock (PLOCK bit is set if locked)
	while (!(PLLSTAT & (1<<PLOCK)));
	// e. connect (and enable) PLL
	PLLCON = (1<<PLLE) | (1<<PLLC);
	// f. feed sequence
	PLLFEED = PLL_FEED1;
	PLLFEED = PLL_FEED2;
	
	// --- setup and enable the MAM (Memory Accelerator Module) ---
	// a. start change by turning of the MAM (redundant)
	MAMCR = 0;	
	// b. set MAM-Fetch cycle to 3 cclk as recommended for >40MHz
	MAMTIM = MAM_FETCH;
	// c. enable MAM 
	MAMCR = MAM_MODE;
	
	// --- set VPB speed ---
	VPBDIV = VPBDIV_VAL;
	
	// --- map INT-vector ---
	#if defined(RAM_RUN)
	  MEMMAP = MEMMAP_USER_RAM_MODE;
	#elif defined(ROM_RUN)
	  MEMMAP = MEMMAP_USER_FLASH_MODE;
	#else
	#error RUN_MODE not defined!
	#endif
}

/* *** MAIN ************************************************************* */
 
int main(void)
{  
	SystemInit();
    uart0Init(B9600, UART_8N1, UART_FIFO_8); // setup the UART 

	printf("\n\r*** START ***\n\r");	

    IODIR0 |= P0_23;
    
    PINSEL1 |= (1<<0);
    VICIntEnClear = 0xFFFFFFFF;
    VICIntSelect = 0x00000000; 
    
    pal_timer_init();
    
    enableIRQ(); 
    
    int a,n;
    
    pal_line(0,0,259,0);
    pal_line(0,0,0,335);
    pal_line(259,335,259,0);
    pal_line(259,335,0,335);
    pal_line(0,0,259,335);

    for (a = 0;a<50000;a++);

    pal_encode_str(4,20,"Ulrich Radig");
 
    while(1)
    {
        pal_clear();
        for (n = 0;n<50000;n++);
        pal_clear();
        for (a=5;a<335;a=a+2)
        {
            pal_line(5,0,259,a);
            for (n = 0;n<5000;n++);
        }
        for (a=259;a>5;a=a-2)
        {
            pal_line(5,0,a,335);
            for (n = 0;n<5000;n++);
        }
    }    
return(0);
}


