// Modul...: PAL.C
// Version.: 1.0
// Compiler: ARMGCC
// Datum...: Dezember 2005
// Autor...: Ulrich Radig
//------------------------------------------------------------------------------

#include "pal.h"
#include "ssp_master.h"
#include "typedefs.h"
#include "config.h"

//-----------------------------------------------------------------------------
//
// P0.21 PWM5  Ausgang Sync  --[A]Diode[K]--1kOhm---------- 75 Ohm - Masse
// P0.19 MOSI  Ausgang Video --[A]Diode[K]--220Ohm __/
//
//-----------------------------------------------------------------------------

U08 pal_image[PAL_BYTES_PER_CHAR_ROW * PAL_CHAR_ROWS];

pU08 pal_image_ptr;
U32 pal_timer_count = 0; // Timer1 Zhlerwert
U32 pal_line_count = 0; // Aktuelle Display-Zeile
U32 pal_bytes_to_write; // Anzahl Datenbytes
U32 pal_timer_count1 = 0;
//-----------------------------------------------------------------------------

/* Timer0 Compare-Match Interrupt Handler (ISR) */
void __attribute__ ((interrupt("IRQ"))) tc0_cmp(void) 
{
  T1MR0 = T1TC + PAL_HSYNC_64_US; // MatchRegister0 setzen
  U16 tmp;
  pal_timer_count1 = T1TC + PAL_HSYNC_64_US;
  if (++pal_line_count < 311 ) // 1. Halbbild VSync	 311
  {
    while(++pal_line_count < 311)
   	{ 
      PAL_SYNC_LOW(); // Sync ein
      pal_timer_count = T1TC + PAL_HSYNC_DURATION+5;
      while (T1TC < pal_timer_count) ; // Synchronpuls 4.8s
      PAL_SYNC_HIGH(); // Sync aus

  	  if (pal_line_count >= PAL_MIN_VERT_OFF && pal_line_count < PAL_MAX_VERT_OFF)
      {

	    pal_timer_count = T1TC + PAL_HORZ_OFF;	
	    while (T1TC < pal_timer_count);

  	    pal_bytes_to_write = PAL_CHAR_COLS / 2;

        while (pal_bytes_to_write--)
        {
    	  while(!(SSPSR & TNF));
          tmp = ((*pal_image_ptr++) << 8);
          tmp = tmp + (*pal_image_ptr++);
          SSPDR = tmp; // Datenbyte in den Tx-FIFO schreiben
	    }
	  }
      while (T1TC < pal_timer_count1);
      pal_timer_count1 = T1TC + PAL_HSYNC_64_US - PAL_LATENZ;
    }
    
	T1MR0 = T1TC + PAL_HSYNC_64_US; // MatchRegister0 setzen
    for (pal_timer_count = 0;pal_timer_count<10;pal_timer_count++);
    PAL_SYNC_LOW(); // Sync ein
	pal_timer_count = T1TC + PAL_HSYNC_DURATION;
    while (T1TC < pal_timer_count) ; // Synchronpuls 4.8s
    PAL_SYNC_HIGH(); // Sync aus

  }
  else
  { 
  	T1MR0 = T1MR0 - PAL_HSYNC_32_US; // MatchRegister0 setzen
    if (pal_line_count < 316) // 1. Halbbild VSync	  316
    {

      PAL_SYNC_LOW(); // Sync aus
	  pal_timer_count = T1TC + PAL_HALF_HSYNC_DURATION;
      while (T1TC < pal_timer_count) ; // Synchronpuls 2.4s 
      PAL_SYNC_HIGH(); // Sync aus
    }
    else if (pal_line_count < 321) // 1. Halbbild VSync	 321
    {
	  PAL_SYNC_HIGH(); // Sync aus
	  pal_timer_count = T1TC + PAL_HALF_HSYNC_DURATION;
      while (T1TC < pal_timer_count) ; // Synchronpuls 2.4s 
      PAL_SYNC_LOW(); // Sync aus
    }
    else if (pal_line_count < 324) // 1. Halbbild VSync	 325
    {
	  PAL_SYNC_LOW(); // Sync aus
	  pal_timer_count = T1TC + PAL_HALF_HSYNC_DURATION;
      while (T1TC < pal_timer_count) ; // Synchronpuls 2.4s 
      PAL_SYNC_HIGH(); // Sync aus
    }
    else
    {
      PAL_SYNC_LOW(); // Sync aus
	  pal_timer_count = T1TC + PAL_HALF_HSYNC_DURATION;
      while (T1TC < pal_timer_count) ; // Synchronpuls 4.8s 
      PAL_SYNC_HIGH(); // Sync aus	  
	  pal_line_count = 0;
	  pal_image_ptr = (pU08)&pal_image[0];
	  T1MR0 += PAL_HSYNC_32_US; // MatchRegister0 setzen
    }
  }  
  T1IR = 0xFF; // Timer1 Interrupt-Flags lschen
  VICVectAddr = 0; // Interrupt in VIC lschen
}
//-----------------------------------------------------------------------------

void pal_timer_init(void)
{
  U32 n;

  for (n = 0; n < PAL_CHAR_ROWS * PAL_CHAR_LINES * PAL_CHAR_COLS; n++)
  {
    pal_image[n] = 0x00;
  }

  PAL_SYNC_INIT(); // Sync-Signal als Ausgang setzen
/*
  T0MR0 = ((FOSC*PLL_M)/(1000/10))-1;     // Compare-hit at 10mSec (-1 reset "tick")
  T0MCR = TxMCR_INT_ON_MR0 | TxMCR_RESET_ON_MR0; 	// Interrupt and Reset on MR0
  T0TCR = TxTCR_COUNTER_ENABLE;            // Timer0 Enable

  VICVectAddr0 = (unsigned long)tc0_cmp;   // set interrupt vector in 0
  VICVectCntl0 = VICVectCntl0_ENABLE | VIC_Channel_Timer0; // use it for Timer 0 Interrupt:
  VICIntEnable = (1<<VIC_Channel_Timer0);    // Enable Timer0 Interrupt
*/



  T1TCR = 0; // Timer1 ausschalten
  T1PC = 0; // Prescaler = 0
  T1EMR = 0; // Match Pin Aktivitt ausschalten
  T1CCR = 0; // Capture ausschalten
  T1PR = ((FOSC*PLL_M) / PAL_TIMER_CLK1) - 1; // Prescaler setzen
  T1MCR = TIM_MR0INT ;// Freigabe fr Interrupt MR0 (Match-Register 0)
  T1MR0 += PAL_HSYNC_64_US; // MatchRegister0 setzen
  
  VICVectAddr0 = (unsigned long)tc0_cmp;   // set interrupt vector in 0
  VICVectCntl0 = VICVectCntl0_ENABLE | VIC_Channel_Timer1; // use it for Timer 0 Interrupt:
  VICIntEnable = (1<<VIC_Channel_Timer1);    // Enable Timer0 Interrupt
  
  T1TCR = TIM_CE; // Timer1 einschalten


  PCONP |= PCSPI1; // SPI1 einschalten
  PINSEL1 |= SPI1_IOSET_MASK; // PIN Konfigurieren
  SSPCPSR = 8; // Clock Prescale Register setzten
  SSPCR0 = DSS_16_BIT | CPHA |FRF_SPI; // SPI-Format  
  SSPCR1 = SSE; // Schnittstelle als Master aktivieren
  while (SSPSR & RNE) // Rx-FIFO leeren
  {
    SSPDR; // Dummy-Read
  }



}
//-----------------------------------------------------------------------------

void pal_encode_char(U32 col,U32 row,U08 chr)
{
  pU08 font_ptr;
  U32 n;

  if (chr >= 32)
  {
    chr -= 32;
  }

  font_ptr = (pU08)&FONT_IMAGE_7X9[chr][0];
  row *= PAL_BYTES_PER_CHAR_ROW;

  for (n = 0; n < PAL_CHAR_LINES; n++)
  {
    pal_image[row + col + n * PAL_CHAR_COLS] = *font_ptr++;
  }
}
//-----------------------------------------------------------------------------

void pal_encode_str(U32 col,U32 row,pU08 pstr)
{
  while (*pstr)
  {
    pal_encode_char(col++,row,*pstr++);
  }
}
//-----------------------------------------------------------------------------

void pal_set_pixel (U32 zeile,U32 spalte)
{
 pal_image[(zeile*PAL_CHAR_COLS)+(spalte/8)]|=1 << (7- (spalte -((spalte/8)*8)));
}

//-----------------------------------------------------------------------------

void pal_clear_pixel (U32 zeile,U32 spalte)
{
 pal_image[(zeile*PAL_CHAR_COLS) + (spalte/8)]&=~(1 << (7- (spalte -((spalte/8)*8))));
}

//-----------------------------------------------------------------------------
void pal_swap_int ( U32 *i1, U32 *i2 )
{
U32 dummy;

dummy = *i2;
*i2 = *i1;
*i1 = dummy;
}

//-----------------------------------------------------------------------------
//Linen zeichnen nach dem Bresenham-Algorithmus
void pal_line( U32 x1, U32 y1, U32 x2, U32 y2)
{
	S32 d, dx, dy, aincr, bincr, xincr, yincr, x, y;

	if (abs(x2-x1)<abs(y2-y1))
	{
		if ( y1 > y2 )
		{
			pal_swap_int( &x1, &x2 );
			pal_swap_int( &y1, &y2 );
		}
		xincr = ( x2 > x1 ) ? 1 : -1;
		dy = y2 - y1;
		dx = abs( x2-x1 );
		d = 2 * dx - dy;
		aincr = 2 * (dx - dy);
		bincr = 2 * dx;
		x = x1;
		y = y1;

		pal_set_pixel( x, y);
		for (y=y1+1; y<= y2; ++y )
		{
			if ( d >= 0 )
			{
				x += xincr;
				d += aincr;
			}
			else d += bincr;
		pal_set_pixel( x, y );
		}
	} 
	else
	{
		if ( x1 > x2 )
		{
			pal_swap_int( &x1, &x2 );
			pal_swap_int( &y1, &y2 );
		}
		yincr = ( y2 > y1 ) ? 1 : -1;
		dx = x2 - x1;
		dy = abs( y2-y1 );
		d = 2 * dy - dx;
		aincr = 2 * (dy - dx);
		bincr = 2 * dy;
		x = x1;
		y= y1;
		pal_set_pixel( x, y);
		for (x=x1+1; x<=x2; ++x )
		{
			if ( d >= 0 )
			{
				y += yincr;
				d += aincr;
			} 
			else
			{
				d += bincr;
			}
			pal_set_pixel( x, y );
		}
	}
}

//-----------------------------------------------------------------------------
void pal_clear(void)
{
  U32 n;

  for (n = 0; n < PAL_CHAR_ROWS * PAL_CHAR_LINES * PAL_CHAR_COLS; n++)
  {
    pal_image[n] = 0x00;
  }
}

