#ifndef __PAL_H
#define __PAL_H
//-----------------------------------------------------------------------------

#include "lpc213x.h"
#include "typedefs.h"
#include "font.h"
#include "ssp_master.h"
//-----------------------------------------------------------------------------

#define PAL_MAX_LINES (U32)312 // Standard PAL Zeilen pro Halbbild
#define PAL_CHAR_COLS (U32)42
#define PAL_CHAR_ROWS (U32)26
#define PAL_CHAR_LINES (U32)10
#define PAL_HORZ_OFF (U32) 30
#define PAL_MIN_VERT_OFF (U32)32
#define PAL_MAX_VERT_OFF (U32)(PAL_CHAR_LINES * PAL_CHAR_ROWS + PAL_MIN_VERT_OFF)
#define PAL_TOTAL_CHAR_LINES (U32)(PAL_CHAR_LINES + PAL_CHAR_BLANK_LINES)
#define PAL_BYTES_PER_CHAR_ROW (U32)(PAL_CHAR_LINES * PAL_CHAR_COLS)

#define PAL_TIMER_CLK0 (U32)5000000 // 200ns Timer1-Takt
#define PAL_TIMER_CLK1 (U32)5000000  // 1us Timer1-Takt
#define PAL_HSYNC_64_US (U32)320 // Timer Ticks fr 64.0s HSync Intervall
#define PAL_HSYNC_32_US (PAL_HSYNC_64_US / 2) // Timer Ticks fr 32.0s HSync Intervall
#define PAL_HSYNC_DURATION (U32)20 // Timer Ticks fr 4.8s HSync Pulsbreite
#define PAL_HALF_HSYNC_DURATION (U32)(PAL_HSYNC_DURATION / 2) // Timer Ticks fr 2.4s HSync Pulsbreite	 
#define PAL_LATENZ 3

#define PAL_SYNC_DIR IODIR0 // Datenrichtungsregister fr Sync-Signal
#define PAL_SYNC_SET IOSET0 // Setzregister fr Sync-Signal
#define PAL_SYNC_CLR IOCLR0 // Lschregister fr Sync-Signal
#define PAL_SYNC_PIN P0_21 // Pin fr Sync-Signal

// Makros
#define PAL_SYNC_INIT() (PAL_SYNC_DIR |= PAL_SYNC_PIN)
#define PAL_SYNC_HIGH() (PAL_SYNC_SET = PAL_SYNC_PIN)
#define PAL_SYNC_LOW() (PAL_SYNC_CLR = PAL_SYNC_PIN)

#define VICVectCntl0_ENABLE (1<<5)

#define VIC_Channel_Timer0  4
#define VIC_Channel_Timer1  5

#define TxTCR_COUNTER_ENABLE (1<<0)
#define TxTCR_COUNTER_RESET  (1<<1)
#define TxMCR_INT_ON_MR0     (1<<0)
#define TxMCR_RESET_ON_MR0   (1<<1)
#define TxIR_MR0_FLAG        (1<<0)
//-----------------------------------------------------------------------------

// TxIR Interrupt-Register
#define TIM_CR3INT BIT7 // Interrupt-Flag fr Capture-Kanal 3
#define TIM_CR2INT BIT6 // Interrupt-Flag fr Capture-Kanal 2
#define TIM_CR1INT BIT5 // Interrupt-Flag fr Capture-Kanal 1
#define TIM_CR0INT BIT4 // Interrupt-Flag fr Capture-Kanal 0
#define TIM_MR3INT BIT9 // Interrupt-Flag fr Match-Kanal 3
#define TIM_MR2INT BIT6 // Interrupt-Flag fr Match-Kanal 2
#define TIM_MR1INT BIT3 // Interrupt-Flag fr Match-Kanal 1
#define TIM_MR0RES BIT1
#define TIM_MR0INT BIT0 // Interrupt-Flag fr Match-Kanal 0

// TxTCR Timer-Control-Register
#define TIM_CR BIT1 // Counter-Reset
#define TIM_CE BIT0 // Counter-Enable

// TxCCR Capture-Control-Register
#define TIM_CAP3INT BIT11 // Interrupt fr Pin CAPx.3 einschalten
#define TIM_CAP3FE  BIT10 // Negative Flankentriggerung fr CAPx.3
#define TIM_CAP3RE  BIT9 // Positive Flankentriggerung fr CAPx.3
#define TIM_CAP2INT BIT8 // Interrupt fr Pin CAPx.2 einschalten
#define TIM_CAP2FE  BIT7 // Negative Flankentriggerung fr CAPx.2
#define TIM_CAP2RE  BIT6 // Positive Flankentriggerung fr CAPx.2
#define TIM_CAP1INT BIT5 // Interrupt fr Pin CAPx.1 einschalten
#define TIM_CAP1FE  BIT4 // Negative Flankentriggerung fr CAPx.1
#define TIM_CAP1RE  BIT3 // Positive Flankentriggerung fr CAPx.1
#define TIM_CAP0INT BIT2 // Interrupt fr Pin CAPx.0 einschalten
#define TIM_CAP0FE  BIT1 // Negative Flankentriggerung fr CAPx.0
#define TIM_CAP0RE  BIT0 // Positive Flankentriggerung fr CAPx.0
//-----------------------------------------------------------------------------

void pal_timer_init(void);
void pal_encode_char(U32 col,U32 row,U08 chr);
void pal_encode_str(U32 col,U32 row,pU08 pstr);
void pal_set_pixel (U32 zeile,U32 spalte);
void pal_clear_pixel (U32 zeile,U32 spalte);
void pal_swap_int ( U32 *i1, U32 *i2 );
void pal_line( U32 x1, U32 y1, U32 x2, U32 y2);
void pal_clear (void);

//-----------------------------------------------------------------------------

#endif
