#ifndef __SSP_MASTER_H
#define __SSP_MASTER_H
//-----------------------------------------------------------------------------
#include "typedefs.h"
//-----------------------------------------------------------------------------

#define SSP_FIFO_SIZE 8

// SSPCR0 Control Register 0
#define CPHA      BIT7 // Clock Out Phase
#define CPOL      BIT6 // Clock Out Polarity
#define FRF_SPI   0x00 // SPI MODE
#define FRF_SSI   0x10 // SSI MODE
#define FRF_MICRO 0x20 // Microwire MODE

#define DSS_04_BIT 0x03
#define DSS_08_BIT 0x07
#define DSS_09_BIT 0x08
#define DSS_10_BIT 0x09
#define DSS_11_BIT 0x0A
#define DSS_12_BIT 0x0B
#define DSS_13_BIT 0x0C
#define DSS_14_BIT 0x0D
#define DSS_15_BIT 0x0E
#define DSS_16_BIT 0x0F

// SSPCR1 Control Register 1
#define SOD BIT3 // Slave Output Disable
#define MS  BIT2 // Master/Slave, 0 = MASTER
#define SSE BIT1 // SSP Enable
#define LBM BIT0 // Loop Back Mode

// SSPSR Status Register
#define BSY BIT4 // BUSY
#define RFF BIT3 // Receive FIFO Full
#define RNE BIT2 // Receive FIFO Not Empty
#define TNF BIT1 // Transmit FIFO Not Full
#define TFE BIT0 // Transmit FIFO Empty

// SSPIMSC Interrupt Mask Set/Clear Register
#define TXIM  BIT3 // IRQ Tx FIFO enable
#define RXIM  BIT2 // IRQ Rx FIFO enable
#define RTIM  BIT1 // IRQ Receive Timeout enable
#define RORIM BIT0 // IRQ Receive Overrun enable

// SSPRIS Raw Interrupt Status Register
#define TXRIS  BIT3 // Tx FIFO is at least half empty
#define RXRIS  BIT2 // Rx FIFO is at least half full
#define RTRIS  BIT1 // Receive Timeout condition
#define RORRIS BIT0 // completely received while the RxFIFO was full

// SSPMIS Masked Interrupt Status Register
#define TXMIS  BIT3 // Tx FIFO is at least half empty, and this interrupt is enabled
#define RXMIS  BIT2 // Rx FIFO is at least half full, and this interrupt is enabled
#define RTMIS  BIT1 // Receive Timeout condition and this interrupt is enabled
#define RORMIS BIT0 // another frame was completely received while the RxFIFO was full, and this interrupt is enabled

// SSPICR Interrupt Clear Register
#define RTIC  BIT1 // clears the Receive Timeout interrupt
#define RORIC BIT0 // clears the frame was received when RxFIFO was full interrupt

// SPI-IOSET-Maske
#define SPI1_IOSET_MASK 0x000002A8 // SS,SCK,MISO und MOSI fr SPI1 einschalten
//-----------------------------------------------------------------------------

#define SPI_DI				5
#define SPI_DO				6
#define SPI_Clock			4

// SPCR Control Register 0
#define SPI0_MSTR    BIT5 // SPI MODE Master/Slave
#define SPI0_CPOL    BIT4 // Clock Out Polarity
#define SPI0_CPHA    BIT3 // Clock Out Phase

// SPSR Status Register
#define SPIF    BIT7 // BUSY

// SPI-IOSET-Maske
#define SPI0_IOSET_MASK 0x00005500 // SS,SCK,MISO und MOSI fr SPI1 einschalten

#endif
