//////////////////////////////////////////////////////////////////
// Die Messwerte werden ber die serielle Schnittstelle ausgegeben
// Zielhardware: Atmel AtMega 8
// Dateiname:   main.c
// Headerfile:  main.h
// Autor: Thomas Wiens th.wiens(at)gmx.de
// Datum: 29.12.2005
//////////////////////////////////////////////////////////////////
/* Der PC sendet ein Dn, n ist dabei die Nummer des Sensors dessen
 Messwert ausgegeben werdem soll. 
 PC->C "1"
 C startet Wandlung und liest Messwert aus
 C->PC "215" als Messwert fr 21,5C
 Als Ende-Zeichen wird vom C ein /n bertragen

Sendet der PC ein R wird vom C der ROMCode des DS1820 ausgegeben.
Dies funktioniert nur, wenn nur ein! Sensor angeschlossen ist.
 Als Ende-Zeichen wird vom C ein /n bertragen
*/

#include "main.h"
#define MAXSENSORS 10 // Anzahl der sich am Bus befindlichen Sensoren

char getRomCodes(void);

// ********************************************************************************************
// GLOBALE VARIABLEN
// ********************************************************************************************
char com_befehl;
// Hat com_befehl einen Wert von 1-10 wird der entsprechende Sensor abgefragt
// Ist com_befehl == "R" wird der ROMCode ausgelesen
// Ist com_befehl == "W" folgen 80 Bytes mit Daten fr den RomCode


unsigned char ee_w1_romCode[MAXSENSORS][8] EEMEM = {
	{16, 19, 193, 218, 0, 8, 0, 122},
	{16, 227, 42, 219, 0, 8, 0, 45},
	{16, 14, 10, 219, 0, 8, 0, 182},
	{0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0}
};

unsigned char EEMEM ee_w1_num_sensors;				// Anzahl der aktiven Sensoren am Bus


// ********************************************************************************************
// INTERRUPTS
// ********************************************************************************************
SIGNAL (SIG_UART_RECV) {
	com_befehl = UDR;
}

// ********************************************************************************************
// MAIN
// ********************************************************************************************
int main(void){
	int result;
	unsigned char i, romCode[8], w1_num_sensors;
	char daten[50];
	unsigned char w1_romCode[MAXSENSORS][8];
	
	eeprom_read_block(&w1_romCode, &ee_w1_romCode, MAXSENSORS * 8);
	w1_num_sensors = eeprom_read_byte(&ee_w1_num_sensors);
	uinit();										// UART initialisieren
	UCSRB |= (1<<RXCIE);							// Receive Interrupt freigeben
	sei();
	for (;;){
		cli();
		if ((com_befehl > '0') && (com_befehl <= '9')) {
			// '1' entspricht ASCII 49 dez. -> Befehl enthlt den Kanal in dezimaler Form
			result = wire_meas_serial(w1_romCode[(com_befehl - 49)]);
			itoa(result, daten, 10);
			uputs(daten);
			uputs("\n");
			com_befehl = 0;
		}
		else if (com_befehl == 'R') {
			result = wire_read_rom(romCode);
			if (result)
				uputs("0000000000000000");
			else {
				for (i = 0; i < 8; i++) {
					sprintf( daten, "%02X", romCode[i] );  // Seriennummer in Hexadezimaler Form ausgeben
					uputs(daten);
				}				
			}
			uputs("\n");
			com_befehl = 0;
		}
		else if (com_befehl == 'W') {
			if (getRomCodes() == 0) {
				eeprom_read_block(&w1_romCode, &ee_w1_romCode, MAXSENSORS * 8);  // Daten aus EEPROM ins Ram zurcklesen
				w1_num_sensors = eeprom_read_byte(&ee_w1_num_sensors);
			}
			com_befehl = 0;			
		}
		sei();
	}	
	return(0);
}

// ********************************************************************************************
// FUNKTIONEN
// ********************************************************************************************
/* Es werden die ROM-Codes hintereinander bertragen, es werden insgesamt 82 Zeichen erwartet
   80 Zeichen ROM-Codes, dann die Anzahl der aktiven Sensoren am Bus und dann die Prfsumme
   die aus einer XOR-Verknpfung der zuvor bertragenen Zeichen besteht. War die bertragung 
   fehlerhaft wird vom Controller mit einem "F" geantwortet und die Daten mssen erneut ber-
   tragen werden. Nach 3 fehlerhaften bertragungen wird abgebrochen. War die bertragung
   erfolgreich antwortet der Controller mit einem "O".
*/
char getRomCodes(void) {
	unsigned char i, buffer[82], check, errcount = 0;
	cli();
	// uputs("Fertig zum Empfang der Daten...\n\r");
	uputs("R");
	do {
		check = 0;
		for (i = 0; i <= 81; i++) {			
			buffer[i] = uread();		            				// Zeichen lesen
			if (i < 81) check ^= buffer[i];						// Prfsummesparversion (einfache XOR Verknpfung)
		}
		if (check != buffer[81]) {
			uputs("F");  											// Fehlerhafte bertragung melden
			errcount++;
		}
	} while ((check != buffer[81]) && (errcount < 3)); 
	if (errcount >= 3)
		return -1;
	uputs("O");														// Erfolgreiche bertragung melden
	// Daten ins EEPROM schreiben
	eeprom_write_block(&buffer, &ee_w1_romCode, MAXSENSORS * 8);
	eeprom_write_byte(&ee_w1_num_sensors, buffer[80]);
	return 0;
}

