#ifndef _main_h_
#define _main_h_

#include <avr/io.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
#include <avr/delay.h>    				// fr Zeitverzgerung
#include <stdlib.h>
#include <stdio.h>
#include <avr/eeprom.h>

#include "uart.h"
#include "onewire.h"

#define XTAL		4194304L

#define BAUD		4800
#define bauddivider	(unsigned int)(1.0 * XTAL / BAUD / 16 - 0.5)

#define uchar unsigned char
#define uint unsigned int
#define bit uchar
#define idata
#define code

#ifndef EEMEM
#define EEMEM  __attribute__ ((section (".eeprom")))
#endif

#define W1DDR	DDRC					// Datenrichtungsregister fr 1-Wire
#define W1PORT	PORTC					// Port fr den 1-Wire Pin
#define W1TXD	PC0						// Pin fr 1-Wire Transmit
#define w1PIN	PINC					// Pin fr 1-Wire Receive

#endif

