#ifndef _onewire_h_
#define _onewire_h_

#define MATCH_ROM	0x55
#define SKIP_ROM	0xCC
#define	SEARCH_ROM	0xF0

#define READ_ROM	0x33

#define CONVERT_T	0x44		// DS1820 commands
#define READ		0xBE
#define WRITE		0x4E
#define EE_WRITE	0x48
#define EE_RECALL	0xB8

#define	SEARCH_FIRST	0xFF		// start new search
#define	PRESENCE_ERR	0xFF
#define	DATA_ERR	0xFE
#define LAST_DEVICE	0x00		// last device found

#define W1DDR	DDRC					// Datenrichtungsregister fr 1-Wire
#define W1PORT	PORTC					// Port fr den 1-Wire Pin
#define W1TXD	PC0						// Pin fr 1-Wire Transmit
#define w1PIN	PINC					// Pin fr 1-Wire Receive

void wire_send_byte(unsigned char sbyte);
unsigned char wire_read_byte(void);
unsigned char wire_master_reset(void);
int wire_read_rom(unsigned char *ptrData);
int wire_meas_one(void);
int wire_meas_serial(unsigned char *serial);

#endif
