// func_mysql.c
// Funktionen zum ansprechen der MySQL Datenbank

#include "func_mysql.h"
#include <time.h>
#include <stdio.h>
#include "/usr/include/mysql/mysql.h"

int mysql_connect(const char *DBHost, const char *DBUser, const char *DBPassword, const char *DBName) {
	int mError;
	mysql_init(&mDB);
	mConnection = mysql_real_connect(&mDB, DBHost, DBUser, DBPassword, DBName, 0, 0, 0);
	if (mConnection == NULL) {
		fprintf(stderr, "Es konnte keine Verbindung zur Datenbank hergestellt werden: %s\n", mysql_error(&mDB));
		return 1;
	}
	else {
		fprintf(stdout, "Verbindung zur Datenbank %s hergestellt!\n", DBName);	
	}
	return 0;
}

int mysql_disconnect(void)
{
	mysql_close(mConnection);
	return 0;
}

int mysql_insert_value(int id, double messwert){
	// Messwert und Zeitstempel in Datenbank schreiben
	char eingabe[30];
	int i,  size=0;
	char *str[7], *query;
	char *ptr;
	struct tm *systime;
	time_t sec;
	time(&sec);
	systime = localtime (&sec);
	/* Anfragestring erstellen */
	str[0] = "INSERT INTO messdaten (zeitstempel, messID, messwert) VALUES ('";
	strcpy(eingabe, "");
	strftime(eingabe, 30, "%Y-%m-%d %H:%M:%S", systime);  // Zeitstempel im SQL Format "2005-03-01 00:00:00"
	str[1] =(char *) malloc(strlen(eingabe)+1);
	strcpy(str[1], eingabe);
	str[2] = "', ";
	strcpy(eingabe, "");
	sprintf(eingabe, "%d", id);
	str[3] =(char *) malloc(strlen(eingabe)+1);
	strcpy(str[3], eingabe);
	str[4] = ", ";	
	strcpy(eingabe, "");
	sprintf(eingabe, "%f", messwert);
	str[5] =(char *) malloc(strlen(eingabe)+1);
	strcpy(str[5], eingabe);
	str[6] = ")";
	for(i = 0; i < 7; i++)
		size+=strlen(str[i]);
	/* Speicherplatz fr den Anfragestring */
	query =(char *) malloc(size + 1);
	strcpy(query, str[0]);
	for(i = 1; i < 7; i++)
		strcat(query, str[i]);	  
	/* Anfrage an den Datenbankserver */
	// printf("Anfragestring: %s\n", query);
	mysql_query(mConnection, query);
	mysql_check_error();
	free(str[1]);
	free(str[3]);
	free(str[5]);
	free(query);
	return 0;
}

int mysql_check_error(void) {
	if (mysql_errno(mConnection) != 0) {
		fprintf(stderr, "MySQL Fehler: %u (%s)\n",mysql_errno (mConnection), mysql_error (mConnection));
		return 1;
	}
	return 0;
}

int mysql_db_erstellen(const char *DBHost, const char *DBUser, const char *DBPassword, const char *DBName, struct str_conf_data * cdata) {
	int error = 0, i;
	char query[218], string[10];
	char *create_string_1 = "CREATE TABLE messinfos("\
		"messID INT PRIMARY KEY NOT NULL,"\
		"messName VARCHAR(128) NOT NULL default '',"\
		"messEinheit VARCHAR(10) NOT NULL default '',"\
		"messWireID VARCHAR(16) NOT NULL default '')";
	char *create_string_2 = "CREATE TABLE messdaten("\
		"zeitstempel DATETIME NOT NULL, "\
		"messID INT,"\
		"messwert DOUBLE NOT NULL, 	"\
		"PRIMARY KEY (zeitstempel, messID))";
	
	if (mysql_connect(DBHost, DBUser, DBPassword, NULL )) {
		return 1;
	}
	// Prfen ob DB schon existiert
	strcpy(query, "");
	strcpy(query, "USE ");
	strncat(query, DBName, 200);
	mysql_query(mConnection, query);
	if (mysql_errno (mConnection) != 1049) { // Fehler 1049 = Unknown database
		printf("\nFehler: Eine Datenbank mit dem Namen '%s' existiert bereits.\n\n", DBName);
		mysql_disconnect();
		return 1;
	}
	strcpy(query, "");
	strcpy(query, "CREATE DATABASE ");
	strncat(query, DBName, 200);
	mysql_query(mConnection, query);
	error += mysql_check_error();	
	
	strcpy(query, "");
	strcpy(query, "USE ");
	strncat(query, DBName, 200);
	mysql_query(mConnection, query);	
	
	mysql_query(mConnection, create_string_1);	
	error += mysql_check_error();
	
	mysql_query(mConnection, create_string_2);	
	error += mysql_check_error();
	
	for (i = 0; i <= 9; i++) {
		strcpy(query, "");
		strcat(query, "INSERT INTO messinfos VALUES (");
		sprintf(string, "%i", i);
		strcat(query, string);
		strcat(query, ", '");
		strncat(query, cdata->SensorName[i], 127);
		strcat(query, "', 'C', '");
		strncat(query, cdata->SensorID[i], 16);
		strcat(query, "')");
		mysql_query(mConnection, query);	
		error += mysql_check_error();
	}	
	if (!(error)){ 
		printf("\nDatenbank erfolgreich angelegt :-)\n");
		mysql_disconnect();
		return 0;
	}
	else 
		printf("\nDatenbank konnte nicht oder nicht vollstndig angelegt werden!\n");
		mysql_disconnect();
		return 1;
}


