/*///////////////////////////////////////////////////////////////////////////////////////////
// Datenabfrage ber serielle Schnittstelle und speichern der Daten in eine MySQL-Datenbank
// Dateiname:   mcmysql.c
// Headerfile:  mcmysql.h
// Autor: Thomas Wiens
// Datum: 31.12.2005
// Kurzbeschreibung:
// Das Programm fragt ber die serielle Schnittstelle zyklisch Daten aus
// einem angeschlossenen Mikrocontroller ab. Bei der Abfrage wird der zu 
// messende Kanal ausgegeben (1-10). Der Controller antwortet mit dem Messwert,
// der daraufhin in einer MySQL-Datenbank abgespeichert wird.
// Einstellungen lassen sich in einer zugehrigen mcmysql.conf vornehmen.
// 

 Zugehrige Datenbank:
 
CREATE DATABASE messDB;

USE messDB;

CREATE TABLE messinfos(
	messID INT PRIMARY KEY NOT NULL,
	messName VARCHAR(128) NOT NULL default '',
	messEinheit VARCHAR(10) NOT NULL default '',
	messWireID VARCHAR(16) NOT NULL default ''	
);

CREATE TABLE messdaten(
	zeitstempel DATETIME NOT NULL, 
	messID INT,
 	messwert DOUBLE NOT NULL, 	
	PRIMARY KEY (zeitstempel, messID)
);
///////////////////////////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include <time.h>
#include "func_mysql.h"
#include "messlib.h"
#include "confuse.h"
#include "mcmysql.h"

int main(int argc, char *argv[]) {
	int wert, i;
	int error;
	char dmm_string[6], kanal, *c;
	int dmm_fd;
	double temperatur;
	time_t jetzt;
	struct tm *systime;
	struct str_conf_data conf_data = {NULL};	
	int SensorsActive, Messzyklus;
	char *SerialPort = NULL;
	char *MYSQLUsername = NULL, *MYSQLPassword = NULL, *MYSQLDatenbank = NULL, *MYSQLHostname = NULL;
   
	char idarray[10 * 16 + 1];  				// Array fr Sensor-IDs
// Daten aus Config-Datei
    cfg_opt_t opts[] = {
        CFG_SIMPLE_INT("SensorsActive", &SensorsActive),
        CFG_SIMPLE_STR("SerialPort", &SerialPort),
        CFG_SIMPLE_INT("Messzyklus", &Messzyklus),
        CFG_SIMPLE_STR("SensorID0", &conf_data.SensorID[0]),
		CFG_SIMPLE_STR("SensorID1", &conf_data.SensorID[1]),
		CFG_SIMPLE_STR("SensorID2", &conf_data.SensorID[2]),
		CFG_SIMPLE_STR("SensorID3", &conf_data.SensorID[3]),
		CFG_SIMPLE_STR("SensorID4", &conf_data.SensorID[4]),
		CFG_SIMPLE_STR("SensorID5", &conf_data.SensorID[5]),
		CFG_SIMPLE_STR("SensorID6", &conf_data.SensorID[6]),
		CFG_SIMPLE_STR("SensorID7", &conf_data.SensorID[7]),
		CFG_SIMPLE_STR("SensorID8", &conf_data.SensorID[8]),
		CFG_SIMPLE_STR("SensorID9", &conf_data.SensorID[9]),
        CFG_SIMPLE_STR("SensorName0", &conf_data.SensorName[0]),
		CFG_SIMPLE_STR("SensorName1", &conf_data.SensorName[1]),
		CFG_SIMPLE_STR("SensorName2", &conf_data.SensorName[2]),
		CFG_SIMPLE_STR("SensorName3", &conf_data.SensorName[3]),
		CFG_SIMPLE_STR("SensorName4", &conf_data.SensorName[4]),
		CFG_SIMPLE_STR("SensorName5", &conf_data.SensorName[5]),
		CFG_SIMPLE_STR("SensorName6", &conf_data.SensorName[6]),
		CFG_SIMPLE_STR("SensorName7", &conf_data.SensorName[7]),
		CFG_SIMPLE_STR("SensorName8", &conf_data.SensorName[8]),
		CFG_SIMPLE_STR("SensorName9", &conf_data.SensorName[9]),		
        CFG_SIMPLE_STR("MYSQLUsername", &MYSQLUsername),
		CFG_SIMPLE_STR("MYSQLPassword", &MYSQLPassword),
		CFG_SIMPLE_STR("MYSQLDatenbank", &MYSQLDatenbank),
		CFG_SIMPLE_STR("MYSQLHostname", &MYSQLHostname),
        CFG_END()
    }; 
	cfg_t *cfg;
	cfg = cfg_init(opts, 0);
	cfg_parse(cfg, "mcmysql.conf");    
	

// Kommandozeilenparameter auswerten
	if(argc == 1 || getopt(argv[1],"h") == TRUE ) {
		show_help();
		exit(0);
	}
	else if(getopt(argv[1],"v") == TRUE) {
         printf("Version 1.0\n");
         exit(0);
	}
	else if (getopt(argv[1],"r") == TRUE) {
		read_wire_ids(SerialPort);
		exit(0);
	}
	else if (getopt(argv[1],"i") == TRUE) {
		// Array der IDs erzeugen
		strcpy(idarray, "");
		for (i = 0; i <= 9; i++) {
			strncat(idarray, conf_data.SensorID[i], 16);  // Auf 16 Zeichen Lnge begrenzen
		}
		// IDs in den Controller bertragen
		write_com_codes(idarray, SerialPort, (unsigned char) SensorsActive);
		exit(0);
	}
// Datenbank anlegen
	else if (getopt(argv[1],"d") == TRUE) {
		mysql_db_erstellen(MYSQLHostname, MYSQLUsername, MYSQLPassword, MYSQLDatenbank, &conf_data);
		exit(0);
	}
// Alle anderen Optionen zeigen die Hilfe
	else if (getopt(argv[1],"z") == FALSE) {
		show_help();
		exit(0);
	}

// Zyklisches Programm 
	if ((dmm_fd=init_dmm(SerialPort))<1) {
		fprintf(stderr,"Fehler beim Initialisieren der seriellen Schnittstelle!\n");
		exit(-1);
	}
	
	if (mysql_connect(MYSQLHostname, MYSQLUsername, MYSQLPassword, MYSQLDatenbank)) {
		exit(-1);
	}
	
	for (;;) {
		time(&jetzt);
		systime = localtime(&jetzt);
		c = asctime(systime);
		printf("\n%s", c);
			for (kanal = '1'; kanal <= SensorsActive + 48; kanal++) {
				if (read_dmm(dmm_fd,dmm_string, &kanal)==1) {
					dmm_string[6]='\0';
					sscanf(dmm_string,"%i",&wert);
					temperatur = (double)wert / 10.0;					
					printf("\tSensor: %i Temperatur: %2.2f C \n", kanal - 48, temperatur);
					mysql_insert_value( kanal - 49, temperatur);
				}
				else {
					fprintf(stderr,"Fehler beim Lesen von der seriellen Schnittstelle !\n");
				}	  
			}
		sleep(Messzyklus);
   }
   mysql_disconnect();
   close_dmm(dmm_fd);
   return 0;
}


void show_help(void) {
	printf("\nProgrammaufruf: mcmysql [OPTION]\n"\
		"\t-z  Programm liest zyklisch die Temperaturen aus und schreibt sie in die Datenbank\n"\
		"\t-r  Auslesen der 1-Wire ID eines angeschlossenen Sensors\n"\
		"\t-i  Initialisieren des Controllers mit den 1-Wire IDs\n"\
		"\t-d  Anlegen einer neuen MySQL-Datenbank mit den Daten aus der conf-Datei\n"\
		"\t-v  Versionsnummer\n"\
		"\t-h  Dieser Text\n\n");
}

int getopt(char *argument,char *option)
{
	if( argument[0]=='-' && argument[1]==option[0])
		return TRUE;
	return FALSE;
}

int read_wire_ids(char *port) {
	int fd, i, nbyte;
	char buf[18];
	if ((fd = init_dmm(port)) < 1) {
		fprintf(stderr,"Fehler beim Initialisieren der seriellen Schnittstelle!\n");
		return(-1);
	}
	write(fd, "R", 1);						// Anfrage zum Senden der Wire ID senden
    i=-1;
    do {
       i++;
       nbyte=read(fd, &buf[i], 1);			// Ein Zeichen lesen
       if(nbyte!=1){            			// Gibt es kein Zeichen -> TIMEOUT
         fprintf(stderr,"TIMEOUT !\n");
         return (-1);
       }
    } while ((buf[i]!='\n') && (i < 17)); 
	if (buf[i] == '\n')
		buf[i] = '\0';
	printf("\nGelesene ID: %s\n\n", buf);
	close_dmm(fd);
	return 0;
}

unsigned char c_to_uchar(char z) {
	if (z >= '0' && z <= '9')
		return (z - 48);
	else if (z >= 'A' && z <='F')
		return (z - 55);
	else
		return 0;		
}

unsigned char hex_to_uchar(char left, char right) {
	return (c_to_uchar(left) * 16 + c_to_uchar(right));
}

int write_com_codes(char *ids, char *port, unsigned char numsensors) {
	int i, fd, nbyte;
	unsigned char zeichen, check, errcount = 0, data_ok = FALSE;
	char buf;
	if ((fd = init_dmm(port))<1) {
		fprintf(stderr,"Fehler beim Initialisieren der seriellen Schnittstelle!\n");
		return(-1);
	}
	write(fd, "W", 1);			// Anfrage zum Schreiben der IDs senden
	nbyte=read(fd, &buf, 1);	// Auf Antwort warten
	if(nbyte!=1){             	// Gibt es kein Zeichen -> TIMEOUT
		fprintf(stderr,"TIMEOUT !\n");
		return (-1);
	}
	else if (buf != 'R') {
		fprintf(stderr, "Controller falsch geantwortet!\n");
		return (-1);
	}
	printf("\nbertrage Daten\n");	
	do {	
		check = 0;
		buf = 0;
		for (i = 0; i < 80; i++) {
			zeichen = hex_to_uchar(ids[2 * i], ids[2 * i + 1]); // Zwei Characters zu einem Wert
			check ^= zeichen;
			// printf("Nr: %i Wert: %i\t\t", i, zeichen);
			printf(".");
			write(fd, &zeichen, 1);
		}
		check ^= numsensors;
		write(fd, &numsensors, 1);
		write(fd, &check, 1);
		nbyte=read(fd, &buf, 1);
			
		if ((nbyte == 0) || (buf != 'O')) {
			data_ok = FALSE;
			errcount++;	
			printf("\nbertragung war fehlerhaft, wiederhole\n");	
		}
		else {
			printf("\nbertragung erfolgreich beendet\n\n");	
			data_ok = TRUE;		
		}
	} while (!(data_ok) && errcount < 3);	
	close_dmm(fd);	
	return 0;
}

