// http://www.linux-magazin.de/Artikel/ausgabe/1999/08/Messen/messen.html
// Angepasst an Microcontrollerdaten

#include <fcntl.h>
#include <sys/termios.h>
#include <sys/ioctl.h>
#include <stdio.h>

#define BAUDRATE B4800

/* Funktion zum Initialisieren und ffnen des Ports/Devices */
int init_dmm(const char * device) {                                 
  int fd;
  int modelines=0;
  struct termios settings;

/*ffnen und berprfen des Filedeskriptors*/
  fd=open(device,O_RDWR|O_NOCTTY);
  if(fd==-1) {
    fprintf(stderr,"Das Device %s kann nicht geffnet werden!\n",device);
    return(fd);
  }
/*Prfe ob Filedeskriptor zu einem Terminal gehrt*/
  if(!isatty(fd)) {
    fprintf(stderr,"Das Device %s ist kein Terminal-Device !\n",device);
    return(-1);
  }
  

/*Setzen der Inputflags*/
  settings.c_iflag=   IGNBRK  /*Ignoriere BREAKS beim Input*/
                    | IGNPAR; /*Keine Paritt*/


/*Setzen der Outputflags*/
  settings.c_oflag=0;         /*Keine besonderen Angaben ntig*/


/*Setzen der Controlflags*/
  settings.c_cflag= CLOCAL ;  /*Ignoriere Modemstatus, lokaler Anschlu*/

  settings.c_cflag &= ~PARENB;
  settings.c_cflag &= ~CSTOPB;  // Ein Stopbit
  settings.c_cflag &= ~CRTSCTS; // Hardware Flusskontrolle ausschalten
  settings.c_cflag &= ~CSIZE;   // Character-Size Bits ausmaskieren
  settings.c_cflag |= CS8;      // No parity (8N1):
  settings.c_cflag |= CREAD;    // Zeichen knnen gelesen werden

/*Setzen der lokalen Flags*/
  settings.c_lflag=0;         /*Keine besonderen Angaben ntig*/  

/*Festlegen der maximalen Zeit, welche beim Lesen gewartet werden soll*/
  settings.c_cc[VTIME]=50;  /*Gerte mit hheren 
                              bertragungsgeschwindigkeiten */
                            /*knnen kleinere Werte erhalten */


/*Festlegen der minimalen Anzahl der zu lesenden Bytes -> Fall 3*/
/* Sobald ein Byte anliegt liefert read dieses.
   Wenn die Zeit TIME seit dem Aufruf von read verstrichen ist liefert read 0 zurck. */
  settings.c_cc[VMIN]=0;
  
/*Definieren der bertragungsgeschwindigkeit */
  if(cfsetspeed(&settings,B4800 )!=0) {
      fprintf(stderr,"Fehler beim Setzen der bertragungsgeschwindigkeit auf %s !\n"
             ,device);
      return(-1);
    }

/*bertragung der Einstellungen an die Schnittstelle*/
  if(tcsetattr(fd,TCSANOW,&settings)==-1) {
      fprintf(stderr,"Fehler beim Setzen der Terminalattribute auf  %s !\n",device);
      return(-1);
    }

/*Lesen der IO-Control-Parameter*/
  if(ioctl(fd,TIOCMGET,&modelines)==-1) {
      fprintf(stderr,"Fehler bei ioctl TIOCMGET auf  %s!\n",device);
      return(-1);
    }
  return(fd);
} 

/* Funktion zum Lesen eines Mewertes */
int read_dmm(int fd,char buf[14], const char * channel) {
  int i;
  int nbyte;
    write(fd, channel, 1); /* Zu messenden Kanal auswhlen */
    i=-1;
    do{
       i++;
       nbyte=read(fd, &buf[i], 1); /*Lies ein Zeichen*/
       if(nbyte!=1){             /*Gibt es kein Zeichen -> TIMEOUT*/
         fprintf(stderr,"TIMEOUT ! Gelesen: %d\n", nbyte);
         return (-1);
       }
    } while ((buf[i]!='\n') && (i < 6)); 
	if (buf[i] == '\n')
		buf[i] = '\0';
  /*Lies maximal 7 Zeichen (-1000\n) */  
  return(1);
}

/*Funktion zum Schlieen des Devices*/
int close_dmm(int fd) {
  return(close(fd));
}

