#!/usr/bin/perl -w
use CGI qw(:standard);
use DBI;

$cgi = CGI -> new();

print "Content-Type: text/html\n\n";

# Verbindungskonfiguration
$driver = 'mysql';
$database = 'neueDB';
$host = 'localhost';
$port = '';
$uid = 'root';
$pwd = 'debbi4min';

# Parameter entgegennehmen
$messname = $cgi->param('messname');
$monat = $cgi->param('monat');
$tag = $cgi->param('tag');
$stunde = $cgi->param('stunde');
$dauer = $cgi->param('dauer');

# Verbindungsaufbau
$datasource = "DBI:$driver:$database:$host:$port";
$dbh = DBI->connect($datasource, $uid, $pwd)
		or die "Fehler beim Verbindungsaufbau!";

# Anfangs- und Endzeitstempel im SQL-Format zusammensetzen
$jahr = "2006";

$beg_time = $jahr."-".$monat."-".$tag." ".$stunde.":00:00";
$end_std = $stunde + $dauer;

# Tagessprung
if($end_std >= 24) {
	$tag++;
	$end_std = $end_std -24;
	# Monatssprung (ohne Schaltjahrberechnung :-o )
	if($tag > 28) {
		if (($tag == 32 && ($monat == 1 || $monat == 3 || $monat == 5 || $monat == 7 || $monat == 8 || $monat == 10 || $monat == 12)) ||
			($tag == 31 && ($monat == 4 || $monat == 6 || $monat == 9 || $monat == 11 )) ||
			($tag == 29 && ($monat == 2))) {
				$tag = 1;
				$monat++;
				if ($monat == 12) {
					$monat = 1;
					$jahr++;
				}
		}
	}
}

$end_time = $jahr."-".$monat."-".$tag." ".$end_std.":00:00";

# Messwerte auslesen
$sth = $dbh->prepare("SELECT d.Zeitstempel, d.messwert FROM messdaten d, messinfos i WHERE d.messID = i.messID AND i.messName = '$messname' 
		AND d.zeitstempel >= '$beg_time' AND d.zeitstempel <= '$end_time'")
		or die "Fehlerhafte SQL Anweisung!";
$sth->execute
		or die "Die Anweisung kann nicht ausgefhrt werden!";
		
# HTML-Dokument ausgeben
print "<html>
	<head>
	<title>Messdatenauswertung</title>
	</head>
	<body>
	<h1>Messung: $messname</h1>";


print("Zeitraum von: $beg_time bis $end_time<br>");


# Ergebnistabelle auslesen und in Datei schreiben
$data_ok = 0;
open(DATEI, ">messung.dat") || die "$!";
select(DATEI);
while (@row = $sth->fetchrow_array) {
	$data_ok = 1;
	$uhrzeit = $row[0];
	# Leerzeichen durch Unterstrich ersetzen
	$uhrzeit =~ s/ /_/g;
	$messwert = $row[1];
	print("$uhrzeit\t$messwert\n");
	
}
close(DATEI);
select(STDOUT);

if ($data_ok == 0) {
	print "Fehler: Fuer den angebenen Zeitraum existieren keine Daten!<br>";
}
# Gnuplot Datei schreiben

$bildname = $messname."_".$jahr."_".$monat."_".$tag."_".$stunde."_".$dauer.".png";
# Leerzeichen und Umlaute entfernen 
$bildname =~ s/|||| //gi;

if ($data_ok == 1) {
	open(DATEI, ">show.gp") || die "$!";
	select(DATEI);
	print ("set term png large
set size 1.5,1.5
set output '/var/www/$bildname'
set title \"Messung: $messname\"
set xlabel \"Datum\\nUhrzeit\"
set ylabel \"Temperatur [C]\"
set xdata time
set timefmt \"%Y-%m-%d_%H:%M:%S\"
set format x \"%d.%m\\n%H:%M\"
set grid
plot 'messung.dat' using 1:2 with lines\n");
	close(DATEI);
	select(STDOUT);	
	# Gnuplot aufrufen und Bild erzeugen
	system("/usr/bin/gnuplot show.gp");
	# Bild anzeigen
	print ("<img src=\"../$bildname\">");
}

# Zurckbutton
print ("<p><a href=\"mcauswert.pl\">Neue Auswahl</a></p>");
print ("<p><a href=\"/messmenu.html\">Hauptmenue</a></p>");

# Aufrumen
$sth->finish;
$dbh->disconnect;

# HTML-Dokument abschlieen
print ("</body></html>");


