//
//  $Id: lpc214x.h 346 2008-12-04 15:17:52Z jcw $
//  $Revision: 346 $
//  $Author: jcw $
//  $Date: 2008-12-04 10:17:52 -0500 (Thu, 04 Dec 2008) $
//  $HeadURL: http://tinymicros.com/svn_public/arm/lpc2148_demo/trunk/lpc214x.h $
//

//
//  Using typedef'ed structures instead of #define's would be much cleaner.  However,
//  it's a damn lot of work to define them all, and there were a bunch of #defines
//  to start with, so I just expanded them.
//

#ifndef _LPC214X_H_
#define _LPC214X_H_

#include "sysdefs.h"

/*##############################################################################
## MISC
##############################################################################*/

/* Constants for data to put in IRQ/FIQ Exception Vectors */
#define VECTDATA_IRQ  0xe51ffff0  /* LDR PC,[PC,#-0xFF0] */
#define VECTDATA_FIQ  /* __TODO */


/*##############################################################################
## VECTORED INTERRUPT CONTROLLER
##############################################################################*/

#define VIC_IRQStatus           (*(pREG32 (0xfffff000)))
#define VIC_FIQStatus           (*(pREG32 (0xfffff004)))
#define VIC_RawIntr             (*(pREG32 (0xfffff008)))
#define VIC_IntSelect           (*(pREG32 (0xfffff00c)))
#define VIC_IntEnable           (*(pREG32 (0xfffff010)))
#define VIC_IntEnClr            (*(pREG32 (0xfffff014)))
#define VIC_SoftInt             (*(pREG32 (0xfffff018)))
#define VIC_SoftIntClear        (*(pREG32 (0xfffff01c)))
#define VIC_Protection          (*(pREG32 (0xfffff020)))
#define VIC_VectAddr            (*(pREG32 (0xfffff030)))
#define VIC_DefVectAddr         (*(pREG32 (0xfffff034)))

#define VIC_VectAddr0           (*(pREG32 (0xfffff100)))
#define VIC_VectAddr1           (*(pREG32 (0xfffff104)))
#define VIC_VectAddr2           (*(pREG32 (0xfffff108)))
#define VIC_VectAddr3           (*(pREG32 (0xfffff10c)))
#define VIC_VectAddr4           (*(pREG32 (0xfffff110)))
#define VIC_VectAddr5           (*(pREG32 (0xfffff114)))
#define VIC_VectAddr6           (*(pREG32 (0xfffff118)))
#define VIC_VectAddr7           (*(pREG32 (0xfffff11c)))
#define VIC_VectAddr8           (*(pREG32 (0xfffff120)))
#define VIC_VectAddr9           (*(pREG32 (0xfffff124)))
#define VIC_VectAddr10          (*(pREG32 (0xfffff128)))
#define VIC_VectAddr11          (*(pREG32 (0xfffff12c)))
#define VIC_VectAddr12          (*(pREG32 (0xfffff130)))
#define VIC_VectAddr13          (*(pREG32 (0xfffff134)))
#define VIC_VectAddr14          (*(pREG32 (0xfffff138)))
#define VIC_VectAddr15          (*(pREG32 (0xfffff13c)))

#define VIC_VectCntl0           (*(pREG32 (0xfffff200)))
#define VIC_VectCntl1           (*(pREG32 (0xfffff204)))
#define VIC_VectCntl2           (*(pREG32 (0xfffff208)))
#define VIC_VectCntl3           (*(pREG32 (0xfffff20c)))
#define VIC_VectCntl4           (*(pREG32 (0xfffff210)))
#define VIC_VectCntl5           (*(pREG32 (0xfffff214)))
#define VIC_VectCntl6           (*(pREG32 (0xfffff218)))
#define VIC_VectCntl7           (*(pREG32 (0xfffff21c)))
#define VIC_VectCntl8           (*(pREG32 (0xfffff220)))
#define VIC_VectCntl9           (*(pREG32 (0xfffff224)))
#define VIC_VectCntl10          (*(pREG32 (0xfffff228)))
#define VIC_VectCntl11          (*(pREG32 (0xfffff22c)))
#define VIC_VectCntl12          (*(pREG32 (0xfffff230)))
#define VIC_VectCntl13          (*(pREG32 (0xfffff234)))
#define VIC_VectCntl14          (*(pREG32 (0xfffff238)))
#define VIC_VectCntl15          (*(pREG32 (0xfffff23c)))

#define VIC_SoftInt_WDT         (0x00000001)
#define VIC_SoftInt_ARMCore0    (0x00000004)
#define VIC_SoftInt_ARMCore1    (0x00000008)
#define VIC_SoftInt_Timer0      (0x00000010)
#define VIC_SoftInt_Timer1      (0x00000020)
#define VIC_SoftInt_UART0       (0x00000040)
#define VIC_SoftInt_UART1       (0x00000080)
#define VIC_SoftInt_PWM0        (0x00000100)
#define VIC_SoftInt_I2C0        (0x00000200)
#define VIC_SoftInt_SPI0        (0x00000400)
#define VIC_SoftInt_SPI1        (0x00000800)
#define VIC_SoftInt_SSP         (0x00000800)
#define VIC_SoftInt_PLL         (0x00001000)
#define VIC_SoftInt_RTC         (0x00002000)
#define VIC_SoftInt_EINT0       (0x00004000)
#define VIC_SoftInt_EINT1       (0x00008000)
#define VIC_SoftInt_EINT2       (0x00010000)
#define VIC_SoftInt_EINT3       (0x00020000)
#define VIC_SoftInt_AD0         (0x00040000)
#define VIC_SoftInt_I2C1        (0x00080000)
#define VIC_SoftInt_BOD         (0x00100000)
#define VIC_SoftInt_AD1         (0x00200000)
#define VIC_SoftInt_USB         (0x00400000)
#define VIC_SoftInt_MASK        (0x007ffffd)

#define VIC_SoftIntClr_WDT      (0x00000001)
#define VIC_SoftIntClr_ARMCore0 (0x00000004)
#define VIC_SoftIntClr_ARMCore1 (0x00000008)
#define VIC_SoftIntClr_Timer0   (0x00000010)
#define VIC_SoftIntClr_Timer1   (0x00000020)
#define VIC_SoftIntClr_UART0    (0x00000040)
#define VIC_SoftIntClr_UART1    (0x00000080)
#define VIC_SoftIntClr_PWM0     (0x00000100)
#define VIC_SoftIntClr_I2C0     (0x00000200)
#define VIC_SoftIntClr_SPI0     (0x00000400)
#define VIC_SoftIntClr_SPI1     (0x00000800)
#define VIC_SoftIntClr_SSP      (0x00000800)
#define VIC_SoftIntClr_PLL      (0x00001000)
#define VIC_SoftIntClr_RTC      (0x00002000)
#define VIC_SoftIntClr_EINT0    (0x00004000)
#define VIC_SoftIntClr_EINT1    (0x00008000)
#define VIC_SoftIntClr_EINT2    (0x00010000)
#define VIC_SoftIntClr_EINT3    (0x00020000)
#define VIC_SoftIntClr_AD0      (0x00040000)
#define VIC_SoftIntClr_I2C1     (0x00080000)
#define VIC_SoftIntClr_BOD      (0x00100000)
#define VIC_SoftIntClr_AD1      (0x00200000)
#define VIC_SoftIntClr_USB      (0x00400000)
#define VIC_SoftIntClr_MASK     (0x007ffffd)

#define VIC_RawIntr_WDT         (0x00000001)
#define VIC_RawIntr_ARMCore0    (0x00000004)
#define VIC_RawIntr_ARMCore1    (0x00000008)
#define VIC_RawIntr_Timer0      (0x00000010)
#define VIC_RawIntr_Timer1      (0x00000020)
#define VIC_RawIntr_UART0       (0x00000040)
#define VIC_RawIntr_UART1       (0x00000080)
#define VIC_RawIntr_PWM0        (0x00000100)
#define VIC_RawIntr_I2C0        (0x00000200)
#define VIC_RawIntr_SPI0        (0x00000400)
#define VIC_RawIntr_SPI1        (0x00000800)
#define VIC_RawIntr_SSP         (0x00000800)
#define VIC_RawIntr_PLL         (0x00001000)
#define VIC_RawIntr_RTC         (0x00002000)
#define VIC_RawIntr_EINT0       (0x00004000)
#define VIC_RawIntr_EINT1       (0x00008000)
#define VIC_RawIntr_EINT2       (0x00010000)
#define VIC_RawIntr_EINT3       (0x00020000)
#define VIC_RawIntr_AD0         (0x00040000)
#define VIC_RawIntr_I2C1        (0x00080000)
#define VIC_RawIntr_BOD         (0x00100000)
#define VIC_RawIntr_AD1         (0x00200000)
#define VIC_RawIntr_USB         (0x00400000)
#define VIC_RawIntr_MASK        (0x007ffffd)

#define VIC_IntEnable_WDT       (0x00000001)
#define VIC_IntEnable_ARMCore0  (0x00000004)
#define VIC_IntEnable_ARMCore1  (0x00000008)
#define VIC_IntEnable_Timer0    (0x00000010)
#define VIC_IntEnable_Timer1    (0x00000020)
#define VIC_IntEnable_UART0     (0x00000040)
#define VIC_IntEnable_UART1     (0x00000080)
#define VIC_IntEnable_PWM0      (0x00000100)
#define VIC_IntEnable_I2C0      (0x00000200)
#define VIC_IntEnable_SPI0      (0x00000400)
#define VIC_IntEnable_SPI1      (0x00000800)
#define VIC_IntEnable_SSP       (0x00000800)
#define VIC_IntEnable_PLL       (0x00001000)
#define VIC_IntEnable_RTC       (0x00002000)
#define VIC_IntEnable_EINT0     (0x00004000)
#define VIC_IntEnable_EINT1     (0x00008000)
#define VIC_IntEnable_EINT2     (0x00010000)
#define VIC_IntEnable_EINT3     (0x00020000)
#define VIC_IntEnable_AD0       (0x00040000)
#define VIC_IntEnable_I2C1      (0x00080000)
#define VIC_IntEnable_BOD       (0x00100000)
#define VIC_IntEnable_AD1       (0x00200000)
#define VIC_IntEnable_USB       (0x00400000)
#define VIC_IntEnable_MASK      (0x007ffffd)

#define VIC_IntEnClr_WDT        (0x00000001)
#define VIC_IntEnClr_ARMCore0   (0x00000004)
#define VIC_IntEnClr_ARMCore1   (0x00000008)
#define VIC_IntEnClr_Timer0     (0x00000010)
#define VIC_IntEnClr_Timer1     (0x00000020)
#define VIC_IntEnClr_UART0      (0x00000040)
#define VIC_IntEnClr_UART1      (0x00000080)
#define VIC_IntEnClr_PWM0       (0x00000100)
#define VIC_IntEnClr_I2C0       (0x00000200)
#define VIC_IntEnClr_SPI0       (0x00000400)
#define VIC_IntEnClr_SPI1       (0x00000800)
#define VIC_IntEnClr_SSP        (0x00000800)
#define VIC_IntEnClr_PLL        (0x00001000)
#define VIC_IntEnClr_RTC        (0x00002000)
#define VIC_IntEnClr_EINT0      (0x00004000)
#define VIC_IntEnClr_EINT1      (0x00008000)
#define VIC_IntEnClr_EINT2      (0x00010000)
#define VIC_IntEnClr_EINT3      (0x00020000)
#define VIC_IntEnClr_AD0        (0x00040000)
#define VIC_IntEnClr_I2C1       (0x00080000)
#define VIC_IntEnClr_BOD        (0x00100000)
#define VIC_IntEnClr_AD1        (0x00200000)
#define VIC_IntEnClr_USB        (0x00400000)
#define VIC_IntEnClr_MASK       (0x007ffffd)

#define VIC_IntSelect_WDT       (0x00000001)
#define VIC_IntSelect_ARMCore0  (0x00000004)
#define VIC_IntSelect_ARMCore1  (0x00000008)
#define VIC_IntSelect_Timer0    (0x00000010)
#define VIC_IntSelect_Timer1    (0x00000020)
#define VIC_IntSelect_UART0     (0x00000040)
#define VIC_IntSelect_UART1     (0x00000080)
#define VIC_IntSelect_PWM0      (0x00000100)
#define VIC_IntSelect_I2C0      (0x00000200)
#define VIC_IntSelect_SPI0      (0x00000400)
#define VIC_IntSelect_SPI1      (0x00000800)
#define VIC_IntSelect_SSP       (0x00000800)
#define VIC_IntSelect_PLL       (0x00001000)
#define VIC_IntSelect_RTC       (0x00002000)
#define VIC_IntSelect_EINT0     (0x00004000)
#define VIC_IntSelect_EINT1     (0x00008000)
#define VIC_IntSelect_EINT2     (0x00010000)
#define VIC_IntSelect_EINT3     (0x00020000)
#define VIC_IntSelect_AD0       (0x00040000)
#define VIC_IntSelect_I2C1      (0x00080000)
#define VIC_IntSelect_BOD       (0x00100000)
#define VIC_IntSelect_AD1       (0x00200000)
#define VIC_IntSelect_USB       (0x00400000)
#define VIC_IntSelect_MASK      (0x007ffffd)

#define VIC_IRQStatus_WDT       (0x00000001)
#define VIC_IRQStatus_ARMCore0  (0x00000004)
#define VIC_IRQStatus_ARMCore1  (0x00000008)
#define VIC_IRQStatus_Timer0    (0x00000010)
#define VIC_IRQStatus_Timer1    (0x00000020)
#define VIC_IRQStatus_UART0     (0x00000040)
#define VIC_IRQStatus_UART1     (0x00000080)
#define VIC_IRQStatus_PWM0      (0x00000100)
#define VIC_IRQStatus_I2C0      (0x00000200)
#define VIC_IRQStatus_SPI0      (0x00000400)
#define VIC_IRQStatus_SPI1      (0x00000800)
#define VIC_IRQStatus_SSP       (0x00000800)
#define VIC_IRQStatus_PLL       (0x00001000)
#define VIC_IRQStatus_RTC       (0x00002000)
#define VIC_IRQStatus_EINT0     (0x00004000)
#define VIC_IRQStatus_EINT1     (0x00008000)
#define VIC_IRQStatus_EINT2     (0x00010000)
#define VIC_IRQStatus_EINT3     (0x00020000)
#define VIC_IRQStatus_AD0       (0x00040000)
#define VIC_IRQStatus_I2C1      (0x00080000)
#define VIC_IRQStatus_BOD       (0x00100000)
#define VIC_IRQStatus_AD1       (0x00200000)
#define VIC_IRQStatus_USB       (0x00400000)
#define VIC_IRQStatus_MASK      (0x007ffffd)

#define VIC_FIQStatus_WDT       (0x00000001)
#define VIC_FIQStatus_ARMCore0  (0x00000004)
#define VIC_FIQStatus_ARMCore1  (0x00000008)
#define VIC_FIQStatus_Timer0    (0x00000010)
#define VIC_FIQStatus_Timer1    (0x00000020)
#define VIC_FIQStatus_UART0     (0x00000040)
#define VIC_FIQStatus_UART1     (0x00000080)
#define VIC_FIQStatus_PWM0      (0x00000100)
#define VIC_FIQStatus_I2C0      (0x00000200)
#define VIC_FIQStatus_SPI0      (0x00000400)
#define VIC_FIQStatus_SPI1      (0x00000800)
#define VIC_FIQStatus_SSP       (0x00000800)
#define VIC_FIQStatus_PLL       (0x00001000)
#define VIC_FIQStatus_RTC       (0x00002000)
#define VIC_FIQStatus_EINT0     (0x00004000)
#define VIC_FIQStatus_EINT1     (0x00008000)
#define VIC_FIQStatus_EINT2     (0x00010000)
#define VIC_FIQStatus_EINT3     (0x00020000)
#define VIC_FIQStatus_AD0       (0x00040000)
#define VIC_FIQStatus_I2C1      (0x00080000)
#define VIC_FIQStatus_BOD       (0x00100000)
#define VIC_FIQStatus_AD1       (0x00200000)
#define VIC_FIQStatus_USB       (0x00400000)
#define VIC_FIQStatus_MASK      (0x007ffffd)

#define VIC_VectCntl_SLOTMASK   (0x0000001f)
#define VIC_VectCntl_ENABLE     (0x00000020)

#define VIC_Protection_ACCESS   (0x00000001)
#define VIC_Protection_MASK     (0x00000001)

#define VIC_Mask_WDT            (0x00000001)
#define VIC_Mask_RSVD           (0x00000002)
#define VIC_Mask_ARMCore0       (0x00000004)
#define VIC_Mask_ARMCore1       (0x00000008)
#define VIC_Mask_Timer0         (0x00000010)
#define VIC_Mask_Timer1         (0x00000020)
#define VIC_Mask_UART0          (0x00000040)
#define VIC_Mask_UART1          (0x00000080)
#define VIC_Mask_PWM0           (0x00000100)
#define VIC_Mask_I2C0           (0x00000200)
#define VIC_Mask_SPI0           (0x00000400)
#define VIC_Mask_SPI1           (0x00000800)
#define VIC_Mask_SSP            (0x00000800)
#define VIC_Mask_PLL            (0x00001000)
#define VIC_Mask_RTC            (0x00002000)
#define VIC_Mask_EINT0          (0x00004000)
#define VIC_Mask_EINT1          (0x00008000)
#define VIC_Mask_EINT2          (0x00010000)
#define VIC_Mask_EINT3          (0x00020000)
#define VIC_Mask_AD0            (0x00040000)
#define VIC_Mask_I2C1           (0x00080000)
#define VIC_Mask_BOD            (0x00100000)
#define VIC_Mask_AD1            (0x00200000)
#define VIC_Mask_USB            (0x00400000)
#define VIC_Mask_MASK           (0x007ffffd)

#define VIC_Channel_WDT         (0)
#define VIC_Channel_RSVD        (1)
#define VIC_Channel_ARMCore0    (2)
#define VIC_Channel_ARMCore1    (3)
#define VIC_Channel_Timer0      (4)
#define VIC_Channel_Timer1      (5)
#define VIC_Channel_UART0       (6)
#define VIC_Channel_UART1       (7)
#define VIC_Channel_PWM0        (8)
#define VIC_Channel_I2C0        (9)
#define VIC_Channel_SPI0        (10)
#define VIC_Channel_SPI1        (11)
#define VIC_Channel_SSP         (11)
#define VIC_Channel_PLL         (12)
#define VIC_Channel_RTC         (13)
#define VIC_Channel_EINT0       (14)
#define VIC_Channel_EINT1       (15)
#define VIC_Channel_EINT2       (16)
#define VIC_Channel_EINT3       (17)
#define VIC_Channel_AD0         (18)
#define VIC_Channel_I2C1        (19)
#define VIC_Channel_BOD         (20)
#define VIC_Channel_AD1         (21)
#define VIC_Channel_USB         (22)


/*##############################################################################
## PCB - Pin Connect Block
##############################################################################*/

#define PCB_PINSEL0               (*(pREG32 (0xe002c000)))
#define PCB_PINSEL1               (*(pREG32 (0xe002c004)))
#define PCB_PINSEL2               (*(pREG32 (0xe002c014)))

#define PCB_PINSEL0_ALL_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL1_ALL_GPIO      ((unsigned int) 0x00000000)

#define PCB_PINSEL0_P00_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P00_TXD0      ((unsigned int) 0x00000001)
#define PCB_PINSEL0_P00_PWM1      ((unsigned int) 0x00000002)
#define PCB_PINSEL0_P00_RSVD3     ((unsigned int) 0x00000003)
#define PCB_PINSEL0_P00_MASK      ((unsigned int) 0x00000003)

#define PCB_PINSEL0_P01_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P01_RXD0      ((unsigned int) 0x00000004)
#define PCB_PINSEL0_P01_PWM3      ((unsigned int) 0x00000008)
#define PCB_PINSEL0_P01_EINT0     ((unsigned int) 0x0000000c)
#define PCB_PINSEL0_P01_MASK      ((unsigned int) 0x0000000c)

#define PCB_PINSEL0_P02_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P02_SCL0      ((unsigned int) 0x00000010)
#define PCB_PINSEL0_P02_CAP00     ((unsigned int) 0x00000020)
#define PCB_PINSEL0_P02_RSVD3     ((unsigned int) 0x00000030)
#define PCB_PINSEL0_P02_MASK      ((unsigned int) 0x00000030)

#define PCB_PINSEL0_P03_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P03_SDA0      ((unsigned int) 0x00000040)
#define PCB_PINSEL0_P03_MAT00     ((unsigned int) 0x00000080)
#define PCB_PINSEL0_P03_EINT1     ((unsigned int) 0x000000c0)
#define PCB_PINSEL0_P03_MASK      ((unsigned int) 0x000000c0)

#define PCB_PINSEL0_P04_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P04_SCK0      ((unsigned int) 0x00000100)
#define PCB_PINSEL0_P04_CAP01     ((unsigned int) 0x00000200)
#define PCB_PINSEL0_P04_RSVD3     ((unsigned int) 0x00000300)
#define PCB_PINSEL0_P04_MASK      ((unsigned int) 0x00000300)

#define PCB_PINSEL0_P05_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P05_MISO0     ((unsigned int) 0x00000400)
#define PCB_PINSEL0_P05_MAT01     ((unsigned int) 0x00000800)
#define PCB_PINSEL0_P05_AD06      ((unsigned int) 0x00000c00)
#define PCB_PINSEL0_P05_MASK      ((unsigned int) 0x00000c00)

#define PCB_PINSEL0_P06_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P06_MOSI0     ((unsigned int) 0x00001000)
#define PCB_PINSEL0_P06_CAP02     ((unsigned int) 0x00002000)
#define PCB_PINSEL0_P06_AD10      ((unsigned int) 0x00003000)
#define PCB_PINSEL0_P06_MASK      ((unsigned int) 0x00003000)

#define PCB_PINSEL0_P07_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P07_SSEL0     ((unsigned int) 0x00004000)
#define PCB_PINSEL0_P07_PWM2      ((unsigned int) 0x00008000)
#define PCB_PINSEL0_P07_EINT2     ((unsigned int) 0x0000c000)
#define PCB_PINSEL0_P07_MASK      ((unsigned int) 0x0000c000)

#define PCB_PINSEL0_P08_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P08_TXD1      ((unsigned int) 0x00010000)
#define PCB_PINSEL0_P08_PWM4      ((unsigned int) 0x00020000)
#define PCB_PINSEL0_P08_AD11      ((unsigned int) 0x00030000)
#define PCB_PINSEL0_P08_MASK      ((unsigned int) 0x00030000)

#define PCB_PINSEL0_P09_GPIO      ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P09_RXD1      ((unsigned int) 0x00040000)
#define PCB_PINSEL0_P09_PWM6      ((unsigned int) 0x00080000)
#define PCB_PINSEL0_P09_EINT3     ((unsigned int) 0x000c0000)
#define PCB_PINSEL0_P09_MASK      ((unsigned int) 0x000c0000)

#define PCB_PINSEL0_P010_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P010_RTS1     ((unsigned int) 0x00100000)
#define PCB_PINSEL0_P010_CAP10    ((unsigned int) 0x00200000)
#define PCB_PINSEL0_P010_AD12     ((unsigned int) 0x00300000)
#define PCB_PINSEL0_P010_MASK     ((unsigned int) 0x00300000)

#define PCB_PINSEL0_P011_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P011_CTS1     ((unsigned int) 0x00400000)
#define PCB_PINSEL0_P011_CAP11    ((unsigned int) 0x00800000)
#define PCB_PINSEL0_P011_SCL1     ((unsigned int) 0x00c00000)
#define PCB_PINSEL0_P011_MASK     ((unsigned int) 0x00c00000)

#define PCB_PINSEL0_P012_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P012_DSR1     ((unsigned int) 0x01000000)
#define PCB_PINSEL0_P012_MAT10    ((unsigned int) 0x02000000)
#define PCB_PINSEL0_P012_AD13     ((unsigned int) 0x03000000)
#define PCB_PINSEL0_P012_MASK     ((unsigned int) 0x03000000)

#define PCB_PINSEL0_P013_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P013_DTR1     ((unsigned int) 0x04000000)
#define PCB_PINSEL0_P013_MAT11    ((unsigned int) 0x08000000)
#define PCB_PINSEL0_P013_AD14     ((unsigned int) 0x0c000000)
#define PCB_PINSEL0_P013_MASK     ((unsigned int) 0x0c000000)

#define PCB_PINSEL0_P014_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P014_DCD1     ((unsigned int) 0x10000000)
#define PCB_PINSEL0_P014_EINT1    ((unsigned int) 0x20000000)
#define PCB_PINSEL0_P014_SDA1     ((unsigned int) 0x30000000)
#define PCB_PINSEL0_P014_MASK     ((unsigned int) 0x30000000)

#define PCB_PINSEL0_P015_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL0_P015_RI1      ((unsigned int) 0x40000000)
#define PCB_PINSEL0_P015_EINT2    ((unsigned int) 0x80000000)
#define PCB_PINSEL0_P015_AD15     ((unsigned int) 0xc0000000)
#define PCB_PINSEL0_P015_MASK     ((unsigned int) 0xc0000000)

#define PCB_PINSEL1_P016_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P016_EINT0    ((unsigned int) 0x00000001)
#define PCB_PINSEL1_P016_MAT02    ((unsigned int) 0x00000002)
#define PCB_PINSEL1_P016_CAP02    ((unsigned int) 0x00000003)
#define PCB_PINSEL1_P016_MASK     ((unsigned int) 0x00000003)

#define PCB_PINSEL1_P017_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P017_CAP12    ((unsigned int) 0x00000004)
#define PCB_PINSEL1_P017_SCK1     ((unsigned int) 0x00000008)
#define PCB_PINSEL1_P017_MAT12    ((unsigned int) 0x0000000c)
#define PCB_PINSEL1_P017_MASK     ((unsigned int) 0x0000000c)

#define PCB_PINSEL1_P018_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P018_CAP13    ((unsigned int) 0x00000010)
#define PCB_PINSEL1_P018_MISO1    ((unsigned int) 0x00000020)
#define PCB_PINSEL1_P018_MAT13    ((unsigned int) 0x00000030)
#define PCB_PINSEL1_P018_MASK     ((unsigned int) 0x00000030)

#define PCB_PINSEL1_P019_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P019_MAT12    ((unsigned int) 0x00000040)
#define PCB_PINSEL1_P019_MOSI1    ((unsigned int) 0x00000080)
#define PCB_PINSEL1_P019_CAP12    ((unsigned int) 0x000000c0)
#define PCB_PINSEL1_P019_MASK     ((unsigned int) 0x000000c0)

#define PCB_PINSEL1_P020_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P020_MAT13    ((unsigned int) 0x00000100)
#define PCB_PINSEL1_P020_SSEL1    ((unsigned int) 0x00000200)
#define PCB_PINSEL1_P020_EINT3    ((unsigned int) 0x00000300)
#define PCB_PINSEL1_P020_MASK     ((unsigned int) 0x00000300)

#define PCB_PINSEL1_P021_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P021_PWM5     ((unsigned int) 0x00000400)
#define PCB_PINSEL1_P021_AD16     ((unsigned int) 0x00000800)
#define PCB_PINSEL1_P021_CAP13    ((unsigned int) 0x00000c00)
#define PCB_PINSEL1_P021_MASK     ((unsigned int) 0x00000c00)

#define PCB_PINSEL1_P022_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P022_AD17     ((unsigned int) 0x00001000)
#define PCB_PINSEL1_P022_CAP00    ((unsigned int) 0x00002000)
#define PCB_PINSEL1_P022_MAT00    ((unsigned int) 0x00003000)
#define PCB_PINSEL1_P022_MASK     ((unsigned int) 0x00003000)

#define PCB_PINSEL1_P023_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P023_VBUS     ((unsigned int) 0x00004000)
#define PCB_PINSEL1_P023_RSVD2    ((unsigned int) 0x00008000)
#define PCB_PINSEL1_P023_RSVD3    ((unsigned int) 0x0000c000)
#define PCB_PINSEL1_P023_MASK     ((unsigned int) 0x0000c000)

#define PCB_PINSEL1_P024_RSVD0    ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P024_RSVD1    ((unsigned int) 0x00010000)
#define PCB_PINSEL1_P024_RSVD2    ((unsigned int) 0x00020000)
#define PCB_PINSEL1_P024_RSVD3    ((unsigned int) 0x00030000)
#define PCB_PINSEL1_P024_MASK     ((unsigned int) 0x00030000)

#define PCB_PINSEL1_P025_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P025_AD04     ((unsigned int) 0x00040000)
#define PCB_PINSEL1_P025_AOUT     ((unsigned int) 0x00080000)
#define PCB_PINSEL1_P025_RSVD3    ((unsigned int) 0x000c0000)
#define PCB_PINSEL1_P025_MASK     ((unsigned int) 0x000c0000)

#define PCB_PINSEL1_P026_RSVD0    ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P026_RSVD1    ((unsigned int) 0x00100000)
#define PCB_PINSEL1_P026_RSVD2    ((unsigned int) 0x00200000)
#define PCB_PINSEL1_P026_RSVD3    ((unsigned int) 0x00300000)
#define PCB_PINSEL1_P026_MASK     ((unsigned int) 0x00300000)

#define PCB_PINSEL1_P027_RSVD0    ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P027_RSVD1    ((unsigned int) 0x00400000)
#define PCB_PINSEL1_P027_RSVD2    ((unsigned int) 0x00800000)
#define PCB_PINSEL1_P027_RSVD3    ((unsigned int) 0x00c00000)
#define PCB_PINSEL1_P027_MASK     ((unsigned int) 0x00c00000)

#define PCB_PINSEL1_P028_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P028_AD01     ((unsigned int) 0x01000000)
#define PCB_PINSEL1_P028_CAP02    ((unsigned int) 0x02000000)
#define PCB_PINSEL1_P028_MAT02    ((unsigned int) 0x03000000)
#define PCB_PINSEL1_P028_MASK     ((unsigned int) 0x03000000)

#define PCB_PINSEL1_P029_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P029_AD02     ((unsigned int) 0x04000000)
#define PCB_PINSEL1_P029_CAP03    ((unsigned int) 0x08000000)
#define PCB_PINSEL1_P029_MAT03    ((unsigned int) 0x0c000000)
#define PCB_PINSEL1_P029_MASK     ((unsigned int) 0x0c000000)

#define PCB_PINSEL1_P030_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P030_AD03     ((unsigned int) 0x10000000)
#define PCB_PINSEL1_P030_EINT3    ((unsigned int) 0x20000000)
#define PCB_PINSEL1_P030_CAP00    ((unsigned int) 0x30000000)
#define PCB_PINSEL1_P030_MASK     ((unsigned int) 0x30000000)

#define PCB_PINSEL1_P031_GPIO     ((unsigned int) 0x00000000)
#define PCB_PINSEL1_P031_UPLED    ((unsigned int) 0x40000000)
#define PCB_PINSEL1_P031_CONNECT  ((unsigned int) 0x80000000)
#define PCB_PINSEL1_P031_RSVD3    ((unsigned int) 0xc0000000)
#define PCB_PINSEL1_P031_MASK     ((unsigned int) 0xc0000000)

#define PCB_PINSEL2_P13626_GPIO   ((unsigned int) 0x00000000) 
#define PCB_PINSEL2_P13626_DEBUG  ((unsigned int) 0x00000004) 
#define PCB_PINSEL2_P13626_MASK   ((unsigned int) 0x00000004)

#define PCB_PINSEL2_P12516_GPIO   ((unsigned int) 0x00000000) 
#define PCB_PINSEL2_P12516_TRACE  ((unsigned int) 0x00000008) 
#define PCB_PINSEL2_P12516_MASK   ((unsigned int) 0x00000008)

/*##############################################################################
## GPIO - General Purpose I/O
##############################################################################*/

#define GPIO0_IOPIN     (*(pREG32 (0xe0028000)))
#define GPIO0_IOSET     (*(pREG32 (0xe0028004)))
#define GPIO0_IODIR     (*(pREG32 (0xe0028008)))
#define GPIO0_IOCLR     (*(pREG32 (0xe002800c)))
#define GPIO1_IOPIN     (*(pREG32 (0xe0028010)))
#define GPIO1_IOSET     (*(pREG32 (0xe0028014)))
#define GPIO1_IODIR     (*(pREG32 (0xe0028018)))
#define GPIO1_IOCLR     (*(pREG32 (0xe002801c)))

#define GPIO0_FIODIR    (*(pREG32 (0x3fffc000)))
#define GPIO0_FIODIRL   (*(pREG16 (0x3fffc000)))
#define GPIO0_FIODIR0   (*(pREG8  (0x3fffc000)))
#define GPIO0_FIODIR1   (*(pREG8  (0x3fffc001)))
#define GPIO0_FIODIRH   (*(pREG16 (0x3fffc002)))
#define GPIO0_FIODIR2   (*(pREG8  (0x3fffc002)))
#define GPIO0_FIODIR3   (*(pREG8  (0x3fffc003)))

#define GPIO0_FIOMASK   (*(pREG32 (0x3fffc010)))
#define GPIO0_FIOMASKL  (*(pREG16 (0x3fffc010)))
#define GPIO0_FIOMASK0  (*(pREG8  (0x3fffc010)))
#define GPIO0_FIOMASK1  (*(pREG8  (0x3fffc011)))
#define GPIO0_FIOMASKH  (*(pREG16 (0x3fffc012)))
#define GPIO0_FIOMASK2  (*(pREG8  (0x3fffc012)))
#define GPIO0_FIOMASK3  (*(pREG8  (0x3fffc013)))

#define GPIO0_FIOPIN    (*(pREG32 (0x3fffc014)))
#define GPIO0_FIOPINL   (*(pREG16 (0x3fffc014)))
#define GPIO0_FIOPIN0   (*(pREG8  (0x3fffc014)))
#define GPIO0_FIOPIN1   (*(pREG8  (0x3fffc015)))
#define GPIO0_FIOPINH   (*(pREG16 (0x3fffc016)))
#define GPIO0_FIOPIN2   (*(pREG8  (0x3fffc016)))
#define GPIO0_FIOPIN3   (*(pREG8  (0x3fffc017)))

#define GPIO0_FIOSET    (*(pREG32 (0x3fffc018)))
#define GPIO0_FIOSETL   (*(pREG16 (0x3fffc018)))
#define GPIO0_FIOSET0   (*(pREG8  (0x3fffc018)))
#define GPIO0_FIOSET1   (*(pREG8  (0x3fffc019)))
#define GPIO0_FIOSETH   (*(pREG16 (0x3fffc01a)))
#define GPIO0_FIOSET2   (*(pREG8  (0x3fffc01a)))
#define GPIO0_FIOSET3   (*(pREG8  (0x3fffc01b)))

#define GPIO0_FIOCLR    (*(pREG32 (0x3fffc01c)))
#define GPIO0_FIOCLRL   (*(pREG16 (0x3fffc01c)))
#define GPIO0_FIOCLR0   (*(pREG8  (0x3fffc01c)))
#define GPIO0_FIOCLR1   (*(pREG8  (0x3fffc01d)))
#define GPIO0_FIOCLRH   (*(pREG16 (0x3fffc01e)))
#define GPIO0_FIOCLR2   (*(pREG8  (0x3fffc01e)))
#define GPIO0_FIOCLR3   (*(pREG8  (0x3fffc01f)))

#define GPIO1_FIODIR    (*(pREG32 (0x3fffc020)))
#define GPIO1_FIODIRL   (*(pREG16 (0x3fffc020)))
#define GPIO1_FIODIR0   (*(pREG8  (0x3fffc020)))
#define GPIO1_FIODIR1   (*(pREG8  (0x3fffc021)))
#define GPIO1_FIODIRH   (*(pREG16 (0x3fffc022)))
#define GPIO1_FIODIR2   (*(pREG8  (0x3fffc022)))
#define GPIO1_FIODIR3   (*(pREG8  (0x3fffc023)))

#define GPIO1_FIOMASK   (*(pREG32 (0x3fffc030)))
#define GPIO1_FIOMASKL  (*(pREG16 (0x3fffc030)))
#define GPIO1_FIOMASK0  (*(pREG8  (0x3fffc030)))
#define GPIO1_FIOMASK1  (*(pREG8  (0x3fffc031)))
#define GPIO1_FIOMASKH  (*(pREG16 (0x3fffc032)))
#define GPIO1_FIOMASK2  (*(pREG8  (0x3fffc032)))
#define GPIO1_FIOMASK3  (*(pREG8  (0x3fffc033)))

#define GPIO1_FIOPIN    (*(pREG32 (0x3fffc034)))
#define GPIO1_FIOPINL   (*(pREG16 (0x3fffc034)))
#define GPIO1_FIOPIN0   (*(pREG8  (0x3fffc034)))
#define GPIO1_FIOPIN1   (*(pREG8  (0x3fffc035)))
#define GPIO1_FIOPINH   (*(pREG16 (0x3fffc036)))
#define GPIO1_FIOPIN2   (*(pREG8  (0x3fffc036)))
#define GPIO1_FIOPIN3   (*(pREG8  (0x3fffc037)))

#define GPIO1_FIOSET    (*(pREG32 (0x3fffc038)))
#define GPIO1_FIOSETL   (*(pREG16 (0x3fffc038)))
#define GPIO1_FIOSET0   (*(pREG8  (0x3fffc038)))
#define GPIO1_FIOSET1   (*(pREG8  (0x3fffc039)))
#define GPIO1_FIOSETH   (*(pREG16 (0x3fffc03a)))
#define GPIO1_FIOSET2   (*(pREG8  (0x3fffc03a)))
#define GPIO1_FIOSET3   (*(pREG8  (0x3fffc03b)))

#define GPIO1_FIOCLR    (*(pREG32 (0x3fffc03c)))
#define GPIO1_FIOCLRL   (*(pREG16 (0x3fffc03c)))
#define GPIO1_FIOCLR0   (*(pREG8  (0x3fffc03c)))
#define GPIO1_FIOCLR1   (*(pREG8  (0x3fffc03d)))
#define GPIO1_FIOCLRH   (*(pREG16 (0x3fffc03e)))
#define GPIO1_FIOCLR2   (*(pREG8  (0x3fffc03e)))
#define GPIO1_FIOCLR3   (*(pREG8  (0x3fffc03f)))

#define GPIO_IO_P0      ((unsigned int) 0x00000001)
#define GPIO_IO_P1      ((unsigned int) 0x00000002)
#define GPIO_IO_P2      ((unsigned int) 0x00000004)
#define GPIO_IO_P3      ((unsigned int) 0x00000008)
#define GPIO_IO_P4      ((unsigned int) 0x00000010)
#define GPIO_IO_P5      ((unsigned int) 0x00000020)
#define GPIO_IO_P6      ((unsigned int) 0x00000040)
#define GPIO_IO_P7      ((unsigned int) 0x00000080)
#define GPIO_IO_P8      ((unsigned int) 0x00000100)
#define GPIO_IO_P9      ((unsigned int) 0x00000200)
#define GPIO_IO_P10     ((unsigned int) 0x00000400)
#define GPIO_IO_P11     ((unsigned int) 0x00000800)
#define GPIO_IO_P12     ((unsigned int) 0x00001000)
#define GPIO_IO_P13     ((unsigned int) 0x00002000)
#define GPIO_IO_P14     ((unsigned int) 0x00004000)
#define GPIO_IO_P15     ((unsigned int) 0x00008000)
#define GPIO_IO_P16     ((unsigned int) 0x00010000)
#define GPIO_IO_P17     ((unsigned int) 0x00020000)
#define GPIO_IO_P18     ((unsigned int) 0x00040000)
#define GPIO_IO_P19     ((unsigned int) 0x00080000)
#define GPIO_IO_P20     ((unsigned int) 0x00100000)
#define GPIO_IO_P21     ((unsigned int) 0x00200000)
#define GPIO_IO_P22     ((unsigned int) 0x00400000)
#define GPIO_IO_P23     ((unsigned int) 0x00800000)
#define GPIO_IO_P24     ((unsigned int) 0x01000000)
#define GPIO_IO_P25     ((unsigned int) 0x02000000)
#define GPIO_IO_P26     ((unsigned int) 0x04000000)
#define GPIO_IO_P27     ((unsigned int) 0x08000000)
#define GPIO_IO_P28     ((unsigned int) 0x10000000)
#define GPIO_IO_P29     ((unsigned int) 0x20000000)
#define GPIO_IO_P30     ((unsigned int) 0x40000000)
#define GPIO_IO_P31     ((unsigned int) 0x80000000)
#define GPIO_IO_ALL     ((unsigned int) 0xffffffff)
#define GPIO_IO_JTAG    ((unsigned int) 0x003e0000)


/*##############################################################################
## UART0 / UART1
##############################################################################*/

#define UART0_RBR       (*(pREG32 (0xe000c000)))
#define UART0_THR       (*(pREG32 (0xe000c000)))
#define UART0_IER       (*(pREG32 (0xe000c004)))
#define UART0_IIR       (*(pREG32 (0xe000c008)))
#define UART0_FCR       (*(pREG32 (0xe000c008)))
#define UART0_LCR       (*(pREG32 (0xe000c00c)))
#define UART0_LSR       (*(pREG32 (0xe000c014)))
#define UART0_SCR       (*(pREG32 (0xe000c01c)))
#define UART0_ACR       (*(pREG32 (0xe0000020)))
#define UART0_FDR       (*(pREG32 (0xe0000028)))
#define UART0_TER       (*(pREG32 (0xe0000030)))
#define UART0_DLL       (*(pREG32 (0xe000c000)))
#define UART0_DLM       (*(pREG32 (0xe000c004)))

#define UART1_RBR       (*(pREG32 (0xe0010000)))
#define UART1_THR       (*(pREG32 (0xe0010000)))
#define UART1_IER       (*(pREG32 (0xe0010004)))
#define UART1_IIR       (*(pREG32 (0xe0010008)))
#define UART1_FCR       (*(pREG32 (0xe0010008)))
#define UART1_LCR       (*(pREG32 (0xe001000c)))
#define UART1_LSR       (*(pREG32 (0xe0010014)))
#define UART1_SCR       (*(pREG32 (0xe001001c)))
#define UART1_ACR       (*(pREG32 (0xe0010020)))
#define UART1_FDR       (*(pREG32 (0xe0010028)))
#define UART1_TER       (*(pREG32 (0xe0010030)))
#define UART1_DLL       (*(pREG32 (0xe0010000)))
#define UART1_DLM       (*(pREG32 (0xe0010004)))
#define UART1_MCR       (*(pREG32 (0xe0010010)))
#define UART1_MSR       (*(pREG32 (0xe0010018)))

#define UART_LCR_DLAB   (0x00000080)
#define UART_LCR_NOPAR  (0x00000000)
#define UART_LCR_1STOP  (0x00000000)
#define UART_LCR_8BITS  (0x00000003)
#define UART_IER_EI     (0x00000003)
#define UART_FCR_EN     (0x00000001)
#define UART_FCR_CLR    (0x00000006)


/*##############################################################################
## I2C
##############################################################################*/

#define I2C0_CONSET         (*(pREG32 (0xe001c000)))
#define I2C0_STAT           (*(pREG32 (0xe001c004)))
#define I2C0_DAT            (*(pREG32 (0xe001c008)))
#define I2C0_ADR            (*(pREG32 (0xe001c00c)))
#define I2C0_SCLH           (*(pREG32 (0xe001c010)))
#define I2C0_SCLL           (*(pREG32 (0xe001c014)))
#define I2C0_CONCLR         (*(pREG32 (0xe001c018)))

#define I2C1_CONSET         (*(pREG32 (0xe005c000)))
#define I2C1_STAT           (*(pREG32 (0xe005c004)))
#define I2C1_DAT            (*(pREG32 (0xe005c008)))
#define I2C1_ADR            (*(pREG32 (0xe005c00c)))
#define I2C1_SCLH           (*(pREG32 (0xe005c010)))
#define I2C1_SCLL           (*(pREG32 (0xe005c014)))
#define I2C1_CONCLR         (*(pREG32 (0xe005c018)))

#define I2C_CONSET_AA       (0x00000004)
#define I2C_CONSET_SI       (0x00000008)
#define I2C_CONSET_STO      (0x00000010)
#define I2C_CONSET_STA      (0x00000020)
#define I2C_CONSET_I2EN     (0x00000040)
#define I2C_CONSET_MASK     (0x0000007c)

#define I2C_STAT_STATMASK   (0x000000f8)
#define I2C_STAT_STATSHIFT  (3)

#define I2C_ADDR_GC         (0x00000001)
#define I2C_ADDR_ADDRMASK   (0x000000fe)
#define I2C_ADDR_ADDRSHIFT  (1)

#define I2C_CONCLR_AAC      (0x00000004)
#define I2C_CONCLR_SIC      (0x00000008)
#define I2C_CONCLR_STAC     (0x00000020)
#define I2C_CONCLR_I2ENC    (0x00000040)
#define I2C_CONCLR_MASK     (0x0000006c)


/*##############################################################################
## SPI - Serial Peripheral Interface
##############################################################################*/

#define SPI_SPCR        (*(pREG32 (0xe0020000)))
#define SPI_SPSR        (*(pREG32 (0xe0020004)))
#define SPI_SPDR        (*(pREG32 (0xe0020008)))
#define SPI_SPCCR       (*(pREG32 (0xe002000c)))
#define SPI_SPINT       (*(pREG32 (0xe002001c)))

#define SPI_SPCR_BITENABLE    ((unsigned int) 0x00000004)
#define SPI_SPCR_CPHA         ((unsigned int) 0x00000008)
#define SPI_SPCR_CPHA1ST      ((unsigned int) 0x00000000)
#define SPI_SPCR_CPHA2ND      ((unsigned int) 0x00000008)
#define SPI_SPCR_CPOL         ((unsigned int) 0x00000010)
#define SPI_SPCR_CPOLACTHIGH  ((unsigned int) 0x00000000)
#define SPI_SPCR_CPOLACTLOW   ((unsigned int) 0x00000010)
#define SPI_SPCR_SLAVE        ((unsigned int) 0x00000000)
#define SPI_SPCR_MSTR         ((unsigned int) 0x00000020)
#define SPI_SPCR_MSBF         ((unsigned int) 0x00000000)
#define SPI_SPCR_LSBF         ((unsigned int) 0x00000040)
#define SPI_SPCR_SPIE         ((unsigned int) 0x00000080)
#define SPI_SPCR_BITS8        ((unsigned int) 0x00000800)
#define SPI_SPCR_BITS9        ((unsigned int) 0x00000900)
#define SPI_SPCR_BITS10       ((unsigned int) 0x00000a00)
#define SPI_SPCR_BITS11       ((unsigned int) 0x00000b00)
#define SPI_SPCR_BITS12       ((unsigned int) 0x00000c00)
#define SPI_SPCR_BITS13       ((unsigned int) 0x00000d00)
#define SPI_SPCR_BITS14       ((unsigned int) 0x00000e00)
#define SPI_SPCR_BITS15       ((unsigned int) 0x00000f00)
#define SPI_SPCR_BITS16       ((unsigned int) 0x00000000)
#define SPI_SPCR_BITSMASK     ((unsigned int) 0x00000f00)

#define SPI_SPSR_ABRT         ((unsigned int) 0x00000008)
#define SPI_SPSR_MODF         ((unsigned int) 0x00000010)
#define SPI_SPSR_ROVR         ((unsigned int) 0x00000020)
#define SPI_SPSR_WCOL         ((unsigned int) 0x00000040)
#define SPI_SPSR_SPIF         ((unsigned int) 0x00000080)

#define SPI_SPINT_INTFLAG     ((unsigned int) 0x00000001)


/*##############################################################################
## SSP - Synchronous Serial Port
##############################################################################*/

#define SSP_CR0         (*(pREG32 (0xe0068000)))
#define SSP_CR1         (*(pREG32 (0xe0068004)))
#define SSP_DR          (*(pREG32 (0xe0068008)))
#define SSP_SR          (*(pREG32 (0xe006800C)))
#define SSP_CPSR        (*(pREG32 (0xe0068010)))
#define SSP_IMSC        (*(pREG32 (0xe0068014)))
#define SSP_RIS         (*(pREG32 (0xe0068018)))
#define SSP_MIS         (*(pREG32 (0xe006801C)))
#define SSP_ICR         (*(pREG32 (0xe0068020)))

#define SSP_FIFO_DEPTH  (8)

#define SSP_CR0_DSS_4   ((unsigned int) 0x00000003)
#define SSP_CR0_DSS_5   ((unsigned int) 0x00000004)
#define SSP_CR0_DSS_6   ((unsigned int) 0x00000005)
#define SSP_CR0_DSS_7   ((unsigned int) 0x00000006)
#define SSP_CR0_DSS_8   ((unsigned int) 0x00000007)
#define SSP_CR0_DSS_9   ((unsigned int) 0x00000008)
#define SSP_CR0_DSS 10  ((unsigned int) 0x00000009)
#define SSP_CR0_DSS_11  ((unsigned int) 0x0000000a)
#define SSP_CR0_DSS_12  ((unsigned int) 0x0000000b)
#define SSP_CR0_DSS_13  ((unsigned int) 0x0000000c)
#define SSP_CR0_DSS_14  ((unsigned int) 0x0000000d)
#define SSP_CR0_DSS_15  ((unsigned int) 0x0000000e)
#define SSP_CR0_DSS_16  ((unsigned int) 0x0000000f)
#define SSP_CR0_FRF_SPI ((unsigned int) 0x00000000)
#define SSP_CR0_FRF_SSI ((unsigned int) 0x00000010)
#define SSP_CR0_FRF_MW  ((unsigned int) 0x00000020)
#define SSP_CR0_CPOL    ((unsigned int) 0x00000040)
#define SSP_CR0_CPHA    ((unsigned int) 0x00000080)
#define SSP_CR0_SCR     ((unsigned int) 0x0000ff00)

#define SSP_CR1_LBM     ((unsigned int) 0x00000001)
#define SSP_CR1_SSE     ((unsigned int) 0x00000002)
#define SSP_CR1_MS      ((unsigned int) 0x00000004)
#define SSP_CR1_SOD     ((unsigned int) 0x00000008)

#define SSP_SR_TFE      ((unsigned int) 0x00000001)
#define SSP_SR_TNF      ((unsigned int) 0x00000002)
#define SSP_SR_RNE      ((unsigned int) 0x00000004)
#define SSP_SR_RFF      ((unsigned int) 0x00000008)
#define SSP_SR_BSY      ((unsigned int) 0x00000010)

#define SSP_IMSC_RORIM  ((unsigned int) 0x00000001)
#define SSP_IMSC_RTIM   ((unsigned int) 0x00000002)
#define SSP_IMSC_RXIM   ((unsigned int) 0x00000004)
#define SSP_IMSC_TXIM   ((unsigned int) 0x00000008)

#define SSP_RIS_RORRIS  ((unsigned int) 0x00000001)
#define SSP_RIS_RTRIS   ((unsigned int) 0x00000002)
#define SSP_RIS_RXRIS   ((unsigned int) 0x00000004)
#define SSP_RIS_TXRIS   ((unsigned int) 0x00000008)

#define SSP_MIS_RORMIS  ((unsigned int) 0x00000001)
#define SSP_MIS_RTMIS   ((unsigned int) 0x00000002)
#define SSP_MIS_RXMIS   ((unsigned int) 0x00000004)
#define SSP_MIS_TXMIS   ((unsigned int) 0x00000008)

#define SSP_ICR_RORIC   ((unsigned int) 0x00000001)
#define SSP_ICR_RTIC    ((unsigned int) 0x00000002)


/*##############################################################################
## Timer 0 and Timer 1
##############################################################################*/

#define T0_BASE_ADDR        (pREG32 (0xe0004000))
#define T0_IR               (*(pREG32 (0xe0004000)))
#define T0_TCR              (*(pREG32 (0xe0004004)))
#define T0_TC               (*(pREG32 (0xe0004008)))
#define T0_PR               (*(pREG32 (0xe000400c)))
#define T0_PC               (*(pREG32 (0xe0004010)))
#define T0_MCR              (*(pREG32 (0xe0004014)))
#define T0_MR0              (*(pREG32 (0xe0004018)))
#define T0_MR1              (*(pREG32 (0xe000401c)))
#define T0_MR2              (*(pREG32 (0xe0004020)))
#define T0_MR3              (*(pREG32 (0xe0004024)))
#define T0_CCR              (*(pREG32 (0xe0004028)))
#define T0_CR0              (*(pREG32 (0xe000402c)))
#define T0_CR1              (*(pREG32 (0xe0004030)))
#define T0_CR2              (*(pREG32 (0xe0004034)))
#define T0_CR3              (*(pREG32 (0xe0004038)))
#define T0_EMR              (*(pREG32 (0xe000403c)))
#define T0_CTCR             (*(pREG32 (0xe0004070)))

#define T1_BASE_ADDR        (pREG32 (0xe0008000))
#define T1_IR               (*(pREG32 (0xe0008000)))
#define T1_TCR              (*(pREG32 (0xe0008004)))
#define T1_TC               (*(pREG32 (0xe0008008)))
#define T1_PR               (*(pREG32 (0xe000800c)))
#define T1_PC               (*(pREG32 (0xe0008010)))
#define T1_MCR              (*(pREG32 (0xe0008014)))
#define T1_MR0              (*(pREG32 (0xe0008018)))
#define T1_MR1              (*(pREG32 (0xe000801c)))
#define T1_MR2              (*(pREG32 (0xe0008020)))
#define T1_MR3              (*(pREG32 (0xe0008024)))
#define T1_CCR              (*(pREG32 (0xe0008028)))
#define T1_CR0              (*(pREG32 (0xe000802c)))
#define T1_CR1              (*(pREG32 (0xe0008030)))
#define T1_CR2              (*(pREG32 (0xe0008034)))
#define T1_CR3              (*(pREG32 (0xe0008038)))
#define T1_EMR              (*(pREG32 (0xe000803c)))
#define T1_CTCR             (*(pREG32 (0xe0008070)))

#define T_IR_MR0            (0x00000001)
#define T_IR_MR1            (0x00000002)
#define T_IR_MR2            (0x00000004)
#define T_IR_MR3            (0x00000008)
#define T_IR_CR0            (0x00000010)
#define T_IR_CR1            (0x00000020)
#define T_IR_CR2            (0x00000040)
#define T_IR_CR3            (0x00000080)
#define T_IR_MASK           (0x000000ff)

#define T_TCR_CE            (0x00000001)
#define T_TCR_CR            (0x00000002)

#define T_CTCR_MODE_PCLK    (0x00000000)
#define T_CTCR_MODE_CAPRISE (0x00000001)
#define T_CTCR_MODE_CAPFALL (0x00000002)
#define T_CTCR_MODE_CAPBOTH (0x00000003)
#define T_CTCR_MODE_MASK    (0x00000003)
#define T_CTCR_CIS_CAPN0    (0x00000000)
#define T_CTCR_CIS_CAPN1    (0x00000004)
#define T_CTCR_CIS_CAPN2    (0x00000008)
#define T_CTCR_CIS_CAPN3    (0x0000000c)
#define T_CTCR_CIS_MASK     (0x0000000c)

#define T_MCR_MR0I          (0x00000001)
#define T_MCR_MR0R          (0x00000002)
#define T_MCR_MR0S          (0x00000004)
#define T_MCR_MR1I          (0x00000008)
#define T_MCR_MR1R          (0x00000010)
#define T_MCR_MR1S          (0x00000020)
#define T_MCR_MR2I          (0x00000040)
#define T_MCR_MR2R          (0x00000080)
#define T_MCR_MR2S          (0x00000100)
#define T_MCR_MR3I          (0x00000200)
#define T_MCR_MR3R          (0x00000400)
#define T_MCR_MR3S          (0x00000800)

#define T_CCR_CAP0RE        (0x00000001)
#define T_CCR_CAP0FE        (0x00000002)
#define T_CCR_CAP0I         (0x00000004)
#define T_CCR_CAP1RE        (0x00000008)
#define T_CCR_CAP1FE        (0x00000010)
#define T_CCR_CAP1I         (0x00000020)
#define T_CCR_CAP2RE        (0x00000040)
#define T_CCR_CAP2FE        (0x00000080)
#define T_CCR_CAP2I         (0x00000100)
#define T_CCR_CAP3RE        (0x00000200)
#define T_CCR_CAP3FE        (0x00000400)
#define T_CCR_CAP3I         (0x00000800)

#define T_EMR_EM0           (0x00000001)
#define T_EMR_EM1           (0x00000002)
#define T_EMR_EM2           (0x00000004)
#define T_EMR_EM3           (0x00000008)
#define T_EMR_EMC0_NONE     (0x00000000)
#define T_EMR_EMC0_CLEAR    (0x00000010)
#define T_EMR_EMC0_SET      (0x00000020)
#define T_EMR_EMC0_TOGGLE   (0x00000030)
#define T_EMR_EMC0_MASK     (0x00000030)
#define T_EMR_EMC1_NONE     (0x00000000)
#define T_EMR_EMC1_CLEAR    (0x00000040)
#define T_EMR_EMC1_SET      (0x00000080)
#define T_EMR_EMC1_TOGGLE   (0x000000c0)
#define T_EMR_EMC1_MASK     (0x000000c0)
#define T_EMR_EMC2_NONE     (0x00000000)
#define T_EMR_EMC2_CLEAR    (0x00000100)
#define T_EMR_EMC2_SET      (0x00000200)
#define T_EMR_EMC2_TOGGLE   (0x00000300)
#define T_EMR_EMC2_MASK     (0x00000300)
#define T_EMR_EMC3_NONE     (0x00000000)
#define T_EMR_EMC3_CLEAR    (0x00000400)
#define T_EMR_EMC3_SET      (0x00000800)
#define T_EMR_EMC3_TOGGLE   (0x00000c00)
#define T_EMR_EMC3_MASK     (0x00000c00)


/*##############################################################################
## ADC
##############################################################################*/

#define AD0_CR              (*(pREG32 (0xe0034000)))
#define AD0_GDR             (*(pREG32 (0xe0034004)))
#define AD0_STAT            (*(pREG32 (0xe0034030)))
#define AD0_GSR             (*(pREG32 (0xe0034008)))
#define AD0_INTEN           (*(pREG32 (0xe003400c)))
#define AD0_DR0             (*(pREG32 (0xe0034010)))
#define AD0_DR1             (*(pREG32 (0xe0034014)))
#define AD0_DR2             (*(pREG32 (0xe0034018)))
#define AD0_DR3             (*(pREG32 (0xe003401c)))
#define AD0_DR4             (*(pREG32 (0xe0034020)))
#define AD0_DR5             (*(pREG32 (0xe0034024)))
#define AD0_DR6             (*(pREG32 (0xe0034028)))
#define AD0_DR7             (*(pREG32 (0xe003402c)))

#define AD1_CR              (*(pREG32 (0xe0060000)))
#define AD1_GDR             (*(pREG32 (0xe0060004)))
#define AD1_STAT            (*(pREG32 (0xe0060030)))
#define AD1_GSR             (*(pREG32 (0xe0030008)))
#define AD1_INTEN           (*(pREG32 (0xe006000c)))
#define AD1_DR0             (*(pREG32 (0xe0060010)))
#define AD1_DR1             (*(pREG32 (0xe0060014)))
#define AD1_DR2             (*(pREG32 (0xe0060018)))
#define AD1_DR3             (*(pREG32 (0xe006001c)))
#define AD1_DR4             (*(pREG32 (0xe0060020)))
#define AD1_DR5             (*(pREG32 (0xe0060024)))
#define AD1_DR6             (*(pREG32 (0xe0060028)))
#define AD1_DR7             (*(pREG32 (0xe006002c)))

#define AD_CR_SEL0          (0x00000001)
#define AD_CR_SEL1          (0x00000002)
#define AD_CR_SEL2          (0x00000004)
#define AD_CR_SEL3          (0x00000008)
#define AD_CR_SEL4          (0x00000010)
#define AD_CR_SEL5          (0x00000020)
#define AD_CR_SEL6          (0x00000040)
#define AD_CR_SEL7          (0x00000080)
#define AD_CR_SELMASK       (0x000000ff)
#define AD_CR_CLKDIV        (0x0000ff00)
#define AD_CR_CLKDIVMASK    (0x0000ff00)
#define AD_CR_CLKDIVSHIFT   (8)
#define AD_CR_BURST         (0x00010000)
#define AD_CR_CLKS10        (0x00000000)
#define AD_CR_CLKS9         (0x00020000)
#define AD_CR_CLKS8         (0x00040000)
#define AD_CR_CLKS7         (0x00060000)
#define AD_CR_CLKS6         (0x00080000)
#define AD_CR_CLKS5         (0x000a0000)
#define AD_CR_CLKS4         (0x000c0000)
#define AD_CR_CLKS3         (0x000e0000)
#define AD_CR_PDN           (0x00200000)
#define AD_CR_START_NONE    (0x00000000)
#define AD_CR_START_NOW     (0x01000000)
#define AD_CR_START_P016    (0x02000000)
#define AD_CR_START_P022    (0x03000000)
#define AD_CR_START_MAT01   (0x04000000)
#define AD_CR_START_MAT03   (0x05000000)
#define AD_CR_START_MAT10   (0x06000000)
#define AD_CR_START_MAT11   (0x07000000)
#define AD_CR_START_MASK    (0x07000000)
#define AD_CR_EDGE          (0x08000000)
#define AD_CR_MASK          (0x0f2fffff)

#define AD_GDR_RESULT       (0x0000ffc0)
#define AD_GDR_CHN          (0x07000000)
#define AD_GDR_CHNMASK      (0x07000000)
#define AD_GDR_CHNSHIFT     (24)
#define AD_GDR_OVERRUN      (0x40000000)
#define AD_GDR_DONE         (0x80000000)
#define AD_GDR_MASK         (0xc700ffc0)

#define AD_GSR_BURST        (0x00010000)
#define AD_GSR_START_NONE   (0x00000000)
#define AD_GSR_START_NOW    (0x01000000)
#define AD_GSR_START_P016   (0x02000000)
#define AD_GSR_START_P022   (0x03000000)
#define AD_GSR_START_MAT01  (0x04000000)
#define AD_GSR_START_MAT03  (0x05000000)
#define AD_GSR_START_MAT10  (0x06000000)
#define AD_GSR_START_MAT11  (0x07000000)
#define AD_GSR_EDGE         (0x08000000)
#define AD_GSR_MASK         (0x0f010000)

#define AD_STAT_RSVD        (0x00000001)
#define AD_STAT_DONE0       (0x00000001)
#define AD_STAT_DONE1       (0x00000002)
#define AD_STAT_DONE2       (0x00000004)
#define AD_STAT_DONE3       (0x00000008)
#define AD_STAT_DONE4       (0x00000010)
#define AD_STAT_DONE5       (0x00000020)
#define AD_STAT_DONE6       (0x00000040)
#define AD_STAT_DONE7       (0x00000080)
#define AD_STAT_OVERRUN0    (0x00000100)
#define AD_STAT_OVERRUN1    (0x00000200)
#define AD_STAT_OVERRUN2    (0x00000400)
#define AD_STAT_OVERRUN3    (0x00000800)
#define AD_STAT_OVERRUN4    (0x00001000)
#define AD_STAT_OVERRUN5    (0x00002000)
#define AD_STAT_OVERRUN6    (0x00004000)
#define AD_STAT_OVERRUN7    (0x00008000)
#define AD_STAT_ADINT       (0x00010000)
#define AD_STAT_MASK        (0x0001ffff)

#define AD_INTEN_AD0        (0x00000001)
#define AD_INTEN_AD1        (0x00000002)
#define AD_INTEN_AD2        (0x00000004)
#define AD_INTEN_AD3        (0x00000008)
#define AD_INTEN_AD4        (0x00000010)
#define AD_INTEN_AD5        (0x00000020)
#define AD_INTEN_AD6        (0x00000040)
#define AD_INTEN_AD7        (0x00000080)
#define AD_INTEN_DONE       (0x00000100)
#define AD_INTEN_MASK       (0x000001ff)

#define AD_DR_RESULT        (0x0000ffc0)
#define AD_DR_RESULTMASK    (0x0000ffc0)
#define AD_DR_RESULTSHIFT   (6)
#define AD_DR_OVERRUN       (0x40000000)
#define AD_DR_DONE          (0x80000000)
#define AD_DR_MASK          (0xc000ffc0)


/*##############################################################################
## DAC
##############################################################################*/

#define DAC_CR            (*(pREG32 (0xe006c000)))

#define DAC_CR_VALUE      (0x0000ffc0)
#define DAC_CR_VALUEMASK  (0x0000ffc0)
#define DAC_CR_VALUESHIFT (6)
#define DAC_CR_BIAS       (0x00010000)
#define DAC_CR_MASK       (0x0001ffc0)


/*##############################################################################
## PWM
##############################################################################*/

#define PWM_IR            (*(pREG32 (0xe0014000)))
#define PWM_TCR           (*(pREG32 (0xe0014004)))
#define PWM_TC            (*(pREG32 (0xe0014008)))
#define PWM_PR            (*(pREG32 (0xe001400c)))
#define PWM_PC            (*(pREG32 (0xe0014010)))
#define PWM_MCR           (*(pREG32 (0xe0014014)))
#define PWM_MR0           (*(pREG32 (0xe0014018)))
#define PWM_MR1           (*(pREG32 (0xe001401c)))
#define PWM_MR2           (*(pREG32 (0xe0014020)))
#define PWM_MR3           (*(pREG32 (0xe0014024)))
#define PWM_MR4           (*(pREG32 (0xe0014040)))
#define PWM_MR5           (*(pREG32 (0xe0014044)))
#define PWM_MR6           (*(pREG32 (0xe0014048)))
#define PWM_EMR           (*(pREG32 (0xe001403c)))
#define PWM_PCR           (*(pREG32 (0xe001404c)))
#define PWM_LER           (*(pREG32 (0xe0014050)))

#define PWM_IR_MR0        ((unsigned int) 0x00000001)
#define PWM_IR_MR1        ((unsigned int) 0x00000002)
#define PWM_IR_MR2        ((unsigned int) 0x00000004)
#define PWM_IR_MR3        ((unsigned int) 0x00000008)
#define PWM_IR_MR4        ((unsigned int) 0x00000100)
#define PWM_IR_MR5        ((unsigned int) 0x00000200)
#define PWM_IR_MR6        ((unsigned int) 0x00000400)
#define PWM_IR_MASK       ((unsigned int) 0x0000070f)

#define PWM_TCR_CE        ((unsigned int) 0x00000001)
#define PWM_TCR_CR        ((unsigned int) 0x00000002)
#define PWM_TCR_PWME      ((unsigned int) 0x00000008)
#define PWM_TCR_MASK      ((unsigned int) 0x0000000b)

#define PWM_MCR_MR0I      ((unsigned int) 0x00000001)
#define PWM_MCR_MR0R      ((unsigned int) 0x00000002)
#define PWM_MCR_MR0S      ((unsigned int) 0x00000004)
#define PWM_MCR_MR1I      ((unsigned int) 0x00000008)
#define PWM_MCR_MR1R      ((unsigned int) 0x00000010)
#define PWM_MCR_MR1S      ((unsigned int) 0x00000020)
#define PWM_MCR_MR2I      ((unsigned int) 0x00000040)
#define PWM_MCR_MR2R      ((unsigned int) 0x00000080)
#define PWM_MCR_MR2S      ((unsigned int) 0x00000100)
#define PWM_MCR_MR3I      ((unsigned int) 0x00000200)
#define PWM_MCR_MR3R      ((unsigned int) 0x00000400)
#define PWM_MCR_MR3S      ((unsigned int) 0x00000800)
#define PWM_MCR_MR4I      ((unsigned int) 0x00001000)
#define PWM_MCR_MR4R      ((unsigned int) 0x00002000)
#define PWM_MCR_MR4S      ((unsigned int) 0x00004000)
#define PWM_MCR_MR5I      ((unsigned int) 0x00008000)
#define PWM_MCR_MR5R      ((unsigned int) 0x00010000)
#define PWM_MCR_MR5S      ((unsigned int) 0x00020000)
#define PWM_MCR_MR6I      ((unsigned int) 0x00040000)
#define PWM_MCR_MR6R      ((unsigned int) 0x00080000)
#define PWM_MCR_MR6S      ((unsigned int) 0x00100000)
#define PWM_MCR_MASK      ((unsigned int) 0x001fffff)

#define PWM_PCR_SEL2      ((unsigned int) 0x00000004)
#define PWM_PCR_SEL3      ((unsigned int) 0x00000008)
#define PWM_PCR_SEL4      ((unsigned int) 0x00000010)
#define PWM_PCR_SEL5      ((unsigned int) 0x00000020)
#define PWM_PCR_SEL6      ((unsigned int) 0x00000040)
#define PWM_PCR_SEL_MASK  ((unsigned int) 0x0000007c)
#define PWM_PCR_ENA1      ((unsigned int) 0x00000200)
#define PWM_PCR_ENA2      ((unsigned int) 0x00000400)
#define PWM_PCR_ENA3      ((unsigned int) 0x00000800)
#define PWM_PCR_ENA4      ((unsigned int) 0x00001000)
#define PWM_PCR_ENA5      ((unsigned int) 0x00002000)
#define PWM_PCR_ENA6      ((unsigned int) 0x00004000)
#define PWM_PCR_ENA_MASK  ((unsigned int) 0x00007d00)
#define PWM_PCR_MASK      ((unsigned int) 0x00007d00)

#define PWM_LER_M0L       ((unsigned int) 0x00000001)
#define PWM_LER_M1L       ((unsigned int) 0x00000002)
#define PWM_LER_M2L       ((unsigned int) 0x00000004)
#define PWM_LER_M3L       ((unsigned int) 0x00000008)
#define PWM_LER_M4L       ((unsigned int) 0x00000010)
#define PWM_LER_M5L       ((unsigned int) 0x00000020)
#define PWM_LER_M6L       ((unsigned int) 0x00000040)
#define PWM_LER_MASK      ((unsigned int) 0x0000007f)


/*##############################################################################
## RTC
##############################################################################*/

#define RTC_ILR         (*(pREG32 (0xe0024000)))
#define RTC_CTC         (*(pREG32 (0xe0024004)))
#define RTC_CCR         (*(pREG32 (0xe0024008)))  
#define RTC_CIIR        (*(pREG32 (0xe002400c)))
#define RTC_AMR         (*(pREG32 (0xe0024010)))
#define RTC_CTIME0      (*(pREG32 (0xe0024014)))
#define RTC_CTIME1      (*(pREG32 (0xe0024018)))
#define RTC_CTIME2      (*(pREG32 (0xe002401c)))

#define RTC_SEC         (*(pREG32 (0xe0024020)))
#define RTC_MIN         (*(pREG32 (0xe0024024)))
#define RTC_HOUR        (*(pREG32 (0xe0024028)))
#define RTC_DOM         (*(pREG32 (0xe002402c)))
#define RTC_DOW         (*(pREG32 (0xe0024030)))
#define RTC_DOY         (*(pREG32 (0xe0024034)))
#define RTC_MONTH       (*(pREG32 (0xe0024038)))
#define RTC_YEAR        (*(pREG32 (0xe002403c)))

#define RTC_ALSEC       (*(pREG32 (0xe0024060)))
#define RTC_ALMIN       (*(pREG32 (0xe0024064)))
#define RTC_ALHOUR      (*(pREG32 (0xe0024068)))
#define RTC_ALDOM       (*(pREG32 (0xe002406c)))
#define RTC_ALDOW       (*(pREG32 (0xe0024070)))
#define RTC_ALDOY       (*(pREG32 (0xe0024074)))
#define RTC_ALMON       (*(pREG32 (0xe0024078)))
#define RTC_ALYEAR      (*(pREG32 (0xe002407c)))

#define RTC_PREINT      (*(pREG32 (0xe0024080)))
#define RTC_PREFRAC     (*(pREG32 (0xe0024084)))

#define RTC_ILR_RTCCIF  (0x00000001)
#define RTC_ILR_RTCALF  (0x00000002)
#define RTC_ILR_MASK    (0x00000003)

#define RTC_CCR_CLKEN   (0x00000001)
#define RTC_CCR_CTCRST  (0x00000002)
#define RTC_CCR_TEST    (0x0000000c)
#define RTC_CCR_CLKSRC  (0x00000010)

#define RTC_CIIR_IMSEC  (0x00000001)
#define RTC_CIIR_IMMIN  (0x00000002)
#define RTC_CIIR_IMHOUR (0x00000004)
#define RTC_CIIR_IMDOM  (0x00000008)
#define RTC_CIIR_IMDOW  (0x00000010)
#define RTC_CIIR_IMDOY  (0x00000020)
#define RTC_CIIR_IMMON  (0x00000040)
#define RTC_CIIR_IMYEAR (0x00000080)
#define RTC_CIIR_IMMASK (0x000000ff)

#define RTC_AMR_AMRSEC  (0x00000001)
#define RTC_AMR_AMRMIN  (0x00000002)
#define RTC_AMR_AMRHOUR (0x00000004)
#define RTC_AMR_AMRDOM  (0x00000008)
#define RTC_AMR_AMRDOW  (0x00000010)
#define RTC_AMR_AMRDOY  (0x00000020)
#define RTC_AMR_AMRMON  (0x00000040)
#define RTC_AMR_AMRYEAR (0x00000080)
#define RTC_AMR_AMRMASK (0x000000ff)

typedef struct __attribute__ ((packed)) 
{
  union
  {
    struct
    {
      unsigned int counter   : 14;
      unsigned int rsvd15_31 : 18;
    };

    unsigned int i;
  };
}
rtcCTC_t;

typedef struct __attribute__ ((packed)) 
{
  union
  {
    struct 
    {
      unsigned int seconds   : 6;
      unsigned int rsvd7_6   : 2;
      unsigned int minutes   : 6;
      unsigned int rsvd14_15 : 2;
      unsigned int hours     : 5;
      unsigned int rsvd21_23 : 3;
      unsigned int dow       : 3;
      unsigned int rsvd27_31 : 5;
    };

    unsigned int i;
  };
}
rtcCTIME0_t;

typedef struct __attribute__ ((packed)) 
{
  union
  {
    struct
    {
      unsigned int dom       : 5;
      unsigned int rsvd5_7   : 3;
      unsigned int month     : 4;
      unsigned int rsvd12_15 : 4;
      unsigned int year      : 12;
      unsigned int rsvd28_31 : 4;
    };

    unsigned int i;
  };
}
rtcCTIME1_t;

typedef struct __attribute__ ((packed)) 
{
  union
  {
    struct 
    {
      unsigned int doy       : 12;
      unsigned int rsvd12_31 : 20;
    };

    unsigned int i;
  };
}
rtcCTIME2_t;


/*##############################################################################
## WD - Watchdog
##############################################################################*/

#define WD_MOD        (*(pREG32 (0xe0000000)))
#define WD_TC         (*(pREG32 (0xe0000004)))
#define WD_FEED       (*(pREG32 (0xe0000008)))
#define WD_TV         (*(pREG32 (0xe000000c)))

#define WD_MOD_WDEN   (0x00000001)
#define WD_MOD_RESET  (0x00000002)
#define WD_MOD_TOF    (0x00000004)
#define WD_MOD_INT    (0x00000008)
#define WD_MOD_MASK   (0x0000000f)

#define WD_FEED_FEED1 (0x000000aa)
#define WD_FEED_FEED2 (0x00000055)


/*##############################################################################
## System Control Block
##############################################################################*/

#define SCB_MEMMAP          (*(pREG32 (0xe01fc040)))
#define SCB_PLLCON          (*(pREG32 (0xe01fc080)))
#define SCB_PLLCFG          (*(pREG32 (0xe01fc084)))
#define SCB_PLLSTAT         (*(pREG32 (0xe01fc088)))
#define SCB_PLLFEED         (*(pREG32 (0xe01fc08c)))
#define SCB_PCON            (*(pREG32 (0xe01fc0c0)))
#define SCB_PCONP           (*(pREG32 (0xe01fc0c4)))
#define SCB_VPBDIV          (*(pREG32 (0xe01fc100)))
#define SCB_EXTINT          (*(pREG32 (0xe01fc140)))
#define SCB_INTWAKE         (*(pREG32 (0xe01fc144)))
#define SCB_EXTMODE         (*(pREG32 (0xe01fc148)))
#define SCB_EXTPOLAR        (*(pREG32 (0xe01fc14c)))
#define SCB_RSIR            (*(pREG32 (0xe01fc180)))
#define SCB_CSPR            (*(pREG32 (0xe01fc184)))
#define SCB_SCS             (*(pREG32 (0xe01fc1a0)))

#define SCB_MEMMAP_BLM      (0x00000000)
#define SCB_MEMMAP_UFL      (0x00000001)
#define SCB_MEMMAP_URM      (0x00000002)
#define SCB_MEMMAP_RSVD     (0x00000003)
#define SCB_MEMMAP_MASK     (0x00000003)

#define SCB_PLLCON_PLLE     (0x00000001)
#define SCB_PLLCON_PLLC     (0x00000002)
#define SCB_PLLCON_MASK     (0x00000003)

#define SCB_PLLCFG_MSEL     (0x0000001f)
#define SCB_PLLCFG_PSEL     (0x00000060)
#define SCB_PLLCFG_MUL1     (0x00000000)
#define SCB_PLLCFG_MUL2     (0x00000001)
#define SCB_PLLCFG_MUL3     (0x00000002)
#define SCB_PLLCFG_MUL4     (0x00000003)
#define SCB_PLLCFG_MUL5     (0x00000004)
#define SCB_PLLCFG_MUL6     (0x00000005)
#define SCB_PLLCFG_MUL7     (0x00000006)
#define SCB_PLLCFG_MUL8     (0x00000007)
#define SCB_PLLCFG_MUL9     (0x00000008)
#define SCB_PLLCFG_MUL10    (0x00000009)
#define SCB_PLLCFG_MUL11    (0x0000000a)
#define SCB_PLLCFG_MUL12    (0x0000000b)
#define SCB_PLLCFG_MUL13    (0x0000000c)
#define SCB_PLLCFG_MUL14    (0x0000000d)
#define SCB_PLLCFG_MUL15    (0x0000000e)
#define SCB_PLLCFG_MUL16    (0x0000000f)
#define SCB_PLLCFG_MUL17    (0x00000010)
#define SCB_PLLCFG_MUL18    (0x00000011)
#define SCB_PLLCFG_MUL19    (0x00000012)
#define SCB_PLLCFG_MUL20    (0x00000013)
#define SCB_PLLCFG_MUL21    (0x00000014)
#define SCB_PLLCFG_MUL22    (0x00000015)
#define SCB_PLLCFG_MUL23    (0x00000016)
#define SCB_PLLCFG_MUL24    (0x00000017)
#define SCB_PLLCFG_MUL25    (0x00000018)
#define SCB_PLLCFG_MUL26    (0x00000019)
#define SCB_PLLCFG_MUL27    (0x0000001a)
#define SCB_PLLCFG_MUL28    (0x0000001b)
#define SCB_PLLCFG_MUL29    (0x0000001c)
#define SCB_PLLCFG_MUL30    (0x0000001d)
#define SCB_PLLCFG_MUL31    (0x0000001e)
#define SCB_PLLCFG_MUL32    (0x0000001f)
#define SCB_PLLCFG_DIV1     (0x00000000)
#define SCB_PLLCFG_DIV2     (0x00000020)
#define SCB_PLLCFG_DIV4     (0x00000040)
#define SCB_PLLCFG_DIV8     (0x00000060)
#define SCB_PLLCFG_MASK     (0x0000007f)

#define SCB_PLLSTAT_MSEL    (0x0000001f)
#define SCB_PLLSTAT_PSEL    (0x00000060)
#define SCB_PLLSTAT_PLLE    (0x00000100)
#define SCB_PLLSTAT_PLLC    (0x00000200)
#define SCB_PLLSTAT_PLOCK   (0x00000400)

#define SCB_PLLFEED_FEED1   (0x000000aa)
#define SCB_PLLFEED_FEED2   (0x00000055)

#define SCB_PCON_IDL        (0x00000001)
#define SCB_PCON_PD         (0x00000002)
#define SCB_PCON_PDBOD      (0x00000004)
#define SCB_PCON_BODPDM     (0x00000008)
#define SCB_PCON_BOGD       (0x00000010)
#define SCB_PCON_BORD       (0x00000020)
#define SCB_PCON_MASK       (0x0000003f)

#define SCB_PCONP_ALLOFF    (0x00000000)
#define SCB_PCONP_PCTIM0    (0x00000002)
#define SCB_PCONP_PCTIM1    (0x00000004)
#define SCB_PCONP_PCUART0   (0x00000008)
#define SCB_PCONP_PCUART1   (0x00000010)
#define SCB_PCONP_PCPWM0    (0x00000020)
#define SCB_PCONP_PCI2C0    (0x00000080)
#define SCB_PCONP_PCSPI0    (0x00000100)
#define SCB_PCONP_PCRTC     (0x00000200)
#define SCB_PCONP_PCSPI1    (0x00000400)
#define SCB_PCONP_PCAD0     (0x00001000)
#define SCB_PCONP_PCI2C1    (0x00080000)
#define SCB_PCONP_PCAD1     (0x00100000)
#define SCB_PCONP_PUSB      (0x80000000)
#define SCB_PCONP_ATRESET   (0x000003be)
#define SCB_PCONP_MASK      (0x801817be)

#define SCB_VPBDIV_25       (0x00000000)
#define SCB_VPBDIV_100      (0x00000001)
#define SCB_VPBDIV_50       (0x00000002)
#define SCB_VPBDIV_RSVD     (0x00000003)
#define SCB_VPBDIV_MASK     (0x00000003)

#define SCB_EXTINT_EINT0    (0x00000001)
#define SCB_EXTINT_EINT1    (0x00000002)
#define SCB_EXTINT_EINT2    (0x00000004)
#define SCB_EXTINT_EINT3    (0x00000008)
#define SCB_EXTINT_MASK     (0x0000000f)

#define SCB_INTWAKE_EINT0   (0x00000001)
#define SCB_INTWAKE_EINT1   (0x00000002)
#define SCB_INTWAKE_EINT2   (0x00000004)
#define SCB_INTWAKE_EINT3   (0x00000008)
#define SCB_INTWAKE_USB     (0x00000020)
#define SCB_INTWAKE_BOD     (0x00004000)
#define SCB_INTWAKE_RTC     (0x00008000)
#define SCB_INTWAKE_MASK    (0x0000c02f)

#define SCB_EXTMODE_EINT0   (0x00000001)
#define SCB_EXTMODE_EINT1   (0x00000002)
#define SCB_EXTMODE_EINT2   (0x00000004)
#define SCB_EXTMODE_EINT3   (0x00000008)
#define SCB_EXTMODE_MASK    (0x0000000f)

#define SCB_EXTPOLAR_EINT0  (0x00000001)
#define SCB_EXTPOLAR_EINT1  (0x00000002)
#define SCB_EXTPOLAR_EINT2  (0x00000004)
#define SCB_EXTPOLAR_EINT3  (0x00000008)
#define SCB_EXTPOLAR_MASK   (0x0000000f)

#define SCB_RSIR_POR        (0x00000001)
#define SCB_RSIR_EXTR       (0x00000002)
#define SCB_RSIR_WDTR       (0x00000004)
#define SCB_RSIR_BODR       (0x00000008)
#define SCB_RSIR_MASK       (0x0000000f)

#define SCB_SCS_GPIO0M      (0x00000001)
#define SCB_SCS_GPIO1M      (0x00000002)
#define SCB_SCS_MASK        (0x00000003)


/*##############################################################################
## System Control Block (USB)
##############################################################################*/

#define USB_PLLCON                (*(pREG32 (0xe01fc0a0)))
#define USB_PLLCFG                (*(pREG32 (0xe01fc0a4)))
#define USB_PLLSTAT               (*(pREG32 (0xe01fc0a8)))
#define USB_PLLFEED               (*(pREG32 (0xe01fc0ac)))

#define USB_IntSt                 (*(pREG32 (0xe01fc1c0)))

#define USB_DevIntSt              (*(pREG32 (0xe0090000)))
#define USB_DevIntEn              (*(pREG32 (0xe0090004)))
#define USB_DevIntClr             (*(pREG32 (0xe0090008)))
#define USB_DevIntSet             (*(pREG32 (0xe009000c)))
#define USB_DevIntPri             (*(pREG32 (0xe009002c)))

#define USB_EpIntSt               (*(pREG32 (0xe0090030)))
#define USB_EpIntEn               (*(pREG32 (0xe0090034)))
#define USB_EpIntClr              (*(pREG32 (0xe0090038)))
#define USB_EpIntSet              (*(pREG32 (0xe009003c)))
#define USB_EpIntPri              (*(pREG32 (0xe0090040)))

#define USB_ReEP                  (*(pREG32 (0xe0090044)))
#define USB_EpInd                 (*(pREG32 (0xe0090048)))
#define USB_MaxPSize              (*(pREG32 (0xe009004c)))

#define USB_RxData                (*(pREG32 (0xe0090018)))
#define USB_RxPLen                (*(pREG32 (0xe0090020)))
#define USB_TxData                (*(pREG32 (0xe009001c)))
#define USB_TxPLen                (*(pREG32 (0xe0090024)))
#define USB_Ctrl                  (*(pREG32 (0xe0090028)))

#define USB_CmdCode               (*(pREG32 (0xe0090010)))
#define USB_CmdData               (*(pREG32 (0xe0090014)))

#define USB_DMARSt                (*(pREG32 (0xe0090050)))
#define USB_DMARClr               (*(pREG32 (0xe0090054)))
#define USB_DMARSet               (*(pREG32 (0xe0090058)))
#define USB_UDCAH                 (*(pREG32 (0xe0090080)))
#define USB_EpDMASt               (*(pREG32 (0xe0090084)))
#define USB_EpDMAEn               (*(pREG32 (0xe0090088)))
#define USB_EpDMADis              (*(pREG32 (0xe009008c)))
#define USB_DMAIntSt              (*(pREG32 (0xe0090090)))
#define USB_DMAIntEn              (*(pREG32 (0xe0090094)))
#define USB_EoTIntSt              (*(pREG32 (0xe00900a0)))
#define USB_EoTIntClr             (*(pREG32 (0xe00900a4)))
#define USB_EoTIntSet             (*(pREG32 (0xe00900a8)))
#define USB_NDDRIntSt             (*(pREG32 (0xe00900ac)))
#define USB_NDDRIntClr            (*(pREG32 (0xe00900b0)))
#define USB_NDDRIntSet            (*(pREG32 (0xe00900b4)))
#define USB_SysErrIntSt           (*(pREG32 (0xe00900b8)))
#define USB_SysErrIntClr          (*(pREG32 (0xe00900bc)))
#define USB_SysErrIntSet          (*(pREG32 (0xe00900c0)))

#define USB_PLLCON_PLLE           (0x00000001)
#define USB_PLLCON_PLLC           (0x00000002)
#define USB_PLLCON_MASK           (0x00000003)

#define USB_PLLCFG_MSEL           (0x0000001f)
#define USB_PLLCFG_PSEL           (0x00000060)
#define USB_PLLCFG_MUL1           (0x00000000)
#define USB_PLLCFG_MUL2           (0x00000001)
#define USB_PLLCFG_MUL3           (0x00000002)
#define USB_PLLCFG_MUL4           (0x00000003)
#define USB_PLLCFG_MUL5           (0x00000004)
#define USB_PLLCFG_MUL6           (0x00000005)
#define USB_PLLCFG_MUL7           (0x00000006)
#define USB_PLLCFG_MUL8           (0x00000007)
#define USB_PLLCFG_MUL9           (0x00000008)
#define USB_PLLCFG_MUL10          (0x00000009)
#define USB_PLLCFG_MUL11          (0x0000000a)
#define USB_PLLCFG_MUL12          (0x0000000b)
#define USB_PLLCFG_MUL13          (0x0000000c)
#define USB_PLLCFG_MUL14          (0x0000000d)
#define USB_PLLCFG_MUL15          (0x0000000e)
#define USB_PLLCFG_MUL16          (0x0000000f)
#define USB_PLLCFG_MUL17          (0x00000010)
#define USB_PLLCFG_MUL18          (0x00000011)
#define USB_PLLCFG_MUL19          (0x00000012)
#define USB_PLLCFG_MUL20          (0x00000013)
#define USB_PLLCFG_MUL21          (0x00000014)
#define USB_PLLCFG_MUL22          (0x00000015)
#define USB_PLLCFG_MUL23          (0x00000016)
#define USB_PLLCFG_MUL24          (0x00000017)
#define USB_PLLCFG_MUL25          (0x00000018)
#define USB_PLLCFG_MUL26          (0x00000019)
#define USB_PLLCFG_MUL27          (0x0000001a)
#define USB_PLLCFG_MUL28          (0x0000001b)
#define USB_PLLCFG_MUL29          (0x0000001c)
#define USB_PLLCFG_MUL30          (0x0000001d)
#define USB_PLLCFG_MUL31          (0x0000001e)
#define USB_PLLCFG_MUL32          (0x0000001f)
#define USB_PLLCFG_DIV1           (0x00000000)
#define USB_PLLCFG_DIV2           (0x00000020)
#define USB_PLLCFG_DIV4           (0x00000040)
#define USB_PLLCFG_DIV8           (0x00000060)
#define USB_PLLCFG_MASK           (0x0000007f)

#define USB_PLLSTAT_MSEL          (0x0000001f)
#define USB_PLLSTAT_PSEL          (0x00000060)
#define USB_PLLSTAT_PLLE          (0x00000100)
#define USB_PLLSTAT_PLLC          (0x00000200)
#define USB_PLLSTAT_PLOCK         (0x00000400)

#define USB_PLLFEED_FEED1         (0x000000aa)
#define USB_PLLFEED_FEED2         (0x00000055)

#define USB_IntSt_REQLP           (0x00000001)
#define USB_IntSt_REQHP           (0x00000002)
#define USB_IntSt_REQDMA          (0x00000004)
#define USB_IntSt_NeedClock       (0x00000100)
#define USB_IntSt_EnUSBInts       (0x80000000)
#define USB_IntSt_MASK            (0x80000107)

#define USB_DevIntSt_FRAME        (0x00000001)
#define USB_DevIntSt_EPFAST       (0x00000002)
#define USB_DevIntSt_EPSLOW       (0x00000004)
#define USB_DevIntSt_DEVSTAT      (0x00000008)
#define USB_DevIntSt_CCEMTY       (0x00000010)
#define USB_DevIntSt_CDFULL       (0x00000020)
#define USB_DevIntSt_RxENDPKT     (0x00000040)
#define USB_DevIntSt_TxENDPKT     (0x00000080)
#define USB_DevIntSt_EPRLZED      (0x00000100)
#define USB_DevIntSt_EPRINT       (0x00000200)
#define USB_DevIntSt_MASK         (0x000003ff)

#define USB_DevIntEn_NONE         (0x00000000)
#define USB_DevIntEn_FRAME        (0x00000001)
#define USB_DevIntEn_EPFAST       (0x00000002)
#define USB_DevIntEn_EPSLOW       (0x00000004)
#define USB_DevIntEn_DEVSTAT      (0x00000008)
#define USB_DevIntEn_CCEMTY       (0x00000010)
#define USB_DevIntEn_CDFULL       (0x00000020)
#define USB_DevIntEn_RxENDPKT     (0x00000040)
#define USB_DevIntEn_TxENDPKT     (0x00000080)
#define USB_DevIntEn_EPRLZED      (0x00000100)
#define USB_DevIntEn_EPRINT       (0x00000200)
#define USB_DevIntEn_MASK         (0x000003ff)

#define USB_DevIntClr_FRAME       (0x00000001)
#define USB_DevIntClr_EPFAST      (0x00000002)
#define USB_DevIntClr_EPSLOW      (0x00000004)
#define USB_DevIntClr_DEVSTAT     (0x00000008)
#define USB_DevIntClr_CCEMTY      (0x00000010)
#define USB_DevIntClr_CDFULL      (0x00000020)
#define USB_DevIntClr_RxENDPKT    (0x00000040)
#define USB_DevIntClr_TxENDPKT    (0x00000080)
#define USB_DevIntClr_EPRLZED     (0x00000100)
#define USB_DevIntClr_EPRINT      (0x00000200)
#define USB_DevIntClr_ALL         (0x000003ff)
#define USB_DevIntClr_MASK        (0x000003ff)

#define USB_DevIntSet_FRAME       (0x00000001)
#define USB_DevIntSet_EPFAST      (0x00000002)
#define USB_DevIntSet_EPSLOW      (0x00000004)
#define USB_DevIntSet_DEVSTAT     (0x00000008)
#define USB_DevIntSet_CCEMTY      (0x00000010)
#define USB_DevIntSet_CDFULL      (0x00000020)
#define USB_DevIntSet_RxENDPKT    (0x00000040)
#define USB_DevIntSet_TxENDPKT    (0x00000080)
#define USB_DevIntSet_EPRLZED     (0x00000100)
#define USB_DevIntSet_EPRINT      (0x00000200)
#define USB_DevIntSet_MASK        (0x000003ff)

#define USB_DevIntPri_NONE        (0x00000000)
#define USB_DevIntPri_FRAME       (0x00000001)
#define USB_DevIntPri_EPFAST      (0x00000002)
#define USB_DevIntPri_MASK        (0x00000003)

#define USB_EpIntSt_EP0RX         (0x00000001)
#define USB_EpIntSt_EP0TX         (0x00000002)
#define USB_EpIntSt_EP1RX         (0x00000004)
#define USB_EpIntSt_EP1TX         (0x00000008)
#define USB_EpIntSt_EP2RX         (0x00000010)
#define USB_EpIntSt_EP2TX         (0x00000020)
#define USB_EpIntSt_EP3RX         (0x00000040)
#define USB_EpIntSt_EP3TX         (0x00000080)
#define USB_EpIntSt_EP4RX         (0x00000100)
#define USB_EpIntSt_EP4TX         (0x00000200)
#define USB_EpIntSt_EP5RX         (0x00000400)
#define USB_EpIntSt_EP5TX         (0x00000800)
#define USB_EpIntSt_EP6RX         (0x00001000)
#define USB_EpIntSt_EP6TX         (0x00002000)
#define USB_EpIntSt_EP7RX         (0x00004000)
#define USB_EpIntSt_EP7TX         (0x00008000)
#define USB_EpIntSt_EP8RX         (0x00010000)
#define USB_EpIntSt_EP8TX         (0x00020000)
#define USB_EpIntSt_EP9RX         (0x00040000)
#define USB_EpIntSt_EP9TX         (0x00080000)
#define USB_EpIntSt_EP10RX        (0x00100000)
#define USB_EpIntSt_EP10TX        (0x00200000)
#define USB_EpIntSt_EP11RX        (0x00400000)
#define USB_EpIntSt_EP11TX        (0x00800000)
#define USB_EpIntSt_EP12RX        (0x01000000)
#define USB_EpIntSt_EP12TX        (0x02000000)
#define USB_EpIntSt_EP13RX        (0x04000000)
#define USB_EpIntSt_EP13TX        (0x08000000)
#define USB_EpIntSt_EP14RX        (0x10000000)
#define USB_EpIntSt_EP14TX        (0x20000000)
#define USB_EpIntSt_EP15RX        (0x40000000)
#define USB_EpIntSt_EP15TX        (0x80000000)
#define USB_EpIntSt_MASK          (0xffffffff)

#define USB_EpIntEn_NONE          (0x00000000)
#define USB_EpIntEn_EP0RX         (0x00000001)
#define USB_EpIntEn_EP0TX         (0x00000002)
#define USB_EpIntEn_EP1RX         (0x00000004)
#define USB_EpIntEn_EP1TX         (0x00000008)
#define USB_EpIntEn_EP2RX         (0x00000010)
#define USB_EpIntEn_EP2TX         (0x00000020)
#define USB_EpIntEn_EP3RX         (0x00000040)
#define USB_EpIntEn_EP3TX         (0x00000080)
#define USB_EpIntEn_EP4RX         (0x00000100)
#define USB_EpIntEn_EP4TX         (0x00000200)
#define USB_EpIntEn_EP5RX         (0x00000400)
#define USB_EpIntEn_EP5TX         (0x00000800)
#define USB_EpIntEn_EP6RX         (0x00001000)
#define USB_EpIntEn_EP6TX         (0x00002000)
#define USB_EpIntEn_EP7RX         (0x00004000)
#define USB_EpIntEn_EP7TX         (0x00008000)
#define USB_EpIntEn_EP8RX         (0x00010000)
#define USB_EpIntEn_EP8TX         (0x00020000)
#define USB_EpIntEn_EP9RX         (0x00040000)
#define USB_EpIntEn_EP9TX         (0x00080000)
#define USB_EpIntEn_EP10RX        (0x00100000)
#define USB_EpIntEn_EP10TX        (0x00200000)
#define USB_EpIntEn_EP11RX        (0x00400000)
#define USB_EpIntEn_EP11TX        (0x00800000)
#define USB_EpIntEn_EP12RX        (0x01000000)
#define USB_EpIntEn_EP12TX        (0x02000000)
#define USB_EpIntEn_EP13RX        (0x04000000)
#define USB_EpIntEn_EP13TX        (0x08000000)
#define USB_EpIntEn_EP14RX        (0x10000000)
#define USB_EpIntEn_EP14TX        (0x20000000)
#define USB_EpIntEn_EP15RX        (0x40000000)
#define USB_EpIntEn_EP15TX        (0x80000000)
#define USB_EpIntEn_MASK          (0xffffffff)

#define USB_EpIntClr_EP0RX        (0x00000001)
#define USB_EpIntClr_EP0TX        (0x00000002)
#define USB_EpIntClr_EP1RX        (0x00000004)
#define USB_EpIntClr_EP1TX        (0x00000008)
#define USB_EpIntClr_EP2RX        (0x00000010)
#define USB_EpIntClr_EP2TX        (0x00000020)
#define USB_EpIntClr_EP3RX        (0x00000040)
#define USB_EpIntClr_EP3TX        (0x00000080)
#define USB_EpIntClr_EP4RX        (0x00000100)
#define USB_EpIntClr_EP4TX        (0x00000200)
#define USB_EpIntClr_EP5RX        (0x00000400)
#define USB_EpIntClr_EP5TX        (0x00000800)
#define USB_EpIntClr_EP6RX        (0x00001000)
#define USB_EpIntClr_EP6TX        (0x00002000)
#define USB_EpIntClr_EP7RX        (0x00004000)
#define USB_EpIntClr_EP7TX        (0x00008000)
#define USB_EpIntClr_EP8RX        (0x00010000)
#define USB_EpIntClr_EP8TX        (0x00020000)
#define USB_EpIntClr_EP9RX        (0x00040000)
#define USB_EpIntClr_EP9TX        (0x00080000)
#define USB_EpIntClr_EP10RX       (0x00100000)
#define USB_EpIntClr_EP10TX       (0x00200000)
#define USB_EpIntClr_EP11RX       (0x00400000)
#define USB_EpIntClr_EP11TX       (0x00800000)
#define USB_EpIntClr_EP12RX       (0x01000000)
#define USB_EpIntClr_EP12TX       (0x02000000)
#define USB_EpIntClr_EP13RX       (0x04000000)
#define USB_EpIntClr_EP13TX       (0x08000000)
#define USB_EpIntClr_EP14RX       (0x10000000)
#define USB_EpIntClr_EP14TX       (0x20000000)
#define USB_EpIntClr_EP15RX       (0x40000000)
#define USB_EpIntClr_EP15TX       (0x80000000)
#define USB_EpIntClr_ALL          (0xffffffff)
#define USB_EpIntClr_MASK         (0xffffffff)

#define USB_EpIntSet_EP0RX        (0x00000001)
#define USB_EpIntSet_EP0TX        (0x00000002)
#define USB_EpIntSet_EP1RX        (0x00000004)
#define USB_EpIntSet_EP1TX        (0x00000008)
#define USB_EpIntSet_EP2RX        (0x00000010)
#define USB_EpIntSet_EP2TX        (0x00000020)
#define USB_EpIntSet_EP3RX        (0x00000040)
#define USB_EpIntSet_EP3TX        (0x00000080)
#define USB_EpIntSet_EP4RX        (0x00000100)
#define USB_EpIntSet_EP4TX        (0x00000200)
#define USB_EpIntSet_EP5RX        (0x00000400)
#define USB_EpIntSet_EP5TX        (0x00000800)
#define USB_EpIntSet_EP6RX        (0x00001000)
#define USB_EpIntSet_EP6TX        (0x00002000)
#define USB_EpIntSet_EP7RX        (0x00004000)
#define USB_EpIntSet_EP7TX        (0x00008000)
#define USB_EpIntSet_EP8RX        (0x00010000)
#define USB_EpIntSet_EP8TX        (0x00020000)
#define USB_EpIntSet_EP9RX        (0x00040000)
#define USB_EpIntSet_EP9TX        (0x00080000)
#define USB_EpIntSet_EP10RX       (0x00100000)
#define USB_EpIntSet_EP10TX       (0x00200000)
#define USB_EpIntSet_EP11RX       (0x00400000)
#define USB_EpIntSet_EP11TX       (0x00800000)
#define USB_EpIntSet_EP12RX       (0x01000000)
#define USB_EpIntSet_EP12TX       (0x02000000)
#define USB_EpIntSet_EP13RX       (0x04000000)
#define USB_EpIntSet_EP13TX       (0x08000000)
#define USB_EpIntSet_EP14RX       (0x10000000)
#define USB_EpIntSet_EP14TX       (0x20000000)
#define USB_EpIntSet_EP15RX       (0x40000000)
#define USB_EpIntSet_EP15TX       (0x80000000)
#define USB_EpIntSet_MASK         (0xffffffff)

#define USB_EpIntPri_NONE         (0x00000000)
#define USB_EpIntPri_EP0RX        (0x00000001)
#define USB_EpIntPri_EP0TX        (0x00000002)
#define USB_EpIntPri_EP1RX        (0x00000004)
#define USB_EpIntPri_EP1TX        (0x00000008)
#define USB_EpIntPri_EP2RX        (0x00000010)
#define USB_EpIntPri_EP2TX        (0x00000020)
#define USB_EpIntPri_EP3RX        (0x00000040)
#define USB_EpIntPri_EP3TX        (0x00000080)
#define USB_EpIntPri_EP4RX        (0x00000100)
#define USB_EpIntPri_EP4TX        (0x00000200)
#define USB_EpIntPri_EP5RX        (0x00000400)
#define USB_EpIntPri_EP5TX        (0x00000800)
#define USB_EpIntPri_EP6RX        (0x00001000)
#define USB_EpIntPri_EP6TX        (0x00002000)
#define USB_EpIntPri_EP7RX        (0x00004000)
#define USB_EpIntPri_EP7TX        (0x00008000)
#define USB_EpIntPri_EP8RX        (0x00010000)
#define USB_EpIntPri_EP8TX        (0x00020000)
#define USB_EpIntPri_EP9RX        (0x00040000)
#define USB_EpIntPri_EP9TX        (0x00080000)
#define USB_EpIntPri_EP10RX       (0x00100000)
#define USB_EpIntPri_EP10TX       (0x00200000)
#define USB_EpIntPri_EP11RX       (0x00400000)
#define USB_EpIntPri_EP11TX       (0x00800000)
#define USB_EpIntPri_EP12RX       (0x01000000)
#define USB_EpIntPri_EP12TX       (0x02000000)
#define USB_EpIntPri_EP13RX       (0x04000000)
#define USB_EpIntPri_EP13TX       (0x08000000)
#define USB_EpIntPri_EP14RX       (0x10000000)
#define USB_EpIntPri_EP14TX       (0x20000000)
#define USB_EpIntPri_EP15RX       (0x40000000)
#define USB_EpIntPri_EP15TX       (0x80000000)
#define USB_EpIntPri_MASK         (0xffffffff)

#define USB_EpRE_EP0              (0x00000001)
#define USB_EpRE_EP1              (0x00000002)
#define USB_EpRE_EP2              (0x00000004)
#define USB_EpRE_EP3              (0x00000008)
#define USB_EpRE_EP4              (0x00000010)
#define USB_EpRE_EP5              (0x00000020)
#define USB_EpRE_EP6              (0x00000040)
#define USB_EpRE_EP7              (0x00000080)
#define USB_EpRE_EP8              (0x00000100)
#define USB_EpRE_EP9              (0x00000200)
#define USB_EpRE_EP10             (0x00000400)
#define USB_EpRE_EP11             (0x00000800)
#define USB_EpRE_EP12             (0x00001000)
#define USB_EpRE_EP13             (0x00002000)
#define USB_EpRE_EP14             (0x00004000)
#define USB_EpRE_EP15             (0x00008000)
#define USB_EpRE_EP16             (0x00010000)
#define USB_EpRE_EP17             (0x00020000)
#define USB_EpRE_EP18             (0x00040000)
#define USB_EpRE_EP19             (0x00080000)
#define USB_EpRE_EP20             (0x00100000)
#define USB_EpRE_EP21             (0x00200000)
#define USB_EpRE_EP22             (0x00400000)
#define USB_EpRE_EP23             (0x00800000)
#define USB_EpRE_EP24             (0x01000000)
#define USB_EpRE_EP25             (0x02000000)
#define USB_EpRE_EP26             (0x04000000)
#define USB_EpRE_EP27             (0x08000000)
#define USB_EpRE_EP28             (0x10000000)
#define USB_EpRE_EP29             (0x20000000)
#define USB_EpRE_EP30             (0x40000000)
#define USB_EpRE_EP31             (0x80000000)
#define USB_EpRE_MASK             (0xffffffff)

#define USB_EpIn_MASK             (0x0000001f)

#define USB_MaxPSize_MASK         (0x000003ff)

#define USB_RxPLen_PKTLENGTH      (0x000003ff)
#define USB_RxPLen_PKTLENGTH_MASK (0x000003ff)
#define USB_RxPLen_DV             (0x00000400)
#define USB_RxPLen_PKTRDY         (0x00000800)
#define USB_RxPLen_MASK           (0x00000fff)

#define USB_TxPLen_PKTLENGTH      (0x000003ff)
#define USB_TxPLen_MASK           (0x000003ff)

#define USB_Ctrl_RDEN             (0x00000001)
#define USB_Ctrl_WREN             (0x00000002)
#define USB_Ctrl_LOGENDPOINT      (0x0000003c)
#define USB_Ctrl_MASK             (0x0000003f)

#define USB_CmdCode_CMDPHASE      (0x0000ff00)
#define USB_CmdCode_CMDCODE       (0x00ff0000)
#define USB_CmdCode_MASK          (0x00ffff00)

#define USB_CmdData_MASK          (0x000000ff)

#define USB_DMARSt_EP0            (0x00000001)
#define USB_DMARSt_EP1            (0x00000002)
#define USB_DMARSt_EP2            (0x00000004)
#define USB_DMARSt_EP3            (0x00000008)
#define USB_DMARSt_EP4            (0x00000010)
#define USB_DMARSt_EP5            (0x00000020)
#define USB_DMARSt_EP6            (0x00000040)
#define USB_DMARSt_EP7            (0x00000080)
#define USB_DMARSt_EP8            (0x00000100)
#define USB_DMARSt_EP9            (0x00000200)
#define USB_DMARSt_EP10           (0x00000400)
#define USB_DMARSt_EP11           (0x00000800)
#define USB_DMARSt_EP12           (0x00001000)
#define USB_DMARSt_EP13           (0x00002000)
#define USB_DMARSt_EP14           (0x00004000)
#define USB_DMARSt_EP15           (0x00008000)
#define USB_DMARSt_EP16           (0x00010000)
#define USB_DMARSt_EP17           (0x00020000)
#define USB_DMARSt_EP18           (0x00040000)
#define USB_DMARSt_EP19           (0x00080000)
#define USB_DMARSt_EP20           (0x00100000)
#define USB_DMARSt_EP21           (0x00200000)
#define USB_DMARSt_EP22           (0x00400000)
#define USB_DMARSt_EP23           (0x00800000)
#define USB_DMARSt_EP24           (0x01000000)
#define USB_DMARSt_EP25           (0x02000000)
#define USB_DMARSt_EP26           (0x04000000)
#define USB_DMARSt_EP27           (0x08000000)
#define USB_DMARSt_EP28           (0x10000000)
#define USB_DMARSt_EP29           (0x20000000)
#define USB_DMARSt_EP30           (0x40000000)
#define USB_DMARSt_EP31           (0x80000000)
#define USB_DMARSt_MASK           (0xffffffff)

#define USB_DMARClr_EP0           (0x00000001)
#define USB_DMARClr_EP1           (0x00000002)
#define USB_DMARClr_EP2           (0x00000004)
#define USB_DMARClr_EP3           (0x00000008)
#define USB_DMARClr_EP4           (0x00000010)
#define USB_DMARClr_EP5           (0x00000020)
#define USB_DMARClr_EP6           (0x00000040)
#define USB_DMARClr_EP7           (0x00000080)
#define USB_DMARClr_EP8           (0x00000100)
#define USB_DMARClr_EP9           (0x00000200)
#define USB_DMARClr_EP10          (0x00000400)
#define USB_DMARClr_EP11          (0x00000800)
#define USB_DMARClr_EP12          (0x00001000)
#define USB_DMARClr_EP13          (0x00002000)
#define USB_DMARClr_EP14          (0x00004000)
#define USB_DMARClr_EP15          (0x00008000)
#define USB_DMARClr_EP16          (0x00010000)
#define USB_DMARClr_EP17          (0x00020000)
#define USB_DMARClr_EP18          (0x00040000)
#define USB_DMARClr_EP19          (0x00080000)
#define USB_DMARClr_EP20          (0x00100000)
#define USB_DMARClr_EP21          (0x00200000)
#define USB_DMARClr_EP22          (0x00400000)
#define USB_DMARClr_EP23          (0x00800000)
#define USB_DMARClr_EP24          (0x01000000)
#define USB_DMARClr_EP25          (0x02000000)
#define USB_DMARClr_EP26          (0x04000000)
#define USB_DMARClr_EP27          (0x08000000)
#define USB_DMARClr_EP28          (0x10000000)
#define USB_DMARClr_EP29          (0x20000000)
#define USB_DMARClr_EP30          (0x40000000)
#define USB_DMARClr_EP31          (0x80000000)
#define USB_DMARClr_MASK          (0xffffffff)

#define USB_DMARSet_EP0           (0x00000001)
#define USB_DMARSet_EP1           (0x00000002)
#define USB_DMARSet_EP2           (0x00000004)
#define USB_DMARSet_EP3           (0x00000008)
#define USB_DMARSet_EP4           (0x00000010)
#define USB_DMARSet_EP5           (0x00000020)
#define USB_DMARSet_EP6           (0x00000040)
#define USB_DMARSet_EP7           (0x00000080)
#define USB_DMARSet_EP8           (0x00000100)
#define USB_DMARSet_EP9           (0x00000200)
#define USB_DMARSet_EP10          (0x00000400)
#define USB_DMARSet_EP11          (0x00000800)
#define USB_DMARSet_EP12          (0x00001000)
#define USB_DMARSet_EP13          (0x00002000)
#define USB_DMARSet_EP14          (0x00004000)
#define USB_DMARSet_EP15          (0x00008000)
#define USB_DMARSet_EP16          (0x00010000)
#define USB_DMARSet_EP17          (0x00020000)
#define USB_DMARSet_EP18          (0x00040000)
#define USB_DMARSet_EP19          (0x00080000)
#define USB_DMARSet_EP20          (0x00100000)
#define USB_DMARSet_EP21          (0x00200000)
#define USB_DMARSet_EP22          (0x00400000)
#define USB_DMARSet_EP23          (0x00800000)
#define USB_DMARSet_EP24          (0x01000000)
#define USB_DMARSet_EP25          (0x02000000)
#define USB_DMARSet_EP26          (0x04000000)
#define USB_DMARSet_EP27          (0x08000000)
#define USB_DMARSet_EP28          (0x10000000)
#define USB_DMARSet_EP29          (0x20000000)
#define USB_DMARSet_EP30          (0x40000000)
#define USB_DMARSet_EP31          (0x80000000)
#define USB_DMARSet_MASK          (0xffffffff)

#define USB_EpDMASt_EP0           (0x00000001)
#define USB_EpDMASt_EP1           (0x00000002)
#define USB_EpDMASt_EP2           (0x00000004)
#define USB_EpDMASt_EP3           (0x00000008)
#define USB_EpDMASt_EP4           (0x00000010)
#define USB_EpDMASt_EP5           (0x00000020)
#define USB_EpDMASt_EP6           (0x00000040)
#define USB_EpDMASt_EP7           (0x00000080)
#define USB_EpDMASt_EP8           (0x00000100)
#define USB_EpDMASt_EP9           (0x00000200)
#define USB_EpDMASt_EP10          (0x00000400)
#define USB_EpDMASt_EP11          (0x00000800)
#define USB_EpDMASt_EP12          (0x00001000)
#define USB_EpDMASt_EP13          (0x00002000)
#define USB_EpDMASt_EP14          (0x00004000)
#define USB_EpDMASt_EP15          (0x00008000)
#define USB_EpDMASt_EP16          (0x00010000)
#define USB_EpDMASt_EP17          (0x00020000)
#define USB_EpDMASt_EP18          (0x00040000)
#define USB_EpDMASt_EP19          (0x00080000)
#define USB_EpDMASt_EP20          (0x00100000)
#define USB_EpDMASt_EP21          (0x00200000)
#define USB_EpDMASt_EP22          (0x00400000)
#define USB_EpDMASt_EP23          (0x00800000)
#define USB_EpDMASt_EP24          (0x01000000)
#define USB_EpDMASt_EP25          (0x02000000)
#define USB_EpDMASt_EP26          (0x04000000)
#define USB_EpDMASt_EP27          (0x08000000)
#define USB_EpDMASt_EP28          (0x10000000)
#define USB_EpDMASt_EP29          (0x20000000)
#define USB_EpDMASt_EP30          (0x40000000)
#define USB_EpDMASt_EP31          (0x80000000)
#define USB_EpDMASt_MASK          (0xffffffff)

#define USB_EpDMAEn_EP0           (0x00000001)
#define USB_EpDMAEn_EP1           (0x00000002)
#define USB_EpDMAEn_EP2           (0x00000004)
#define USB_EpDMAEn_EP3           (0x00000008)
#define USB_EpDMAEn_EP4           (0x00000010)
#define USB_EpDMAEn_EP5           (0x00000020)
#define USB_EpDMAEn_EP6           (0x00000040)
#define USB_EpDMAEn_EP7           (0x00000080)
#define USB_EpDMAEn_EP8           (0x00000100)
#define USB_EpDMAEn_EP9           (0x00000200)
#define USB_EpDMAEn_EP10          (0x00000400)
#define USB_EpDMAEn_EP11          (0x00000800)
#define USB_EpDMAEn_EP12          (0x00001000)
#define USB_EpDMAEn_EP13          (0x00002000)
#define USB_EpDMAEn_EP14          (0x00004000)
#define USB_EpDMAEn_EP15          (0x00008000)
#define USB_EpDMAEn_EP16          (0x00010000)
#define USB_EpDMAEn_EP17          (0x00020000)
#define USB_EpDMAEn_EP18          (0x00040000)
#define USB_EpDMAEn_EP19          (0x00080000)
#define USB_EpDMAEn_EP20          (0x00100000)
#define USB_EpDMAEn_EP21          (0x00200000)
#define USB_EpDMAEn_EP22          (0x00400000)
#define USB_EpDMAEn_EP23          (0x00800000)
#define USB_EpDMAEn_EP24          (0x01000000)
#define USB_EpDMAEn_EP25          (0x02000000)
#define USB_EpDMAEn_EP26          (0x04000000)
#define USB_EpDMAEn_EP27          (0x08000000)
#define USB_EpDMAEn_EP28          (0x10000000)
#define USB_EpDMAEn_EP29          (0x20000000)
#define USB_EpDMAEn_EP30          (0x40000000)
#define USB_EpDMAEn_EP31          (0x80000000)
#define USB_EpDMAEn_MASK          (0xffffffff)

#define USB_EpDMADis_EP0          (0x00000001)
#define USB_EpDMADis_EP1          (0x00000002)
#define USB_EpDMADis_EP2          (0x00000004)
#define USB_EpDMADis_EP3          (0x00000008)
#define USB_EpDMADis_EP4          (0x00000010)
#define USB_EpDMADis_EP5          (0x00000020)
#define USB_EpDMADis_EP6          (0x00000040)
#define USB_EpDMADis_EP7          (0x00000080)
#define USB_EpDMADis_EP8          (0x00000100)
#define USB_EpDMADis_EP9          (0x00000200)
#define USB_EpDMADis_EP10         (0x00000400)
#define USB_EpDMADis_EP11         (0x00000800)
#define USB_EpDMADis_EP12         (0x00001000)
#define USB_EpDMADis_EP13         (0x00002000)
#define USB_EpDMADis_EP14         (0x00004000)
#define USB_EpDMADis_EP15         (0x00008000)
#define USB_EpDMADis_EP16         (0x00010000)
#define USB_EpDMADis_EP17         (0x00020000)
#define USB_EpDMADis_EP18         (0x00040000)
#define USB_EpDMADis_EP19         (0x00080000)
#define USB_EpDMADis_EP20         (0x00100000)
#define USB_EpDMADis_EP21         (0x00200000)
#define USB_EpDMADis_EP22         (0x00400000)
#define USB_EpDMADis_EP23         (0x00800000)
#define USB_EpDMADis_EP24         (0x01000000)
#define USB_EpDMADis_EP25         (0x02000000)
#define USB_EpDMADis_EP26         (0x04000000)
#define USB_EpDMADis_EP27         (0x08000000)
#define USB_EpDMADis_EP28         (0x10000000)
#define USB_EpDMADis_EP29         (0x20000000)
#define USB_EpDMADis_EP30         (0x40000000)
#define USB_EpDMADis_EP31         (0x80000000)
#define USB_EpDMADis_MASK         (0xffffffff)

#define USB_DMAInstSt_EOT         (0x00000001)
#define USB_DMAInstSt_NDDR        (0x00000002)
#define USB_DMAInstSt_SE          (0x00000004)
#define USB_DMAInstSt_MASK        (0x00000007)

#define USB_DMAInstEn_EOT         (0x00000001)
#define USB_DMAInstEn_NDDR        (0x00000002)
#define USB_DMAInstEn_SE          (0x00000004)
#define USB_DMAInstEn_MASK        (0x00000007)

#define USB_EoTIntSt_EP0          (0x00000001)
#define USB_EoTIntSt_EP1          (0x00000002)
#define USB_EoTIntSt_EP2          (0x00000004)
#define USB_EoTIntSt_EP3          (0x00000008)
#define USB_EoTIntSt_EP4          (0x00000010)
#define USB_EoTIntSt_EP5          (0x00000020)
#define USB_EoTIntSt_EP6          (0x00000040)
#define USB_EoTIntSt_EP7          (0x00000080)
#define USB_EoTIntSt_EP8          (0x00000100)
#define USB_EoTIntSt_EP9          (0x00000200)
#define USB_EoTIntSt_EP10         (0x00000400)
#define USB_EoTIntSt_EP11         (0x00000800)
#define USB_EoTIntSt_EP12         (0x00001000)
#define USB_EoTIntSt_EP13         (0x00002000)
#define USB_EoTIntSt_EP14         (0x00004000)
#define USB_EoTIntSt_EP15         (0x00008000)
#define USB_EoTIntSt_EP16         (0x00010000)
#define USB_EoTIntSt_EP17         (0x00020000)
#define USB_EoTIntSt_EP18         (0x00040000)
#define USB_EoTIntSt_EP19         (0x00080000)
#define USB_EoTIntSt_EP20         (0x00100000)
#define USB_EoTIntSt_EP21         (0x00200000)
#define USB_EoTIntSt_EP22         (0x00400000)
#define USB_EoTIntSt_EP23         (0x00800000)
#define USB_EoTIntSt_EP24         (0x01000000)
#define USB_EoTIntSt_EP25         (0x02000000)
#define USB_EoTIntSt_EP26         (0x04000000)
#define USB_EoTIntSt_EP27         (0x08000000)
#define USB_EoTIntSt_EP28         (0x10000000)
#define USB_EoTIntSt_EP29         (0x20000000)
#define USB_EoTIntSt_EP30         (0x40000000)
#define USB_EoTIntSt_EP31         (0x80000000)
#define USB_EoTIntSt_MASK         (0xffffffff)

#define USB_EoTIntClr_EP0         (0x00000001)
#define USB_EoTIntClr_EP1         (0x00000002)
#define USB_EoTIntClr_EP2         (0x00000004)
#define USB_EoTIntClr_EP3         (0x00000008)
#define USB_EoTIntClr_EP4         (0x00000010)
#define USB_EoTIntClr_EP5         (0x00000020)
#define USB_EoTIntClr_EP6         (0x00000040)
#define USB_EoTIntClr_EP7         (0x00000080)
#define USB_EoTIntClr_EP8         (0x00000100)
#define USB_EoTIntClr_EP9         (0x00000200)
#define USB_EoTIntClr_EP10        (0x00000400)
#define USB_EoTIntClr_EP11        (0x00000800)
#define USB_EoTIntClr_EP12        (0x00001000)
#define USB_EoTIntClr_EP13        (0x00002000)
#define USB_EoTIntClr_EP14        (0x00004000)
#define USB_EoTIntClr_EP15        (0x00008000)
#define USB_EoTIntClr_EP16        (0x00010000)
#define USB_EoTIntClr_EP17        (0x00020000)
#define USB_EoTIntClr_EP18        (0x00040000)
#define USB_EoTIntClr_EP19        (0x00080000)
#define USB_EoTIntClr_EP20        (0x00100000)
#define USB_EoTIntClr_EP21        (0x00200000)
#define USB_EoTIntClr_EP22        (0x00400000)
#define USB_EoTIntClr_EP23        (0x00800000)
#define USB_EoTIntClr_EP24        (0x01000000)
#define USB_EoTIntClr_EP25        (0x02000000)
#define USB_EoTIntClr_EP26        (0x04000000)
#define USB_EoTIntClr_EP27        (0x08000000)
#define USB_EoTIntClr_EP28        (0x10000000)
#define USB_EoTIntClr_EP29        (0x20000000)
#define USB_EoTIntClr_EP30        (0x40000000)
#define USB_EoTIntClr_EP31        (0x80000000)
#define USB_EoTIntClr_MASK        (0xffffffff)

#define USB_EoTIntSet_EP0         (0x00000001)
#define USB_EoTIntSet_EP1         (0x00000002)
#define USB_EoTIntSet_EP2         (0x00000004)
#define USB_EoTIntSet_EP3         (0x00000008)
#define USB_EoTIntSet_EP4         (0x00000010)
#define USB_EoTIntSet_EP5         (0x00000020)
#define USB_EoTIntSet_EP6         (0x00000040)
#define USB_EoTIntSet_EP7         (0x00000080)
#define USB_EoTIntSet_EP8         (0x00000100)
#define USB_EoTIntSet_EP9         (0x00000200)
#define USB_EoTIntSet_EP10        (0x00000400)
#define USB_EoTIntSet_EP11        (0x00000800)
#define USB_EoTIntSet_EP12        (0x00001000)
#define USB_EoTIntSet_EP13        (0x00002000)
#define USB_EoTIntSet_EP14        (0x00004000)
#define USB_EoTIntSet_EP15        (0x00008000)
#define USB_EoTIntSet_EP16        (0x00010000)
#define USB_EoTIntSet_EP17        (0x00020000)
#define USB_EoTIntSet_EP18        (0x00040000)
#define USB_EoTIntSet_EP19        (0x00080000)
#define USB_EoTIntSet_EP20        (0x00100000)
#define USB_EoTIntSet_EP21        (0x00200000)
#define USB_EoTIntSet_EP22        (0x00400000)
#define USB_EoTIntSet_EP23        (0x00800000)
#define USB_EoTIntSet_EP24        (0x01000000)
#define USB_EoTIntSet_EP25        (0x02000000)
#define USB_EoTIntSet_EP26        (0x04000000)
#define USB_EoTIntSet_EP27        (0x08000000)
#define USB_EoTIntSet_EP28        (0x10000000)
#define USB_EoTIntSet_EP29        (0x20000000)
#define USB_EoTIntSet_EP30        (0x40000000)
#define USB_EoTIntSet_EP31        (0x80000000)
#define USB_EoTIntSet_MASK        (0xffffffff)

#define USB_NDDRIntSt_EP0         (0x00000001)
#define USB_NDDRIntSt_EP1         (0x00000002)
#define USB_NDDRIntSt_EP2         (0x00000004)
#define USB_NDDRIntSt_EP3         (0x00000008)
#define USB_NDDRIntSt_EP4         (0x00000010)
#define USB_NDDRIntSt_EP5         (0x00000020)
#define USB_NDDRIntSt_EP6         (0x00000040)
#define USB_NDDRIntSt_EP7         (0x00000080)
#define USB_NDDRIntSt_EP8         (0x00000100)
#define USB_NDDRIntSt_EP9         (0x00000200)
#define USB_NDDRIntSt_EP10        (0x00000400)
#define USB_NDDRIntSt_EP11        (0x00000800)
#define USB_NDDRIntSt_EP12        (0x00001000)
#define USB_NDDRIntSt_EP13        (0x00002000)
#define USB_NDDRIntSt_EP14        (0x00004000)
#define USB_NDDRIntSt_EP15        (0x00008000)
#define USB_NDDRIntSt_EP16        (0x00010000)
#define USB_NDDRIntSt_EP17        (0x00020000)
#define USB_NDDRIntSt_EP18        (0x00040000)
#define USB_NDDRIntSt_EP19        (0x00080000)
#define USB_NDDRIntSt_EP20        (0x00100000)
#define USB_NDDRIntSt_EP21        (0x00200000)
#define USB_NDDRIntSt_EP22        (0x00400000)
#define USB_NDDRIntSt_EP23        (0x00800000)
#define USB_NDDRIntSt_EP24        (0x01000000)
#define USB_NDDRIntSt_EP25        (0x02000000)
#define USB_NDDRIntSt_EP26        (0x04000000)
#define USB_NDDRIntSt_EP27        (0x08000000)
#define USB_NDDRIntSt_EP28        (0x10000000)
#define USB_NDDRIntSt_EP29        (0x20000000)
#define USB_NDDRIntSt_EP30        (0x40000000)
#define USB_NDDRIntSt_EP31        (0x80000000)
#define USB_NDDRIntSt_MASK        (0xffffffff)

#define USB_NDDRIntClr_EP0        (0x00000001)
#define USB_NDDRIntClr_EP1        (0x00000002)
#define USB_NDDRIntClr_EP2        (0x00000004)
#define USB_NDDRIntClr_EP3        (0x00000008)
#define USB_NDDRIntClr_EP4        (0x00000010)
#define USB_NDDRIntClr_EP5        (0x00000020)
#define USB_NDDRIntClr_EP6        (0x00000040)
#define USB_NDDRIntClr_EP7        (0x00000080)
#define USB_NDDRIntClr_EP8        (0x00000100)
#define USB_NDDRIntClr_EP9        (0x00000200)
#define USB_NDDRIntClr_EP10       (0x00000400)
#define USB_NDDRIntClr_EP11       (0x00000800)
#define USB_NDDRIntClr_EP12       (0x00001000)
#define USB_NDDRIntClr_EP13       (0x00002000)
#define USB_NDDRIntClr_EP14       (0x00004000)
#define USB_NDDRIntClr_EP15       (0x00008000)
#define USB_NDDRIntClr_EP16       (0x00010000)
#define USB_NDDRIntClr_EP17       (0x00020000)
#define USB_NDDRIntClr_EP18       (0x00040000)
#define USB_NDDRIntClr_EP19       (0x00080000)
#define USB_NDDRIntClr_EP20       (0x00100000)
#define USB_NDDRIntClr_EP21       (0x00200000)
#define USB_NDDRIntClr_EP22       (0x00400000)
#define USB_NDDRIntClr_EP23       (0x00800000)
#define USB_NDDRIntClr_EP24       (0x01000000)
#define USB_NDDRIntClr_EP25       (0x02000000)
#define USB_NDDRIntClr_EP26       (0x04000000)
#define USB_NDDRIntClr_EP27       (0x08000000)
#define USB_NDDRIntClr_EP28       (0x10000000)
#define USB_NDDRIntClr_EP29       (0x20000000)
#define USB_NDDRIntClr_EP30       (0x40000000)
#define USB_NDDRIntClr_EP31       (0x80000000)
#define USB_NDDRIntClr_MASK       (0xffffffff)

#define USB_NDDRIntSet_EP0        (0x00000001)
#define USB_NDDRIntSet_EP1        (0x00000002)
#define USB_NDDRIntSet_EP2        (0x00000004)
#define USB_NDDRIntSet_EP3        (0x00000008)
#define USB_NDDRIntSet_EP4        (0x00000010)
#define USB_NDDRIntSet_EP5        (0x00000020)
#define USB_NDDRIntSet_EP6        (0x00000040)
#define USB_NDDRIntSet_EP7        (0x00000080)
#define USB_NDDRIntSet_EP8        (0x00000100)
#define USB_NDDRIntSet_EP9        (0x00000200)
#define USB_NDDRIntSet_EP10       (0x00000400)
#define USB_NDDRIntSet_EP11       (0x00000800)
#define USB_NDDRIntSet_EP12       (0x00001000)
#define USB_NDDRIntSet_EP13       (0x00002000)
#define USB_NDDRIntSet_EP14       (0x00004000)
#define USB_NDDRIntSet_EP15       (0x00008000)
#define USB_NDDRIntSet_EP16       (0x00010000)
#define USB_NDDRIntSet_EP17       (0x00020000)
#define USB_NDDRIntSet_EP18       (0x00040000)
#define USB_NDDRIntSet_EP19       (0x00080000)
#define USB_NDDRIntSet_EP20       (0x00100000)
#define USB_NDDRIntSet_EP21       (0x00200000)
#define USB_NDDRIntSet_EP22       (0x00400000)
#define USB_NDDRIntSet_EP23       (0x00800000)
#define USB_NDDRIntSet_EP24       (0x01000000)
#define USB_NDDRIntSet_EP25       (0x02000000)
#define USB_NDDRIntSet_EP26       (0x04000000)
#define USB_NDDRIntSet_EP27       (0x08000000)
#define USB_NDDRIntSet_EP28       (0x10000000)
#define USB_NDDRIntSet_EP29       (0x20000000)
#define USB_NDDRIntSet_EP30       (0x40000000)
#define USB_NDDRIntSet_EP31       (0x80000000)
#define USB_NDDRIntSet_MASK       (0xffffffff)

#define USB_SysErrIntSt_EP0       (0x00000001)
#define USB_SysErrIntSt_EP1       (0x00000002)
#define USB_SysErrIntSt_EP2       (0x00000004)
#define USB_SysErrIntSt_EP3       (0x00000008)
#define USB_SysErrIntSt_EP4       (0x00000010)
#define USB_SysErrIntSt_EP5       (0x00000020)
#define USB_SysErrIntSt_EP6       (0x00000040)
#define USB_SysErrIntSt_EP7       (0x00000080)
#define USB_SysErrIntSt_EP8       (0x00000100)
#define USB_SysErrIntSt_EP9       (0x00000200)
#define USB_SysErrIntSt_EP10      (0x00000400)
#define USB_SysErrIntSt_EP11      (0x00000800)
#define USB_SysErrIntSt_EP12      (0x00001000)
#define USB_SysErrIntSt_EP13      (0x00002000)
#define USB_SysErrIntSt_EP14      (0x00004000)
#define USB_SysErrIntSt_EP15      (0x00008000)
#define USB_SysErrIntSt_EP16      (0x00010000)
#define USB_SysErrIntSt_EP17      (0x00020000)
#define USB_SysErrIntSt_EP18      (0x00040000)
#define USB_SysErrIntSt_EP19      (0x00080000)
#define USB_SysErrIntSt_EP20      (0x00100000)
#define USB_SysErrIntSt_EP21      (0x00200000)
#define USB_SysErrIntSt_EP22      (0x00400000)
#define USB_SysErrIntSt_EP23      (0x00800000)
#define USB_SysErrIntSt_EP24      (0x01000000)
#define USB_SysErrIntSt_EP25      (0x02000000)
#define USB_SysErrIntSt_EP26      (0x04000000)
#define USB_SysErrIntSt_EP27      (0x08000000)
#define USB_SysErrIntSt_EP28      (0x10000000)
#define USB_SysErrIntSt_EP29      (0x20000000)
#define USB_SysErrIntSt_EP30      (0x40000000)
#define USB_SysErrIntSt_EP31      (0x80000000)
#define USB_SysErrIntSt_MASK      (0xffffffff)

#define USB_SysErrIntClr_EP0      (0x00000001)
#define USB_SysErrIntClr_EP1      (0x00000002)
#define USB_SysErrIntClr_EP2      (0x00000004)
#define USB_SysErrIntClr_EP3      (0x00000008)
#define USB_SysErrIntClr_EP4      (0x00000010)
#define USB_SysErrIntClr_EP5      (0x00000020)
#define USB_SysErrIntClr_EP6      (0x00000040)
#define USB_SysErrIntClr_EP7      (0x00000080)
#define USB_SysErrIntClr_EP8      (0x00000100)
#define USB_SysErrIntClr_EP9      (0x00000200)
#define USB_SysErrIntClr_EP10     (0x00000400)
#define USB_SysErrIntClr_EP11     (0x00000800)
#define USB_SysErrIntClr_EP12     (0x00001000)
#define USB_SysErrIntClr_EP13     (0x00002000)
#define USB_SysErrIntClr_EP14     (0x00004000)
#define USB_SysErrIntClr_EP15     (0x00008000)
#define USB_SysErrIntClr_EP16     (0x00010000)
#define USB_SysErrIntClr_EP17     (0x00020000)
#define USB_SysErrIntClr_EP18     (0x00040000)
#define USB_SysErrIntClr_EP19     (0x00080000)
#define USB_SysErrIntClr_EP20     (0x00100000)
#define USB_SysErrIntClr_EP21     (0x00200000)
#define USB_SysErrIntClr_EP22     (0x00400000)
#define USB_SysErrIntClr_EP23     (0x00800000)
#define USB_SysErrIntClr_EP24     (0x01000000)
#define USB_SysErrIntClr_EP25     (0x02000000)
#define USB_SysErrIntClr_EP26     (0x04000000)
#define USB_SysErrIntClr_EP27     (0x08000000)
#define USB_SysErrIntClr_EP28     (0x10000000)
#define USB_SysErrIntClr_EP29     (0x20000000)
#define USB_SysErrIntClr_EP30     (0x40000000)
#define USB_SysErrIntClr_EP31     (0x80000000)
#define USB_SysErrIntClr_MASK     (0xffffffff)

#define USB_SysErrIntSet_EP0      (0x00000001)
#define USB_SysErrIntSet_EP1      (0x00000002)
#define USB_SysErrIntSet_EP2      (0x00000004)
#define USB_SysErrIntSet_EP3      (0x00000008)
#define USB_SysErrIntSet_EP4      (0x00000010)
#define USB_SysErrIntSet_EP5      (0x00000020)
#define USB_SysErrIntSet_EP6      (0x00000040)
#define USB_SysErrIntSet_EP7      (0x00000080)
#define USB_SysErrIntSet_EP8      (0x00000100)
#define USB_SysErrIntSet_EP9      (0x00000200)
#define USB_SysErrIntSet_EP10     (0x00000400)
#define USB_SysErrIntSet_EP11     (0x00000800)
#define USB_SysErrIntSet_EP12     (0x00001000)
#define USB_SysErrIntSet_EP13     (0x00002000)
#define USB_SysErrIntSet_EP14     (0x00004000)
#define USB_SysErrIntSet_EP15     (0x00008000)
#define USB_SysErrIntSet_EP16     (0x00010000)
#define USB_SysErrIntSet_EP17     (0x00020000)
#define USB_SysErrIntSet_EP18     (0x00040000)
#define USB_SysErrIntSet_EP19     (0x00080000)
#define USB_SysErrIntSet_EP20     (0x00100000)
#define USB_SysErrIntSet_EP21     (0x00200000)
#define USB_SysErrIntSet_EP22     (0x00400000)
#define USB_SysErrIntSet_EP23     (0x00800000)
#define USB_SysErrIntSet_EP24     (0x01000000)
#define USB_SysErrIntSet_EP25     (0x02000000)
#define USB_SysErrIntSet_EP26     (0x04000000)
#define USB_SysErrIntSet_EP27     (0x08000000)
#define USB_SysErrIntSet_EP28     (0x10000000)
#define USB_SysErrIntSet_EP29     (0x20000000)
#define USB_SysErrIntSet_EP30     (0x40000000)
#define USB_SysErrIntSet_EP31     (0x80000000)
#define USB_SysErrIntSet_MASK     (0xffffffff)


/*##############################################################################
## Memory Accelerator Module (MAM)
##############################################################################*/

#define MAM_CR            (*(pREG32 (0xe01fc000)))
#define MAM_TIM           (*(pREG32 (0xe01fc004)))

#define MAM_CR_DISABLE    (0x000000000)
#define MAM_CR_PARTIAL    (0x000000001)
#define MAM_CR_FULL       (0x000000002)
#define MAM_CR_RSVD       (0x000000003)
#define MAM_CR_MASK       (0x000000003)

#define MAM_TIM_RSVD      (0x000000000)
#define MAM_TIM_1         (0x000000001)
#define MAM_TIM_2         (0x000000002)
#define MAM_TIM_3         (0x000000003)
#define MAM_TIM_4         (0x000000004)
#define MAM_TIM_5         (0x000000005)
#define MAM_TIM_6         (0x000000006)
#define MAM_TIM_7         (0x000000007)
#define MAM_TIM_MASK      (0x000000007)


/*##############################################################################
## IAP/ISP
##############################################################################*/

#define IAP_LOCATION            (0x7ffffff1)
#define IAP_CMD_PREPARE         (50)
#define IAP_CMD_COPYRAMTOFLASH  (51)
#define IAP_CMD_ERASE           (52)
#define IAP_CMD_BLANKCHECK      (53)
#define IAP_CMD_READPARTID      (54)
#define IAP_CMD_READBOOTCODEVER (55)
#define IAP_CMD_COMPARE         (56)
#define IAP_CMD_REINVOKEISP     (57)

#define IAP_RESULT_CMD_SUCCESS          (0)
#define IAP_RESULT_INVALID_COMMAND      (1)
#define IAP_RESULT_SRC_ADDR_ERROR       (2)
#define IAP_RESULT_DST_ADDR_ERROR       (3)
#define IAP_RESULT_SRC_ADDR_NOT_MAPPED  (4)
#define IAP_RESULT_DST_ADDR_NOT_MAPPED  (5)
#define IAP_RESULT_COUNT_ERROR          (6)
#define IAP_RESULT_INVALID_SECTOR       (7)
#define IAP_RESULT_SECTOR_NOT_BLANK     (8)
#define IAP_RESULT_SECTOR_NOT_PREPARED  (9)
#define IAP_RESULT_COMPARE_ERROR        (10)
#define IAP_RESULT_BUSY                 (11)
#define IAP_RESULT_PARAM_ERROR          (12)
#define IAP_RESULT_ADDR_ERROR           (13)
#define IAP_RESULT_ADDR_NOT_MAPPED      (14)
#define IAP_RESULT_CMD_LOCKED           (15)
#define IAP_RESULT_INVALID_CODE         (16)
#define IAP_RESULT_INVALID_BAUD_RATE    (17)
#define IAP_RESULT_ANVALID_STOP_BIT     (18)
#define IAP_RESULT_CRP_ENABLED          (19)
#define IAP_RESULT_LAST                 (19)

#endif
