

#include "tc_vars.h"
// Constants


// Versions numbers
unsigned long tc_varstart		= 0xAABBCCDD;		// Kennung Varstart
unsigned long tc_version		= 0x00000001;		// Factory version 	1 
unsigned long tc_subversion		= 0x00000002;		// Factory subversion 	2
unsigned long tc_dev_version		= 0x00000005;		// Developer version
unsigned long tc_dev_subversion		= 0x00000001;		// Developer subversion
char	      tc_compilation[20] 	= {" C4"};		// Compilation
unsigned long tc_hw_sw_version  	= 0x00000000;		// Type 		0 = W2012 1 = W2014 2 = W2022 3 = W2024
unsigned long tc_hw_version     	= 0x00000000;		// Hardware version


unsigned long tc_model 			= 0x00000000;		// 2012, 2022 ...
unsigned long tc_serial 		= 0x00000000;		// 1
unsigned long tc_production_lot1 	= 0x00000020;		// E
unsigned long tc_production_lot2 	= 0x00000020;		// E
unsigned long tc_shipment_date 		= 0x00000000;		// 2C7

const unsigned char btnUnpushed		= 0x00;
const unsigned char btnPushed 		= 0x01;

const unsigned char btnDraw		= 0x00;
const unsigned char btnRemove 		= 0x01;

const unsigned long BitMasks[32] = {	0x7FFFFFFF, 0xBFFFFFFF, 0xDFFFFFFF, 0xEFFFFFFF,
					0xF7FFFFFF, 0xFBFFFFFF, 0xFDFFFFFF, 0xFEFFFFFF,
					0xFF7FFFFF, 0xFFBFFFFF, 0xFFDFFFFF, 0xFFEFFFFF,
					0xFFF7FFFF, 0xFFFBFFFF, 0xFFFDFFFF, 0xFFFEFFFF,
					0xFFFF7FFF, 0xFFFFBFFF, 0xFFFFDFFF, 0xFFFFEFFF,
					0xFFFFF7FF, 0xFFFFFBFF, 0xFFFFFDFF, 0xFFFFFEFF,
					0xFFFFFF7F, 0xFFFFFFBF, 0xFFFFFFDF, 0xFFFFFFEF,
					0xFFFFFFF7, 0xFFFFFFFB, 0xFFFFFFFD, 0xFFFFFFFE};
								
const unsigned long BitMasks2[32] = {	0x80000000, 0x40000000, 0x20000000, 0x10000000,
					0x08000000, 0x04000000, 0x02000000, 0x01000000,
					0x00800000, 0x00400000, 0x00200000, 0x00100000,
					0x00080000, 0x00040000, 0x00020000, 0x00010000,
					0x00008000, 0x00004000, 0x00002000, 0x00001000,
					0x00000800, 0x00000400, 0x00000200, 0x00000100,
					0x00000080, 0x00000040, 0x00000020, 0x00000010,
					0x00000008, 0x00000004, 0x00000002, 0x00000001};

// Constants
const int DrawOffsetX 		= GRID_XOFFS;				// Draw Offset from Left
const int DrawOffsetY 		= GRID_YOFFS;				// Draw Offset from Top
const int DrawXYOffsetX1 	= GRID_YOFFS + (GRID_XY / 2);		//59;	//?????	// Draw Offset from Top
const int DrawXYOffsetX2 	= GRID_XY_XOFFS + (GRID_XY / 2);	//541;	//?????	// Draw Offset from Left
//const int PreReg_Offset = 40;						// Signal Offset , half Signal
int PreReg_Offset 		= 35;					// Signal Offset , half Signal

const int CH1OffsetX = 0;						// Draw Offset from Left
const int CH2OffsetX = 0;	//10; BF				// Draw Offset from Left
const int CH3OffsetX = 0;						// Draw Offset from Left
const int CH4OffsetX = 0;						// Draw Offset from Left

// correction = SignalOffset - DrawOffset
//const int correction = 18;  //18;					// Draw Correction for the Signals

//const int ADC_ZERO = 127;						//ADC Zero 

// Variables
//-----------------------------------------------------------------------------------------------------
unsigned char test_sw1 = 0;					//BF Test Funktion 11 S -> switch to C-routines
unsigned char test_sw2 = 0;					//BF Test Funktion 20 Y	
unsigned char test_sw3 = 1;					//BF Test Funktion 21 X 


unsigned char test_channel = 1;
unsigned char test_values  = 0;
unsigned int  test_offs_a  = 0;
unsigned int  test_offs_b  = 0;
//unsigned int  test_zero_a  = 0;
//unsigned int  test_zero_b  = 0;
unsigned int  test_div_a   = 1;
unsigned int  test_div_b   = 1;
//unsigned int  test_rel_a   = 0;
//unsigned int  test_rel_b   = 0;
unsigned int  FrameCount   = 0;

//--------------------------------------------------------------------------------------------------------
unsigned char dotted_grid = 0;					//BF switch solid/dotted grid
unsigned char FFT_grid    = 0;					//BF switch frequency div
unsigned char UI_request  = 0;					//BF flag for user interface activity
unsigned char QP_request  = 0;					//BF flag Quick Print requested
unsigned char QP_mode     = 1;					// 0->BF-version / 1->OS-version / 2->USB-Export / (remote control -> shift + T)

unsigned char ZL_changed  = 0;					//BF OnZero Channel -> only draw signal with changed zerolevel


unsigned char test_signal = 0;					//BF test signal generator
//unsigned char ADC_Cal_Requ = 0;				//ADC Calibration requested

unsigned char FlashPreset = 0;					//BF Flash presetting flag

unsigned char CRS_Delta  = 1;					//BF delta cursor on/off
unsigned char AS_request = 0;					//BF auto scale requested
unsigned char RC_request = 0;					//BF signal recall requested
unsigned char RC_overlay = 0;					//BF recall overlay mode active
unsigned char RC_user_if = 0;					//BF flag for user interface activity in Overlay mode
unsigned char LA_active = 0;					//BF logic analyzer mode active

unsigned char ACQ_NewData = 0;
unsigned char ACQ_Average = 0;					//BF Average mode
unsigned char ACQ_ManTrigg = 0;					// Flag manual trigger 
//unsigned char ACQ_AvrgAsm = 0;

unsigned char ADC_VirtualZero_CH1 = 128;
unsigned char ADC_VirtualZero_CH2 = 128;
unsigned char ADC_VirtualZero_CH3 = 128;
unsigned char ADC_VirtualZero_CH4 = 128;

unsigned char UART_NewData = 0;
	 char UART_RXData  = -1;

volatile unsigned char UART_RXFlag = 0;				//KB Quick Print USB-export

unsigned char   UartRxGuiCmd=0;                 		//#FW# Hardware::ISR_UART has filled UartRxGuiBuf
unsigned char   UartRxGuiBuf[UARTRXGUISIZE];    		//#FW# Buffer for GUI-Commands

unsigned char DrawMono = 0;					// flag for drawing monochrome
unsigned char NoDisplay[4] = {0,0,0,0};

char CalSet = 0;
float PreTrigger = 0;

//--------------------------------------------------------------------------------------------------------

unsigned long timer_counter_value = 1;
unsigned long timer_counter_max   = 1;

int timer_reload_low  = 0;
int timer_reload_high = 0;



const int TimerRotPeriod     = 25000000;//40000000;	// BF changed		25000000;	// Rotary change timer
//const int TimerSecPeriod     = 12500000;							// button pushed time
const int TimerSecPeriod     = 8500000;							// button pushed time


const unsigned long tb_value[36] = {0xFFFFFFFF,		//	 0 -> 2 ns
                                    0xFFFFFFFF,		//	 1 -> 5 ns
                                    0xFFFFFFFF,		//	 2 -> 10 ns
                                    0xFFFFFFFF,		//	 3 -> 20 ns
                                    0xFFFFFFFF,		//	 4 -> 50 ns
                                    0xFFFFFFFF,		//	 5 -> 100 ns
                                    0xFFFFFFFF,		//	 6 -> 200 ns
                                    0xFFFFFFFF,		//	 7 -> 500 ns
                                    0xFFFFFFFF,		//	 8 -> 1 µs
				    0xFFFFFFFE,		//	 9 -> 2 µs (500MSa/S)
				    0xFFFFFFFD,		//	10 -> 5 µs (250MSa/S)
				    0xFFFFFFFB,		//	11 -> 10 µs (25MSa/S)
				    0xFFFFFFF3,		//	12 -> 20 µs
				    0xFFFFFFE7,		//	13 -> 50 µs
				    0xFFFFFFCE,		//	14 -> 100 µs
				    0xFFFFFF83,		//	15 -> 200 µs
				    0xFFFFFF06,		//	16 -> 500 µs
				    0xFFFFFE0C,		//	17 -> 1 ms
				    0xFFFFFB1E,		//	18 -> 2 ms
				    0xFFFFF63C,		//	19 -> 5 ms
				    0xFFFFEC78,		//	20 -> 10 ms
				    0xFFFFCF2C,		//	21 -> 20 ms
				    0xFFFF9E58,		//	22 -> 50 ms
				    0xFFFF3CB0,		//	23 -> 100 ms
				    0xFFFE17B8,		//	24 -> 200 ms
                                    0xFFFC2F70,		//	25 -> 500 ms
                                    0xFFFFFFFF,		//	26 -> 1 s [USTB]
                                    0xFFFFFFFF,		//	27 -> 2 s [USTB]
				    0xFFFFFFFF,		//	28 -> 5 s [USTB]
				    0xFFFFFFFF,		//	29 -> 10 s [USTB]
				    0xFFFFFFFF,		//	30 -> 20 s [USTB]
				    0xFFFFFFFF,		//	31 -> 50 s [USTB]
				    0xFFFFFFFF,		//	32 -> 100 s [USTB]
				    0xFFFFFFFF,		//	33 -> 200 s [USTB]
				    0xFFFFFFFF,		//	34 -> 500 s [USTB]
				    0xFFFFFFFF};	//	35 -> 1000 s [USTB]

/* Old values before USTB
                                    0xFFFC2F70,		//	500 mS
                                    0xFFF85EE0,		//	1 S
                                    0xFFECED30,		//	2 S
				    0xFFD9Da60,		//	5 S	
				    0xFFB3B4C0,		//	10 S
				    0xFF4143E0,		//	20 S
				    0xFFFFFFFF,		//	50 S
				    0xFFFFFFFF,		//	100 S
				    0xFFFFFFFF};	//	200 S

*/

// BF add
//constants for ultra slow timebase mode	   1 channel 2 channel 3 channel 4 channel
const unsigned long int USTB_timer_value[11] = {    125000,	//500 mS	Ta = 10ms -> not used
						    250000, 	//1 S		Ta = 20ms -> USTB starts here!!
                                                    500000,	//2 S		Ta = 40ms
	 				           1250000,	//5 S		Ta = 100ms
                                                   2500000,	//10 S		Ta = 200ms
                                                   5000000,	//20 S		Ta = 400ms
                                                  12500000,	//50 S		Ta = 1s
                                                  25000000,	//100 S		Ta = 2s
                                                  50000000,	//200 S		Ta = 4s
                                                 125000000,	//500 S		Ta = 10s
                                                 250000000};	//1000 S	Ta = 20s
/*
const unsigned long int USTB_timer_value[11][4] = {{   100000,   100000,   100000,   100000 },	//500 mS	Ta = 10ms -> not used
						   {   200000,   180000,   172000,   175000 },	//1 S		Ta = 20ms -> USTB starts here!!
                                                   {   500000,   495000,   428000,   399000 },	//2 S		Ta = 40ms
	 				           {  1250000,  1250000,  1250000,  1250000 },	//5 S		Ta = 100ms
                                                   {  2500000,  2500000,  2500000,  2500000 },	//10 S		Ta = 200ms
                                                   {  5000000,  5000000,  5000000,  5000000 },	//20 S		Ta = 400ms
                                                   { 12500000, 12500000, 12500000, 12500000 },	//50 S		Ta = 1s
                                                   { 25000000, 25000000, 25000000, 25000000 },	//100 S		Ta = 2s
                                                   { 50000000, 50000000, 50000000, 50000000 },	//200 S		Ta = 4s
                                                   {125000000,125000000,125000000,125000000 },	//500 S		Ta = 10s
                                                   {250000000,250000000,250000000,250000000 }};	//1000 S	Ta = 20s

*/
const int ExtTrigOffset[36] = {	170,		//	2 ns
				170,		//	5 ns
				170,		//	10 ns
				170,		//	20 ns
				170,		//	50 ns
				165,		//	100 ns
				165,		//	200 ns
				140,		//	500 ns
				160,		//	1 µs
				160,		//	2 µs
				160,		//	5 µs
				 40,		//	10 µs
				 40,		//	20 µs
				 40,		//	50 µs
				 40,		//	100 µs
				 40,		//	200 µs
				 40,		//	500 µs
				 40,		//	1 ms
				 40,		//	2 ms
				 40,		//	5 ms
				 40,		//	10 ms
				 40,		//	20 ms
				 40,		//	50 ms
				 40,		//	100 ms
				 40,		//	200 ms
				 40,		//	500 ms
				//------- USTB ------------------
				  0,		//	1 s
				  0,		//	2 s
				  0,		//	5 s
				  0,		//	10 s
				  0,		//	20 s
				  0,		//	50 s
				  0,		//	100 s
				  0,		//	200 s
				  0,		//	500 s
				  0};		//	1000 s

//--------------------------------------------------------------------------------------------------
//BF range factors for math signal 

const unsigned int math_voltage_factor[2][18] =
					    {{   1,       2,       3,	//  1mV,   2mV,   5mV 
                                                10,      20,      31,	// 10mV,  20mV,  50mV 
                                               100,     197,     308,	//100mV, 200mV, 500mV
                                              1000,    1970,    3079,	//  1V,    2V,    5V
                                             10000,   19700,   30790,   // 10V,   20V,   50V
                                            100000,  197000,  307900 },	//100V,  200V,  500V

					     {   1,       2,       3,	//  1mV,   2mV,   5mV 
                                                 8,      16,      31,	// 10mV,  20mV,  50mV 
                                                80,     159,     308,	//100mV, 200mV, 500mV
                                               806,    1586,    3079,	//  1V,    2V,    5V
                                              8064,   15861,   30790,   // 10V,   20V,   50V
                                             80640,  158615,  307900 }};//100V,  200V,  500V

// for rescaling math multiplication voltage factors
const 		int math_rescale[2][18] =    {{	20000,   19700,   15395,	//  1mV,   2mV,   5mV 
		 			      	20000,   19700,   15395,	// 10mV,  20mV,  50mV 
				     	      	20000,   19700,   15395,	//100mV, 200mV, 500mV
						20000,   19700,   15395,	//  1V,    2V,    5V
						20000,   19700,   15395,	// 10V,   20V,   50V
						20000,   19700,   15395 },	//100V,  200V,  500V

					       {16128,  15861,   15395,	//  1mV,   2mV,   5mV 
				     		16128,  15861,   15395,	// 10mV,  20mV,  50mV 
				     		16128,  15861,   15395,	//100mV, 200mV, 500mV
				     		16128,  15861,   15395,	//  1V,    2V,    5V
				     		16128,  15861,   15395,	// 10V,   20V,   50V
			             		16128,  15861,   15395 }};	//100V,  200V,  500V


const unsigned int predivisor[10] = { 1, 2, 5, 10, 20, 50, 100, 200, 500, 1000 }; //BF probe division

//------------------------------------------------------------------------------------------------------

unsigned char ColorPalette = 0; 

const unsigned char GridColorArray[10][4] = {{0x00, 0x15, 0x2A, 0x3F},	//white
					     {0x00, 0x01, 0x02, 0x03},	//red
					     {0x00, 0x04, 0x08, 0x0C},	//green
					     {0x00, 0x05, 0x0A, 0x0F},	//yellow
					     {0x00, 0x10, 0x20, 0x30},	//deep blue
					     {0x00, 0x14, 0x18, 0x2C},	//light blue
					     {0x00, 0x11, 0x12, 0x13},	//violet
					     {0x00, 0x16, 0x17, 0x2B},	//pink
					     {0x00, 0x06, 0x0B, 0x1B},	//orange
					     {0x00, 0x15, 0x1A, 0x3F}};	//test white

const unsigned int Splash_Logo_PosX = 275;
const unsigned int Splash_Logo_PosY = 60;

const unsigned int Splash_Data_PosX = 200;
const unsigned int Splash_Data_PosY = 200;

//----------------------------------------------------------------------------------------
//		Filter
unsigned char FilterType = 1;					// type of noise filter -> 1 = proprietary / 2 = IIR  / 3 = FIR

//----------------------------------------------------------------------------------------

/* BF not needed anymore
//BF new signal start/stop table -> used only for delayed mode, in normal mode the new 
// variable below are used
const short SignalStartStop[36][2] = {{  8180,  8204},	//   2ns
				      {  8162,  8222},	//   5ns
				      {  8132,  8252},	//  10ns
				      {  8072,  8312},  //  20ns
				      {  7892,  8492},	//  50ns
				      {  7592,  8792},	// 100ns
				      {  6992,  9392},	// 200ns
				      {  5192, 11192},	// 500ns
				      {  2192, 14192},	//   1µs
				      {  2192, 14192},	//   2µs
				      {   692, 15692},	//   5µs
				      {   548,  3548},	//  10µs
				      {   848,  3248},	//  20µs
				      {   548,  3548},	//  50µs
				      {   548,  3548},	// 100µs
				      {   848,  3248},	// 200µs
				      {   548,  3548},	// 500µs
				      {   548,  3548},	//   1ms
				      {   848,  3248},	//   2ms
				      {   548,  3548},	//   5ms
				      {   548,  3548},	//  10ms
				      {   848,  3248},	//  20ms
				      {   548,  3548},	//  50ms
				      {   548,  3548},	// 100ms
				      {   848,  3248},	// 200ms
				      {   548,  3548},	// 500ms
				      {  7892,  8492},	//   1s not used
				      {  7892,  8492},	//   2s not used
				      {  7892,  8492},	//   5s not used
				      {  7892,  8492},	//  10s not used
				      {  7892,  8492},	//  20s not used
				      {  7892,  8492},	//  50s not used
				      {  7892,  8492},	// 100s not used
				      {  7892,  8492},	// 200s not used
				      {  7892,  8492},	// 500s not used
				      {  7892,  8492}};	//1000s not used

*/

/*BF del #023
// BF new Signal length calculation table
const short SignalSize[34]= {	  24,	//   2nS
				  60,	//   5nS
				 120,	//  10nS
				 240,	//  20nS
			         600,	//  50nS
			        1200,	// 100nS
			        2400,	// 200nS
			        6000,	// 500nS
			       12000,	//   1µS
			       12000,	//   2µS
			       15000,	//   5µS
				3000,	//  10µS
				2400,	//  20µS
				3000,	//  50µS
				3000,	// 100µS
				2400,	// 200µS
				3000,	// 500µS
				3000,	//   1mS
				2400,	//   2mS
				3000,	//   5mS
				3000,	//  10mS
				2400,	//  20mS
				3000,	//  50mS
				3000,   // 100mS
				2400,	// 200mS
				3000,	// 500mS
				 600,	//   1S
				 600,	//   2S
				 600,	//   5S
				 600,	//  10S
				 600,	//  20S
				 600,	//  50S
				 600,	// 100S
				 600 };	// 200S

*/

int SignalMemSize = 600;	//BF #023
int MemStartOffs = 50;
int MemoryEnd  = 16000;
int TrigPosMax = 4000;

//BF needed for calculation of triggerposition in memory window and 
//   draw factor calculation -> Hardware::RecalcTimeParameters()
const float ZoomFactorTable[36] = {  0.04,	//   2nS
				     0.10,	//   5nS
				     0.20,	//  10nS
				     0.40,	//  20nS
				     1.00,	//  50nS
				     2.00,	// 100nS
				     4.00,	// 200nS
				    10.00,	// 500nS
				    20.00,	//   1µS
				    20.00,	//   2µS
				    25.00,	//   5µS
				     5.00,	//  10µS
				     4.00,	//  20µS
				     5.00,	//  50µS
				     5.00,	// 100µS
				     4.00,	// 200µS
				     5.00,	// 500µS
				     5.00,	//   1mS
				     4.00,	//   2mS
				     5.00,	//   5mS
				     5.00,	//  10mS
				     4.00,	//  20mS
				     5.00,	//  50mS
				     5.00,	// 100mS
				     4.00,	// 200mS
				     5.00,	// 500mS
				     1.00,	//   1S
				     1.00,	//   2S
				     1.00,	//   5S
				     1.00,	//  10S
				     1.00,	//  20S
				     1.00,	//  50S
				     1.00,	// 100S
				     1.00,	// 200S
				     1.00,	// 500S
				     1.00};	//1000S

//BF #003 Delayed end timebase (MainTimebase - DelayedTimebase - 1)
const char Dm_Sel_Tb_End[26] =   {-1,	//   2nS -> n.a.
				   0,	//   5nS -> 2ns
				   1,	//  10nS -> 2ns
				   2,	//  20nS -> 2ns
			           2,	//  50nS -> 5ns
				   3,	// 100nS -> 5ns
				   4,	// 200nS -> 5ns
				   5,	// 500nS -> 5ns
				   5,	//   1µS -> 10ns
				   3,	//   2µS -> 
				   3,	//   5µS ->
				   1,	//  10µS ->
				   1,	//  20µS ->
				   1,	//  50µS ->
				   1,	// 100µS ->
				   1,	// 200µS ->
				   1,	// 500µS
				   1,	//   1mS
				   1,	//   2mS
				   1,	//   5mS
				   1,	//  10mS
				   1,	//  20mS
				   1,	//  50mS
				   1,   // 100mS
				   1,	// 200mS
				   1};	// 500mS



float ZoomFactor = 1;
float ZoomFactor_old = 1;
float ZoomFactorDel = 1;

//BF corrected register values for external trigger level #019
const int ExtTriggerLevel[103] = {0x40, 0x41, 0x42, 0x43,0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
				  0x50, 0x51, 0x52, 0x53,0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
				  0x60, 0x61, 0x62, 0x63,0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
				  0x70, 0x71, 0x72, 0x73,0x74, 0x75, 0x76, 0x77, 
				  0x80,             0x83,0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
				  0x90, 0x91, 0x92, 0x93,0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
				  0xA0, 0xA1, 0xA2, 0xA3,0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
				  0xB0};


/*BF del
const int Extern_Trigger_Values[33] = {0x40, 0x44, 0x48, 0x4C, 0x50, 0x54, 0x58, 0x5C, 0x60, 0x64, 0x68, 0x6C, 0x70, 0x74, 0x78, 0x7C,
                                       0x80, 0x84, 0x88, 0x8C, 0x90, 0x94, 0x98, 0x9C, 0xA0, 0xA4, 0xA8, 0xAC, 0xB0, 0xB4, 0xB8, 0xBC, 0xC0};
*/

//BF corrected values for external trigger level display output #019
const float ExtTriggerDispl[103] ={-11.300,-11.100,-10.900,-10.700,-10.500,-10.300,-10.150,-10.000, -9.800, -9.500, -9.200, -9.000, -8.800, -8.600, -8.400, -8.200,
				  -8.000, -7.800, -7.600, -7.400, -7.200, -7.000, -6.800, -6.600, -6.400, -6.200, -6.000, -5.800, -5.600, -5.400, -5.200, -5.000,
				  -4.750, -4.550, -4.350, -4.150, -3.950, -3.750, -3.550, -3.350, -3.150, -2.950, -2.750, -2.550, -2.340, -2.130, -1.930, -1.740,
				  -1.540, -1.300, -1.150, -0.950, -0.750, -0.550, -0.350, -0.100,  
				   0.000,                  0.100,  0.300,  0.500,  0.700,  0.910,  1.100,  1.300,  1.500,  1.700,  1.900,  2.100,  2.300,  2.500,
				   2.700,  2.900,  3.100,  3.300,  3.500,  3.700,  3.900,  4.100,  4.300,  4.500,  4.700,  4.900,  5.100,  5.300,  5.500,  5.700,
				   5.900,  6.100,  6.300,  6.500,  6.700,  6.900,  7.100,  7.300,  7.500,  7.700,  7.900,  8.100,  8.300,  8.500,  8.700,  8.900,
				   9.210};
/*BF del
const float Extern_Trigger_Strs[33] = {-2.5, -2.4, -2.2, -2.0, -1.8, -1.6, -1.5, -1.4, -1.3, -1.1, -1.0, -0.9, -0.8, -0.6, -0.4, -0.2,
                                        0.0,  0.2,  0.4,  0.6,  0.8,  0.9,  1.0,  1.1,  1.3,  1.4,  1.5,  1.6,  1.8,  2.0,  2.2,  2.4,  2.5};
*/
                                         
unsigned long tc_test_var = 0x00000000;
unsigned long tc_test_var2 = 0x00000000;

// testdata

unsigned char DrawSignal = 1;

unsigned char keyboard_found = 0;
unsigned long slope_value = 0;

double Test_Slip = 192.0;
int Test_Range = 1;

bool Transfer_man_data = false;
/*
0 = undetected
1 = no keyboard
2 = Power on Boot
3 = Reset on Boot
4 = Keyboard detected
*/

unsigned long *prog_flash_adr;
unsigned long prog_flash_adress;
unsigned char prog_flash_length;
unsigned long prog_flash_offset;
unsigned char Flash_Read_Buffer[1024];
unsigned long Flash_Protect_Buffer[256];
	
volatile unsigned char config_loaded = false;
unsigned char init_done = false;
unsigned char config_changed = 0;

unsigned char GridColorArrayPos = 3;
unsigned char GridColor_Val = 0x3F;
//BF del unsigned char GridColor_Val_Delayed = 0x15;
//BF del unsigned char GridColorArrayPos_Delayed = 2;

unsigned char WT_Logo_Color_Val = 0x31;		//0x10 / 0x21 / 0x31 

//BF  ++++++++++++++++++++++  delete 
int TestInt = 0;
long TestLong = 0;

unsigned char Test_Mode      = false;
unsigned char ADC_Debug_Mode = false;     	// If true than printf ADC Debug information
unsigned char Debug_Mode     = false;         	// If true than printf Debug information
unsigned char Command_Mode   = false;         	// If true than printf Command information
unsigned char ExtraTrg_Mode  = false;

//BF+++++++++++++++++++++++ delete

bool screen_sel = 0;
bool screen_sel_old = 1;

//unsigned char Splash_drawed = false;


volatile unsigned char adc_started = false;
volatile unsigned char AutoFreeRun = false;


//Quick Logic
unsigned int ctrl_reg = 0x00A3;				//0x0003;
unsigned int adc_ctrl_reg = 0x01C0;			//0;
unsigned int adc_del_reg = 0;
unsigned int pre_reg = 0x0000;				//0x004C;
unsigned int trg_val_reg = 0x00A0;			//0;
unsigned int trg_hyst_reg = 0x0090;			//0;
unsigned int ext_trg_val_reg = 125;	// JK 0x80;		//0;
unsigned int triggering = 0x00;				//2;

unsigned int channel_Adr_add12 = 0x0000;	//BF renamed
unsigned int channel_Adr_add34 = 0x0000;	//BF renamed

unsigned int trg_val_CHI_reg = 0x00A0;			//0;
unsigned int trg_val_CHII_reg = 0x00A0;			//0;
unsigned int trg_val_CHIII_reg = 0x00A0;			//0;
unsigned int trg_val_CHIV_reg = 0x00A0;			//0;

unsigned int trig_range_reg = 0;
unsigned int trig_width_reg = 0x0001;		//0;

unsigned long trig_holdoff_reg = 0x00000000;


int HoldOff_Value = 0;
int HoldOff_Expo = 1;   //ns
int HoldOff_Steps = 8;

int Pulse11_Value = 16;
int Pulse11_Expo = 1;   //ns
int Pulse11_Steps = 8;

int Pulse12_Value = 8;
int Pulse12_Expo = 1;   //ns
int Pulse12_Steps = 8;

int Pulse21_Value = 16;
int Pulse21_Expo = 1;   //ns
int Pulse21_Steps = 8;

int Pulse22_Value = 16;
int Pulse22_Expo = 1;   //ns
int Pulse22_Steps = 8;

int math_scale     = 11;	//BF added -> 5V default
int math_mul_scale = 177;	//BF -> 5V
int math_sub_scale = 161;	//BF -> 5V 
int math_add_scale = 161;	//BF -> 5V

//BF added for new offset calculation
int Math_Offset     = 0;
int Math_Mul_Offset = 0;
int Math_Sub_Offset = 0;
int Math_Add_Offset = 0;


unsigned long adc_change12_reg = 0x01000000;
unsigned long adc_change34_reg = 0x01000000;
unsigned long adc_ctr12_reg = 0x00000000;
unsigned long adc_ctr34_reg = 0x00000000;

//unsigned long ram_adress_reg = 0;

//unsigned int test_port_reg = 0;

// Backup Vars
unsigned int triggering_bak = 0;
unsigned int ctrl_reg_bak = 0;
unsigned int adc_ctrl_reg_bak = 0;
unsigned long timebase_reg_bak = 0;
unsigned int pre_reg_bak = 0;
unsigned int channel_Adr_add_bak = 0;
unsigned int trg_val_reg_bak = 0;
unsigned int trg_hyst_reg_bak = 0;
unsigned int trig_range_reg_bak = 0;
unsigned long trig_holdoff_reg_bak = 0;
unsigned int trig_width_reg_bak = 0;
unsigned char GridColor_Val_bak = 0;
unsigned long adc_change12_reg_bak = 0;
unsigned long adc_change34_reg_bak = 0;

char Selected_Voltage_CH1_bak = 0;
char Selected_Voltage_CH2_bak = 0;
char Selected_Voltage_CH3_bak = 0;
char Selected_Voltage_CH4_bak = 0;

int ZeroLevelCH1_bak = 0;
int ZeroLevelCH2_bak = 0;
int ZeroLevelCH3_bak = 0;
int ZeroLevelCH4_bak = 0;

int Virtual_ZeroLevelCH1_bak = 0;
int Virtual_ZeroLevelCH2_bak = 0;
int Virtual_ZeroLevelCH3_bak = 0;
int Virtual_ZeroLevelCH4_bak = 0;

//BF added 
int ZeroLevelCH1_Main_bak = 0;
int ZeroLevelCH2_Main_bak = 0;
int ZeroLevelCH3_Main_bak = 0;
int ZeroLevelCH4_Main_bak = 0;
int Virtual_ZeroLevelCH1_Main_bak = 0;
int Virtual_ZeroLevelCH2_Main_bak = 0;
int Virtual_ZeroLevelCH3_Main_bak = 0;
int Virtual_ZeroLevelCH4_Main_bak = 0;

/*BF del -> integrated in new zero shift
//ADC-correction
int  alpha[4] = {0, 0, 0, 0};			// Y = beta * X + alpha	
float beta[4] = {1, 1, 1, 1};			// alpha -> zero offset, beta -> gain
*/


int Trigger_Pos_CH1_bak = 0;								// Stores the Trigger Position on Channel 1
int Trigger_Pos_CH2_bak = 0;								// Stores the Trigger Position on Channel 2
int Trigger_Pos_CH3_bak = 0;								// Stores the Trigger Position on Channel 3
int Trigger_Pos_CH4_bak = 0;

int AC_CH1_bak = 0;
int AC_CH2_bak = 0;
int AC_CH3_bak = 0;
int AC_CH4_bak = 0;

int Invert_CH1_bak = 0;
int Invert_CH2_bak = 0;
int Invert_CH3_bak = 0;
int Invert_CH4_bak = 0;

int MAINMODE_bak = 0;
int TriggerMode_bak = 0;

int Acquire_bak_0 = 0;
int Acquire_bak_1 = 0;

volatile int HistoMax_1 = 0;
volatile int HistoMax_2 = 0;	
volatile int HistoSt_1 = 0;
volatile int HistoSt_2 = 0;
volatile int HistoDiv = 0;

short draw_start  = 0;
short draw_factor = 0;
short draw_dm_ixstart = 0;
short draw_dm_ixfactor = 0;
char  MainTimebase_bak;
char Run_bak;
unsigned char SingleShot_bak;

int Rot_Time = 0;


char testtoggle =0;

int CH1_DAC_Offset = DAC_MIDSCALE;
int CH2_DAC_Offset = DAC_MIDSCALE;
int CH3_DAC_Offset = DAC_MIDSCALE;
int CH4_DAC_Offset = DAC_MIDSCALE;


//BF new correction array
//  DAC_Correction[Set 1-4][Channel 1-4][VoltRange 1-3];
int DAC_Correction[4][4][3] = {{{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}},
			       {{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}},
			       {{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}},
			       {{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}}};

//BF add #001 Channel delay correction
char CH1_Del_Correct = 0;
char CH2_Del_Correct = 0;
char CH3_Del_Correct = 0;
char CH4_Del_Correct = 0;


//--------------------------------------------------------------------------------------
// BF add
// Variables for new ultra slow timebase mode

short USTB_Mode     = 0;			//0 -> off , 1 -> roll mode, 2 -> shift mode
short USTB_Mode_bak = 0;
short USTB_Dir      = USTB_FORWARD;		//buffer storing direction
//short USTB_Dir_bak  = USTB_FORWARD;
short USTB_Disp     = USTB_PERM;		//display mode (permanent/step)
unsigned char USTB_NewData  = 0;		//flag to show if new data is available
int  USTB_idx               = 0;		//pointer to the actual time positien
int  USTB_EOSignal          = 0;		//end of signal

//--------------------------------------------------------------------------------------

int LED_ON[16];
//int LED_Buf = 0;

int Display_Line_Adresses[480];
//BF del not used int Display_Line_Adresses2[480];

//int *Display_Line_Adresses = (int *) 0x008DCA74;
//int *Display_Line_Adresses2 = (int *) 0x008DCE34;

volatile unsigned char VSync_Needed = 0;
//volatile unsigned char DrawSignals_Needed = 1; //BF del


///BF old USB functions -> can be deleted in future #017
volatile unsigned char uart2_buffer[64];
volatile unsigned char send_buffer[64];
//volatile char uart2_count;

//BF new designed USB functions #017
volatile char UART2_rx_cnt;
volatile unsigned char UART2_rx_buffer[64];
volatile unsigned char UART2_tx_buffer[64];


// For clearing Channel and Math Plane Bit 1 - 5
volatile unsigned char ClearPlane = 0x00;
volatile unsigned char DrawPlane = 0x00;
volatile unsigned char RemovePlane = 0x00;
volatile unsigned char ClearPhase = true;

volatile unsigned char UpdateMarkerPlane = true;
volatile unsigned char UpdateMenuTextPlane = true;

volatile int TestVar = 10;

// Rotary
volatile int Rotary_Direction = 0;
volatile int Rotary_Direction_mem_pulse = 1;
volatile int Rotary_Switch = 0;
volatile int Rotary_Steps = 1;

volatile int Keyboard_mem = 0;
volatile char Keyboard_Changed = 0;

volatile char ADC_Data_Available = 0;

//unsigned long TransPlane_Buffer_Adr1 = 0x00000000; 	BF not used
//unsigned long TransPlane_Plane_Adr1 = 0x00000000;	BF not used
//unsigned long TransPlane_Buffer_Adr2 = 0x00000000;	BF not used
//unsigned long TransPlane_Plane_Adr2 = 0x00000000;	BF not used

unsigned short SwitchesCH1;
unsigned short SwitchesCH2;
unsigned short SwitchesCH3;
unsigned short SwitchesCH4;
unsigned short SwitchesTB;

unsigned short SwitchesLMH[4]; 		//Jörg -> analog to SwitchesCHx

// Signal pointer
unsigned char *S1Ptr = 0;
unsigned char *S2Ptr = 0;
unsigned char *S3Ptr = 0;
unsigned char *S4Ptr = 0;
unsigned char *SMPtr = 0;

unsigned long *Buffer_Mark1Plane = (unsigned long *) 0x008CA5F4; //0x008D3BF4;
unsigned long *Buffer_UI2Plane = (unsigned long *) 0x008D3BF4;

//BF not used unsigned char *SIGNAL_IntBuf = (unsigned char *) 0x008DD1F4;

// BF add QM changed by Stefan
int *SIGNAL_Histo = (int *) 0x008DD320;					//BF -> used for QM calculation

/* BF del QM changed by Stefan
int *SIGNAL1_Histo = (int *) 0x008DD320;				//BF -> used for QM calculation
int *SIGNAL2_Histo = (int *) 0x008DD520;
int *SIGNAL3_Histo = (int *) 0x008DD720;
int *SIGNAL4_Histo = (int *) 0x008DD920;
int *SIGNALM_Histo = (int *) 0x008DDB20;
*/
//----------------------------------------------------------------------------------------------------------------------------
// memory area 6000 Byte wide [0x008DDD20 - 0x008DF48F] for buffering interpolation, USTB and FFT values
unsigned char *SIGNAL1_Intpolate = (unsigned char *) 0x008DDD20;   	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL2_Intpolate = (unsigned char *) 0x008DE1D0;	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL3_Intpolate = (unsigned char *) 0x008DE680;	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL4_Intpolate = (unsigned char *) 0x008DEB30;	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNALM_Intpolate = (unsigned char *) 0x008DEFE0;	// BF -> shared memory for Interpolation 1200 Byte

unsigned char *SIGNAL1_USTB = (unsigned char *) 0x008DDD20;   		// BF -> shared memory for USTB mode 1200 Byte
unsigned char *SIGNAL2_USTB = (unsigned char *) 0x008DE1D0;   		// BF -> shared memory for USTB mode 1200 Byte
unsigned char *SIGNAL3_USTB = (unsigned char *) 0x008DE680;   		// BF -> shared memory for USTB mode 1200 Byte
unsigned char *SIGNAL4_USTB = (unsigned char *) 0x008DEB30;   		// BF -> shared memory for USTB mode 1200 Byte
//unsigned char *SIGNALM_USTB = (unsigned char *) 0x008DEFE0;   		// BF -> shared memory for USTB mode 1200 Byte

//int *freq_re = (int *) 0x008DDD20		//1024 * 4 = 4096	//BF -> shared memory for frequency values real -> declared local

//------------------------------------------------------------------------------------------------------------------------------
// memory area 6000 Byte wide [0x008DF490 - 0x008E0C0F] for buffering interpolation and FFT values
unsigned char *SIGNAL1_Intpolate_delayed = (unsigned char *) 0x008DF490;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL2_Intpolate_delayed = (unsigned char *) 0x008DF940;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL3_Intpolate_delayed = (unsigned char *) 0x008DFDF0;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL4_Intpolate_delayed = (unsigned char *) 0x008E02A0;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNALM_Intpolate_delayed = (unsigned char *) 0x008E0750;// BF -> shared memory for Interpolation 1200 Byte

//int *freq_im = (int *) 0x008DF490;	//1024 * 4 = 4096	// BF -> shared memory forFrequency values imaginary -> declared local

//-------------------------------------------------------------------------------------------------------------------------------

//BF -> used for overlay mode
unsigned char *SIGNAL1_Buffer = (unsigned char *) 0x008E0C00;	//BF -> 16384 Byte
unsigned char *SIGNAL2_Buffer = (unsigned char *) 0x008E4C00;	//BF -> 16384 Byte
unsigned char *SIGNAL3_Buffer = (unsigned char *) 0x008E8C00;	//BF -> 16384 Byte
unsigned char *SIGNAL4_Buffer = (unsigned char *) 0x008ECC00;	//BF -> 16384 Byte

//-----------------------------------------------------------------------------------------------------------------------------

// BF free memory  16K [0x008F0C00 - 0x008F4BFF]
//int *tab    = (int *) 0x008F0C00;		//1024 * 4 = 4096	
//int *tab    = (int *) 0x008F1C00;		//1024 * 4 = 4096	
//int *tab    = (int *) 0x008F2C00;		//1024 * 4 = 4096	
//int *tab    = (int *) 0x008F3C00;		//1024 * 4 = 4096	

//-----------------------------------------------------------------------------------------------------------------------------

//BF -> read out buffer for reading ADC values in format long and char
// needs a little bit more than 16384 in normal TB, so the memory area
// below is overwritten sometimes (read out count is 5004 x 4 bytes in slow TB).
// This is no problem, because the memory area below is used for USTB
// only (read out count is 128). 
// Address is used hard coded in assembler routine READADC_ALL()!!! 
unsigned long *readout_sigbuf = (unsigned long *) 0x008F4C00;			//16384 byte - 16k
unsigned char *readout_sigbuf_char = (unsigned char *) 0x008F4C00;

//unsigned long *readout_sigbuf = (unsigned long *) 0x00917440;			//16384 byte - 16k
//unsigned char *readout_sigbuf_char = (unsigned char *) 0x00917440;

//------------------------------------------------------------------------------------------------------------------------------
//BF 0x008F8C00 - 0x00908C00  64k shared memory area -> can be used as memory for multiple purposes

// 0x008F8C00 - 0x008FCC00	-> 16384 byte - 16k
// 0x008FCC00 - 0x00900C00	-> 16384 byte - 16k
// 0x00900C00 - 0x00904C00	-> 16384 byte - 16k
// 0x00904C00 - 0x00908C00	-> 16384 byte - 16k

// FIR temporary buffer shared with USTB shift
unsigned char *FIR_Buffer = (unsigned char *) 0x008F8C00;


// BF reserved when USTB is active! buffer for USTB shift / roll mode 
unsigned char *SHIFT_OFFS1 = (unsigned char *) 0x008F8C00;	//shift buffer 16k for channel 1 
unsigned char *SHIFT_OFFS2 = (unsigned char *) 0x008FCC00;	//shift buffer 16k for channel 2 
unsigned char *SHIFT_OFFS3 = (unsigned char *) 0x00900C00;	//shift buffer 16k for channel 3 
unsigned char *SHIFT_OFFS4 = (unsigned char *) 0x00904C00;	//shift buffer 16k for channel 4 
unsigned char *SHIFT_OFFSM = (unsigned char *) 0x00908C00;	//shift buffer 16k for channel 4 

unsigned char *ROLL_OFFS1 = (unsigned char *) 0x008F8C00;	//roll buffer 32k for channel 1 
unsigned char *ROLL_OFFS2 = (unsigned char *) 0x00900C00;	//roll buffer 32k for channel 2 

//-------------------------------------------------------------------------------------------------------------------------------
//BF 0x00908C00 - 0x0091CC00  80k shared memory area -> can be used as memory for multiple purposes

// BF complete 80k reserved when USTB is active!
unsigned char *ROLL_OFFS3 = (unsigned char *) 0x00908C00;	//roll buffer 32k for channel 3 
unsigned char *ROLL_OFFS4 = (unsigned char *) 0x00910C00;	//roll buffer 32k for channel 4 
unsigned char *ROLL_OFFSM = (unsigned char *) 0x00918C00;	//roll buffer 32k for channel math 

//BF -> low pass filtering in normal TB (shared memory)
unsigned char *Filter1_Buffer = (unsigned char *) 0x00908C00;	//BF -> 16384 Byte
unsigned char *Filter2_Buffer = (unsigned char *) 0x0090CC00;	//BF -> 16384 Byte
unsigned char *Filter3_Buffer = (unsigned char *) 0x00910C00;	//BF -> 16384 Byte
unsigned char *Filter4_Buffer = (unsigned char *) 0x00914C00;	//BF -> 16384 Byte
unsigned char *CopyBuffer     = (unsigned char *) 0x00918C00;	//BF -> 16384 Byte

//-------------------------------------------------------------------------------------------------------------------------------

//signal buffer
unsigned char *SIGNAL1 = (unsigned char *) 0x0091CC00;		//BF -> 16384 Byte
unsigned char *SIGNAL2 = (unsigned char *) 0x00920C00;		//BF -> 16384 Byte
unsigned char *SIGNAL3 = (unsigned char *) 0x00924C00;		//BF -> 16384 Byte
unsigned char *SIGNAL4 = (unsigned char *) 0x00928C00;		//BF -> 16384 Byte
unsigned char *SIGNALM = (unsigned char *) 0x0092CC00;		//BF -> 16384 Byte
int *SPECTRUM = (int *) 0x0092CC00;			// shared memory with math channel 

//-------------------------------------------------------------------------------------------------------------------------------

// buffer for the signal display layer 
unsigned long *Buffer_PlaneM = (unsigned long *) 0x00930C00; // 38400(char) = 9600(long) = 80 byte * 480 
unsigned long *Buffer_Plane1 = (unsigned long *) 0x0093A200;
unsigned long *Buffer_Plane2 = (unsigned long *) 0x00943800;
unsigned long *Buffer_Plane3 = (unsigned long *) 0x0094CE00;
unsigned long *Buffer_Plane4 = (unsigned long *) 0x00956400;


unsigned long *Planes = (unsigned long *) 0x0095FA00;		//Planes base address -> 16 * 38400 = 614400 byte = 153600(long)
unsigned long *UI_Plane1 = (unsigned long *) 0x0095FA00;		//white
unsigned long *UI_Plane2 = (unsigned long *) 0x00969000;		//black -> text plane
unsigned long *UI_Plane3 = (unsigned long *) 0x00972600;		//beige
unsigned long *UI_Plane4 = (unsigned long *) 0x0097BC00;		//yellow
unsigned long *UI_Plane5 = (unsigned long *) 0x00985200;		//dark gray

// signal display layer
unsigned long *Channel_Plane1 = (unsigned long *) 0x0098E800;		// yellow
unsigned long *Channel_Plane2 = (unsigned long *) 0x00997E00;		// green
unsigned long *Channel_Plane3 = (unsigned long *) 0x009A1400;		// blue
unsigned long *Channel_Plane4 = (unsigned long *) 0x009AAA00;		// red
unsigned long *Channel_Math_Plane = (unsigned long *) 0x009B4000;	// violet

// memory space for three buffer planes -> not displayed
unsigned long *Copy_Plane1 = (unsigned long *) 0x009BD600;
unsigned long *Copy_Plane2 = (unsigned long *) 0x009C6C00;
unsigned long *Copy_Plane3 = (unsigned long *) 0x009D0200;

unsigned long *Marker_Plane1 = (unsigned long *) 0x009D9800;		//light red
unsigned long *Marker_Plane2 = (unsigned long *) 0x009E2E00;		//light red

unsigned long *Grid_Plane = (unsigned long *) 0x009EC400;

//-------------------------------------------------------------------------------------------------------------------------------

//BF test for checking memory
//unsigned long *Dummy_Address = (unsigned long *) 0x009F5A00;


//Plane addresses with changed format
//long v_Buffer_PlaneM = 0x00930C00;
long v_Buffer_Plane1 = 0x0093A200;
long v_Buffer_Plane2 = 0x00943800;
long v_Buffer_Plane3 = 0x0094CE00;
long v_Buffer_Plane4 = 0x00956400;

long v_Channel_Plane1 = 0x0098E800;
long v_Channel_Plane2 = 0x00997E00;
long v_Channel_Plane3 = 0x009A1400;
long v_Channel_Plane4 = 0x009AAA00;
//long v_Channel_Math_Plane = 0x009B4000;

unsigned long *Text_Plane = (unsigned long *) 0x00969000;	// pointer to UI_Plane2 (black)


/*
// test
unsigned long buffer_long1 = 0;
unsigned long buffer_long2 = 0;
unsigned long buffer_long3 = 0;
unsigned long buffer_long4 = 0;
unsigned long buffer_addi = 0;
*/

// BF QM thresholds
short thres_type[5] = {0,0,0,0,0};
short thres_low[5] = {0,0,0,0,0};
short thres_mdl[5] = {0,0,0,0,0};
short thres_up[5] = {0,0,0,0,0};

float thres_low_abs[5] = {0,0,0,0,0};
float thres_mdl_abs[5] = {0,0,0,0,0};
float thres_up_abs[5] = {0,0,0,0,0};

// BF add QM changed by Stefan
short SIGNAL_MIN[5]={0,0,0,0,0};
short SIGNAL_MDL[5] = {0,0,0,0,0};
short SIGNAL_MAX[5] = {0,0,0,0,0};
short SIGNAL_BASE[5] = {0,0,0,0,0};
short SIGNAL_TOP[5] = {0,0,0,0,0};
short SIGNAL_AVG[5] = {0,0,0,0,0};
short SIGNAL_AVG_CNT[5] = {0,0,0,0,0};
short SIGNAL_THRES_LOW[5] = {0,0,0,0,0};
short SIGNAL_THRES_MDL[5] = {0,0,0,0,0};
short SIGNAL_THRES_UP[5] = {0,0,0,0,0};

short SIGNAL_THRES_PRE_POSITIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_LOW_POSITIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_MDL_POSITIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_UP_POSITIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_OVER_POSITIV_1[5] = {0,0,0,0,0};

short SIGNAL_THRES_PRE_NEGATIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_LOW_NEGATIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_MDL_NEGATIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_UP_NEGATIV_1[5] = {0,0,0,0,0};
short SIGNAL_THRES_OVER_NEGATIV_1[5] = {0,0,0,0,0};

short SIGNAL_THRES_PRE_POSITIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_LOW_POSITIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_MDL_POSITIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_UP_POSITIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_OVER_POSITIV_2[5] = {0,0,0,0,0};

short SIGNAL_THRES_PRE_NEGATIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_LOW_NEGATIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_MDL_NEGATIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_UP_NEGATIV_2[5] = {0,0,0,0,0};
short SIGNAL_THRES_OVER_NEGATIV_2[5] = {0,0,0,0,0};

short SIGNAL_THRES_PRE_POSITIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_LOW_POSITIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_MDL_POSITIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_UP_POSITIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_OVER_POSITIV_LAST[5] = {0,0,0,0,0};

short SIGNAL_THRES_PRE_NEGATIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_LOW_NEGATIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_MDL_NEGATIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_UP_NEGATIV_LAST[5] = {0,0,0,0,0};
short SIGNAL_THRES_OVER_NEGATIV_LAST[5] = {0,0,0,0,0};


char DelayedTimebase;						// Selected Timebase in delayed mode
int dmode_Cursor_Vertical_Position1_Old;
int dmode_Cursor_Vertical_Position2_Old;
int dmode_QM_Vertical_Position1_Old;
int dmode_QM_Vertical_Position2_Old;
int dmode_Window_Offset_Pos;
int dmode_Window_Offset_Pos_Old;

float Timebase_Ratio = 1.0;

int Cursor_Delayed_1     = 180;
int Cursor_Delayed_2     = 420;
int Cursor_Delayed_Size  = 300;
int Cursor_Delayed_1_Old = 180;
int Cursor_Delayed_2_Old = 420;

unsigned char buf_arr[600];

//------------------------------------------------------------------------------------------------------------------

unsigned char GainIdx = 0;	//BF Index 0-4 to choose the preamp gain bolow

//BF floating point scale factor is used for amplitude calculation
//Standard gain 1  //gain 1.25  //preamp with 24.9 Ohm + gain 1.25  //preamp with 33 Ohm + gain 1.25   //Hardware Add On

			  // gain 1  1.25  24.9Ohm   33Ohm   Addon PCB
float ScaleFactor[16][5] ={ {3.25,  2.620,  3.650,   3.875,  1.822},    //  1mV
			    {3.25,  2.620,  3.650,   3.875,  1.804},    //  2mV
			    {2.100, 2.100,  2.900,   3.125,  1.799},    //  5mV
			    {3.25,  2.620,  3.650,   3.875,  1.822},    // 10mV
			    {3.25,  2.620,  3.650,   3.875,  1.804},    // 20mV
			    {2.095, 2.100,  2.900,   3.125,  1.799},    // 50mV
			    {3.25,  2.620,  3.650,   3.875,  1.822},    //100mV
			    {3.25,  2.620,  3.650,   3.875,  1.804},    //200mV
			    {2.095, 2.100,  2.900,   3.125,  1.799},    //500mV
			    {3.25,  2.620,  3.650,   3.875,  1.822},    //  1V
			    {3.25,  2.620,  3.650,   3.875,  1.804},    //  2V
			    {2.095, 2.100,  2.900,   3.125,  1.799},    //  5V
			    {3.25,  2.620,  3.650,   3.875,  1.822},    //  10V
			    {3.25,  2.620,  3.650,   3.875,  1.804},    //  20V
			    {2.095, 2.100,  2.900,   3.125,  1.799},    //  50V
			    {3.25,  2.620,  3.650,   3.875,  1.822}};   //  100V

//BF scale index for 1er/2er ranges (index 0) and 5er ranges (index 1)
char ScaleIndexTable[16] = { 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0 };


// lookup values for 1er/2er ranges scale index 0, 5er ranges - scale index 1
// will be initialized at startup sequence
short ScaleLookupTable[256][3];

// scaling correction factor for each FFT mode
//		FFT_MAGN / FFT_PHAS / FFT_REAL / FFT_IMAG / FFT_REIM /  FFT_PWSP / FFT_PWDN
float FFT_ScaleCorrection[16][7] = {{ 1.100, 1.000, 1.000, 1.000, 1.000, 0.200, 1.000 },  //  1mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //  2mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //  5mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  // 10mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  // 20mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  // 50mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //100mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //200mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //500mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //  1V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.550, 1.000 },  //  2V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.650, 1.000 },  //  5V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 },  //  10V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 },  //  20V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 },  //  50V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 }}; //  100V

// FFT lookup values -> will be initialized at startup sequence
short FFT_ScaleLookupTable[256];


//BF scale factors for zero shift in zero level handler -> UserIF::ON_Zero_Channel_x()
			   //Standard gain 1  //gain 1.25  //preamp with 24 Ohm + gain 1.25  //preamp with 33 Ohm + gain 1.25   //Hardware Add On
			      // gain 1  1.25   24.9Ohm  33Ohm  Addon PCB
float DAC_ScaleFactor[3][5] = {{ 2.480, 2.480,  2.480,  2.520, 16.361 },	// 1er ranges
                               { 4.940, 4.900,  4.940,  4.980, 30.503 },	// 2er ranges
                               {12.360,12.360, 12.360, 12.432, 76.505 }};	// 5er ranges

// BF ADC correction for every single ADC of the quad-ADC -> will be loaded from flash
int ADC_Offset[4][4] = {{ 0, 0, 0, 0},            
                        { 0, 0, 0, 0},            
                        { 0, 0, 0, 0},            
                        { 0, 0, 0, 0}};           


//--------------------------------------------------------------------------------------------------------------------------------
/* BF del 

short FIR_Tabel[6][9]={{   0,   0,   0,   0, 256,   0,   0,   0,   0},
                       {   9, -12,  18, -34, 244,  48, -22,  14, -10},
                       {  16, -21,  30, -52, 211, 105, -42,  26, -19},
                       {  18, -23,  32, -54, 163, 163, -54,  32, -23},
                       {  15, -19,  26, -42, 105, 211, -52,  30, -21},
                       {   8, -10,  14, -22,  48, 244, -34,  18, -12}};
                                                  
                                                  
                                                  
 short FIR_Tab_big[256][6][9];                    
                                                  
char FirEnabledCH1 = 0;                           
char FirEnabledCH2 = 0;                           
char FirEnabledCH3 = 0;                           
char FirEnabledCH4 = 0;                           
                                                  
                                                  
//BF not used short FirStartCH = 245;             
                                                  
//BF not used short FirStartCH_delayed = 245;     
                                                  
char SmoothEnabledCH1 = 0;                        
char SmoothEnabledCH2 = 0;
char SmoothEnabledCH3 = 0;
char SmoothEnabledCH4 = 0;
*/

//--------------------------------------------------------------------------------------------------------------
//BF -> declarations for Math FFT function
unsigned char MATH_Mode = MATH_OFF; 

unsigned char FFT_Mode = FFT_OFF; 
unsigned char FFT_NewData = 0;
int FFT_Length = FFT_512;
int FFT_Level  = 9;		// FFT_Level = ld(FFT_Length)
int FFT_Windex = -1;		// FFT window index default is Rect
//BF not needed anymore int FFT_Scale  = 2;		// scaling will be made in drawing routine

int FFT_NormENBW;		//Equivalent Noise Bandwidth normed to delta frequency in dB

//int FFT_Win512[512];

short FFT_TriggerMode_bak;

//char FFTToggle  = 0;						// for switching between Scale and Offset
//FloatStr FFT_Scale_Str;					//create FloatStr instance
//FloatStr FFT_Offset_Str;					//create FloatStr instance

float FFT_ENBW[6] = { 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 };

unsigned char FFT_Layout = 0; 
FloatStr FFT_Status_Str;

int iSin1024[1024] =   {   0,    6,   13,   19,   25,   31,   38,   44,   50,   57,   63,   69,   75,   82,   88,   94,  100,  107,  113,  119,
			 125,  132,  138,  144,  150,  156,  163,  169,  175,  181,  187,  194,  200,  206,  212,  218,  224,  230,  237,  243,
			 249,  255,  261,  267,  273,  279,  285,  291,  297,  303,  309,  315,  321,  327,  333,  339,  345,  351,  357,  363,
			 369,  374,  380,  386,  392,  398,  403,  409,  415,  421,  426,  432,  438,  443,  449,  455,  460,  466,  472,  477,
			 483,  488,  494,  499,  505,  510,  516,  521,  526,  532,  537,  543,  548,  553,  558,  564,  569,  574,  579,  584,
			 590,  595,  600,  605,  610,  615,  620,  625,  630,  635,  640,  645,  650,  654,  659,  664,  669,  674,  678,  683,
			 688,  692,  697,  702,  706,  711,  715,  720,  724,  729,  733,  737,  742,  746,  750,  755,  759,  763,  767,  771,
			 775,  779,  784,  788,  792,  796,  799,  803,  807,  811,  815,  819,  822,  826,  830,  834,  837,  841,  844,  848,
			 851,  855,  858,  862,  865,  868,  872,  875,  878,  882,  885,  888,  891,  894,  897,  900,  903,  906,  909,  912,
			 915,  917,  920,  923,  926,  928,  931,  934,  936,  939,  941,  944,  946,  948,  951,  953,  955,  958,  960,  962,
			 964,  966,  968,  970,  972,  974,  976,  978,  980,  982,  983,  985,  987,  989,  990,  992,  993,  995,  996,  998,
			 999, 1000, 1002, 1003, 1004, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1016, 1017, 1018, 1018,
			1019, 1020, 1020, 1021, 1021, 1022, 1022, 1022, 1023, 1023, 1023, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
			1024, 1024, 1023, 1023, 1023, 1022, 1022, 1022, 1021, 1021, 1020, 1020, 1019, 1018, 1018, 1017, 1016, 1016, 1015, 1014,
			1013, 1012, 1011, 1010, 1009, 1008, 1007, 1006, 1004, 1003, 1002, 1000,  999,  998,  996,  995,  993,  992,  990,  989,
			 987,  985,  983,  982,  980,  978,  976,  974,  972,  970,  968,  966,  964,  962,  960,  958,  955,  953,  951,  948,
			 946,  944,  941,  939,  936,  934,  931,  928,  926,  923,  920,  917,  915,  912,  909,  906,  903,  900,  897,  894,
			 891,  888,  885,  882,  878,  875,  872,  868,  865,  862,  858,  855,  851,  848,  844,  841,  837,  834,  830,  826,
			 822,  819,  815,  811,  807,  803,  799,  796,  792,  788,  784,  779,  775,  771,  767,  763,  759,  755,  750,  746,
			 742,  737,  733,  729,  724,  720,  715,  711,  706,  702,  697,  692,  688,  683,  678,  674,  669,  664,  659,  654,
			 650,  645,  640,  635,  630,  625,  620,  615,  610,  605,  600,  595,  590,  584,  579,  574,  569,  564,  558,  553,
			 548,  543,  537,  532,  526,  521,  516,  510,  505,  499,  494,  488,  483,  477,  472,  466,  460,  455,  449,  443,
			 438,  432,  426,  421,  415,  409,  403,  398,  392,  386,  380,  374,  369,  363,  357,  351,  345,  339,  333,  327,
			 321,  315,  309,  303,  297,  291,  285,  279,  273,  267,  261,  255,  249,  243,  237,  230,  224,  218,  212,  206,
			 200,  194,  187,  181,  175,  169,  163,  156,  150,  144,  138,  132,  125,  119,  113,  107,  100,   94,   88,   82,
			  75,   69,   63,   57,   50,   44,   38,   31,   25,   19,   13,    6,    0,   -6,  -13,  -19,  -25, - 31,  -38,  -44,
			 -50,  -57,  -63,  -69,  -75,  -82,  -88,  -94, -100, -107, -113, -119, -125, -132, -138, -144, -150, -156, -163, -169,
			-175, -181, -187, -194, -200, -206, -212, -218, -224, -230, -237, -243, -249, -255, -261, -267, -273, -279, -285, -291,
			-297, -303, -309, -315, -321, -327, -333, -339, -345, -351, -357, -363, -369, -374, -380, -386, -392, -398, -403, -409,
			-415, -421, -426, -432, -438, -443, -449, -455, -460, -466, -472, -477, -483, -488, -494, -499, -505, -510, -516, -521,
			-526, -532, -537, -543, -548, -553, -558, -564, -569, -574, -579, -584, -590, -595, -600, -605, -610, -615, -620, -625,
			-630, -635, -640, -645, -650, -654, -659, -664, -669, -674, -678, -683, -688, -692, -697, -702, -706, -711, -715, -720,
			-724, -729, -733, -737, -742, -746, -750, -755, -759, -763, -767, -771, -775, -779, -784, -788, -792, -796, -799, -803,
			-807, -811, -815, -819, -822, -826, -830, -834, -837, -841, -844, -848, -851, -855, -858, -862, -865, -868, -872, -875,
			-878, -882, -885, -888, -891, -894, -897, -900, -903, -906, -909, -912, -915, -917, -920, -923, -926, -928, -931, -934,
			-936, -939, -941, -944, -946, -948, -951, -953, -955, -958, -960, -962, -964, -966, -968, -970, -972, -974, -976, -978,
			-980, -982, -983, -985, -987, -989, -990, -992, -993, -995, -996, -998, -999,-1000,-1002,-1003,-1004,-1006,-1007,-1008,
		       -1009,-1010,-1011,-1012,-1013,-1014,-1015,-1016,-1016,-1017,-1018,-1018,-1019,-1020,-1020,-1021,-1021,-1022,-1022,-1022,
		       -1023,-1023,-1023,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1023,-1023,-1023,-1022,-1022,-1022,
		       -1021,-1021,-1020,-1020,-1019,-1018,-1018,-1017,-1016,-1016,-1015,-1014,-1013,-1012,-1011,-1010,-1009,-1008,-1007,-1006,
		       -1004,-1003,-1002,-1000, -999, -998, -996, -995, -993, -992, -990, -989, -987, -985, -983, -982, -980, -978, -976, -974,
			-972, -970, -968, -966, -964, -962, -960, -958, -955, -953, -951, -948, -946, -944, -941, -939, -936, -934, -931, -928,
			-926, -923, -920, -917, -915, -912, -909, -906, -903, -900, -897, -894, -891, -888, -885, -882, -878, -875, -872, -868,
			-865, -862, -858, -855, -851, -848, -844, -841, -837, -834, -830, -826, -822, -819, -815, -811, -807, -803, -799, -796,
			-792, -788, -784, -779, -775, -771, -767, -763, -759, -755, -750, -746, -742, -737, -733, -729, -724, -720, -715, -711,
			-706, -702, -697, -692, -688, -683, -678, -674, -669, -664, -659, -654, -650, -645, -640, -635, -630, -625, -620, -615,
			-610, -605, -600, -595, -590, -584, -579, -574, -569, -564, -558, -553, -548, -543, -537, -532, -526, -521, -516, -510,
			-505, -499, -494, -488, -483, -477, -472, -466, -460, -455, -449, -443, -438, -432, -426, -421, -415, -409, -403, -398,
			-392, -386, -380, -374, -369, -363, -357, -351, -345, -339, -333, -327, -321, -315, -309, -303, -297, -291, -285, -279,
			-273, -267, -261, -255, -249, -243, -237, -230, -224, -218, -212, -206, -200, -194, -187, -181, -175, -169, -163, -156,
			-150, -144, -138, -132, -125, -119, -113, -107, -100,  -94,  -88,  -82,  -75,  -69,  -63,  -57,  -50,  -44,  -38,  -31,
			 -25,  -19,  -13,   -6  };

int iCos1024[1024] = {  1024, 1024, 1024, 1024, 1024, 1024, 1023, 1023, 1023, 1022, 1022, 1022, 1021, 1021, 1020, 1020, 1019, 1018, 1018, 1017,
			1016, 1016, 1015, 1014, 1013, 1012, 1011, 1010, 1009, 1008, 1007, 1006, 1004, 1003, 1002, 1000,  999,  998,  996,  995,
			 993,  992,  990,  989,  987,  985,  983,  982,  980,  978,  976,  974,  972,  970,  968,  966,  964,  962,  960,  958,
			 955,  953,  951,  948,  946,  944,  941,  939,  936,  934,  931,  928,  926,  923,  920,  917,  915,  912,  909,  906,
			 903,  900,  897,  894,  891,  888,  885,  882,  878,  875,  872,  868,  865,  862,  858,  855,  851,  848,  844,  841,
			 837,  834,  830,  826,  822,  819,  815,  811,  807,  803,  799,  796,  792,  788,  784,  779,  775,  771,  767,  763,
			 759,  755,  750,  746,  742,  737,  733,  729,  724,  720,  715,  711,  706,  702,  697,  692,  688,  683,  678,  674,
			 669,  664,  659,  654,  650,  645,  640,  635,  630,  625,  620,  615,  610,  605,  600,  595,  590,  584,  579,  574,
			 569,  564,  558,  553,  548,  543,  537,  532,  526,  521,  516,  510,  505,  499,  494,  488,  483,  477,  472,  466,
			 460,  455,  449,  443,  438,  432,  426,  421,  415,  409,  403,  398,  392,  386,  380,  374,  369,  363,  357,  351,
			 345,  339,  333,  327,  321,  315,  309,  303,  297,  291,  285,  279,  273,  267,  261,  255,  249,  243,  237,  230,
			 224,  218,  212,  206,  200,  194,  187,  181,  175,  169,  163,  156,  150,  144,  138,  132,  125,  119,  113,  107,
			 100,   94,   88,   82,   75,   69,   63,   57,   50,   44,   38,   31,   25,   19,   13,    6,    0,   -6,  -13,  -19, 
			 -25,  -31,  -38,  -44,  -50,  -57,  -63,  -69,  -75,  -82,  -88,  -94, -100, -107, -113, -119, -125, -132, -138, -144,
			-150, -156, -163, -169, -175, -181, -187, -194, -200, -206, -212, -218, -224, -230, -237, -243, -249, -255, -261, -267,
			-273, -279, -285, -291, -297, -303, -309, -315, -321, -327, -333, -339, -345, -351, -357, -363, -369, -374, -380, -386,
			-392, -398, -403, -409, -415, -421, -426, -432, -438, -443, -449, -455, -460, -466, -472, -477, -483,-488,  -494, -499,
			-505, -510, -516, -521, -526, -532, -537, -543, -548, -553, -558, -564, -569, -574, -579, -584, -590, -595, -600, -605,
			-610, -615, -620, -625, -630, -635, -640, -645, -650, -654, -659, -664, -669, -674, -678, -683, -688, -692, -697, -702,
			-706, -711, -715, -720, -724, -729, -733, -737, -742, -746, -750, -755, -759, -763, -767, -771, -775, -779, -784, -788,
			-792, -796, -799, -803, -807, -811, -815, -819, -822, -826, -830, -834, -837, -841, -844, -848, -851, -855, -858, -862,
			-865, -868, -872, -875, -878, -882, -885, -888, -891, -894, -897, -900, -903, -906, -909, -912, -915, -917, -920, -923,
			-926, -928, -931, -934, -936, -939, -941, -944, -946, -948, -951, -953, -955, -958, -960, -962, -964, -966, -968, -970,
			-972, -974, -976, -978, -980, -982, -983, -985, -987, -989, -990, -992, -993, -995, -996, -998, -999,-1000,-1002,-1003,
		       -1004,-1006,-1007,-1008,-1009,-1010,-1011,-1012,-1013,-1014,-1015,-1016,-1016,-1017,-1018,-1018,-1019,-1020,-1020,-1021,
		       -1021,-1022,-1022,-1022,-1023,-1023,-1023,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1023,-1023,
		       -1023,-1022,-1022,-1022,-1021,-1021,-1020,-1020,-1019,-1018,-1018,-1017,-1016,-1016,-1015,-1014,-1013,-1012,-1011,-1010,
		       -1009,-1008,-1007,-1006,-1004,-1003,-1002,-1000, -999, -998, -996, -995, -993, -992, -990, -989, -987, -985, -983, -982,
			-980, -978, -976, -974, -972, -970, -968, -966, -964, -962, -960, -958, -955, -953, -951, -948, -946, -944, -941, -939,
			-936, -934, -931, -928, -926, -923, -920, -917, -915, -912, -909, -906, -903, -900, -897, -894, -891, -888, -885, -882,
			-878, -875, -872, -868, -865, -862, -858, -855, -851, -848, -844, -841, -837, -834, -830, -826, -822, -819, -815, -811,
			-807, -803, -799, -796, -792, -788, -784, -779, -775, -771, -767, -763, -759, -755, -750, -746, -742, -737, -733, -729,
			-724, -720, -715, -711, -706, -702, -697, -692, -688, -683, -678, -674, -669, -664, -659, -654, -650, -645, -640, -635,
			-630, -625, -620, -615, -610, -605, -600, -595, -590, -584, -579, -574, -569, -564, -558, -553, -548, -543, -537, -532,
			-526, -521, -516, -510, -505, -499, -494, -488, -483, -477, -472, -466, -460, -455, -449, -443, -438, -432, -426, -421,
			-415, -409, -403, -398, -392, -386, -380, -374, -369, -363, -357, -351, -345, -339, -333, -327, -321, -315, -309, -303,
			-297, -291, -285, -279, -273, -267, -261, -255, -249, -243, -237, -230, -224, -218, -212, -206, -200, -194, -187, -181,
			-175, -169, -163, -156, -150, -144, -138, -132, -125, -119, -113, -107, -100,  -94,  -88,  -82,  -75,  -69,  -63,  -57,
			 -50,  -44,  -38,  -31,  -25,  -19,  -13,   -6,    0,    6,   13,   19,   25,   31,   38,   44,   50,   57,   63,   69,
			  75,   82,   88,   94,  100,  107,  113,  119,  125,  132,  138,  144,  150,  156,  163,  169,  175,  181,  187,  194,
			 200,  206,  212,  218,  224,  230,  237,  243,  249,  255,  261,  267,  273,  279,  285,  291,  297,  303,  309,  315,
			 321,  327,  333,  339,  345,  351,  357,  363,  369,  374,  380,  386,  392,  398,  403,  409,  415,  421,  426,  432,
			 438,  443,  449,  455,  460,  466,  472,  477,  483,  488,  494,  499,  505,  510,  516,  521,  526,  532,  537,  543,
			 548,  553,  558,  564,  569,  574,  579,  584,  590,  595,  600,  605,  610,  615,  620,  625,  630,  635,  640,  645,
			 650,  654,  659,  664,  669,  674,  678,  683,  688,  692,  697,  702,  706,  711,  715,  720,  724,  729,  733,  737,
			 742,  746,  750,  755,  759,  763,  767,  771,  775,  779,  784,  788,  792,  796,  799,  803,  807,  811,  815,  819,
			 822,  826,  830,  834,  837,  841,  844,  848,  851,  855,  858,  862,  865,  868,  872,  875,  878,  882,  885,  888,
			 891,  894,  897,  900,  903,  906,  909,  912,  915,  917,  920,  923,  926,  928,  931,  934,  936,  939,  941,  944,
			 946,  948,  951,  953,  955,  958,  960,  962,  964,  966,  968,  970,  972,  974,  976,  978,  980,  982,  983,  985,
			 987,  989,  990,  992,  993,  995,  996,  998,  999, 1000, 1002, 1003, 1004, 1006, 1007, 1008, 1009, 1010, 1011, 1012,
			1013, 1014, 1015, 1016, 1016, 1017, 1018, 1018, 1019, 1020, 1020, 1021, 1021, 1022, 1022, 1022, 1023, 1023, 1023, 1024,
			1024, 1024, 1024, 1024 };


//logarithm table for log10(x) prescaled to integer screen size with factor 153,9  
short int iLog10[481] = {   0,  0, 46, 73, 93,107,120,130,139,147,
			  154,160,166,171,176,181,185,189,193,197,
			  200,203,206,209,212,215,218,220,222,225,
			  227,229,231,233,235,237,239,241,243,245,
			  246,248,250,251,253,254,256,257,258,260,
			  261,262,264,265,266,268,269,270,271,272,
			  273,274,276,277,278,279,280,281,282,283,
			  284,285,286,286,287,288,289,290,291,292,
			  293,293,294,295,296,297,297,298,299,300,
			  300,301,302,303,303,304,305,305,306,307,
			  307,308,309,309,310,311,311,312,313,313,
			  314,314,315,316,316,317,317,318,318,319,
			  320,320,321,321,322,322,323,323,324,324,
			  325,325,326,326,327,327,328,328,329,329,
			  330,330,331,331,332,332,333,333,334,334,
			  335,335,335,336,336,337,337,338,338,338,
			  339,339,340,340,340,341,341,342,342,342,
			  343,343,344,344,344,345,345,346,346,346,
			  347,347,347,348,348,349,349,349,350,350,
			  350,351,351,351,352,352,352,353,353,353,
			  354,354,354,355,355,355,356,356,356,357,
			  357,357,358,358,358,359,359,359,359,360,
			  360,360,361,361,361,362,362,362,362,363,
			  363,363,364,364,364,364,365,365,365,366,
			  366,366,366,367,367,367,368,368,368,368,
			  369,369,369,369,370,370,370,370,371,371,
			  371,371,372,372,372,373,373,373,373,374,
			  374,374,374,374,375,375,375,375,376,376,
			  376,376,377,377,377,377,378,378,378,378,
			  379,379,379,379,379,380,380,380,380,381,
			  381,381,381,381,382,382,382,382,383,383,
			  383,383,383,384,384,384,384,384,385,385,
			  385,385,386,386,386,386,386,387,387,387,
			  387,387,388,388,388,388,388,389,389,389,
			  389,389,390,390,390,390,390,391,391,391,
			  391,391,391,392,392,392,392,392,393,393,
			  393,393,393,394,394,394,394,394,394,395,
			  395,395,395,395,396,396,396,396,396,396,
			  397,397,397,397,397,397,398,398,398,398,
			  398,398,399,399,399,399,399,399,400,400,
			  400,400,400,400,401,401,401,401,401,401,
			  402,402,402,402,402,402,403,403,403,403,
			  403,403,404,404,404,404,404,404,405,405,
			  405,405,405,405,405,406,406,406,406,406,
			  406,407,407,407,407,407,407,407,408,408,
			  408,408,408,408,408,409,409,409,409,409,
			  409,409,410,410,410,410,410,410,410,411,
			  411,411,411,411,411,411,412,412,412,412,
			  412 };

// window tables prescaled to integer with factor 8192 (<< 13)
			  // 0->Hanning	
int FFT_Window[6][1024] ={{   0,   0,   1,   1,   2,   3,   4,   5,   6,   8,   9,  11,  13,  15,  17,  20,  22,  25,  28,  31,
			     34,  37,  41,  44,  48,  52,  56,  60,  65,  69,  74,  79,  84,  89,  94, 100, 105, 111, 117, 123,
			    129, 135, 142, 148, 155, 162, 169, 176, 184, 191, 199, 207, 215, 223, 231, 239, 248, 257, 265, 274,
			    284, 293, 302, 312, 321, 331, 341, 351, 362, 372, 383, 393, 404, 415, 426, 437, 449, 460, 472, 484,
			    496, 508, 520, 532, 545, 557, 570, 583, 596, 609, 622, 635, 649, 663, 676, 690, 704, 718, 733, 747,
			    762, 776, 791, 806, 821, 836, 852, 867, 882, 898, 914, 930, 946, 962, 978, 994,1011,1028,1044,1061,
			   1078,1095,1112,1129,1147,1164,1182,1200,1218,1235,1253,1272,1290,1308,1327,1345,1364,1383,1402,1421,
			   1440,1459,1478,1498,1517,1537,1556,1576,1596,1616,1636,1656,1676,1697,1717,1737,1758,1779,1800,1820,
			   1841,1862,1883,1905,1926,1947,1969,1990,2012,2034,2055,2077,2099,2121,2143,2165,2187,2210,2232,2254,
			   2277,2299,2322,2345,2367,2390,2413,2436,2459,2482,2505,2529,2552,2575,2598,2622,2645,2669,2692,2716,
			   2740,2764,2787,2811,2835,2859,2883,2907,2931,2955,2979,3004,3028,3052,3076,3101,3125,3150,3174,3199,
			   3223,3248,3272,3297,3322,3346,3371,3396,3421,3445,3470,3495,3520,3545,3570,3595,3620,3645,3670,3695,
			   3720,3745,3770,3795,3820,3845,3870,3895,3920,3945,3970,3995,4021,4046,4071,4096,4121,4146,4171,4197,
			   4222,4247,4272,4297,4322,4347,4372,4397,4422,4447,4472,4497,4522,4547,4572,4597,4622,4647,4672,4697,
			   4722,4747,4771,4796,4821,4846,4870,4895,4920,4944,4969,4993,5018,5042,5067,5091,5116,5140,5164,5188,
			   5213,5237,5261,5285,5309,5333,5357,5381,5405,5428,5452,5476,5500,5523,5547,5570,5594,5617,5640,5663,
			   5687,5710,5733,5756,5779,5802,5825,5847,5870,5893,5915,5938,5960,5982,6005,6027,6049,6071,6093,6115,
			   6137,6158,6180,6202,6223,6245,6266,6287,6309,6330,6351,6372,6392,6413,6434,6455,6475,6495,6516,6536,
			   6556,6576,6596,6616,6636,6655,6675,6694,6714,6733,6752,6771,6790,6809,6828,6847,6865,6884,6902,6920,
			   6939,6957,6974,6992,7010,7028,7045,7063,7080,7097,7114,7131,7148,7164,7181,7198,7214,7230,7246,7262,
			   7278,7294,7310,7325,7340,7356,7371,7386,7401,7416,7430,7445,7459,7474,7488,7502,7516,7529,7543,7557,
			   7570,7583,7596,7609,7622,7635,7647,7660,7672,7684,7696,7708,7720,7732,7743,7755,7766,7777,7788,7799,
			   7809,7820,7830,7841,7851,7861,7871,7880,7890,7899,7908,7918,7927,7935,7944,7953,7961,7969,7977,7985,
			   7993,8001,8008,8016,8023,8030,8037,8044,8050,8057,8063,8069,8075,8081,8087,8092,8098,8103,8108,8113,
			   8118,8123,8127,8132,8136,8140,8144,8148,8151,8155,8158,8161,8164,8167,8170,8172,8175,8177,8179,8181,
			   8183,8184,8186,8187,8188,8189,8190,8191,8191,8192,8192,8192,8192,8192,8192,8191,8191,8190,8189,8188,
			   8187,8186,8184,8183,8181,8179,8177,8175,8172,8170,8167,8164,8161,8158,8155,8151,8148,8144,8140,8136,
			   8132,8127,8123,8118,8113,8108,8103,8098,8092,8087,8081,8075,8069,8063,8057,8050,8044,8037,8030,8023,
			   8016,8008,8001,7993,7985,7977,7969,7961,7953,7944,7935,7927,7918,7908,7899,7890,7880,7871,7861,7851,
			   7841,7830,7820,7809,7799,7788,7777,7766,7755,7743,7732,7720,7708,7696,7684,7672,7660,7647,7635,7622,
			   7609,7596,7583,7570,7557,7543,7529,7516,7502,7488,7474,7459,7445,7430,7416,7401,7386,7371,7356,7340,
			   7325,7310,7294,7278,7262,7246,7230,7214,7198,7181,7164,7148,7131,7114,7097,7080,7063,7045,7028,7010,
			   6992,6974,6957,6939,6920,6902,6884,6865,6847,6828,6809,6790,6771,6752,6733,6714,6694,6675,6655,6636,
			   6616,6596,6576,6556,6536,6516,6495,6475,6455,6434,6413,6392,6372,6351,6330,6309,6287,6266,6245,6223,
			   6202,6180,6158,6137,6115,6093,6071,6049,6027,6005,5982,5960,5938,5915,5893,5870,5847,5825,5802,5779,
			   5756,5733,5710,5687,5663,5640,5617,5594,5570,5547,5523,5500,5476,5452,5428,5405,5381,5357,5333,5309,
			   5285,5261,5237,5213,5188,5164,5140,5116,5091,5067,5042,5018,4993,4969,4944,4920,4895,4870,4846,4821,
			   4796,4771,4747,4722,4697,4672,4647,4622,4597,4572,4547,4522,4497,4472,4447,4422,4397,4372,4347,4322,
			   4297,4272,4247,4222,4197,4171,4146,4121,4096,4071,4046,4021,3995,3970,3945,3920,3895,3870,3845,3820,
			   3795,3770,3745,3720,3695,3670,3645,3620,3595,3570,3545,3520,3495,3470,3445,3421,3396,3371,3346,3322,
			   3297,3272,3248,3223,3199,3174,3150,3125,3101,3076,3052,3028,3004,2979,2955,2931,2907,2883,2859,2835,
			   2811,2787,2764,2740,2716,2692,2669,2645,2622,2598,2575,2552,2529,2505,2482,2459,2436,2413,2390,2367,
			   2345,2322,2299,2277,2254,2232,2210,2187,2165,2143,2121,2099,2077,2055,2034,2012,1990,1969,1947,1926,
			   1905,1883,1862,1841,1820,1800,1779,1758,1737,1717,1697,1676,1656,1636,1616,1596,1576,1556,1537,1517,
			   1498,1478,1459,1440,1421,1402,1383,1364,1345,1327,1308,1290,1272,1253,1235,1218,1200,1182,1164,1147,
			   1129,1112,1095,1078,1061,1044,1028,1011, 994, 978, 962, 946, 930, 914, 898, 882, 867, 852, 836, 821,
			    806, 791, 776, 762, 747, 733, 718, 704, 690, 676, 663, 649, 635, 622, 609, 596, 583, 570, 557, 545,
			    532, 520, 508, 496, 484, 472, 460, 449, 437, 426, 415, 404, 393, 383, 372, 362, 351, 341, 331, 321,
			    312, 302, 293, 284, 274, 265, 257, 248, 239, 231, 223, 215, 207, 199, 191, 184, 176, 169, 162, 155,
			    148, 142, 135, 129, 123, 117, 111, 105, 100,  94,  89,  84,  79,  74,  69,  65,  60,  56,  52,  48,
			     44,  41,  37,  34,  31,  28,  25,  22,  20,  17,  15,  13,  11,   9,   8,   6,   5,   4,   3,   2,
			      1,   1,   0,   0,	},

			  // 1->Blackman
			  {   0,   0,   0,   0,   1,   1,   1,   2,   2,   3,   3,   4,   5,   5,   6,   7,   8,   9,  10,  11,
			     12,  14,  15,  16,  17,  19,  20,  22,  24,  25,  27,  29,  31,  33,  35,  37,  39,  41,  43,  45,
			     48,  50,  53,  55,  58,  60,  63,  66,  69,  72,  75,  78,  81,  84,  87,  91,  94,  98, 101, 105,
			    108, 112, 116, 120, 124, 128, 132, 136, 140, 145, 149, 154, 158, 163, 168, 172, 177, 182, 187, 192,
			    198, 203, 208, 214, 219, 225, 231, 236, 242, 248, 254, 260, 267, 273, 279, 286, 292, 299, 306, 313,
			    320, 327, 334, 341, 348, 356, 363, 371, 379, 386, 394, 402, 410, 419, 427, 435, 444, 452, 461, 470,
			    479, 488, 497, 506, 516, 525, 535, 544, 554, 564, 574, 584, 594, 605, 615, 626, 636, 647, 658, 669,
			    680, 691, 703, 714, 726, 738, 749, 761, 773, 786, 798, 810, 823, 836, 848, 861, 874, 888, 901, 914,
			    928, 941, 955, 969, 983, 997,1012,1026,1040,1055,1070,1085,1100,1115,1130,1146,1161,1177,1193,1209,
			   1225,1241,1257,1274,1290,1307,1324,1341,1358,1375,1392,1410,1427,1445,1463,1481,1499,1517,1536,1554,
			   1573,1592,1610,1629,1649,1668,1687,1707,1726,1746,1766,1786,1806,1826,1847,1867,1888,1909,1930,1951,
			   1972,1993,2015,2036,2058,2079,2101,2123,2145,2168,2190,2212,2235,2258,2281,2304,2327,2350,2373,2396,
			   2420,2444,2467,2491,2515,2539,2563,2587,2612,2636,2661,2686,2710,2735,2760,2785,2810,2836,2861,2887,
			   2912,2938,2964,2989,3015,3041,3067,3094,3120,3146,3173,3199,3226,3253,3279,3306,3333,3360,3387,3415,
			   3442,3469,3496,3524,3551,3579,3607,3634,3662,3690,3718,3746,3774,3802,3830,3858,3886,3914,3943,3971,
			   3999,4028,4056,4085,4113,4142,4170,4199,4228,4256,4285,4314,4343,4372,4400,4429,4458,4487,4516,4545,
			   4574,4603,4631,4660,4689,4718,4747,4776,4805,4834,4863,4892,4921,4950,4979,5007,5036,5065,5094,5123,
			   5151,5180,5209,5237,5266,5295,5323,5352,5380,5409,5437,5465,5494,5522,5550,5578,5606,5634,5662,5690,
			   5718,5746,5774,5801,5829,5856,5884,5911,5939,5966,5993,6020,6047,6074,6100,6127,6154,6180,6207,6233,
			   6259,6285,6311,6337,6363,6388,6414,6439,6465,6490,6515,6540,6565,6589,6614,6638,6663,6687,6711,6735,
			   6759,6782,6806,6829,6852,6875,6898,6921,6943,6966,6988,7010,7032,7054,7076,7097,7118,7140,7161,7181,
			   7202,7222,7243,7263,7283,7302,7322,7341,7361,7380,7398,7417,7436,7454,7472,7490,7507,7525,7542,7559,
			   7576,7593,7609,7625,7641,7657,7673,7688,7703,7718,7733,7748,7762,7776,7790,7804,7817,7830,7844,7856,
			   7869,7881,7893,7905,7917,7928,7939,7950,7961,7972,7982,7992,8002,8011,8020,8030,8038,8047,8055,8063,
			   8071,8079,8086,8093,8100,8107,8113,8119,8125,8131,8136,8142,8146,8151,8156,8160,8164,8167,8171,8174,
			   8177,8179,8182,8184,8186,8187,8189,8190,8191,8191,8192,8192,8192,8192,8191,8191,8190,8189,8187,8186,
			   8184,8182,8179,8177,8174,8171,8167,8164,8160,8156,8151,8146,8142,8136,8131,8125,8119,8113,8107,8100,
			   8093,8086,8079,8071,8063,8055,8047,8038,8030,8020,8011,8002,7992,7982,7972,7961,7950,7939,7928,7917,
			   7905,7893,7881,7869,7856,7844,7830,7817,7804,7790,7776,7762,7748,7733,7718,7703,7688,7673,7657,7641,
			   7625,7609,7593,7576,7559,7542,7525,7507,7490,7472,7454,7436,7417,7398,7380,7361,7341,7322,7302,7283,
			   7263,7243,7222,7202,7181,7161,7140,7118,7097,7076,7054,7032,7010,7988,6966,6943,6921,6898,6875,6852,
			   6829,6806,6782,6759,6735,6711,6687,6663,6638,6614,6589,6565,6540,6515,6490,6465,6439,6414,6388,6363,
			   6337,6311,6285,6259,6233,6207,6180,6154,6127,6100,6074,6047,6020,5993,5966,5939,5911,5884,5856,5829,
			   5801,5774,5746,5718,5690,5662,5634,5606,5578,5550,5522,5494,5465,5437,5409,5380,5352,5323,5295,5266,
			   5237,5209,5180,5151,5123,5094,5065,5036,5007,4979,4950,4921,4892,4863,4834,4805,4776,4747,4718,4689,
			   4660,4631,4603,4574,4545,4516,4487,4458,4429,4400,4372,4343,4314,4285,4256,4228,4199,4170,4142,4113,
			   4085,4056,4028,3999,3971,3943,3914,3886,3858,3830,3802,3774,3746,3718,3690,3662,3634,3607,3579,3551,
			   3524,3496,3469,3442,3415,3387,3360,3333,3306,3279,3253,3226,3199,3173,3146,3120,3094,3067,3041,3015,
			   2989,2964,2938,2912,2887,2861,2836,2810,2785,2760,2735,2710,2686,2661,2636,2612,2587,2563,2539,2515,
			   2491,2467,2444,2420,2396,2373,2350,2327,2304,2281,2258,2235,2212,2190,2168,2145,2123,2101,2079,2058,
			   2036,2015,1993,1972,1951,1930,1909,1888,1867,1847,1826,1806,1786,1766,1746,1726,1707,1687,1668,1649,
			   1629,1610,1592,1573,1554,1536,1517,1499,1481,1463,1445,1427,1410,1392,1375,1358,1341,1324,1307,1290,
			   1274,1257,1241,1225,1209,1193,1177,1161,1146,1130,1115,1100,1085,1070,1055,1040,1026,1012, 997, 983,
			    969, 955, 941, 928, 914, 901, 888, 874, 861, 848, 836, 823, 810, 798, 786, 773, 761, 749, 738, 726,
			    714, 703, 691, 680, 669, 658, 647, 636, 626, 615, 605, 594, 584, 574, 564, 554, 544, 535, 525, 516,
			    506, 497, 488, 479, 470, 461, 452, 444, 435, 427, 419, 410, 402, 394, 386, 379, 371, 363, 356, 348,
			    341, 334, 327, 320, 313, 306, 299, 292, 286, 279, 273, 267, 260, 254, 248, 242, 236, 231, 225, 219,
			    214, 208, 203, 198, 192, 187, 182, 177, 172, 168, 163, 158, 154, 149, 145, 140, 136, 132, 128, 124,
			    120, 116, 112, 108, 105, 101,  98,  94,  91,  87,  84,  81,  78,  75,  72,  69,  66,  63,  60,  58,
			     55,  53,  50,  48,  45,  43,  41,  39,  37,  35,  33,  31,  29,  27,  25,  24,  22,  20,  19,  17,
			     16,  15,  14,  12,  11,  10,   9,   8,   7,   6,   5,   5,   4,   3,   3,   2,   2,   1,   1,   1,
			      0,   0,   0,   0,	},

			  // 2->Poisson 3.0
			  { 410, 413, 415, 418, 420, 422, 425, 427, 430, 432, 435, 438, 440, 443, 445, 448, 451, 453, 456, 459,
			    461, 464, 467, 469, 472, 475, 478, 481, 483, 486, 489, 492, 495, 498, 501, 504, 507, 510, 513, 516,
			    519, 522, 525, 528, 531, 534, 537, 540, 543, 547, 550, 553, 556, 560, 563, 566, 570, 573, 576, 580,
			    583, 587, 590, 593, 597, 600, 604, 607, 611, 615, 618, 622, 626, 629, 633, 637, 640, 644, 648, 652,
			    656, 659, 663, 667, 671, 675, 679, 683, 687, 691, 695, 699, 703, 707, 712, 716, 720, 724, 729, 733,
			    737, 741, 746, 750, 755, 759, 763, 768, 772, 777, 782, 786, 791, 795, 800, 805, 810, 814, 819, 824,
			    829, 834, 839, 843, 848, 853, 858, 863, 869, 874, 879, 884, 889, 894, 900, 905, 910, 916, 921, 926,
			    932, 937, 943, 948, 954, 959, 965, 971, 976, 982, 988, 994,1000,1006,1011,1017,1023,1029,1035,1041,
			   1048,1054,1060,1066,1072,1079,1085,1091,1098,1104,1111,1117,1124,1131,1137,1144,1151,1157,1164,1171,
			   1178,1185,1192,1199,1206,1213,1220,1227,1234,1242,1249,1256,1264,1271,1279,1286,1294,1301,1309,1317,
			   1324,1332,1340,1348,1356,1364,1372,1380,1388,1396,1404,1412,1421,1429,1438,1446,1454,1463,1472,1480,
			   1489,1498,1507,1515,1524,1533,1542,1551,1560,1570,1579,1588,1597,1607,1616,1626,1635,1645,1655,1664,
			   1674,1684,1694,1704,1714,1724,1734,1744,1754,1765,1775,1786,1796,1807,1817,1828,1839,1849,1860,1871,
			   1882,1893,1904,1916,1927,1938,1950,1961,1973,1984,1996,2008,2019,2031,2043,2055,2067,2079,2092,2104,
			   2116,2129,2141,2154,2166,2179,2192,2205,2218,2231,2244,2257,2270,2284,2297,2311,2324,2338,2352,2365,
			   2379,2393,2407,2422,2436,2450,2464,2479,2494,2508,2523,2538,2553,2568,2583,2598,2613,2629,2644,2660,
			   2675,2691,2707,2723,2739,2755,2771,2787,2804,2820,2837,2853,2870,2887,2904,2921,2938,2955,2973,2990,
			   3008,3025,3043,3061,3079,3097,3115,3134,3152,3171,3189,3208,3227,3246,3265,3284,3303,3323,3342,3362,
			   3382,3402,3422,3442,3462,3482,3503,3523,3544,3565,3586,3607,3628,3649,3671,3692,3714,3736,3758,3780,
			   3802,3825,3847,3870,3892,3915,3938,3961,3985,4008,4032,4055,4079,4103,4127,4152,4176,4200,4225,4250,
			   4275,4300,4325,4351,4376,4402,4428,4454,4480,4506,4533,4560,4586,4613,4640,4668,4695,4723,4750,4778,
			   4806,4835,4863,4892,4920,4949,4978,5008,5037,5067,5096,5126,5157,5187,5217,5248,5279,5310,5341,5372,
			   5404,5436,5468,5500,5532,5565,5597,5630,5663,5697,5730,5764,5798,5832,5866,5900,5935,5970,6005,6040,
			   6076,6112,6148,6184,6220,6257,6293,6330,6367,6405,6443,6480,6518,6557,6595,6634,6673,6712,6752,6791,
			   6831,6871,6912,6952,6993,7034,7076,7117,7159,7201,7244,7286,7329,7372,7415,7459,7503,7547,7591,7636,
			   7681,7726,7771,7817,7863,7909,7955,8002,8049,8097,8144,8192,8192,8144,8097,8049,8002,7955,7909,7863,
			   7817,7771,7726,7681,7636,7591,7547,7503,7459,7415,7372,7329,7286,7244,7201,7159,7117,7076,7034,6993,
			   6952,6912,6871,6831,6791,6752,6712,6673,6634,6595,6557,6518,6480,6443,6405,6367,6330,6293,6257,6220,
			   6184,6148,6112,6076,6040,6005,5970,5935,5900,5866,5832,5798,5764,5730,5697,5663,5630,5597,5565,5532,
			   5500,5468,5436,5404,5372,5341,5310,5279,5248,5217,5187,5157,5126,5096,5067,5037,5008,4978,4949,4920,
			   4892,4863,4835,4806,4778,4750,4723,4695,4668,4640,4613,4586,4560,4533,4506,4480,4454,4428,4402,4376,
			   4351,4325,4300,4275,4250,4225,4200,4176,4152,4127,4103,4079,4055,4032,4008,3985,3961,3938,3915,3892,
			   3870,3847,3825,3802,3780,3758,3736,3714,3692,3671,3649,3628,3607,3586,3565,3544,3523,3503,3482,3462,
			   3442,3422,3402,3382,3362,3342,3323,3303,3284,3265,3246,3227,3208,3189,3171,3152,3134,3115,3097,3079,
			   3061,3043,3025,3008,2990,2973,2955,2938,2921,2904,2887,2870,2853,2837,2820,2804,2787,2771,2755,2739,
			   2723,2707,2691,2675,2660,2644,2629,2613,2598,2583,2568,2553,2538,2523,2508,2494,2479,2464,2450,2436,
			   2422,2407,2393,2379,2365,2352,2338,2324,2311,2297,2284,2270,2257,2244,2231,2218,2205,2192,2179,2166,
			   2154,2141,2129,2116,2104,2092,2079,2067,2055,2043,2031,2019,2008,1996,1984,1973,1961,1950,1938,1927,
			   1916,1904,1893,1882,1871,1860,1849,1839,1828,1817,1807,1796,1786,1775,1765,1754,1744,1734,1724,1714,
			   1704,1694,1684,1674,1664,1655,1645,1635,1626,1616,1607,1597,1588,1579,1570,1560,1551,1542,1533,1524,
			   1515,1507,1498,1489,1480,1472,1463,1454,1446,1438,1429,1421,1412,1404,1396,1388,1380,1372,1364,1356,
			   1348,1340,1332,1324,1317,1309,1301,1294,1286,1279,1271,1264,1256,1249,1242,1234,1227,1220,1213,1206,
			   1199,1192,1185,1178,1171,1164,1157,1151,1144,1137,1131,1124,1117,1111,1104,1098,1091,1085,1079,1072,
			   1066,1060,1054,1048,1041,1035,1029,1023,1017,1011,1006,1000, 994, 988, 982, 976, 971, 965, 959, 954,
			    948, 943, 937, 932, 926, 921, 916, 910, 905, 900, 894, 889, 884, 879, 874, 869, 863, 858, 853, 848,
			    843, 839, 834, 829, 824, 819, 814, 810, 805, 800, 795, 791, 786, 782, 777, 772, 768, 763, 759, 755,
			    750, 746, 741, 737, 733, 729, 724, 720, 716, 712, 707, 703, 699, 695, 691, 687, 683, 679, 675, 671,
			    667, 663, 659, 656, 652, 648, 644, 640, 637, 633, 629, 626, 622, 618, 615, 611, 607, 604, 600, 597,
			    593, 590, 587, 583, 580, 576, 573, 570, 566, 563, 560, 556, 553, 550, 547, 543, 540, 537, 534, 531,
			    528, 525, 522, 519, 516, 513, 510, 507, 504, 501, 498, 495, 492, 489, 486, 483, 481, 478, 475, 472,
			    469, 467, 464, 461, 459, 456, 453, 451, 448, 445, 443, 440, 438, 435, 432, 430, 427, 425, 422, 420,
			    418, 415, 413, 410,	},

			  // 3->Kaiser-Bessel 3.0
			  {   5,   6,   6,   7,   7,   8,   9,   9,  10,  10,  11,  12,  12,  13,  14,  15,  15,  16,  17,  18,
			     19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  30,  31,  32,  33,  35,  36,  38,  39,  41,  42,
			     44,  45,  47,  49,  50,  52,  54,  56,  58,  60,  62,  64,  66,  68,  70,  73,  75,  77,  80,  82,
			     85,  87,  90,  93,  95,  98, 101, 104, 107, 110, 113, 116, 120, 123, 126, 130, 133, 137, 140, 144,
			    148, 152, 155, 159, 164, 168, 172, 176, 180, 185, 189, 194, 199, 203, 208, 213, 218, 223, 228, 233,
			    239, 244, 250, 255, 261, 267, 273, 278, 285, 291, 297, 303, 310, 316, 323, 329, 336, 343, 350, 357,
			    364, 372, 379, 387, 394, 402,410,  418, 426,434,  442, 450, 459, 468,476,  485, 494, 503, 512, 521,
			    531, 540, 550, 560, 570, 580, 590, 600, 610, 621, 631, 642, 653, 664, 675, 686, 697, 709, 720, 732,
			    744, 756, 768, 780, 793, 805, 818, 831, 844, 857, 870, 883, 897, 910, 924, 938, 952, 966, 980, 994,
			   1009,1024,1038,1053,1068,1084,1099,1114,1130,1146,1162,1178,1194,1210,1227,1244,1260,1277,1294,1311,
			   1329,1346,1364,1382,1400,1418,1436,1454,1473,1491,1510,1529,1548,1567,1586,1606,1625,1645,1665,1685,
			   1705,1726,1746,1767,1787,1808,1829,1850,1872,1893,1915,1936,1958,1980,2002,2024,2047,2069,2092,2115,
			   2137,2160,2184,2207,2230,2254,2277,2301,2325,2349,2373,2398,2422,2447,2471,2496,2521,2546,2571,2596,
			   2622,2647,2673,2699,2724,2750,2776,2803,2829,2855,2882,2908,2935,2962,2989,3016,3043,3070,3097,3125,
			   3152,3180,3208,3235,3263,3291,3319,3347,3375,3404,3432,3460,3489,3518,3546,3575,3604,3633,3662,3691,
			   3720,3749,3778,3807,3837,3866,3895,3925,3954,3984,4014,4043,4073,4103,4133,4162,4192,4222,4252,4282,
			   4312,4342,4372,4402,4432,4463,4493,4523,4553,4583,4614,4644,4674,4704,4734,4765,4795,4825,4855,4886,
			   4916,4946,4976,5006,5037,5067,5097,5127,5157,5187,5217,5247,5277,5307,5337,5366,5396,5426,5455,5485,
			   5515,5544,5574,5603,5632,5662,5691,5720,5749,5778,5807,5836,5864,5893,5922,5950,5979,6007,6035,6063,
			   6091,6119,6147,6175,6203,6230,6258,6285,6312,6339,6366,6393,6420,6446,6473,6499,6525,6551,6577,6603,
			   6629,6654,6680,6705,6730,6755,6780,6804,6829,6853,6877,6901,6925,6948,6972,6995,7018,7041,7064,7087,
			   7109,7131,7153,7175,7197,7218,7240,7261,7282,7302,7323,7343,7363,7383,7403,7422,7442,7461,7479,7498,
			   7516,7535,7553,7570,7588,7605,7622,7639,7656,7672,7688,7704,7720,7735,7751,7766,7780,7795,7809,7823,
			   7837,7850,7864,7877,7890,7902,7914,7926,7938,7950,7961,7972,7983,7993,8003,8013,8023,8032,8042,8051,
			   8059,8068,8076,8084,8091,8098,8105,8112,8119,8125,8131,8136,8142,8147,8152,8156,8161,8165,8169,8172,
			   8175,8178,8181,8183,8185,8187,8189,8190,8191,8191,8192,8192,8192,8192,8191,8191,8190,8189,8187,8185,
			   8183,8181,8178,8175,8172,8169,8165,8161,8156,8152,8147,8142,8136,8131,8125,8119,8112,8105,8098,8091,
			   8084,8076,8068,8059,8051,8042,8032,8023,8013,8003,7993,7983,7972,7961,7950,7938,7926,7914,7902,7890,
			   7877,7864,7850,7837,7823,7809,7795,7780,7766,7751,7735,7720,7704,7688,7672,7656,7639,7622,7605,7588,
			   7570,7553,7535,7516,7498,7479,7461,7442,7422,7403,7383,7363,7343,7323,7302,7282,7261,7240,7218,7197,
			   7175,7153,7131,7109,7087,7064,7041,7018,6995,6972,6948,6925,6901,6877,6853,6829,6804,6780,6755,6730,
			   6705,6680,6654,6629,6603,6577,6551,6525,6499,6473,6446,6420,6393,6366,6339,6312,6285,6258,6230,6203,
			   6175,6147,6119,6091,6063,6035,6007,5979,5950,5922,5893,5864,5836,5807,5778,5749,5720,5691,5662,5632,
			   5603,5574,5544,5515,5485,5455,5426,5396,5366,5337,5307,5277,5247,5217,5187,5157,5127,5097,5067,5037,
			   5006,4976,4946,4916,4886,4855,4825,4795,4765,4734,4704,4674,4644,4614,4583,4553,4523,4493,4463,4432,
			   4402,4372,4342,4312,4282,4252,4222,4192,4162,4133,4103,4073,4043,4014,3984,3954,3925,3895,3866,3837,
			   3807,3778,3749,3720,3691,3662,3633,3604,3575,3546,3518,3489,3460,3432,3404,3375,3347,3319,3291,3263,
			   3235,3208,3180,3152,3125,3097,3070,3043,3016,2989,2962,2935,2908,2882,2855,2829,2803,2776,2750,2724,
			   2699,2673,2647,2622,2596,2571,2546,2521,2496,2471,2447,2422,2398,2373,2349,2325,2301,2277,2254,2230,
			   2207,2184,2160,2137,2115,2092,2069,2047,2024,2002,1980,1958,1936,1915,1893,1872,1850,1829,1808,1787,
			   1767,1746,1726,1705,1685,1665,1645,1625,1606,1586,1567,1548,1529,1510,1491,1473,1454,1436,1418,1400,
			   1382,1364,1346,1329,1311,1294,1277,1260,1244,1227,1210,1194,1178,1162,1146,1130,1114,1099,1084,1068,
			   1053,1038,1024,1009, 994, 980, 966, 952, 938, 924, 910, 897, 883, 870, 857, 844, 831, 818, 805, 793,
			    780, 768, 756, 744, 732, 720, 709, 697, 686, 675, 664, 653, 642, 631, 621, 610, 600, 590, 580, 570,
			    560, 550, 540, 531, 521, 512, 503, 494, 485, 476, 468, 459, 450, 442, 434, 426, 418, 410, 402, 394,
			    387, 379, 372, 364, 357, 350, 343, 336, 329, 323, 316, 310, 303, 297, 291, 285, 278, 273, 267, 261,
			    255, 250, 244, 239, 233, 228, 223, 218, 213, 208, 203, 199, 194, 189, 185, 180, 176, 172, 168, 164,
			    159, 155, 152, 148, 144, 140, 137, 133, 130, 126, 123, 120, 116, 113, 110, 107, 104, 101,  98,  95,
			     93,  90,  87,  85,  82,  80,  77,  75,  73,  70,  68,  66,  64,  62,  60,  58,  56,  54,  52,  50,
			     49,  47,  45,  44,  42,  41,  39,  38,  36,  35,  33,  32,  31,  30,  28,  27,  26,  25,  24,  23,
			     22,  21,  20,  19,  18,  17,  16,  15,  15,  14,  13,  12,  12,  11,  10,  10,   9,   9,   8,   7,
			      7,   6,   6,   5,  },

			  // 4->Gauss 3.0
			  {  93,  94,  96,  98,  99, 101, 103, 105, 106, 108, 110, 112, 114, 116, 118, 120, 122, 124, 126, 128,
			    131, 133, 135, 137, 140, 142, 144, 147, 149, 152, 154, 157, 160, 162, 165, 168, 170, 173, 176, 179,
			    182, 185, 188, 191, 194, 197, 200, 203, 207, 210, 213, 217, 220, 224, 227, 231, 234, 238, 242, 246,
			    249, 253, 257, 261, 265, 269, 274, 278, 282, 286, 291, 295, 300, 304, 309, 313, 318, 323, 328, 333,
			    338, 343, 348, 353, 358, 363, 369, 374, 380, 385, 391, 397, 402, 408, 414, 420, 426, 432, 438, 445,
			    451, 457, 464, 470, 477, 484, 490, 497, 504, 511, 518, 525, 533, 540, 548, 555, 563, 570, 578, 586,
			    594, 602, 610, 618, 626, 635, 643, 652, 660, 669, 678, 687, 696, 705, 714, 723, 733, 742, 752, 762,
			    771, 781, 791, 801, 811, 822, 832, 843, 853, 864, 875, 886, 897, 908,919,  930, 942, 953, 965, 976,
			    988,1000,1012,1025,1037,1049,1062,1074,1087,1100,1113,1126,1139,1153,1166,1180,1193,1207,1221,1235,
			   1249,1263,1278,1292,1307,1322,1336,1351,1366,1382,1397,1412,1428,1444,1460,1476,1492,1508,1524,1541,
			   1557,1574,1591,1608,1625,1642,1659,1677,1694,1712,1730,1748,1766,1784,1802,1821,1839,1858,1877,1896,
			   1915,1934,1953,1973,1992,2012,2032,2052,2072,2092,2112,2133,2153,2174,2195,2216,2237,2258,2279,2301,
			   2322,2344,2366,2387,2409,2432,2454,2476,2499,2521,2544,2567,2590,2613,2636,2660,2683,2707,2730,2754,
			   2778,2802,2826,2850,2874,2899,2923,2948,2973,2998,3023,3048,3073,3098,3123,3149,3175,3200,3226,3252,
			   3278,3304,3330,3356,3382,3409,3435,3462,3489,3515,3542,3569,3596,3623,3650,3678,3705,3732,3760,3787,
			   3815,3843,3870,3898,3926,3954,3982,4010,4038,4066,4094,4123,4151,4179,4208,4236,4265,4293,4322,4351,
			   4379,4408,4437,4466,4495,4523,4552,4581,4610,4639,4668,4697,4726,4755,4784,4813,4843,4872,4901,4930,
			   4959,4988,5017,5046,5075,5105,5134,5163,5192,5221,5250,5279,5308,5337,5366,5395,5424,5452,5481,5510,
			   5539,5567,5596,5625,5653,5682,5710,5739,5767,5795,5823,5852,5880,5908,5936,5963,5991,6019,6047,6074,
			   6102,6129,6156,6184,6211,6238,6265,6292,6318,6345,6371,6398,6424,6450,6476,6502,6528,6554,6580,6605,
			   6630,6656,6681,6706,6730,6755,6779,6804,6828,6852,6876,6900,6923,6947,6970,6993,7016,7039,7062,7084,
			   7106,7129,7151,7172,7194,7215,7236,7257,7278,7299,7319,7340,7360,7380,7399,7419,7438,7457,7476,7494,
			   7513,7531,7549,7567,7584,7602,7619,7636,7652,7669,7685,7701,7717,7732,7748,7763,7777,7792,7806,7820,
			   7834,7848,7861,7874,7887,7900,7912,7924,7936,7948,7959,7970,7981,7991,8002,8012,8022,8031,8040,8049,
			   8058,8066,8075,8082,8090,8097,8105,8111,8118,8124,8130,8136,8141,8147,8151,8156,8160,8164,8168,8172,
			   8175,8178,8181,8183,8185,8187,8188,8190,8191,8191,8192,8192,8192,8192,8191,8191,8190,8188,8187,8185,
			   8183,8181,8178,8175,8172,8168,8164,8160,8156,8151,8147,8141,8136,8130,8124,8118,8111,8105,8097,8090,
			   8082,8075,8066,8058,8049,8040,8031,8022,8012,8002,7991,7981,7970,7959,7948,7936,7924,7912,7900,7887,
			   7874,7861,7848,7834,7820,7806,7792,7777,7763,7748,7732,7717,7701,7685,7669,7652,7636,7619,7602,7584,
			   7567,7549,7531,7513,7494,7476,7457,7438,7419,7399,7380,7360,7340,7319,7299,7278,7257,7236,7215,7194,
			   7172,7151,7129,7106,7084,7062,7039,7016,6993,6970,6947,6923,6900,6876,6852,6828,6804,6779,6755,6730,
			   6706,6681,6656,6630,6605,6580,6554,6528,6502,6476,6450,6424,6398,6371,6345,6318,6292,6265,6238,6211,
			   6184,6156,6129,6102,6074,6047,6019,5991,5963,5936,5908,5880,5852,5823,5795,5767,5739,5710,5682,5653,
			   5625,5596,5567,5539,5510,5481,5452,5424,5395,5366,5337,5308,5279,5250,5221,5192,5163,5134,5105,5075,
			   5046,5017,4988,4959,4930,4901,4872,4843,4813,4784,4755,4726,4697,4668,4639,4610,4581,4552,4523,4495,
			   4466,4437,4408,4379,4351,4322,4293,4265,4236,4208,4179,4151,4123,4094,4066,4038,4010,3982,3954,3926,
			   3898,3870,3843,3815,3787,3760,3732,3705,3678,3650,3623,3596,3569,3542,3515,3489,3462,3435,3409,3382,
			   3356,3330,3304,3278,3252,3226,3200,3175,3149,3123,3098,3073,3048,3023,2998,2973,2948,2923,2899,2874,
			   2850,2826,2802,2778,2754,2730,2707,2683,2660,2636,2613,2590,2567,2544,2521,2499,2476,2454,2432,2409,
			   2387,2366,2344,2322,2301,2279,2258,2237,2216,2195,2174,2153,2133,2112,2092,2072,2052,2032,2012,1992,
			   1973,1953,1934,1915,1896,1877,1858,1839,1821,1802,1784,1766,1748,1730,1712,1694,1677,1659,1642,1625,
			   1608,1591,1574,1557,1541,1524,1508,1492,1476,1460,1444,1428,1412,1397,1382,1366,1351,1336,1322,1307,
			   1292,1278,1263,1249,1235,1221,1207,1193,1180,1166,1153,1139,1126,1113,1100,1087,1074,1062,1049,1037,
			   1025,1012,1000, 988, 976, 965, 953, 942, 930, 919, 908, 897, 886, 875, 864, 853, 843, 832, 822, 811,
			    801, 791, 781, 771, 762, 752,742,  733, 723, 714, 705, 696, 687, 678, 669, 660, 652, 643, 635, 626,
			    618, 610, 602, 594, 586, 578, 570, 563, 555, 548, 540, 533, 525, 518, 511, 504, 497, 490, 484, 477,
			    470, 464, 457, 451, 445, 438, 432, 426, 420, 414, 408, 402, 397, 391, 385, 380, 374, 369, 363, 358,
			    353, 348, 343, 338, 333, 328, 323, 318, 313, 309, 304, 300, 295, 291, 286, 282, 278, 274, 269, 265,
			    261, 257, 253, 249, 246, 242, 238, 234, 231, 227, 224, 220, 217, 213, 210, 207, 203, 200, 197, 194,
			    191, 188, 185, 182, 179, 176, 173, 170, 168, 165, 162, 160, 157, 154, 152, 149, 147, 144, 142, 140,
			    137, 135, 133, 131, 128, 126, 124, 122, 120, 118, 116, 114, 112, 110, 108, 106, 105, 103, 101,  99,
			     98,  96,  94,  93,  },

			// 5->FlatTop
			{   33,   33,   33,   32,   32,   32,   31,   31,   30,   30,   29,   28,   27,   26,   25,   24,   23,   21,   20,   19,
			    17,   15,   14,   12,   10,    8,    6,    3,    1,   -1,   -4,   -6,   -9,  -12,  -15,  -18,  -21,  -24,  -27,  -31,
			   -34,  -38,  -42,  -46,  -50,  -54,  -58,  -63,  -67,  -72,  -77,  -82,  -87,  -92,  -97, -103, -109, -114, -120, -127,
			  -133, -139, -146, -152, -159, -166, -174, -181, -189, -196, -204, -212, -221, -229, -238, -246, -255, -265, -274, -283,
			  -293, -303, -313, -324, -334, -345, -356, -367, -378, -390, -402, -414, -426, -438, -451, -463, -476, -490, -503, -517,
			  -531, -545, -559, -573, -588, -603, -618, -634, -649, -665, -681, -697, -714, -730, -747, -764, -782, -799, -817, -835,
			  -853, -871, -890, -908, -927, -946, -966, -985,-1005,-1025,-1045,-1065,-1085,-1106,-1127,-1147,-1168,-1190,-1211,-1232,
			 -1254,-1276,-1298,-1320,-1342,-1364,-1387,-1409,-1432,-1454,-1477,-1500,-1523,-1546,-1569,-1592,-1615,-1638,-1661,-1684,
			 -1708,-1731,-1754,-1777,-1800,-1823,-1847,-1870,-1893,-1915,-1938,-1961,-1984,-2006,-2029,-2051,-2073,-2095,-2117,-2138,
			 -2160,-2181,-2202,-2223,-2244,-2264,-2284,-2304,-2323,-2342,-2361,-2380,-2398,-2416,-2433,-2450,-2467,-2483,-2499,-2514,
			 -2529,-2543,-2557,-2570,-2583,-2596,-2607,-2618,-2629,-2639,-2648,-2657,-2665,-2672,-2679,-2685,-2690,-2695,-2699,-2702,
			 -2704,-2705,-2706,-2705,-2704,-2702,-2699,-2695,-2690,-2685,-2678,-2670,-2662,-2652,-2641,-2629,-2616,-2602,-2587,-2571,
			 -2553,-2535,-2515,-2494,-2472,-2448,-2424,-2398,-2370,-2342,-2312,-2281,-2248,-2214,-2179,-2142,-2104,-2064,-2023,-1981,
			 -1937,-1891,-1844,-1795,-1745,-1693,-1640,-1585,-1529,-1471,-1411,-1350,-1286,-1222,-1155,-1087,-1017, -946, -872, -797,
			  -721, -642, -562, -479, -395, -310, -222, -133,  -41,   52,  147,  243,  342,  443,  545,  650,  756,  864,  974, 1086,
			  1200, 1316, 1433, 1553, 1674, 1798, 1923, 2051, 2180, 2311, 2444, 2579, 2716, 2855, 2996, 3139, 3283, 3430, 3579, 3729,
			  3881, 4035, 4191, 4349, 4509, 4671, 4835, 5000, 5167, 5336, 5507, 5680, 5854, 6031, 6209, 6389, 6570, 6754, 6939, 7125,
			  7314, 7504, 7696, 7889, 8084, 8281, 8479, 8679, 8880, 9083, 9287, 9493, 9700, 9909,10119,10331,10544,10758,10974,11191,
			 11409,11628,11849,12071,12294,12518,12743,12970,13197,13425,13655,13885,14116,14349,14582,14815,15050,15285,15522,15759,
			 15996,16234,16473,16712,16952,17192,17433,17674,17916,18158,18400,18642,18885,19128,19371,19614,19857,20100,20344,20587,
			 20830,21073,21315,21558,21800,22042,22284,22525,22766,23006,23246,23485,23724,23962,24200,24436,24672,24908,25142,25375,
			 25608,25839,26070,26299,26528,26755,26981,27206,27429,27651,27872,28092,28310,28526,28741,28955,29167,29377,29586,29793,
			 29998,30201,30403,30602,30800,30996,31189,31381,31571,31758,31943,32127,32308,32486,32663,32837,33009,33178,33345,33509,
			 33671,33831,33988,34142,34294,34443,34589,34732,34873,35011,35147,35279,35409,35535,35659,35780,35898,36013,36125,36234,
			 36339,36442,36542,36638,36732,36822,36909,36993,37073,37151,37225,37296,37363,37428,37489,37546,37601,37652,37699,37744,
			 37785,37822,37856,37887,37915,37939,37959,37976,37990,38000,38007,38010,38010,38007,38000,37990,37976,37959,37939,37915,
			 37887,37856,37822,37785,37744,37699,37652,37601,37546,37489,37428,37363,37296,37225,37151,37073,36993,36909,36822,36732,
			 36638,36542,36442,36339,36234,36125,36013,35898,35780,35659,35535,35409,35279,35147,35011,34873,34732,34589,34443,34294,
			 34142,33988,33831,33671,33509,33345,33178,33009,32837,32663,32486,32308,32127,31943,31758,31571,31381,31189,30996,30800,
			 30602,30403,30201,29998,29793,29586,29377,29167,28955,28741,28526,28310,28092,27872,27651,27429,27206,26981,26755,26528,
			 26299,26070,25839,25608,25375,25142,24908,24672,24436,24200,23962,23724,23485,23246,23006,22766,22525,22284,22042,21800,
			 21558,21315,21073,20830,20587,20344,20100,19857,19614,19371,19128,18885,18642,18400,18158,17916,17674,17433,17192,16952,
			 16712,16473,16234,15996,15759,15522,15285,15050,14815,14582,14349,14116,13885,13655,13425,13197,12970,12743,12518,12294,
			 12071,11849,11628,11409,11191,10974,10758,10544,10331,10119, 9909, 9700, 9493, 9287, 9083, 8880, 8679, 8479, 8281, 8084,
			  7889, 7696, 7504, 7314, 7125, 6939, 6754, 6570, 6389, 6209, 6031, 5854, 5680, 5507, 5336, 5167, 5000, 4835, 4671, 4509,
			  4349, 4191, 4035, 3881, 3729, 3579, 3430, 3283, 3139, 2996, 2855, 2716, 2579, 2444, 2311, 2180, 2051, 1923, 1798, 1674,
			  1553, 1433, 1316, 1200, 1086,  974,  864,  756,  650,  545,  443,  342,  243,  147,   52,  -41, -133, -222, -310, -395,
			  -479, -562, -642, -721, -797, -872, -946,-1017,-1087,-1155,-1222,-1286,-1350,-1411,-1471,-1529,-1585,-1640,-1693,-1745,
			 -1795,-1844,-1891,-1937,-1981,-2023,-2064,-2104,-2142,-2179,-2214,-2248,-2281,-2312,-2342,-2370,-2398,-2424,-2448,-2472,
			 -2494,-2515,-2535,-2553,-2571,-2587,-2602,-2616,-2629,-2641,-2652,-2662,-2670,-2678,-2685,-2690,-2695,-2699,-2702,-2704,
			 -2705,-2706,-2705,-2704,-2702,-2699,-2695,-2690,-2685,-2679,-2672,-2665,-2657,-2648,-2639,-2629,-2618,-2607,-2596,-2583,
			 -2570,-2557,-2543,-2529,-2514,-2499,-2483,-2467,-2450,-2433,-2416,-2398,-2380,-2361,-2342,-2323,-2304,-2284,-2264,-2244,
			 -2223,-2202,-2181,-2160,-2138,-2117,-2095,-2073,-2051,-2029,-2006,-1984,-1961,-1938,-1915,-1893,-1870,-1847,-1823,-1800,
			 -1777,-1754,-1731,-1708,-1684,-1661,-1638,-1615,-1592,-1569,-1546,-1523,-1500,-1477,-1454,-1432,-1409,-1387,-1364,-1342,
			 -1320,-1298,-1276,-1254,-1232,-1211,-1190,-1168,-1147,-1127,-1106,-1085,-1065,-1045,-1025,-1005, -985, -966, -946, -927,
			  -908, -890, -871, -853, -835, -817, -799, -782, -764, -747, -730, -714, -697, -681, -665, -649, -634, -618, -603, -588,
			  -573, -559, -545, -531, -517, -503, -490, -476, -463, -451, -438, -426, -414, -402, -390, -378, -367, -356, -345, -334,
			  -324, -313, -303, -293, -283, -274, -265, -255, -246, -238, -229, -221, -212, -204, -196, -189, -181, -174, -166, -159, 
			  -152, -146, -139, -133, -127, -120, -114, -109, -103,  -97,  -92,  -87,  -82,  -77,  -72,  -67,  -63,  -58,  -54,  -50,
			   -46,  -42,  -38,  -34,  -31,  -27,  -24,  -21,  -18,  -15,  -12,   -9,   -6,   -4,   -1,    1,    3,    6,    8,   10,
			    12,   14,   15,   17,   19,   20,   21,   23,   24,   25,   26,   27,   28,   29,   30,   30,   31,   31,   32,   32,
			    32,   33,   33,   33 } 
		};


//---------------------------------------------------------------------------------------------------------------------------------------

//BF del short LogicData[32];

//BF not used char USB_Connected = false;
char USB_Data_Trans;
char USB_SendAllData;
char USB_At_Startup = false;
char USB_OnlyTrigger;

char USB_Data_Requested = false;

char RS232_Data_Requested = false;
unsigned char RS232_ContData_ReqMask = 0;
char RS232_ScreenShot_Requested = false;

volatile char Run;
//volatile char Signal_Loaded = 0;

unsigned char SingleShot = 0;
//volatile char Single_Restart = 0;

volatile char ButtonChanged = 0;
//BF del volatile char RoteryChanged = 0;
//BF del volatile char RoteryReady = 0;
//volatile char UserIface_active = 0;	BF del - not used
//volatile char UserIface_active_2 = 0;

char SavePointer = 1;

short led_status;									// Stores the LED Port Bits;
char ScreenShotActive;									// is 1 when sending screen shot

char PopUpPosition;
char IsPopuped;										// When it is Popuped it is 1, else 0
char PopupTimeCounter;									// Counter for Popup Pulldown

char TriggerLevelChanged = 1;								// Was Triggerlevel changed
char TriggerModeChanged = 1;								// Was Triggermode changed
char TriggerWayChanged = 1;								// Was Triggerway changed
char TimebaseChanged = 1;								// Was Timebase changed
char TimeOffsetChanged = 1;								// Was Time_Offset changed
//BF del not used char SIGNALFaktorChanged = 1;								// Was SIGNALFaktor changed

char TriggerLevelActive = 0;								// Is triggerlevel line drawing active?
char TimeOffsetActive = 0;								// Is Time_Offset selected ?
char StatusBtnRemove = 0;								// remove button
char ZeroPopupChanged = 0;								// When 1 then is changed
char MenuPopupChanged = 0;								// When 1 then is changed
char MenuPopupActive = -1;								// Stores the actual Menupopup
char VoltageChangedCh1 = 1;								// Was Voltage changed
char VoltageChangedCh2 = 1;								// Was Voltage changed
char VoltageChangedCh3 = 1;								// Was Voltage changed
char VoltageChangedCh4 = 1;								// Was Voltage changed
char MenuPopupChanged2 = 0;								// Was MenuPopup changed
char MenuOnlyChanged = 0;								// When 1 then is changed 

//------------------------------ Menu -------------------------------------------

char MenuItemChanged[6] = {0, 0, 0, 0, 0, 0};
char MenuItemPushed[6] = {0, 0, 0, 0, 0, 0};						// When Menuitem is pushed drawed
//char MenuItemPushed_old[6] = {0, 0, 0, 0, 0, 0};					// When Menuitem is pushed drawed
//char MenuStatusChanged = 0;								// When switching on/off a menu holds menunr
char MenuAktive = 1;                                        				// When Menu was deaktive
char MenuAktive_old = 1;                                   				// When Menu was deaktive
char EdgeToggle = 0;                                        				// for switching between Holdoff and Probe
char PulseToggle = 1;                                       				// for switching between smaller/bigger pulse width
char MathToggle = 0;  //BF -> obsolete                                      				// for switching between Scale and Offset
char DelayPopupSelect = 0;								// selected delay popup menu 0 - 3
char AcquirePopupSelect = 2;								// selected popup menu in acquire menu;

char VS_ZeroLevelChanged = 0;								//BF -> change flag for Zero sign drawing
char VS_TrigLevelChanged = 0;								//BF -> change flag for Zero sign drawing

int MenuPopupX;
int MenuPopupY;
int MenuPopupSizeX;
int MenuPopupSizeY;

char MenuStored;
char MenuChanged;
int MenuTimeCounter;										// Counter for Menu Pulldown

char MenuItemCount;										// Store the count of the Menuitems
char MenuOldItemCount;										// Store the count of the old Menuitems


// New Menu Vars
char New_Menu     = -1;
char Active_Menu  = -1;
char Menu_Changed = -1;
char Menu_First_Draw = 1;

//--------------------------------------------------------------------------

volatile char NumberOfChannels = 4;

char Channels_Active;
char Channel_1_Active;										// Store the channel activity
char Channel_2_Active;										// Store the channel activity
char Channel_3_Active;										// Store the channel activity
char Channel_4_Active;										// Store the channel activity
char Channel_Math_Active;									// Store the math activity
/*BF del
char Channel_1_Active_Old;									// Store old channel activity for channel logic
char Channel_2_Active_Old;									// Store old channel activity for channel logic
char Channel_3_Active_Old;									// Store old channel activity for channel logic
char Channel_4_Active_Old;									// Store old channel activity for channel logic
char Channel_Math_Active_Old;									// Store old math activity for popup processing
*/
char Channel_1_Active_bak = 0;									//Backup channel status for restoring
char Channel_2_Active_bak = 0;									//Backup channel status for restoring
char Channel_3_Active_bak = 0;									//Backup channel status for restoring
char Channel_4_Active_bak = 0;									//Backup channel status for restoring
char Channel_Math_Active_bak = 0;								//Backup channel status for restoring


//char RealTimebase;										// ADC Timebase 
//char RealTimebase_Old;										// ADC Timebase
char VirtualTimebase;										// Virtual Timebase -> in Stop mode 
char MainTimebase;										// Timebase Index
char MainTimebase_Old;	     									
char XY_Mode = 0;     										// Selected Normal or XY-Mode
//  0 - Normal , 1 = XY-Mode

volatile int PreTrigComp;									// Pretrigger compensation

/** New Trigger Values**/
int Trig_Pos_Mem           = 300;                                     				// Store the Triggerposition in Memory
int Trig_Pos_Display       = 300;                                 				// Store the Triggerposition on Display
int Trig_Pos_Display_dmode = 300;                           					// Store the Triggerposition on Display in delayed mode
int MemWinStart           = -300;                    						// Memory Windows start offset

int Trig_Pos_Mem_old           = 300;                                     			// Store the Triggerposition in Memory
int Trig_Pos_Display_old       = 300;                                 				// Store the Triggerposition on Display
int Trig_Pos_Display_dmode_old = 300;                           				// Store the Triggerposition on Display in delayed mode
int MemWinStart_old           = -300;                                    			// Memory Windows start offset

// delayed fehlt noch


char TriggerWay;
char TriggerWay_bak;										// Stores the way to trigger
// 1 - Edge / 2 - Pulse / 3 - Pattern / 4 - More

char Selected_Trigger_Source;									// Stores the Channel who Trigger
char Selected_Trigger_Source_Old;								// Stores the Channel who Trigger Old
// 1 - 4 Channels / 5 - External / 6 - Line



volatile unsigned long noTriggerTime = 0; 						//needed for combi-trigger; measures time in ms, since last trigger
volatile unsigned char CombiTriggerStatus = 0;						//0=normal-Mode, 1=AutoMode-first-time, 2=AutoMode-FreeRun
volatile unsigned long timingcounter;

//char TiggerLevelLine;										// If 1 then Draw Trigger Level Line
int Trigger_Pos_CH1;										// Stores the Trigger Position on Channel 1
int Trigger_Pos_CH2;										// Stores the Trigger Position on Channel 2
int Trigger_Pos_CH3;										// Stores the Trigger Position on Channel 3
int Trigger_Pos_CH4;										// Stores the Trigger Position on Channel 4
int Trigger_Pos_CHE;										// Stores the Trigger Position on External

int Trigger_Pos_CH1_Old;									// Stores the old Trigger Position on Channel 1
int Trigger_Pos_CH2_Old;									// Stores the old Trigger Position on Channel 2
int Trigger_Pos_CH3_Old;									// Stores the old Trigger Position on Channel 3
int Trigger_Pos_CH4_Old;									// Stores the old Trigger Position on Channel 4
int Trigger_Pos_CHE_Old;									// Stores the old Trigger Position on External

// ZeroLine in virtual screen with hight 0 - 16383 pixels 8192 is middle
int Virtual_ZeroLevelCH1;
int Virtual_ZeroLevelCH2;
int Virtual_ZeroLevelCH3;
int Virtual_ZeroLevelCH4;

//BF -> 0 - 400 pixels, 200 is middle now!
int ZeroLevelCH1;
int ZeroLevelCH2;
int ZeroLevelCH3;
int ZeroLevelCH4;

int Virtual_ZeroLevelXYCH1;
int Virtual_ZeroLevelXYCH2;
int Virtual_ZeroLevelXYCH3;
int Virtual_ZeroLevelXYCH4;

int ZeroLevelCH1_Old;
int ZeroLevelCH2_Old;
int ZeroLevelCH3_Old;
int ZeroLevelCH4_Old;

volatile char Selected_Voltage_CH1;								// Selected Voltage_CH1
volatile char Selected_Voltage_CH1_Old;								// Selected Voltage_CH1
volatile char Selected_Voltage_CH2;								// Selected Voltage_CH2
volatile char Selected_Voltage_CH2_Old;								// Selected Voltage_CH2
volatile char Selected_Voltage_CH3;								// Selected Voltage_CH3
volatile char Selected_Voltage_CH3_Old;								// Selected Voltage_CH3
volatile char Selected_Voltage_CH4;								// Selected Voltage_CH4
volatile char Selected_Voltage_CH4_Old;								// Selected Voltage_CH4
volatile char Selected_TB;									// Selected TimeBase


char SelectedCursor;										// Which Cursor is selected
char SelectedCursorOld;										// Which Cursor was selected

char Cursor_Enabled;
char Cursor_Enabled_Old;
char CursorChanged;										// Was Cursor changed

char Cursor_XY_Selected;									// 0 = X selected, 1 = Y selected
char Cursor_XY_Selected_Old;									// 0 = X selected, 1 = Y selected

char Cursor_Both_Selected;
char Cursor_Both_Selected_Old;

char Cursor_Horizontal_Active; 									// 0 = Off
char Cursor_Horizontal_Active_Old;								// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected

												// 4 = Active and both selected

long Cursor_Horizontal_Position_Real1;								// Store Real Cursor Position
long Cursor_Horizontal_Position_Real2;								// Store Real Cursor Position

long Cursor_Horizontal_Position1_Old;								// Store old Cursor horizontal I position
long Cursor_Horizontal_Position2_Old;								// Store old Cursor horizontal II position

char Cursor_Vertical_Active;									// 0 = Off
char Cursor_Vertical_Active_Old;								// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
//long Cursor_Vertical_Position1;								// Store Cursor vertical I position
//long Cursor_Vertical_Position2;								// Store Cursor vertical II position
												// 4 = Active and both selected

//long Cursor_Vertical_Position_Real1;								// Store Real Cursor Position
//long Cursor_Vertical_Position_Real2;								// Store Real Cursor Position

//long Cursor_Vertical_Position1_Old;								// Store old Cursor vertical I position
//long Cursor_Vertical_Position2_Old;								// Store old Cursor vertical II position

long Cursor_Vertical_Position_TY_1;								// Store Cursor Position
long Cursor_Vertical_Position_TY_2;								// Store Cursor Position

long Cursor_Vertical_Position_XY_1;								// Store Cursor Position
long Cursor_Vertical_Position_XY_2;								// Store Cursor Position

long Cursor_Vertical_Position_FFT_1;								// Store Cursor Position
long Cursor_Vertical_Position_FFT_2;								// Store Cursor Position


long Cursor_Vertical_Position1_Old;								// Store old Cursor vertical I position
long Cursor_Vertical_Position2_Old;								// Store old Cursor vertical II position

char Cursor_Data_Draw_Pos = 0;									// Stores the draw position of the cursor data
char Cursor_Data_First_Draw = 0;								// Is it draw first time ?

char QM_Enabled;
char QM_Enabled_Old;
char QM_Changed[3];										// Was quick measurment changed
char QM_Type[3];                                   					        // What type of measurment (look 1313 -> 52 ...
char QM_Type_Old[3];                                      					// What type of measurment (look 1313 -> 52 ...
char QM_Channel[3];                                         					// What channel is measured
char QM_Second_Channel[3];									// Fore delay / phase measurment
char QM_CHI_Edge[3];                                        					// Fore delay  measurment // 1 = positiv , 2 = negativ
char QM_CHII_Edge[3];                                       					// Fore delay  measurment // 1 = positiv , 2 = negativ

char BufPre[30];
char BufUnit[10];
char BufReturn[30];

char QM_V_A_Buf[1];
char QM_H_A_Buf[1];
    
char QM_Horizontal_Active; 									// 0 = Off
char QM_Horizontal_Active_Old;							     		// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long QM_Horizontal_Position_Real1;								// Store Real Cursor Position
long QM_Horizontal_Position_Real2;								// Store Real Cursor Position

long QM_Horizontal_Position1_Old;								// Store old Cursor horizontal I position
long QM_Horizontal_Position2_Old;								// Store old Cursor horizontal II position

char QM_Vertical_Active;									// 0 = Off
char QM_Vertical_Active_Old;									// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long QM_Vertical_Position_Real1;								// Store Real Cursor Position
long QM_Vertical_Position_Real2;								// Store Real Cursor Position

long QM_Vertical_Position1_Old;									// Store old Cursor vertical I position
long QM_Vertical_Position2_Old;									// Store old Cursor vertical II position

char Quick_Measure_Data_Draw_Pos = 0;								// Stores the draw position of the cursor data
char Quick_Measure_First_Draw = 0;								// Is it draw first time ?

char Quick_Measure_Threshold_btn_select;

//Memory Browser depended
char Memory_Window_visible = false;
int mb_window_start_old = 0;
int mb_window_stop_old = 0;
int mb_window_trigger_old = 0;
int mb_window_cursor1_old = 0;
int mb_window_cursor2_old = 0;


//Create FloatStr objects
FloatStr Pulse11;
FloatStr Pulse21;
FloatStr Pulse12;
FloatStr Pulse22;

FloatStr Cursor_Delta_X;	
FloatStr Cursor_Delta_1X;
FloatStr Cursor_Delta_XY_X;
FloatStr Cursor_Delta_Y;

FloatStr FFT_Cursor_Delta_X;	
FloatStr FFT_Cursor_Delta_1X;
//FloatStr FFT_Cursor_Delta_XY_X;
FloatStr FFT_Cursor_Delta_Y;

FloatStr Cursor_Vertical_Pos_1_Str;
FloatStr Cursor_Vertical_Pos_2_Str;

FloatStr FFT_Cursor_Vertical_Pos_1_Str;
FloatStr FFT_Cursor_Vertical_Pos_2_Str;

FloatStr Cursor_Vertical_Pos_XY_1_Str;
FloatStr Cursor_Vertical_Pos_XY_2_Str;
/*
FloatStr FFT_Cursor_Vertical_Pos_XY_1_Str;
FloatStr FFT_Cursor_Vertical_Pos_XY_2_Str;
*/	
FloatStr Cursor_Horizontal_Pos_1_Str;
FloatStr Cursor_Horizontal_Pos_2_Str;

FloatStr FFT_Cursor_Horizontal_Pos_1_Str;
FloatStr FFT_Cursor_Horizontal_Pos_2_Str;


FloatStr QM_Slot1;
FloatStr QM_Slot2;
FloatStr QM_Slot3;

FloatStr QM_Threshold_lower;
FloatStr QM_Threshold_middle;
FloatStr QM_Threshold_upper;

//BF del FloatStr Math_Offset;

FloatStr Math_Offset_mul;
FloatStr Math_Offset_sub;
FloatStr Math_Offset_add;

// CursorData Buffer variables

/* BF not used
int dcd_channel_buf = -1;
int dcd_volt_buf = -1;
int dcd_zero_buf = -1;
int dcd_voltmfactor_buf = -1;

int dcd_hz1_buf = -1;
int dcd_hz2_buf = -1;
int dcd_vz1_buf = -1;
int dcd_vz2_buf = -1;
int dcd_time_buf = -1;
double dcd_tfactor_buf = -1;
double dcd_vfactor_buf = -1;
*/

//double voltoff1 = 0;	
//double voltoff2 = 0;

double timeoff1 = 0;	
double timeoff2 = 0;

FloatStr Zero_Level1_Str;
FloatStr Zero_Level2_Str;
FloatStr Zero_Level3_Str;
FloatStr Zero_Level4_Str;
// zerolevel buffer variables


int dzp_channel_buf = -1;
short dzp_fprobe_buf = -1;
char dzp_fselected_voltage_buf = -1;
double dzp_factor_buf = 0;


FloatStr Trigger_Level_Str;
FloatStr Trigger_ExtLevel_Str;

int ct_Selected_Trigger_Source_buf = -1;
int ct_volt_buf = -1;
int ct_voltmfactor_buf = -1;
double ct_vfactor_buf = -1;
double ct_vfactor2_buf = -1;

FloatStr Timebase_Offset_Str;  // unused
FloatStr Trigger_Offset_Str;
FloatStr HoldOff;

//********************************************************************************************************************************************************************************************************************************


						//***************************************************
						//                     Menu
						//***************************************************



//BF -> horizontal (X) drawing offset for button text (first line -> caption)
//  -> a Value greater than 0 displays the button in the menu
unsigned short MenuItemDef[32][6] ={{30,28,22, 7, 0, 0},	// 00 ACQUIRE : Logic /Average / Noise Filter / Interpolation
				    {11,21,30,26,25,20},	// 01 CHANNEL I   : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {11,21,30,26,25,20},	// 02 CHANNEL II  : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {11,21,30,26,25,20},	// 03 CHANNEL III : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {11,21,30,26,25,20},	// 04 CHANNEL IV  : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {27,32,36, 5, 5,30},	// 05 Display : Persist / Clear Display / Grid / No Display / Draw Mode / Setup Submenu
 				    {27,22,20, 5,30,30},	// 06 Utility : About Oszi / Default Setup / Calibrate Offsets / Calbration Set / Test Signal / More
				    {31,31,23,20, 0, 0},	// 07 Service : Start User Cal / Start Self Test / User Cal Status / RS-232 Setup
				    {30,33,29,25,32,22},	// 08 Save / Recall : Memory / Save / Recall Trace / Overlay /Clear Display /Restore settings
				    { 5, 5, 5, 0, 0,16},	// 09 n.a.
				    {36,23,37,37,23,25},	// 10 Timebase : Main / Delayed / X - Y / FFT / Browse / USTB-submenu
				    { 0, 0, 0, 0, 0, 0},	// 11 Delayed Timebase :
				    {22,13,26,26,26,30},	// 12 Trigger Mode : Mode / Coupling / Auto Level / Holdoff / External Probe	BF deactivated Reject #019
				    {20,20,10,10,12,40},	// 13 Trigger sub menu: LED1 / LED2 / Map to Ch3+4 / free
				    {26,11,15,19,26,26},	// 14 Trigger Edge : Rising / Falling / Trigger 1-4 / Extern/Line / TV CH1 / PreTrigger / Auto Level
				    {11,32,13,36,36,26},	// 15 Pulse Width : Source / Pulse / Dir / Lower / Bigger
				    {11,41,41,41,41,35},	// 16 Cursor X : Source, X1, X2, Y1, Y2, X1X2/Y1Y2
				    {25,25,25,25,30, 2},	// 17 Quick Print : BMP / PGM / CSV / ASCII / n.a / Destination 
				    { 2,10,20, 0, 0,40},	// 18 Hardware Settings #004 ADC-Register / Pre Amp Gain / free
				    {11,34,23,31,20,12},	// 19 Quick Measurment : Source, Select, Measure Delay, Clear Meas, Settings, Thresholds
				    {11,26,11,26,18,16},	// 20 QM Settings Delay : Source, Edge, Source, Edge, Measure Delay
				    {11, 0,11, 0,18,16},	// 21 QM Settings Phase : Source, Edge, Source, Edge, Measure Delay
				    {11,11,36,36,36,16},	// 22 QM Thresholds : Source , Type, Lower, Middle, Upper
				    {31,25,20, 7, 0, 0},	// 23 Autoscale : Undo / Search Slow / Save / Setup
				    {31,22,21,31,28, 0},	// 24 Trigger Mode TV : Mode, Pos / Neg , Standard, Mode, Count
				    {22,22,22,22,15,40},	// 25 Extended Utilities CH1...CH4 delay, Hardware Menu   BF #001 #004
				    {32,28,31,31,31, 0},	// 26 Math : Scale /   / 1 * 2 / 1 - 2 / 1 + 2
				    {16,16,25,20, 0,31},	// 27 FFT Settings : Source / Window / Mode / Length
				    {27,32,36,25, 0,30},	// 28 Display FFT 
				    {32, 0, 0, 0, 0,16},	// 29 Math Settings -> not used anymore
				    {15,15,15, 0, 0,16},	// 30 USTB
				    {25,25,25, 0, 0, 2}};	// 31 Quick Print USB-Export


// BF menu button text -> first line (caption)
unsigned char MenuItem[32][6][16] = {{{"Logic"},{"Average"},{"Noise Filter"},{"Interpolation"},{""},{""}},		//  0 ACQUIRE
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe ["},{"Center"},{"Dispatch"}},	//  1 CHANNEL 1
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe \\"},{"Center"},{"Dispatch"}},	//  2 CHANNEL 2
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe ]"},{"Center"},{"Dispatch"}},	//  3 CHANNEL 3
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe ^"},{"Center"},{"Dispatch"}},	//  4 CHANNEL 4
				     {{"Persist"},{"Clear"},{"Grid"},{"{No Display"},{"{Draw Mode"},{"Setup"}},	    	//  5 DISPLAY
				     {{"About"},{"Default"},{"Calibrate"},{"{Calibration"},{"Test"},{"More"}},		//  6 Utility 
				     {{"Start"},{"Start"},{"User Cal"},{"RS-232"},{""},{""}},				//  7 Service Menu n.a.
				     {{"Memory"},{"Save"},{"Recall"},{"Overlay"},{"Clear"},{"Restore"}},		//  8 Save / Recall
				     {{"{Grid Color"},{"{Grid Lines"},{"{  Status"},{""},{""},{""}},			//  9 Display Setup Submenu
				     {{"Main"},{"Delayed"},{"X - Y"},{"FFT"},{"Browse"},{"USTB"}},			// 10 Timebase 
				     {{""},{""},{""},{""},{""},{""}},							// 11 n.a.
				     {{"{   Mode"},{"{ Coupling"},{"Trigger"},{"Holdoff"},{"Probe `"},{"More"}},	// 12 Trigger Mode
				     {{"{ LED 1"},{"{ LED 2"},{"Ch 3/4 LED"},{"Single Trigg"},{"Pre Trigger"},{""}},	// 13 Trigger sub menu
				     {{"}         ~"},{"{ Source"},{"{ External"},{"{ TV  ["},{"Adjust"},{"PreTrig"}},	// 14 Edge 
//BF -> no negative Pulse	     {{"{ Source"},{Pos_Pulse, Space, Space, Space, Space, Space, Space, Space, Space, Space, Neg_Pulse},{Big_Smaller, Space, Space, Space, Space, Big_Bigger, Space, Space, Space, Space, Big_Bigger, Big_Smaller},{Big_Smaller},{Big_Bigger},{"@ t"}}, 		// 15 Pulse Width
				     {{"{ Source"},{Space, Space, Space, Space, Pos_Pulse, Space, Space, Space, Space, Space},{Big_Smaller, Space, Space, Space, Space, Big_Bigger, Space, Space, Space, Space, Big_Bigger, Big_Smaller},{Big_Smaller},{Big_Bigger},{"PreTrig"}},			// 15 Pulse Width
				     {{"{  Source"},{"X1"},{"X2"},{"Y1"},{"Y2"},{"X1   X2"}}, 				// 16 Cursor X
				     {{"Save to"},{"Save to"},{"Save to"},{"Save to"},{"Send"},{"{ Destination"}}, 	// 17 Quick Print 
				     {{"{ ADC Setup"},{"{ Pre Gain"},{"LED Test"},{""},{""},{""}}, 			// 18 Hardware #004
				     {{"{ Source"},{"Select:"},{"Measure"},{"Clear"},{"Setting"},{"Thresholds"}},	// 19 Quick Measurment
				     {{"{ Source1"},{"}        ~"},{"{ Source2"},{"}        ~"},{"Measure"},{""}},	// 20 Quick Measurment Delay Settings
				     {{"{ Source1"},{""},{"{ Source2"},{""},{"Measure"},{""}},		                // 21 Quick Measurment Phase Settings
				     {{"{ Source"},{"{ Type"},{"Lower"},{"Middle"},{"Upper"},{""}},			// 22 Quick Measurment Thresholds
				     {{"Undo"},{"Search"},{"Save new"},{"{ TB Search"},{""},{""}},		        // 23 Autoscale
				     {{"Mode"},{Pos_Pulse, Space, Space, Space, Space, Space, Space, Space, Space, Space, Neg_Pulse},{"Standard"},{"Mode"},{""},{""}},	// 24 Trigger Mode TV
				     {{"CH1 Delay"},{"CH2 Delay"},{"CH3 Delay"},{"CH4 Delay"},{"Hardware"},{""}},	// 25 Extended Utilities BF #001
				     {{"Scale"},{"Offset"},{"1  *  2"},{"1  -  2"},{"1  +  2"},{""}},  			// 26 Math	
				     {{"{ Source"},{"{ Window"},{"{ Mode"},{"{ Length"},{""},{""}},              	// 27 FFT Settings
				     {{"Persist"},{"Clear"},{"Grid"},{"Switch"},{"Display"},{"Setup"}},			// 28 Display FFT 
				     {{"Scale"},{"Offset"},{""},{""},{""},{""}},					// 29 Math Settings
				     {{"{  Mode"},{"{ Display"},{"{ Buffer"},{""},{""},{""}},				// 30 USTB
				     {{"Save to"},{"Save to"},{"Save to"},{""},{""},{"{ Destination"}}};		// 31 Quick Print USB-export

unsigned char MenuEdgeBufText[7] = 	{"{     "};


// [MenuData] //BF -> print offset in pixel for second line in menu button		
unsigned short MenuDataDef[350] = {36, 36, 21, 61,				//   0
				   41, 41, 					//   4
				   19, 36, 36, 					//   6
				   36, 36, 					//   9
				   36, 36, 					//  11
				   36, 36, 36, 36, 36, 				//  13
				   22, 16,  8, 					//  18
				   19, 19, 19,					//  21
				   19, 20, 23,					//  24
				   50, 46, 46, 46, 33,				//  27
				   23, 24, 26,					//  32
				   31, 20, 26,					//  35
				   21, 21, 28, 27,				//  38
				   27, 20, 15,					//  42
				   15, 35, 15, 15,				//  45
				   40, 15, 17,					//  49
				   16, 28, 10, 22,				//  52	//  4 Quick Measurement Select	
				   14, 18, 18,					//  56	//  4 Quick Measurement Select	
				   13, 30, 30,					//  59	//  4 Quick Measurement Select
				   20, 35, 25, 25,				//  62	//  4 Quick Measurement Select
				   15, 15, 25, 25,				//  66	// 31 FFT Mode
				   8,  5,  5,  5,				//  70  // 31 FFT Mode
				   46, 46, 46, 46, 43, 43, 43,			//  74
				   40, 40, 40, 36, 36,				//  81
				   30, 30, 30,					//  86
				   24, 24,					//  89
				   28, 						//  91
				   31, 26, 26,					//  92
				   40, 40, 20, 20,				//  95
				   22, 25,					//  99	// 23 Autoscale
				   31, 31, 31,					// 101
				   31, 31, 31,					// 104
				   31, 31, 31,					// 107
				   31, 31, 31, 31,				// 110
				   35, 20, 20, 20, 20,				// 114
				   35, 20, 15, 20, 20,				// 119
				   35,  5, 27, 35,				// 124
				   15, 15, 30, 15, 15,				// 128	//BF External Trigger + TV Trigger #019
				   41, 37, 36, 33, 				// 133
				   45, 41, 41, 41, 25, 35,			// 137	// Trigger Source BF #019
				   31, 25, 29, 29, 36,	              	  	// 143
				   36, 36, 36, 30, 30,	               	 	// 148	// BF Quick Print
				   33, 32, 32, 31, 30,	                	// 153	
				   30, 42, 41, 41, 39,	                	// 158	
				   38, 38, 36, 34, 33,	                	// 163	
				   33, 32, 31, 31, 25,	                	// 168	
				   24, 24, 40, 39, 39,	                	// 173	
				   35, 34, 34, 32, 21,	                	// 178	
				   25, 13, 40, 15, 0,	                	// 183	// BF #006
				   20, 25, 32, 20, 25,	                	// 188	// BF print offset for new entries in Utility menu (188, 189, 190, 191 )
				   21, 20, 21, 15, 15 ,				// 193 	// BF new items für the windows
				   21, 26, 0,  0,  0,				// 198  
				   30, 30, 30, 30, 30, 30, 30,			// 203 	//BF #001
				   30, 30, 30, 25, 25, 25, 25,			// 210 	//BF #001
				   25, 25, 25,  0,  0,	0, 			// 217 	//BF #001
				   25, 13, 13, 25, 25, 25, 25,			// 223 	//BF #002
				   25, 17, 20, 25,  5,  			// 230 	//BF #004
				    0,  0,  0,  0,  0, 				// 235 	//BF #004
				//---------------------------------------------------------------------------------------
				    0,  0,  0,  0,  0,  0,  0,  0,		// 240  reserved for special functions
				//---------------------------------------------------------------------------------------
				   //35, 22, 22, 10, 10, 10,  			// 248	// Noise Filter
				   30, 25,  0,  0,  0,  0,			// 248  - 253 Grid Layout

				   35, 25, 43, 43, 40,  0,  0,  0,  0,  0,	// 254	// Average
				   15,  7, 30, 30,				// 264	// Calibration Set
				   30, 36,  0,  0,				// 268	// UC Quick Print
				   15, 15, 10,  5, 10,  5,  0,  0,		// 272 	   Pre Trigger Setting
				    8,  8,  0,  0,				// 280	   Autoscale setup
				    7,  7, 10, 10,				// 284	   USTB Mode
				   13, 18,  0,  0,				// 288	   USTB Display
				   10, 15, 30,  0,				// 292	   Draw Mode
				   30, 25, 25,  0,				// 296	   USTB Buffer Size
				   25, 35, 28, 25, 35, 35, 20, 35, 23, 33, 0,	// 300  - 310 Grid Color
	
				   //30, 25,  0,  0,  0,  0,  0,  0,  0,	// 311  - 319 Grid Layout
				   35, 22, 22, 10, 10, 10, 10, 10, 10,  	// 311	- 319 Noise Filter	

				   40, 45, 45, 35, 45, 45, 35,  0,  0,  0,	// 320  - 329 Channel no display
				   15, 18, 10, 25, 15, 10, 10, 10, 10,  0,	// 330  - 339 Status / Menu layout
				   40, 20, 15, 10, 10, 10, 20,  0,  0,  0	// 340  - 349
			};






// Button text second line	   // [MenuStatusNr] [Länge]
char MenuData[350][16] =  {	"   ", {Menu_Select}, {Menu_Select}, {Menu_Select},
				"On", "Off", 								// 4
				"Ground", "AC", "DC", 							// 6
				"20MHz", "100MHz", 							// 9
				"2 x 2", "12 x 12", 							// 11
				"128KB", "32KB", "8KB", "1KB", "X - Y",					// 13
				"Started", "Quick Help", "Oscilloscope", 				// 18
				"Channel 1", "Channel 2", "Channel 3",					// 21
				"Channel 4", "Channels", "Hex",						// 24
				"1", "2", "3", "4", "Math", 						// 27
				"Left", "Center", "Right",						// 32
				"Delay", "Measure", "Display",						// 35
				"Trigger", " ", "Status", "Recall",					// 38
				"Linear", "sin(x)/x", "",						// 42	// Interpolation
				"Character", "Y1   Y2", "Autoscale", "Settings",			// 45
				"%", "Absolute", "",			        			// 49
				"Average", "Delay", "Duty Cycle", "Fall Time",				// 52	//  4 Quick Measurement Select
				"Frequency", "Maximum", "Minimum", 		    			// 56	//  4 Quick Measurement Select
				"Peak-Peak", "Period", "Phase",						// 59	//  4 Quick Measurement Select
				"Rise Time", "RMS", "+ Width", "- Width",         			// 62	//  4 Quick Measurement Select
				"Magnitude", "Phase", "Real", "Imaginary",        			// 66	// 31 FFT Mode
				 "Real+Imag", "Power Spec", "Power Dens", "",				// 70	// 31 FFT Mode
				"1", "2", "4", "8", "16", "32", "64",					// 74
				"128", "256", "512", "1024", "2048",					// 81
				"4096", "8192", "16384",						// 86
				"External", "Line", 							// 89
				"<None>", 								// 91
				"Auto", "Normal", "Combi",						// 92
				"DC", "AC", "LF Reject", "HF Reject",					// 95	// 12 Trigger Mode/Coupling
				"Slow TB", "Setting",							// 99	// 23 Autoscale
				"0.1 : 1", "0.2 : 1", "0.5 : 1",					// 101
				"1 : 1", "2 : 1", "5 : 1",			        		// 104
				"10 : 1", "20 : 1", "50 : 1",						// 107
				"100 : 1", "200 : 1", "500 : 1", "1000 : 1",				// 110
				"Off", "Trig wait", "", " ", " ", 					// 114   // LED 1
				"Off", "Triggered", "Trig Event", " ", " ",				// 119   // LED 2
				"Off", "Double Push", "Direct", "",					// 124	
				"LF Reject", "HF Reject", "Line", "Vert Sync", "Comp Sync",		// 128	//BF External Trigger + TV Trigger #019
				"0 %", "33 %", "66 %", "100 %",						// 133
				 "1", "2", "3", "4", "External", "TV",					// 137	//BF Trigger Source #019
                           	"Start", "Cancel", "Setup", "Trace", "Busy", 				// 143
                           	"BMP", "PPM", "CSV", "ASCII", "not used",				// 148
				"10mV/", "20mV/", "50mV/", "100mV/", "200mV/",				// 153
				"500mV/", "1V/", "2V/", "5V/", "10V/",		    			// 158
				"20V/", "50V/", "100V/", "1mV/", "2mV/",				// 163
				"5mV/", "10mV/", "20mV/", "50mV/", "100mV/",				// 168
				"200mV/", "500mV/", "1V/", "2V/", "5V/",				// 173
				"10V/", "20V/", "50V/", "100V/", "",					// 178
				"Layout", "Auto Level", "PC", "USB-Host", "",				// 183	//BF #006
				"Offsets", "Window", "Grid", "", "Signal",        			// 188  
				"Rectangle","von Hann","Blackman","Poisson 3.0","Kaiser 3.0",		// 193 -> BF added new items
				"Gauss 3.0","FlatTop","","","",						// 198
				" 0ns", " 1ns", " 2ns", " 3ns", " 4ns", " 5ns", " 6ns",			// 203	//BF #001
				" 7ns", " 8ns", " 9ns", "10ns", "11ns", "12ns", "13ns",			// 210	//BF #001
				"14ns", "15ns", "16ns", "", "", "",					// 217	//BF #001
				"Factory", "High Frequ", "Test 1", "Test 2", "Test 3",			// 223	//BF #002
				"Test 4","Test 5",							// 228	//BF #002
				"Factory", "Standard", "24.9 Ohm", "33 Ohm", "Add-On PCB",		// 230	//BF #004
				"", "", "", "", "",							// 235	//BF #004
				//----------------------------------------------------------------------------------------------------------------------------
				"", "", "", "", "", "", "", "",						// 240	reserved for special functions -> don't use
				//----------------------------------------------------------------------------------------------------------------------------
				"Solid", "Dotted", "", "", "", "", 					// 248 - 253 Grid Layout
				"Off", "Infinite", "4", "6", "8", "", "", "",	"", "",			// 254	// Average
				"Standard", "Active Probe", "Set 3", "Set4", 				// 264	// Calibration Set
				"Color", "B/W", "", "",							// 268	// UC Quick Print
				"Left Edge", "First Div", "Grid Middle", "Trace Middle", "Keep Value", "Keep + Follow", "", "",	// 272    Pre Trigger Setting
				"Trig. Source", "All Channels", "", "",					// 280
				"Roll Forward", "Roll Reverse", "Shift Forw", "Shift Revs",		// 284	//USTB Mode
				"Permanent", "Stepwise", "", "", 					// 288	//USTB Display Mode
				"Fast Vector", "Accurate", "Points", "",				// 292	//Draw Mode
				"8KB", "16KB", "32KB", "",						// 296 - 299 USTB Buffer Size
				"White", "Red", "Green", "Yellow", "Blue", "Teal", "Magenta", "Pink", "Orange", "Gray", "",	// 300 - 310 Grid Color	
				"Off", "Smooth", "Strong", "IIR 1 Stage", "IIR 2 Stage", "IIR 3 Stage", // 311 - 319 Noise Filter
				"FIR 1 ", "FIR 2 ", "FIR 3 ",
				"Off", "1", "2", "1 + 2", "3", "4", "3 + 4", "", "", "", 		// 320 - 329 Channel no display	
				"Standard", "Mono Grid", "Mono Beige", "Yellow", "Light Red", "Neon Yellow", "Neon Green", "Neon Blue", "Neon Red", "", // 330 - 339 Status / Menu layout	
				"Off", "TTL 5V", "CMOS 5V", "LVTTL 3.3V", "CMOS 2.5V", "CMOS 1.8V", "RS232", "", "", ""	// 340 - 349 - Logic	
			};



//BF start entries for buttons second line [MenuNr][Button(ItemNr)]	
//BF entry must be the index of the second line entry (from MenuData[][] above)!	
short MenuStatus[32][6] = {{ 340, 254, 311,  42,   0,   0}, 	//  0 Acquire
			   {   8, 240, 240, 104,  21,  25}, 	//  1 Channel 1
			   {   8, 240, 240, 104,  22,  25}, 	//  2 Channel 2
			   {   8, 240, 240, 104,  23,  25}, 	//  3 Channel 3
			   {   8, 240, 240, 104,  24,  25}, 	//  4 Channel 4
			   { 240,  37, 136, 320, 292, 242}, 	//  5 Display
			   {  20, 145, 188, 264, 192, 242}, 	//  6 Utility
			   {   0,   0,   0,   0,   0,   0}, 	//  7 Service n.a.
		 	   {   0, 146, 146, 146,  37,  48}, 	//  8 Save / Recall BF -> new overlay function
			   { 300, 248, 330,   0,   0, 243}, 	//  9 Display Setup Submenu
			   { 241, 240, 240, 240, 240, 242}, 	// 10 Timebase: Main / Delayed / XY / FFT / USTB / Browse
			   {   0,   0,   0,   0,   0,   0}, 	// 11 Delayed Timebase Menu n.a.
			   {  92,  95, 184,   0, 104, 242}, 	// 12 Trigger Mode / Coupling
			   { 114, 119, 240, 124, 272, 243}, 	// 13 Trigger sub menu
			   {   2, 137, 128, 131, 189,   0}, 	// 14 Edge  BF new external Trigger #019	
			   { 137,   1,   3,   0,   0,   0}, 	// 15 Pulse Width	#019
			   {  27,   0,   0,   0,   0,  46}, 	// 16 Cursor
			   { 148, 149, 150, 151,  36, 185}, 	// 17 Quick Print, Send Measure -> 36
			   { 223, 230,   0,   0,   0, 243},	// 18 Hardware #004
			   {  27,  52,  52,  36, 242, 242},	// 19 Quick Measurment
			   {  27,   2,  28,   2,  53, 243},	// 20 QM Delay Settings n.a.
			   {  27,   0,  28,   0,  61, 243},	// 21 QM Phase Settings	n.a.	
			   {  27,  49,   0,   0,   0, 243}, 	// 22 QM Thresholds	
			   {  47,  99, 100, 280,   0,   0},	// 23 Autoscale
			   {  93,   2, 114, 119,   0,   0},	// 24 Trigger Mode TV
			   { 203, 203, 203, 203, 242, 243},	// 25 Extended Utilities BF #001 #004
			   {   0,   0, 240, 241, 240,   0},	// 26 Math
			   { 137, 193,  66,  83,   0, 243},	// 27 FFT Settings
 			   { 240,  37, 136, 190, 183, 242}, 	// 28 Display FFT 
			   {   0,   0,   0,   0,   0, 243}, 	// 29 Math Settings
			   { 284, 288, 296,   0,   0, 243}, 	// 30 USTB: Mode / Display / Buffer
			   { 268, 269, 150,   0,   0, 185}}; 	// 31 Quick Print USB-Export

//BF Special function codes for menu status to display diffent signs in the second line of the button

								//   0 empty
								//   1 Ok sign middle
								//   2 Ok sign left
								//   3 Ok sign right
								// 240 Unchecked Checkbox
								// 241 Checked Checkbox
								// 242 Menu Down Arrow
								// 243 Menu Up Arrow
								// 244 Menu Down Arrow Grayed
								// 245 Menu Up Arrow Grayed
								// 246 Menu Grayed
								// 247 Sub Menu


// BF status of entries in menu popup list
// 0 = Not displayed / 1 = Deactive (grayed) / 2 = Available / 3 = Selected
short MenuPopupStatus[48][22] = {{ 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  0 Draw Mode
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  1 Cursor Source
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  2 Autoscale Setup
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  3 Quick Measurement Source
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  4 Quick Measurement Select
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  5 Quick Measurement Delay Settings Source1
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  6 Quick Measurement Delay Settings Source2
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  7 Trigger Source Pulse Width
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  8 Trigger Edge External setting
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  9 Trigger Mode (Auto/Normal/Combi)
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 10 Trigger Coupling
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 11 Trigger Edge TV
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 12 Single Trigger Setting
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 13 Channel 1 Coupling
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 14 Channel 2 Coupling
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 15 Channel 3 Coupling
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 16 Channel 4 Coupling
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 17 LED 1 Function
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 18 LED 2 Function
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 19 Calibration Set
				 { 3, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 20 Pre Trigger Setting
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 21 Average
				 { 3, 2, 2, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 22 Filter setting
				 { 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 23 Interpolation setting
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 24 Quick Measurement Phase Settings Source1
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 25 Quick Measurement Phase Settings Source2
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 26 Quick Measurement Threshold Source
				 { 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 27 Quick Measurement Threshold Type (Percent , Absolute)
				 { 3, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 28 Trigger Edge Source #019
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 29 FFT Source
				 { 3, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 30 FFT Window
				 { 3, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 31 FFT Mode
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 32 FFT Length
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 33 More Utilities - CH1 Delay BF #001
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 34 More Utilities - CH2 Delay BF #001
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 35 More Utilities - CH3 Delay BF #001
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 36 More Utilities - CH4 Delay BF #001
				 { 3, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 37 Hardware - ADC Register setting BF #002 #004
				 { 0, 3, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 38 Hardware - Pre Amp Gain BF #004
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 39 Quick Print - Destination
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 40 USTB mode 
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 41 USTB display mode
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 42 USTB buffer size
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 43 Grid Color
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 44 Grid Layout
				 { 3, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 45 Channel no display
				 { 3, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 46 Status / Menu layout
				 { 3, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}; 	// 47 Acquire - Logic




// Button position / number of entries in menu popup lists
unsigned short MenuPopupDef[48][2] =	{{4, 3},        //  0 Draw Mode
				       	 {0, 5},      	//  1 Cursor Source
					 {3, 2},	//  2 Autoscale Setup
				 	 {0, 5},	//  3 Quick Measurement Source
					 {1,14},	//  4 Quick Measurement Select
					 {0, 5},	//  5 Quick Measurement Delay Settings Source1
					 {2, 5},	//  6 Quick Measurement Delay Settings Source2
					 {0, 5},	//  7 Trigger Source Pulse Width
					 {2, 3},	//  8 Trigger Edge External setting
					 {0, 3},	//  9 Trigger Mode (Auto/Normal/Combi)
					 {1, 2},	// 10 Trigger Coupling
					 {3, 2},	// 11 Trigger Edge TV
					 {3, 3},	// 12 Single Trigger Setting
					 {0, 3},	// 13 Channel 1 Coupling
					 {0, 3},	// 14 Channel 2 Coupling
					 {0, 3},	// 15 Channel 3 Coupling
					 {0, 3},	// 16 Channel 4 Coupling
					 {0, 2},	// 17 LED 1 Function
					 {1, 3},	// 18 LED 2 Function
					 {3, 4},	// 19 Calibration Set
					 {4, 6},	// 20 Pre Trigger Setting
					 {1, 5},	// 21 Average
					 {2, 9},	// 22 Filter setting
					 {3, 2},	// 23 Interpolation setting
					 {0, 5},	// 24 Quick Measurement Phase Settings Source1
					 {2, 5},	// 25 Quick Measurement Phase Settings Source2
					 {0, 5},	// 26 Quick Measurement Threshold Source
					 {1, 2},	// 27 Quick Measurement Threshold Type (Percent , Absolute)
					 {1, 6},	// 28 Trigger Edge Source #019
					 {0, 4},	// 29 FFT Source
					 {1, 7},	// 30 FFT Window
					 {2, 7},	// 31 FFT Mode
					 {3, 2},	// 32 FFT Length
					 {0,17},	// 33 More Utilities - CH1 Delay BF #001
					 {1,17},	// 34 More Utilities - CH2 Delay BF #001
					 {2,17},	// 35 More Utilities - CH3 Delay BF #001
					 {3,17},	// 36 More Utilities - CH4 Delay BF #001
					 {0, 7},	// 37 Hardware - ADC Register setting BF #002 #004
					 {1, 5},	// 38 Hardware - Pre Amp Gain BF #004
					 {5, 2},	// 39 Quick Print - Destination
					 {0, 4},	// 40 USTB mode 
					 {1, 2},	// 41 USTB display mode
					 {2, 3},	// 42 USTB buffer size
					 {0,10},	// 43 Grid Color
					 {1, 2},	// 44 Grid Layout
					 {3, 7},	// 45 Channel no display
					 {2, 5},	// 46 Status / Menu layout
					 {0, 7}};	// 47 Acquire - Logic


//BF entries for menu popup lists
// Caption	/ Items ->
char MenuPopupText[48][23][20] = 
{
{{"Draw Mode"}, {"Fast Vector"}, {"Accurate"}, {"Points"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 0 Draw Mode
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 1 Cursor Source
{{"TB Search"}, {"Trig. Source"}, {"All Channels"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 2 Autoscale Setup
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 3 Quick Measurement Source
{{"Select Measurement"}, {"Average"}, {"Delay"}, {"Duty Cycle"}, {"Fall Time"}, {"Frequency"}, {"Maximum"}, {"Minimum"}, {"Peak-Peak"}, {"Period"}, {"Phase"}, {"Rise Time"}, {"RMS"}, {"+ Width"}, {"- Width"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},                                                                                                                                			// 4 Quick Measurement Select
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 5 QM Delay Settings Source1
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},                       // 6 QM Delay Settings Source2
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"External"}, {"TV"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 7 Trigger Source Pulse Width
{{"External"}, {"LF Reject"}, {"HF Reject"}, {"Line"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 8 External Trigger Setting
{{"Mode"}, {"Auto"}, {"Normal"}, {"Combi"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 9 Trigger Mode
{{"Coupling"}, {"DC"}, {"AC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},				//10 Trigger Coupling
{{"TV  ["}, {"Vert Sync"}, {"Comp Sync"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//11 TV Trigger
{{"Single Trigger"}, {"Off"}, {"Double Push"}, {"Direct"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	//12 Single Trigger Setting
{{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//13 Channel 1 Coupling
{{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//14 Channel 2 Coupling
{{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//15 Channel 3 Coupling
{{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//16 Channel 4 Coupling
{{"LED 1"}, {"Off"}, {"Trig wait"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//17 LED 1 Function
{{"LED 2"}, {"Off"}, {"Triggered"}, {"Trig Event"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//18 LED 2 Function
{{"Calibration"}, {"Standard"}, {"Active Probe"}, {"Set 3"}, {"Set 4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	//19 Calibration Set
{{"Pre Trigger"}, {"Left Edge"}, {"First Div"}, {"Grid Middle"}, {"Trace Middle"}, {"Keep Value"}, {"Keep + Follow"},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""}},//20 Pre Trigger Setting
{{"Average"}, {"Off"}, {"Infinite"}, {"4"}, {"6"}, {"8"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//21 Average
{{"Noise Filter"}, {"Off"}, {"Smooth"}, {"Strong"}, {"IIR 1 Stage"}, {"IIR 2 Stage"}, {"IIR 3 Stage"}, {"FIR 1"}, {"FIR 2"}, {"FIR 3"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	//22 Filter
{{"Interpolation"}, {"Linear"}, {"sin(x)/x"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//23 Interpolation
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//24 QM Phase settings source 1
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//25 QM Phase settings source 2
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//26 QM Threshold Source
{{"Type"}, {"Percent"}, {"Absolute"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//27 QM Threshold Type(%, Absolute)
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"External"}, {"TV"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//28 Trigger Source Edge menu
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},				//29 FFT Source
{{"Windows"}, {"Rectangle"}, {"von Hann"}, {"Blackman"}, {"Poisson"}, {"Kais.-Bess."}, {"Gauss"}, {"FlatTop"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}}, //30 FFT window
{{"FFT-Mode"}, {"Magnitude"}, {"Phase"}, {"Real"}, {"Imag"}, {"Real+Imag"}, {"Power Spec"}, {"Power Dens"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	 //31 FFT mode
{{"FFT-Length"}, {" 512"}, {"1024"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}}, 			//32 FFT length
{{"CH1 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//33 BF #001
{{"CH2 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//34 BF #001
{{"CH3 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//35 BF #001
{{"CH4 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//36 BF #001
{{"ADC-Setup"}, {"Factory"}, {"High Frequ"}, {"Test 1"}, {"Test 2"}, {"Test 3"}, {"Test 4"}, {"Test 5"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},//37 BF #002 #004
{{"Pre Gain"}, {"Factory"}, {"Standard"},  {"24.9 Ohm"}, {"33 Ohm"}, {"Add-On PCB"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},//38 BF #004
{{"Destination"}, {"PC"}, {"USB-Host"},  {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//39 Quick Print Destination
{{"USTB Mode "}, {"Roll Forw"}, {"Roll Rev"}, {"Shift Forw"}, {"Shift Rev"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 40 USTB mode
{{"USTB Display "}, {"Permanent"}, {"Stepwise"}, {" "}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 41 USTB display mode
{{"Buffer Size "}, {"8KB"}, {"16KB"}, {"32KB (Roll)"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 42 USTB buffer size
{{"Grid Color"}, {"White"}, {"Red"}, {"Green"}, {"Yellow"}, {"Blue"}, {"Teal"}, {"Magenta"}, {"Pink"}, {"Orange"}, {"Gray"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 43 Grid Color
{{"Grid Layout"}, {"Solid Lines"}, {"Dotted Lines"}, {" "}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 44 Grid Layout
{{"No Display"}, {"Off"}, {"Channel 1"}, {"Channel 2"}, {"Ch 1 + 2"}, {"Channel 3"}, {"Channel 4"}, {"Ch 3 + 4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 45 Channel no display
{{"Status Layout"}, {"Standard"}, {"Mono Grid"}, {"Mono Beige"}, {"Mono Yellow"}, {"Mono Red"}, {"Neon Yellow"}, {"Neon Green"}, {"Neon Blue"}, {"Neon Red"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},// 46 Status / Menu layout
{{"Digital Logic"}, {"Off"}, {"TTL 5V"}, {"CMOS 5V"}, {"LVTTL 3.3V"}, {"CMOS 2.5V"}, {"CMOS 1.8V"}, {"RS232"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 47 Logic


};

//********************************************************************************************************************************************************************************************************************************

	
//char SampleRateData[15][10] = {"4.00kSa/s", "10.0kSa/s", "20.0kSa/s", "40.0kSa/s", "100kSa/s", "200kSa/s", "400kSa/s", "1.00MSa/s", "2.00MSa/s", "4.00MSa/s", "10.0MSa/s", "20.0MSa/s", "25.0MSa/s", "100MSa/s", "200MSa/s"};

//BF del char Stringlist[1][32] = {"Sample Rate = "};
	
	
//BF del char PatternStatus[5] = {3, 3, 3, 3, 3};
																

//BF not used unsigned char TriggerData[11][12] = {"+ Extern", "- Extern", "+ LF Reject", "-LF Reject", "+ HF Reject", "- HF Reject", 
//								     "+ Line", "- Line", "TV VS", "TV Odd", "TV Even"};

		
unsigned short TimebaseDataDef[36] = {	10, 10,  7,  6,  6,  2,  1,  1,
				      	11, 10, 10,  7,  6,  6,  2,  1,  1,
					10,  9,  9,  5,  4,  4,  1,  0,  0,
					12, 11, 11,  8,  7,  7,  3,  3,  3,  1};


unsigned char TimebaseData[36][10] = 	{{'2', S_nS, S_Slash},
					 {'5', S_nS, S_Slash},
					 {'1', '0', S_nS, S_Slash},
					 {'2', '0', S_nS, S_Slash},
					 {'5', '0', S_nS, S_Slash},
					 {'1', '0', '0', S_nS, S_Slash},
					 {'2', '0', '0', S_nS, S_Slash},
					 {'5', '0', '0', S_nS, S_Slash},
					 {'1', S_uS, S_Slash},
					 {'2', S_uS, S_Slash},
					 {'5', S_uS, S_Slash},
					 {'1', '0', S_uS, S_Slash},
					 {'2', '0', S_uS, S_Slash},
					 {'5', '0', S_uS, S_Slash},
					 {'1', '0', '0', S_uS, S_Slash},
					 {'2', '0', '0', S_uS, S_Slash},
					 {'5', '0', '0', S_uS, S_Slash},
					 {'1', S_mS, S_Slash},
					 {'2', S_mS, S_Slash},
					 {'5', S_mS, S_Slash},
					 {'1', '0', S_mS, S_Slash},
					 {'2', '0', S_mS, S_Slash},
					 {'5', '0', S_mS, S_Slash},
					 {'1', '0', '0', S_mS, S_Slash},
					 {'2', '0', '0', S_mS, S_Slash},
					 {'5', '0', '0', S_mS, S_Slash},
					 {'1', S_S, S_Slash},
					 {'2', S_S, S_Slash},
					 {'5', S_S, S_Slash},
					 {'1', '0', S_S, S_Slash},
					 {'2', '0', S_S, S_Slash},
					 {'5', '0', S_S, S_Slash},
					 {'1', '0', '0', S_S, S_Slash},
					 {'2', '0', '0', S_S, S_Slash},
					 {'5', '0', '0', S_S, S_Slash},
					 {'1', '0', '0', '0', S_S, S_Slash}};

//BF new TB values
// used in Display::MEASURETIME() and Display::CALCCURSORDATA()
float TimeBaseFactor[36] = {	0.00004,	//   2 	ns
			      	0.0001,		//   5 	ns
			      	0.0002,		//  10 	ns
			      	0.0004,		//  20 	ns
			       	0.001,		//  50 	ns
				0.002,		// 100 	ns
				0.004,		// 200 	ns
				0.01,		// 500 	ns		
				0.02,		//   1 	µs
				0.04,		//   2 	µs
				0.1,		//   5 	µs
				0.2,		//  10 	µs
				0.4,		//  20 	µs
				1,		//  50 	µs
				2,		// 100 	µs
				4,		// 200 	µs
			       10,		// 500 	µs
			       20,		//   1 	ms
			       40,		//   2 	ms
			      100,		//   5 	ms
			      200,		//  10 	ms
			      400,		//  20 	ms
			     1000,		//  50 	ms
			     2000,		// 100 	ms
			     4000,		// 200 	ms
			    10000,		// 500 	ms
			    20000,		//   1 	s
			    40000,		//   2 	s
			   100000,		//   5 	s
			   200000,		//  10 	s
			   400000,		//  20 	s
			  1000000,		//  50 	s
			  2000000,		// 100  s
			  4000000,		// 200  s
			 10000000,		// 500  s
			 20000000		//1000  s
		};

// BF new sample rate value for pretrigger calculation and FFT
int SampleRate[36] = {	1000000000,		//   2 	ns - 1GSa
			1000000000,		//   5 	ns - 1GSa
			1000000000,		//  10 	ns - 1GSa
			1000000000,		//  20 	ns - 1GSa
			1000000000,		//  50 	ns - 1GSa
			1000000000,		// 100 	ns - 1GSa
			1000000000,		// 200 	ns - 1GSa
			1000000000,		// 500 	ns - 1GSa	
			1000000000,		//   1 	µs - 1GSa
			 500000000,		//   2 	µs - 500MSa
			 250000000,		//   5 	µs - 250MSa
			  25000000,		//  10 	µs - 25MSa
			  10000000,		//  20 	µs - 10MSa
			   5000000,		//  50 	µs - 5MSa
			   2500000,		// 100 	µs - 2.5MSa
			   1000000,		// 200 	µs - 1MSa
			    500000,		// 500 	µs - 500KSa
			    250000,		//   1 	ms - 250KSa
			    100000,		//   2 	ms - 100KSa
			     50000,		//   5 	ms - 50KSa
			     25000,		//  10 	ms - 25KSa
			     10000,		//  20 	ms - 10KSa
			      5000,		//  50 	ms - 5KSa
			      2500,		// 100 	ms - 2,5KSa
			      1000,		// 200 	ms - 1KSa
			       500,		// 500 	ms - 500Sa
			       250,		//   1 	s  - 250Sa 
			       100,		//   2 	s  - 100Sa
				50,		//   5 	s  - 50Sa
				25,		//  10 	s  - 25Sa
				10,		//  20 	s  - 10Sa
				 5,		//  50 	s  - 5Sa
				 2,		// 100 	s  - 2,5Sa
				 1,		// 200 	s  - 1Sa 
				 1,
				 1
 			};

// BF Text offset for top status line	
unsigned short SampleRateDataDef[36] = {20, 20, 20, 20, 20, 20, 20, 20,	
                                        20,  0,  0, 10, 10, 15,  0, 20,
                                         0,  0,  0, 10, 10, 10, 15,  5,
                                        15,  5, 15, 15, 15, 20, 10, 20, 15, 15 , 15, 11 };
		
unsigned char SampleRateData[36][11] = {{"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "},					//interpolated / normal
                                        {"1 GSa/s "}, {"500 MSa/s "}, {"250 MSa/s "}, {"25 MSa/s "}, {"10 MSa/s "}, {"5 MSa/s "}, {"2.5 MSa/s "}, {"1 MSa/s "},				//normal
                                        {"500 kSa/s "}, {"250 kSa/s "}, {"100 kSa/s "}, {"50 kSa/s "}, {"25 kSa/s "}, {"10 kSa/s "}, {"5 kSa/s "}, {"2.5 kSa/s "},			//normal
                                        {"1 kSa/s "}, {"500 Sa/s "}, {"50 Sa/s "}, {"25 Sa/s "}, {"10 Sa/s "}, {"5 Sa/s "}, {"2.5 Sa/s "}, {"1 Sa/s "}, {"1 Sa/2s "},			//USTB
					{"1 Sa/4s "}, {"1 Sa/10s "}, {"1 Sa/20s "}};													//USTB
/*
// BF #003 extended printout matrix		
const short TimebaseData_Matrix[36][5][10] = {{{'2', S_nS, S_Slash}, {'5', S_nS, S_Slash}, {'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}},                             // 2 ns
                                              {{'5', S_nS, S_Slash}, {'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}},                   // 5 ns
                                              {{'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}},         // 10 ns
                                              {{'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}},    // 20 ns
                                              {{'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}},         // 50 ns
                                              {{'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}},              // 100 ns
                                              {{'2', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}},                                  // 200 ns
                                              {{'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}},                             // 500 ns
                                              {{'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}},                                  // 1 �s
                                              {{'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}},                             // 2 �s
                                              {{'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}},                   // 5 �s
                                              {{'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}},         // 10 �s
                                              {{'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}},    // 20 �s
                                              {{'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}},         // 50 �s
                                              {{'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}},              // 100 �s
                                              {{'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}},                        // 200 �s
                                              {{'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}},                             // 500 �s
                                              {{'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}},                                  // 1 ms
                                              {{'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}},                             // 2 ms
                                              {{'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}},                   // 5 ms
                                              {{'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}},         // 10 ms
                                              {{'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}},    // 20 ms
                                              {{'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}},          // 50 ms
                                              {{'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}},                // 100 ms
                                              {{'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}},                           // 200 ms
                                              {{'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}},                                 // 500 ms
                                              {{'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}},                                       // 1 s
                                              {{'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}},                                  // 2 s
                                              {{'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}},                        // 5 s
                                              {{'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}},              // 10 s
                                              {{'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}},         // 20 s
                                              {{'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}}, // 50 s
                                              {{'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, { }},       		// 100 s
                                              {{'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, { }, { }}, 						// 200 s
                                              {{'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, { }, { }, { }}, 									// 500 s
                                              {{'1', '0', '0', '0', S_S, S_Slash}, { }, { }, { }, { }}}; 												// 1000 s

*/


//BF changed #003 new reduced table for delayed factor
const float Timebase_Delayed_Factor_Table[26]    =  {           2,
                                                     		5,
                                                     	       10,
                                                     	       20,
                                                               50,
                                                              100,
                                                              200,
                                                              500,
                                                             1000,
                                                             2000,
                                                             5000,
                                                            10000,
                                                            20000,
                                                            50000,
                                                           100000,
                                                           200000,
                                                           500000,
                                                          1000000,
                                                          2000000,
                                                          5000000,
                                                         10000000,
                                                         20000000,
                                                         50000000,
                                                        100000000,
                                                        200000000,
                                                        500000000 };

//Voltage ratio
const float VoltFactor[19] = { 0.001,	//  1mV
			       0.002,	//  2mV
			       0.005,	//  5mV
			       0.01,	// 10mV
			       0.02,	// 20mV
			       0.05,	// 50mV
			       0.1,	//100mV
			       0.2,	//200mV
			       0.5,	//500mV
			       1.0,	//  1V
			       2.0,	//  2V
			       5.0,	//  5V
			      10.0,	// 10V
			      20.0,	// 20V
			      50.0,	// 50V
			     100.0, 	//100V
			     200.0, 	//200V
			     300.0, 	//500V
			    1000.0};   //1000V



const char VoltageData[11][5] =  {{S_uV, S_Slash},
				  {S_mV, S_Slash},
				  {S_V, S_Slash},
				  {S_kV, S_Slash},
	 			  {S_uA, S_Slash},
				  {S_mA, S_Slash},
				  {S_A, S_Slash},
				  {S_kA, S_Slash},
				  {},
				  {}, {}};

// direct conversion from screen position to voltage
const float ScreenScaleFactor[16] = { 0.00002,	//  1mV
				      0.00004,	//  2mV
				      0.0001,	//  5mV
				      0.0002,	// 10mV
				      0.0004,	// 20mV
				      0.001,	// 50mV
				      0.002,	//100mV
				      0.004,	//200mV
				      0.01,	//500mV
				      0.02,	//  1V
				      0.04,	//  2V
				      0.1,	//  5V
				      0.2,	// 10V
				      0.4,	// 20V
				      1.0,	// 50V
				      2.0 };	//100V


//FONT 10x9 BITMAPS ...........................................................
unsigned char FONT10X9[100][28]={{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;32 (BLANK)   3 Pixel Space
								
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
								  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;33 (!)
								
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;34 (") 
						
        						 {0x40,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,
						  		  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;35 (#) #
						
        						 {0xF8,0x03,0x18,0x00,0x60,0x00,0x80,0x01,0x60,0x00,0x18,0x00,0xF8,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;36 ($) kleines gro�es M
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;37 (%) 
								
        						 {0xF8,0x01,0xF8,0x03,0x00,0x02,0x00,0x01,0xF8,0x03,0xF8,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;38 (&) �
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;39 (')
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;40  (  
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;41  ) 
								
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;42 (*) 
						
        						 {0x10,0x00,0x10,0x00,0x7C,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;43 (+) +
						
		   						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;44 (,)
						
		        				 {0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;45 (-) -
						
        						 {0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;46 (.) .
						
        						 {0x00,0x03,0xE0,0x00,0x1C,0x00,0x03,0x00,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;47 (/) /
						
        						 {0xFE,0x01,0xFF,0x03,0x01,0x02,0x01,0x02,0xFF,0x03,0xFE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;48 (0) 0
						
		        				 {0x0C,0x00,0x06,0x00,0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;49 (1) 1
						
        						 {0x02,0x03,0x83,0x03,0xE1,0x02,0x71,0x02,0x3F,0x02,0x0E,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;50 (2) 2
						
        						 {0x02,0x01,0x03,0x03,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;51 (3) 3
											
        						 {0xC0,0x00,0xB0,0x00,0x8C,0x00,0xFF,0x03,0xFF,0x03,0x80,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;52 (4) 4
						
		        				 {0x1C,0x01,0x1F,0x03,0x0B,0x02,0x09,0x02,0xF9,0x03,0xF1,0x01,0x00,0x00,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;53 (5) 5
								
        						 {0xFC,0x01,0xFE,0x03,0x11,0x02,0x11,0x02,0xF3,0x03,0xE2,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;54 (6) 6
						
        						 {0x01,0x00,0x81,0x03,0xF1,0x03,0x7D,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;55 (7) 7
						
        						 {0xEE,0x01,0xFF,0x03,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;56 (8) 8
						
		        				 {0x1E,0x01,0x3F,0x03,0x21,0x02,0x21,0x02,0xFF,0x01,0xFE,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;57 (9) 9
						
        						 {0x18,0x03,0x18,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;58 (:) :
						
        						 {0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x07,0x80,0x03,
						  		  0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x02,0x00}, //   ;59 (;) Menu Hacken
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;60 (<)
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;61 (=) 
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;62 (>)
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;63 (?)
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;64 (@) 
						
        						 {0x00,0x03,0xE0,0x03,0xFC,0x00,0x9F,0x00,0x83,0x00,0x9F,0x00,0xFC,0x00,
						  		  0xE0,0x03,0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;65 (A) A
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x02,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;66 (B) B
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x01,0x02,0x01,0x02,0x03,0x03,
						  		  0x02,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;67 (C) C
						
		        				 {0xFF,0x03,0xFF,0x03,0x01,0x02,0x01,0x02,0x03,0x03,0xFE,0x01,0xFC,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;68 (D) D
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x02,0x11,0x02,0x11,0x02,0x01,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;69 (E) E
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x00,0x11,0x00,0x11,0x00,0x01,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;70 (F) F
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x21,0x02,0x21,0x02,0xE3,0x03,
						  		  0xE2,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;71 (G) G
						
		        				 {0xFF,0x03,0xFF,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0xFF,0x03,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;72 (H) H
						
        						 {0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;73 (I) I
						
        						 {0x80,0x01,0x80,0x03,0x00,0x02,0x00,0x02,0xFF,0x03,0xFF,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;74 (J) J
						
        						 {0xFF,0x03,0xFF,0x03,0x30,0x00,0x1C,0x00,0xFE,0x00,0xE3,0x03,0x01,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;75 (K) K
						
		        				 {0xFF,0x03,0xFF,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;76 (L) L
						
        						 {0xFF,0x03,0xFF,0x03,0x0F,0x00,0xFC,0x01,0x80,0x03,0xFC,0x01,0x0F,0x00,
						  		  0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;77 (M) M
						
        						 {0xFF,0x03,0xFF,0x03,0x0E,0x00,0x38,0x00,0xE0,0x00,0xFF,0x03,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;78 (N) N
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x01,0x02,0x03,0x03,0xFE,0x01,
						  		  0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;79 (O) O
						
		        				 {0xFF,0x03,0xFF,0x03,0x21,0x00,0x21,0x00,0x21,0x00,0x3F,0x00,0x1E,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;80 (P) P
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x81,0x02,0x03,0x03,0xFE,0x01,
						  		  0xFC,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;81 (Q) Q
						
        						 {0xFF,0x03,0xFF,0x03,0x21,0x00,0x21,0x00,0x61,0x00,0xFF,0x01,0x9E,0x03,
						  		  0x00,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;82 (R) R
						
        						 {0x0E,0x01,0x1F,0x03,0x39,0x02,0x31,0x02,0x71,0x02,0xE3,0x03,0xC2,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;83 (S) S
						
		        				 {0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x03,0xFF,0x03,0x03,0x00,0x03,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;84 (T) T
						
        						 {0xFF,0x01,0xFF,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0xFF,0x03,0xFF,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;85 (U) U
						
        						 {0x03,0x00,0x1F,0x00,0xFC,0x00,0xE0,0x03,0x00,0x03,0xE0,0x03,0xFC,0x00,
						  		  0x1F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;86 (V) V
						
        						 {0x03,0x00,0x7F,0x00,0xFC,0x03,0x80,0x03,0xF8,0x03,0x7F,0x00,0x07,0x00,
						  		  0x7F,0x00,0xF8,0x03,0x80,0x03,0xFC,0x03,0x7F,0x00,0x03,0x00,0x00,0x00}, //   ;87 (W) W
						
		        				 {0x03,0x03,0x87,0x03,0xFC,0x00,0x78,0x00,0xFC,0x00,0x87,0x03,0x03,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;88 (X) X
						
        						 {0x03,0x00,0x07,0x00,0x1C,0x00,0xF8,0x03,0xF8,0x03,0x1C,0x00,0x07,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;89 (Y) Y
						
        						 {0x01,0x03,0x81,0x03,0xE1,0x02,0x79,0x02,0x1D,0x02,0x07,0x02,0x03,0x02,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;90 (Z) Z
						
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x22,0x08,0x12,0x08,0xFA,0x0B,0x02,0x08,
						  		  0x02,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;91 ([) 1 small One
						  		
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x0A,0x0A,0x0B,0x8A,0x0A,0x4A,0x0A,
						  		  0x32,0x0A,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;92 (\) 2 small Two

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x09,0x0A,0x0A,0x4A,0x0A,0x4A,0x0A,
						  		  0xB2,0x09,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;93 (]) 3 small Three

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0xC2,0x08,0xA2,0x08,0x92,0x08,0xFA,0x0B,
						  		  0x82,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;94 (^) 4 small Four
						
								 {0xFC,0x00,0x02,0x01,0x79,0x02,0x85,0x02,0x85,0x02,0x85,0x02,0x85,0x02,
						  		  0x49,0x02,0x02,0x01,0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_) � copywrite
								
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x1A,0x0B,0xA2,0x08,0x42,0x08,0xA2,0x08,
						  		  0x1A,0x0B,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;96 (`)  e small e
						
        						 {0x90,0x01,0xC8,0x03,0x68,0x02,0x28,0x02,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;97 (a)  a

        						 {0xFF,0x03,0xFF,0x03,0x10,0x01,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;98 (b)  b

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x08,0x02,0x18,0x03,0x10,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;99 (c)  c

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x10,0x01,0xFF,0x03,0xFF,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;100 (d)  d

        						 {0xF0,0x01,0xF8,0x03,0x48,0x02,0x48,0x02,0x78,0x03,0x70,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;101 (e)  e

        						 {0x08,0x00,0xFE,0x03,0xFF,0x03,0x09,0x00,0x01,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;102 (f)  f

        						 {0xF0,0x09,0xF8,0x13,0x08,0x12,0x10,0x11,0xF8,0x1F,0xF8,0x0F,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;103 (g)  g

        						 {0xFF,0x03,0xFF,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;104 (h)  h

        						 {0xFB,0x03,0xFB,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;105 (i)  i

        						 {0x00,0x10,0x00,0x10,0xFB,0x1F,0xFB,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;106 (j)  j

        						 {0xFF,0x03,0xFF,0x03,0x60,0x00,0xF0,0x01,0x98,0x03,0x08,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;107 (k)  k

        						 {0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;108 (l)  l

        						 {0xF8,0x03,0xF8,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF8,0x03,0x10,0x00,
						  		  0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;109 (m)  m

        						 {0xF8,0x03,0xF8,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;110 (n)  n

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;111 (o)  o

        						 {0xF8,0x1F,0xF8,0x1F,0x10,0x01,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;112 (p)  p

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x10,0x01,0xF8,0x1F,0xF8,0x1F,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;113 (q)  q

        						 {0xF8,0x03,0xF8,0x03,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;114 (r)  r

        						 {0x30,0x01,0x78,0x03,0x68,0x02,0xC8,0x02,0xD8,0x03,0x90,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;115 (s)  s

        						 {0x08,0x00,0xFC,0x01,0xFE,0x03,0x08,0x02,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;116 (t)  t

        						 {0xF8,0x01,0xF8,0x03,0x00,0x02,0x00,0x01,0xF8,0x03,0xF8,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;117 (u)  u

        						 {0x18,0x00,0xF8,0x00,0xE0,0x03,0x00,0x03,0xE0,0x03,0xF8,0x00,0x18,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;118 (v)  v

        						 {0x18,0x00,0xF8,0x00,0xE0,0x03,0x80,0x03,0xF0,0x01,0x38,0x00,0xF0,0x01,
						  		  0x80,0x03,0xE0,0x03,0xF8,0x00,0x18,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;119 (w)  w

        						 {0x18,0x03,0xB8,0x03,0xE0,0x00,0xE0,0x00,0xB8,0x03,0x18,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;120 (x)  x

        						 {0x18,0x10,0xF8,0x10,0xE0,0x1F,0x00,0x1F,0xE0,0x07,0xF8,0x00,0x18,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;121 (y)  y

        						 {0x08,0x03,0xC8,0x03,0xE8,0x02,0x38,0x02,0x18,0x02,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;122 (z)  z 
						
        						 {0x10,0x00,0x18,0x00,0xFC,0x01,0xFE,0x01,0xFC,0x01,0x18,0x00,0x10,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;123 ({)  Big Arrow Up

        						 {0x20,0x00,0x60,0x00,0xFE,0x00,0xFE,0x01,0xFE,0x00,0x60,0x00,0x20,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;124 (|)  Big Arrow Down

        						 {0x20,0x00,0x30,0x00,0x38,0x00,0xFD,0x00,0x39,0x01,0x31,0x02,0x21,0x04,
						  		  0x01,0x04,0x01,0x04,0x01,0x04,0x01,0x04,0x02,0x02,0x04,0x01,0xF8,0x00}, //   ;125 (})  Cycle Arrow

								 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;126 (~) 
						
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;127 (�)
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;128
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;129
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;130
						
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}};//    ;131
						
//FONT 12x9 BITMAPS ...........................................................
unsigned char FONT12X9[120][28]={{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;32 (BLANK)   3 Pixel Space
								
		        				 {0xFF,0x0D,0xFF,0x0D,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;33 (!) !
								
        						 {0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0F,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;34 (") "
						
        						 {0x40,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,
						  		  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;35 (#) #
						
        						 {0xF0,0x0F,0xF0,0x0F,0xF0,0x00,0xC0,0x07,0x00,0x0E,0xC0,0x07,0xF0,0x00,
						  		  0xF0,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;36 ($) kleines gro�es M f�r Main Timebase
						
		        				 {0x0E,0x00,0x1F,0x00,0x11,0x00,0x1F,0x06,0x8E,0x07,0xE0,0x01,0x78,0x00,
						  		  0x9E,0x03,0xC7,0x07,0x41,0x04,0xC0,0x07,0x80,0x03,0x00,0x00,0x00,0x80}, //   ;37 (%) %
								
        						 {0xF8,0x7F,0xF8,0x7F,0x00,0x04,0x00,0x0C,0x00,0x06,0xF8,0x0F,0xF8,0x0F,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;38 (&) �
						
        						 {0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;39 (') '
						
        						 {0xF0,0x07,0xFE,0x3F,0x0F,0x78,0x01,0x40,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;40  (  
						
		        				 {0x00,0x00,0x01,0x40,0x0F,0x78,0xFE,0x3F,0xF0,0x07,0x00,0x00,0x00,0x80,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;41  ) 

        						 {0x50,0x00,0x50,0x00,0x38,0x00,0x50,0x00,0x50,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;42 (*) *
						
        						 {0x10,0x00,0x10,0x00,0x7C,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;43 (+) +
						
		   						 {0x00,0x4C,0x00,0x3C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;44 (,) ,
						
		        				 {0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;45 (-) -

        						 {0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;46 (.) .
						
        						 {0x00,0x00,0x00,0x0E,0xF8,0x0F,0xFF,0x01,0x07,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;47 (/) /
					
        						 {0xFC,0x03,0xFE,0x07,0x07,0x0E,0x03,0x0C,0x03,0x0C,0x07,0x0E,0xFE,0x07,
						  		  0xFC,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;48 (0) 0
						
		        				 {0x18,0x00,0x0C,0x00,0x06,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;49 (1) 1
						
        						 {0x0C,0x0C,0x0E,0x0E,0x07,0x0F,0x83,0x0D,0xC3,0x0D,0xE3,0x0C,0x7E,0x0C,
						  		  0x1C,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;50 (2) 2
						
        						 {0x04,0x03,0x06,0x07,0x03,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0E,0xFF,0x07,
						  		  0xCE,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;51 (3) 3
											
        						 {0x80,0x03,0xC0,0x03,0x70,0x03,0x38,0x03,0x0E,0x03,0xFF,0x0F,0xFF,0x0F,
						  		  0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;52 (4) 4
						
		        				 {0x78,0x03,0x7F,0x07,0x3F,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0E,0xE3,0x07,
								  0xC0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;53 (5) 5
								
        						 {0xF8,0x01,0xFE,0x07,0x67,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0C,0xE7,0x07,
						  		  0xC6,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;54 (6) 6
						
        						 {0x03,0x00,0x03,0x00,0x03,0x0F,0xE3,0x0F,0xFB,0x01,0x1F,0x00,0x07,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;55 (7) 7
						
        						 {0x9C,0x03,0xFE,0x07,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0xFE,0x07,
						  		  0x9C,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;56 (8) 8
						
		        				 {0x3C,0x06,0x7E,0x0E,0xE3,0x0C,0xC3,0x0C,0xC3,0x0C,0x67,0x0E,0xFE,0x07,
						  		  0xF8,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;57 (9) 9
						
        						 {0x00,0x00,0x18,0x0C,0x18,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;58 (:) :
														
        						 {0x18,0x4C,0x18,0x3C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;59 (;) ;
						
		        				 {0x40,0x00,0xE0,0x00,0xE0,0x00,0xB0,0x01,0xB0,0x01,0x18,0x03,0x18,0x03,
								  0x0C,0x06,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;60 (<) <
						
        						 {0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,
						  		  0xB0,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;61 (=) =
						
        						 {0x0C,0x06,0x18,0x03,0x18,0x03,0xB0,0x01,0xB0,0x01,0xE0,0x00,0xE0,0x00,
						  		  0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;62 (>) >
						
        						 {0x18,0x00,0x1C,0x00,0x0E,0x00,0x86,0x1B,0xC6,0x1B,0xE6,0x00,0x7C,0x00,
						  		  0x38,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;63 (?) ?

		        				 {0x00,0x0C,0x00,0x0F,0xC0,0x0F,0xF0,0x0C,0x3C,0x0C,0x0F,0x0C,0x3C,0x0C,
								  0xF0,0x0C,0xC0,0x0F,0x00,0x0F,0x00,0x0C,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;64 (@) Delta
						
        						 {0x00,0x08,0x00,0x0F,0xE0,0x07,0xF8,0x01,0x9E,0x01,0x86,0x01,0x9E,0x01,
						  		  0xF8,0x01,0xE0,0x07,0x00,0x0F,0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;65 (A) A
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,
						  		  0xFF,0x0C,0xDE,0x07,0x80,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;66 (B) B
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x07,0x0E,0x0E,0x07,0x04,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;67 (C) C
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x06,0x06,0xFE,0x07,0xF8,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;68 (D) D
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,
						  		  0x63,0x0C,0x63,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;69 (E) E
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,
						  		  0x03,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;70 (F) F
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0xC3,0x0C,0xC3,0x0C,
						  		  0xC7,0x0E,0xCE,0x07,0xC4,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;71 (G) G
						
		        				 {0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,
						  		  0x60,0x00,0x60,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;72 (H) H
						
        						 {0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;73 (I) I
						
        						 {0x00,0x07,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0E,0xFF,0x07,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;74 (J) J
						
        						 {0xFF,0x0F,0xFF,0x0F,0xC0,0x00,0x60,0x00,0x30,0x00,0x78,0x00,0xEC,0x01,
						  		  0x86,0x07,0x03,0x0E,0x01,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;75 (K) K
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,
						  		  0x00,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;76 (L) L
						
        						 {0xFF,0x0F,0xFF,0x0F,0x0F,0x00,0xFC,0x00,0xE0,0x07,0x00,0x0F,0xE0,0x07,
						  		  0xFC,0x00,0x0F,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;77 (M) M
						
        						 {0xFF,0x0F,0xFF,0x0F,0x0E,0x00,0x1C,0x00,0x70,0x00,0xE0,0x00,0x80,0x03,
						  		  0x00,0x07,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;78 (N) N
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x06,0x06,0xFE,0x07,0xF8,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;79 (O) O
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x77,0x00,
						  		  0x3E,0x00,0x1C,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;80 (P) P
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0D,0x03,0x0F,0x03,0x06,
						  		  0x06,0x0E,0xFE,0x1F,0xF8,0x11,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;81 (Q) Q
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0xE3,0x00,0xE3,0x01,
						  		  0xB7,0x07,0x3E,0x0F,0x1C,0x0C,0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;82 (R) R
						
        						 {0x1C,0x03,0x3E,0x07,0x33,0x0E,0x73,0x0C,0x63,0x0C,0x63,0x0C,0xE7,0x0E,
						  		  0xCE,0x07,0x8C,0x03,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;83 (S) S
						
		        				 {0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x0F,0xFF,0x0F,0x03,0x00,
						  		  0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;84 (T) T
						
        						 {0xFF,0x03,0xFF,0x07,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,
						  		  0x00,0x0E,0xFF,0x07,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;85 (U) U
						
        						 {0x03,0x00,0x0F,0x00,0x7C,0x00,0xF0,0x01,0x80,0x0F,0x00,0x0E,0x80,0x0F,
						  		  0xF0,0x01,0x7C,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;86 (V) V
						
        						 {0x1F,0x00,0xFE,0x00,0xE0,0x0F,0x00,0x0F,0xF8,0x0F,0xFF,0x00,0x07,0x00,
						  		  0xFF,0x00,0xF8,0x0F,0x00,0x0F,0xE0,0x0F,0xFC,0x01,0x1F,0x00,0x00,0x00}, //   ;87 (W) W
						
		        				 {0x03,0x0C,0x07,0x0E,0x9E,0x07,0xF8,0x01,0xF0,0x00,0xF8,0x01,0x9E,0x07,
						  		  0x07,0x0E,0x03,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;88 (X) X
						
        						 {0x07,0x00,0x1E,0x00,0x38,0x00,0xE0,0x0F,0xE0,0x0F,0x38,0x00,0x1E,0x00,
						  		  0x07,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;89 (Y) Y
						
        						 {0x03,0x0E,0x83,0x0F,0xC3,0x0D,0xF3,0x0C,0x3B,0x0C,0x1F,0x0C,0x07,0x0C,
						  		  0x03,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;90 (Z) Z
						
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x22,0x08,0x12,0x08,0xFA,0x0B,0x02,0x08,
						  		  0x02,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;91 ([) 1 small One
						  		
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x0A,0x0A,0x0B,0x8A,0x0A,0x4A,0x0A,
						  		  0x32,0x0A,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;92 (\) 2 small Two

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x09,0x0A,0x0A,0x4A,0x0A,0x4A,0x0A,
						  		  0xB2,0x09,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;93 (]) 3 small Three

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0xC2,0x08,0xA2,0x08,0x92,0x08,0xFA,0x0B,
						  		  0x82,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;94 (^) 4 small Four
						         /*
								 {0xFC,0x00,0x02,0x01,0x79,0x02,0x85,0x02,0x85,0x02,0x85,0x02,0x85,0x02,
						  		  0x49,0x02,0x02,0x01,0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_) � copywrite
								 */
								 {0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_)  _

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x1A,0x0B,0xA2,0x08,0x42,0x08,0xA2,0x08,
						  		  0x1A,0x0B,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;96 (`)  e small e

        						 {0x30,0x07,0xB8,0x0F,0x98,0x0D,0xD8,0x0C,0xD8,0x0C,0xF8,0x07,0xF0,0x0F,
						  		  0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;97 (a)  a

        						 {0xFF,0x0F,0xFF,0x0F,0x30,0x06,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;98 (b)  b

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x38,0x0E,0x30,0x06,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;99 (c)  c

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x30,0x06,0xFF,0x0F,
						  		  0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;100 (d)  d

        						 {0xE0,0x03,0xF0,0x07,0xD8,0x0E,0xD8,0x0C,0xD8,0x0C,0xF0,0x06,0xE0,0x02,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;101 (e)  e

        						 {0x18,0x00,0xFE,0x0F,0xFF,0x0F,0x1B,0x00,0x1B,0x00,0x03,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;102 (f)  f

        						 {0xE0,0x33,0xF0,0x77,0x38,0x6E,0x18,0x6C,0x18,0x6C,0x30,0x66,0xF8,0x7F,
						  		  0xF8,0x3F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;103 (g)  g

        						 {0xFF,0x0F,0xFF,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,
						  		  0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;104 (h)  h

        						 {0xFB,0x0F,0xFB,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;105 (i)  i

        						 {0x00,0x60,0x00,0x60,0xFB,0x7F,0xFB,0x3F,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;106 (j)  j

        						 {0xFF,0x0F,0xFF,0x0F,0xC0,0x01,0xE0,0x00,0xF0,0x03,0x18,0x0F,0x08,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;107 (k)  k

        						 {0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;108 (l)  l

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,0xF0,0x0F,
						  		  0x30,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x80}, //   ;109 (m)  m

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,
						  		  0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;110 (n)  n

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;111 (o)  o

        						 {0xF8,0x7F,0xF8,0x7F,0x30,0x06,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;112 (p)  p

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x30,0x06,0xF8,0x7F,
						  		  0xF8,0x7F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;113 (q)  q

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;114 (r)  r

        						 {0x70,0x06,0xF8,0x0E,0xD8,0x0C,0xD8,0x0D,0x98,0x0D,0xB8,0x0F,0x30,0x07,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;115 (s)  s

        						 {0x18,0x00,0xFE,0x07,0xFF,0x0F,0x18,0x0C,0x18,0x0C,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;116 (t)  t

        						 {0xF8,0x07,0xF8,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x06,0xF8,0x0F,
						  		  0xF8,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;117 (u)  u

        						 {0x38,0x00,0xF8,0x01,0xC0,0x0F,0x00,0x0E,0xC0,0x0F,0xF8,0x01,0x38,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;118 (v)  v

        						 {0x18,0x00,0xF8,0x01,0xE0,0x0F,0x00,0x0E,0xC0,0x0F,0xF8,0x01,0x38,0x00,
						  		  0xF8,0x01,0xC0,0x0F,0x00,0x0E,0xE0,0x0F,0xF8,0x01,0x18,0x00,0x00,0x00}, //   	;119 (w)  w

        						 {0x18,0x0C,0x38,0x0E,0xF0,0x07,0xC0,0x01,0xF0,0x07,0x38,0x0E,0x18,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;120 (x)  x

        						 {0x18,0x00,0x78,0x60,0xE0,0x63,0x80,0x7F,0x00,0x3E,0x80,0x0F,0xE0,0x03,
						  		  0x78,0x00,0x18,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;121 (y)  y

        						 {0x18,0x0C,0x18,0x0F,0x98,0x0F,0xD8,0x0D,0xF8,0x0C,0x78,0x0C,0x18,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;122 (z)  z 
								
								 {0x80,0x00,0xC0,0x00,0xE0,0x00,0xF0,0x00,0xF8,0x00,0xF0,0x00,0xE0,0x00,
								  0xC0,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;123 ({)  	Arrow Up
								
								 {0x08,0x00,0x18,0x00,0x38,0x00,0x78,0x00,0xF8,0x00,0x78,0x00,0x38,0x00,
								  0x18,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;124 (|)  	Arrow Down

        						 {0x00,0x08,0x00,0x08,0xC0,0x08,0xF0,0x08,0xFF,0x0F,0xF1,0x00,0xC1,0x00,
								  0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;125 (})  	Rising Edge
					
								 {0x01,0x00,0x01,0x00,0x31,0x00,0xF1,0x00,0xFF,0x0F,0xF0,0x08,0x30,0x08,
								  0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;126 (~)	Falling Edge

        						 {0x00,0x78,0xF0,0x7F,0xFF,0x07,0x0F,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;127 (DEL) / for per Division
								
		        				 {0x00,0x00,0x7F,0x03,0x7F,0x1F,0x02,0x7C,0x01,0x60,0x7F,0x7C,0x7F,0x1F,
								  0x02,0x03,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x80}, //   	;128 (�)  milli Volt per Division
															
        						 {0x03,0x00,0x0F,0x00,0x7C,0x00,0xF0,0x01,0x80,0x0F,0x00,0x0E,0x80,0x0F,
								  0xF0,0x01,0x7C,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;129 (?)  Volt per Division
								
        						 {0x00,0x00,0x7F,0x26,0x7F,0x6F,0x02,0x4D,0x01,0x59,0x7F,0x7B,0x7E,0x32,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;130 (�) ns per Division
						
        						 {0x00,0x00,0x00,0x00,0x7F,0xC4,0x7F,0xDB,0x10,0xDB,0x1F,0xDB,0x1F,0x23,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80},//    	;131 (�)  �s per Division								

        						 {0x00,0x00,0x7F,0x26,0x7F,0x6F,0x02,0x4D,0x01,0x59,0x7F,0x7B,0x7F,0x32,
								  0x02,0x00,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;132 (�) ms per Division
						
        						 {0x00,0x00,0xC0,0x04,0xE0,0x0D,0xA0,0x09,0x20,0x0B,0x60,0x0F,0x40,0x06,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80},//    	;133 (�)  s per Division								

        						 {0x20,0x00,0xA0,0x00,0xB8,0x02,0xA8,0x00,0x28,0x00,0x08,0x00,0x7F,0x00,
								  0x3E,0x00,0x1C,0x00,0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80},//    	;134 (�) Ground Sign

        						 {0x00,0x00,0xC0,0x00,0xE0,0x01,0xE0,0x01,0xC0,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;135 (�) List Count Dot

        						 {0xF0,0x07,0xFE,0x3F,0x0F,0x78,0x41,0x41,0x60,0x03,0x70,0x07,0x60,0x03,
								  0x41,0x41,0x0F,0x78,0xFE,0x7F,0xF0,0x07,0x00,0x00,0x00,0x80,0x00,0x80}, //	;136 (�) Channel Zerolevel Symbol

        						 {0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x07,0x80,0x03,
						  		  0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x02,0x00}, //   	;137 (�) Menu Hacken

        						 {0x00,0x30,0x00,0x30,0xFF,0x3F,0xFF,0x3F,0x03,0x00,0x03,0x00,0x03,0x00,
								  0x03,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x80}, //   	;138 (�) positive Pulse

        						 {0x03,0x00,0x03,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x30,
								  0x00,0x30,0xFF,0x3F,0xFF,0x3F,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x80}, //   	;139 (�) negative Pulse

        						 {0x80,0x00,0xC0,0x01,0xC0,0x01,0x60,0x03,0x60,0x03,0x30,0x06,0x30,0x06,
								  0x18,0x0C,0x18,0x0C,0x0C,0x18,0x0C,0x18,0x04,0x10,0x00,0x00,0x00,0x80}, //   	;140 (�) gro�es kleiner als
								
        						 {0x04,0x10,0x0C,0x18,0x0C,0x18,0x18,0x0C,0x18,0x0C,0x30,0x06,0x30,0x06,
								  0x60,0x03,0x60,0x03,0xC0,0x01,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x80},// 	;141 (?) gro�es gr��er als

        						 {0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x00,0x60,0x03,0x7F,0x1F,0x7F,0x7C,
								  0x40,0x60,0x20,0x7C,0x7F,0x1F,0x7F,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;142 (�) � Volt per Division
								
        						 {0x00,0x00,0x7F,0x03,0x7F,0x1F,0x1C,0x7C,0x36,0x60,0x63,0x7C,0x41,0x1F,
								  0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;143 (?) kilo Volt per Division
								
        						 {0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x30,0x60,0x3C,0x7F,0x0F,0x7F,0x0B,
								  0x40,0x0F,0x20,0x3C,0x7F,0x30,0x7F,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;144 (?) � Ampere per Division
								
        						 {0x00,0x00,0x7F,0x30,0x7F,0x3C,0x02,0x0F,0x01,0x0B,0x7F,0x0F,0x7F,0x3C,
								  0x02,0x30,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;145 (�) milli Ampere per Division
								
        						 {0x00,0x10,0x00,0x1E,0xC0,0x0F,0xF8,0x03,0x3E,0x03,0x06,0x03,0x3E,0x03,
								  0xF8,0x03,0xC0,0x0F,0x00,0x1E,0x00,0x10,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;146 (�) Ampere per Division
								
        						 {0x00,0x00,0x7F,0x30,0x7F,0x3C,0x1C,0x0F,0x36,0x0B,0x63,0x0F,0x41,0x3C,
								  0x00,0x30,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //    ;147 (�) kilo Ampere per Division

        						 {0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x03,0xFF,0x03,0x03,0x00,0x03,0x00,
								  0xF3,0x1F,0xE0,0x0F,0xC0,0x07,0x80,0x03,0x00,0x01,0x00,0x00,0x00,0x80}, //    ;148 (�) Trigger Sign

        						 {0x08,0x00,0x0C,0x00,0x0E,0x00,0xFF,0x01,0xFF,0x01,0x0E,0x00,0x0C,0x00,
								  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //    ;149 (�) Overvoltage
								
        						 {0x20,0x00,0x60,0x00,0xE0,0x00,0xFF,0x01,0xFF,0x01,0xE0,0x00,0x60,0x00,
								  0x20,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;150 (�) Undervoltage

        						 {0xC6,0x00,0xE7,0x00,0xF3,0x00,0xFB,0x00,0xDF,0x00,0xCE,0x00,0x00,0x00,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								      /*
        						 {0x66,0x00,0x73,0x00,0x7B,0x00,0x6F,0x00,0x66,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								     */
                                  /*
        						 {0x42,0x00,0x61,0x00,0x51,0x00,0x49,0x00,0x46,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								 */
								  
								  //    ;152 (�)
								  //    ;153 (�)
								  //    ;154 (�)
								  //    ;155 (�)
								  //    ;156 (�)
								  //    ;157 (?)
								  //    ;158 (�)
								  //    ;159 (�)
								  //    ;160 ( )

unsigned char bitbmBigArrowUp[] = { 32, 13,
								0x00, 0x01, 0x00, 0x00,
								0x00, 0x07, 0xC0, 0x00,
								0x00, 0x1F, 0xF0, 0x00,
								0x00, 0x7F, 0xFC, 0x00,
								0x01, 0xFF, 0xFF, 0x00,
								0x07, 0xFF, 0xFF, 0xC0, 
								0x1F, 0xFF, 0xFF, 0xF0,
								0x7F, 0xFF, 0xFF, 0xFC, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x0F, 0xE0, 0x00,
								0x00, 0x1F, 0xF0, 0x00,
								0x00, 0x3F, 0xF8, 0x00};
					

unsigned char bitbmBigArrowDown[] = { 32, 13,
								0x00, 0x3F, 0xF8, 0x00, 
								0x00, 0x1F, 0xF0, 0x00, 
								0x00, 0x0F, 0xE0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x7F, 0xFF, 0xFF, 0xFC, 
								0x1F, 0xFF, 0xFF, 0xF0, 
								0x07, 0xFF, 0xFF, 0xC0, 
								0x01, 0xFF, 0xFF, 0x00, 
								0x00, 0x7F, 0xFC, 0x00, 
								0x00, 0x1F, 0xF0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x01, 0x00, 0x00};
						
unsigned char bitbmCycleArrow[] = { 16, 14,
								0x00, 0x60, 
								0x10, 0x70, 
								0x10, 0x18, 
								0x38, 0x0C, 
								0x38, 0x06, 
								0x7C, 0x06, 
								0x7C, 0x06, 
								0xFE, 0x06, 
								0xFE, 0x06, 
								0x38, 0x06, 
								0x38, 0x0C, 
								0x1C, 0x18, 
								0x07, 0xF0, 
								0x01, 0xE0};
						
unsigned char bitbmSelectCycleArrow[] = { 24, 14, 
								0x00, 0x06, 0x00, 
								0x10, 0x17, 0x00, 
								0x10, 0x11, 0x80, 
								0x38, 0x38, 0xC0, 
								0x38, 0x38, 0x60, 
								0x7C, 0x7C, 0x60, 
								0x7C, 0x7C, 0x60, 
								0xFE, 0xFE, 0x60, 
								0xFE, 0xFE, 0x60, 
								0x38, 0x00, 0x60, 
								0x38, 0x00, 0xC0, 
								0x1C, 0x01, 0x80, 
								0x07, 0xFF, 0x00, 
								0x01, 0xFE, 0x00};
										
unsigned char bitbmTimebaseOffset[] = { 16, 12, 
								0x07, 0xFF, 
								0x07, 0xFF, 
								0x07, 0xFF, 
								0x07, 0x00, 
								0x07, 0x00, 
								0x07, 0x00, 
								0x7F, 0xF0, 
								0x3F, 0xE0, 
								0x1F, 0xC0, 
								0x0F, 0x80, 
								0x07, 0x00, 
								0x02, 0x00};
										
unsigned char bitbmSubMenu[] = { 40, 13, 
								 0x00, 0x00, 0x00, 0x10, 0x00, 
								 0x00, 0x00, 0x00, 0x18, 0x00, 
								 0x00, 0x00, 0x00, 0x1C, 0x00, 
								 0x00, 0x17, 0x3C, 0xFE, 0x00, 
								 0x00, 0x13, 0x9E, 0x7F, 0x00, 
								 0x46, 0x39, 0xCF, 0x3F, 0x80, 
								 0xEF, 0x7C, 0xE7, 0x9F, 0xC0, 
								 0x46, 0x39, 0xCF, 0x3F, 0x80, 
								 0x00, 0x13, 0x9E, 0x7F, 0x00, 
								 0x00, 0x17, 0x3C, 0xFE, 0x00, 
								 0x00, 0x00, 0x00, 0x1C, 0x00, 
								 0x00, 0x00, 0x00, 0x18, 0x00, 
								 0x00, 0x00, 0x00, 0x10, 0x00};						

// BF added new GND symbol on the left side
unsigned char bitbm_GND[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								//GND symbol
								0x02, 0x00,
								0x0F, 0x90,
								0x00, 0x10,
								0x07, 0x00,
								0x00, 0x00,						
								0x02, 0x00};


// BF corrected channel 1 sign
unsigned char bitbmCH1[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x00,
								0x03, 0x00,
								0x05, 0x00,
								0x01, 0x00,
								0x01, 0x00,						
								0x01, 0x10,
								0x01, 0x18,
								0x00, 0x1C,
								0x07, 0xFE,//0x03, 0xFE, middle
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};

// BF corrected ground sign on the right side							
unsigned char bitbmCH1_gnd[] = { 16, 29,
								0x00, 0x00,
								0x00, 0x20,
								0x00, 0x60,
								0x00, 0xA0,
								0x00, 0x20,
								0x00, 0x20,	
								0x08, 0x20,
								0x18, 0x20,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
/* BF -> not used at this time								
unsigned char bitbmCH1_XY[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x10,
								0x02, 0x38,
								0x06, 0x7C,
								0x0A, 0xFE,
								0x02, 0x10,						
								0x02, 0x10,
								0x02, 0x10,
								0x02, 0x7C,
								0x00, 0x00,
								0x00, 0x38,
								0x00, 0x00,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};	
*/							
// BF corrected channel 2 sign
unsigned char bitbmCH2[] = { 16, 16,
								0x00, 0x00,
								0x07, 0x00,
								0x08, 0x80,
								0x00, 0x80,
								0x01, 0x00,
								0x02, 0x00,						
								0x04, 0x10,
								0x0F, 0x98,
								0x00, 0x1C,
								0x07, 0xFE,
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};
// BF corrected ground sign on the right side									
unsigned char bitbmCH2_gnd[] = { 16, 29,
								0x00, 0x00,
								0x01, 0xE0,
								0x00, 0x10,
								0x00, 0x10,
								0x00, 0x20,
								0x00, 0x40,						
								0x08, 0x80,
								0x19, 0xF0,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
// BF corrected channel 3 sign
unsigned char bitbmCH3[] = { 16, 16,
								0x00, 0x00,
								0x07, 0x00,
								0x08, 0x80,
								0x00, 0x80,
								0x03, 0x00,
								0x00, 0x80,						
								0x08, 0x90,
								0x07, 0x98,
								0x00, 0x1C,
								0x07, 0xFE,
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};
// BF corrected ground sign on the right side	
unsigned char bitbmCH3_gnd[] = { 16, 29,
								0x00, 0x00,
								0x00, 0xE0,
								0x01, 0x10,
								0x00, 0x10,
								0x00, 0x60,
								0x00, 0x10,						
								0x09, 0x10,
								0x18, 0xE0,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
// BF corrected channel 4 sign
unsigned char bitbmCH4[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x80,
								0x02, 0x80,
								0x04, 0x80,
								0x08, 0x80,
								0x0F, 0xC0,						
								0x00, 0x90,
								0x00, 0x98,
								0x00, 0x1C,
								0x07, 0xFE,
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};
// BF corrected ground sign on the right side	
unsigned char bitbmCH4_gnd[] = { 16, 29,
								0x00, 0x00,
								0x00, 0x60,
								0x00, 0xA0,
								0x01, 0x20,
								0x02, 0x20,
								0x03, 0xF0,						
								0x08, 0x20,
								0x18, 0x20,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
						
unsigned char bitbmMin[] = { 16, 16,
								0x01, 0x00,
								0x01, 0x00,
								0x03, 0x80,
								0x03, 0x80,
								0x07, 0xC0,
								0x07, 0xC0,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
                                						
unsigned char bitbmMax[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x07, 0xC0,
								0x07, 0xC0,
								0x03, 0x80,
								0x03, 0x80,
								0x01, 0x00,
								0x01, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};

// BF corrected trigger symbol	
unsigned char bitbmTrigger[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x10,
								0x7C, 0x18,
								0x10, 0x1C,
								0x17, 0xFE,
								0x10, 0x1C,
								0x10, 0x18,
								0x10, 0x10,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
/*	
unsigned char bitbmTrigger[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x7C, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
*/
unsigned char bitbmTrigAVG[] = { 16, 16,
								0x00, 0x40,
								0x0E, 0x80,
								0x11, 0x00,
								0x22, 0x80,
								0x24, 0x80,
								0x28, 0x80,
								0x11, 0x10,
								0x2E, 0x18,
								0x40, 0x1C,
								0x07, 0xFE,
								0x7C, 0x1C,
								0x10, 0x18,
								0x10, 0x10,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00};
                                                                						
unsigned char bitbmCoppAC[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00, 
								0x30, 0x00, 
								0x10, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 								
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};

// BF corrected DC sign								
unsigned char bitbmCoppDC[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00, 
								0x30, 0x00, 
								0x10, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
// BF corrected DC/INV sign								
unsigned char bitbmCoppInv[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00,
								0x30, 0x00,
								0x10, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,                                 								
								0x00, 0x00};								
// BF corrected DC/BW sign
unsigned char bitbmCoppLimit[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00,
								0xFF, 0xF8,//0xFF, 0xC0,
								0x70, 0x00,
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
                                   						
unsigned char bitbmCoppACInv[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00,
								0x30, 0x00,
								0x10, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,                                 								
								0x00, 0x00};                                   						
						
unsigned char bitbmCoppACLimit[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0,
								0x70, 0x00, 
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,                                 								
								0x00, 0x00};								
// BF corrected DC/INV/BW sign						
unsigned char bitbmCoppInvLimit[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0,
								0x70, 0x00,
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,                                 								
								0x00, 0x00};								
								
														
unsigned char bitbmCoppFull[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00,
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,
								0x00, 0x00};								
							
unsigned char bitbmStopTrigger[] = { 24, 17,
								0x00, 0x7F, 0x00,
								0x00, 0x80, 0x80,
								0x01, 0x7F, 0x40,
								0x02, 0xFF, 0xA0,
								0x05, 0xFF, 0xD0,
								0x0B, 0xFF, 0xE8,
								0x14, 0x8B, 0x34,
								0x15, 0xD5, 0x54,
								0x14, 0xD5, 0x34,
								0x16, 0xD5, 0x74,
								0x14, 0xDB, 0x74,
								0x0B, 0xFF, 0xE8,
								0x05, 0xFF, 0xD0,
								0x02, 0xFF, 0xA0,
								0x01, 0x7F, 0x40,
								0x00, 0x80, 0x80,
								0x00, 0x7F, 0x00};

/*BF not used							
unsigned char bitbmStopTrigger_stop[] = { 24, 5,
								0x03, 0x74, 0xE0,
								0x02, 0x2A, 0xA0,
								0x03, 0x2A, 0xE0,
								0x01, 0x2A, 0x80,
								0x03, 0x24, 0x80};										
*/
unsigned char bitbmWTAG[] =    {88, 87,
								0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00,
								0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
								0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
								0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xC0, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xE0, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x0F, 0xFF, 0xF0, 0x00,
								0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xF8, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFC, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFE, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0x80,
								0x00, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0x03, 0x81, 0xFF, 0xFF, 0xC0,
								0x01, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0x0F, 0xE0, 0xFF, 0xFF, 0xC0,
								0x03, 0xFC, 0x1F, 0xFF, 0xFF, 0xFE, 0x1F, 0xE0, 0xFF, 0xFF, 0xE0,
								0x07, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x1F, 0xF0, 0xFF, 0xFF, 0xE0,
								0x07, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0xFF, 0xFF, 0xF0,
								0x0F, 0xFF, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0x7F, 0xFF, 0xF0,
								0x0F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFC, 0x7F, 0xF8, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFC, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFE, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0x7F, 0xFF, 0xFC,
								0x3F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xC7, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xF3, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xC7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
								0x7F, 0xFF, 0xF9, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xE3, 0xFF, 0xFE,
								0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x3F, 0xFF, 0xFE, 0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x3F, 0xFF, 0xFE, 0x7F, 0xFF, 0x1F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x1F, 0xFF, 0xFE, 0x7F, 0xFF, 0x3F, 0xFF, 0xFF, 0xF1, 0xFF, 0xFC,
								0x1F, 0xFF, 0xFE, 0x3F, 0xFF, 0x3F, 0xFF, 0xFF, 0xF0, 0xFF, 0xF8,
								0x1F, 0xFF, 0xFE, 0x3F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0xFF, 0xF8,
								0x0F, 0xFF, 0xFE, 0x3F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0xFF, 0xF8,
								0x0F, 0xFF, 0xFF, 0x1F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0x7F, 0xF0,
								0x0F, 0xFF, 0xFF, 0x0F, 0xFC, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xF0,
								0x07, 0xFF, 0xFF, 0x0F, 0xFC, 0x7F, 0xFF, 0xFF, 0xFC, 0x3F, 0xE0,
								0x07, 0xFF, 0xFF, 0x87, 0xF8, 0x7F, 0xFF, 0xFF, 0xFC, 0x3F, 0xE0,
								0x03, 0xFF, 0xFF, 0x83, 0xF0, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xC0,
								0x01, 0xFF, 0xFF, 0x81, 0xE0, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0x80,
								0x01, 0xFF, 0xFF, 0x80, 0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
								0x00, 0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x7F, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x3F, 0xFF, 0xE0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x1F, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x0F, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
								0x00, 0x07, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
								0x00, 0x03, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
								0x00, 0x01, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
								0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
								0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
								0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00};







// ===========================================================
// Parameters for Each Peripheral, Excerpted From The PTF File



// ------------------
// Parameters for altera_nios named cpu

// CPU_Architecture     = nios_32             
// mstep                = 1                   
// multiply             = 0                   
// rom_decoder          = 1                   
// wvalid_wr            = 0                   
// num_regs             = 256                 
// do_generate          = 1                   
// include_debug        = 0                   
// include_trace        = 0                   
// reset_slave          = boot_monitor_rom/s1 
// reset_offset         = 0x0                 
// vecbase_slave        = ext_ram/s1          
// vecbase_offset       = 0x03ff00            
// support_interrupts   = 1                   
// implement_forward_b1 = 0                   
// support_rlc_rrc      = 0                   
// advanced             = 1                   
// CONSTANTS            = 
// mainmem_slave        = ext_ram/s1          
// datamem_slave        = ext_ram/s1          
// maincomm_slave       = uart1/s1            
// debugcomm_slave      = uart2_debug/s1      
// germs_monitor_id     = std_32_2.0          


// ------------------
// Parameters for altera_avalon_onchip_memory named boot_monitor_rom

// Writeable              = 0     
// Size_Value             = 1     
// Size_Multiple          = 1024  
// Contents               = blank 
// Shrink_to_fit_contents = 0     
// CONTENTS               = srec  


// ------------------
// Parameters for altera_avalon_uart named uart1

// baud             = 115200   
// data_bits        = 8        
// fixed_baud       = 1        
// parity           = N        
// stop_bits        = 2        
// use_cts_rts      = 0        
// use_eop_register = 0        
// sim_true_baud    = 0        
// sim_char_stream  = g40000\n 


// ------------------
// Parameters for altera_avalon_pio named seven_seg_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named speed_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// capture   = 0    
// edge_type = NONE 
// irq_type  = NONE 


// ------------------
// Parameters for altera_avalon_timer named timer1

// always_run           = 0     
// fixed_period         = 0     
// snapshot             = 1     
// period               = 1     
// period_units         = msec  
// reset_output         = 0     
// timeout_pulse_output = 0     
// mult                 = 0.001 


// ------------------
// Parameters for altera_avalon_pio named led_pio

// has_tri   = 1    
// has_out   = 0    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named button_pio

// has_tri   = 0    
// has_out   = 0    
// has_in    = 1    
// edge_type = ANY  
// irq_type  = EDGE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named lcd_pio

// has_tri   = 1    
// has_out   = 0    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named direction_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// capture   = 0    
// edge_type = NONE 
// irq_type  = NONE 


// ------------------
// Parameters for altera_avalon_uart named uart2_debug

// baud             = 115200 
// data_bits        = 8      
// fixed_baud       = 1      
// parity           = N      
// stop_bits        = 1      
// use_cts_rts      = 0      
// use_eop_register = 0      
// sim_true_baud    = 0      
// sim_char_stream  = 


// ------------------
// Parameters for altera_nios_dev_board_sram32 named ext_ram

// sram_memory_size  = 256  
// sram_memory_units = 1024 
// sram_data_width   = 32   
// CONTENTS          = srec 


// ------------------
// Parameters for altera_nios_dev_board_flash named ext_flash

// CONTENTS = srec 


// end of file


/* BF
//Macros defined in CDK -> Excalibur

#define nm_mult(_x,_y) ({\
	int __x = (_x), __y = (_y);\
	asm volatile("usr0 %0,%2 ; does mult" \
	: "=r" (__x) \
	: "0" (__x), "r" (__y));\
	__x;\
	})


#define nm_math(_x,_y) ({\
	int __x = (_x), __y = (_y);\
	asm volatile("mov %%r0,%2\n\tusr1 %0 ; does math" \
	: "=r" (__x) \
	: "0" (__x), "r" (__y));\
	__x;\
	})



#define nm_math_pfx(_p,_x,_y) ({\
	int __x = (_x), __y = (_y);\
	asm volatile("mov %%r0,%2\n\tpfx " #_p "\n\tusr1 %0 ; does math" \
	: "=r" (__x) \
	: "0" (__x), "r" (__y));\
	__x;\
	})


*/
