
#include "floatstr_t.h"
#include <stdio.h>

#define Space			32

#define S_Slash 		127
#define S_uV 			142
#define S_mV 			128
#define S_V  			129	
#define S_kV  			143	
#define S_uA 			144
#define S_mA 			145
#define S_A  			146	
#define S_kA 			147
#define S_nS 			130	
#define S_uS 			131	
#define S_mS 			132
#define S_S  			133
#define Ground_Sign		134
#define Text_Count_Dot		135
#define Zero_Level_Sym		136
#define Menu_Select		137

#define Pos_Pulse		138
#define Neg_Pulse		139
#define Big_Smaller		140
#define Big_Bigger		141

#define Trigger_Sign		148
#define OverVolt_Sign		149
#define UnderVolt_Sign		150
#define Square_Sign    		151

#define PI 3.14159265358979323

#define	STX			0x02
#define	ETX			0x03

#define SPI_DELAY16     175     // >150 us for shifting out a 16 bit value 

// BF insert
//#define FFT_LENGTH 		1024 //512  	 	// number of digitized values
//#define FFT_LEVEL 		10   //9         	// number of butterfly levels 10 = ld(1024)
#define FFT_OFF			0		// FFT mode - not active
#define FFT_MAGN		1		// FFT mode - Magnitude in linear division
#define FFT_PHAS		2		// FFT mode - Phase
#define FFT_REAL		3		// FFT mode - Real part
#define FFT_IMAG		4		// FFT mode - Imaginary part
#define FFT_REIM		5		// FFT mode - Real + Imaginary
#define FFT_PWSP		6		// FFT mode - Power Spectrum in logarithmic division
#define FFT_PWDN		7		// FFT mode - Power Density Spectrum in logarithmic division

#define FFT_512			512
#define FFT_1024		1024
#define FFT_INTFACT		1024	//256

#define MATH_OFF		0		// MATH mode - not active
#define MATH_FFT		1		// MATH mode - FFT
#define MATH_MUL		2		// MATH mode - multiply
#define MATH_SUB		3		// MATH mode - subtract
#define MATH_ADD		4		// MATH mode - add

#define DRAW_FAST		292		// Draw Mode - fast pixel connection
#define DRAW_ACC		293		// Draw Mode - accurate line function with Bresenham algorithm
#define DRAW_PIX		294		// Draw Mode - pixel only

#define SQRT_PREC		10
#define SQRT_ITER		42      	// Max iterations
#define SQRT_EPS		1       	// Precision

#define USTB_OFF		0		// USTB mode - not active
#define USTB_ROLL		284		// USTB mode - roll mode
#define USTB_SHIFT		286		// USTB mode - shift mode
#define USTB_FORWARD		0		// USTB direction - forward
#define USTB_REVERSE		1		// USTB direction - reverse 
#define USTB_PERM		288		// USTB display mode - permanent
#define USTB_STEP		289		// USTB display mode - stepwise 
#define USTB_8KB		296		// USTB buffer size
#define USTB_16KB		297		// USTB buffer size
#define USTB_32KB		298		// USTB buffer size

#define TRIG_AUTO		92
#define TRIG_NORM		93
#define TRIG_COMB		94

#define TRIG_EDGE		1
#define TRIG_PULS		2
#define TRIG_PATT		3

#define ADD_ON			234

#define AVRG_OFF		254



#define FILT_OFF		311
#define PRO			1
#define IIR			2
#define FIR			3




#define LOGA_OFF		340
#define LOGA_TTL		341
#define LOGA_CMOS		342
#define LOGA_LVTTL		343
#define LOGA_CM25		344
#define LOGA_CM18		345
#define LOGA_RS232		346

#define OFF			0
#define ON			1

#define BTN_STOP		37
#define BTN_SINGLE		38
#define BTN_OFF			240
#define BTN_ON			241
#define INACTIVE		246
#define NONE			91

#define GRID_HEIGHT		400
#define GRID_ZERO		GRID_HEIGHT/2
#define GRID_WIDTH		600
#define GRID_XY			400
#define GRID_XY_XOFFS		120
#define GRID_XOFFS		20
#define GRID_YOFFS		20
#define GRID_XOFFS_FFT		3	// BF 64
#define GRID_YOFFS_FFT		20
#define GRID_HEIGHT_FFT		400
#define GRID_WIDTH_FFT		512
#define TOP_PLANE_MIN		0
#define TOP_PLANE_MAX		360
#define GRID_PLANE_MIN		360	//400	//380
#define GRID_PLANE_MAX		8480	//8440	//8500	//8120
#define BOTT_PLANE_MIN		8480	//8500	//8140
#define BOTT_PLANE_MAX		9600
#define SCR_PLANE_MIN		0
#define SCR_PLANE_MAX		9600

//#define MEMSTARTOFFS		100
#define ADC_ZERO		128	//ADC zero position
// BF insert end

//BF insert definitions by Stefan for menu structure

#define MENU_ACQUIRE 		0 
#define MENU_CHANNEL1 		1 
#define MENU_CHANNEL2 		2 
#define MENU_CHANNEL3 		3 
#define MENU_CHANNEL4 		4 
#define MENU_DISPLAY 		5 
#define MENU_UTILITY 		6 
#define MENU_SERVICE 		7 
#define MENU_SAVE 		8 
#define MENU_DISPL_SETUP 	9 
#define MENU_TIMEBASE 		10 
#define MENU_TRIGGERMODE 	12
#define MENU_TRIGGERSUB		13 
#define MENU_TRIGGEREDGE 	14 
#define MENU_PULSEWIDTH 	15 
#define MENU_CURSOR 		16 
#define MENU_QUICKPRINT 	17 
#define MENU_HARDWARE 		18 
#define MENU_QUICKMEASURE 	19 
#define MENU_QMDELAY 		20 
#define MENU_QMPHASE  		21 
#define MENU_QMTHRESHOLDS 	22 
#define MENU_AUTOSCALE 		23 
#define MENU_TRIGGERTV 		24 
#define MENU_EXTUTILS 		25 
#define MENU_MATH 		26 
#define MENU_FFT 		27 
#define MENU_DISPL_FFT 		28 
#define MENU_MATHSETTINGS 	29 
#define MENU_USTB		30 
#define MENU_QP_USB		31 

#define BLOCKSIZE 2048			// KB screenshot export function

#define DAC_MIDSCALE		32768	//Midscale of 16 Bit DAC

//BF insert end

#define Protected_Config_Flash			(unsigned long *)	0x000F0000
#define SAVE_SIGNAL_NR_A01			(unsigned long *)	0x00100000
#define SAVE_SIGNAL_NR_A02			(unsigned long *)	0x00110000
#define SAVE_SIGNAL_NR_A03			(unsigned long *)	0x00120000
#define SAVE_SIGNAL_NR_A04			(unsigned long *)	0x00130000
#define SAVE_SIGNAL_NR_A05			(unsigned long *)	0x00140000
#define SAVE_SIGNAL_NR_A06			(unsigned long *)	0x00150000
#define SAVE_SIGNAL_NR_A07			(unsigned long *)	0x00160000
#define SAVE_SIGNAL_NR_A08			(unsigned long *)	0x00170000
#define SAVE_SIGNAL_NR_A09			(unsigned long *)	0x00180000
#define SAVE_SIGNAL_NR_A10			(unsigned long *)	0x00190000
#define SAVE_SIGNAL_NR_A11			(unsigned long *)	0x001A0000
#define SAVE_SIGNAL_NR_A12			(unsigned long *)	0x001B0000
#define SAVE_SIGNAL_NR_A13			(unsigned long *)	0x001C0000
#define SAVE_SIGNAL_NR_A14			(unsigned long *)	0x001D0000
#define SAVE_SIGNAL_NR_A15			(unsigned long *)	0x001E0000
#define SAVE_SIGNAL_NR_A16			(unsigned long *)	0x001F0000
#define SAVE_SIGNAL_NR_B01			(unsigned long *)	0x00200000
#define SAVE_SIGNAL_NR_B02			(unsigned long *)	0x00210000
#define SAVE_SIGNAL_NR_B03			(unsigned long *)	0x00220000
#define SAVE_SIGNAL_NR_B04			(unsigned long *)	0x00230000
#define SAVE_SIGNAL_NR_B05			(unsigned long *)	0x00240000
#define SAVE_SIGNAL_NR_B06			(unsigned long *)	0x00250000
#define SAVE_SIGNAL_NR_B07			(unsigned long *)	0x00260000
#define SAVE_SIGNAL_NR_B08			(unsigned long *)	0x00270000
#define SAVE_SIGNAL_NR_B09			(unsigned long *)	0x00280000
#define SAVE_SIGNAL_NR_B10			(unsigned long *)	0x00290000
#define SAVE_SIGNAL_NR_B11			(unsigned long *)	0x002A0000
#define SAVE_SIGNAL_NR_B12			(unsigned long *)	0x002B0000
#define SAVE_SIGNAL_NR_B13			(unsigned long *)	0x002C0000
#define SAVE_SIGNAL_NR_B14			(unsigned long *)	0x002D0000
#define SAVE_SIGNAL_NR_B15			(unsigned long *)	0x002E0000
#define SAVE_SIGNAL_NR_B16			(unsigned long *)	0x002F0000
#define SAVE_SIGNAL_NR_C01			(unsigned long *)	0x00300000
#define SAVE_SIGNAL_NR_C02			(unsigned long *)	0x00310000
#define SAVE_SIGNAL_NR_C03			(unsigned long *)	0x00320000
#define SAVE_SIGNAL_NR_C04			(unsigned long *)	0x00330000
#define SAVE_SIGNAL_NR_C05			(unsigned long *)	0x00340000
#define SAVE_SIGNAL_NR_C06			(unsigned long *)	0x00350000
#define SAVE_SIGNAL_NR_C07			(unsigned long *)	0x00360000
#define SAVE_SIGNAL_NR_C08			(unsigned long *)	0x00370000
#define SAVE_SIGNAL_NR_C09			(unsigned long *)	0x00380000
#define SAVE_SIGNAL_NR_C10			(unsigned long *)	0x00390000
#define SAVE_SIGNAL_NR_C11			(unsigned long *)	0x003A0000
#define SAVE_SIGNAL_NR_C12			(unsigned long *)	0x003B0000
#define SAVE_SIGNAL_NR_C13			(unsigned long *)	0x003C0000
#define SAVE_SIGNAL_NR_C14			(unsigned long *)	0x003D0000
#define SAVE_SIGNAL_NR_C15			(unsigned long *)	0x003E0000
#define SAVE_SIGNAL_NR_C16			(unsigned long *)	0x003F0000
#define SAVE_SIGNAL_NR_D01			(unsigned long *)	0x00400000
#define SAVE_SIGNAL_NR_D02			(unsigned long *)	0x00410000
#define SAVE_SIGNAL_NR_D03			(unsigned long *)	0x00420000
#define SAVE_SIGNAL_NR_D04			(unsigned long *)	0x00430000
#define SAVE_SIGNAL_NR_D05			(unsigned long *)	0x00440000
#define SAVE_SIGNAL_NR_D06			(unsigned long *)	0x00450000
#define SAVE_SIGNAL_NR_D07			(unsigned long *)	0x00460000
#define SAVE_SIGNAL_NR_D08			(unsigned long *)	0x00470000
#define SAVE_SIGNAL_NR_D09			(unsigned long *)	0x00480000
#define SAVE_SIGNAL_NR_D10			(unsigned long *)	0x00490000
#define SAVE_SIGNAL_NR_D11			(unsigned long *)	0x004A0000
#define SAVE_SIGNAL_NR_D12			(unsigned long *)	0x004B0000
#define SAVE_SIGNAL_NR_D13			(unsigned long *)	0x004C0000
#define SAVE_SIGNAL_NR_D14			(unsigned long *)	0x004D0000
#define SAVE_SIGNAL_NR_D15			(unsigned long *)	0x004E0000
#define SAVE_SIGNAL_NR_D16			(unsigned long *)	0x004F0000
#define SAVE_SIGNAL_NR_E01			(unsigned long *)	0x00500000
#define SAVE_SIGNAL_NR_E02			(unsigned long *)	0x00510000
#define SAVE_SIGNAL_NR_E03			(unsigned long *)	0x00520000
#define SAVE_SIGNAL_NR_E04			(unsigned long *)	0x00530000
#define SAVE_SIGNAL_NR_E05			(unsigned long *)	0x00540000
#define SAVE_SIGNAL_NR_E06			(unsigned long *)	0x00550000
#define SAVE_SIGNAL_NR_E07			(unsigned long *)	0x00560000
#define SAVE_SIGNAL_NR_E08			(unsigned long *)	0x00570000
#define SAVE_SIGNAL_NR_E09			(unsigned long *)	0x00580000
#define SAVE_SIGNAL_NR_E10			(unsigned long *)	0x00590000
#define SAVE_SIGNAL_NR_E11			(unsigned long *)	0x005A0000
#define SAVE_SIGNAL_NR_E12			(unsigned long *)	0x005B0000
#define SAVE_SIGNAL_NR_E13			(unsigned long *)	0x005C0000
#define SAVE_SIGNAL_NR_E14			(unsigned long *)	0x005D0000
#define SAVE_SIGNAL_NR_E15			(unsigned long *)	0x005E0000
#define SAVE_SIGNAL_NR_E16			(unsigned long *)	0x005F0000

#define TABLES_Flash				(unsigned long *)	0x006B0000
#define WTAG_Logo_Half_Flash			(unsigned long *)	0x006C0000
#define WTAG_Logo            			(unsigned long *)	0x006D0000
#define UI_Plane1_Flash				(unsigned long *)	0x006E0000
// BF unused #define UI_Plane2_Flash				(unsigned long *)	0x006F0000
// BF unused #define UI_Plane3_Flash				(unsigned long *)	0x00700000
// BF unused #define UI_Plane4_Flash				(unsigned long *)	0x00710000
// BF unused #define UI_Plane5_Flash				(unsigned long *)	0x00720000
// BF unused #define Channel_Plane1_Flash			(unsigned long *)	0x00730000
// BF unused #define Channel_Plane2_Flash			(unsigned long *)	0x00740000
// BF unused #define Channel_Plane3_Flash			(unsigned long *)	0x00750000
// BF unused #define Channel_Plane4_Flash			(unsigned long *)	0x00760000
// BF unused #define Channel_Math_Plane_Flash		(unsigned long *)	0x00770000
// BF unused #define Memory_Plane1_Flash			(unsigned long *)	0x00780000
// BF unused #define Memory_Plane2_Flash			(unsigned long *)	0x00790000
// BF unused #define Memory_Plane3_Flash			(unsigned long *)	0x007A0000
// BF unused #define Marker_Plane1_Flash			(unsigned long *)	0x007B0000
// BF unused #define Marker_Plane2_Flash			(unsigned long *)	0x007C0000
#define ProtBackup_Flash			(unsigned long *)	0x007D0000
#define ConfBackup_Flash			(unsigned long *)	0x007E0000	// BF #010
#define Config_Flash				(unsigned long *)	0x007F0000

#define adc1      				(unsigned long *)	0x00A00000
#define adc2      				(unsigned long *)	0x00A00010
#define adc3      				(unsigned long *)	0x00A00020
#define adc4      				(unsigned long *)	0x00A00030



// Constants
extern unsigned long tc_varstart ;;		// Kennung Varstart
extern unsigned long tc_version ;;		// Factory version 			//BF changed
extern unsigned long tc_subversion ;;		// Factory subversion 			//BF changed
extern unsigned long tc_dev_version ;;		// Developer version			//BF changed
extern unsigned long tc_dev_subversion ;;	// Developer subversion			//BF changed
extern char	     tc_compilation[20];
extern unsigned long tc_hw_sw_version ;;	// Type 		0 ;
extern unsigned long tc_hw_version ;;		// Version 		0 // Var to read hardware version
extern unsigned long tc_model ;;		// 2012, 2022 ...
extern unsigned long tc_serial ;;		// 1
extern unsigned long tc_production_lot1 ;;	// E
extern unsigned long tc_production_lot2 ;;	// E
extern unsigned long tc_shipment_date ;;	// 2C7

extern const unsigned char  C_GROUND_SIGN	;;
extern const unsigned char  C_MENU_SELECT_SIGN	;;

extern const unsigned char btnUnpushed		;;
extern const unsigned char btnPushed 		;;
extern const unsigned char btnDraw			;;
extern const unsigned char btnRemove 		;;
extern const unsigned long BitMasks[32] ;
extern const unsigned long BitMasks2[32] ;
// Constants
extern const int DrawOffsetX ;;									// Draw Offset from Left
extern const int DrawOffsetY ;;									// Draw Offset from Top
extern const int DrawXYOffsetX1 ;;								// Draw Offset from Top
extern const int DrawXYOffsetX2 ;;								// Draw Offset from Left
extern int PreReg_Offset ;;									// Signal Offset , half Signal

extern const int CH1OffsetX ;;									// Draw Offset from Left
extern const int CH2OffsetX ;;									// Draw Offset from Left
extern const int CH3OffsetX ;;									// Draw Offset from Left
extern const int CH4OffsetX ;;									// Draw Offset from Left
//extern const int correction ;;  //18;								// Draw Correction for the Signals
//extern const int timerAutoFreefirst ;;								// Trigger Auto Timer 100 ms -> wird array der timebases
//extern const int timerAutoFreefast  ;;								// Trigger Auto Timer 10 ms
extern unsigned long timer_counter_value ;;
extern unsigned long timer_counter_max ;;
extern int timer_reload_low ;;
extern int timer_reload_high ;;
//BF not used extern unsigned long timer_array_first[32];
//BF not used extern unsigned long timer_array_fast[32] ;
//extern const int timerAutoFreefirst ;;							// Trigger Auto Timer 100 ms -> wird array der timebases
//extern const int timerAutoFreefast  ;;							// Trigger Auto Timer 10 ms
extern const int TimerRotPeriod     ;;								// Rotary change timer
extern const int TimerSecPeriod     ;;								// button pushed time	

// BF add
// Constant for new ultra slow timebase mode
extern const unsigned long tb_value[36] ;;
extern const unsigned long int USTB_timer_value[11];

extern const int ExtTrigOffset[36];

extern const unsigned int predivisor[10];		//BF probe division
extern const unsigned int math_voltage_factor[2][18];; 	//BF math voltage factors
extern const int math_rescale[2][18];		// math multiplication rescaling
//extern const unsigned int math_voltage_div[18] ;; 	//BF math voltage divisor

extern unsigned char ColorPalette; 
extern const unsigned char GridColorArray[10][4] ;;
extern const unsigned int Splash_Logo_PosX ;;
extern const unsigned int Splash_Logo_PosY ;;
extern const unsigned int Splash_Data_PosX ;;
extern const unsigned int Splash_Data_PosY ;;

//-----------------------------------------------------
//		filter
extern unsigned char FilterType;					// type of noise filter

//-----------------------------------------------------


//BF del extern const short SignalStartStop[36][2];
//BF del #023 extern const short SignalSize[34];
extern int SignalMemSize;			//BF #023
extern int MemStartOffs;
extern int MemoryEnd;
extern int TrigPosMax;

extern const float ZoomFactorTable[36];;
extern const char Dm_Sel_Tb_End[26];;		//BF #003
extern float ZoomFactor;
extern float ZoomFactor_old;
extern float ZoomFactorDel;
//extern const float OffsetFactorTable[36];
//extern float OffsetFactor;


//extern const float PreTrigger_Offset_Table[32][5];
extern const short Zoom_Index_Table[32][5] ;
extern const int ExtTriggerLevel[103] ;		//BF #019
extern const float ExtTriggerDispl[103] ;	//BF #019
//--------------------------------------------------------------------------------------
extern unsigned char dotted_grid;				//BF switch grid
extern unsigned char FFT_grid;					//BF switch frequency div
extern unsigned char UI_request;				//flag for request on user interface
extern unsigned char QP_request;				//Quick Print request
extern unsigned char QP_mode ;					// 0->BF-version / 1->OS-version / 2->USB-Export / (remote control -> shift + T)
extern unsigned char test_signal;				//BF test signal generator
extern unsigned char CRS_Delta;					//BF delta cursor on/off
extern unsigned char AS_request;				//BF auto scale requested
extern unsigned char RC_request;				//BF signal recall requested
extern unsigned char RC_overlay;				//BF recall overlay mode active
extern unsigned char RC_user_if;				//BF flag for user interface activity in Overlay mode
extern unsigned char LA_active;

extern unsigned char ZL_changed;				//BF OnZero Channel

extern unsigned char ACQ_NewData;
extern unsigned char ACQ_Average;				//BF Average mode
extern unsigned char ACQ_ManTrigg;
//extern unsigned char ACQ_AvrgAsm;

extern unsigned char ADC_VirtualZero_CH1;
extern unsigned char ADC_VirtualZero_CH2;
extern unsigned char ADC_VirtualZero_CH3;
extern unsigned char ADC_VirtualZero_CH4;

extern unsigned char FlashPreset;				//BF Flash presetting flag

extern unsigned char UART_NewData;;
extern char UART_RXData;;
extern volatile unsigned char UART_RXFlag;			//KB Quick Print USB-export

extern	unsigned char   UartRxGuiCmd;                 		//#FW# Hardware::ISR_UART has filled UartRxGuiBuf
#define UARTRXGUISIZE   8                       		//Length of a GUI-Command
extern        unsigned char   UartRxGuiBuf[UARTRXGUISIZE];    	//#FW# Buffer for GUI-Commands
#define       MAXTIMEBASEVAL  31

extern unsigned char DrawMono;					// flag for drawing monochrome
extern unsigned char NoDisplay[4];

extern char CalSet;
extern float PreTrigger;

//only for test purposes
extern unsigned char test_sw1;					
extern unsigned char test_sw2; 					//BF for testing drawing
extern unsigned char test_sw3;					//BF for testing drawing

extern unsigned char test_channel;
extern unsigned char test_values;
extern unsigned int  test_offs_a;
extern unsigned int  test_offs_b;
//extern unsigned int  test_zero_a;
//extern unsigned int  test_zero_b;
extern unsigned int  test_div_a;
extern unsigned int  test_div_b;
//extern unsigned int  test_rel_a;
//extern unsigned int  test_rel_b;
extern unsigned int  FrameCount;
//---------------------------------------------------------------------------------------
extern unsigned long tc_test_var ;;
extern unsigned long tc_test_var2 ;;

extern unsigned char DrawSignal ;;
extern unsigned char keyboard_found ;;
extern unsigned long slope_value ;;
extern double Test_Slip;
extern int Test_Range;
extern bool Transfer_man_data;

extern double ct_vfactor_buf;
extern double ct_vfactor2_buf;


//extern double voltoff1;	
//extern double voltoff2;
extern double timeoff1;	
extern double timeoff2;

/* BF not used
extern double dcd_vfactor_buf;
extern double dcd_tfactor_buf;
*/
extern double dzp_factor_buf;

extern unsigned long *prog_flash_adr;
extern unsigned long prog_flash_adress;
extern unsigned char prog_flash_length;
extern unsigned long prog_flash_offset;
extern unsigned char Flash_Read_Buffer[1024];
extern unsigned long Flash_Protect_Buffer[256];
extern volatile unsigned char config_loaded ;;
extern unsigned char init_done ;;
extern unsigned char config_changed ;;
extern unsigned char GridColorArrayPos ;;
extern unsigned char GridColor_Val ;;
//BF not used extern unsigned char GridColor_Val_Delayed ;;
//BF not used extern unsigned char GridColorArrayPos_Delayed ;;
extern unsigned char WT_Logo_Color_Val ;;		//0x10 / 0x21 / 0x31 
//BF del extern int Testint ;;
//BF del extern long Testlong ;;
//BF del extern unsigned char Test_Mode ;;

extern unsigned char ADC_Debug_Mode ;;     // If true than printf ADC Debug information
extern unsigned char Debug_Mode ;;         // If true than printf Debug information
extern unsigned char Command_Mode ;;         // If true than printf Command information

extern unsigned char ExtraTrg_Mode ;;
//extern unsigned char Splash_drawed ;;

//extern volatile unsigned char Search_Channel ;;
extern volatile unsigned char adc_started ;;
extern volatile unsigned char AutoFreeRun ;;

extern unsigned int ctrl_reg ;;				//0x0003;
extern unsigned int adc_ctrl_reg ;;			//0;
extern unsigned int adc_del_reg ;;
extern unsigned int pre_reg ;;				//0x004C;
extern unsigned int trg_val_reg ;;			//0;
extern unsigned int trg_hyst_reg ;;			//0;
extern unsigned int ext_trg_val_reg ;;		//0;
extern unsigned int triggering ;;				//2;

extern unsigned int channel_Adr_add12 ;;		//BF renamed
extern unsigned int channel_Adr_add34 ;;		//BF renamed

extern unsigned int trg_val_CHI_reg ;;			//0;
extern unsigned int trg_val_CHII_reg ;;			//0;
extern unsigned int trg_val_CHIII_reg ;;			//0;
extern unsigned int trg_val_CHIV_reg ;;			//0;
extern unsigned int trig_range_reg ;;
extern unsigned int trig_width_reg ;;		//0;
extern unsigned long trig_holdoff_reg ;;

extern int HoldOff_Value ;;
extern int HoldOff_Expo ;;   //ns
extern int HoldOff_Steps ;;
extern int Pulse11_Value ;;
extern int Pulse11_Expo ;;   //ns
extern int Pulse11_Steps ;;
extern int Pulse12_Value ;;
extern int Pulse12_Expo ;;   //ns
extern int Pulse12_Steps ;;
extern int Pulse21_Value ;;
extern int Pulse21_Expo ;;   //ns
extern int Pulse21_Steps ;;
extern int Pulse22_Value ;;
extern int Pulse22_Expo ;;   //ns
extern int Pulse22_Steps ;;

//BF new offset calculation
extern int Math_Offset ;;
extern int Math_Mul_Offset ;;
extern int Math_Sub_Offset ;;
extern int Math_Add_Offset ;;
//BF del extern float Math_Off_Mul_Value ;;
//extern int Math_Off_Mul_Value_int ;;
//extern int Math_Off_Mul_Expo ;;   //ns
//extern float Math_Off_Mul_Steps ;;
//BF del extern float Math_Off_Sub_Value ;;
//extern int Math_Off_Sub_Value_int ;;
//extern int Math_Off_Sub_Expo ;;   //ns
//extern float Math_Off_Sub_Steps ;;
//BF del extern float Math_Off_Add_Value ;;
//extern int Math_Off_Add_Value_int ;;
//extern int Math_Off_Add_Expo ;;   //ns
//extern float Math_Off_Add_Steps ;;
extern unsigned long adc_change12_reg ;;
extern unsigned long adc_change34_reg ;;
extern unsigned long adc_ctr12_reg ;;
extern unsigned long adc_ctr34_reg ;;
//extern unsigned long ram_adress_reg ;;
//extern unsigned int test_port_reg ;;
extern unsigned int triggering_bak ;;
extern unsigned int ctrl_reg_bak ;;
extern unsigned int adc_ctrl_reg_bak ;;
extern unsigned long timebase_reg_bak ;;
extern unsigned int pre_reg_bak ;;
extern unsigned int channel_Adr_add_bak ;;
extern unsigned int trg_val_reg_bak ;;
extern unsigned int trg_hyst_reg_bak ;;
extern unsigned int trig_range_reg_bak ;;
extern unsigned long trig_holdoff_reg_bak ;;
extern unsigned int trig_width_reg_bak ;;
extern unsigned char GridColor_Val_bak ;;
extern unsigned long adc_change12_reg_bak ;;
extern unsigned long adc_change34_reg_bak ;;
extern char Selected_Voltage_CH1_bak ;;
extern char Selected_Voltage_CH2_bak ;;
extern char Selected_Voltage_CH3_bak ;;
extern char Selected_Voltage_CH4_bak ;;
extern int ZeroLevelCH1_bak ;;
extern int ZeroLevelCH2_bak ;;
extern int ZeroLevelCH3_bak ;;
extern int ZeroLevelCH4_bak ;;
extern int Virtual_ZeroLevelCH1_bak ;;
extern int Virtual_ZeroLevelCH2_bak ;;
extern int Virtual_ZeroLevelCH3_bak ;;
extern int Virtual_ZeroLevelCH4_bak ;;
//BF added
extern int ZeroLevelCH1_Main_bak ;;
extern int ZeroLevelCH2_Main_bak ;;
extern int ZeroLevelCH3_Main_bak ;;
extern int ZeroLevelCH4_Main_bak ;;
extern int Virtual_ZeroLevelCH1_Main_bak ;;
extern int Virtual_ZeroLevelCH2_Main_bak ;;
extern int Virtual_ZeroLevelCH3_Main_bak ;;
extern int Virtual_ZeroLevelCH4_Main_bak ;;
/*BF del 
//ADC-correction
extern int  alpha[4];				// Y = beta * X + alpha	
extern float beta[4];				// alpha -> zero offset, beta -> gain
*/
/*BF del
extern int ZeroLevelCH1_cor_offset ;;
extern int ZeroLevelCH2_cor_offset ;;
extern int ZeroLevelCH3_cor_offset ;;
extern int ZeroLevelCH4_cor_offset ;;

extern int ZeroLevelCH1_XY_bak ;;
extern int ZeroLevelCH2_XY_bak ;;
extern int VZeroLevelCH1_XY_bak ;;
extern int VZeroLevelCH2_XY_bak ;;
*/

extern int Trigger_Pos_CH1_bak ;;										// Stores the Trigger Position on Channel 1
extern int Trigger_Pos_CH2_bak ;;										// Stores the Trigger Position on Channel 2
extern int Trigger_Pos_CH3_bak ;;										// Stores the Trigger Position on Channel 3
extern int Trigger_Pos_CH4_bak ;;
//extern int Timebase_Offset_Pos_bak ;;
//extern int Trigger_Offset_Pos_bak ;;	//BF del not used
extern int AC_CH1_bak ;;
extern int AC_CH2_bak ;;
extern int AC_CH3_bak ;;
extern int AC_CH4_bak ;;
extern int Invert_CH1_bak ;;
extern int Invert_CH2_bak ;;
extern int Invert_CH3_bak ;;
extern int Invert_CH4_bak ;;
extern int MAINMODE_bak ;;
extern int TriggerMode_bak ;;
extern int Acquire_bak_0 ;;
extern int Acquire_bak_1 ;;
extern volatile int HistoMax_1 ;;
extern volatile int HistoMax_2 ;;	
extern volatile int HistoSt_1 ;;
extern volatile int HistoSt_2 ;;
extern volatile int HistoDiv ;;


//extern char  RealTimebase_bak;
//extern short SIGNALFaktor_idx_bak;    
//extern short SIGNAL_StartFr_idx_bak;   
extern short draw_start ;;
extern short draw_factor ;;
extern short draw_dm_ixstart ;;
extern short draw_dm_ixfactor ;;
extern char  MainTimebase_bak;
extern char Run_bak;
extern unsigned char SingleShot_bak;

extern int Rot_Time ;;

extern char testtoggle ;;
extern int CH1_DAC_Offset ;;
extern int CH2_DAC_Offset ;;
extern int CH3_DAC_Offset ;;
extern int CH4_DAC_Offset ;;

extern int DAC_Correction[4][4][3];;	//BF added

//BF add #001 Channel delay correction
extern char CH1_Del_Correct;
extern char CH2_Del_Correct;
extern char CH3_Del_Correct;
extern char CH4_Del_Correct;

//--------------------------------------------------------------------------------------
// BF add
// Variables for new ultra slow timebase mode

extern short USTB_Mode;;	
extern short USTB_Mode_bak;;	
extern short USTB_Dir;			// buffer storing direction
//extern short USTB_Dir_bak;
extern short USTB_Disp;			// display mode (permanent/step)
extern unsigned char USTB_NewData;;
extern int  USTB_idx ;;
extern int  USTB_EOSignal;		//end of signal

//--------------------------------------------------------------------------------------

extern int LED_ON[16];
//extern int LED_Buf ;;
extern int Display_Line_Adresses[480];
//BF del not used extern int Display_Line_Adresses2[480];
//int *Display_Line_Adresses ;;
//int *Display_Line_Adresses2 ;;
extern volatile unsigned char VSync_Needed ;;
//extern volatile unsigned char DrawSignals_Needed ;; //BF del
//BF old USB functions -> can be deleted in future #017
extern volatile unsigned char uart2_buffer[64];
extern volatile unsigned char send_buffer[64];
//extern volatile char uart2_count;

//BF new designed USB functions #017
extern volatile char UART2_rx_cnt;
extern volatile unsigned char UART2_rx_buffer[64];
extern volatile unsigned char UART2_tx_buffer[64];


extern volatile unsigned char ClearPlane ;;
extern volatile unsigned char DrawPlane ;;
extern volatile unsigned char RemovePlane ;;
extern volatile unsigned char ClearPhase ;;
extern volatile unsigned char UpdateMarkerPlane ;;
extern volatile unsigned char UpdateMenuTextPlane ;;
extern volatile int TestVar ;;
extern volatile int Rotary_Direction ;;
extern volatile int Rotary_Direction_mem_pulse ;;
extern volatile int Rotary_Switch ;;
extern volatile int Rotary_Steps ;;

extern volatile int Keyboard_mem ;;
extern volatile char Keyboard_Changed ;;
extern volatile char ADC_Data_Available ;;

//extern unsigned long TransPlane_Buffer_Adr1 ;;
//extern unsigned long TransPlane_Plane_Adr1 ;;
//extern unsigned long TransPlane_Buffer_Adr2 ;;
//extern unsigned long TransPlane_Plane_Adr2 ;;

extern unsigned short SwitchesCH1;
extern unsigned short SwitchesCH2;
extern unsigned short SwitchesCH3;
extern unsigned short SwitchesCH4;
extern unsigned short SwitchesTB;
extern unsigned short SwitchesLMH[4]; 		//Jörg -> analog to SwitchesCHx

extern unsigned long *Buffer_Mark1Plane ;; //0x008D3BF4;
extern unsigned long *Buffer_UI2Plane ;;

//extern unsigned char *SIGNAL_IntBuf ;;	//BF reactivated for tests

// BF add QM changed by Stefan
extern int *SIGNAL_Histo ;;   // double used for Rollmode. No Interpolation for rollmode

/* BF del QM changed by Stefan
extern int *SIGNAL1_Histo ;;   // double used for Rollmode. No Interpolation for rollmode
extern int *SIGNAL2_Histo ;;
extern int *SIGNAL3_Histo ;;
extern int *SIGNAL4_Histo ;;
extern int *SIGNALM_Histo ;;
*/
//---------------------------------------------------------------------------
extern unsigned char *SIGNAL1_Intpolate ;;   
extern unsigned char *SIGNAL2_Intpolate ;;
extern unsigned char *SIGNAL3_Intpolate ;;
extern unsigned char *SIGNAL4_Intpolate ;;
extern unsigned char *SIGNALM_Intpolate ;;
extern unsigned char *SIGNAL1_USTB ;;   
extern unsigned char *SIGNAL2_USTB ;;
extern unsigned char *SIGNAL3_USTB ;;
extern unsigned char *SIGNAL4_USTB ;;
//extern unsigned char *SIGNALM_USTB ;;
//---------------------------------------------------------------------------

extern unsigned char *SIGNAL1_Intpolate_delayed ;;
extern unsigned char *SIGNAL2_Intpolate_delayed ;;
extern unsigned char *SIGNAL3_Intpolate_delayed ;;
extern unsigned char *SIGNAL4_Intpolate_delayed ;;
extern unsigned char *SIGNALM_Intpolate_delayed ;;
//---------------------------------------------------------------------------


//BF -> used for overlay mode
extern unsigned char *SIGNAL1_Buffer ;;
extern unsigned char *SIGNAL2_Buffer ;;
extern unsigned char *SIGNAL3_Buffer ;;
extern unsigned char *SIGNAL4_Buffer ;;

extern unsigned long *readout_sigbuf ;;
extern unsigned char *readout_sigbuf_char ;;

//extern int *tab ;;		//1024 * 4 = 4096
//extern int *tab ;;		//1024 * 4 = 4096	
//extern int *tab ;;		//1024 * 4 = 4096	
//extern int *tab ;;		//1024 * 4 = 4096

extern unsigned char *FIR_Buffer;

extern unsigned char *SHIFT_OFFS1;	//shift buffer 16k for channel 1 
extern unsigned char *SHIFT_OFFS2;	//shift buffer 16k for channel 2 
extern unsigned char *SHIFT_OFFS3;	//shift buffer 16k for channel 3 
extern unsigned char *SHIFT_OFFS4;	//shift buffer 16k for channel 4 
extern unsigned char *SHIFT_OFFSM;	//shift buffer 16k for channel math 

extern unsigned char *ROLL_OFFS1;	//roll buffer 32k for channel 1 
extern unsigned char *ROLL_OFFS2;	//roll buffer 32k for channel 2 
extern unsigned char *ROLL_OFFS3;	//roll buffer 32k for channel 3 
extern unsigned char *ROLL_OFFS4;	//roll buffer 32k for channel 4 
extern unsigned char *ROLL_OFFSM;	//roll buffer 32k for channel math 


//BF -> buffer for low pass filtering
extern unsigned char *Filter1_Buffer;
extern unsigned char *Filter2_Buffer;
extern unsigned char *Filter3_Buffer;
extern unsigned char *Filter4_Buffer;
extern unsigned char *CopyBuffer;

// signal buffer
extern unsigned char *SIGNAL1 ;;
extern unsigned char *SIGNAL2 ;;
extern unsigned char *SIGNAL3 ;;
extern unsigned char *SIGNAL4 ;;
extern unsigned char *SIGNALM ;;
extern int *SPECTRUM ;;

// Signal pointer
extern unsigned char *S1Ptr;
extern unsigned char *S2Ptr;
extern unsigned char *S3Ptr;
extern unsigned char *S4Ptr;
extern unsigned char *SMPtr;

extern unsigned long *Buffer_PlaneM ;;
extern unsigned long *Buffer_Plane1 ;;
extern unsigned long *Buffer_Plane2 ;;
extern unsigned long *Buffer_Plane3 ;;
extern unsigned long *Buffer_Plane4 ;;
extern unsigned long *Planes ;;
extern unsigned long *UI_Plane1 ;;
extern unsigned long *UI_Plane2 ;;
extern unsigned long *UI_Plane3 ;;
extern unsigned long *UI_Plane4 ;;
extern unsigned long *UI_Plane5 ;;
extern unsigned long *Channel_Plane1 ;;
extern unsigned long *Channel_Plane2 ;;
extern unsigned long *Channel_Plane3 ;;
extern unsigned long *Channel_Plane4 ;;
extern unsigned long *Channel_Math_Plane ;;
extern unsigned long *Copy_Plane1;
extern unsigned long *Copy_Plane2;
extern unsigned long *Copy_Plane3;
extern unsigned long *Marker_Plane1 ;;
extern unsigned long *Marker_Plane2 ;;
extern unsigned long *Grid_Plane ;;

//extern unsigned long *Dummy_Address ;;//BF testing memory

//extern long v_Buffer_PlaneM ;;
extern long v_Buffer_Plane1 ;;
extern long v_Buffer_Plane2 ;;
extern long v_Buffer_Plane3 ;;
extern long v_Buffer_Plane4 ;;
extern long v_Channel_Plane1 ;;
extern long v_Channel_Plane2 ;;
extern long v_Channel_Plane3 ;;
extern long v_Channel_Plane4 ;;
//extern long v_Channel_Math_Plane ;;

extern unsigned long *Text_Plane;

/*
extern unsigned long buffer_long1 ;;
extern unsigned long buffer_long2 ;;
extern unsigned long buffer_long3 ;;
extern unsigned long buffer_long4 ;;
extern unsigned long buffer_addi ;;
*/

// BF QM thresholds
extern short thres_type[5];
extern short thres_low[5];
extern short thres_mdl[5];
extern short thres_up[5];

extern float thres_low_abs[5];
extern float thres_mdl_abs[5];
extern float thres_up_abs[5];


// BF add QM changed by Stefan
extern short SIGNAL_MIN[5] ;;
extern short SIGNAL_MDL[5] ;;
extern short SIGNAL_MAX[5] ;;
extern short SIGNAL_BASE[5] ;;
extern short SIGNAL_TOP[5] ;;
extern short SIGNAL_AVG[5] ;;
extern short SIGNAL_AVG_CNT[5] ;;
extern short SIGNAL_THRES_LOW[5] ;;
extern short SIGNAL_THRES_MDL[5] ;;
extern short SIGNAL_THRES_UP[5] ;;
extern short SIGNAL_THRES_PRE_POSITIV_1[5] ;;
extern short SIGNAL_THRES_LOW_POSITIV_1[5] ;;
extern short SIGNAL_THRES_MDL_POSITIV_1[5] ;;
extern short SIGNAL_THRES_UP_POSITIV_1[5] ;;
extern short SIGNAL_THRES_OVER_POSITIV_1[5] ;;
extern short SIGNAL_THRES_PRE_NEGATIV_1[5] ;;
extern short SIGNAL_THRES_LOW_NEGATIV_1[5] ;;
extern short SIGNAL_THRES_MDL_NEGATIV_1[5] ;;
extern short SIGNAL_THRES_UP_NEGATIV_1[5] ;;
extern short SIGNAL_THRES_OVER_NEGATIV_1[5] ;;
extern short SIGNAL_THRES_PRE_POSITIV_2[5] ;;
extern short SIGNAL_THRES_LOW_POSITIV_2[5] ;;
extern short SIGNAL_THRES_MDL_POSITIV_2[5] ;;
extern short SIGNAL_THRES_UP_POSITIV_2[5] ;;
extern short SIGNAL_THRES_OVER_POSITIV_2[5] ;;
extern short SIGNAL_THRES_PRE_NEGATIV_2[5] ;;
extern short SIGNAL_THRES_LOW_NEGATIV_2[5] ;;
extern short SIGNAL_THRES_MDL_NEGATIV_2[5] ;;
extern short SIGNAL_THRES_UP_NEGATIV_2[5] ;;
extern short SIGNAL_THRES_OVER_NEGATIV_2[5] ;;
extern short SIGNAL_THRES_PRE_POSITIV_LAST[5] ;;
extern short SIGNAL_THRES_LOW_POSITIV_LAST[5] ;;
extern short SIGNAL_THRES_MDL_POSITIV_LAST[5] ;;
extern short SIGNAL_THRES_UP_POSITIV_LAST[5] ;;
extern short SIGNAL_THRES_OVER_POSITIV_LAST[5] ;;
extern short SIGNAL_THRES_PRE_NEGATIV_LAST[5] ;;
extern short SIGNAL_THRES_LOW_NEGATIV_LAST[5] ;;
extern short SIGNAL_THRES_MDL_NEGATIV_LAST[5] ;;
extern short SIGNAL_THRES_UP_NEGATIV_LAST[5] ;;
extern short SIGNAL_THRES_OVER_NEGATIV_LAST[5] ;;


extern char DelayedTimebase;	
extern int dmode_Cursor_Vertical_Position1_Old;
extern int dmode_Cursor_Vertical_Position2_Old;
extern int dmode_QM_Vertical_Position1_Old;
extern int dmode_QM_Vertical_Position2_Old;
extern int dmode_Window_Offset_Pos;
extern int dmode_Window_Offset_Pos_Old;
extern float Timebase_Ratio ;;
extern int Cursor_Delayed_1 ;;
extern int Cursor_Delayed_2 ;;
extern int Cursor_Delayed_Size ;;
extern int Cursor_Delayed_1_Old ;;
extern int Cursor_Delayed_2_Old ;;
//BF del extern volatile char multi_active ;;
extern volatile int ch1_value;
extern volatile int ch1_factor ;;
extern volatile int ch1_result;
extern volatile int ch2_value;
extern volatile int ch2_factor ;;
extern volatile int ch2_result;
extern volatile int ch3_value;
extern volatile int ch3_factor ;;
extern volatile int ch3_result;
extern volatile int ch4_value;
extern volatile int ch4_factor ;;
extern volatile int ch4_result;  
extern unsigned char buf_arr[600];

extern unsigned char GainIdx;			//BF added
extern float ScaleFactor[16][5];		//BF added
extern char ScaleIndexTable[16];		//BF added
extern short ScaleLookupTable[256][3];		//BF added
extern float FFT_ScaleCorrection[16][7];	//BF added
extern short FFT_ScaleLookupTable[256];		//BF added

extern float DAC_ScaleFactor[3][5] ;	

extern int ADC_Offset[4][4] ;


//-------------------------------------------------------------------------
// Math FFT variables
extern unsigned char MATH_Mode;

extern unsigned char FFT_Mode;; 
extern unsigned char FFT_NewData;
extern int FFT_Length;;
extern int FFT_Level;;		//FFT_Level = ld(FFT_Length)
extern int FFT_Windex;;		//FFT window index 
//BF not needed anymore extern int FFT_Scale;;
extern int FFT_NormENBW;		//Equivalent Noise Bandwidth normed to delta frequency in dB
extern unsigned char FFT_Layout;;
extern short FFT_TriggerMode_bak;

extern float FFT_ENBW[6];

//extern char FFTToggle;;                                       		// for switching between Scale and Offset
//extern FloatStr FFT_Scale_Str;
//extern FloatStr FFT_Offset_Str;
extern FloatStr FFT_Status_Str;
extern int iSin1024[1024];;
extern int iCos1024[1024];;

extern short int iLog10[481];;

extern int FFT_Window[6][1024] ;

/* BF insert end */
//---------------------------------------------------------------------------
//BF del extern short LogicData[32];
//BF not used extern char USB_Connected ;;
extern char USB_Data_Trans;
extern char USB_SendAllData;
extern char USB_At_Startup ;;
extern char USB_OnlyTrigger;
extern char USB_Data_Requested ;;

extern unsigned char RS232_ContData_ReqMask;
extern char RS232_Data_Requested;
extern char RS232_ScreenShot_Requested;

extern volatile char Run;
//extern volatile char Signal_Loaded ;;		BF del -> not used
extern unsigned char SingleShot;;
//extern volatile char Single_Restart ;;
extern volatile char ButtonChanged ;;

extern char SavePointer ;;
extern short led_status;											// Stores the LED Port Bits;
extern char ScreenShotActive;										// is 1 when sending screen shot
extern char PopUpPosition;
extern char IsPopuped;												// When it is Popuped it is 1, else 0
extern char PopupTimeCounter;										// Counter for Popup Pulldown
extern char TriggerLevelChanged ;;								// Was Triggerlevel changed
extern char TriggerModeChanged ;;								// Was Triggermode changed
extern char TriggerWayChanged ;;								// Was Triggerway changed
extern char TimebaseChanged ;;									// Was Timebase changed
extern char TimeOffsetChanged ;;								// Was Time_Offset changed
//BF del extern char SIGNALFaktorChanged ;;								// Was SIGNALFaktor changed
extern char TriggerLevelActive ;;								// Is Triggerlevel selected ?
extern char TimeOffsetActive ;;									// Is Time_Offset selected ?
extern char StatusBtnRemove ;;									// remove button
extern char ZeroPopupChanged ;;									// When 1 then is changed
extern char MenuPopupChanged ;;									// When 1 then is changed
extern char MenuPopupActive ;;									// Stores the actual Menupopup
extern char VoltageChangedCh1 ;;								// Was Voltage changed
extern char VoltageChangedCh2 ;;								// Was Voltage changed
extern char VoltageChangedCh3 ;;								// Was Voltage changed
extern char VoltageChangedCh4 ;;								// Was Voltage changed
extern char MenuPopupChanged2 ;;								// Was MenuPopup changed
extern char MenuOnlyChanged ;;									// When 1 then is changed 
extern char MenuItemChanged[6] ;;
extern char MenuItemPushed[6] ;;								// When Menuitem is pushed drawed
//extern char MenuItemPushed_old[6] ;;								// When Menuitem is pushed drawed
//extern char MenuStatusChanged ;;								// When switching on/off a menu holds menunr
extern char MenuAktive ;;                                        				// When Menu was deaktive
extern char MenuAktive_old ;;                                    				// When Menu was deaktive
extern char EdgeToggle ;;                                       				// for switching between Holdoff and Probe
extern char PulseToggle ;;                                       				// for switching between smaller/bigger pulse width
extern char MathToggle ;;                                        				// for switching between Scale and Offset
extern char DelayPopupSelect;									// selected delay popup menu 0 - 3
extern char AcquirePopupSelect;									// selected popup menu in acquire menu 1 / 2

extern char VS_ZeroLevelChanged ;;								// Zerolevel change flag
extern char VS_TrigLevelChanged ;;								// Triggerlevel change flag

extern int MenuPopupX;
extern int MenuPopupY;
extern int MenuPopupSizeX;
extern int MenuPopupSizeY;
extern char MenuStored;
extern char MenuChanged;
extern int MenuTimeCounter;										// Counter for Menu Pulldown
extern char MenuItemCount;											// Store the count of the Menuitems
extern char MenuOldItemCount;										// Store the count of the old Menuitems
extern char New_Menu ;;
extern char Active_Menu ;;
extern char Menu_Changed ;;
extern char Menu_First_Draw;

extern volatile char NumberOfChannels ;;

extern char Channels_Active;
extern char Channel_1_Active;										// Store the channel activity
extern char Channel_2_Active;										// Store the channel activity
extern char Channel_3_Active;										// Store the channel activity
extern char Channel_4_Active;										// Store the channel activity
extern char Channel_Math_Active;									// Store the math activity
/*BF del
extern char Channel_1_Active_Old;									// Store the channel activity
extern char Channel_2_Active_Old;									// Store the channel activity
extern char Channel_3_Active_Old;									// Store the channel activity
extern char Channel_4_Active_Old;									// Store the channel activity
extern char Channel_Math_Active_Old;									// Store the math activity
*/
extern char Channel_1_Active_bak;									//Backup channel status for restoring
extern char Channel_2_Active_bak;									//Backup channel status for restoring
extern char Channel_3_Active_bak;									//Backup channel status for restoring
extern char Channel_4_Active_bak;									//Backup channel status for restoring
extern char Channel_Math_Active_bak;									//Backup channel status for restoring

//extern char RealTimebase;										// ADC Timebase 
//extern char RealTimebase_Old;										// ADC Timebase
extern char VirtualTimebase;										
extern char MainTimebase;										// Timebase Index
extern char MainTimebase_Old;	     								
extern char XY_Mode ;;											// Selected Normal or XY-Mode
//extern int Timebase_Offset_Pos;										// Cursor -> Store the Timebase Offset Position in Pixel
//extern int Timebase_Offset_Pos_Old;									// Cursor -> Store the old Timebase Offset Position in Pixel
//extern volatile int Trigger_Offset_Pos;	//BF del not used					// Store the Timebase Offset Position in Pixel
//extern volatile int Trigger_Offset_Pos_Old;	//BF del not used					// Store the old Timebase Offset Position in Pixel
extern volatile int PreTrigComp;									// Pretrigger compensation
extern int Trig_Pos_Mem ;;                                     						// Store the Triggerposition in Memory
extern int Trig_Pos_Display ;;                                 						// Store the Triggerposition on Display
extern int Trig_Pos_Display_dmode ;;                           						// Store the Triggerposition on Display in delayed mode
extern int MemWinStart ;;                                    						// Store the Trigger Memory Offset
extern int Trig_Pos_Mem_old ;;                                     					// Store the Triggerposition in Memory
extern int Trig_Pos_Display_old ;;                                 					// Store the Triggerposition on Display
extern int Trig_Pos_Display_dmode_old ;;                           					// Store the Triggerposition on Display in delayed mode
extern int MemWinStart_old ;;                                    					// Store the Trigger Memory Offset
extern char TriggerWay;											// Stores the way to trigger
extern char TriggerWay_bak;	
extern char Selected_Trigger_Source;									// Stores the Channel who Trigger
extern char Selected_Trigger_Source_Old;								// Stores the Channel who Trigger Old

extern volatile unsigned long noTriggerTime ;;
extern volatile unsigned char CombiTriggerStatus;;
extern volatile unsigned long timingcounter;

extern int Trigger_Pos_CH1;										// Stores the Trigger Position on Channel 1
extern int Trigger_Pos_CH2;										// Stores the Trigger Position on Channel 2
extern int Trigger_Pos_CH3;										// Stores the Trigger Position on Channel 3
extern int Trigger_Pos_CH4;										// Stores the Trigger Position on Channel 4
extern int Trigger_Pos_CHE;										// Stores the Trigger Position on External
extern int Trigger_Pos_CH1_Old;									// Stores the old Trigger Position on Channel 1
extern int Trigger_Pos_CH2_Old;									// Stores the old Trigger Position on Channel 2
extern int Trigger_Pos_CH3_Old;									// Stores the old Trigger Position on Channel 3
extern int Trigger_Pos_CH4_Old;									// Stores the old Trigger Position on Channel 4
extern int Trigger_Pos_CHE_Old;									// Stores the old Trigger Position on External

extern int Virtual_ZeroLevelCH1;
extern int Virtual_ZeroLevelCH2;
extern int Virtual_ZeroLevelCH3;
extern int Virtual_ZeroLevelCH4;
extern int ZeroLevelCH1;
extern int ZeroLevelCH2;
extern int ZeroLevelCH3;
extern int ZeroLevelCH4;
extern int Virtual_ZeroLevelXYCH1;
extern int Virtual_ZeroLevelXYCH2;
extern int Virtual_ZeroLevelXYCH3;
extern int Virtual_ZeroLevelXYCH4;
extern int ZeroLevelCH1_Old;
extern int ZeroLevelCH2_Old;
extern int ZeroLevelCH3_Old;
extern int ZeroLevelCH4_Old;

extern volatile char Selected_Voltage_CH1;									// Selected Voltage_CH1
extern volatile char Selected_Voltage_CH1_Old;								// Selected Voltage_CH1
extern volatile char Selected_Voltage_CH2;									// Selected Voltage_CH2
extern volatile char Selected_Voltage_CH2_Old;								// Selected Voltage_CH2
extern volatile char Selected_Voltage_CH3;									// Selected Voltage_CH3
extern volatile char Selected_Voltage_CH3_Old;								// Selected Voltage_CH3
extern volatile char Selected_Voltage_CH4;									// Selected Voltage_CH4
extern volatile char Selected_Voltage_CH4_Old;								// Selected Voltage_CH4
extern volatile char Selected_TB;											// Selected TimeBase

extern char SelectedCursor;										// Which Cursor is selected
extern char SelectedCursorOld;										// Which Cursor was selected
extern char Cursor_Enabled;
extern char Cursor_Enabled_Old;
extern char CursorChanged;											// Was Cursor changed
extern char Cursor_XY_Selected;									// 0 ;
extern char Cursor_XY_Selected_Old;								// 0 ;
extern char Cursor_Both_Selected;
extern char Cursor_Both_Selected_Old;
extern char Cursor_Horizontal_Active; 								// 0 ;
extern char Cursor_Horizontal_Active_Old;							// 1 ;
extern long Cursor_Horizontal_Position_Real1;						// Store Real Cursor Position
extern long Cursor_Horizontal_Position_Real2;						// Store Real Cursor Position
extern long Cursor_Horizontal_Position1_Old;						// Store old Cursor horizontal I position
extern long Cursor_Horizontal_Position2_Old;						// Store old Cursor horizontal II position
extern char Cursor_Vertical_Active;								// 0 ;
extern char Cursor_Vertical_Active_Old;							// 1 ;

//extern long Cursor_Vertical_Position_Real1;						// Store Real Cursor Position
//extern long Cursor_Vertical_Position_Real2;						// Store Real Cursor Position
//extern long Cursor_Vertical_Position1_Old;						// Store old Cursor vertical I position
//extern long Cursor_Vertical_Position2_Old;						// Store old Cursor vertical II position

extern long Cursor_Vertical_Position_TY_1;						// Store Cursor Position
extern long Cursor_Vertical_Position_TY_2;						// Store Cursor Position
extern long Cursor_Vertical_Position_XY_1;						// Store Cursor Position
extern long Cursor_Vertical_Position_XY_2;						// Store Cursor Position
extern long Cursor_Vertical_Position_FFT_1;						// Store Cursor Position
extern long Cursor_Vertical_Position_FFT_2;						// Store Cursor Position
extern long Cursor_Vertical_Position1_Old;						// Store old Cursor vertical I position
extern long Cursor_Vertical_Position2_Old;						// Store old Cursor vertical II position
extern char Cursor_Data_Draw_Pos ;;							// Stores the draw position of the cursor data
extern char Cursor_Data_First_Draw ;;							// Is it draw first time ?
extern char QM_Enabled;
extern char QM_Enabled_Old;
extern char QM_Changed[3];											// Was quick measurment changed
extern char QM_Type[3];                                            // What type of measurment (look 1313 -> 52 ...
extern char QM_Type_Old[3];                                        // What type of measurment (look 1313 -> 52 ...
extern char QM_Channel[3];                                         // What channel is measured
extern char QM_Second_Channel[3];                                  // Fore delay / phase measurment
extern char QM_CHI_Edge[3];                                        // Fore delay  measurment // 1 ;
extern char QM_CHII_Edge[3];                                       // Fore delay  measurment // 1 ;
extern char BufPre[30];
extern char BufUnit[10];
extern char BufReturn[30];
extern char QM_V_A_Buf[1];
extern char QM_H_A_Buf[1];
extern char QM_Horizontal_Active; 								     // 0 ;
extern char QM_Horizontal_Active_Old;							     // 1 ;
extern long QM_Horizontal_Position_Real1;						// Store Real Cursor Position
extern long QM_Horizontal_Position_Real2;						// Store Real Cursor Position
extern long QM_Horizontal_Position1_Old;						// Store old Cursor horizontal I position
extern long QM_Horizontal_Position2_Old;						// Store old Cursor horizontal II position
extern char QM_Vertical_Active;								// 0 ;
extern char QM_Vertical_Active_Old;							// 1 ;
extern long QM_Vertical_Position_Real1;						// Store Real Cursor Position
extern long QM_Vertical_Position_Real2;						// Store Real Cursor Position
extern long QM_Vertical_Position1_Old;							// Store old Cursor vertical I position
extern long QM_Vertical_Position2_Old;							// Store old Cursor vertical II position
extern char Quick_Measure_Data_Draw_Pos ;;								// Stores the draw position of the cursor data
extern char Quick_Measure_First_Draw ;;							// Is it draw first time ?
extern char Quick_Measure_Threshold_btn_select;
extern char Memory_Window_visible ;;
extern int mb_window_start_old ;;
extern int mb_window_stop_old ;;
extern int mb_window_trigger_old ;;
extern int mb_window_cursor1_old ;;
extern int mb_window_cursor2_old ;;
extern int math_mul_scale ;;
extern int math_sub_scale ;;
extern int math_add_scale ;;
extern int math_scale ;;

extern FloatStr Pulse11;
extern FloatStr Pulse21;
extern FloatStr Pulse12;
extern FloatStr Pulse22;

extern FloatStr Cursor_Delta_X;	
extern FloatStr Cursor_Delta_1X;
extern FloatStr Cursor_Delta_XY_X;
extern FloatStr Cursor_Delta_Y;
extern FloatStr Cursor_Vertical_Pos_1_Str;
extern FloatStr Cursor_Vertical_Pos_2_Str;
extern FloatStr Cursor_Vertical_Pos_XY_1_Str;
extern FloatStr Cursor_Vertical_Pos_XY_2_Str;
extern FloatStr Cursor_Horizontal_Pos_1_Str;
extern FloatStr Cursor_Horizontal_Pos_2_Str;

extern FloatStr FFT_Cursor_Delta_X;	
extern FloatStr FFT_Cursor_Delta_1X;
extern FloatStr FFT_Cursor_Delta_Y;
extern FloatStr FFT_Cursor_Vertical_Pos_1_Str;
extern FloatStr FFT_Cursor_Vertical_Pos_2_Str;
extern FloatStr FFT_Cursor_Horizontal_Pos_1_Str;
extern FloatStr FFT_Cursor_Horizontal_Pos_2_Str;

extern FloatStr QM_Slot1;
extern FloatStr QM_Slot2;
extern FloatStr QM_Slot3;
extern FloatStr QM_Threshold_lower;
extern FloatStr QM_Threshold_middle;
extern FloatStr QM_Threshold_upper;
//BF del extern FloatStr Math_Offset;
extern FloatStr Math_Offset_mul;
extern FloatStr Math_Offset_sub;
extern FloatStr Math_Offset_add;

extern FloatStr Zero_Level1_Str;
extern FloatStr Zero_Level2_Str;
extern FloatStr Zero_Level3_Str;
extern FloatStr Zero_Level4_Str;

extern int dzp_channel_buf ;;
extern short dzp_fprobe_buf ;;
extern char dzp_fselected_voltage_buf ;;

extern FloatStr Trigger_Level_Str;
extern FloatStr Trigger_ExtLevel_Str;
extern int ct_Selected_Trigger_Source_buf ;;
extern int ct_volt_buf ;;
extern int ct_voltmfactor_buf ;;
extern FloatStr Timebase_Offset_Str;  // unused
extern FloatStr Trigger_Offset_Str;
extern FloatStr HoldOff;

//---------------------------------------------------------------------------------------------
//         Menu

extern unsigned short MenuItemDef[32][6] ;
//BF not used extern unsigned char MenuItem151[16] ;;
extern unsigned char MenuItem[32][6][16] ;
extern unsigned char MenuEdgeBufText[7] ;;
extern unsigned short MenuDataDef[350] ;
extern char MenuData[350][16] ;
extern short MenuStatus[32][6] ;
extern short MenuPopupStatus[48][22] ;	
extern unsigned short MenuPopupDef[48][2] ;;
extern char MenuPopupText[48][23][20] ;
//----------------------------------------------------------------------------------------------

//extern char SampleRateData[15][10] ;;
//BF del extern char Stringlist[1][32] ;;
//BF del extern char PatternStatus[5] ;;

//BF del extern unsigned char TriggerData[11][12] ;
extern unsigned short TimebaseDataDef[36] ;
extern unsigned char TimebaseData[36][10] ;

extern float TimeBaseFactor[36];				//BF new TB values
extern int SampleRate[36];					//BF new sample rate values

extern unsigned short SampleRateDataDef[36] ;
extern unsigned char SampleRateData[36][11] ;
//extern const short TimebaseData_Matrix[36][5][10] ;
extern const float Timebase_Delayed_Factor_Table[26];	//BF #003
//extern const unsigned short VoltageDataDef[11] ;; BF del

extern const float VoltFactor[19];
extern const char VoltageData[11][5] ;

extern const float ScreenScaleFactor[16];

extern unsigned char FONT10X9[100][28];
extern unsigned char FONT12X9[120][28];
extern unsigned char bitbmBigArrowUp[] ;
extern unsigned char bitbmBigArrowDown[] ;
extern unsigned char bitbmCycleArrow[] ;
extern unsigned char bitbmSelectCycleArrow[] ;
extern unsigned char bitbmTimebaseOffset[] ;
extern unsigned char bitbmSubMenu[] ;
extern unsigned char bitbm_GND[];
extern unsigned char bitbmCH1[] ;
extern unsigned char bitbmCH1_gnd[] ;
//extern unsigned char bitbmCH1_XY[] ;
extern unsigned char bitbmCH2[] ;
extern unsigned char bitbmCH2_gnd[] ;
extern unsigned char bitbmCH3[] ;
extern unsigned char bitbmCH3_gnd[] ;
extern unsigned char bitbmCH4[] ;
extern unsigned char bitbmCH4_gnd[] ;
extern unsigned char bitbmMin[] ;
extern unsigned char bitbmMax[] ;
extern unsigned char bitbmTrigger[] ;
extern unsigned char bitbmTrigAVG[] ;
extern unsigned char bitbmCoppAC[] ;
extern unsigned char bitbmCoppDC[] ;
extern unsigned char bitbmCoppInv[] ;
extern unsigned char bitbmCoppLimit[] ;
extern unsigned char bitbmCoppLimit[] ;
extern unsigned char bitbmCoppACInv[] ;
extern unsigned char bitbmCoppACLimit[] ;
extern unsigned char bitbmCoppInvLimit[] ;
extern unsigned char bitbmCoppFull[] ;
extern unsigned char bitbmStopTrigger[] ;
//BF not used extern unsigned char bitbmStopTrigger_stop[] ;
extern unsigned char bitbmWTAG[] ;

extern bool screen_sel;
extern bool screen_sel_old;


// support_interrupts   ;
// CONSTANTS            ;
// sim_extern char_stream  ;
// sim_extern char_stream  ;


/* Function:    ShiftAndRound
 * Description: Shifts an value (to divide) an takes care of the last
 *              removed bit (0.5) so we round values and don't cut
 *              them
 * Parameters:  Number: Value to be divided
 *              Bits: Number of bits to shift
 * Returnvalue: Number shiftet to right by Bits bits and rounded
 * Written:     20100630 - rowue
 * Tested:      Yes
 * Reviewed:    No
 * Remarks:     inline
 */

static inline unsigned int ShiftAndRound (
        unsigned int Number,
        short BitsToShift) {

    unsigned int LastDigit = 0;

    if (BitsToShift) {
        BitsToShift -= 1;
        if (BitsToShift) {
            Number >>= BitsToShift;
        }
        LastDigit = Number & 0x01;
        Number >>= 1;
        Number += LastDigit;
    }
    return Number;
}




/* Function:    MultiplyFloatInt
 * Description: Multiply float and int and return int (unsigned).
 *              No conversion (int)((float)INT * float) is needed.
 *              The range is 2^-10 to 2^14
 * Parameters:  FactorInt: Integer (unsigned) - integer factor
 *              FactorFloat: float factor - sign will be dropped(!)
 * Returnvalue: unsigned integer from multiplication
 * Written:     20100701 - rowue
 * Tested:      Yes
 * Reviewed:    No
 * Remarks:     inline
 * Todo:        Assembler Makro - to put it in an central place!!!
 */
static inline unsigned int MultiplyFloatInt (
        unsigned int FactorInt,
        float FactorFloat
        ) {

    unsigned int exponent;
    unsigned int add_me;
    unsigned int mantissa;
    unsigned int *convert;
    unsigned int *puffer;


    convert = (unsigned int *)&FactorFloat;
    puffer = (unsigned int *)&FactorFloat;
    mantissa = ((*convert & 0x007fffff) | 0x00800000);
    exponent = (*convert >> 23) & 0xff;

    // These are our exponents and values - as expected 
    // Now convert these guys to fixed point (if possible)
    //
    if (exponent >= 117) {
        exponent -= 117;    // 10 bits spare
        if (exponent < 24) {
            mantissa >>=(23-exponent);
            mantissa *= FactorInt;
            mantissa >>= 9;
            add_me = (mantissa &0x01);
            mantissa >>= 1;
            mantissa += add_me;
        } else {
            mantissa = 0xffffffff;
        }
    } else {
        mantissa = 0x00000000;
    }

    return mantissa;
}

/* Function:    Math_Sqrt
 * Description: Get the square root of an integer
 * Parameters:  Radikand: Integer - the number to calculate the root from
 * Returnvalue: Radix: Integer - the radix of the radikant
 * Written:     20100717 - rowue
 * Tested:      Yes
 * Reviewed:    No
 * Remarks:     inline
 * Todo:        Assembler Makro - to put it in an central place!!!
 */
static inline unsigned int Math_Sqrt (
        unsigned int Radikand) {

    int Bits;
    int i;
    int SecNumber;
    int Sqrt;
    int Eps;
    int yn;
    int Counter = 0;

    Bits = 0;

    SecNumber = Radikand;
    if (!(Radikand)) {      // TODO: Check for overrun
        Sqrt = 0;
    } else {
        while (SecNumber) {
            SecNumber >>= 1;
            Bits += 1;
        }
    
        Bits = ShiftAndRound (Bits, 1);
        Sqrt = ShiftAndRound (Radikand, Bits);
    
        yn = Radikand/Sqrt;
    
        Eps = 42;   // Sqrt can be lower than yn in the first iteration
    
        while ((Eps > SQRT_EPS) && (Counter < SQRT_ITER)) {
            Sqrt = ShiftAndRound (Sqrt + yn, 1);
            yn = Radikand/Sqrt;
            Eps = Sqrt - yn;
            Counter++;
        }
    }
    return Sqrt;

    /* What's the joke on this?
     * sqrt(a) = a^{0.5} -> sqrt(2^n) = 2^{n/2}
     *
     * the use of the hedon scheme is caused by cut-off errors
     *
     */
}



//BF calculate square root
static inline int iSqrt(int op)
{
	int l,r;
	// and square root
	for( l = 0,r = 1 ; l <= SQRT_PREC; l++)			// r = sqrt(v)
	r = (r + (op / r)) >> 1;

	return r;

}

//##########################################################################################################################################################
// BF function for sending float values via printf() to RS232, resolving the problem of systemcrash in open source FW
// when using the printf() directly

static void floatprintf(float fvalue)
{
	long int pre, aft,factor;
	int i;
	
	if (fvalue == 0)
	{ printf("0.000"); return;}

	//calculating pre FP value
	pre = (long int)fvalue;
	if(pre == 0 && fvalue < 0)	//negativ
		printf("-%d.",pre);
	else
		printf("%d.",pre);
		
	//get leading zero
	if((fvalue - pre) != 0) //check if numbers after FP exist
	{
		for(factor = 10, i= 0 ;0 == (long int)((fvalue - pre) * factor) && i<11; factor*=10, i++)
		{ printf("0"); }
	}
	else
	{	
		printf("000");
		return;
	}
	
	//calc after FP value, minimum 3 numbers after FP
	aft = (long int)((fvalue - pre) * factor * 100);
	
	if(aft < 0)	//kill sign
	{ aft *= -1; }

	printf("%d",aft);

	if(i >= 11)
	printf("overflow");

}


