/**
  ******************************************************************************
  * @file    stm32f4_discovery_DOGM128.h
  * @author  MCD Application Team
  * @version V1.1.0
  * @date    28-October-2011
  * @brief   This file contains all the functions prototypes for the stm32f4_discovery_DOGM128.c
  *          firmware driver.
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************  
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __STM32F4_DISCOVERY_DOGM128_H
#define __STM32F4_DISCOVERY_DOGM128_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
 #include "stm32f4xx.h"
extern  void Delay(__IO uint32_t nCount);



 // STM32F4_DISCOVERY 3,3V				DOGS102		DOGM128
 // -----------------------------------------------------------------------------
 // LCD_A0/CD   GPIOD GPIO_Pin_8   	-> 	PIN 26		PIN 38
 // LCD_RST     GPIOB GPIO_Pin_11   ->	PIN 27 		PIN 39
 // LCD_CS      GPIOB GPIO_Pin_12 	-> 	PIN 28 		PIN 40
 // MOSI        GPIOB GPIO_Pin_15 	-> 	PIN 25		PIN 37
 // SCK         GPIOB GPIO_Pin_13 	-> 	PIN 24		PIN 36


#define ORIENTATION_NORMAL  FALSE
#define ORIENTATION_REVERSE TREU
//*----------------------------------------------------------------------------
#define LCD_WIDTH   128
#define LCD_HEIGHT  64
//*----------------------------------------------------------------------------
#define FILLED      TRUE
#define FRAMED      FALSE
//*----------------------------------------------------------------------------
#define TXT_MODE_LEFT     0x00
#define TXT_MODE_CENTER   0x01
#define TXT_MODE_RIGHT    0x02

#define TXT_MODE_NONINV   0x00
#define TXT_MODE_INVERS   0x04

#define TXT_MODE_RAM      0x00
#define TXT_MODE_FLASH    0x08

#define TXT_ADD_UP        0x10
#define TXT_ADD_DOWN      0x20
//*----------------------------------------------------------------------------
#define RPRINTF_FLOAT

#define DOGM128_SPI                       SPI2
#define DOGM128_SPI_CLK                   RCC_APB1Periph_SPI2

#define DOGM128_SPI_SCK_PIN               GPIO_Pin_13
#define DOGM128_SPI_SCK_GPIO_PORT         GPIOB
#define DOGM128_SPI_SCK_GPIO_CLK          RCC_AHB1Periph_GPIOB
#define DOGM128_SPI_SCK_SOURCE            GPIO_PinSource13
#define DOGM128_SPI_SCK_AF                GPIO_AF_SPI2

#define DOGM128_SPI_MISO_PIN              GPIO_Pin_14
#define DOGM128_SPI_MISO_GPIO_PORT        GPIOB
#define DOGM128_SPI_MISO_GPIO_CLK         RCC_AHB1Periph_GPIOB
#define DOGM128_SPI_MISO_SOURCE           GPIO_PinSource14
#define DOGM128_SPI_MISO_AF               GPIO_AF_SPI2

#define DOGM128_SPI_MOSI_PIN              GPIO_Pin_15
#define DOGM128_SPI_MOSI_GPIO_PORT        GPIOB
#define DOGM128_SPI_MOSI_GPIO_CLK         RCC_AHB1Periph_GPIOB
#define DOGM128_SPI_MOSI_SOURCE           GPIO_PinSource15
#define DOGM128_SPI_MOSI_AF               GPIO_AF_SPI2

#define DOGM128_SPI_CS_PIN                GPIO_Pin_12
#define DOGM128_SPI_CS_GPIO_PORT          GPIOB
#define DOGM128_SPI_CS_GPIO_CLK           RCC_AHB1Periph_GPIOB

#define DOGM128_SPI_A0_PIN                GPIO_Pin_8
#define DOGM128_SPI_A0_GPIO_PORT          GPIOD
#define DOGM128_SPI_A0_GPIO_CLK           RCC_AHB1Periph_GPIOD

#define DOGM128_SPI_RST_PIN               GPIO_Pin_11
#define DOGM128_SPI_RST_GPIO_PORT         GPIOB
#define DOGM128_SPI_RST_GPIO_CLK          RCC_AHB1Periph_GPIOB

#define DOGM128_CS_LOW()        GPIO_ResetBits(DOGM128_SPI_CS_GPIO_PORT , DOGM128_SPI_CS_PIN)
#define DOGM128_CS_HIGH()       GPIO_SetBits(DOGM128_SPI_CS_GPIO_PORT , DOGM128_SPI_CS_PIN)

#define DOGM128_RST_LOW()      GPIO_ResetBits(DOGM128_SPI_RST_GPIO_PORT, DOGM128_SPI_RST_PIN )
#define DOGM128_RST_HIGH()      GPIO_SetBits(DOGM128_SPI_RST_GPIO_PORT, DOGM128_SPI_RST_PIN)

#define DOGM128_A0_LOW()        GPIO_ResetBits(DOGM128_SPI_A0_GPIO_PORT, DOGM128_SPI_A0_PIN )
#define DOGM128_A0_HIGH()       GPIO_SetBits(DOGM128_SPI_A0_GPIO_PORT, DOGM128_SPI_A0_PIN)


/* DOGM128 display commands */
#define DOGM128_PAGE_BASE                       0xB0
#define DOGM128_PAGE0                           0xB0
#define DOGM128_PAGE1                           0xB1
#define DOGM128_PAGE2                           0xB2
#define DOGM128_PAGE3                           0xB3
#define DOGM128_PAGE4                           0xB4
#define DOGM128_PAGE5                           0xB5
#define DOGM128_PAGE6                           0xB6
#define DOGM128_PAGE7                           0xB7
#define DOGM128_DISPLAY_ON                      0xAF
#define DOGM128_DISPLAY_OFF                     0xAE
#define DOGM128_DISPLAY_START_ADDRESS_BASE      0x40
#define DOGM128_ADC_NORMAL                      0xA0
#define DOGM128_ADC_REVERSE                     0xA1
#define DOGM128_DISPLAY_NORMAL                  0xA6
#define DOGM128_DISPLAY_REVERSE                 0xA7
#define DOGM128_ALL_POINTS_ON                   0xA5
#define DOGM128_ALL_POINTS_OFF                  0xA4
#define DOGM128_BIAS_19                         0xA2
#define DOGM128_BIAS_17                         0xA3
#define DOGM128_INTERNAL_RESET                  0xE2
#define DOGM128_COM_OUTPUT_SCAN_NORMAL          0xC0
#define DOGM128_COM_OUTPUT_SCAN_REVERSE         0xC8
#define DOGM128_POWER_CONTROL_BASE              0x28
#define DOGM128_V0_OUTPUT_RESISTOR_BASE         0x20
#define DOGM128_ELECTRONIC_VOLUME_MODE_SET      0x81
#define DOGM128_STATIC_INDICATOR_OFF            0xAC
#define DOGM128_STATIC_INDICATOR_ON             0xAD
#define DOGM128_BOOSTER_RATIO_SET               0xF8

 extern const uint8_t dogm128_font[96][6];

 void dogm128_send_command(uint8_t command);
 //*----------------------------------------------------------------------------
 // VARIABLENDEFINITION
 //*----------------------------------------------------------------------------
 // Der Font-Header f�r den Font-Editor von H.Reddmann
 // Funktioniert nur mit unkomprimierten Fonts
 //*----------------------------------------------------------------------------
 typedef struct {
   uint8_t  Font_Size_Lo;       // Font size in Bytes LOW
   uint8_t  Font_Size_Hi;       // Font size in Bytes HIGH
   uint8_t  Font_Width;         // Font Width in Pixels
   uint8_t  Font_Height;        // Font Height in Pixels
   uint8_t  Font_BitsPerPixels; // Font Bits per Pixels (nur 1 erlaubt)
   uint8_t  Font_FirstChar;     // Font first char
   uint8_t  Font_LastChar;      // Font last char
 } TFONTHEAD;
 //*----------------------------------------------------------------------------
 typedef struct {
   uint8_t   Mirror[128][8];    // Display Mirror-Buffer 4 x 132 Bytes
   uint8_t invers;            // Flag f�r invertiertes Display
   uint8_t *fontwidth;          // Zeiger auf die Font-Breitentabelle
   uint8_t *fontdata;           // Zeiger auf die Font-Daten
   uint8_t Char_First;          // First Char aus Header
   uint8_t Char_Last;           // Last Char aus Header
   uint8_t Font_Height;         // Font Height aus Header
   uint8_t X_Pos;               // Aktuelle Zeichenausgabe X-Position
   uint8_t X_Max;               // Rechte Begrenzung f�r Zeichenausgabe
   uint8_t Y_Pos;               // Aktuelle Zeichenausgabe Y-Position
 } TLCD;

 extern TLCD lcd;
 //*----------------------------------------------------------------------------
 // FUNKTIONSPROTOTYPEN
 //*----------------------------------------------------------------------------
 void spi_init(void);
 uint8_t DOGM128_SendByte(uint8_t byte);
 void Lcd_Init(void);
 void dogm128_send_command(uint8_t command);
 void dogm128_send_command(uint8_t data);
 void Lcd_Show(void);
 void Lcd_Clear(void);
 void dogm128_send_command(uint8_t command);
 void Lcd_SetPixel(uint8_t x, uint8_t y);
 void Lcd_ClrPixel(uint8_t x, uint8_t y);
 void Lcd_Hline(uint8_t x1, uint8_t y1, uint8_t w);
 void Lcd_Vline(uint8_t x, uint8_t y, uint8_t h);
 void Lcd_Erase(uint8_t x, uint8_t y, uint8_t w, uint8_t h);
 void Lcd_Rectangle(uint8_t x, uint8_t y, uint8_t w, uint8_t h, uint8_t mode);
 void Lcd_RoundRectangle(uint8_t x, uint8_t y, uint8_t w, uint8_t h, uint8_t mode);
 void Lcd_Bar(uint8_t x, uint8_t y, uint8_t w, uint8_t max, uint8_t pos);
 //*----------------------------------------------------------------------------
 void Font_Init(uint8_t *ptr);
 void Font_DrawChar(char c);
 uint8_t   Font_CharWidth(char c);
 uint16_t  Font_TextWidth(char *ptr, uint8_t mode);
 void rprintfFloat(char numDigits, double x);
 void rprintfNum(char base, char numDigits, char isSigned, char padchar, long n);
 void rprintfStr(char str[]);
 void rprintfStrLen(char str[], unsigned int start, unsigned int len);
 void Font_SetPos(uint8_t x, uint8_t y);
 //*----------------------------------------------------------------------------
 void Font_SystemFont(void);
 void Font_HeaderFont(void);
 void Font_BigFont(void);



/* USER Callbacks: This is function for which prototype only is declared in
   MEMS accelerometre driver and that should be implemented into user applicaiton. */  
/* DOGM128_TIMEOUT_UserCallback() function is called whenever a timeout condition
   occure during communication (waiting transmit data register empty flag(TXE)
   or waiting receive data register is not empty flag (RXNE)).
   You can use the default timeout callback implementation by uncommenting the 
   define USE_DEFAULT_TIMEOUT_CALLBACK in stm32f4_discovery_DOGM128.h file.
   Typically the user implementation of this callback should reset MEMS peripheral
   and re-initialize communication or in worst case reset all the application. */


#ifdef __cplusplus
}
#endif

#endif /* __STM32F4_DISCOVERY_DOGM128_H */


/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
