/*----------------------------------------------------------------------------
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : SystemFont.h
    Date                : 21.06.2009
    Font size in bytes  : 0x01F6, 502
    Font width          : 14
    Font height         : 8
    Font first char     : 0x1A
    Font last char      : 0x7F
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
       // common shared fields
       U16   font_Size_in_Bytes_over_all_included_Size_it_self;
       U8    font_Width_in_Pixel_for_fixed_drawing;
       U8    font_Height_in_Pixel_for_all_Characters;
       U8    font_Bits_per_Pixels;
             // if MSB are set then font is a compressed font
       U8    font_First_Char;
       U8    font_Last_Char;
       U8    font_Char_Widths[font_Last_Char - font_First_Char +1];
             // for each character the separate width in pixels,
             // characters < 128 have an implicit virtual right empty row
             // characters with font_Char_Widths[] == 0 are undefined
    }
----------------------------------------------------------------------------*/
#ifndef SystemFont_H
#define SystemFont_H
//*----------------------------------------------------------------------------



#define SystemFont_WIDTH 14
#define SystemFont_HEIGHT 8
//*----------------------------------------------------------------------------
static const uint8_t SystemFont[] = {
    0xF6, 0x01, 0x0E, 0x08, 0x01, 0x1A, 0x7F, 
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00, 0x03, 0x05, 0x00, 0x07, 0x07, 0x0D, 0x03, 0x03, 
    0x00, 0x05, 0x01, 0x04, 0x01, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
    0x03, 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 
    0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
    0x05, 0x00, 0x05, 0x00, 0x03, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x04, 0x04, 0x01, 
    0x02, 0x04, 0x01, 0x05, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x02, 0x04, 0x04, 0x05, 0x04, 0x04, 
    0x04, 0x05, 0x05, 0x01, 0x04, 0x05, 
    0x7E, 0x09, 0x09, 0x7E, 0x7F, 0x49, 0x49, 0x36, 0x3E, 0x41, 0x41, 0x22, 0x7F, 0x41, 0x22, 0x1C, 
    0x7F, 0x49, 0x49, 0x41, 0x7F, 0x09, 0x09, 0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x14, 0x7F, 
    0x14, 0x7F, 0x14, 0x02, 0x25, 0x12, 0x08, 0x24, 0x52, 0x20, 0xC3, 0xA5, 0xD9, 0xB9, 0xD9, 0xA5, 
    0xC3, 0x7C, 0x28, 0x6C, 0x45, 0x87, 0x81, 0x87, 0x85, 0xE8, 0x28, 0x6C, 0x44, 0x7C, 0x1C, 0x22, 
    0x41, 0x41, 0x22, 0x1C, 0x08, 0x08, 0x3E, 0x08, 0x08, 0xC0, 0x08, 0x08, 0x08, 0x08, 0x40, 0x60, 
    0x1C, 0x03, 0x3E, 0x41, 0x41, 0x3E, 0x04, 0x02, 0x7F, 0x00, 0x62, 0x51, 0x49, 0x46, 0x22, 0x49, 
    0x49, 0x36, 0x1F, 0x10, 0x7E, 0x10, 0x27, 0x45, 0x45, 0x39, 0x3E, 0x49, 0x49, 0x32, 0x01, 0x71, 
    0x09, 0x07, 0x36, 0x49, 0x49, 0x36, 0x26, 0x49, 0x49, 0x3E, 0x00, 0x24, 0x00, 0x14, 0x14, 0x14, 
    0x14, 0x41, 0x22, 0x14, 0x08, 0x02, 0x51, 0x09, 0x06, 0x7E, 0x09, 0x09, 0x09, 0x7E, 0x7F, 0x49, 
    0x49, 0x49, 0x36, 0x3E, 0x41, 0x41, 0x41, 0x22, 0x41, 0x7F, 0x41, 0x41, 0x3E, 0x7F, 0x49, 0x49, 
    0x49, 0x41, 0x7F, 0x09, 0x09, 0x09, 0x01, 0x3E, 0x41, 0x41, 0x49, 0x7A, 0x7F, 0x08, 0x08, 0x08, 
    0x7F, 0x41, 0x7F, 0x41, 0x20, 0x40, 0x40, 0x3F, 0x7F, 0x08, 0x14, 0x22, 0x41, 0x7F, 0x40, 0x40, 
    0x40, 0x40, 0x7F, 0x02, 0x1C, 0x02, 0x7F, 0x7F, 0x02, 0x0C, 0x10, 0x7F, 0x3E, 0x41, 0x41, 0x41, 
    0x3E, 0x7F, 0x09, 0x09, 0x09, 0x06, 0x3E, 0x41, 0x51, 0x61, 0xBE, 0x7F, 0x09, 0x19, 0x29, 0x46, 
    0x26, 0x49, 0x49, 0x49, 0x32, 0x01, 0x01, 0x7F, 0x01, 0x01, 0x3F, 0x40, 0x40, 0x40, 0x3F, 0x03, 
    0x1C, 0x60, 0x1C, 0x03, 0x1F, 0x60, 0x3C, 0x60, 0x1F, 0x63, 0x14, 0x08, 0x14, 0x63, 0x03, 0x04, 
    0x78, 0x04, 0x03, 0x61, 0x51, 0x49, 0x45, 0x43, 0x08, 0x08, 0x3E, 0x1C, 0x08, 0x3E, 0x1C, 0x08, 
    0x40, 0x40, 0x40, 0x40, 0x1C, 0x1C, 0x00, 0x20, 0x54, 0x54, 0x78, 0x7F, 0x44, 0x44, 0x38, 0x38, 
    0x44, 0x44, 0x28, 0x38, 0x44, 0x44, 0x7F, 0x38, 0x54, 0x54, 0x18, 0x7E, 0x09, 0x98, 0xA4, 0xA4, 
    0x7C, 0x7F, 0x08, 0x04, 0x78, 0x7D, 0x80, 0x7D, 0x7F, 0x10, 0x28, 0x44, 0x7F, 0x7C, 0x04, 0x7C, 
    0x04, 0x78, 0x7C, 0x04, 0x04, 0x78, 0x38, 0x44, 0x44, 0x38, 0xFC, 0x24, 0x24, 0x18, 0x18, 0x24, 
    0x24, 0xFC, 0x7C, 0x08, 0x04, 0x48, 0x54, 0x54, 0x24, 0x3E, 0x44, 0x3C, 0x40, 0x40, 0x7C, 0x1C, 
    0x60, 0x60, 0x1C, 0x1C, 0x60, 0x18, 0x60, 0x1C, 0x6C, 0x10, 0x10, 0x6C, 0x9C, 0xA0, 0xA0, 0x7C, 
    0x64, 0x54, 0x54, 0x4C, 0x08, 0x0C, 0x7E, 0x0C, 0x08, 0x10, 0x30, 0x7E, 0x30, 0x10, 0x00, 0x06, 
    0x09, 0x09, 0x06, 0x04, 0x04, 0x00, 0x02, 0x0F, 0x00
};
//*----------------------------------------------------------------------------
#endif

