/**
*****************************************************************************
**
**  File        : main.c
**	Display EA DOGM128
**
**
*****************************************************************************
*/  //RTC->RTC_CALIBR = 0x000f;

 // STM32F4_DISCOVERY 3,3V				DOGS102		DOGM128
 // -----------------------------------------------------------------------------
 // LCD_A0/CD   GPIOD GPIO_Pin_8   	-> 	PIN 26		PIN 38
 // LCD_RST     GPIOB GPIO_Pin_11   ->	PIN 27 		PIN 39
 // LCD_CS      GPIOB GPIO_Pin_12 	-> 	PIN 28 		PIN 40
 // MOSI        GPIOB GPIO_Pin_15 	-> 	PIN 25		PIN 37
 // SCK         GPIOB GPIO_Pin_13 	-> 	PIN 24		PIN 36


#include "main.h"

RTCTime current_time;
#define RTC_CLOCK_SOURCE_LSE   /* LSE used as RTC source clock */

RTC_TimeTypeDef RTC_TimeStructure;
RTC_InitTypeDef RTC_InitStructure;
RTC_AlarmTypeDef  RTC_AlarmStructure;
RTC_DateTypeDef RTC_DateStructure;
NVIC_InitTypeDef  NVIC_InitStructure;
EXTI_InitTypeDef  EXTI_InitStructure;

RTC_TimeTypeDef ausgabe_zeit_rise;
RTC_TimeTypeDef ausgabe_zeit_set;

TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;
TIM_OCInitTypeDef  TIM_OCInitStructure;
TIM_BDTRInitTypeDef TIM_BDTRInitStructure;

__IO uint32_t AsynchPrediv = 0, SynchPrediv = 0;

int main(void)
{

	SystemInit();
	spi_init(); 		// SPI2 init
	Lcd_Init();			// DOGM128 init
	Lcd_Clear();	 	// nach Lcd_Clear() unbedingt Lcd_Show()!!
	Lcd_Show();			// Display Show
	Font_SystemFont();	// Font auswhlen (Standard)

	STM_EVAL_LEDInit(LED3);
	STM_EVAL_LEDInit(LED5);
	STM_EVAL_LEDInit(LED6);

	init_tim2(); 		// Timer2 Imterrupt auf 0,5 Sekunden
	backup_vbat(); 		// Vbat init

	//set_time (); 		//Datum und Zeit einstellen

	RTC_GetTime(RTC_Format_BIN, &RTC_TimeStructure); // Zeit auslesen
	RTC_GetDate(RTC_Format_BIN, &RTC_DateStructure); // Datum auslesen
	sun_init ();
	set_alarm ();
	RTC_GetAlarm(RTC_Format_BIN, RTC_Alarm_B, &RTC_AlarmStructure);
	ausgabe_lcd();			// Ausgabe Display
	STM_EVAL_LEDOn(LED6);		// alles ok!!

	// CALIBRIEREN
	//RTC_CoarseCalibConfig(RTC_CalibSign_Negative,16);
	//RTC_CalibOutputCmd(ENABLE);
	//RTC_CalibOutputConfig(RTC_CalibOutput_1Hz); // oder 512
	//RTC_CalibOutputCmd(ENABLE);
while (1)
  {
	 // Delay(0x7ffff);
	  RTC_GetTime(RTC_Format_BIN, &RTC_TimeStructure); // Zeit auslesen
	  RTC_GetDate(RTC_Format_BIN, &RTC_DateStructure); // Datum auslesen
	  RTC_GetAlarm(RTC_Format_BIN, RTC_Alarm_B, &RTC_AlarmStructure); // Alarm auslesen
	  daten();
	  ausgabe_lcd();			// Ausgabe Display
	  RTC_Alarm_IRQHandler(); 	//Alarm-Abfrage


	  //Font_SetPos(0,32);
	  //rprintfNum(10, 8,  FALSE, '0', RTC->CR);
	  //Lcd_Show();			// Display Show

	  //Delay(0x7ffff);


  }



}


void Delay(__IO uint32_t nCount)
{
  while(nCount--)
  {
  }
}


void RTC_Config(void)
{
  /* Enable the PWR clock */
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_PWR, ENABLE);

  /* Allow access to RTC */
  PWR_BackupAccessCmd(ENABLE);

#if defined (RTC_CLOCK_SOURCE_LSI)  /* LSI used as RTC source clock*/
/* The RTC Clock may varies due to LSI frequency dispersion. */
  /* Enable the LSI OSC */
  RCC_LSICmd(ENABLE);

  /* Wait till LSI is ready */
  while(RCC_GetFlagStatus(RCC_FLAG_LSIRDY) == RESET)
  {
  }

  /* Select the RTC Clock Source */
  RCC_RTCCLKConfig(RCC_RTCCLKSource_LSI);

  SynchPrediv = 0xFF;
  AsynchPrediv = 0x7F;

#elif defined (RTC_CLOCK_SOURCE_LSE) /* LSE used as RTC source clock */
  /* Enable the LSE OSC */
  RCC_LSEConfig(RCC_LSE_ON);

  /* Wait till LSE is ready */
  while(RCC_GetFlagStatus(RCC_FLAG_LSERDY) == RESET)
  {
  }

  /* Select the RTC Clock Source */
  RCC_RTCCLKConfig(RCC_RTCCLKSource_LSE);

  SynchPrediv = 0xFF;
  AsynchPrediv = 0x7F;

#else
  //#error Please select the RTC Clock source inside the main.c file
#endif /* RTC_CLOCK_SOURCE_LSI */

  /* Enable the RTC Clock */
  RCC_RTCCLKCmd(ENABLE);

  /* Wait for RTC APB registers synchronisation */
  RTC_WaitForSynchro();
}

void RTC_Alarm_IRQHandler(void)
{
  if(RTC_GetITStatus(RTC_IT_ALRA) != RESET)
  {
	  STM_EVAL_LEDOff(LED5);
	  RTC_ClearITPendingBit(RTC_IT_ALRA);
	  EXTI_ClearITPendingBit(EXTI_Line17);
	  sun_init (); 	//Astro-Daten erneuern
	  set_alarm ();

  }

  if(RTC_GetITStatus(RTC_IT_ALRB) != RESET)
  {
	  STM_EVAL_LEDOn(LED5);
	  RTC_ClearITPendingBit(RTC_IT_ALRB);
	  EXTI_ClearITPendingBit(EXTI_Line17);

  }



}

void set_alarm (void)
{
RTC_AlarmCmd(RTC_Alarm_A, DISABLE);
RTC_AlarmStructure.RTC_AlarmTime.RTC_Seconds = 0;
RTC_AlarmStructure.RTC_AlarmTime.RTC_Minutes = ausgabe_zeit_rise.RTC_Minutes;
RTC_AlarmStructure.RTC_AlarmTime.RTC_Hours = ausgabe_zeit_rise.RTC_Hours-1;

RTC_AlarmStructure.RTC_AlarmMask = RTC_AlarmMask_DateWeekDay ;
RTC_SetAlarm(RTC_Format_BIN, RTC_Alarm_A, &RTC_AlarmStructure);


/* Enable the RTC Alarm A Interrupt */
RTC_ITConfig(RTC_IT_ALRA, ENABLE);

/* Enable the alarm  A */
RTC_AlarmCmd(RTC_Alarm_A, ENABLE);



//----------------Alarm B--------------------------------------------------------
RTC_AlarmCmd(RTC_Alarm_B, DISABLE);
RTC_AlarmStructure.RTC_AlarmTime.RTC_Seconds = 0;
RTC_AlarmStructure.RTC_AlarmTime.RTC_Minutes = ausgabe_zeit_set.RTC_Minutes;
RTC_AlarmStructure.RTC_AlarmTime.RTC_Hours = ausgabe_zeit_set.RTC_Hours-1;

RTC_AlarmStructure.RTC_AlarmMask = RTC_AlarmMask_DateWeekDay ;
RTC_SetAlarm(RTC_Format_BIN, RTC_Alarm_B, &RTC_AlarmStructure);


/* Enable the RTC Alarm B Interrupt */
RTC_ITConfig(RTC_IT_ALRB, ENABLE);

/* Enable the alarm  B */
RTC_AlarmCmd(RTC_Alarm_B, ENABLE);
}


void set_time (void)
{
  //RTC_WriteBackupRegister(RTC_BKP_DR0, 0x32F2);
RTC_TimeStructure.RTC_Hours = 14;
RTC_TimeStructure.RTC_Minutes = 10;
RTC_TimeStructure.RTC_Seconds = 0;

RTC_SetTime(RTC_Format_BIN, &RTC_TimeStructure);

RTC_DateStructure.RTC_Year = 12;
RTC_DateStructure.RTC_Month = 1;
RTC_DateStructure.RTC_Date = 9;
RTC_DateStructure.RTC_WeekDay = 2;

RTC_SetDate(RTC_Format_BIN, &RTC_DateStructure);

}


void ausgabe_lcd(void)
{

const  char *wdname[7] = {"Son", "Mon", "Die", "Mit", "Don", "Fre", "Sam",};

//RTC_GetDate(RTC_Format_BIN, &RTC_DateStructure); // Datum auslesen
Font_SetPos(0,0);
rprintfStr((char*)wdname[(RTC_DateStructure.RTC_WeekDay-1)]);// Tagname erzeugen
rprintfStr(", ");
rprintfNum(10, 2,  FALSE, '0',RTC_DateStructure.RTC_Date);
rprintfStr(":");
rprintfNum(10, 2,  FALSE, '0',RTC_DateStructure.RTC_Month);
rprintfStr(":");
rprintfNum(10, 4,  FALSE, '0',RTC_DateStructure.RTC_Year+2000);

//RTC_GetTime(RTC_Format_BIN, &RTC_TimeStructure); // Zeit auslesen
Font_SetPos(75,0);
rprintfNum(10, 2,  FALSE, '0',RTC_TimeStructure.RTC_Hours);
rprintfStr(":");
rprintfNum(10, 2,  FALSE, '0',RTC_TimeStructure.RTC_Minutes);
rprintfStr(":");
rprintfNum(10, 2,  FALSE, '0',RTC_TimeStructure.RTC_Seconds);

//
/*
RTC_GetAlarm(RTC_Format_BIN, RTC_Alarm_A, &RTC_AlarmStructure);
Font_SetPos(0,8);
rprintfNum(10, 2,  FALSE, '0',RTC_AlarmStructure.RTC_AlarmTime.RTC_Hours);
rprintfStr(":");
rprintfNum(10, 2,  FALSE, '0',RTC_AlarmStructure.RTC_AlarmTime.RTC_Minutes);

RTC_GetAlarm(RTC_Format_BIN, RTC_Alarm_B, &RTC_AlarmStructure);
Font_SetPos(50,8);
rprintfNum(10, 2,  FALSE, '0',RTC_AlarmStructure.RTC_AlarmTime.RTC_Hours);
rprintfStr(":");
rprintfNum(10, 2,  FALSE, '0',RTC_AlarmStructure.RTC_AlarmTime.RTC_Minutes);
*/

//RTC_GetAlarm(RTC_Format_BIN, RTC_Alarm_B, &RTC_AlarmStructure);
Font_SetPos(0,24);
rprintfNum(10, 2,  FALSE, '0',(ausgabe_zeit_rise.RTC_Hours-1));	// Alarm Rise
rprintfStr(":");
rprintfNum(10, 2,  FALSE, '0',ausgabe_zeit_rise.RTC_Minutes);
Font_SetPos(50,24);
rprintfNum(10, 2,  FALSE, '0',(ausgabe_zeit_set.RTC_Hours-1));	// Alarm Rise
rprintfStr(":");
rprintfNum(10, 2,  FALSE, '0',ausgabe_zeit_set.RTC_Minutes);

/*
Font_SetPos(0,32);

rprintfNum(10, 4,  FALSE, '0',current_time.Al_Rise_Min);
rprintfStr(" : ");
rprintfNum(10, 4,  FALSE, '0',current_time.Al_Set_Min);
rprintfStr(" : ");
rprintfNum(10, 4,  FALSE, '0',current_time.Al_Time_Min);

Font_SetPos(0,40);

rprintfNum(10, 3,  FALSE, '0',current_time.Tag_Set);
rprintfStr(" : ");
rprintfNum(10, 3,  FALSE, '0',current_time.Tag_Rise);
rprintfStr(" : ");
rprintfNum(10, 3,  FALSE, '0',current_time.Tag_Heute);*/

Lcd_Show();			// Display Show

}


uint16_t ist_schaltjahr(uint16_t jahr)
{
   if (jahr % 4 == 0)
      return 1;
      else if (!(0 == jahr % 100))
              return 0;
           else if (0 == jahr % 400)
                   return 1;
   return 0;
 }




uint16_t tag_des_jahres(uint16_t tag,uint16_t monat,uint16_t jahr) { // Jahr hier noch uint8

	uint16_t Monatstage[13] = {31,28,31,30,31,30,31,31,30,31,30,31};

	uint16_t Tage= 0;
	uint16_t i;


Monatstage[1]  = 28 + ist_schaltjahr((jahr+2000));// Jahr hier noch uint16 stellig

if (tag <= Monatstage[monat-1])

{
 for (i=0; i < monat-1; i++)
     Tage = Tage + Monatstage[i];

 	 Tage = Tage + tag;
}
	return (uint16_t)Tage;
}


void sz_ein(uint16_t Jahr)
{
	uint16_t Tag,t; t = 31;	//Datum Tag fr Beginn Sommerzeit
	Tag = t -=  ( 4 + Jahr*5 / 4) % 7;
	current_time.Tag_Sz_Ein=(uint16_t)Tag;
	return;
}
void sz_aus(uint16_t Jahr)
{
	uint16_t Tag,t; t = 31;	//Datum Tag fr Ende Sommerzeit
	Tag = t -= (Jahr + 1 + Jahr / 4)% 7;
	current_time.Tag_Sz_Aus = (uint16_t)Tag;
	return;
}

void daten (void)
{
	current_time.Monat_SZ_Ein = 3;  // Mrz
	current_time.Monat_SZ_Aus = 10; // Oktober
	// Alle bentigten Zeiten fr Sommerzeitumstellung werden in Tage zur besseren Verarbeitung umrechnen

	sz_ein(RTC_DateStructure.RTC_Year); 	//Berechnung SZ ein in Tagen
	sz_aus(RTC_DateStructure.RTC_Year); 	//Berechnung SZ aus in Tagen

	// Tag des Jahres, Plus Kontrolle des Schaltjahre
	current_time.Tag_Heute = tag_des_jahres(RTC_DateStructure.RTC_Date,RTC_DateStructure.RTC_Month,RTC_DateStructure.RTC_Year);
	current_time.Tag_Rise  = tag_des_jahres(current_time.Tag_Sz_Ein,current_time.Monat_SZ_Ein,RTC_DateStructure.RTC_Year);
	current_time.Tag_Set  = tag_des_jahres(current_time.Tag_Sz_Aus,current_time.Monat_SZ_Aus,RTC_DateStructure.RTC_Year);
	// Alle bentigten Zeiten in Minuten zur besseren Verarbeitung umrechnen
	current_time.Al_Rise_Min = ausgabe_zeit_rise.RTC_Hours*60 + ausgabe_zeit_rise.RTC_Minutes;	//RISE in Minuten
	current_time.Al_Set_Min  = ausgabe_zeit_set.RTC_Hours*60  + ausgabe_zeit_set.RTC_Minutes;	//SET in Minuten
	current_time.Al_Time_Min = RTC_TimeStructure.RTC_Hours*60 + RTC_TimeStructure.RTC_Minutes;

}

void backup_vbat(void)
{
if (RTC_ReadBackupRegister(RTC_BKP_DR0) != 0x32F2)
{
  /* RTC configuration  */
  RTC_Config();

  /* Configure the RTC data register and RTC prescaler */
  RTC_InitStructure.RTC_AsynchPrediv = AsynchPrediv;
  RTC_InitStructure.RTC_SynchPrediv = SynchPrediv;
  RTC_InitStructure.RTC_HourFormat = RTC_HourFormat_24;

  /* Check on RTC init */
  if (RTC_Init(&RTC_InitStructure) == ERROR)
  {
   // printf("\n\r        /!\\***** RTC Prescaler Config failed ********/!\\ \n\r");
  }

  /* Configure the time register */
  //RTC_TimeRegulate();
}
else
{
  /* Check if the Power On Reset flag is set */
  if (RCC_GetFlagStatus(RCC_FLAG_PORRST) != RESET)
  {
   // printf("\r\n Power On Reset occurred....\n\r");
  }
  /* Check if the Pin Reset flag is set */
  else if (RCC_GetFlagStatus(RCC_FLAG_PINRST) != RESET)
  {
    //printf("\r\n External Reset occurred....\n\r");
  }

  //printf("\n\r No need to configure RTC....\n\r");

  /* Enable the PWR clock */
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_PWR, ENABLE);

  /* Allow access to RTC */
  PWR_BackupAccessCmd(ENABLE);

  /* Wait for RTC APB registers synchronisation */
  RTC_WaitForSynchro();

  /* Clear the RTC Alarm Flag */
  RTC_ClearFlag(RTC_FLAG_ALRAF);

  /* Clear the EXTI Line 17 Pending bit (Connected internally to RTC Alarm) */
  EXTI_ClearITPendingBit(EXTI_Line17);

}

/* RTC Alarm A Interrupt Configuration */
/* EXTI configuration *********************************************************/


EXTI_ClearITPendingBit(EXTI_Line17);
EXTI_InitStructure.EXTI_Line = EXTI_Line17;
EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising;
EXTI_InitStructure.EXTI_LineCmd = ENABLE;
EXTI_Init(&EXTI_InitStructure);

/* Enable the RTC Alarm Interrupt */
NVIC_InitStructure.NVIC_IRQChannel = RTC_Alarm_IRQn;
NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
NVIC_Init(&NVIC_InitStructure);
}

void init_tim2(void)
{
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, ENABLE);    //TIM2 mit einem Takt versorgen

	NVIC_InitStructure.NVIC_IRQChannel = TIM2_IRQn;   //Interrupt Kanal auswhlen. Hier TIM2
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1; //Interrupt Prioritt festlegen
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;      //Interrupt Unterprioritt festlegen
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;         //Aktivieren des Interrupts
	NVIC_Init(&NVIC_InitStructure);                         //Konfiguration bernehmen



	TIM_TimeBaseStructure.TIM_Prescaler = 5250;                 // Clock Teiler 168MHz / 5250 = 32kHz
	TIM_TimeBaseStructure.TIM_Period = 16000;                   // Anzahl Durchlufe bis berlauf Interrupt 32kHz / 16000 = 0,5s
	TIM_TimeBaseStructure.TIM_ClockDivision = TIM_CKD_DIV1;     //Keine Clock Division
	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up; //Hochzhlender Timer Modus
	TIM_TimeBaseInit(TIM2,&TIM_TimeBaseStructure);
	TIM_Cmd(TIM2, ENABLE);                                  //Timer Aktivieren

	TIM_ClearFlag(TIM2,TIM_FLAG_Update);                   //Interrupt Flag von TIM2 lschen
	TIM_ITConfig(TIM2,TIM_IT_Update, ENABLE);              //Interrupt fr TIM2 Aktivieren
	TIM_ClearFlag(TIM2,TIM_FLAG_Update);                   //Interrupt Flag fr TIM2 Lschen

}

void TIM2_IRQHandler(void)
{
	TIM_ClearFlag(TIM2, TIM_FLAG_Update);         //Interrupt Flag von TIM2 Lschen
	STM_EVAL_LEDToggle(LED3);

	//Interrupt Flag von TIM2 Lschen
}

// Ende
