/*
 * main.h
 *
 *  Created on: Dec 31, 2011
 *      Author: gerdi
 */

#ifndef MAIN_H_
#define MAIN_H_



#include "stdio.h"
#include "stdlib.h"

#include "stm32f4xx.h"
#include "stm32f4xx_conf.h"
#include "stm32f4_discovery.h"
#include "stm32f4xx_usart.h"
#include "stm32f4xx_gpio.h"
#include "dogm_128.h"
#include "sun.h"

typedef struct {

	uint16_t Al_Rise_Min;	//  RISE in Minuten
	uint16_t Al_Set_Min;	// SET in Minuten
	uint16_t Al_Time_Min;	// Aktuelle Zeit in Minuten
	uint16_t Tag_Rise;		//  RISE in Minuten
	uint16_t Tag_Set;		// SET in Minuten
	uint16_t Tag_Heute;		// softwaremig ermittelt
	uint16_t Tag_Sz_Ein;
	uint16_t Tag_Sz_Aus;
	uint16_t Sz_Ein;		// Variable zur Speicherung im RTC-RAM
	uint16_t Monat_SZ_Ein;  // 3 Mrz
	uint16_t Monat_SZ_Aus;	// 10 Oktober

} RTCTime;


extern RTC_DateTypeDef RTC_DateStructure;
extern RTC_TimeTypeDef ausgabe_zeit_rise;
extern RTC_TimeTypeDef ausgabe_zeit_set;

#define FALSE 0
#define false 0
#define TRUE  1
#define true  1

void init_tim2(void);
void backup_vbat(void);
void RTC_Config(void);
extern void Delay(__IO uint32_t nCount);
void RTC_TimeShow(void);
void RTC_AlarmShow(void);
void RTC_TimeRegulate(void);
void RTC_Alarm_IRQHandler(void);
void set_time (void);
void set_alarm (void);
void ausgabe_lcd(void);
void sz_aus(uint16_t Jahr);
void sz_ein(uint16_t Jahr);
uint16_t tag_des_jahres(uint16_t tag,uint16_t monat,uint16_t jahr);
uint16_t ist_schaltjahr(uint16_t jahr);
void daten (void);

#endif /* MAIN_H_ */
