

#include "hardware_t.h"
#include "tc_vars.h"
#include "flash_t.h"
#include "display_t.h"
#include "userif_t.h"
#include "signal_t.h"

#include "math.h"

// Class Display
// Public Functions
void Display::Init(void)											// Init Display Subroutine
{

	unsigned long *flash_address;
	int x, result = 0;

	printf("- Display initialization\r");

	Pulse11.Init(0.000000016, 0.000000016, 0.268435448, 0.000000008, 2, 3, "", "", "s");
	Pulse12.Init(0.000000008, 0.000000008, 0.000524000, 0.000000008, 2, 3, "", "", "s");
	Pulse21.Init(0.000000016, 0.000000016, 0.268435448, 0.000000008, 2, 3, "", "", "s");
	Pulse22.Init(0.000000016, 0.000000016, 0.268435448, 0.000000008, 2, 3, "", "", "s");
	
        switch(Pulse11_Expo)
        {
            case 1:
            {
                Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse11.Write_Value((float) Pulse11_Value / (float) 1000);
                break;
            }
        }
        Pulse11.RenderText();

        switch(Pulse12_Expo)
        {
            case 1:
            {
                Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse12.Write_Value((float) Pulse12_Value / (float) 1000);
                break;
            }
        }
        Pulse12.RenderText();

        switch(Pulse21_Expo)
        {
            case 1:
            {
                Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse21.Write_Value((float) Pulse21_Value / (float) 1000);
                break;
            }
        }
        Pulse21.RenderText();

        switch(Pulse22_Expo)
        {
            case 1:
            {
                Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse22.Write_Value((float) Pulse22_Value / (float) 1000);
                break;
            }
        }
        Pulse22.RenderText();	

	// init normal cursor data display
	Cursor_Delta_X.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "@X = ", "s");
	Cursor_Delta_1X.Init(0.00000001, 0.00000001, 10, 0.000000005, 3, 5, "", "1/@X = ", "Hz");
	Cursor_Delta_XY_X.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");

	Cursor_Vertical_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "s");
	Cursor_Vertical_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "s");

	Cursor_Vertical_Pos_XY_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	Cursor_Vertical_Pos_XY_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");

	Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");

	// init FFT cursor data display
	FFT_Cursor_Delta_X.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "@X = ", "Hz");
	FFT_Cursor_Delta_1X.Init(0.00000001, 0.00000001, 10, 0.000000005, 3, 5, "", "1/@X = ", "s");
	FFT_Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");

	FFT_Cursor_Vertical_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "Hz");
	FFT_Cursor_Vertical_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "Hz");

	FFT_Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
	FFT_Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");

	// init QM-data display
	QM_Slot1.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Freq(@) :", "");
	QM_Slot2.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Pk-Pk(@) :", "");
	QM_Slot3.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Pk-Pk(@) :", "");	

//	QM_Slot1_Value.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "Hz");
//	QM_Slot2_Value.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
//	QM_Slot3_Value.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");	

	
//BF del	Math_Offset.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
	
	Math_Offset_mul.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_add.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_sub.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");

	Zero_Level1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(1) = ", "V");
	Zero_Level2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(2) = ", "V");
	Zero_Level3_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(3) = ", "V");
	Zero_Level4_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(4) = ", "V");
	
	Trigger_Level_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
	Trigger_ExtLevel_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");	
	Trigger_Offset_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "s");	
	
	Timebase_Offset_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "s");

	HoldOff.Init(0.000000008, 0.000000008, 0.15, 0.000000008, 3, 6, "", "", "s");  // start 8 ns , min 8 ns, max 150 ms, steps 8 ns , 2 afterdot, 5 maxlength, '' Text, '' PreText, 'S' Unit
	
	//BF obsolete FFT_Scale_Str.Init(0.00000004, 0.00000004, 300, 0.00000004, 2, 5, "", "", "dBV/");
	//BF obsolete FFT_Offset_Str.Init(0.00000004, 0.00000004, 300, 0.00000004, 2, 5, "", "", "dBV");
	
	switch(HoldOff_Expo)
	{
		case 1:
		{
			HoldOff.Write_StepSize(0.000000008);
			//HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000000);
			HoldOff.Write_Value((float) HoldOff_Value * 0.000000001);		// 10^9
			break;
		}
		case 2:
		{
			HoldOff.Write_StepSize(0.000001);
			//HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000);
			HoldOff.Write_Value((float) HoldOff_Value * 0.000001);			// 10^6	
			break;
		}
		case 3:
		{
			HoldOff.Write_StepSize(0.001);
			//HoldOff.Write_Value((float) HoldOff_Value / (float) 1000);
			HoldOff.Write_Value((float) HoldOff_Value * 0.001); 			// 10^3
			break;
		}
		case 4:		//BF not needed
		{
			HoldOff.Write_StepSize(1);
			HoldOff.Write_Value((float) HoldOff_Value);
			break;
		}
	}

	HoldOff.RenderText();	

//printf("Value : %d  Expo : %d Steps : %d  trig_holdoff_reg : %d  %x \r\n", HoldOff_Value, HoldOff_Expo, HoldOff_Steps, trig_holdoff_reg, trig_holdoff_reg);


//	if (HoldOff_Value) trig_holdoff_reg = (unsigned long) (HoldOff.Read_Value() / (float) 0.000000008);
//	else trig_holdoff_reg = 0x00000000;

	// init QM thresholds menu
	short QM_thr_ch = MenuStatus[MENU_QMTHRESHOLDS][0] - 27;
	if (thres_type[QM_thr_ch] == 49)	// percent
	{
		QM_Threshold_lower.Init(10, 5, 93, 1, 0, 3, "", "", "%");
		QM_Threshold_middle.Init(50, 6, 94, 1, 0, 3, "", "", "%");
		QM_Threshold_upper.Init(90, 7, 95, 1, 0, 3, "", "", "%");

		QM_Threshold_lower.Write_Value((float)thres_low[QM_thr_ch]);	
		QM_Threshold_lower.RenderText();
		
		QM_Threshold_middle.Write_Value((float)thres_mdl[QM_thr_ch]);	
		QM_Threshold_middle.RenderText();
		
		QM_Threshold_upper.Write_Value((float)thres_up[QM_thr_ch]);	
		QM_Threshold_upper.RenderText();
	}
	else					// absolute
	{
		QM_Threshold_lower.Init(800, 50, 20000, 1, 2, 3, "", "", "mV");
		QM_Threshold_middle.Init(1.2, 0.05, 20, 1, 2, 3, "", "", "V");
		QM_Threshold_upper.Init(1.2, 0.05, 20, 1, 2, 3, "", "", "V");
	}
	
	// init math scale value for all calculations
	Math_Offset_mul.Write_Value((float)Math_Mul_Offset * ScreenScaleFactor[math_mul_scale-166]);
	Math_Offset_mul.RenderText();
	Math_Offset_sub.Write_Value((float)Math_Sub_Offset * ScreenScaleFactor[math_sub_scale-150]);
	Math_Offset_sub.RenderText();
	Math_Offset_add.Write_Value((float)Math_Add_Offset * ScreenScaleFactor[math_add_scale-150]);
	Math_Offset_add.RenderText();	

	DRAW_SPLASH();
 	
	init_done = true;	

	printf("- Display initialization                - done\r\n");

}

//##########################################################################################################################################################
//BF find and set acive entry		#007
void Display::MenuPopupInit(short MenuPopupNr, short MenuStatusNr, short StartNr)
{
	unsigned short lMaxEntry = 0;
	short lButtonNo = 0;
	short lEntryNr = 0;
	
	// get button number
	lButtonNo = MenuPopupDef[MenuPopupNr][0];

	// 240 - 247 are reserved special functions
	if (MenuStatus[MenuStatusNr][lButtonNo] > 239 && MenuStatus[MenuStatusNr][lButtonNo] < 248) return; 
	if (MenuStatus[MenuStatusNr][lButtonNo] == 0) return; 

	// get new active popup entry number
	lEntryNr = MenuStatus[MenuStatusNr][lButtonNo] - StartNr;

	// get number of entries
	lMaxEntry = MenuPopupDef[MenuPopupNr][1];
	
	// reset the active entry
	for (int x = 0; x < lMaxEntry; x++)
	{
		if (MenuPopupStatus[MenuPopupNr][x] == 3) MenuPopupStatus[MenuPopupNr][x] = 2;
	}
	
	//set the new active entry
    	MenuPopupStatus[MenuPopupNr][lEntryNr] = 3;
 
}		

//##########################################################################################################################################################
//BF new menu initialization		#005
void Display::MenuInit(void)
{

	MenuPopupInit(0, MENU_DISPLAY, DRAW_FAST);		//draw mode
	MenuPopupInit(1, MENU_CURSOR, 27);			//cursor source
	MenuPopupInit(2, MENU_AUTOSCALE, 280);			//Autoscale TB Search Setup
	MenuPopupInit(3, MENU_QUICKMEASURE, 27);		//quick measure source
	MenuPopupInit(4, MENU_QUICKMEASURE, 52);		//quick measure select
	MenuPopupInit(5, MENU_QMDELAY, 27);			//  5 Quick Measurement Delay Settings Source1
	MenuPopupInit(6, MENU_QMDELAY, 27);			//  5 Quick Measurement Delay Settings Source2

	MenuPopupInit(7, MENU_PULSEWIDTH, 137);			// 7 Trigger Pulse Width Source

	MenuPopupInit(8, MENU_TRIGGEREDGE, 128);		// 8 Trigger Edge Settings for External Source

	MenuPopupInit(9, MENU_TRIGGERMODE, 92); 		// 9 Trigger mode

	MenuPopupInit(10, MENU_TRIGGERMODE, 95); 		// 10 Trigger Mode Coupling

	MenuPopupInit(11, MENU_TRIGGEREDGE, 131); 		// 11 Trigger Edge TV

	MenuPopupInit(12, MENU_TRIGGERSUB, 124); 		// 12 Trigger Sub Menu Single Trigger Setting

	if (MenuStatus[MENU_CHANNEL1][3] < 104) MenuStatus[MENU_CHANNEL1][3] = 104;
	if (MenuStatus[MENU_CHANNEL2][3] < 104) MenuStatus[MENU_CHANNEL2][3] = 104;
	if (MenuStatus[MENU_CHANNEL3][3] < 104) MenuStatus[MENU_CHANNEL3][3] = 104;
	if (MenuStatus[MENU_CHANNEL4][3] < 104) MenuStatus[MENU_CHANNEL4][3] = 104;
	if (MenuStatus[MENU_TRIGGERMODE][4] < 104) MenuStatus[MENU_TRIGGERMODE][4] = 104;
	

	MenuPopupInit(13, MENU_CHANNEL1, 6); 			// Channel 1 Coupling

	MenuPopupInit(14, MENU_CHANNEL2, 6); 			// Channel 2 Coupling

	MenuPopupInit(15, MENU_CHANNEL3, 6); 			// Channel 3 Coupling

	MenuPopupInit(16, MENU_CHANNEL4, 6); 			// Channel 4 Coupling
	
	MenuPopupInit(17, MENU_TRIGGERSUB, 114);		// 17 LED 1

	MenuPopupInit(18, MENU_TRIGGERSUB, 119);		// 18 LED 2

	MenuPopupInit(19, MENU_UTILITY, 264);			// 19 Calibration Set

	MenuPopupInit(20, MENU_TRIGGERSUB, 272);		// 20 Auto Pre Trigger setting

	MenuPopupInit(21, MENU_ACQUIRE, AVRG_OFF);		// 21 Average

	MenuPopupInit(22, MENU_ACQUIRE, FILT_OFF);			// 22 Filter Setting

	MenuPopupInit(23, MENU_ACQUIRE, 42);			// 23 Interpolation

	MenuPopupInit(24, MENU_QMPHASE, 27);			// 24 Quick Measurement Phase Settings Source1
	
	MenuPopupInit(25, MENU_QMPHASE, 27);			// 25 Quick Measurement Phase Settings Source2

	MenuPopupInit(26, MENU_QMTHRESHOLDS, 27);		// 26 Quick Measurement Threshold Source

	MenuPopupInit(27, MENU_QMTHRESHOLDS, 49);		// 27 Quick Measurement Threshold Type (Percent , Absolute)

	MenuPopupInit(28, MENU_TRIGGEREDGE, 137);		// 28 Trigger Edge Source

	MenuPopupInit(29, MENU_FFT, 137);			// 29 FFT Source

	MenuPopupInit(30, MENU_FFT, 193);			// 30 FFT Window
	
	MenuPopupInit(31, MENU_FFT, 66);			// 31 FFT Mode

	MenuPopupInit(32, MENU_FFT, 83);			// 32 FFT Length


//      init extended utility menu -> channel delay
	MenuStatus[MENU_EXTUTILS][0] = 203 + CH1_Del_Correct;
	MenuStatus[MENU_EXTUTILS][1] = 203 + CH2_Del_Correct;

	if (NumberOfChannels == 4)
	{
		MenuStatus[MENU_EXTUTILS][2] = 203 + CH3_Del_Correct;
		MenuStatus[MENU_EXTUTILS][3] = 203 + CH4_Del_Correct;
	}
	else
	{
		CH3_Del_Correct = 0;
		CH4_Del_Correct = 0;
		MenuStatus[MENU_EXTUTILS][2] = 246;		// for 2 Channel version set inactive
		MenuStatus[MENU_EXTUTILS][3] = 246;		// for 2 Channel version set inactive
		MenuItemDef[MENU_EXTUTILS][2] = 0;		// don't display button
		MenuItemDef[MENU_EXTUTILS][3] = 0;		// don't display button
	}
	
	MenuPopupInit(33, MENU_EXTUTILS, 203); 			// hardware->delay
	MenuPopupInit(34, MENU_EXTUTILS, 203); 			// hardware->delay
	MenuPopupInit(35, MENU_EXTUTILS, 203); 			// hardware->delay
	MenuPopupInit(36, MENU_EXTUTILS, 203); 			// hardware->delay
	MenuPopupInit(37, MENU_HARDWARE, 223);			// ADC-register setup

	//Pre Amp Menu (gain)
	MenuStatus[MENU_HARDWARE][1] = GainIdx + 230;		//BF #004
	MenuPopupInit(38, MENU_HARDWARE, 230);			//gain

	MenuStatus[MENU_QUICKPRINT][5] = QP_mode + 185;		//destination
	MenuStatus[MENU_QP_USB][5]     = QP_mode + 185;		//destination
	MenuPopupInit(39, MENU_QUICKPRINT, 185);


	// correct buffer size + menus
	if (MenuStatus[MENU_USTB][0] < USTB_SHIFT) 		// -> roll mode
	{ 
		MenuPopupStatus[42][2] = 2; 			// reactivate 32KB menu item
		MenuStatus[MENU_USTB][1] = USTB_Disp;		// reactivate popup menu for window
	}
	else							// -> shift mode
	{
		if (MenuStatus[MENU_USTB][2] == USTB_32KB)	// check if buffer size doesn't exceed 16KB in shift mode
		{
			MenuStatus[MENU_USTB][2] = USTB_16KB;	// reduce to 16KB
			MenuPopupStatus[42][1] = 3;		// activate 16KB item
		}

		MenuPopupStatus[42][2] = 1;			// set 32KB menu item inactive
		MenuStatus[MENU_USTB][1] = INACTIVE;		// set popup menu for window inactive
	}

	MenuPopupInit(40, MENU_USTB, 284);			// 40 USTB Mode
	MenuPopupInit(41, MENU_USTB, 288);			// 41 USTB Display
	MenuPopupInit(42, MENU_USTB, 296);			// 42 USTB Buffer Size

	MenuPopupInit(43, MENU_DISPL_SETUP, 300);		// 43 Grid Color
	MenuPopupInit(44, MENU_DISPL_SETUP, 248);		// 44 Grid Layout
	MenuPopupInit(45, MENU_DISPLAY, 320);			// 45 Channel no display
	MenuPopupInit(46, MENU_DISPL_SETUP, 330);		// 46 Status / Menu layout
	MenuPopupInit(47, MENU_ACQUIRE, 340);			// 47 Acquire / Logic
	


	// special settings for 2 channel version
	if (NumberOfChannels == 2)
	{
		Channel_3_Active = 0;
		Channel_4_Active = 0;
		
		LED_ON[2] = 0;
		LED_ON[3] = 0;
		MenuPopupStatus[1][2] = 0;	//cursor source
		MenuPopupStatus[1][3] = 0;	//cursor source
		MenuPopupStatus[3][2] = 0;	//quick measurement source
		MenuPopupStatus[3][3] = 0;	//quick measurement source
		MenuPopupStatus[5][2] = 0;	//quick measurement delay settings source1
		MenuPopupStatus[5][3] = 0;	//quick measurement delay settings source1
		MenuPopupStatus[6][2] = 0;	//quick measurement delay settings source2
		MenuPopupStatus[6][3] = 0;	//quick measurement delay settings source2
		MenuPopupStatus[7][2] = 0;	//pulse width source
		MenuPopupStatus[7][3] = 0;	//pulse width source
		MenuPopupStatus[24][2] = 0;	//quick measurement phase settings source1
		MenuPopupStatus[24][3] = 0;	//quick measurement phase settings source1
		MenuPopupStatus[25][2] = 0;	//quick measurement phase settings source2
		MenuPopupStatus[25][3] = 0;	//quick measurement phase settings source1
		MenuPopupStatus[26][2] = 0;	//quick measurement threshold source
		MenuPopupStatus[26][3] = 0;	//quick measurement threshold source
		MenuPopupStatus[28][2] = 0;	//edge source
		MenuPopupStatus[28][3] = 0;	//edge source
		MenuPopupStatus[29][2] = 0;	//FFT source
		MenuPopupStatus[29][3] = 0;	//FFT sorce

		MenuPopupStatus[45][4] = 0;	// channel no display 3
		MenuPopupStatus[45][5] = 0;	// channel no display 4
		MenuPopupStatus[45][6] = 0;	// channel no display 3 + 4
 	}


	MenuPopupActive = -1;

}

//##########################################################################################################################################################

void Display::DRAW_SPLASH(void)
{
	unsigned long x;
	char BufText[80];
	char BufText2[80];	
	char BufText3[80];	
	char BufText4[80];
	unsigned char Grid_Color_Buff = GridColor_Val;
	

        //printf("Draw Splash\r\n");

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}	
	
	GridColor_Val = WT_Logo_Color_Val;	// set color of grid layer
	Hardware::SetupADC();			// update register
	
	sprintf(BufText, "%1i.%1i.BF.%1i.%1i%s", tc_version, tc_subversion, tc_dev_version, tc_dev_subversion, tc_compilation);
	sprintf(BufText2, "%X.%c%c", tc_hw_version, tc_production_lot1, tc_production_lot2);
	sprintf(BufText3, "%06d%02d%1X%1X", tc_serial, ((tc_shipment_date & 0x0000FF00) >> 8), ((tc_shipment_date & 0x000000F0) >> 4), (tc_shipment_date & 0x0000000F));	
	sprintf(BufText4, "W%04dA", tc_model);
	
        //TEXTOUTvbig("Developed by", Splash_Data_PosX + 28, Splash_Data_PosY - 20, 1, UI_Plane1);		
   	TEXTOUTxvbig("BlueFlash Firmware", Splash_Logo_PosX - 14, Splash_Data_PosY - 20, 1, UI_Plane1);	
	
	TEXTOUTvbig("Model : ", Splash_Data_PosX + 28, Splash_Data_PosY + 50, 1, UI_Plane1);
	TEXTOUTvbig(BufText4, Splash_Data_PosX + 148, Splash_Data_PosY + 50, 1, UI_Plane1);	
		
	TEXTOUTvbig("Hardware Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 70, 1, UI_Plane1);
	TEXTOUTvbig(BufText2, Splash_Data_PosX + 148, Splash_Data_PosY + 70, 1, UI_Plane1);		
	TEXTOUTvbig("Software Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 90, 1, UI_Plane1);
	TEXTOUTvbig(BufText, Splash_Data_PosX + 148, Splash_Data_PosY + 90, 1, UI_Plane1);	
		
	TEXTOUTvbig("Serial Number : ", Splash_Data_PosX + 28, Splash_Data_PosY + 110, 1, UI_Plane1);
	TEXTOUTvbig(BufText3, Splash_Data_PosX + 148, Splash_Data_PosY + 110, 1, UI_Plane1);	 	
		
	TEXTOUTvbig("No Rights Reserved _ 2011", Splash_Data_PosX + 236, Splash_Data_PosY + 250, 1, UI_Plane1);

	AMDFlash::copy_flash_to_plane(WTAG_Logo_Half_Flash, UI_Plane5);
	AMDFlash::copy_flash_to_plane(WTAG_Logo, Grid_Plane);

	//Splash_drawed = true;

	dma->np_piodata = 1;					// enable DMA transfer for display data
	dma->np_piodata = 0;	


	//printf("Draw Splash finished\r\n");	

}

//##########################################################################################################################################################
/* not used anymore
void Display::REMOVE_SPLASH(void)
{
	unsigned long x;
	char BufText[80];
	char BufText2[80];	
	char BufText3[80];	
	char BufText4[80];
	
	sprintf(BufText, "%1i.%1i.BF.%1i.%1i%s", tc_version, tc_subversion, tc_dev_version, tc_dev_subversion, tc_compilation);
	sprintf(BufText2, "%X.%c%c", tc_hw_version, tc_production_lot1, tc_production_lot2);
	sprintf(BufText3, "%06d%02d%1X%1X", tc_serial, ((tc_shipment_date & 0x0000FF00) >> 8), ((tc_shipment_date & 0x000000F0) >> 4), (tc_shipment_date & 0x0000000F));	
	sprintf(BufText4, "W%04dA", tc_model);


	// Clear Buffer Planes
	for (x = 0; x < 9600; x++)
	{
		Buffer_Plane1[x] = 0;
		Buffer_Plane2[x] = 0;
		Buffer_Plane3[x] = 0;
		Buffer_Plane4[x] = 0;
		Buffer_PlaneM[x] = 0;
		Buffer_UI2Plane[x] = 0;
		Buffer_Mark1Plane[x] = 0;
		UI_Plane5[x] = 0;
	}

	BITBITMAP(bitbmWTAG, Splash_Logo_PosX, Splash_Logo_PosY, 0, Grid_Plane);
			
	//TEXTOUTvbig("Developed by", Splash_Data_PosX + 28, Splash_Data_PosY - 20, 0, UI_Plane1);		
	TEXTOUTxvbig("BlueFlash Firmware", Splash_Logo_PosX - 14, Splash_Data_PosY - 20, 0, UI_Plane1);
	
	TEXTOUTvbig("Model : ", Splash_Data_PosX + 28, Splash_Data_PosY + 50, 0, UI_Plane1);
	TEXTOUTvbig(BufText4, Splash_Data_PosX + 148, Splash_Data_PosY + 50, 0, UI_Plane1);	
		
	TEXTOUTvbig("Hardware Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 70, 0, UI_Plane1);
	TEXTOUTvbig(BufText2, Splash_Data_PosX + 148, Splash_Data_PosY + 70, 0, UI_Plane1);		
	
	TEXTOUTvbig("Software Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 90, 0, UI_Plane1);
	TEXTOUTvbig(BufText, Splash_Data_PosX + 148, Splash_Data_PosY + 90, 0, UI_Plane1);	
		
	TEXTOUTvbig("Serial Number : ", Splash_Data_PosX + 28, Splash_Data_PosY + 110, 0, UI_Plane1);
	TEXTOUTvbig(BufText3, Splash_Data_PosX + 148, Splash_Data_PosY + 110, 0, UI_Plane1);	 	
		
	TEXTOUTvbig("No Rights Reserved _ 2011", Splash_Data_PosX + 236, Splash_Data_PosY + 250, 0, UI_Plane1);		
			
	//GridColor_Val = GridColorArray[ColorPalette][GridColorArrayPos];
	//Hardware::SetupADC();

}
*/
//##########################################################################################################################################################

void Display::DrawInitialScreen(void)
{
	unsigned long lX;

	switch (MenuStatus[MENU_DISPL_SETUP][2])
	{
		case 330: DrawMono = 0; Text_Plane = UI_Plane2; break;	// standard
		case 331: DrawMono = 1; Text_Plane = Grid_Plane; break;	// mono grid
		case 332: DrawMono = 1; Text_Plane = UI_Plane3; break;	// mono white
		case 333: DrawMono = 1; Text_Plane = UI_Plane4; break;	// mono yellow
		case 334: DrawMono = 1; Text_Plane = Marker_Plane2; break;// mono red
		case 335: DrawMono = 1; Text_Plane = Channel_Plane1; break;// neon yellow
		case 336: DrawMono = 1; Text_Plane = Channel_Plane2; break;// neon green
		case 337: DrawMono = 1; Text_Plane = Channel_Plane3; break;// neon blue
		case 338: DrawMono = 1; Text_Plane = Channel_Plane4; break;// neon red
	}

	// Clear All Planes
	for (lX = 0; lX < 153600; lX++)
	{ Planes[lX] = 0; }
	
	// clear buffer planes
	for (lX = 0; lX < 9600; lX++)
	{
		Buffer_Mark1Plane[lX] = 0;
		Buffer_UI2Plane[lX]   = 0;
		Buffer_PlaneM[lX] = 0;
		Buffer_Plane1[lX] = 0;
		Buffer_Plane2[lX] = 0;
		Buffer_Plane3[lX] = 0;
		Buffer_Plane4[lX] = 0;
	}

	if (DrawMono==0)
	{

		//Top -> status area above the grid
		for (lX = TOP_PLANE_MIN; lX < TOP_PLANE_MAX; lX++)
		{ UI_Plane3[lX] = 0xFFFFFFFF; }

		//Bottom -> function button area
		for (lX = BOTT_PLANE_MIN; lX < BOTT_PLANE_MAX; lX++)
		{ UI_Plane3[lX] = 0xFFFFFFFF; }
	}

	GridColor_Val = GridColorArray[ColorPalette][GridColorArrayPos];
	Hardware::SetupADC();

	//------------------------------------------------------------------------------
	//Draw Grids		//BF
	//------------------------------------------------------------------------------
	if (XY_Mode)								// Check if XY-mode
	GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw XY grid into gridplane
	else if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON) 				// delayed mode
	GRIDDELAYED(GRID_XOFFS, GRID_YOFFS, Grid_Plane);
	else if (FFT_Mode != FFT_OFF) 						// FFT mode
	GRIDFFT(GRID_XOFFS_FFT, GRID_YOFFS_FFT, Grid_Plane);			// Draw FFT grid into gridplane
	else 									// main mode
	GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw main grid into gridplane
	
	
	//Print text into the top area
	VoltageChangedCh1 = 1;
	VoltageChangedCh2 = 1;
	VoltageChangedCh3 = 1;
	VoltageChangedCh4 = 1;

	TimebaseChanged     = 1;
//	TimeOffsetChanged   = 1;
	TriggerLevelChanged = 1;
	TriggerModeChanged  = 1;
	TriggerWayChanged   = 1;

	StatusUpdate();

	FFT_DrawStatus(0);	// draw FFT status values
	
	Cursor_Data_First_Draw = 1;
	Quick_Measure_First_Draw = 1;
	Menu_First_Draw = 1;
	Menu_Changed = 1;

}
//##########################################################################################################################################################

void Display::RefreshScreen(void)
{
	unsigned long lX;

// BF delete old cursors and markers
	//Grid area
	for (lX = GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{
		Buffer_Mark1Plane[lX] = 0;
		Marker_Plane1[lX]     = 0;
		Marker_Plane2[lX]     = 0;
		Buffer_UI2Plane[lX]   = 0;

		Channel_Plane1[lX] = 0;
		Channel_Plane2[lX] = 0;
		Channel_Math_Plane[lX] = 0;

		Buffer_Plane1 [lX] = 0;
		Buffer_Plane2 [lX] = 0;
		Buffer_PlaneM [lX] = 0;
		UI_Plane3[lX]      = 0;
		UI_Plane4[lX]      = 0;
	}	

	if(NumberOfChannels == 4)
	{
		for (lX = GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
		{
			Channel_Plane3[lX] = 0;
			Channel_Plane4[lX] = 0;
	
			Buffer_Plane3 [lX] = 0;
			Buffer_Plane4 [lX] = 0;
		}	
	}

	if (!Cursor_Enabled && !QM_Enabled)
	{ Display::DrawCursorDeltaValues(0); }					// remove the cursor data

	//------------------------------------------------------------------------------
	//Draw Grids		//BF
	//------------------------------------------------------------------------------
	if (XY_Mode)								// Check if XY-mode
	GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw XY grid into gridplane
	else if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON) 			// delayed mode
	GRIDDELAYED(GRID_XOFFS, GRID_YOFFS, Grid_Plane);
	else if (FFT_Mode != FFT_OFF) 						// FFT mode
	GRIDFFT(GRID_XOFFS_FFT, GRID_YOFFS_FFT, Grid_Plane);			// Draw FFT grid into gridplane
	else 									// main mode
	GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw main grid into gridplane
	

	VoltageChangedCh1 = 1;	
	VoltageChangedCh2 = 1;	
	if(NumberOfChannels == 4)
	{
		VoltageChangedCh3 = 1;	
		VoltageChangedCh4 = 1;	
	}	

	//Print text into the top area
	StatusUpdate();

	if (MenuStatus[MENU_TIMEBASE][4] == BTN_ON)
	Display::DRAWMEMORY(0, 1, 1);				//draw memory window if browse is on


	FFT_DrawStatus(0);					//draw status if FFT is active

}
//##########################################################################################################################################################
//BF -> draw solid bar in a plane  -> filled rectangle = bar -> rename...
void Display::Rect(int x, int y, int dx, int dy, char set, unsigned long *planeaddress)
{
	int pos;
	int bit;
	int bitbuf;
	int intbuf;
	long BitMaskBuf;
	
	int ctx, cty;
		
	intbuf = (x >> 5);	
	
	bit = (x - (intbuf << 5));
	bitbuf = bit;
		
	for (cty = y; cty < (y + dy); cty++)
	{
		bit = bitbuf;
		if (set == 1) BitMaskBuf = BitMasks2[bit];
		else BitMaskBuf = BitMasks[bit];
		
		pos = (cty * 20) + intbuf;
				
		for (ctx = dx; ctx > 0; ctx--)
		{
			if (set == 1)
			{
				*(planeaddress + pos) = *(planeaddress + pos) | BitMaskBuf;
				BitMaskBuf >>= 1;
			}
			else
			{
				*(planeaddress + pos) = *(planeaddress + pos) & BitMaskBuf;
				BitMaskBuf >>= 1;
				BitMaskBuf |= 0x80000000;				
			}			
		
			bit++;
			
			if (bit > 31)
			{
				bit = 0;
				pos++;
				if (set == 1) BitMaskBuf = 0x80000000;
				else BitMaskBuf = 0x7FFFFFFF;
			}
		}		
	}	
}
//##########################################################################################################################################################
//BF -> Draw single pixel in a plane
//void Display::PIXELP(int x, int y, char set, unsigned long *planeaddress)
inline void PIXELP(int x, int y, char set, unsigned long *planeaddress)
{
	int pos;
	int bit;
	int intbuf;
	
	intbuf = x >> 5;	
	pos = Display_Line_Adresses[y] + intbuf;		
	bit = x - (intbuf << 5);
	
	if (set == 1) *(planeaddress + pos) |= BitMasks2[bit];
	else *(planeaddress + pos) &= BitMasks[bit];
}

//void Display::PixelOn(int x, int y, unsigned long *planeaddress)
inline void PixelOn(int x, int y, unsigned long *planeaddress)
{
	int pos;
	int bit;
	int intbuf;
	
	intbuf = x >> 5;	
	pos = Display_Line_Adresses[y] + intbuf;		
	bit = x - (intbuf << 5);
	
	*(planeaddress + pos) |= BitMasks2[bit];
}

//void Display::PixelOff(int x, int y, unsigned long *planeaddress)
inline void PixelOff(int x, int y, unsigned long *planeaddress)
{
	int pos;
	int bit;
	int intbuf;
	
	intbuf = x >> 5;	
	pos = Display_Line_Adresses[y] + intbuf;
	bit = x - (intbuf << 5);
	
	*(planeaddress + pos) &= BitMasks[bit];
}

//##########################################################################################################################################################
// BF this function draws vertical lines
// BF Attention!!! y and y2 must not be equal because in this case system crashes. The first point on vertical
// position y is not drawn -> this must be done via PIXELP()
void Display::Connect_Pixels(int x, short y, short y2, int dir, unsigned long *planeaddress)
{
        if (dir == 1)
        {
            asm("
             MOV	%r1, %i0                   ; Load X to %r1

             MOV	%r2, %i0                   ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i1                   ; Load Y to %r3

             ;ADDI   %r3, GRID_YOFFS               ; Add Correction Value -> BF del no offset here!!

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             MOV	%r4, %i4                   ; Load BufferAddress to %r4

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x80000000)            ; Load bitmask
             MOVI	%r5,%lo(0x80000000)
             PFX	%xhi(0x80000000)
             MOVHI	%r5,%xlo(0x80000000)

             LSR    %r5, %r1                       ; Calculate Bit to set


             MOV    %r6, %i2                       ; Load End Y to %r6

             SUB    %r6, %i1                       ; Get the Difference

             cp_loop1:

             LD     %r0, [%r4]                     ; Load Value from Memory
             OR     %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop1                       ; Jump to Loop
             NOP

            ");
        }
    	else
        {
            asm("
             MOV	%r1, %i0                       ; Load X to %r1

             MOV	%r2, %i0                       ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i2                       ; Load Y to %r3

             ;ADDI   %r3, GRID_YOFFS                ; Add Correction Value BF del

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             MOV    %r4, %i4                       ; Load BufferAddress to %r4

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x80000000)                ; Load bitmask
             MOVI	%r5,%lo(0x80000000)
             PFX	%xhi(0x80000000)
             MOVHI	%r5,%xlo(0x80000000)

             LSR    %r5, %r1                       ; Calculate Bit to set

             MOV    %r6, %i1                       ; Load End Y to %r6

             SUB    %r6, %i2                       ; Get the Difference

             cp_loop2:

             LD     %r0, [%r4]                     ; Load Value from Memory
             OR     %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop2                       ; Jump to Loop
             NOP

            ");
	   }		
}

//##########################################################################################################################################################
// BF complete new routine with Bresenham algorithm
//void Display::DRAWLINEP(int x1, int y1, int x2, int y2, char set, unsigned long *plane)	// Draw a Line
inline void DRAWLINEP(int x1, int y1, int x2, int y2, char set, unsigned long *plane)	// Draw a Line
{
	
	//--------------------------------------------
	//special case horizontal line
	//--------------------------------------------
	if(y1 == y2)
	{
		if(x1 < x2)
		for(; x1 <= x2; x1++)	{ PIXELP( x1, y1, set, plane); }
		else
		for(; x2 <= x1; x2++)	{ PIXELP( x2, y1, set, plane); }
		return;
	}	

	//--------------------------------------------
	//special case vertical line
	//--------------------------------------------
	else if(x1 == x2)
	{
		if(y1 < y2)
		for(; y1 <= y2; y1++)	{ PIXELP( x1, y1, set, plane); }
		else
		for(; y2 <= y1; y2++)	{ PIXELP( x1, y2, set, plane); }
		return;
	}	

	//-------------------------------------------------------------
	// Bresenham algorithm for drawing diagonal lines
	//-------------------------------------------------------------
	int dy = y2 - y1;
        int dx = x2 - x1;
        int stepx, stepy;

	//check if delta is positive or negative
	if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }

	//special case exact 45 degrees delta x / delta y = 1
	if (dx == dy)
	{
		//horizontal and vertical component increment constant with 1 
		if(x1 < x2) 
		{
			if(y1 < y2)
			{ 
				for(; x1 != x2; x1++, y1++)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1++, y1--)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
			
		}
		else if(x1 > x2)
		{
			if(y1 < y2) 
			{
				for(; x1 != x2; x1--, y1++)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1--, y1--)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
		}
	}

	
        dy <<= 1;                              		// dy is now 2*dy
        dx <<= 1;                              		// dx is now 2*dx
	
	//set starting point
	PIXELP( x1, y1, set, plane);
	
	//---------------------------------------------
	//between horizontal and 45 degrees
	//---------------------------------------------
	if (dx > dy)
	{
		int fraction = dy - (dx >> 1);   	// same as 2*dy - dx
		while (x1 != x2) {
			if (fraction >= 0) {
			y1 += stepy;
			fraction -= dx;              	// same as fraction -= 2*dx
			}
			x1 += stepx;
			fraction += dy;          	// same as fraction -= 2*dy
			PIXELP( x1, y1, set, plane);
		}
        	return;
	}

	//---------------------------------------------
	//between vertical and 45 degrees
	//---------------------------------------------
	if (dx < dy)
	{
		int fraction = dx - (dy >> 1);
		while (y1 != y2) {
			if (fraction >= 0) {
			x1 += stepx;
			fraction -= dy;
			}
			y1 += stepy;
			fraction += dx;
			PIXELP( x1, y1, set, plane);
		}
		return;
        }

}

// BF line routine with Bresenham algorithm and performance optimization
//void Display::Line(int x1, int y1, int x2, int y2, unsigned long *plane)	// Draw a Line
inline void Line(int x1, int y1, int x2, int y2, unsigned long *plane)	// Draw a Line
{
	
	//--------------------------------------------
	//special case horizontal line
	//--------------------------------------------
	if(y1 == y2)
	{
		if(x1 < x2)
		for(; x1 <= x2; x1++)	{ PixelOn( x1, y1, plane); }
		else
		for(; x2 <= x1; x2++)	{ PixelOn( x2, y1, plane); }
		return;
	}	

	//--------------------------------------------
	//special case vertical line
	//--------------------------------------------
	else if(x1 == x2)
	{
		if(y1 < y2)
		for(; y1 <= y2; y1++)	{ PixelOn( x1, y1, plane); }
		else
		for(; y2 <= y1; y2++)	{ PixelOn( x1, y2, plane); }
		return;
	}	

	//-------------------------------------------------------------
	// Bresenham algorithm for drawing diagonal lines
	//-------------------------------------------------------------
	int dy = y2 - y1;
        int dx = x2 - x1;
        int stepx, stepy;

	//check if delta is positive or negative
	if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }

	//special case exact 45 degrees delta x / delta y = 1
	if (dx == dy)
	{
		//horizontal and vertical component increment constant with 1 
		if(x1 < x2) 
		{
			if(y1 < y2)
			{ 
				for(; x1 != x2; x1++, y1++)
				{ PixelOn( x1, y1, plane); }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1++, y1--)
				{ PixelOn( x1, y1, plane); }
				return;
			}
			
		}
		else if(x1 > x2)
		{
			if(y1 < y2) 
			{
				for(; x1 != x2; x1--, y1++)
				{ PixelOn( x1, y1, plane); }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1--, y1--)
				{ PixelOn( x1, y1, plane); }
				return;
			}
		}
	}

	
        dy <<= 1;                              		// dy is now 2*dy
        dx <<= 1;                              		// dx is now 2*dx
	
	//set starting point
	PixelOn( x1, y1, plane);
	
	//---------------------------------------------
	//between horizontal and 45 degrees
	//---------------------------------------------
	if (dx > dy)
	{
		int fraction = dy - (dx >> 1);   	// same as 2*dy - dx
		while (x1 != x2) {
			if (fraction >= 0) {
			y1 += stepy;
			fraction -= dx;              	// same as fraction -= 2*dx
			}
			x1 += stepx;
			fraction += dy;          	// same as fraction -= 2*dy
			PixelOn( x1, y1, plane);
		}
        	return;
	}

	//---------------------------------------------
	//between vertical and 45 degrees
	//---------------------------------------------
	if (dx < dy)
	{
		int fraction = dx - (dy >> 1);
		while (y1 != y2) {
			if (fraction >= 0) {
			x1 += stepx;
			fraction -= dy;
			}
			y1 += stepy;
			fraction += dx;
			PixelOn( x1, y1, plane);
		}
		return;
        }

}
//##########################################################################################################################################################
// BF not needed any more
/*
void Display::DRAWZEROLINE(int y, char set, unsigned long *plane)
{

    int pos, cnt;

    pos = Display_Line_Adresses[y + 20];

    if (set) *(plane + pos) |= 0x00000FFF;
    else *(plane + pos) &= 0xFFF00000;

    for (cnt = 1; cnt < 19; cnt++)
    {
        if (set) *(plane + pos + cnt) = 0xFFFFFFFF;
        else *(plane + pos + cnt) = 0x00000000;
    }

    if (set) *(plane + pos + 19) |= 0xFFE00000;
    else *(plane + pos + 19) &= 0x001FFFFF;

}
*/
//##########################################################################################################################################################

void Display::TEXTOUTvbig(char *String, int x, int y, char set, unsigned long *layer)	// Draw Text at Pos X / Y with Color and BackColor (FF = Transparent)
{
	int Buf, Ct, Ctt, Bit;
	int count;
	
	count = strlen(String);

	// Start drawing background
	Bit = 0;									// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)							// Calculate the correction for the background
	{
		Buf = String[Ct] - 32;							// get the letter
		
		for (Ctt = 0;Ctt < 14; Ctt++)						// test the Bytes of the letter (x size)
		{
			if (FONT10X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;		// if itŽs size small than the minimum size 0x80 signals it
		}
	}	
	
	//Draw Background	
//	if (backcolor != 0xFF) Rect(x - 3, y - 4, (14 * count) + 5 - Bit, 18, backcolor, layer);	// Text background (0xFF transparent) (Lettercount * Minimumsize) - Lettersize correktion
	
	//Start drawing letters
	Bit = 0;									// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)							// Letterloop
	{
		Buf = String[Ct] - 32;							// get the letter
		
		for (Ctt = 0;Ctt < 14; Ctt++)						// Letterbyteloop
		{		
			if (FONT10X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;	// if Letterbyte = 0x80 the end of the letter is reached and the next letter not move forward
			else
			{
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y, set, layer);			// If Bit 0 set Pixel 0 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 1, set, layer);		// If Bit 1 set Pixel 1 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 2, set, layer);		// If Bit 2 set Pixel 2 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 3, set, layer);		// If Bit 3 set Pixel 3 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 4, set, layer);		// If Bit 4 set Pixel 4 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 5, set, layer);		// If Bit 5 set Pixel 5 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 6, set, layer);		// If Bit 6 set Pixel 6 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 7, set, layer);		// If Bit 7 set Pixel 7 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 8, set, layer);		// If Bit 8 set Pixel 8 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 9, set, layer);		// If Bit 9 set Pixel 9 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 10, set, layer);		// If Bit 10 set Pixel 10 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 11, set, layer);		// If Bit 11 set Pixel 11 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 12, set, layer);		// If Bit 12 set Pixel 12 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 13, set, layer);		// If Bit 13 set Pixel 13 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 14, set, layer);		// If Bit 14 set Pixel 14 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 15, set, layer);	// If Bit 15 set Pixel 15 in the Row is drawed in the color
			}							
		}
	}
}
//##########################################################################################################################################################

void Display::TEXTOUTxvbig(char *String, int x, int y, char set, unsigned long *layer)	// Draw Text at Pos X / Y with Color and BackColor (FF = Transparent)
{
	int Ct, Ctt, Bit;
	int count;
	unsigned char Buf;
	
	count = strlen(String);
	
	// Start drawing background
	Bit = 0;									// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)							// Calculate the correction for the background
	{
		Buf = String[Ct] - 32;							// get the letter
				
		for (Ctt = 0;Ctt < 14; Ctt++)						// test the Bytes of the letter (x size)
		{
			if (FONT12X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;		// if it's size small than the minimum size 0x80 signals it		
		}
	}	
	
	//Draw Background	
//	if (backcolor != 0xFF) Rect(x - 3, y - 3, (14 * count) + 5 - Bit, 19, backcolor, layer);	// Text background (0xFF transparent) (Lettercount * Minimumsize) - Lettersize correktion
	
	//Start drawing letters
	Bit = 0;													// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)								// Letterloop
	{
		Buf = String[Ct] - 32;								// get the letter
		for (Ctt = 0;Ctt < 14; Ctt++)							// Letterbyteloop
		{
			if (FONT12X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;	// if Letterbyte = 0x80 the end of the letter is reached and the next letter not move forward
			else
			{
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y, set, layer);					// If Bit 0 set Pixel 0 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 1, set, layer);				// If Bit 1 set Pixel 1 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 2, set, layer);				// If Bit 2 set Pixel 2 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 3, set, layer);				// If Bit 3 set Pixel 3 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 4, set, layer);				// If Bit 4 set Pixel 4 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 5, set, layer);				// If Bit 5 set Pixel 5 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 6, set, layer);				// If Bit 6 set Pixel 6 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 7, set, layer);				// If Bit 7 set Pixel 7 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 8, set, layer);			// If Bit 8 set Pixel 8 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 9, set, layer);			// If Bit 9 set Pixel 9 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 10, set, layer);			// If Bit 10 set Pixel 10 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 11, set, layer);			// If Bit 11 set Pixel 11 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 12, set, layer);		// If Bit 12 set Pixel 12 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 13, set, layer);		// If Bit 13 set Pixel 13 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 14, set, layer);		// If Bit 14 set Pixel 14 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 15, set, layer);		// If Bit 15 set Pixel 15 in the Row is drawed in the color
			}								
		}
	}
}
//##########################################################################################################################################################

void Display::BITBITMAP(unsigned char *pointer, int x, int y, unsigned char set, unsigned long *layer)	// Draw two color bitmap
{
	int cc, cx, cy, pos;
	unsigned char ccmask;

	int sizex = (int) pointer[0] / 8;
	int sizey = pointer[1];


	pos = 2;

	for (cy = 0; cy < sizey; cy++)
	{
		for (cx = 0; cx < sizex; cx++)
		{
			ccmask = 0x80;			
			
			for (cc = 0; cc < 8; cc++)
			{			
				if ((pointer[pos] & ccmask) == ccmask)
				{
					PIXELP(x + cc + (cx * 8), y + cy, set, layer);
				}
				ccmask = ccmask >> 1;
			}
			pos++;			
		}
	}
}
//##########################################################################################################################################################

// BF changed (complete grid changed, new subdivisions and new grid dimension GRID_WIDTH 600 x 400)
void Display::GRID(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;
	
	
	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	


	//---------------------------------------------------------------------------------------------
	// Horizontal (X) division from left to right - 12 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for (lX = x; lX < (x + GRID_WIDTH + 1); lX ++)
	{
		//draw top and bottom edge lines and middle line, 
		PIXELP(lX, y - 1, 1, layer);				// Top Line
		PIXELP(lX, y + GRID_HEIGHT + 1, 1, layer);		// Bottom Line
		//print every second point 
		if ((lX - x)%2 == 0) {
			PIXELP(lX, y + GRID_HEIGHT / 2, 1, layer);	// Middle Line
		}	
		
		
		//draw subdivisions every 10th pixel - one square is 50 pixel wide and has 5 subdivisions
		if( ((lX - x)%10 == 0)&&((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)) && ((lX - x)%50 != 0) )
		{
			//Top 2 pixel line for 5 subdivisions (every 10th x-pixel)
			PIXELP(lX, y + 0, 1, layer);
			PIXELP(lX, y + 2, 1, layer);
			//Middle top 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 3, 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 1, 1, layer);
			//Middle bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_HEIGHT / 2) + 1, 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT / 2) + 3, 1, layer);
			//Bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + GRID_HEIGHT - 2, 1, layer);
			PIXELP(lX, y + GRID_HEIGHT, 1, layer);
		}	

		//Main division - 50 pixel for one division
		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < GRID_WIDTH - 5) && ((lX - x) != (GRID_WIDTH / 2)))
		{
			//Top line division
			PIXELP(lX, y + 1, 1, layer);
			PIXELP(lX, y + 3, 1, layer);
			PIXELP(lX, y + 5, 1, layer);
			//Middle line top division
			PIXELP(lX, y + ((GRID_HEIGHT / 2) - 6), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) - 4), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) - 2), 1, layer);
			//Middle line bottom division
			PIXELP(lX, y + ((GRID_HEIGHT / 2) + 2), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) + 4), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) + 6), 1, layer);
			//Bottom line division
			PIXELP(lX, y + (GRID_HEIGHT - 5), 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT - 3), 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT - 1), 1, layer);

			//Grid lines vertical - grid width modulo 50 = 12 lines with one point every 10th pixel
			if (dotted_grid)
				for (lY = y + 10; lY < (y + GRID_HEIGHT - 5); lY += 10)	//dotted line
				{ PIXELP(lX, lY, 1, layer); }
			else
				for (lY = y; lY < (y + GRID_HEIGHT); lY ++)		//solid line
				{ PIXELP(lX, lY, 1, layer); }
		}	
		
	}
	
	//---------------------------------------------------------------------------------------------
	// Vertical (Y) division from top to bottom - 8 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for(lY = y; lY < (y + GRID_HEIGHT + 1); lY++)
	{
		PIXELP(x - 1, lY, 1, layer);				// Left side line
		PIXELP(x + GRID_WIDTH + 1, lY, 1, layer);		// Right side line	
		// one point every second pixel
		if ((lY - y)%2 == 0) 
		{
			PIXELP(x + (GRID_WIDTH / 2), lY, 1, layer);	// Vertical middle line
		}	

		//draw subdivisions every 10th pixel - one square is 50 pixel high and has 5 subdivisions
		if ( ((lY - y)%10== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5)) && ((lY - y) != (GRID_HEIGHT / 2)) && ((lY - y)%50 != 0) )
		{
			//Left side 2 pixel line for 5 subdivisions
			PIXELP(x + 0, lY, 1, layer);
			PIXELP(x + 2, lY, 1, layer);
			//Middle left side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_WIDTH / 2) - 3, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) - 1, lY, 1, layer);
			//Middle right side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_WIDTH / 2) + 1, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) + 3, lY, 1, layer);
			//Right side 2 pixel line for 5 subdivisions
			PIXELP(x + GRID_WIDTH - 2, lY, 1, layer);
			PIXELP(x + GRID_WIDTH, lY, 1, layer);
		}		
		

		// Vertical main division 400 : 50 = 8 squares high
		if (((lY - y)%50 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5)) && ((lY - y) != (GRID_HEIGHT / 2)))
		{
			// Left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + 1, lY, 1, layer);
			PIXELP(x + 3, lY, 1, layer);
			PIXELP(x + 5, lY, 1, layer);
			// Middle left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_WIDTH / 2) - 6, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) - 4, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) - 2, lY, 1, layer);
			// Middle right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_WIDTH / 2) + 2, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) + 4, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) + 6, lY, 1, layer);
			// Right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + GRID_WIDTH - 5, lY, 1, layer);
			PIXELP(x + GRID_WIDTH - 3, lY, 1, layer);
			PIXELP(x + GRID_WIDTH - 1, lY, 1, layer);

			//Gridlines horizontal - grid height modulo 50 = 8 lines with one point every 10th pixel
			if (dotted_grid)
				for (lX = x + 10 ; lX < (x + GRID_WIDTH - 5); lX += 10)	//dotted line
				{ PIXELP(lX, lY, 1, layer); }
			else
				for (lX = x; lX < (x + GRID_WIDTH); lX ++)	//solid line
				{ PIXELP(lX, lY, 1, layer); } 
		}		
	}
	
	//Gridlines horizontal - for 10% - 90% rise time determination with one point every 25th pixel
	lY = y + 75;		//90%
	//for (lX = x ; lX < (x + GRID_WIDTH); lX += 25)
	for (lX = x ; lX < (x + GRID_WIDTH); lX += 10)
	{	
		if (((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)))
		{
			//PIXELP(lX - 3, lY, 1, layer);
			PIXELP(lX, lY, 1, layer);
			//PIXELP(lX + 3, lY, 1, layer);
		}
	}

	lY = y + GRID_HEIGHT - 75;	//10%
	//for (lX = x ; lX < (x + GRID_WIDTH); lX += 25)
	for (lX = x ; lX < (x + GRID_WIDTH); lX += 10)
	{	
		if (((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)))
		{
			//PIXELP(lX - 3, lY, 1, layer);
			PIXELP(lX, lY, 1, layer);
			//PIXELP(lX + 3, lY, 1, layer);
		}
	}

	PIXELP(x - 1, y - 1, 1, layer); 				// Left top corner
	PIXELP(x + GRID_WIDTH + 1, y - 1, 1, layer); 			// Right top corner
	PIXELP(x - 1, y + GRID_HEIGHT + 1, 1, layer); 			// Left bottom corner
	PIXELP(x + GRID_WIDTH + 1, y + GRID_HEIGHT + 1, 1, layer); 	// Right bottom corner
}
//##########################################################################################################################################################

// BF changed (complete grid changed, new subdivisions and new grid dimension GRID_WIDTH 600 x 200 x 2)
void Display::GRIDDELAYED(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;
	unsigned long by = y + (GRID_HEIGHT / 2);	
	

	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	
	
	
	//Horizontal line drawing
	for(lX = x; lX < (x + GRID_WIDTH + 1); lX++)	//lX += 2)
	{
		PIXELP(lX, y - 1, 1, layer);										// Top Line
		PIXELP(lX, y + (GRID_HEIGHT / 4), 1, layer);								// Middle Line
		PIXELP(lX, y + ((GRID_HEIGHT / 2) + 1), 1, layer);							// Bottom Line
		
		
		if (((lX - x)%10 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)) && ((lX - x)%50 != 0))
		{
			PIXELP(lX, y + 0, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, y + 2, 1, layer);									// 10 er Dots Top Line
			
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 3, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 3, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 2, 1, layer);						// 10 er Dots Bottom Line
			PIXELP(lX, y + (GRID_HEIGHT / 2), 1, layer); 							// 10 er Dots Bottom Line
	
		}		

		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)))
		{

			PIXELP(lX, y + 1, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, y + 3, 1, layer); 									// 10 er Dots Top Line	
			PIXELP(lX, y + 5, 1, layer); 									// 10 er Dots Top Line	
			
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 6, 1, layer); 						// 10 er Dots Middle Line	
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 2, 1, layer);						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 2, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 6, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 5, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 3, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 1, 1, layer); 						// 10 er Dots Bottom Line	

			//Draw vertical line on every main X-division
			for(lY = (y + 5); lY < (y + (GRID_HEIGHT / 2)); lY += 5)	// 10 BF ???
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}
		
	}
	
	//Vertical line drawing
	for(lY = y; lY < (y + ((GRID_HEIGHT / 2) + 1)); lY++)	//lY += 2) 
	{
		PIXELP(x - 1, lY, 1, layer);										// Left Line
		PIXELP(x + (GRID_WIDTH / 2), lY, 1, layer);								// Middle Line
		PIXELP(x + GRID_WIDTH + 1, lY, 1, layer);								// Right Line
		
		if (((lY - y)%5 == 0) && ((lY - y) > 2) && ((lY - y) < ((GRID_HEIGHT / 2) - 2)) && ((lY - y) != (GRID_HEIGHT / 4)) && ((lY - y)%25 != 0))
		{
			PIXELP(x + 0, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 2, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + (GRID_WIDTH / 2) - 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 1, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 1, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + GRID_WIDTH - 2, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH, lY, 1, layer); 								// 10 er Dots Right Line
		}		
		
		if (((lY - y)%25 == 0) && ((lY - y) > 2) && ((lY - y) < ((GRID_HEIGHT / 2) - 2)) && ((lY - y) != (GRID_HEIGHT / 4)))
		{

			PIXELP(x + 1, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 3, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 5, lY, 1, layer); 									// 10 er Dots Left Line
			
			PIXELP(x + (GRID_WIDTH / 2) - 6, lY, 1, layer); 						// 10 er Dots Middle Line	
			PIXELP(x + (GRID_WIDTH / 2) - 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 6, lY, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(x + GRID_WIDTH - 5, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH - 3, lY, 1, layer); 							// 10 er Dots Right Line	
			PIXELP(x + GRID_WIDTH - 1, lY, 1, layer); 							// 10 er Dots Right Line

			//Draw horizontal line on every main Y-division
			for (lX = (x + 10); lX < (x + GRID_WIDTH); lX += 10)
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}		
	}
	
	PIXELP(x - 1, y - 1, 1, layer); 										// Left Top corner
	PIXELP(x + GRID_WIDTH + 1, y - 1, 1, layer);									// Right Top corner
	PIXELP(x - 1, y + ((GRID_HEIGHT / 2) + 1), 1, layer); 								// Left Bottom corner
	PIXELP(x + GRID_WIDTH + 1, y + ((GRID_HEIGHT / 2) + 1), 1, layer); 						// Right Bottom corner

	//-----------------------------------	
	// 	Delayed Part
	//-----------------------------------
	// Horizontal drawing
	for (lX = x; lX < (x + GRID_WIDTH + 1);	lX++)	//lX += 2)
	{
		PIXELP(lX, by - 1, 1, layer);										// Top Line
		PIXELP(lX, by + (GRID_HEIGHT / 4), 1, layer);								// Middle Line
		PIXELP(lX, by + ((GRID_HEIGHT / 2) + 1), 1, layer);							// Bottom Line
		
		
		if (((lX - x)%10 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)) && ((lX - x)%50 != 0))
		{
			PIXELP(lX, by + 0, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + 2, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 3, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 3, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 2, 1, layer);						// 10 er Dots Bottom Line
			PIXELP(lX, by + (GRID_HEIGHT / 2), 1, layer); 							// 10 er Dots Bottom Line
	
		}		

		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)))
		{

			PIXELP(lX, by + 1, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + 3, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + 5, 1, layer); 									// 10 er Dots Top Line
			
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 6, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 2, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 2, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 6, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 5, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 3, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 1, 1, layer);						// 10 er Dots Bottom Line	

			//Draw vertical line on every main X-division
			for (lY = (by + 5); lY < (by + (GRID_HEIGHT / 2)); lY += 5)	//10  BF ??
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}
		
	}
	
	//Vertical drawing
	for	(lY = by; lY < (by + ((GRID_HEIGHT / 2) + 1)); lY++) 	//lY += 2)
	{
		PIXELP(x - 1, lY, 1, layer);										// 2 er Dots Left Line
		PIXELP(x + (GRID_WIDTH / 2), lY, 1, layer);								// 2 er Dots Middle Line
		PIXELP(x + GRID_WIDTH + 1, lY, 1, layer);								// 2 er Dots Right Line		
		
		if (((lY - by)%5 == 0) && ((lY - by) > 2) && ((lY - by) < ((GRID_HEIGHT / 2) - 2)) && ((lY - by) != (GRID_HEIGHT / 4)) && ((lY - by)%25 != 0))
		{
			PIXELP(x + 0, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 2, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + (GRID_WIDTH / 2) - 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 1, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 1, lY, 1, layer);							// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + GRID_WIDTH - 2, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH, lY, 1, layer); 								// 10 er Dots Right Line
		}		
		
		if (((lY - by)%25 == 0) && ((lY - by) > 2) && ((lY - by) < ((GRID_HEIGHT / 2) - 2)) && ((lY - by) != (GRID_HEIGHT / 4)))
		{

			PIXELP(x + 1, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 3, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 5, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + (GRID_WIDTH / 2) - 6, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 6, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + GRID_WIDTH - 5, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH - 3, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH - 1, lY, 1, layer); 							// 10 er Dots Right Line

			//Draw horizontal line on every main Y-division
			for (lX = (x + 10); lX < (x + GRID_WIDTH); lX += 10)
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}		
	}
	
	PIXELP(x - 1, by - 1, 1, layer); 										// Left Top corner
	PIXELP(x + GRID_WIDTH + 1, by - 1, 1, layer); 									// Right Top corner
	PIXELP(x - 1, by + ((GRID_HEIGHT / 2) + 1), 1, layer); 								// Left Bottom corner
	PIXELP(x + GRID_WIDTH + 1, by + ((GRID_HEIGHT / 2) + 1), 1, layer); 						// Right Bottom corner
/*
	for (lX = x; lX < (x + GRID_WIDTH + 1); lX ++)
	{
		PIXELP(lX, by - 1, 1, layer);										// Top Line
		PIXELP(lX, by + 0, 1, layer);										// Middle Line
		PIXELP(lX, by + 1, 1, layer);										// Bottom Line
    	}
*/
}	//Grid delayed end
//##########################################################################################################################################################

// BF changed (complete grid changed, new subdivisions and new grid dimension 400 x 400)
void Display::GRIDXY(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;

	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	


	//---------------------------------------------------------------------------------------------
	// Horizontal (X) division from left to right - 8 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for (lX = x; lX < (x + GRID_XY + 1); lX ++)
	{
		//draw top and bottom edge lines and middle line, 
		PIXELP(lX, y - 1, 1, layer);			// Top Line
		PIXELP(lX, y + GRID_XY + 1, 1, layer);		// Bottom Line
		//print every second point 
		if ((lX - x)%2 == 0) {
			PIXELP(lX, y + GRID_XY / 2, 1, layer);	// Middle Line
		}	
		
		
		//draw subdivisions every 10th pixel - one square is 50 pixel wide and has 5 subdivisions
		if( ((lX - x)%10 == 0)&&((lX - x) > 5) && ((lX - x) < (GRID_XY - 5)) && ((lX - x) != (GRID_XY / 2)) && ((lX - x)%50 != 0) )
		{
			//Top 2 pixel line for 5 subdivisions (every 10th x-pixel)
			PIXELP(lX, y + 0, 1, layer);
			PIXELP(lX, y + 2, 1, layer);
			//Middle top 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_XY / 2) - 3, 1, layer);
			PIXELP(lX, y + (GRID_XY / 2) - 1, 1, layer);
			//Middle bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_XY / 2) + 1, 1, layer);
			PIXELP(lX, y + (GRID_XY / 2) + 3, 1, layer);
			//Bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + GRID_XY - 2, 1, layer);
			PIXELP(lX, y + GRID_XY, 1, layer);
		}	

		//Main division - 50 pixel for one divisin
		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < GRID_XY - 5) && ((lX - x) != (GRID_XY / 2)))
		{
			//Top line division
			PIXELP(lX, y + 1, 1, layer);
			PIXELP(lX, y + 3, 1, layer);
			PIXELP(lX, y + 5, 1, layer);
			//Middle line top division
			PIXELP(lX, y + ((GRID_XY / 2) - 6), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) - 4), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) - 2), 1, layer);
			//Middle line bottom division
			PIXELP(lX, y + ((GRID_XY / 2) + 2), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) + 4), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) + 6), 1, layer);
			//Bottom line division
			PIXELP(lX, y + (GRID_XY - 5), 1, layer);
			PIXELP(lX, y + (GRID_XY - 3), 1, layer);
			PIXELP(lX, y + (GRID_XY - 1), 1, layer);

			//Grid lines vertical - grid width modulo 50 = 8 lines with one point every 10th pixel
			if (dotted_grid)
			for (lY = y + 10; lY < (y + GRID_XY - 5); lY += 10)	//dotted line
			{ PIXELP(lX, lY, 1, layer); }
			else
			for (lY = y; lY < (y + GRID_XY); lY ++)		//solid line
			{ PIXELP(lX, lY, 1, layer); }
		}	
		
	}
	
	//---------------------------------------------------------------------------------------------
	// Vertical (Y) division from top to bottom - 8 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for(lY = y; lY < (y + GRID_XY + 1); lY++)
	{
		PIXELP(x - 1, lY, 1, layer);				// Left side line
		PIXELP(x + GRID_XY + 1, lY, 1, layer);			// Right side line	
		// one point every second pixel
		if ((lY - y)%2 == 0) 
		{
			PIXELP(x + (GRID_XY / 2), lY, 1, layer);	// Vertical middle line
		}	

		//draw subdivisions every 10th pixel - one square is 50 pixel high and has 5 subdivisions
		if ( ((lY - y)%10== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_XY - 5)) && ((lY - y) != (GRID_XY / 2)) && ((lY - y)%50 != 0) )
		{
			//Left side 2 pixel line for 5 subdivisions
			PIXELP(x + 0, lY, 1, layer);
			PIXELP(x + 2, lY, 1, layer);
			//Middle left side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_XY / 2) - 3, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) - 1, lY, 1, layer);
			//Middle right side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_XY / 2) + 1, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) + 3, lY, 1, layer);
			//Right side 2 pixel line for 5 subdivisions
			PIXELP(x + GRID_XY - 2, lY, 1, layer);
			PIXELP(x + GRID_XY, lY, 1, layer);
		}		
		

		// Vertical main division 400 : 50 = 8 squares high
		if (((lY - y)%50 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_XY - 5)) && ((lY - y) != (GRID_XY / 2)))
		{
			// Left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + 1, lY, 1, layer);
			PIXELP(x + 3, lY, 1, layer);
			PIXELP(x + 5, lY, 1, layer);
			// Middle left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_XY / 2) - 6, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) - 4, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) - 2, lY, 1, layer);
			// Middle right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_XY / 2) + 2, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) + 4, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) + 6, lY, 1, layer);
			// Right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + GRID_XY - 5, lY, 1, layer);
			PIXELP(x + GRID_XY - 3, lY, 1, layer);
			PIXELP(x + GRID_XY - 1, lY, 1, layer);

			//Gridlines horizontal - grid height modulo 50 = 8 lines with one point every 10th pixel
			if (dotted_grid)
			for (lX = x + 10 ; lX < (x + GRID_XY - 5); lX += 10)	//dotted line
			{ PIXELP(lX, lY, 1, layer); }
			else
			for (lX = x; lX < (x + GRID_XY); lX ++)		//solid line
			{ PIXELP(lX, lY, 1, layer); }
		}		
	}

	//Corners
	PIXELP(x - 1, y - 1, 1, layer); 			// Left top corner
	PIXELP(x + GRID_XY + 1, y - 1, 1, layer); 		// Right top corner
	PIXELP(x - 1, y + GRID_XY + 1, 1, layer); 		// Left bottom corner
	PIXELP(x + GRID_XY + 1, y + GRID_XY + 1, 1, layer); 	// Right bottom corner
}
//##########################################################################################################################################################

// BF new grid for FFT function with dimension 512 x 400
// BF new switchable frequency division
void Display::GRIDFFT(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;
	int lMainModulo, lSubModulo, lXoffs, lSubCnt=0; 


	if(FFT_grid)
	{lMainModulo = 51; lSubModulo = 10;lXoffs = 2;}	//10 frequency divisions - grid width (512) modulo 51 = 10 lines 
	else
	{lMainModulo = 64; lSubModulo = 16;lXoffs = 0;}	//8 frequency divisions - grid width (512) modulo 64 = 8 lines 
	

	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	

	//---------------------------------------------------------------------------------------------
	// Vertical lines - (X) division from left to right - 8 or 10 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for (lX = x,lSubCnt=-2; lX < (x + GRID_WIDTH_FFT + 1); lX ++, lSubCnt++)
	{
		//draw top and bottom edge lines, 
		PIXELP(lX, y-1, 1, layer);				// Top Line
		PIXELP(lX, y + GRID_HEIGHT_FFT + 1, 1, layer);		// Bottom Line
		
		
		//draw subdivisions every 16th or 10th pixel - one square is 64 or 51 pixel wide and has 4 subdivisions
		if( (lSubCnt%lSubModulo == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH_FFT - 5)) && ((lX - x) != (GRID_WIDTH_FFT / 2)) && (lSubCnt < lMainModulo-2))
		{
			//Top line 2 pixel line for 5 subdivisions (every 10th x-pixel)
			PIXELP(lX, y + 0, 1, layer);
			PIXELP(lX, y + 2, 1, layer);
			
		}	
	
		//Main division - 64 or 51 pixel for one division
		if (((lX - (x+lXoffs))%lMainModulo == 0) && ((lX - x) > 5) && ((lX - x) < GRID_WIDTH_FFT - 5))
		{
			lSubCnt = 0;
			//Grid lines vertical
			if (dotted_grid)
			{	//Top line main division 5 pixel long (only visible with dotted grid)
				PIXELP(lX, y + 1, 1, layer);
				PIXELP(lX, y + 3, 1, layer);
				PIXELP(lX, y + 5, 1, layer);

				for (lY = y + 10; lY < (y + GRID_HEIGHT_FFT - 5); lY += 10)	//dotted line with one point every 10th Y-pixel
				{ PIXELP(lX, lY, 1, layer); } }
			else
				for (lY = y; lY < (y + GRID_HEIGHT_FFT); lY ++)			//solid line
				{ PIXELP(lX, lY, 1, layer); }
		}	
		
	}

		
	// Horizontal lines for linear division
	if(FFT_Mode == FFT_MAGN || FFT_Mode == FFT_REAL || FFT_Mode == FFT_IMAG || FFT_Mode == FFT_REIM)
	{

		// Horizontal lines - (Y) division from top to bottom - 8 main divs and 5 sub divs
		for(lY = y; lY < (y + GRID_HEIGHT_FFT + 1); lY++)
		{
			PIXELP(x-1, lY, 1, layer);				// Left side line
			PIXELP(x + GRID_WIDTH_FFT + 1, lY, 1, layer);		// Right side line	
	
			//draw subdivisions every 10th pixel - one square is 50 pixel high and has 5 subdivisions
			if ( ((lY - y)%10== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5)) && ((lY - y) != (GRID_HEIGHT / 2)) && ((lY - y)%50 != 0) )
			{
				//Left side 2 pixel line for 5 subdivisions
				PIXELP(x + 0, lY, 1, layer);
				PIXELP(x + 2, lY, 1, layer);
	
				//Right side 2 pixel line for 5 subdivisions
				PIXELP(x + GRID_WIDTH_FFT - 2, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT, lY, 1, layer);
			}		
	
	
			// Vertical main division 400 : 50 = 8 squares high
			if (((lY - y)%50 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT_FFT - 5)) )
			{
	
				//Gridlines horizontal - grid height modulo 50 = 8 lines 
				if (dotted_grid)
				{
					// Left side 3 pixel line for 8 divisions a 50 pixel
					PIXELP(x + 1, lY, 1, layer);
					PIXELP(x + 3, lY, 1, layer);
					PIXELP(x + 5, lY, 1, layer);
		
					// Right side 3 pixel line for 8 divisions a 50 pixel
					PIXELP(x + GRID_WIDTH_FFT - 5, lY, 1, layer);
					PIXELP(x + GRID_WIDTH_FFT - 3, lY, 1, layer);
					PIXELP(x + GRID_WIDTH_FFT - 1, lY, 1, layer);

					//for (lX = x + 16 ; lX < (x + GRID_WIDTH_FFT - 5); lX += 16)	//dotted line with one point every 16th X-pixel
					for (lX = x,lSubCnt=-2; lX < (x + GRID_WIDTH_FFT + 1); lX ++, lSubCnt++)
					{	
						if( (lSubCnt%lSubModulo == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH_FFT - 5)) && ((lX - x) != (GRID_WIDTH_FFT / 2)) && (lSubCnt < lMainModulo-2))
						{PIXELP(lX, lY, 1, layer);}

						if((lX - (x+lXoffs))%lMainModulo == 0) lSubCnt = 0;
					}
				}
				else
					for (lX = x; lX < (x + GRID_WIDTH_FFT); lX ++)			//solid line
					{ PIXELP(lX, lY, 1, layer); } 
			}		
		}
	}

	//------------------------------------------------------------------------------------------------------
	//			horizontal logarithmic division for dBm values
	//------------------------------------------------------------------------------------------------------
	else if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)	// Horizontal lines for logarithmic division
	{
		
		// Horizontal lines - (Y) division from top to bottom - 5 main divs and 10 sub divs
		for(lY = y; lY < (y + GRID_HEIGHT_FFT + 1); lY++)
		{
			PIXELP(x-1, lY, 1, layer);				// Left side line
			PIXELP(x + GRID_WIDTH_FFT + 1, lY, 1, layer);		// Right side line	
	
			//draw subdivisions every 8th pixel - one square is 80 pixel high and has 10 subdivisions
			if ( ((lY - y)%8== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5) ) && ((lY - y)%80 != 0) )
			{
				//Left side 2 pixel line for 10 subdivisions
				PIXELP(x + 0, lY, 1, layer);
				PIXELP(x + 2, lY, 1, layer);
	
				//Right side 2 pixel line for 10 subdivisions
				PIXELP(x + GRID_WIDTH_FFT - 2, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT, lY, 1, layer);
			}		
	
	
			// Vertical main division 400 : 80 = 5 squares high
			if (((lY - y)%80 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT_FFT - 5)) )
			{
	
				//Gridlines horizontal - grid height modulo 80 = 5 lines 
				if (dotted_grid)
				{
					// Left side 3 pixel line for 5 divisions a 80 pixel
					PIXELP(x + 1, lY, 1, layer);
					PIXELP(x + 3, lY, 1, layer);
					PIXELP(x + 5, lY, 1, layer);
		
					// Right side 3 pixel line for 5 divisions a 80 pixel
					PIXELP(x + GRID_WIDTH_FFT - 5, lY, 1, layer);
					PIXELP(x + GRID_WIDTH_FFT - 3, lY, 1, layer);
					PIXELP(x + GRID_WIDTH_FFT - 1, lY, 1, layer);

					for (lX = x,lSubCnt=-2; lX < (x + GRID_WIDTH_FFT + 1); lX ++, lSubCnt++)
					{	
						if( (lSubCnt%lSubModulo == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH_FFT - 5)) && ((lX - x) != (GRID_WIDTH_FFT / 2)) && (lSubCnt < lMainModulo-2))
						{PIXELP(lX, lY, 1, layer);}

						if((lX - (x+lXoffs))%lMainModulo == 0) lSubCnt = 0;
					}
				}
				else
					for (lX = x; lX < (x + GRID_WIDTH_FFT); lX ++)			//solid line
					{ PIXELP(lX, lY, 1, layer); } 
			}		
		}
	}

	//------------------------------------------------------------------------------------------------------
	//			horizontal degree division for phase values
	//------------------------------------------------------------------------------------------------------
	else if(FFT_Mode == FFT_PHAS)
	{

	


	}



	PIXELP(x - 1, y - 1, 1, layer); 					// Left top corner
	PIXELP(x + GRID_WIDTH_FFT + 1, y - 1, 1, layer); 			// Right top corner
	PIXELP(x - 1, y + GRID_HEIGHT_FFT + 1, 1, layer); 			// Left bottom corner
	PIXELP(x + GRID_WIDTH_FFT + 1, y + GRID_HEIGHT_FFT + 1, 1, layer); 	// Right bottom corner


	
}
//##########################################################################################################################################################
// check which status areas have to be updated and call drawing routine
void Display::StatusUpdate(void)
{

	// Update Statusbar
	if (VoltageChangedCh1) DRAWSTATUS(1, 0);							// Draw Voltage Channel 1
	if (VoltageChangedCh2) DRAWSTATUS(2, 0);							// Draw Voltage Channel 2
	if (NumberOfChannels > 2)
	{
		if (VoltageChangedCh3) DRAWSTATUS(3, 0);						// Draw Voltage Channel 3
		if (VoltageChangedCh4) DRAWSTATUS(4, 0);						// Draw Voltage Channel 4		
	}
	
	if (TimebaseChanged) DRAWSTATUS(0, 0);								// Draw Timebase
	// BF ->????if (TimeOffsetChanged) DRAWSTATUS(5, 0);							// Draw Timebase Offset
	if (TriggerLevelChanged) DRAWSTATUS(6, 0);							// Draw Trigger Level
	if (TriggerModeChanged) DRAWSTATUS(7, 0);							// Draw Auto	
	if (TriggerWayChanged) DRAWSTATUS(8, 0);							// Draw Trigger way	

	MenuTimeCounter = 0;	
}
//##########################################################################################################################################################
// draw requested status area
void Display::DRAWSTATUS(int Which, int isChanging)
{
	unsigned char xe = 0;
	unsigned char xf = 0;	
	unsigned short Buffer = 0;
	char BufferText[17];
	char BufferText2[17];

	switch(Which)
	{
		// Timebase
		case 0:
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON) // Delayed Mode
			{
				/*if (isChanging == 0)
				{
					DRAWROUNDBUTTON(305, 0, 100, 20, btnUnpushed, btnRemove);					// remove button for sample rate
					DRAWROUNDBUTTON(404, 0, 64, 20, btnUnpushed, btnDraw);						// draw button	for time / div		
					DRAWROUNDBUTTON(326, 0, 64, 20, btnUnpushed, btnDraw);						// draw second TB button
				}*/

				Rect(318, 0, 140, 18, 0, Text_Plane);									// remove old text from screen
		
				sprintf(BufferText, "");										// clear text buffer
				for (xe = 0; xe < 10; xe++)										// create time per Div delayed area
				{ BufferText[xe] = TimebaseData[MainTimebase - DelayedTimebase - 1][xe]; }				
				
				TEXTOUTxvbig(BufferText, 335 + TimebaseDataDef[MainTimebase - DelayedTimebase - 1], 2, 1, Text_Plane);	// write text to screen
					

				sprintf(BufferText, "");										// clear text buffer
				for (xe = 0; xe < 10; xe++)										// create time per Div main area
				{ BufferText[xe] = TimebaseData[MainTimebase][xe]; }
				
				TEXTOUTxvbig(BufferText, 413 + TimebaseDataDef[MainTimebase], 2, 1, Text_Plane);			// write text to screen
			}
			else 					// Main Mode
			{
				/*if (isChanging == 0)
				{
					DRAWROUNDBUTTON(326, 0, 64, 20, btnUnpushed, btnRemove);					// remove second TB button from delayed TB
					DRAWROUNDBUTTON(305, 0, 100, 20, btnUnpushed, btnDraw);						// draw button	for sample rate
					DRAWROUNDBUTTON(404, 0, 64, 20, btnUnpushed, btnDraw);						// draw button	for time / div		
				}*/
				
				Rect(318, 0, 145, 18, 0, Text_Plane);									// remove old text from screen 
		
				sprintf(BufferText, "");										// clear text buffer
				for (xe = 0; xe < 11; xe++)										// create Samples per second text 
				{ BufferText[xe] = SampleRateData[MainTimebase+VirtualTimebase][xe]; }	
				
				TEXTOUTxvbig(BufferText, 320 + SampleRateDataDef[MainTimebase+VirtualTimebase], 2, 1, Text_Plane);	// draw draw sample per second
				
				sprintf(BufferText, "");										// clear text buffer
				for (xe = 0; xe < 10; xe++)										// create time per Div text
				{ BufferText[xe] = TimebaseData[MainTimebase+VirtualTimebase][xe]; }	

				TEXTOUTxvbig(BufferText, 413 + TimebaseDataDef[MainTimebase+VirtualTimebase], 2, 1, Text_Plane);	// write time / div to screen
			}
			
            		TimebaseChanged = 0;
			
			break;
		}
	
		// Voltage CH 1	
		case 1:
		{
			if (isChanging == 0)
			{
				if (Channel_1_Active == 0)
				{
					Rect(6, 4, 6, 10, 0, Channel_Plane1);							// clear channel number
					Rect(3, 0, 74, 18, 0, Text_Plane);							// clear voltage text
			
					//DRAWROUNDBUTTON(15, 0, 64, 20, btnUnpushed, btnRemove);				// remove button
					if (!DrawMono) DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnRemove);			// remove button
					break;											// and leave...
				}
				else
				{
					//DRAWROUNDBUTTON(15, 0, 64, 20, btnUnpushed, btnDraw);					// draw buttons	
					if (!DrawMono) DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnDraw);
					TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);						// draw channel number
				}
			}
			
			// Calculate Text
			switch(MenuStatus[MENU_ACQUIRE][0])
			{
				case LOGA_OFF:{ CALCVOLTAGE(1, &BufferText[0]);	break; }
				case LOGA_TTL:{ sprintf(BufferText, "TTL"); break; }
				case LOGA_LVTTL:{ sprintf(BufferText, "LVTTL"); break; }
				case LOGA_CMOS:{ sprintf(BufferText, "CMOS"); break; }
				case LOGA_CM25:{ sprintf(BufferText, "C2.5"); break; }
				case LOGA_CM18:{ sprintf(BufferText, "C1.8"); break; }
				case LOGA_RS232:{ sprintf(BufferText, "RS232"); break; }
			}

			Rect(16, 0, 62, 18, 0, Text_Plane);									// clear text first

			TEXTOUTxvbig(BufferText, 24, 2, 1, Text_Plane);								// draw voltage text
			
			VoltageChangedCh1 = 0;
			
			break;
		}
		
		// Voltage CH 2	
		case 2:
		{
			if (isChanging == 0)
			{
				if (Channel_2_Active == 0)
				{
					Rect(82, 4, 6, 10, 0, Channel_Plane2);							// clear channel number
					Rect(79, 0, 74, 18, 0, Text_Plane);							// clear voltage text
					
					//DRAWROUNDBUTTON(91, 0, 64, 20, btnUnpushed, btnRemove);					// remove button
					if (!DrawMono) DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnRemove);					// remove button
					break;											// and leave...
				}
				else
				{
					//DRAWROUNDBUTTON(91, 0, 64, 20, btnUnpushed, btnDraw);					// draw buttons	
					if (!DrawMono) DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnDraw);
					TEXTOUTvbig("2", 82, 4, 1, Channel_Plane2);						// draw channel number
				}
			}

			// Calculate Text
			switch(MenuStatus[MENU_ACQUIRE][0])
			{
				case LOGA_OFF:{ CALCVOLTAGE(2, &BufferText[0]);	break; }
				case LOGA_TTL:{ sprintf(BufferText, "TTL"); break; }
				case LOGA_LVTTL:{ sprintf(BufferText, "LVTTL"); break; }
				case LOGA_CMOS:{ sprintf(BufferText, "CMOS"); break; }
				case LOGA_CM25:{ sprintf(BufferText, "C2.5"); break; }
				case LOGA_CM18:{ sprintf(BufferText, "C1.8"); break; }
				case LOGA_RS232:{ sprintf(BufferText, "RS232"); break; }
			}

			Rect(92, 0, 61, 18, 0, Text_Plane);									// Clear First
			
			TEXTOUTxvbig(BufferText, 100, 2, 1, Text_Plane);							// Draw Voltage Text

			VoltageChangedCh2 = 0;
			
			break;
		}

		// Voltage CH 3	
		case 3:
		{
			if (isChanging == 0)
			{
				if (Channel_3_Active == 0)
				{
					Rect(158, 4, 6, 10, 0, Channel_Plane3);							// clear channel number
					Rect(155, 0, 74, 18, 0, Text_Plane);							// clear voltage text
					
					//DRAWROUNDBUTTON(167, 0, 64, 20, btnUnpushed, btnRemove);				// remove button
					if (!DrawMono) DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnRemove);					// remove button
					break;											// and leave...
				}
				else
				{
					//DRAWROUNDBUTTON(167, 0, 64, 20, btnUnpushed, btnDraw);					// draw buttons	
					if (!DrawMono) DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnDraw);
					TEXTOUTvbig("3", 158, 4, 1, Channel_Plane3);						// draw channel number
				}
			}

			// Calculate Text
			switch(MenuStatus[MENU_ACQUIRE][0])
			{
				case LOGA_OFF:{ CALCVOLTAGE(3, &BufferText[0]);	break; }
				case LOGA_TTL:{ sprintf(BufferText, "TTL"); break; }
				case LOGA_LVTTL:{ sprintf(BufferText, "LVTTL"); break; }
				case LOGA_CMOS:{ sprintf(BufferText, "CMOS"); break; }
				case LOGA_CM25:{ sprintf(BufferText, "C2.5"); break; }
				case LOGA_CM18:{ sprintf(BufferText, "C1.8"); break; }
				case LOGA_RS232:{ sprintf(BufferText, "RS232"); break; }
			}

			Rect(174, 0, 55, 18, 0, Text_Plane);									// Clear First
		
			TEXTOUTxvbig(BufferText, 176, 2, 1, Text_Plane);							// Draw Voltage Text

			VoltageChangedCh3 = 0;
			
			break;
		}
		
		// Voltage CH 4
		case 4:
		{
			if (isChanging == 0)
			{
				if (Channel_4_Active == 0)
				{
					Rect(234, 4, 6, 10, 0, Channel_Plane4);							// clear channel number
					Rect(231, 0, 74, 18, 0, Text_Plane);							// clear voltage text
					
					//DRAWROUNDBUTTON(243, 0, 64, 20, btnUnpushed, btnRemove);				// remove button
					if (!DrawMono) DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnRemove);					// remove button
					break;											// and leave...
				}
				else
				{
					//DRAWROUNDBUTTON(243, 0, 64, 20, btnUnpushed, btnDraw);					// draw buttons	
					if (!DrawMono) DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnDraw);
					TEXTOUTvbig("4", 234, 4, 1, Channel_Plane4);						// draw channel number
				}
			}

			// Calculate Text
			switch(MenuStatus[MENU_ACQUIRE][0])
			{
				case LOGA_OFF:{ CALCVOLTAGE(4, &BufferText[0]);	break; }
				case LOGA_TTL:{ sprintf(BufferText, "TTL"); break; }
				case LOGA_LVTTL:{ sprintf(BufferText, "LVTTL"); break; }
				case LOGA_CMOS:{ sprintf(BufferText, "CMOS"); break; }
				case LOGA_CM25:{ sprintf(BufferText, "C2.5"); break; }
				case LOGA_CM18:{ sprintf(BufferText, "C1.8"); break; }
				case LOGA_RS232:{ sprintf(BufferText, "RS232"); break; }
			}

			Rect(244, 0, 65, 18, 0, Text_Plane);									// Clear First

			TEXTOUTxvbig(BufferText, 252, 2, 1, Text_Plane);							// Draw Voltage Text

			VoltageChangedCh4 = 0;
			
			break;
		}	
/*BF not used		
		// Timebase Offset  // Muß noch upgedated werden	//BF -> ?????
		case 5:
		{
            		Display::DRAW_ALL_CURSOR();			
            			
			TimeOffsetChanged = 0;
    			
			break;
		}		
*/	
		// Trigger Level
		case 6:
		{	//********* USTB **********	
			if (USTB_Mode != USTB_OFF)
			{

				if (isChanging == 0)
				{
					//DRAWROUNDBUTTON(465, 0, 175, 20, btnUnpushed, btnDraw);				// draw USTB-mode button	

					if (Run)
					{
						if (!DrawMono)BITBITMAP(bitbmStopTrigger, 484, 0, 1, UI_Plane3);           	// repair status bar layer
						BITBITMAP(bitbmStopTrigger, 484, 0, 0, Channel_Plane4);				// remove stop sign

					}
					else
					{	
						BITBITMAP(bitbmStopTrigger, 484, 0, 0, UI_Plane3);				// delete plane under stop sign
						BITBITMAP(bitbmStopTrigger, 484, 0, 1, Channel_Plane4);				// draw stop sign
						//BITBITMAP(bitbmStopTrigger, 484, 0, 0, UI_Plane4);				// delete button plane over the stop sign
						Rect(475, 0, 43, 18, 0, Text_Plane);						// remove text under the stop sign
						break;
					}
				}

				Rect(475, 0, 165, 18, 0, Text_Plane);								// remove text from screen

				if (USTB_Mode == USTB_ROLL && USTB_Dir == USTB_FORWARD)						// create USTB-mode text
				{ sprintf(BufferText, " Roll  Forward"); }
				else if (USTB_Mode == USTB_ROLL && USTB_Dir == USTB_REVERSE)
				{ sprintf(BufferText, " Roll  Reverse"); }	
				else if (USTB_Mode == USTB_SHIFT && USTB_Dir == USTB_FORWARD)
				{ sprintf(BufferText, "Shift  Forward"); }
				else if (USTB_Mode == USTB_SHIFT && USTB_Dir == USTB_REVERSE)
				{ sprintf(BufferText, "Shift  Reverse"); }

				TEXTOUTxvbig(BufferText, 483, 2, 1, Text_Plane);						// draw text		

				if (USTB_Mode == USTB_ROLL)									// create display mode text
				{ 
					if (USTB_Disp == USTB_PERM)
					sprintf(BufferText, "Perm"); 
					else
					sprintf(BufferText, "Step"); 
	
					TEXTOUTxvbig(BufferText, 594, 2, 1, Text_Plane);					// draw text	
				}

				return;
			}

			//********* normal TB **********
			/*if (isChanging == 0)
			{
				DRAWROUNDBUTTON(465, 0, 175, 20, btnUnpushed, btnDraw);						// draw trigger values button
			}*/		

			Rect(568, 0, 79, 18, 0, Text_Plane);									// remove text from screen

			if (MenuStatus[MENU_TRIGGEREDGE][1] == 141 && MenuPopupStatus[8][2] == 3) return;			// Ext Trig Line
			if (MenuStatus[MENU_TRIGGEREDGE][1] == 142) return;   							// Ext Trig TV Ch1

			CALCTRIGGER();												// Calculate Text
			
			if ((MenuStatus[MENU_TRIGGEREDGE][1] == 141) && (TriggerWay == TRIG_EDGE))     // JK 6.9.11
			//if (MenuStatus[MENU_TRIGGEREDGE][1] == 141)
			 TEXTOUTxvbig(Trigger_ExtLevel_Str.Read_Text(), 572, 2, 1, Text_Plane); 				// draw ext. level
			else
			 TEXTOUTxvbig(Trigger_Level_Str.Read_Text(), 572, 2, 1, Text_Plane);					// draw trigger level
		
			TriggerLevelChanged = 0;
			
			break;
		}	
		
		// Trigger Mode (Auto, Combi, Normal etc.) and Run/Stop
		case 7:
		{
			if (USTB_Mode != USTB_OFF) return;

			if (Run)	// **** Run ****
			{	
				if (!DrawMono)BITBITMAP(bitbmStopTrigger, 484, 0, 1, UI_Plane3);           			// repair status bar layer
				BITBITMAP(bitbmStopTrigger, 484, 0, 0, Channel_Plane4);					// remove stop sign
	
				Rect(473, 0, 53, 18, 0, Text_Plane);								// remove text

				if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_AUTO)						// create text
				{ sprintf(BufferText, "Auto"); }
				else if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_NORM)
				{ sprintf(BufferText, "Norm"); }
				else
				{ sprintf(BufferText, "Comb"); }
			
				TEXTOUTxvbig(BufferText, 480, 2, 1, Text_Plane);						// draw text		
			}
			else		// **** Stop ****
			{
				Rect(473, 0, 53, 18, 0, Text_Plane);								// remove text
				//BITBITMAP(bitbmStopTrigger, 484, 0, 0, UI_Plane4);						// delete button plane over the stop sign
				if (!DrawMono) BITBITMAP(bitbmStopTrigger, 484, 0, 0, UI_Plane3);						// delete plane under stop sign
				BITBITMAP(bitbmStopTrigger, 484, 0, 1, Channel_Plane4);						// draw stop sign
			}
			
			TriggerModeChanged = 0;
			
			break;
		}
		
		// Trigger Way		BF #019
		case 8:
		{
			if (USTB_Mode != USTB_OFF) return;

			Rect(524, 0, 43, 18, 0, Text_Plane);					// remove text

			switch(TriggerWay)
			{
				case 1:	
				{
					if (MenuStatus[MENU_TRIGGEREDGE][1] == 137)		//channel 1
					{
						xe = '1';
						xf = ' ';
						//Selected_Trigger_Source = 1;
					}					
					else if (MenuStatus[MENU_TRIGGEREDGE][1] == 138)	//channel 2
					{
						xe = '2';
						xf = ' ';
						//Selected_Trigger_Source = 2;
					}
					else if (MenuStatus[MENU_TRIGGEREDGE][1] == 139)	//channel 3
					{
						xe = '3';
						xf = ' ';
						//Selected_Trigger_Source = 3;
					}
                    			else if (MenuStatus[MENU_TRIGGEREDGE][1] == 140)	//channel 4
					{
						xe = '4';
						xf = ' ';
						//Selected_Trigger_Source = 4;
					}
	                    		else if (MenuStatus[MENU_TRIGGEREDGE][1] == 141)	//external
					{
						//BF External HF Reject
						if (MenuPopupStatus[8][1] == 3)
						{
							xe = 'X';
							xf = 'H';
							//Selected_Trigger_Source = 5;
							MenuStatus[MENU_TRIGGEREDGE][2] = 129;
						}					
						//BF extern Line
						else if (MenuPopupStatus[8][2] == 3)
						{
							xe = 'L';
							xf = ' ';
							//Selected_Trigger_Source = 6;
							MenuStatus[MENU_TRIGGEREDGE][2] = 130;
						}
						//BF External LF Reject as default
						else //if (MenuPopupStatus[8][0] == 3)
						{
							xe = 'X';
							xf = 'L';
							//Selected_Trigger_Source = 5;
							MenuStatus[MENU_TRIGGEREDGE][2] = 128;
							MenuPopupStatus[8][0] = 3;
						}
					}
	                    		else if (MenuStatus[MENU_TRIGGEREDGE][1] == 142)	//TV
					{
						xe = 'T';
						xf = 'V';
						//Selected_Trigger_Source = 6;
						
						if (MenuPopupStatus[11][0] == 3) MenuStatus[MENU_TRIGGEREDGE][3] = 131;
						else { MenuStatus[MENU_TRIGGEREDGE][3] = 132; MenuPopupStatus[11][1] = 3; }	// comp. sync as default
					}


					// if channel who triggers is inverted take other edge
					if (MenuStatus[(MenuStatus[MENU_TRIGGEREDGE][1] - 136)][2] == 241)
					{					
						switch(MenuStatus[14][0])
						{
							case 2:	sprintf(BufferText, "~ %c%c", xe, xf); break;
							case 3:	sprintf(BufferText, "} %c%c", xe, xf); break;			
						}	
					}
					else
					{					
						switch(MenuStatus[14][0])
						{
							case 2:	sprintf(BufferText, "} %c%c", xe, xf); break;
							case 3:	sprintf(BufferText, "~ %c%c", xe, xf); break;			
						}	
					}
                    
					break;	
                    		
				}
							
				case 2:	//BF pulse width
				{				
					switch(MenuStatus[15][0])
					{
						case 137 : xe = '1'; Selected_Trigger_Source = 1; break;
						case 138 : xe = '2'; Selected_Trigger_Source = 2; break;
						case 139 : xe = '3'; Selected_Trigger_Source = 3; break;
						case 140 : xe = '4'; Selected_Trigger_Source = 4; break;
						case 141 : xe = 'X'; Selected_Trigger_Source = 5; break;
					}
					//sprintf(BufferText, "%c %c", 137, xe);
					sprintf(BufferText, "%c %c", 138, xe);
					
					break;
				}

 			}

               		TEXTOUTxvbig(BufferText, 529, 2, 1, Text_Plane);							// Draw Triggerway Text
	
			TriggerWayChanged = 0;
			
			break;
		}				
	}
}		
//##########################################################################################################################################################
/* BF -> not needed any more
void Display::RemoveStatusBtn(void)
{
	switch(StatusBtnRemove)
	{
		case 1:
		{
			DRAWROUNDBUTTON(15, 0, 64, 20, btnUnpushed, btnRemove);							// Remove Button
			break;
		}
		case 2:
		{
			DRAWROUNDBUTTON(91, 0, 64, 20, btnUnpushed, btnRemove);							// Remove Button
			break;
		}
		case 3:
		{
			DRAWROUNDBUTTON(167, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}
		case 4:
		{
			DRAWROUNDBUTTON(243, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}	

		case 6:
		{
			DRAWROUNDBUTTON(558, 0, 82, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}			
		case 10: // Timebase
		{
			DRAWROUNDBUTTON(404, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}
		case 11: // Timebase Delayed
		{
			DRAWROUNDBUTTON(326, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}							
		
	}

	StatusBtnRemove = 0;	
}
*/
//##########################################################################################################################################################
// BF drawing menu buttons on the screen
void Display::UpdateMenu(void)
{
    	int cnt;
	char BufferText[20];
	//char MenuAktMem;

	char Btns_to_remove[6] = {0, 0, 0, 0, 0, 0};           			//remove the button + text
	char Btns_to_remove_text[6] = {0, 0, 0, 0, 0, 0};      			//remove the text
	char Btns_to_draw[6] = {0, 0, 0, 0, 0, 0};             			//draw button
	char Btns_to_redraw[6] = {0, 0, 0, 0, 0, 0};           			//draw text

	if (Menu_First_Draw)							// restore buttons after displaying start screen
	{
		for (cnt = 0; cnt < 6; cnt++)
		{
			if (MenuItemDef[New_Menu][cnt] != 0)
			{ Btns_to_draw[cnt] = 1; Btns_to_redraw[cnt] = 1; MenuItemPushed[cnt] = 0; MenuItemChanged[0] = 0; }
		}
		Menu_First_Draw = 0;
	}
	else if (New_Menu != Active_Menu)					// check if menu changed
	{
		//BF del if (((New_Menu == 17) && (USB_Connected == false))) MenuAktive = 0; // Grayed menus

		for (cnt = 0; cnt < 6; cnt++)
		{
			MenuItemChanged[0] = 0;

			if (MenuItemDef[Active_Menu][cnt] != 0)			// button active in the old menu?
			{
				if (MenuItemDef[New_Menu][cnt] == 0)		// button inactive in the new menu?
				{	Btns_to_remove[cnt] = 1; }
				else						// button is active in this menu
				{
					Btns_to_draw[cnt]        = 1;
					Btns_to_remove_text[cnt] = 1;
					Btns_to_redraw[cnt]      = 1;
				}
			}
			else							// button is inactive in the old menu
			{
				if (MenuItemDef[New_Menu][cnt] != 0)		// button active in the new menu?
				{ Btns_to_draw[cnt] = 1; Btns_to_redraw[cnt] = 1; }
			}
		}		
	}
	else									//BF New Menu == Active Menu -> menu did not change
	{

		if (MenuAktive_old != MenuAktive)	 					// button status changed in this menu?
		{
			for (cnt = 0; cnt < 6; cnt++)
			{
				if (MenuItemDef[Active_Menu][cnt] != 0)	 			// button active in this menu?
				{
					//Btns_to_remove[cnt]      = 1;	// only for push function -> can be solved in button routine
					Btns_to_redraw[cnt]      = 1;
					Btns_to_remove_text[cnt] = 1;
					//Btns_to_draw[cnt]        = 1;
					MenuItemChanged[cnt]     = 0;	// reset change flag
				}
			}
		}
		else
		{
			for (cnt = 0; cnt < 6; cnt++)
			{
				if (MenuItemDef[Active_Menu][cnt] != 0 && MenuItemChanged[cnt] && MenuStatus[Active_Menu][cnt] != INACTIVE)	 // button active in this menu and changed?
				{
					Btns_to_remove[cnt]      = 1;	// only for push function -> can be solved in button routine
					Btns_to_redraw[cnt]      = 1;
					Btns_to_remove_text[cnt] = 1;
					Btns_to_draw[cnt]        = 1;
					MenuItemChanged[cnt]     = 0;	// reset change flag
				}
			}
		}
	}

	// draw menu
	for (cnt = 0; cnt < 6; cnt++)
    	{
          	if (Btns_to_remove_text[cnt] == 1) ClearMenuItemTextAsm(cnt, 35040, 32);
        	if (Btns_to_remove[cnt] == 1)      ClearMenuItemAsm(cnt, 34560, 44);
        	if (Btns_to_draw[cnt] == 1)        DrawMenuItemButton(cnt, MenuItemPushed[cnt]);
		if (Btns_to_redraw[cnt] == 1)      DrawMenuItem(New_Menu, cnt, MenuAktive, 1);
 	} 
	
	if (Cursor_Enabled) DrawCursorDeltaValues(1);		// draw the three additional delta cursor buttons
	//if (QM_Enabled) CALCQMDATA();	-> drawed in DrawSignals()
	
	MenuAktive_old      = MenuAktive;
	Active_Menu         = New_Menu;
	Menu_Changed = 0;
	UpdateMenuTextPlane = true;
	//VSync_Needed        = 1;
}
//##########################################################################################################################################################
/* BF not used
void Display::ClearMenuAsm(long start, long count)
{
    asm(" 	
	         PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	         MOVI	%r3,%lo(0x0095FA00)
	         PFX	%xhi(0x0095FA00)
	         MOVHI	%r3,%xlo(0x0095FA00)	


             PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
             MOVI	%r4,%lo(0x008D3BF4)
             PFX	%xhi(0x008D3BF4)
             MOVHI	%r4,%xlo(0x008D3BF4)

             PFX	%hi(0x00972600)                   ; Set UI3 Address
             MOVI	%r5,%lo(0x00972600)
             PFX	%xhi(0x00972600)
             MOVHI	%r5,%xlo(0x00972600)	
	
             PFX	%hi(0x0097BC00)                   ; Set UI4 Address
             MOVI	%r6,%lo(0x0097BC00)
             PFX	%xhi(0x0097BC00)
             MOVHI	%r6,%xlo(0x0097BC00)                     	

             PFX	%hi(0x00985200)                   ; Set UI5 Address
             MOVI	%r7,%lo(0x00985200)
             PFX	%xhi(0x00985200)
             MOVHI	%r7,%xlo(0x00985200)	

             ADD    %r3, %i0                          ; Add Address Counter
             ADD    %r4, %i0
             ADD    %r5, %i0
             ADD    %r6, %i0
             ADD    %r7, %i0

             MOV    %r1, %i1	

             PFX	%hi(0)                            ; Set Clear register
             MOVI	%r2,%lo(0)
             PFX	%xhi(0)
             MOVHI	%r2,%xlo(0)	

             PFX	%hi(0xFFFFFFFF)                            ; Set Clear register
             MOVI	%r9,%lo(0xFFFFFFFF)
             PFX	%xhi(0xFFFFFFFF)
             MOVHI	%r9,%xlo(0xFFFFFFFF)	
	
             loopCM:
             ST     [%r3], %r2                        ; Clear Buffer
             ST     [%r4], %r2                        ; Clear Buffer
             ST     [%r5], %r9                        ; Clear Buffer
             ST     [%r6], %r2                        ; Clear Buffer
             ST     [%r7], %r2                        ; Clear Buffer
                                          	
             ADDI   %r3, 4                            ; Add Address Counter
             ADDI   %r4, 4
             ADDI   %r5, 4
             ADDI   %r6, 4
             ADDI   %r7, 4

             SUBI   %r1, 1                            ; Decrement Line Counter
             SKPS   cc_z
             BR     loopCM
             NOP 	
        ");

   // UpdateMenuTextPlane = true;
}
*/
//##########################################################################################################################################################
//BF optimized removing, UI_plane3 must not be removed!
void Display::ClearMenuItemAsm(long which, long start, long count)
{
    switch(which)
    {
        case 0 :
        {
		Rect(12, 438, 20, 20, 0, Channel_Plane4);	// delete arrow cycle
		if (!DrawMono) Rect(12, 438, 20, 20, 1, UI_Plane3);

            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
/*	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
*/	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
;                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0x0001FFFF)                   ; Set MASK
                     MOVI	%r10,%lo(0x0001FFFF)
                     PFX	%xhi(0x0001FFFF)
                     MOVHI	%r10,%xlo(0x0001FFFF)

                     PFX	%hi(0xFFFE0000)                   ; Set MASK
                     MOVI	%r11,%lo(0xFFFE0000)
                     PFX	%xhi(0xFFFE0000)
                     MOVHI	%r11,%xlo(0xFFFE0000)   	


                     loopCMI0:

                     ;// UI 1
                     MOV    %L0, %r3

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
/*	
                     ;// UI 3
                     MOV    %L0, %r5

                     ST     [%L0], %r9                        ; Clear Buffer
                     STP    [%L0, 1], %r9                     ; Clear Buffer
                     STP    [%L0, 2], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
*/	
                     ;// UI 4
                     MOV    %L0, %r6

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back


                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
;                     PFX	%hi(80)                                          	
;                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI0
                     NOP 	
                ");
            break;
        }

        case 1 :
        {
		Rect(117, 438, 21, 20, 0, Channel_Plane4);	// delete arrow cycle
		if (!DrawMono) Rect(117, 438, 21, 20, 1, UI_Plane3);
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
/*
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
*/	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
;                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFF0000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFF0000)
                     PFX	%xhi(0xFFFF0000)
                     MOVHI	%r10,%xlo(0xFFFF0000)

                     PFX	%hi(0x0000FFFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x0000FFFF)
                     PFX	%xhi(0x0000FFFF)
                     MOVHI	%r11,%xlo(0x0000FFFF)             	

                     PFX	%hi(0x000003FF)                   ; Set MASK
                     MOVI	%r12,%lo(0x000003FF)
                     PFX	%xhi(0x000003FF)
                     MOVHI	%r12,%xlo(0x000003FF)

                     PFX	%hi(0xFFFFFC00)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFFFC00)
                     PFX	%xhi(0xFFFFFC00)
                     MOVHI	%r13,%xlo(0xFFFFFC00)             	
	
                     loopCMI1:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back

                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
/*	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r9                     ; Clear Buffer
                     STP    [%L0, 5], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
*/
                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
;                     PFX	%hi(80)                                          	
;                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI1
                     NOP 	
                 ");
            break;
        }

        case 2 :
        {
		Rect(222, 438, 20, 20, 0, Channel_Plane4);	// delete arrow cycle
		if (!DrawMono) Rect(222, 438, 20, 20, 1, UI_Plane3);
		asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
/*	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
*/	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
;                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFFFF80)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFFF80)
                     PFX	%xhi(0xFFFFFF80)
                     MOVHI	%r10,%xlo(0xFFFFFF80)

                     PFX	%hi(0x0000007F)                   ; Set MASK
                     MOVI	%r11,%lo(0x0000007F)
                     PFX	%xhi(0x0000007F)
                     MOVHI	%r11,%xlo(0x0000007F)             	

                     loopCMI2:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer


                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer
/*	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     STP    [%L0, 7], %r9                     ; Clear Buffer
                     STP    [%L0, 8], %r9                     ; Clear Buffer
                     STP    [%L0, 9], %r9                     ; Clear Buffer
*/
                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
;                     PFX	%hi(80)                                          	
;                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI2
                     NOP 	
                 ");
            break;
        }

        case 3 :
        {
		Rect(327, 438, 20, 20, 0, Channel_Plane4);	// delete arrow cycle
		if (!DrawMono) Rect(327, 438, 20, 20, 1, UI_Plane3);
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
/*	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
*/	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
;                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0x00FFFFFF)                   ; Set MASK
                     MOVI	%r10,%lo(0x00FFFFFF)
                     PFX	%xhi(0x00FFFFFF)
                     MOVHI	%r10,%xlo(0x00FFFFFF)

                     PFX	%hi(0xFF000000)                   ; Set MASK
                     MOVI	%r11,%lo(0xFF000000)
                     PFX	%xhi(0xFF000000)
                     MOVHI	%r11,%xlo(0xFF000000)             	
	
                     loopCMI3:

                     ;// UI 1
                     MOV    %L0, %r3

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
/*	
                     ;// UI 3
                     MOV    %L0, %r5

                     STP    [%L0, 10], %r9                      ; Clear Buffer
                     STP    [%L0, 11], %r9                     ; Clear Buffer
                     STP    [%L0, 12], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
*/	
                     ;// UI 4
                     MOV    %L0, %r6

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
;                     PFX	%hi(80)                                          	
;                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI3
                     NOP 	
                ");
            break;
        }

        case 4 :
        {
		Rect(432, 438, 20, 20, 0, Channel_Plane4);	// delete arrow cycle
		if (!DrawMono) Rect(432, 438, 20, 20, 1, UI_Plane3);
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
/*	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
*/
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
;                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFE00000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFE00000)
                     PFX	%xhi(0xFFE00000)
                     MOVHI	%r10,%xlo(0xFFE00000)

                     PFX	%hi(0x001FFFFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x001FFFFF)
                     PFX	%xhi(0x001FFFFF)
                     MOVHI	%r11,%xlo(0x001FFFFF)             	

                     PFX	%hi(0x00007FFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x00007FFF)
                     PFX	%xhi(0x00007FFF)
                     MOVHI	%r12,%xlo(0x00007FFF)

                     PFX	%hi(0xFFFF8000)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFF8000)
                     PFX	%xhi(0xFFFF8000)
                     MOVHI	%r13,%xlo(0xFFFF8000)             	
	
                     loopCMI4:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
/*	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r9                    ; Clear Buffer
                     STP    [%L0, 15], %r9                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
*/
                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
;                     PFX	%hi(80)                                          	
;                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI4
                     NOP 	
                 ");

            break;
        }

        case 5 :
        {
		Rect(537, 438, 20, 20, 0, Channel_Plane4);	// delete arrow cycle
		if (!DrawMono) Rect(537, 438, 20, 20, 1, UI_Plane3);
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
/*	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
*/	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
;                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFFF000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFF000)
                     PFX	%xhi(0xFFFFF000)
                     MOVHI	%r10,%xlo(0xFFFFF000)

                     PFX	%hi(0x00000FFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x00000FFF)
                     PFX	%xhi(0x00000FFF)
                     MOVHI	%r11,%xlo(0x00000FFF)             	

                     loopCMI5:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer


                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer
/*	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     STP    [%L0, 17], %r9                    ; Clear Buffer
                     STP    [%L0, 18], %r9                    ; Clear Buffer
                     STP    [%L0, 19], %r9                    ; Clear Buffer
*/
                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
;                     PFX	%hi(80)                                          	
;                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
 
                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI5
                     NOP 	
                 ");
            break;
        }
    }
    //UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::ClearMenuItemTextAsm(long which, long start, long count)
{

//printf("clear menu text -> item %d\n\r", which);


    switch(which)
    {
        case 0 :
        {
            asm(" 	

	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFC00000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFC00000)
                     PFX	%xhi(0xFFC00000)
                     MOVHI	%r10,%xlo(0xFFC00000)

                     PFX	%hi(0x003FFFFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x003FFFFF)
                     PFX	%xhi(0x003FFFFF)
                     MOVHI	%r12,%xlo(0x003FFFFF)

                     loopCMIT0:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 0], %r0                     ; Store it back

                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 3], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 0], %r0                     ; Store it back

                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 3], %r0                     ; Store it back

                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 0], %r0                     ; Store it back

                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 3], %r0                     ; Store it back

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter UI 2
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter UI 5

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT0
                     NOP 	
                ");
            break;
        }

        case 1 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFE000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFE000)
                     PFX	%xhi(0xFFFFE000)
                     MOVHI	%r10,%xlo(0xFFFFE000)

                     PFX	%hi(0x00001FFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x00001FFF)
                     PFX	%xhi(0x00001FFF)
                     MOVHI	%r12,%xlo(0x00001FFF)

                     loopCMIT1:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 3], %r0                     ; Store it back

                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 6], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 6], %r0                     ; Store it back

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT1
                     NOP 	
                 ");
            break;
        }

        case 2 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFE0)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFFFE0)
                     PFX	%xhi(0xFFFFFFE0)
                     MOVHI	%r10,%xlo(0xFFFFFFE0)

                     PFX	%hi(0x0000000F)                   ; Set MASK
                     MOVI	%r12,%lo(0x0000000F)
                     PFX	%xhi(0x0000000F)
                     MOVHI	%r12,%xlo(0x0000000F)

                     loopCMIT2:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 9], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 9], %r0                     ; Store it back

                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 9], %r0                     ; Store it back


                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT2
                     NOP 	
                 ");
            break;
        }

        case 3 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r7, %i1
 
                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xF1000000)                   ; Set MASK
                     MOVI	%r10,%lo(0xF1000000)
                     PFX	%xhi(0xF1000000)
                     MOVHI	%r10,%xlo(0xF1000000)

                     PFX	%hi(0x07FFFFFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x07FFFFFF)
                     PFX	%xhi(0x07FFFFFF)
                     MOVHI	%r12,%xlo(0x07FFFFFF)

                     loopCMIT3:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 13], %r0                    ; Store it back

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT3
                     NOP 	
                ");
            break;
        }

        case 4 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFE00000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFE00000)
                     PFX	%xhi(0xFFE00000)
                     MOVHI	%r10,%xlo(0xFFE00000)

                     PFX	%hi(0x0003FFFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x0003FFFF)
                     PFX	%xhi(0x0003FFFF)
                     MOVHI	%r12,%xlo(0x0003FFFF)

                     loopCMIT4:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 13], %r0                    ; Store it back

                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 16], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 16], %r0                    ; Store it back

                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 16], %r0                    ; Store it back


                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT4
                     NOP 	
                 ");

            break;
        }

        case 5 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	

	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r7, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFC000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFC000)
                     PFX	%xhi(0xFFFFC000)
                     MOVHI	%r10,%xlo(0xFFFFC000)

                     PFX	%hi(0x000001FF)                   ; Set MASK
                     MOVI	%r12,%lo(0x000001FF)
                     PFX	%xhi(0x000001FF)
                     MOVHI	%r12,%xlo(0x000001FF)
                     loopCMIT5:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back

                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	             STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	             STP    [%L0, 19], %r0                    ; Store it back

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT5
                     NOP 	
                 ");
            break;
        }
    }
   // UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::DrawMenuItemButton(int ItemNr, unsigned char pushed)
{
	int ispacer = 0;
	
	//if ((Active_Menu == 15) && (ItemNr == 1)) return; // for pulse width
	
	// Get Menuitem Pos
	switch(ItemNr)
	{
		case 0:
		{
			ispacer = 8;
			break;
		}
		case 1:
		{
			ispacer = 113;
			break;
		}
		case 2:
		{
			ispacer = 218;
			break;
		}
		case 3:
		{
			ispacer = 323;
			break;
		}
		case 4:
		{
			ispacer = 428;
			break;
		}
		case 5:
		{
			ispacer = 533;
			break;
		}
	}									
			
	// Draw Button Frame
	DRAWROUNDBUTTON(ispacer - 3, 432, 106, 46, pushed, btnDraw);	
}
//##########################################################################################################################################################

void Display::DrawMenuItem(int MenuNr,int ItemNr, unsigned char active, unsigned char caption)
{
	int ispacer = 0;
	int xe, textcorr = 0;
	char BufferText[17];	
	char BufferText2[17];
	char delta_t[17] = {"@ t"};	
	
	//if ((MenuNr == 15) && (ItemNr == 1)) return; // For Pulse Width button 1 remove

//printf("draw menu %d  item %d\n\r",MenuNr, ItemNr);
	
	// get menu item (button) pos
	switch(ItemNr)
	{
		case 0:	{ ispacer = 8; break; }
		case 1:	{ ispacer = 113; break;	}
		case 2:	{ ispacer = 218; break; }
		case 3:	{ ispacer = 323; break; }
		case 4:	{ ispacer = 428; break; }
		case 5:	{ ispacer = 533; break; }
	}	

	//-----------------------------------------------------------------------------------
	//			first line on the button
	//-----------------------------------------------------------------------------------
	if (caption)
	{
		
		// Get the Items Caption Text	
		for (xe = 0; xe < 16; xe++)
		{
			if ((MenuNr == MENU_PULSEWIDTH) && (ItemNr == 3) && (MenuStatus[MENU_PULSEWIDTH][2] == 3)) BufferText[xe] = MenuItem[MenuNr][ItemNr + 1][xe]; 		//change items -> bigger
			else if ((MenuNr == MENU_PULSEWIDTH) && (ItemNr == 4) && (MenuStatus[MENU_PULSEWIDTH][2] == 3)) BufferText[xe] = MenuItem[MenuNr][ItemNr - 1][xe]; 	//change items -> smaller
			//else if ((MenuNr == MENU_PULSEWIDTH) && (ItemNr == 4) && (MenuStatus[MENU_PULSEWIDTH][2] == 3)) BufferText[xe] = delta_t[xe]; 			// delta t
			else BufferText[xe] = MenuItem[MenuNr][ItemNr][xe];
		}
		
		//special functions 244/245/246 grayed out 
		if ((MenuStatus[MenuNr][ItemNr] > 243) && (MenuStatus[MenuNr][ItemNr] < 247))
		{
			// Draw Items Caption Text
			TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5);					// Draw Menu Text
			TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane);				// Draw Menu Text	
		}
		else
		{	
			// Pulsewidth menu
			if ((MenuNr == MENU_PULSEWIDTH) && ((ItemNr == 3) || (ItemNr == 4) ))// || (ItemNr == 5)))
			{
				if (ItemNr == 3)	//lower values
				{
					if (MenuStatus[MENU_PULSEWIDTH][2] == 1)
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 		// Draw Menu Data Text
					}
					else if (MenuStatus[MENU_PULSEWIDTH][2] == 2)
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 1))
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text			
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 2))
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 		// Draw Menu Data Text
					}
				}
		
				if (ItemNr == 4)	//higher values
				{
					if (MenuStatus[MENU_PULSEWIDTH][2] == 2)
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 		// Draw Menu Data Text
					}
					else if (MenuStatus[MENU_PULSEWIDTH][2] == 1)
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 2)) // active
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text	
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 1))	//inactive
					{
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 		// Draw Menu Data Text
					}
				}
			}
			else	//all other menus
			{	
				if (active)
				{
					// Draw Items Caption Text	
					TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane);	// Draw Menu Text	
				}
				else
				{
					// Draw Items Caption Text
					TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5);		// Draw Menu Text		
					TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane);	// Draw Menu Text
				}
			}
		}
	}

	//-----------------------------------------------------------------------------------
	//			second line on the button and special signs
	//-----------------------------------------------------------------------------------
	switch(MenuNr)
	{
		// Acquire
		case 0:
		{
			// draw arrow cycle on the buttons 
			if (ItemNr < 3)// ItemNr <= 3)
			{	
			 	if (AcquirePopupSelect == ItemNr) DrawMenuArrowCycle(ispacer + 4, active); //DrawMenuBiggerArrowCycle(ispacer + 6, active);
				else DrawMenuArrowCycle(ispacer + 4, 0);
			}

			break;
		}

		// Channels Probe
		case 1:
		case 2:
		case 3:
		case 4:						
		{
			if (ItemNr == 3) DrawMenuArrowCycle(ispacer + 6, active);	
			break;
		}	
		
		// Display -> grid intensity
		case 5:
		{
			if (ItemNr == 2) DrawMenuArrowCycle(ispacer + 6, active);	
			break;
		}	
		
		// Save / Recall -> memory place
		case 8:
		{
			if (ItemNr == 0)	
			{
				DrawMenuArrowCycle(ispacer + 6, active);
				sprintf(BufferText, "%d", SavePointer);		
				TEXTOUTxvbig(BufferText, ispacer + 46, 455, 1, Buffer_UI2Plane);		// Draw memory Text
			}
            	
			break;
		}		

		// Trigger Mode
		case 12:
		{
			if (ItemNr == 3)	// holdoff
			{	
				if (caption){
				if (EdgeToggle == 0) DrawMenuArrowCycle(ispacer + 6, active);
				else DrawMenuArrowCycle(ispacer + 6, 0); }
				
                		if (HoldOff_Value > 0) TEXTOUTxvbig(HoldOff.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane); 	// draw holdoff value into button	
				else TEXTOUTxvbig(MenuData[5], ispacer + 36, 455, 1, Buffer_UI2Plane); 					// write "Off" into button	
				
				// grayed "off"
				//TEXTOUTxvbig(MenuData[5], ispacer + 36, 455, 0, Buffer_UI2Plane);
				//TEXTOUTxvbig(MenuData[5], ispacer + 36, 455, 1, UI_Plane5);
			}

			if (ItemNr == 4 && caption)	// probe predivider ratio
			{
				if (EdgeToggle == 1) DrawMenuArrowCycle(ispacer + 6, active);
				else DrawMenuArrowCycle(ispacer + 6, 0);
			}			
			break;
		}
		
		// Trigger Edge -> PreTrigger
		case 14:
		{
			if (ItemNr == 5)
			{
				//if (XY_Mode || FFT_Mode != FFT_OFF || USTB_Mode != USTB_OFF)				// Button not active
				if (XY_Mode || USTB_Mode != USTB_OFF)							// Button not active
				{ DrawMenuArrowCycle(ispacer + 6, 0); }							// -> gray arrow cycle
				else
				{ DrawMenuArrowCycle(ispacer + 6, active); }
				
				TEXTOUTxvbig(Trigger_Offset_Str.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text	
			}
			break;
		}
        			
		// Pulse Width
		case 15:
		{		
			if (ItemNr == 3 && caption)	// lower value
			{
				if (PulseToggle == 3) DrawMenuArrowCycle(ispacer + 6, 0);
				else if (MenuStatus[MENU_PULSEWIDTH][2] == 1) DrawMenuArrowCycle(ispacer + 6, 0);
				else if (MenuStatus[MENU_PULSEWIDTH][2] == 2) DrawMenuArrowCycle(ispacer + 6, active);
				else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 1)) DrawMenuArrowCycle(ispacer + 6, active);			
				else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 2)) DrawMenuArrowCycle(ispacer + 6, 0);
			}

			if (ItemNr == 4 && caption)	// higher value
			{
				if (PulseToggle == 3) DrawMenuArrowCycle(ispacer + 6, 0);
				else if (MenuStatus[MENU_PULSEWIDTH][2] == 2) DrawMenuArrowCycle(ispacer + 6, 0);
				else if (MenuStatus[MENU_PULSEWIDTH][2] == 1) DrawMenuArrowCycle(ispacer + 6, active);
				else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 2)) DrawMenuArrowCycle(ispacer + 6, active);			
				else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 1)) DrawMenuArrowCycle(ispacer + 6, 0);
			}            			

			if (ItemNr == 5)	// pretrigger
			{
				//if (XY_Mode || FFT_Mode != FFT_OFF || USTB_Mode != USTB_OFF)				// Button not active
				if (XY_Mode || USTB_Mode != USTB_OFF || PulseToggle != 3)				// Button not active
				{ DrawMenuArrowCycle(ispacer + 6, 0); }							// -> gray arrow cycle
				else
				{ DrawMenuArrowCycle(ispacer + 6, active); }
				
				TEXTOUTxvbig(Trigger_Offset_Str.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text	
			}

			if (MenuStatus[MENU_PULSEWIDTH][2] != 3)
			{
				if (ItemNr == 3)
				{
					if (MenuStatus[MENU_PULSEWIDTH][2] == 1)
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 		// Draw Menu Data Text
					}
					else if (MenuStatus[MENU_PULSEWIDTH][2] == 2)
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 1))
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text			
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 2))
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 		// Draw Menu Data Text
					}
               			 }

				if (ItemNr == 4)
				{
					if (MenuStatus[MENU_PULSEWIDTH][2] == 2)
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 		// Draw Menu Data Text
					}
					else if (MenuStatus[MENU_PULSEWIDTH][2] == 1)
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 2))
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text			
					}
					else if ((MenuStatus[MENU_PULSEWIDTH][2] == 3) && (PulseToggle == 1))
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 		// Draw Menu Data Text
					}
                		}

			}
			else
			{
				if (ItemNr == 3)
				{
					TEXTOUTxvbig(Pulse11.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
				}
				if (ItemNr == 4)
				{
					TEXTOUTxvbig(Pulse12.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
				}
			}
			break;
		}	
		//---------------------------------------------------------------------------
		// BF display cursour data -> added new data for FFT
		//---------------------------------------------------------------------------
		case 16:
		{
			switch(ItemNr)
			{
				case 1:
				{	if (caption){
					if (Cursor_Vertical_Active == 1) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0); }
					
					if (XY_Mode)
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else if(FFT_Mode != FFT_OFF)
					{
						if (active)	
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}
				
				case 2:
				{	if (caption){
					if (Cursor_Vertical_Active == 2) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0); }
					
					if (XY_Mode)
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);
						}					
					}
					else if(FFT_Mode != FFT_OFF)
					{
						if (active)	
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}

				case 3:
				{	if (caption){
					if (Cursor_Horizontal_Active == 1) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0); }
					
					if(FFT_Mode != FFT_OFF)
					{
						if (active)
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}
						
				case 4:
				{	if (caption){
					if (Cursor_Horizontal_Active == 2) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0); }
					
					if(FFT_Mode != FFT_OFF)
					{
						if (active)
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}
				
				case 5:
				{
					if (Cursor_Vertical_Active == 4)
					{
						DrawMenuArrowCycle(ispacer + 6, active);
						DrawMenuArrowCycle2(ispacer + 6, 0);
					}
					else if (Cursor_Horizontal_Active == 4)
					{
						DrawMenuArrowCycle(ispacer + 6, 0);
						DrawMenuArrowCycle2(ispacer + 6, active);
					}
					else
					{
						DrawMenuArrowCycle(ispacer + 6, 0);
						DrawMenuArrowCycle2(ispacer + 6, 0);
					}					
				}				
			}
			break;
		}

		// Quick Measure
		case 19:
		{
			if (ItemNr == 1 ) DrawMenuBiggerArrowCycle(ispacer + 6, active);	
			break;
		}
			
		// Quick Measurment Threshold
		case 22:
		{
			if (ItemNr == 2)
			{
				if (Quick_Measure_Threshold_btn_select == 1) DrawMenuArrowCycle(ispacer + 6, active);	
				else DrawMenuArrowCycle(ispacer + 6, 0);	
		
				TEXTOUTxvbig(QM_Threshold_lower.Read_Text(), ispacer + 36, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
			if (ItemNr == 3)
			{
				if (Quick_Measure_Threshold_btn_select == 2) DrawMenuArrowCycle(ispacer + 6, active);	
				else DrawMenuArrowCycle(ispacer + 6, 0);	
		
				TEXTOUTxvbig(QM_Threshold_middle.Read_Text(), ispacer + 36, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
			if (ItemNr == 4)
			{
				if (Quick_Measure_Threshold_btn_select == 3) DrawMenuArrowCycle(ispacer + 6, active);	
				else DrawMenuArrowCycle(ispacer + 6, 0);	
		
				TEXTOUTxvbig(QM_Threshold_upper.Read_Text(), ispacer + 36, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
			break;
		}

		// Delay compensation popup 1 - 4
		case 25:
		{	
			// draw arrow cycle on the first 4 buttons 
			if (ItemNr < 4)
			{	
			 	if (DelayPopupSelect == ItemNr) DrawMenuArrowCycle(ispacer + 4, active); //DrawMenuBiggerArrowCycle(ispacer + 6, active);
				else DrawMenuArrowCycle(ispacer + 4, 0);
			}

			break;
		}

		// Math scale and offset
		case 26:
		{
			switch(ItemNr)
			{
				case 0:
				{
					if (MathToggle == 0) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (active)
					{
						if (MenuStatus[MENU_MATH][2] == BTN_ON)	TEXTOUTxvbig(MenuData[math_mul_scale], ispacer + MenuDataDef[math_mul_scale], 455, 1, Buffer_UI2Plane);		
						else if (MenuStatus[MENU_MATH][3] == BTN_ON) TEXTOUTxvbig(MenuData[math_sub_scale], ispacer + MenuDataDef[math_sub_scale], 455, 1, Buffer_UI2Plane);
						else if (MenuStatus[MENU_MATH][4] == BTN_ON) TEXTOUTxvbig(MenuData[math_add_scale], ispacer + MenuDataDef[math_add_scale], 455, 1, Buffer_UI2Plane);
					}
					else
					{
						if (MenuStatus[MENU_MATH][2] == BTN_ON)	
						{
							TEXTOUTxvbig(MenuData[math_mul_scale], ispacer + MenuDataDef[math_mul_scale], 455, 0, Buffer_UI2Plane);
							TEXTOUTxvbig(MenuData[math_mul_scale], ispacer + MenuDataDef[math_mul_scale], 455, 1, UI_Plane5);	
						}
						else if (MenuStatus[MENU_MATH][3] == BTN_ON)	
						{
							TEXTOUTxvbig(MenuData[math_sub_scale], ispacer + MenuDataDef[math_sub_scale], 455, 0, Buffer_UI2Plane);
							TEXTOUTxvbig(MenuData[math_sub_scale], ispacer + MenuDataDef[math_sub_scale], 455, 1, UI_Plane5);	
						}
						else if (MenuStatus[MENU_MATH][4] == BTN_ON)	
						{
							TEXTOUTxvbig(MenuData[math_add_scale], ispacer + MenuDataDef[math_add_scale], 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(MenuData[math_add_scale], ispacer + MenuDataDef[math_add_scale], 455, 1, UI_Plane5);
						}
					}

					break;
				}			
			
				case 1:
				{
					if (MathToggle == 1) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (active)
					{
						if (MenuStatus[MENU_MATH][2] == BTN_ON)	TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);
						else if (MenuStatus[MENU_MATH][3] == BTN_ON) TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);
						else if (MenuStatus[MENU_MATH][4] == BTN_ON) TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);
					}
					else
					{
						if (MenuStatus[MENU_MATH][2] == BTN_ON)	
						{
							TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);
							TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);
						}
						else if (MenuStatus[MENU_MATH][3] == BTN_ON)	
						{
							TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);
						}
						else if (MenuStatus[MENU_MATH][4] == BTN_ON)	
						{
							TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);
						}
					}

					break;
				}
			/*	
				case 2:
				{
					if (1 == 0) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (active)
					{
						if (MenuStatus[MENU_MATH][2] == 241)	TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 20, 455, 1, Buffer_UI2Plane);
						else if (MenuStatus[MENU_MATH][3] == 241) TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 20, 455, 1, Buffer_UI2Plane);
						else if (MenuStatus[MENU_MATH][4] == 241) TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 20, 455, 1, Buffer_UI2Plane);
					}
					else
					{
						if (MenuStatus[MENU_MATH][2] == 241)	
						{
							TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 20, 455, 0, Buffer_UI2Plane);
							TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 20, 455, 1, UI_Plane5);	
						}
						else if (MenuStatus[MENU_MATH][3] == 241)	
						{
							TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 20, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 20, 455, 1, UI_Plane5);	
						}
						else if (MenuStatus[MENU_MATH][4] == 241)	
						{
							TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 20, 455, 0, Buffer_UI2Plane);
							TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 20, 455, 1, UI_Plane5);	
						}
					}
					break;
				}
            		*/
			}
           		break;
        	}




//	BF not needed in new FFT -> causes text failure in Window button!!!

		// FFT Settings		
		case 27:		
		{
/*
			if (ItemNr == 1)
			{
				if (FFTToggle == 0)
					DrawMenuArrowCycle(ispacer + 6, active);	
				else 
					DrawMenuArrowCycle(ispacer + 6, 0);	
				
				TEXTOUTxvbig(FFT_Scale_Str.Read_Text(), ispacer + 8, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
			if (ItemNr == 2)
			{
				if (FFTToggle == 1)
					DrawMenuArrowCycle(ispacer + 6, active);	
				else 
					DrawMenuArrowCycle(ispacer + 6, 0);
				
				 TEXTOUTxvbig(FFT_Offset_Str.Read_Text(), ispacer + 10, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text	
			}
*/


			break;
		}	//BF changed end


		// Display FFT -> grid intensity
		case 28:
		{
			if (ItemNr == 2) DrawMenuArrowCycle(ispacer + 6, active);	
			break;
		}	



	}

	//-----------------------------------------------------------------------------------------------
	//		button text
	//-----------------------------------------------------------------------------------------------
	
	// Text Correction for Pulse Width Item 2
	if ((MenuNr == 15) && (ItemNr == 2))
	{
		if (MenuStatus[MenuNr][ItemNr] == 2) textcorr = -9;
		else if (MenuStatus[MenuNr][ItemNr] == 3) textcorr = 8;
	}	

	if (MenuStatus[MenuNr][ItemNr] < 240 || MenuStatus[MenuNr][ItemNr] > 247) //BF new entries above 247
	{
		if (active)
		{
			TEXTOUTxvbig(MenuData[MenuStatus[MenuNr][ItemNr]], ispacer + MenuDataDef[MenuStatus[MenuNr][ItemNr]] + textcorr, 455, 1, Buffer_UI2Plane);		// Draw Menu Data Text
		}
		else
		{
			TEXTOUTxvbig(MenuData[MenuStatus[MenuNr][ItemNr]], ispacer + MenuDataDef[MenuStatus[MenuNr][ItemNr]] + textcorr, 455, 0, Buffer_UI2Plane);		// Draw Menu Data Text
			TEXTOUTxvbig(MenuData[MenuStatus[MenuNr][ItemNr]], ispacer + MenuDataDef[MenuStatus[MenuNr][ItemNr]] + textcorr, 455, 1, UI_Plane5);			// Draw Menu Data Text	
		}		
	}
	else if ((MenuStatus[MenuNr][ItemNr] == 240) || (MenuStatus[MenuNr][ItemNr] == 241)) DrawMenuCheckBox(ispacer + 46, 457, MenuStatus[MenuNr][ItemNr] - 240, active);  	// Draw a Checkbox
	else if ((MenuStatus[MenuNr][ItemNr] == 242) || (MenuStatus[MenuNr][ItemNr] == 243)) DrawMenuArrow(ispacer + 31, MenuStatus[MenuNr][ItemNr] - 242, active);		// Draw an Arrow
	else if ((MenuStatus[MenuNr][ItemNr] == 244) || (MenuStatus[MenuNr][ItemNr] == 245)) DrawMenuArrow(ispacer + 31, MenuStatus[MenuNr][ItemNr] - 244, 0);			// Draw an Arrow Grayed	
	else if (MenuStatus[MenuNr][ItemNr] == 247) DrawSubMenuArrow(ispacer + 31, active);											// Draw a SubArrow	


	if ((MenuNr == 0) && (ItemNr == 0))Signal::LOGA_LogicProcessor();	


}
//##########################################################################################################################################################
/* BF -> not used
void Display::ClearMenuItem(int ItemNr)				// Clear a Menuitem            Überarbeiten mit Assembler Funktion
{
	int xa, Ct;
	
	switch(ItemNr)
	{
		case 0:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{			
				*(UI_Plane1 + xa) = 0;
				*(UI_Plane1 + xa + 1) = 0;
				*(UI_Plane1 + xa + 2) = 0;
				*(UI_Plane1 + xa + 3) = *(UI_Plane1 + xa + 3) & 0x0007FFFF;			
				*(Buffer_UI2Plane + xa) = 0;
				*(Buffer_UI2Plane + xa + 1) = 0;
				*(Buffer_UI2Plane + xa + 2) = 0;
				*(Buffer_UI2Plane + xa + 3) = *(Buffer_UI2Plane + xa + 3) & 0x0007FFFF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa) = 0;
				*(UI_Plane3 + xa + 1) = 0;
				*(UI_Plane3 + xa + 2) = 0;
				*(UI_Plane3 + xa + 3) = *(UI_Plane3 + xa + 3) & 0x0007FFFF;
				// BF end
				*(UI_Plane4 + xa) = 0;
				*(UI_Plane4 + xa + 1) = 0;
				*(UI_Plane4 + xa + 2) = 0;
				*(UI_Plane4 + xa + 3) = *(UI_Plane4 + xa + 3) & 0x0007FFFF;
				*(UI_Plane5 + xa) = 0;
				*(UI_Plane5 + xa + 1) = 0;
				*(UI_Plane5 + xa + 2) = 0;
				*(UI_Plane5 + xa + 3) = *(UI_Plane5 + xa + 3) & 0x0007FFFF;
				xa += 20;
			}
			break;
		}
		case 1:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 3) = *(UI_Plane1 + xa + 3) & 0xFFFF0000;
				*(UI_Plane1 + xa + 4) = 0;
				*(UI_Plane1 + xa + 5) = 0;
				*(UI_Plane1 + xa + 6) = *(UI_Plane1 + xa + 6) & 0x000003FF;								
				*(Buffer_UI2Plane + xa + 3) = *(Buffer_UI2Plane + xa + 3) & 0xFFFF0000;
				*(Buffer_UI2Plane + xa + 4) = 0;
				*(Buffer_UI2Plane + xa + 5) = 0;
				*(Buffer_UI2Plane + xa + 6) = *(Buffer_UI2Plane + xa + 6) & 0x000003FF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 3) = *(UI_Plane3 + xa + 3) & 0xFFFF0000;
				*(UI_Plane3 + xa + 4) = 0;
				*(UI_Plane3 + xa + 5) = 0;
				*(UI_Plane3 + xa + 6) = *(UI_Plane3 + xa + 6) & 0x000003FF;
				// BF end
				*(UI_Plane4 + xa + 3) = *(UI_Plane4 + xa + 3) & 0xFFFF0000;
				*(UI_Plane4 + xa + 4) = 0;
				*(UI_Plane4 + xa + 5) = 0;
				*(UI_Plane4 + xa + 6) = *(UI_Plane4 + xa + 6) & 0x000003FF;
				*(UI_Plane5 + xa + 3) = *(UI_Plane5 + xa + 3) & 0xFFFF0000;
				*(UI_Plane5 + xa + 4) = 0;
				*(UI_Plane5 + xa + 5) = 0;
				*(UI_Plane5 + xa + 6) = *(UI_Plane5 + xa + 6) & 0x000003FF;
				xa += 20;
			}
			break;
		}
		case 2:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 6) = *(UI_Plane1 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane1 + xa + 7) = 0;
				*(UI_Plane1 + xa + 8) = 0;
				*(UI_Plane1 + xa + 9) = 0;
				*(Buffer_UI2Plane + xa + 6) = *(Buffer_UI2Plane + xa + 6) & 0xFFFFFF00;
				*(Buffer_UI2Plane + xa + 7) = 0;
				*(Buffer_UI2Plane + xa + 8) = 0;
				*(Buffer_UI2Plane + xa + 9) = 0;	
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 6) = *(UI_Plane3 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane3 + xa + 7) = 0;
				*(UI_Plane3 + xa + 8) = 0;
				*(UI_Plane3 + xa + 9) = 0;
				// BF end
				*(UI_Plane4 + xa + 6) = *(UI_Plane4 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane4 + xa + 7) = 0;
				*(UI_Plane4 + xa + 8) = 0;
				*(UI_Plane4 + xa + 9) = 0;
				*(UI_Plane5 + xa + 6) = *(UI_Plane5 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane5 + xa + 7) = 0;
				*(UI_Plane5 + xa + 8) = 0;
				*(UI_Plane5 + xa + 9) = 0;
				xa += 20;
			}
			break;
		}
		case 3:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 10) = 0;
				*(UI_Plane1 + xa + 11) = 0;
				*(UI_Plane1 + xa + 12) = 0;
				*(UI_Plane1 + xa + 13) = *(UI_Plane1 + xa + 13) & 0x00FFFFFF;
				*(Buffer_UI2Plane + xa + 10) = 0;
				*(Buffer_UI2Plane + xa + 11) = 0;
				*(Buffer_UI2Plane + xa + 12) = 0;
				*(Buffer_UI2Plane + xa + 13) = *(Buffer_UI2Plane + xa + 13) & 0x00FFFFFF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 10) = 0;
				*(UI_Plane3 + xa + 11) = 0;
				*(UI_Plane3 + xa + 12) = 0;
				*(UI_Plane3 + xa + 13) = *(UI_Plane3 + xa + 13) & 0x00FFFFFF;
				// BF end
				*(UI_Plane4 + xa + 10) = 0;
				*(UI_Plane4 + xa + 11) = 0;
				*(UI_Plane4 + xa + 12) = 0;
				*(UI_Plane4 + xa + 13) = *(UI_Plane4 + xa + 13) & 0x00FFFFFF;
				*(UI_Plane5 + xa + 10) = 0;
				*(UI_Plane5 + xa + 11) = 0;
				*(UI_Plane5 + xa + 12) = 0;
				*(UI_Plane5 + xa + 13) = *(UI_Plane5 + xa + 13) & 0x00FFFFFF;
				xa += 20;
			}
			break;
		}
		case 4:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 13) = *(UI_Plane1 + xa + 13) & 0xFF000000;
				*(UI_Plane1 + xa + 14) = 0;
				*(UI_Plane1 + xa + 15) = 0;
				*(UI_Plane1 + xa + 16) =  *(UI_Plane1 + xa + 16) & 0x00007FFF;
				*(Buffer_UI2Plane + xa + 13) = *(Buffer_UI2Plane + xa + 13) & 0xFF000000;
				*(Buffer_UI2Plane + xa + 14) = 0;
				*(Buffer_UI2Plane + xa + 15) = 0;
				*(Buffer_UI2Plane + xa + 16) =  *(Buffer_UI2Plane + xa + 16) & 0x00007FFF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 13) = *(UI_Plane3 + xa + 13) & 0xFF000000;
				*(UI_Plane3 + xa + 14) = 0;
				*(UI_Plane3 + xa + 15) = 0;
				*(UI_Plane3 + xa + 16) =  *(UI_Plane3 + xa + 16) & 0x00007FFF;
				// BF end
				*(UI_Plane4 + xa + 13) = *(UI_Plane4 + xa + 13) & 0xFF000000;
				*(UI_Plane4 + xa + 14) = 0;
				*(UI_Plane4 + xa + 15) = 0;
				*(UI_Plane4 + xa + 16) =  *(UI_Plane4 + xa + 16) & 0x00007FFF;
				*(UI_Plane5 + xa + 13) = *(UI_Plane5 + xa + 13) & 0xFF000000;
				*(UI_Plane5 + xa + 14) = 0;
				*(UI_Plane5 + xa + 15) = 0;
				*(UI_Plane5 + xa + 16) =  *(UI_Plane5 + xa + 16) & 0x00007FFF;
				xa += 20;
			}
			break;
		}
		case 5:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 16) = *(UI_Plane1 + xa + 16) & 0xFFFFC000;
				*(UI_Plane1 + xa + 17) = 0;
				*(UI_Plane1 + xa + 18) = 0;
				*(UI_Plane1 + xa + 19) = 0;
				*(Buffer_UI2Plane + xa + 16) = *(Buffer_UI2Plane + xa + 16) & 0xFFFFC000;
				*(Buffer_UI2Plane + xa + 17) = 0;
				*(Buffer_UI2Plane + xa + 18) = 0;
				*(Buffer_UI2Plane + xa + 19) = 0;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 16) = *(UI_Plane3 + xa + 16) & 0xFFFFC000;
				*(UI_Plane3 + xa + 17) = 0;
				*(UI_Plane3 + xa + 18) = 0;
				*(UI_Plane3 + xa + 19) = 0;
				// BF end
				*(UI_Plane4 + xa + 16) = *(UI_Plane4 + xa + 16) & 0xFFFFC000;
				*(UI_Plane4 + xa + 17) = 0;
				*(UI_Plane4 + xa + 18) = 0;
				*(UI_Plane4 + xa + 19) = 0;
				*(UI_Plane5 + xa + 16) = *(UI_Plane5 + xa + 16) & 0xFFFFC000;
				*(UI_Plane5 + xa + 17) = 0;
				*(UI_Plane5 + xa + 18) = 0;
				*(UI_Plane5 + xa + 19) = 0;
				xa += 20;
			}
			break;
		}
	}	
 //   UpdateMenuTextPlane = true;								
}
*/
//##########################################################################################################################################################

void Display::DRAWMENUPOPUP(int PopupNr)
{
	int x, xe, y;
	int pos = 0;

	int posx = 0;
	int sizex = 0;
	int posy = 0;
	int sizey = 0;
	int count = 0;	
	int button = 0;
	
	char BufferText[22];
	char BufferText2[22];	
		
	button = MenuPopupDef[PopupNr][0];
	count  = MenuPopupDef[PopupNr][1];

	// resize if there are deleted entries (for two channel DSOs)
	for (x=0,y=count;x < y;x++)	
	if (MenuPopupStatus[PopupNr][x] == 0) count--;

	posx = (button * 100) + 15;
	sizey = (count * 17) + 37;
	posy = 420 - sizey;

	if (PopupNr == 4) sizex = 150;
	else sizex = 120;

	MenuPopupX = posx - 2;
	MenuPopupY = posy;
	MenuPopupSizeX = sizex + 4;
	MenuPopupSizeY = sizey + 15;

	// Clear
	if (MenuPopupActive != PopupNr)		// first call
	{
		Rect(posx - 1, posy, sizex + 2, sizey, 0, UI_Plane1); //sizey = 5	
		Rect(posx - 1, posy, sizex + 2, sizey, 0, UI_Plane2);
		Rect(posx - 1, posy, sizex + 2, sizey, 0, UI_Plane5);
		//BF done in Draw Button  if (Channel_Math_Active) Rect(posx - 1, posy, sizex + 2, sizey, 0, Channel_Math_Plane);			// delete math layer under the popup

		DRAWROUNDBUTTON(posx - 3, posy, sizex + 6, sizey + 3, btnUnpushed, btnDraw);
		DRAWMENUBUTTONSELECT(button);		

		//Draw Popup Caption
		sprintf(BufferText, "");
		for (xe = 0; xe < 20; xe++)
		{
			BufferText[xe] = MenuPopupText[PopupNr][0][xe];
		}
		TEXTOUTxvbig(BufferText, posx + 5, posy + 5, 1, UI_Plane2);					// Draw Menu Text
		
		// Div Line
		Rect(posx + 2, posy + 20, sizex - 4, 1, 1, UI_Plane5);
		//Rect(posx + 2, posy + 21, sizex - 4, 1, 1, UI_Plane1);	//BF del because of draw failure in this plane on the right edge
		Rect(posx + 2, posy + 21, sizex - 4, 1, 1, UI_Plane5);	
	
		
		for (x=0,y=0;x < count;y++)
		{
			if (MenuPopupStatus[PopupNr][y] == 0)							// not available entry	
			{ continue; }										// don't draw anything

			sprintf(BufferText, "");
			for (xe = 0; xe < 20; xe++)
			{ BufferText[xe] = MenuPopupText[PopupNr][y + 1][xe]; }

			if (MenuPopupStatus[PopupNr][y] == 1)							// inactive
			{ TEXTOUTxvbig(BufferText, posx + 25, posy + 28 + (x * 17), 1, UI_Plane5); }		// draw grayed popup item text	
			
			else if (MenuPopupStatus[PopupNr][y] == 2)						// normal entry
			{ TEXTOUTxvbig(BufferText, posx + 25, posy + 28 + (x * 17), 1, UI_Plane2); }		// draw popup item text
			
			else if (MenuPopupStatus[PopupNr][y] == 3)						// active
			{
				sprintf(BufferText2, "%c  %s", Menu_Select, BufferText);
				TEXTOUTxvbig(BufferText2, posx + 5, posy + 28 + (x * 17), 1, UI_Plane2);	// draw popup item text		
			}
			x++;	
		}
	}
	else				// popup is active -> only step through
	{
		Rect(posx + 4, posy + 27, 15, sizey - 35, 0, UI_Plane2);
		
		//for (x = 0;x < count;x++)
		for (x=0,y=0;x < count;y++)
		{	
			if (MenuPopupStatus[PopupNr][y] == 0)							// not available entry	
			{ continue; }										// don't draw anything
	
			if (MenuPopupStatus[PopupNr][y] == 3)
			{
				sprintf(BufferText2, "%c", Menu_Select);
				TEXTOUTxvbig(BufferText2, posx + 5, posy + 28 + (x * 17), 1, UI_Plane2);	// draw select sign at active entry
			}
			x++;
		}
	}		
	
	MenuPopupChanged = 1;
	MenuPopupActive  = PopupNr;
	MenuItemChanged[button] = 1;										//redraw button
	
}
//##########################################################################################################################################################

void Display::DRAWMENUPOPDOWN(void)
{
	int x, y;
	int posy = 0;
	int sizey = 0;
	int count = 0;	
	int xa, xo, Ct;	

	// Clean Up the Popup
	xa = MenuPopupY * 20;
	xo = MenuPopupX / 32;

	for (Ct = 0; Ct < MenuPopupSizeY - 5; Ct++)
	{			
		*(UI_Plane1 + xo + xa)     = 0;
		*(UI_Plane1 + xo + xa + 1) = 0;
		*(UI_Plane1 + xo + xa + 2) = 0;
		*(UI_Plane1 + xo + xa + 3) = 0;
		*(UI_Plane1 + xo + xa + 4) = 0;
		*(UI_Plane1 + xo + xa + 5) = 0;

		*(Buffer_UI2Plane + xo + xa)     = 0;
		*(Buffer_UI2Plane + xo + xa + 1) = 0;
		*(Buffer_UI2Plane + xo + xa + 2) = 0;
		*(Buffer_UI2Plane + xo + xa + 3) = 0;
		*(Buffer_UI2Plane + xo + xa + 4) = 0;
		*(Buffer_UI2Plane + xo + xa + 5) = 0;

		*(UI_Plane2 + xo + xa)     = 0;
		*(UI_Plane2 + xo + xa + 1) = 0;
		*(UI_Plane2 + xo + xa + 2) = 0;
		*(UI_Plane2 + xo + xa + 3) = 0;
		*(UI_Plane2 + xo + xa + 4) = 0;
		*(UI_Plane2 + xo + xa + 5) = 0;
/* BF del to avoid overwriting of grid 
		*(UI_Plane3 + xo + xa)     = 0;
		*(UI_Plane3 + xo + xa + 1) = 0;
		*(UI_Plane3 + xo + xa + 2) = 0;
		*(UI_Plane3 + xo + xa + 3) = 0;
		*(UI_Plane3 + xo + xa + 4) = 0;
		*(UI_Plane3 + xo + xa + 5) = 0;
// BF end*/
		*(UI_Plane4 + xo + xa)     = 0;
		*(UI_Plane4 + xo + xa + 1) = 0;
		*(UI_Plane4 + xo + xa + 2) = 0;
		*(UI_Plane4 + xo + xa + 3) = 0;
		*(UI_Plane4 + xo + xa + 4) = 0;
		*(UI_Plane4 + xo + xa + 5) = 0;

		*(UI_Plane5 + xo + xa)     = 0;
		*(UI_Plane5 + xo + xa + 1) = 0;
		*(UI_Plane5 + xo + xa + 2) = 0;
		*(UI_Plane5 + xo + xa + 3) = 0;
		*(UI_Plane5 + xo + xa + 4) = 0;
		*(UI_Plane5 + xo + xa + 5) = 0;
		xa += 20;
		
		if (Channel_Math_Active)
		{
			*(Channel_Math_Plane + xo + xa)     = *(Buffer_PlaneM + xo + xa);
			*(Channel_Math_Plane + xo + xa + 1) = *(Buffer_PlaneM + xo + xa + 1);
			*(Channel_Math_Plane + xo + xa + 2) = *(Buffer_PlaneM + xo + xa + 2);
			*(Channel_Math_Plane + xo + xa + 3) = *(Buffer_PlaneM + xo + xa + 3);
			*(Channel_Math_Plane + xo + xa + 4) = *(Buffer_PlaneM + xo + xa + 4);
			*(Channel_Math_Plane + xo + xa + 5) = *(Buffer_PlaneM + xo + xa + 5);
		}


	}
	
/* BF del because no repair is needed when lines above are commented out
	// Repair Menu Down
//	xa = 407 * 20;
	xa = BOTT_PLANE_MIN;
	for (Ct = 0; Ct < 23; Ct++)
	{			
		*(UI_Plane3 + xo + xa)     = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 1) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 2) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 3) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 4) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 5) = 0xFFFFFFFF;
		xa += 20;
	}	
BF end */

	if (MenuPopupActive == 4)
    	{
/* BF del
		// Repaire Top Menu
		xa = 9 * 20;
		for (Ct = 0; Ct < 9; Ct++)
		{			
			*(UI_Plane3 + xo + xa)     = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 1) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 2) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 3) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 4) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 5) = 0xFFFFFFFF;
			xa += 20;
		}
*/
	/* TMW  if (MenuStatus[5][4] == 241)	//Units
		{
		Display::DRAWMEMORY(0, 1, 1);
		} TMW*/
	
		VoltageChangedCh1 = 1;
		VoltageChangedCh2 = 1;
	
		if (NumberOfChannels > 2)
		{
			VoltageChangedCh3 = 1;
			VoltageChangedCh4 = 1;
		}
	
		StatusUpdate();
    	}
	

	MenuPopupActive = -1;
	MenuPopupChanged = 0;

/*	BF del -> causes problems at menu change
	New_Menu = Active_Menu;
    	Menu_Changed = 1;
*/
	// Repaire Menu	
	if (Cursor_Enabled)
	{
		//BF not used CursorChanged = 3;
		Cursor_Data_First_Draw = true;
		DrawCursorDeltaValues(1);
	}
	if (QM_Enabled)
	{
		Quick_Measure_First_Draw = true;
		DrawQMData(1);
	}

}

//##########################################################################################################################################################

void Display::DRAWMENUBUTTONSELECT(int buttonnr)
{
	int x, y, c, posx = 0;
	posx = 40 + (buttonnr * 100);
	
	c = 21;	
	for (y = 0; y < 10; y++)
	{
		for (x = 0; x < c; x++)
		{
			if (x == 0) PIXELP(posx + y + x, 420 + y, 1, UI_Plane5);				//clBlack
			else if (x == (c - 1)) PIXELP(posx + y + x, 420 + y, 1, UI_Plane5);
			else PIXELP(posx + y + x, 420 + y, 1, UI_Plane4);		
			PIXELP(posx + y + x, 420 + y, 0, UI_Plane2);
		}
		c--;
		c--;
	}	
 }
//##########################################################################################################################################################
//BF  added workaround for wrong UI_Plane1 transfer	
void Display::DRAWROUNDBUTTON(int posx, int posy, int sizex, int sizey, unsigned char pushed, unsigned char remove)
{
	char set;
	unsigned long *iplane;	
	int x, y, c;
	
	//pushed = 0;	// BF test
	
	if (remove)
	{ set = 0; }
	else
	{	
		set = 1;		
		if (Channel_Math_Active)
		Rect(posx - 1, posy, sizex + 2, sizey, 0, Channel_Math_Plane);		// delete math layer under the popup
	}

	// **** Upper side ****
	if (posx<40) iplane = UI_Plane4;						// repair first button
	else iplane = UI_Plane1;

	// Left Edge
	c = 8;
	for (y = 1; y < 7; y++)
	{
		if (y < 6) c--;	
		for (x = c; x < 9; x++)
		{
			if ((y == 1) && (pushed == 0)) iplane = iplane;
			else if ((y == 1) && (pushed == 1)) iplane = UI_Plane5;
			else if ((x == c) && (pushed == 0)) iplane = iplane;
			else if ((x == c) && (pushed == 1)) iplane = UI_Plane5;
			else iplane = UI_Plane4;
			
			PIXELP(posx + x, posy + y, set, iplane);
		}
	}

	if (pushed) iplane = UI_Plane5;
	else iplane = UI_Plane1;	
	
	// Upper Middle
	//Rect(posx + 9, posy, sizex - 18, 1, set, iplane);		// TopLine

	if ((posx+sizex) > 607)	//BF workaround for wrong UI_Plane1 transfer	
	{
		DRAWLINEP(posx + 9, posy, posx + sizex - 9, posy, set, UI_Plane4);	// top line
		DRAWLINEP(posx + 9, posy, 607, posy, set, iplane);			// top line

	}	
	else
	DRAWLINEP(posx + 9, posy, posx + sizex - 9, posy, set, iplane);			// top line

	if (posx<40) DRAWLINEP(posx + 9, posy, posx + 31, posy, set, UI_Plane4);	// repair first button

	// Middle Block
	Rect(posx + 9, posy + 1, sizex - 18, 6, set, UI_Plane4);

	// Right Edge
	c = 1;
	for (y = 1; y < 7; y++)
	{
		if (y < 6) c++;	
		for (x = 0; x < c; x++)
		{	
			if ((y == 1) && (pushed == 0)) 
			{ if ((posx+sizex) > 607) iplane = UI_Plane4;	else iplane = UI_Plane1; }	//BF workaround for wrong UI_Plane1 transfer - repair button	
			else if ((y == 1) && (pushed == 1)) iplane = UI_Plane5;
			else if ((x == (c - 1)) && (pushed == 0))		
			{ if ((posx+sizex) > 607) iplane = UI_Plane4;	else iplane = UI_Plane1; }	//BF workaround for wrong UI_Plane1 transfer - repair button		
			else if ((x == (c - 1)) && (pushed == 1)) iplane = UI_Plane5;
			else iplane = UI_Plane4;
			
			PIXELP(posx + (sizex - 9) + x, posy + y, set, iplane);
		}
	}		

	// Solid Middle Block
	Rect(posx + 3, posy + 7, sizex - 6, sizey - 16, set, UI_Plane4);

	// Sidelines
	if (pushed)
	{
		//Rect(posx + 2, posy + 7, 1, sizey - 16, set, UI_Plane5);
		//Rect(posx + sizex - 3, posy + 7, 1, sizey - 16, set, UI_Plane1);
		DRAWLINEP(posx + 2, posy + 7, posx + 2, posy+sizey - 9, set, UI_Plane5);
		DRAWLINEP(posx + sizex - 3, posy + 7, posx + sizex - 3, posy+sizey - 9, set, UI_Plane1);
	}
	else
	{
		//Rect(posx + 2, posy + 7, 1, sizey - 16, set, UI_Plane1);
		//Rect(posx + sizex - 3, posy + 7, 1, sizey - 16, set, UI_Plane5);
		DRAWLINEP(posx + 2, posy + 7, posx + 2, posy+sizey - 9, set, UI_Plane1);
		DRAWLINEP(posx + sizex - 3, posy + 7, posx + sizex - 3, posy+sizey - 9, set, UI_Plane5);
	}

	// **** bottom side ****
	// Left Edge
	c = 3;
	for (y = 0; y < 6; y++)
	{
		if (y > 1) c++;	
		for (x = c; x < 9; x++)
		{		
			if ((y == 5) && (pushed == 0)) iplane = UI_Plane5;
			else if ((y == 5) && (pushed == 1)) iplane = UI_Plane1;
			else if ((x == c) && (pushed == 0)) iplane = UI_Plane5;
			else if ((x == c) && (pushed == 1)) iplane = UI_Plane1;
			else iplane = UI_Plane4;			
			
			PIXELP(posx + x, posy + (sizey - 9) + y, set, iplane);
		}
	}

	if (pushed) iplane = UI_Plane1;
	else iplane = UI_Plane5;
	
	// Lower Middle
	//Rect(posx + 9, posy + (sizey - 9) + 6, sizex - 18, 1, set, iplane);	// BottomLine
	DRAWLINEP(posx + 9, posy+sizey - 3, posx + sizex - 9, posy+sizey - 3, set, iplane);

	// Middle Block
	Rect(posx + 9, posy + (sizey - 9), sizex - 18, 6, set, UI_Plane4);

	// Right Edge
	c = 6;
	for (y = 0; y < 6; y++)
	{
		if (y > 1) c--;	
		for (x = 0; x < c; x++)
		{		
			if ((y == 5) && (pushed == 0)) iplane = UI_Plane5;
			else if ((y == 5) && (pushed == 1)) iplane = UI_Plane1;
			else if ((x == (c - 1)) && (pushed == 0)) iplane = UI_Plane5;
			else if ((x == (c - 1)) && (pushed == 1)) iplane = UI_Plane1;
			else iplane = UI_Plane4;						
			
			PIXELP(posx + (sizex - 9) + x, posy + (sizey - 9) + y, set, iplane);
		}
	}
}
//##########################################################################################################################################################

void Display::DRAWSQUAREBUTTON(int posx, int posy, int sizex, int sizey, unsigned char pushed, unsigned char remove)
{
	char set;
	unsigned long *iplane;			
		
	if (remove) set = 0;
	else set = 1;
	
	// Left Edge	
	if (pushed) iplane = UI_Plane5;
	else iplane = UI_Plane1;
	
	PIXELP(posx + 1, posy + 2, set, iplane);
	PIXELP(posx + 2, posy + 1, set, iplane);
	
	PIXELP(posx + 2, posy + 2, !set, UI_Plane3);	
	
	// Upper Middle
	Rect(posx + 3, posy, sizex - 6, 1, set, iplane);					// TopLine

	// Middle Block
	Rect(posx + 3, posy + 1, sizex - 6, 2, !set, UI_Plane3);				// Middle Block	
	
	// Right Edge		
	PIXELP(posx + (sizex - 3), posy + 1, set, iplane);
	PIXELP(posx + (sizex - 3) + 1, posy + 2, set, iplane);
	PIXELP(posx + (sizex - 3), posy + 2, !set, UI_Plane3);
	
	// Middle Block
	Rect(posx + 1, posy + 3, sizex - 2, sizey - 6, !set, UI_Plane3); //1
	
	// Sidelines
	if (pushed)
	{
		Rect(posx, posy + 3, 1, sizey - 6, set, UI_Plane5);
		Rect(posx + sizex - 1, posy + 3, 1, sizey - 6, set, UI_Plane1);
	}
	else
	{
		Rect(posx, posy + 3, 1, sizey - 6, set, UI_Plane1);
		Rect(posx + sizex - 1, posy + 3, 1, sizey - 6, set, UI_Plane5);
	}
		
	if (pushed) iplane = UI_Plane1;
	else iplane = UI_Plane5;
			
	// Down
	// Left Edge	
	PIXELP(posx + 1, posy + (sizey - 3), set, iplane);
	PIXELP(posx + 2, posy + (sizey - 3) + 1, set, iplane);
	PIXELP(posx + 2, posy + (sizey - 3), !set, UI_Plane3);

	// Lower Middle
	Rect(posx + 3, posy + (sizey - 1), sizex - 6, 1, set, iplane);	// Bottom Line

	Rect(posx + 3, posy + (sizey - 3), sizex - 6, 2, !set, UI_Plane3);		// Middle Block //1

	// Right Edge
	PIXELP(posx + (sizex - 3) + 1, posy + (sizey - 3), set, iplane);
	PIXELP(posx + (sizex - 3), posy + (sizey - 3) + 1, set, iplane);
	PIXELP(posx + (sizex - 3), posy + (sizey - 3), !set, UI_Plane3);
}
//##########################################################################################################################################################

void Display::DrawMenuCheckBox(int posx, int posy, char checked, char active)			// Draw a Checkbox in menu
{
	if (checked)
	{	
		Line(posx, posy, posx + 10, posy, UI_Plane5);
		Line(posx + 1, posy + 10, posx + 11, posy + 10, UI_Plane1);
		Line(posx, posy + 1, posx, posy + 10, UI_Plane5);				
		Line(posx + 10, posy, posx + 10, posy + 10, UI_Plane1);
		
		if (active) Rect(posx + 2, posy + 2, 7, 7, 1, Buffer_UI2Plane);			// Checkbox Filling Black
		else
		{
			Rect(posx + 2, posy + 2, 7, 7, 1, UI_Plane5);				// Checkbox Filling Gray
		}
	}
	else
	{
		Line(posx, posy, posx + 10, posy, UI_Plane1);	
		Line(posx + 1, posy + 10, posx + 11, posy + 10, UI_Plane5);
		Line(posx, posy + 1, posx, posy + 10, UI_Plane1);		
		Line(posx + 10, posy, posx + 10, posy + 10, UI_Plane5);					
		
		Rect(posx + 2, posy + 2, 7, 7, 0, Buffer_UI2Plane);				// Checkbox Filling
		Rect(posx + 2, posy + 2, 7, 7, 0, UI_Plane5);					// Checkbox Filling

	}	
    UpdateMenuTextPlane = true;		
}
//##########################################################################################################################################################

void Display::DrawMenuArrow(int posx, int updn, int active)					// Draw Sub-Menu Arrow
{	
	if (updn == 0)  // Down
	{
		BITBITMAP(bitbmBigArrowDown, posx, 455, active, Buffer_UI2Plane);
		BITBITMAP(bitbmBigArrowDown, posx, 455, !active, UI_Plane5);
	}
	else			// Up , it is always displayed without Text -> 10 Dots heigher
	{
		BITBITMAP(bitbmBigArrowUp, posx, 445, active, Buffer_UI2Plane);
		BITBITMAP(bitbmBigArrowUp, posx, 445, !active, UI_Plane5);
	}	
	UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::DrawMenuArrowCycle(int posx, int active)						// Draw the knob turn cycle
{
	if (active)
	{
		BITBITMAP(bitbmCycleArrow, posx, 438, 1, Channel_Plane4);
		//BITBITMAP(bitbmCycleArrow, posx, 438, 1, Buffer_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 438, 0, UI_Plane3);
		BITBITMAP(bitbmCycleArrow, posx, 438, 0, UI_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 438, 0, UI_Plane5);	
	}
	else BITBITMAP(bitbmCycleArrow, posx, 438, 1, UI_Plane5);
}
//##########################################################################################################################################################

void Display::DrawMenuArrowCycle2(int posx, int active)						// Draw the knob turn cycle
{
	if (active)
	{
		BITBITMAP(bitbmCycleArrow, posx, 455, 1, Channel_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 455, 1, Buffer_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 455, 0, UI_Plane3);
		BITBITMAP(bitbmCycleArrow, posx, 455, 0, UI_Plane4);		
	}
	else BITBITMAP(bitbmCycleArrow, posx, 455, 1, UI_Plane5);
}
//##########################################################################################################################################################

void Display::DrawMenuBiggerArrowCycle(int posx, int active)					// Draw the knob turn cycle with popup arrow
{
	if (active)
	{
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 1, Channel_Plane4);
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 1, Buffer_Plane4);
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 0, UI_Plane3);
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 0, UI_Plane4);
	}
	else BITBITMAP(bitbmSelectCycleArrow, posx, 438, 1, UI_Plane5);
}
//##########################################################################################################################################################

void Display::DrawSubMenuArrow(int posx, int active)						// Draw the sub menu arrow
{
	if (active)  BITBITMAP(bitbmSubMenu, posx, 458, 1, Buffer_UI2Plane);
	else BITBITMAP(bitbmSubMenu, posx, 458, 1, UI_Plane5);
	UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::DRAW_ALL_CURSOR(void)								// Draw the Cursors
{
	int c;
    	int BufVal1 = 0;
    	int BufVal2 = 0;
    	int BufVal3 = 0;
    	int BufVal4 = 0;
    	int BufVal5 = 0;
    	int BufVal6 = 0;
	int vert_cursor_max = GRID_HEIGHT + 1;		// BF
	
	int horz_cursor_start = 0;
	int horz_cursor_stop = GRID_WIDTH;		// BF
	
	long Cursor_Horizontal_Position1 = 0;							// Store Cursor horizontal I position
	long Cursor_Horizontal_Position2 = 0;							// Store Cursor horizontal II position
	
	long QM_Vertical_Position1 = 0;
	long QM_Vertical_Position2 = 0;
	
	long QM_Horizontal_Position1 = 0;
	long QM_Horizontal_Position2 = 0;
	int lXOffs = GRID_XOFFS;
	


	//if (Splash_drawed) return;

	if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON) vert_cursor_max = (GRID_HEIGHT / 2) - 2;  //BF -> delayed height limit


	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// 			remove old cursors
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	//---------------------------------------------
	// remove Pretrigger sign 
	//---------------------------------------------

	// new pretrigger position
	BufVal1 = Trig_Pos_Display + DrawOffsetX;
	BufVal2 = Trig_Pos_Display_dmode + DrawOffsetX;
	
	if (MenuStatus[MENU_TIMEBASE][1] == BTN_OFF) BufVal2 = 0;
	else if (BufVal2 > (GRID_WIDTH - 1 + DrawOffsetX)) BufVal2 = GRID_WIDTH - 1 + DrawOffsetX;
	else if (BufVal2 < (DrawOffsetX + 1)) BufVal2 = DrawOffsetX + 1;
	
	
	//printf("BV1 : %5d BV2 : %5d\n", BufVal1, BufVal2);

	// delete signs in main window
	if (BufVal1 != Trig_Pos_Display_old || FFT_Mode != FFT_OFF)
	{
		
		if (Trig_Pos_Display_old <= (DrawOffsetX + 1))						// delete arrow to the left
		{ Display::Rect(DrawOffsetX + 1, 21, 14, 12, 0, Buffer_Mark1Plane); }
		else if (Trig_Pos_Display_old >= (GRID_WIDTH - 1 + DrawOffsetX))			// delete arrow to the right
		{ Display::Rect(GRID_WIDTH - 13 + DrawOffsetX, 21, 14, 12, 0, Buffer_Mark1Plane); }
		else											// delete pretrigger sign
		{
			DRAWLINEP(Trig_Pos_Display_old - 2, 22, Trig_Pos_Display_old + 3, 22, 0, UI_Plane2);
			DRAWLINEP(Trig_Pos_Display_old, 22, Trig_Pos_Display_old, 27, 0, UI_Plane2);
	
			Display::Rect(Trig_Pos_Display_old-5, 20, 10, 10, 0, Buffer_Mark1Plane);
			Display::Rect(Trig_Pos_Display_old-5, 20, 10, 10, 0, Marker_Plane1);
		}
	}

	//BF remove delayed pretrigger sign
	if (BufVal2 != Trig_Pos_Display_dmode_old || FFT_Mode != FFT_OFF)
	{ 
		if (Trig_Pos_Display_dmode_old <= (DrawOffsetX + 1))					// delete arrow to the left
		{ Display::Rect(DrawOffsetX + 1, 221, 18, 18, 0, Buffer_Mark1Plane); }
		else if (Trig_Pos_Display_dmode_old >= (GRID_WIDTH - 1 + DrawOffsetX))			// delete arrow to the right
		{ Display::Rect(GRID_WIDTH - 13 + DrawOffsetX, 221, 18, 18, 0, Buffer_Mark1Plane); }
		else											// delete pretrigger sign
		{ Display::Rect(Trig_Pos_Display_dmode_old-8, 220, 16, 10, 0, Buffer_Mark1Plane); }
	}		// BF new trigger sign deletion
	

	//---------------------------------------------
	// remove cursors 
	//---------------------------------------------

	for (c = DrawOffsetY; c < ((GRID_HEIGHT / 2) + 1 + DrawOffsetY); c++)
	{
		// Remove vertical Cursor first	
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		// Remove vertical quick measurement cursor
		*(Buffer_Mark1Plane + (QM_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (QM_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		// Remove delayed cursor		
		*(Buffer_Mark1Plane + (Cursor_Delayed_1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (Cursor_Delayed_2_Old / 32) + (c * 20)) = 0;
	}		
       		
	for (c = ((GRID_HEIGHT / 2) + 1 + DrawOffsetY); c < (GRID_HEIGHT + 2 + DrawOffsetY); c++)
	{	
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		*(Buffer_Mark1Plane + (QM_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (QM_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		*(Buffer_Mark1Plane + (dmode_Cursor_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (dmode_Cursor_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		*(Buffer_Mark1Plane + (dmode_QM_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (dmode_QM_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	}

	for (c = 0; c < 20; c++)
	{
		// Remove horizontal cursor first	
		*(Buffer_Mark1Plane + (Cursor_Horizontal_Position1_Old * 20) + c) = 0;
		*(Buffer_Mark1Plane + (Cursor_Horizontal_Position2_Old * 20) + c) = 0;	
	
		// Remove horizontal quick measurement cursor
		*(Buffer_Mark1Plane + (QM_Horizontal_Position1_Old * 20) + c) = 0;
		*(Buffer_Mark1Plane + (QM_Horizontal_Position2_Old * 20) + c) = 0;	
	
		// Remove horizontal cursor first	
		*(Buffer_Mark1Plane + ((Cursor_Horizontal_Position1_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;
		*(Buffer_Mark1Plane + ((Cursor_Horizontal_Position2_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;	
	
		// Remove horizontal quick measurement cursor
		*(Buffer_Mark1Plane + ((QM_Horizontal_Position1_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;
		*(Buffer_Mark1Plane + ((QM_Horizontal_Position2_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;
	}
	
	//******** Everything removed - start drawing *********

	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// 			draw pretrigger sign
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	//---------------------------------------------
	// Draw Pretrigger sign in main window
	//---------------------------------------------
	// Draw the filled Triangle for Offset Position
	if (XY_Mode == 0 && FFT_Mode == FFT_OFF)	//Main mode
	{

		if (BufVal1 <= (DrawOffsetX + 1))					// arrow to the left
		{
			BufVal1 = DrawOffsetX + 1;
		
			Line(BufVal1 + 0, 26, BufVal1 + 11, 26, Buffer_Mark1Plane);
		
			Line(BufVal1 + 1, 25, BufVal1 + 1, 28, Buffer_Mark1Plane);
			Line(BufVal1 + 2, 24, BufVal1 + 2, 29, Buffer_Mark1Plane);
			Line(BufVal1 + 3, 23, BufVal1 + 3, 30, Buffer_Mark1Plane);
			Line(BufVal1 + 4, 22, BufVal1 + 4, 31, Buffer_Mark1Plane);
			Line(BufVal1 + 5, 21, BufVal1 + 5, 32, Buffer_Mark1Plane);
	
		}
		else if (BufVal1 >= (GRID_WIDTH - 1 + DrawOffsetX))			// arrow to the right
		{
			BufVal1 = GRID_WIDTH - 1 + DrawOffsetX;
		
			Line(BufVal1 - 10, 26, BufVal1 + 1, 26, Buffer_Mark1Plane);
		
			Line(BufVal1 - 1, 25, BufVal1 - 1, 28, Buffer_Mark1Plane);
			Line(BufVal1 - 2, 24, BufVal1 - 2, 29, Buffer_Mark1Plane);
			Line(BufVal1 - 3, 23, BufVal1 - 3, 30, Buffer_Mark1Plane);
			Line(BufVal1 - 4, 22, BufVal1 - 4, 31, Buffer_Mark1Plane);
			Line(BufVal1 - 5, 21, BufVal1 - 5, 32, Buffer_Mark1Plane);
		}
		else									// trigger sign
		{
			Line(BufVal1 - 3, 21, BufVal1 + 4, 21, Buffer_Mark1Plane);
			Line(BufVal1 - 3, 22, BufVal1 + 4, 22, Buffer_Mark1Plane);
			Line(BufVal1 - 3, 23, BufVal1 + 4, 23, Buffer_Mark1Plane);
			Line(BufVal1 - 3, 24, BufVal1 + 4, 24, Buffer_Mark1Plane);
		
			Line(BufVal1 - 3, 25, BufVal1 + 4, 25, Buffer_Mark1Plane);
			Line(BufVal1 - 2, 26, BufVal1 + 3, 26, Buffer_Mark1Plane);
			Line(BufVal1 - 1, 27, BufVal1 + 2, 27, Buffer_Mark1Plane);
			PixelOn(BufVal1, 28, Buffer_Mark1Plane);
		
			Line(BufVal1 - 3, 21, BufVal1 + 4, 21, Marker_Plane1);
			Line(BufVal1 - 3, 22, BufVal1 + 4, 22, Marker_Plane1);
			Line(BufVal1 - 3, 23, BufVal1 + 4, 23, Marker_Plane1);
			Line(BufVal1 - 3, 24, BufVal1 + 4, 24, Marker_Plane1);
		
			Line(BufVal1 - 3, 25, BufVal1 + 4, 25, Marker_Plane1);
			Line(BufVal1 - 2, 26, BufVal1 + 3, 26, Marker_Plane1);
			Line(BufVal1 - 1, 27, BufVal1 + 2, 27, Marker_Plane1);
			PixelOn(BufVal1, 28, Marker_Plane1);
		
			Line(BufVal1 - 2, 22, BufVal1 + 3, 22, UI_Plane2);
			Line(BufVal1, 22, BufVal1, 27, UI_Plane2);
		}

		Trig_Pos_Display_old = BufVal1; // Save actual position	

        	//--------------------------------------------------
		// Draw pretrigger sign in delayed window
		//--------------------------------------------------
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
		{
		if (BufVal2 <= (DrawOffsetX + 1))					// arrow to the left
		{
			Line(BufVal2 + 0, 226, BufVal2 + 11, 226, Buffer_Mark1Plane);
		
			Line(BufVal2 + 1, 225, BufVal2 + 1, 228, Buffer_Mark1Plane);
			Line(BufVal2 + 2, 224, BufVal2 + 2, 229, Buffer_Mark1Plane);
			Line(BufVal2 + 3, 223, BufVal2 + 3, 230, Buffer_Mark1Plane);
			Line(BufVal2 + 4, 222, BufVal2 + 4, 231, Buffer_Mark1Plane);
			Line(BufVal2 + 5, 221, BufVal2 + 5, 232, Buffer_Mark1Plane);
	
		}
		else if (BufVal2 >= (GRID_WIDTH - 1 + DrawOffsetX))			// arrow to the right
		{
			Line(BufVal2 - 10, 226, BufVal2 + 1, 226, Buffer_Mark1Plane);
		
			Line(BufVal2 - 1, 225, BufVal2 - 1, 228, Buffer_Mark1Plane);
			Line(BufVal2 - 2, 224, BufVal2 - 2, 229, Buffer_Mark1Plane);
			Line(BufVal2 - 3, 223, BufVal2 - 3, 230, Buffer_Mark1Plane);
			Line(BufVal2 - 4, 222, BufVal2 - 4, 231, Buffer_Mark1Plane);
			Line(BufVal2 - 5, 221, BufVal2 - 5, 232, Buffer_Mark1Plane);
		}
		else									// trigger sign
		{
			Line(BufVal2 - 5, 222, BufVal2 + 6, 222, Buffer_Mark1Plane);
			Line(BufVal2 - 4, 223, BufVal2 + 5, 223, Buffer_Mark1Plane);
			Line(BufVal2 - 3, 224, BufVal2 + 4, 224, Buffer_Mark1Plane);
			Line(BufVal2 - 2, 225, BufVal2 + 3, 225, Buffer_Mark1Plane);
			Line(BufVal2 - 1, 226, BufVal2 + 2, 226, Buffer_Mark1Plane);
			PixelOn(BufVal2, 227, Buffer_Mark1Plane);
		}
			Trig_Pos_Display_dmode_old = BufVal2;
		
			// draw delayed cursor
			BufVal1 = Cursor_Delayed_1 + DrawOffsetX;
			BufVal2 = Cursor_Delayed_2 + DrawOffsetX;
		
			if (BufVal1 > (GRID_WIDTH + DrawOffsetX)) BufVal1 = GRID_WIDTH + DrawOffsetX;
			if (BufVal1 < DrawOffsetX) BufVal1 = DrawOffsetX;
			if (BufVal2 > (GRID_WIDTH + DrawOffsetX)) BufVal2 = GRID_WIDTH + DrawOffsetX;
			if (BufVal2 < DrawOffsetX) BufVal2 = DrawOffsetX;

			for (c = 0; c < ((GRID_HEIGHT / 2) + 1); c++)
			{			
				if (c % 2 == 0) PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane);
				if ((c + 1) % 2 == 0) PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
			}
		
			Cursor_Delayed_1_Old = BufVal1;
			Cursor_Delayed_2_Old = BufVal2;
        	}
    	}

	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// 			calculate and draw manual measurement cursors 
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	if (Cursor_Enabled)
	{

		//------------------------------------------------------------------------------------------
		//			get absolute cursor position on screen
		//------------------------------------------------------------------------------------------

		// vertical
		if (XY_Mode)	//XY-Mode
		{
			//Absolute position for X1 and X2 cursor
			BufVal1 = Cursor_Vertical_Position_XY_1 + GRID_XY_XOFFS;
			BufVal2 = Cursor_Vertical_Position_XY_2 + GRID_XY_XOFFS;

		}	
		else if (FFT_Mode != FFT_OFF)	//FFT
		{
			//Absolute position for X1 and X2 cursor
			BufVal1 = Cursor_Vertical_Position_FFT_1 + GRID_XOFFS_FFT;
			BufVal2 = Cursor_Vertical_Position_FFT_2 + GRID_XOFFS_FFT;

		}
		else	//main + delayed timebase cursor
		{
			//Absolute position for X1 and X2 cursor
			BufVal1 = Cursor_Vertical_Position_TY_1 + GRID_XOFFS;
			BufVal2 = Cursor_Vertical_Position_TY_2 + GRID_XOFFS;
		}	

		if(!LA_active)
		{
			// horizontal
			Cursor_Horizontal_Position1 = Cursor_Horizontal_Position_Real1;
			if (Cursor_Horizontal_Position1 > GRID_HEIGHT) Cursor_Horizontal_Position1 = GRID_HEIGHT;
			else if (Cursor_Horizontal_Position1 < 0) Cursor_Horizontal_Position1 = 0;
				
			Cursor_Horizontal_Position2 = Cursor_Horizontal_Position_Real2;
			if (Cursor_Horizontal_Position2 > GRID_HEIGHT) Cursor_Horizontal_Position2 = GRID_HEIGHT;
			else if (Cursor_Horizontal_Position2 < 0) Cursor_Horizontal_Position2 = 0;
	
			// BF -> new delayed cursor calculation
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
			{
				BufVal3 = (int)((float)(Cursor_Vertical_Position_TY_1 - Cursor_Delayed_1) * Timebase_Ratio) + DrawOffsetX;
	
				// limiter
				if (BufVal3 > (GRID_WIDTH + DrawOffsetX)) BufVal3 = (GRID_WIDTH + DrawOffsetX);
				if (BufVal3 < DrawOffsetX) BufVal3 = DrawOffsetX;
			
				BufVal4 = (int)((float) (Cursor_Vertical_Position_TY_2 - Cursor_Delayed_1) * Timebase_Ratio) + DrawOffsetX;
			
				// limiter
				if (BufVal4 > (GRID_WIDTH + DrawOffsetX)) BufVal4 = (GRID_WIDTH + DrawOffsetX);
				if (BufVal4 < DrawOffsetX) BufVal4 = DrawOffsetX;
			}
		}
		else
		{ BufVal3 = 0; BufVal4 = 0; }

		//------------------------------------------------------------------------------------------
		// Draw New Vertical Cursor into marker plane
		//------------------------------------------------------------------------------------------
		
		switch(Cursor_Vertical_Active)
		{
			// Cursor 1 is active
			case 1:
			{
		
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					//Cursor upper window in delayed grid
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane); 		
						if (c %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
					//Cursor lower window in delayed grid
					for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)
					{
						PixelOn(BufVal3, c + DrawOffsetY, Buffer_Mark1Plane); 		
						if (c %10 == 0) Rect(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				else	//Not delayed
				{
					//Main Grid full height
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane); 		
						if (c %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}
			// Cursor 2 is active
			case 2:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
					}
		
					for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)
					{
						if (c %10 == 0) Rect(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						PixelOn(BufVal4, c + DrawOffsetY, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
					}
				}
				break;
			}	
			// None Cursor is active
			case 3:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
		
				for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)
					{
						if (c %10 == 0) Rect(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}	
			// Both Cursor are active
			case 4:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane);
						PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
					}
		
					for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)	// BF +1????
					{
						PixelOn(BufVal3, c + DrawOffsetY, Buffer_Mark1Plane);
						PixelOn(BufVal4, c + DrawOffsetY, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane);
						PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
					}
				}
				break;
			}			
		}//switch end
		
		Cursor_Vertical_Position1_Old = BufVal1;
		Cursor_Vertical_Position2_Old = BufVal2;
		dmode_Cursor_Vertical_Position1_Old = BufVal3;
		dmode_Cursor_Vertical_Position2_Old = BufVal4;
		Cursor_Vertical_Active_Old = Cursor_Vertical_Active;
	
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	// delayed
		{
			BufVal1 = (Cursor_Horizontal_Position1 >> 1) + DrawOffsetY;
			BufVal2 = (Cursor_Horizontal_Position2 >> 1) + DrawOffsetY;	
		}
		else
		{
			BufVal1 = Cursor_Horizontal_Position1 + DrawOffsetY;
			BufVal2 = Cursor_Horizontal_Position2 + DrawOffsetY;	
		}



		//--------------------------------------------------------------------------------------
		//BF new horizontal cursor dimension for FFT and XY due to the variing grid width
		//--------------------------------------------------------------------------------------
		
		if (XY_Mode)			// XY
		{
			lXOffs = GRID_XY_XOFFS;
			horz_cursor_start = 0;
			horz_cursor_stop = GRID_XY - 4;
		
		}
		else if(FFT_Mode != FFT_OFF)	// FFT
		{
			lXOffs = GRID_XOFFS_FFT;
			horz_cursor_start = 0;
			horz_cursor_stop = GRID_WIDTH_FFT - 4;
		
		}
		else				// main + delayed
		{
			lXOffs = GRID_XOFFS;
			horz_cursor_start = 0;
			horz_cursor_stop = GRID_WIDTH - 4;
		}

        	// Draw New Horizontal Cursor
		if (!LA_active)
		switch(Cursor_Horizontal_Active)
		{
			// Cursor 1 is active
			case 1:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == 241)	//delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						PixelOn(c + lXOffs, BufVal1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
			
						PixelOn(c + lXOffs, BufVal1 + (GRID_HEIGHT / 2) + 1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + lXOffs, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				else	//not delayed
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						PixelOn(c + lXOffs, BufVal1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}
			// Cursor 2 is active
			case 2:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == 241)	//delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						if (c %10 == 0) Rect(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						PixelOn(c + lXOffs, BufVal2, Buffer_Mark1Plane);			
			
						if (c %10 == 0) Rect(c + lXOffs, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
						PixelOn(c + lXOffs, BufVal2 + ((GRID_HEIGHT / 2) + 1), Buffer_Mark1Plane);	
					}
				}
				else	//not delayed
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						if (c %10 == 0) Rect(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						PixelOn(c + lXOffs, BufVal2, Buffer_Mark1Plane);			
					}
				}
				break;
			}
			// None Cursor is active
			case 3:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == 241)	//delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						if (c %10 == 0) Rect(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
			
						if (c %10 == 0) Rect(c + lXOffs, BufVal1 + (GRID_HEIGHT / 2) + 1, 6, 1, 1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + lXOffs, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				else	//not delayed
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						if (c %10 == 0) Rect(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}	
			// Both Cursor are active
			case 4:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == 241)	//delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						PixelOn(c + lXOffs, BufVal1, Buffer_Mark1Plane);
						PixelOn(c + lXOffs, BufVal2, Buffer_Mark1Plane);
			
						PixelOn(c + lXOffs, BufVal1 + (GRID_HEIGHT / 2) + 1, Buffer_Mark1Plane);
						PixelOn(c + lXOffs, BufVal2 + (GRID_HEIGHT / 2) + 1, Buffer_Mark1Plane);
					}
				}
				else	//not delayed
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						PixelOn(c + lXOffs, BufVal1, Buffer_Mark1Plane);
						PixelOn(c + lXOffs, BufVal2, Buffer_Mark1Plane);
					}
				}
				break;
			}					
		}
		
		Cursor_Horizontal_Position1_Old = BufVal1;
		Cursor_Horizontal_Position2_Old = BufVal2;
		Cursor_Horizontal_Active_Old = Cursor_Horizontal_Active;

	}	//BF end if(Cursor_Enabled)


	//----------------------------------------
	//    Draw quick measurement cursor
	//----------------------------------------
	if (QM_Enabled && !UI_request && MenuStatus[MENU_DISPL_SETUP][3] == BTN_ON)
	{
		QM_Vertical_Position1 = QM_Vertical_Position_Real1;
		if (QM_Vertical_Position1 > GRID_WIDTH) QM_Vertical_Position1 = GRID_WIDTH;	//BF limiter
		else if (QM_Vertical_Position1 < 0) QM_Vertical_Position1 = 0;	
	
		QM_Vertical_Position2 = QM_Vertical_Position_Real2;
		if (QM_Vertical_Position2 > GRID_WIDTH) QM_Vertical_Position2 = GRID_WIDTH;	//BF limiter
		else if (QM_Vertical_Position2 < 0) QM_Vertical_Position2 = 0;	
		
		QM_Horizontal_Position1 = QM_Horizontal_Position_Real1;
		if (QM_Horizontal_Position1 > GRID_HEIGHT) QM_Horizontal_Position1 = GRID_HEIGHT;	//BF limiter
		else if (QM_Horizontal_Position1 < 0) QM_Horizontal_Position1 = 0;
			
		QM_Horizontal_Position2 = QM_Horizontal_Position_Real2;
		if (QM_Horizontal_Position2 > GRID_HEIGHT) QM_Horizontal_Position2 = GRID_HEIGHT;	//BF limiter
		else if (QM_Horizontal_Position2 < 0) QM_Horizontal_Position2 = 0;		
	
		if (XY_Mode == 1)
		{
			if (QM_Vertical_Position1 < DrawXYOffsetX1) QM_Vertical_Position1 = DrawXYOffsetX1;	//BF limiter
			else if (QM_Vertical_Position1 > DrawXYOffsetX2) QM_Vertical_Position1 = DrawXYOffsetX2;	
			
			if (QM_Vertical_Position2 < DrawXYOffsetX1) QM_Vertical_Position2 = DrawXYOffsetX1;	//BF limiter
			else if (QM_Vertical_Position2 > DrawXYOffsetX2) QM_Vertical_Position2 = DrawXYOffsetX2;
		}		
	
		BufVal1 = QM_Vertical_Position1 + DrawOffsetX - 2;// + 18;
		BufVal2 = QM_Vertical_Position2 + DrawOffsetX - 2;// + 18;

		//BF new delayed cursor calculation
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
		{
			BufVal3 = (int)((float)(QM_Vertical_Position1 - Cursor_Delayed_1) * Timebase_Ratio) + DrawOffsetX;

			// limiter
			if (BufVal3 > (GRID_WIDTH + DrawOffsetX)) BufVal3 = (GRID_WIDTH + DrawOffsetX);
			if (BufVal3 < DrawOffsetX) BufVal3 = DrawOffsetX;
		
			BufVal4 = (int)((float) (QM_Vertical_Position2 - Cursor_Delayed_1) * Timebase_Ratio) + DrawOffsetX;
		
			// limiter
			if (BufVal4 > (GRID_WIDTH + DrawOffsetX)) BufVal4 = (GRID_WIDTH + DrawOffsetX);
			if (BufVal4 < DrawOffsetX) BufVal4 = DrawOffsetX;
		}

		// Draw New Vertical Cursor
		switch(QM_Vertical_Active)
		{
			// Cursor 1 is active
			case 1:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane); 		
						if (c %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
					for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
					{
						PixelOn(BufVal3, c + DrawOffsetY, Buffer_Mark1Plane); 		
						if (c %10 == 0) Rect(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane); 		
						if (c %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}
			// Cursor 2 is active
			case 2:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
					}
					for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
					{
						if (c %10 == 0) Rect(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						PixelOn(BufVal4, c + DrawOffsetY, Buffer_Mark1Plane);
					}
				}
				break;
			}	
			// None Cursor is active
			case 3:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
		
					for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
					{
						if (c %10 == 0) Rect(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}	
			// Both Cursor are active
			case 4:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane);
						PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
					}
		
					for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
					{
						PixelOn(BufVal3, c + DrawOffsetY, Buffer_Mark1Plane);
						PixelOn(BufVal4, c + DrawOffsetY, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						PixelOn(BufVal1, c + DrawOffsetY, Buffer_Mark1Plane);
						PixelOn(BufVal2, c + DrawOffsetY, Buffer_Mark1Plane);
					}
				}
				break;
			}	
			// only Cursor 1 is active
			case 5:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
		
					for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
					{
						if (c %10 == 0) Rect(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}
			// only Cursor 2 is active
			case 6:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
		
					for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
					{
						if (c %10 == 0) Rect(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = 0; c < vert_cursor_max; c++)
					{
						if (c %10 == 0) Rect(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}	
		}
		
		QM_Vertical_Position1_Old = BufVal1;
		QM_Vertical_Position2_Old = BufVal2;
		dmode_QM_Vertical_Position1_Old = BufVal3;
		dmode_QM_Vertical_Position2_Old = BufVal4;
		QM_Vertical_Active_Old = QM_Vertical_Active;

		if (XY_Mode == 1)	//X-Y mode
		{
			horz_cursor_start = DrawXYOffsetX1;
			horz_cursor_stop = DrawXYOffsetX2;
		}
		else
		{
			horz_cursor_start = 0;
			horz_cursor_stop = GRID_WIDTH;
		}


		// Draw New Horizontal Cursor
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
		{
			BufVal1 = (QM_Horizontal_Position1 >> 1) + DrawOffsetY;
			BufVal2 = (QM_Horizontal_Position2 >> 1) + DrawOffsetY;
		}
		else
		{
			BufVal1 = QM_Horizontal_Position1 + DrawOffsetY;
			BufVal2 = QM_Horizontal_Position2 + DrawOffsetY;
		}

		if (!LA_active)
		switch(QM_Horizontal_Active)
		{
			// Cursor 1 is active
			case 1:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						PixelOn(c + DrawOffsetX, BufVal1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
			
						PixelOn(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						PixelOn(c + DrawOffsetX, BufVal1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}
			// Cursor 2 is active
			case 2:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						PixelOn(c + DrawOffsetX, BufVal2, Buffer_Mark1Plane);			
			
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
						PixelOn(c + DrawOffsetX, BufVal2 * ((GRID_HEIGHT / 2) + 1), Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						PixelOn(c + DrawOffsetX, BufVal2, Buffer_Mark1Plane);			
					}
				}
				break;
			}
			// None Cursor is active
			case 3:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
			
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						if ((c + 4) %10 == 0) Rect(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}	
			// Both Cursor are active
			case 4:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						PixelOn(c + DrawOffsetX, BufVal1, Buffer_Mark1Plane);
						PixelOn(c + DrawOffsetX, BufVal2, Buffer_Mark1Plane);
			
						PixelOn(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), Buffer_Mark1Plane);
						PixelOn(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						PixelOn(c + DrawOffsetX, BufVal1, Buffer_Mark1Plane);
						PixelOn(c + DrawOffsetX, BufVal2, Buffer_Mark1Plane);
					}
				}
				break;
			}
			// only Cursor 1 is active
			case 5:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}
			// only Cursor 2 is active
			case 6:
			{
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
				{
					for (c = 0; c < GRID_WIDTH; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				else
				{
					for (c = horz_cursor_start; c < horz_cursor_stop; c++)
					{
						if (c %10 == 0) Rect(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
					}
				}
				break;
			}	
		}	//BF switch end
		
		QM_Horizontal_Position1_Old = BufVal1;
		QM_Horizontal_Position2_Old = BufVal2;
		QM_Horizontal_Active_Old = QM_Horizontal_Active;

	}//BF QM enabled end
		
    	Cursor_Enabled_Old = Cursor_Enabled;
	QM_Enabled_Old = QM_Enabled;
	
    UpdateMarkerPlane = true;    		
}
//##########################################################################################################################################################

void Display::DRAWMEMORY(char remove, char firstdraw, char redraw)
{
	int intbuf = 0;
	int pos_wst = 0;
	int pos_wsp = 0;
	int pos_to = 0;
	
	//------------------------------------
	// delete memory browser popup
	//------------------------------------
	if (remove)
	{
			Rect(104, 33, 430, 19, 0, UI_Plane1);						// Clear First	
			Rect(104, 33, 430, 19, 0, UI_Plane2);						// Clear First	
			Rect(104, 33, 430, 19, 0, UI_Plane4);						// Clear First	
			Rect(104, 33, 430, 19, 0, UI_Plane5);						// Clear First	
			Rect(104, 33, 430, 19, 0, Marker_Plane2);					// Clear First	
//			Rect(104, 33, 430, 19, 0, Buffer_Mark1Plane);					// Clear First	
		
			Memory_Window_visible = false;
	}

	//-----------------------------------
	// draw memory browser popup
	//-----------------------------------
	if (firstdraw)
	{
		Memory_Window_visible = true;
	
		DRAWROUNDBUTTON(106, 33, 430, 19, btnUnpushed, btnDraw);				// Draw Button	
		Rect(116, 35, 410, 13, 1, UI_Plane2);							// Clear First	
		Rect(116, 35, 410, 13, 0, UI_Plane4);							// Clear First	
		Rect(116, 35, 410, 13, 0, Marker_Plane2);						// Clear First
	}

	//--------------------------------------------------------
	// calculate and draw edge lines and pretrigger sign
	//--------------------------------------------------------
	if (redraw)
	{
		//----------------------------------------------
		// calculate memory window edges on screen
		//----------------------------------------------
		Memory_Window_visible = true;
	
		if (MainTimebase < 11)									// 16KByte high speed TB
		{
			pos_wst = (int) (MemWinStart / 40) + 116;
			pos_wsp = (int) ((MemWinStart + SignalMemSize) / 40) + 116;			//BF #023
			pos_to  = (int) (Trig_Pos_Mem / 40) + 116;
		}
		else if (MainTimebase < 26)								//4 KByte slow TB
		{
			pos_wst = (int) (MemWinStart / 10) + 116;
			pos_wsp = (int) ((MemWinStart + SignalMemSize) / 10) + 116;			//BF #023
			pos_to  = (int) (Trig_Pos_Mem / 10) + 116;
		}
		else if (MenuStatus[MENU_USTB][2] == USTB_8KB)						// USTB 8KB
		{
			pos_wst = (int) (MemWinStart / 20) + 116;
			pos_wsp = (int) ((MemWinStart + SignalMemSize) / 20) + 116;
			pos_to  = (int) (Trig_Pos_Mem / 20) + 116;
		}
		else if (MenuStatus[MENU_USTB][2] == USTB_32KB && USTB_Mode == USTB_ROLL)		// USTB 32KB
		{
			pos_wst = (int) (MemWinStart / 80) + 116;
			pos_wsp = (int) ((MemWinStart + SignalMemSize) / 80) + 116;
			pos_to  = (int) (Trig_Pos_Mem / 80) + 116;
		}
		else											// USTB 16KB -> default
		{
			pos_wst = (int) (MemWinStart / 40) + 116;
			pos_wsp = (int) ((MemWinStart + SignalMemSize) / 40) + 116;
			pos_to  = (int) (Trig_Pos_Mem / 40) + 116;
		}
	



		//-----------------------------
		// Remove old edge lines
		//-----------------------------

		// remove window start pos
		//DRAWLINEP(mb_window_start_old, 36, mb_window_start_old, 47, 0, UI_Plane5);					// switch off edge line layer -> dark gray
		//DRAWLINEP(mb_window_start_old, 36, mb_window_start_old, 47, 0, UI_Plane1);					// switch off edge line layer -> light gray
		DRAWLINEP(mb_window_start_old, 36, mb_window_start_old, 47, 0, Marker_Plane2);					// switch off edge line layer -> light red
		Line(mb_window_start_old, 36, mb_window_start_old, 47, UI_Plane2);						// switch on black layer
	
		// remove window stop pos
		//DRAWLINEP(mb_window_stop_old, 36, mb_window_stop_old, 47, 0, UI_Plane5);					// switch off edge line layer -> dark gray
		//DRAWLINEP(mb_window_stop_old, 36, mb_window_stop_old, 47, 0, UI_Plane1);					// switch off edge line layer -> light gray
		DRAWLINEP(mb_window_stop_old, 36, mb_window_stop_old, 47, 0, Marker_Plane2);					// switch off edge line layer -> light red
		Line(mb_window_stop_old, 36, mb_window_stop_old, 47, UI_Plane2);						// switch on black layer

		// remove sign for pretrigger position
		DRAWLINEP(mb_window_trigger_old, 39, mb_window_trigger_old, 44, 0, Marker_Plane2);				// switch off pretrigger sign layer 
		DRAWLINEP(mb_window_trigger_old - 2, 39, mb_window_trigger_old + 3, 39, 0, Marker_Plane2);			// switch off pretrigger sign layer 
		Line(mb_window_trigger_old, 39, mb_window_trigger_old, 44, UI_Plane2);						// switch on black layer
		Line(mb_window_trigger_old - 2, 39, mb_window_trigger_old + 3, 39, UI_Plane2);					// switch on black layer

		if (mb_window_trigger_old < 119)										// remove parts of pretrigger sign which
		{														// are too far left
			Rect(113, 39, 3, 5, 0, Marker_Plane2);
			Rect(113, 39, 3, 5, 0, UI_Plane2);
		}

		if (mb_window_trigger_old > 522)										// remove parts of pretrigger sign which
		{														// are too far right
			PixelOff(526, 39, Marker_Plane2);
			PixelOff(526, 39, UI_Plane2);
		}
	
		//-----------------------------------------
		// draw lines and pretrigger sign
		//-----------------------------------------	

		// Window Start Pos
		//Line(pos_wst, 36, pos_wst, 47, UI_Plane5);									// draw edge line -> dark gray	
		//Line(pos_wst, 36, pos_wst, 47, UI_Plane1);									// draw edge line -> light gray		
		Line(pos_wst, 36, pos_wst, 47, Marker_Plane2);									// draw edge line -> light red	
		DRAWLINEP(pos_wst, 36, pos_wst, 47, 0, UI_Plane2);								// switch off black layer
		mb_window_start_old = pos_wst;
	
		// Window Stop Pos
		//Line(pos_wsp, 36, pos_wsp, 47, UI_Plane5);									// draw edge line -> dark gray	
		//Line(pos_wsp, 36, pos_wsp, 47, UI_Plane1);;									// draw edge line -> light gray	
		Line(pos_wsp, 36, pos_wsp, 47, Marker_Plane2);									// draw edge line -> light red	
		DRAWLINEP(pos_wsp, 36, pos_wsp, 47, 0, UI_Plane2);								// switch off black layer
		mb_window_stop_old = pos_wsp;
	
		// Trigger Pos
		Line(pos_to, 39, pos_to, 44, Marker_Plane2);									// draw pretrigger sign -> light red
		Line(pos_to - 2, 39, pos_to + 3, 39, Marker_Plane2);								// draw pretrigger sign -> light red
		DRAWLINEP(pos_to, 39, pos_to, 44, 0, UI_Plane2);								// switch off black layer
		DRAWLINEP(pos_to - 2, 39, pos_to + 3, 39, 0, UI_Plane2);							// switch off black layer
		//DRAWLINEP(pos_to, 39, pos_to, 44, 0, UI_Plane5);								// switch off edge line layer to bring pretrigger sign
		//DRAWLINEP(pos_to, 39, pos_to, 44, 0, UI_Plane1);								// to foreground -> only if using different layer for
		//DRAWLINEP(pos_to - 2, 39, pos_to + 3, 39, 0, UI_Plane5);							// pretrigger sign and edge lines
		//DRAWLINEP(pos_to - 2, 39, pos_to + 3, 39, 0, UI_Plane1);						
		mb_window_trigger_old = pos_to;

	}

    //UpdateMarkerPlane = true;
}
//##########################################################################################################################################################
// BF added FFT cursor data, new two step logic
// writes delta values on three buttons on top of the normal button menu
void Display::DrawCursorDeltaValues(char set)
{
	if (set)
	{	
		int posx = 0;
		int posy = 0;

		if (!CRS_Delta) return;	
	
		if (MenuPopupActive > -1) return;
		
	
		for (posy = 408 * 20; posy < 428 * 20; posy+=20)
		{
			for (posx = 0; posx < 20; posx++) *(Buffer_UI2Plane + posy + posx) = 0;		// delete Text		
		}	
/*	
		for (posy = 408 * 20; posy < 428 * 20; posy+=20)
		{
			for (posx = 14; posx < 20; posx++) *(Buffer_UI2Plane + posy + posx) = 0;	// delete Text		
		}	
*/
		if (Cursor_Enabled)
		{
			if (Cursor_Data_First_Draw)
			{
				//draw buttons
				DRAWROUNDBUTTON(1, 408, 214, 23, btnUnpushed, btnDraw);						// Button left
				DRAWROUNDBUTTON(214, 408, 214, 23, btnUnpushed, XY_Mode);					// Button middle
				if (!LA_active)DRAWROUNDBUTTON(426, 408, 214, 23, btnUnpushed, btnDraw);			// Button right	
			}

			// print text on screen
			if (XY_Mode)
			{
				TEXTOUTxvbig(Cursor_Delta_XY_X.Read_Text(), 20, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				TEXTOUTxvbig(Cursor_Delta_Y.Read_Text(), 440, 412, 1, Buffer_UI2Plane);			// Draw Cursor Text	
			}
			else if (FFT_Mode != FFT_OFF)
			{
				TEXTOUTxvbig(FFT_Cursor_Delta_X.Read_Text(), 20, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				TEXTOUTxvbig(FFT_Cursor_Delta_1X.Read_Text(), 230, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				TEXTOUTxvbig(FFT_Cursor_Delta_Y.Read_Text(), 440, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
			}
			else	// normal mode
			{
				TEXTOUTxvbig(Cursor_Delta_X.Read_Text(), 20, 412, 1, Buffer_UI2Plane);			// Draw Cursor Text	
				TEXTOUTxvbig(Cursor_Delta_1X.Read_Text(), 230, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				if (!LA_active)TEXTOUTxvbig(Cursor_Delta_Y.Read_Text(), 440, 412, 1, Buffer_UI2Plane);	// Draw Cursor Text	
			}
		}
		
		Cursor_Data_First_Draw = 0;
		Cursor_Data_Draw_Pos = 0;

		UpdateMenuTextPlane = true;	
	}
	else		//delete cursor data
	{
		// remove the cursor data
		for (int ix = 408 * 20; ix < 430 * 20; ix++)
		{
			*(UI_Plane1 + ix) = 0;		// delete
			*(Buffer_UI2Plane + ix) = 0;	// delete Text
			*(UI_Plane2 + ix) = 0;		//Guido add: delete button-text
			*(UI_Plane4 + ix) = 0;		// delete
			*(UI_Plane5 + ix) = 0;		// delete
		}

	}

}
//##########################################################################################################################################################

void Display::DrawQMData(char set)
{
	int posx = 0;
	int posy = 0;
	
	if (MenuPopupActive > -1) return;
	
	if (set)
	{			
		if (Quick_Measure_First_Draw)
		{
			// remove the cursor data
			for (posx = 408 * 20; posx < 430 * 20; posx++)
			{
				*(UI_Plane1 + posx) = 0;	// delete
				*(Buffer_UI2Plane + posx) = 0;	// delete Text	
				*(UI_Plane2 + posx) = 0;	// delete
				*(UI_Plane4 + posx) = 0;	// delete
				*(UI_Plane5 + posx) = 0;	// delete
			}
		}
		else		
		{
			if (QM_Changed[0] == 1)
			{
				for (posy = 408 * 20; posy < 428 * 20; posy+=20)
				{ for (posx = 0; posx < 6; posx++) *(Buffer_UI2Plane + posy + posx) = 0; }	// delete Text		
			}
			if (QM_Changed[1] == 1)
			{
				for (posy = 408 * 20; posy < 428 * 20; posy+=20)
				{ for (posx = 6; posx < 13; posx++) *(Buffer_UI2Plane + posy + posx) = 0; }	// delete Text		
			}
			if (QM_Changed[2] == 1)
			{
				for (posy = 408 * 20; posy < 428 * 20; posy+=20)
				{ for (posx = 13; posx < 20; posx++) *(Buffer_UI2Plane + posy + posx) = 0; }	// delete Text		
			}
		}
	
		if (QM_Enabled)
		{		
			if (Quick_Measure_First_Draw)
			{
				if (QM_Type[0] > 0) DRAWROUNDBUTTON(1, 408, 214, 23, btnUnpushed, btnDraw);		// Button
				if (QM_Type[1] > 0) DRAWROUNDBUTTON(214, 408, 214, 23, btnUnpushed, btnDraw);		// Button
				if (QM_Type[2] > 0) DRAWROUNDBUTTON(426, 408, 214, 23, btnUnpushed, btnDraw);		// Button	
			}
			
			if (QM_Type[0] > 0) TEXTOUTxvbig(QM_Slot1.Read_Text(), 20, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
			if (QM_Type[1] > 0) TEXTOUTxvbig(QM_Slot2.Read_Text(), 230, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
			if (QM_Type[2] > 0) TEXTOUTxvbig(QM_Slot3.Read_Text(), 440, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
		}
		
		Quick_Measure_First_Draw = 0;
		Quick_Measure_Data_Draw_Pos = 0;
		if (QM_Type[0] > 0) QM_Changed[0] = 0;
		if (QM_Type[1] > 0) QM_Changed[1] = 0;
		if (QM_Type[2] > 0) QM_Changed[2] = 0;

		UpdateMenuTextPlane = true;
	}
	else		// remove QM data
	{
		for (int ix = 408 * 20; ix < 430 * 20; ix++)
		{
			*(UI_Plane1 + ix) = 0;		// delete
			*(Buffer_UI2Plane + ix) = 0;	// delete Text
			*(UI_Plane2 + ix) = 0;		//Guido add: delete button-text
			*(UI_Plane4 + ix) = 0;		// delete
			*(UI_Plane5 + ix) = 0;		// delete
		}
	}

}
//##########################################################################################################################################################
//BF changed due to new grid dimension and replaced switch against indexed array fetch
void Display::CALCCURSORDATA(void)  								// channel = source im cursor menu
{
	int lCursorOffset = 0;	
	int lVoltRange = 0;		
	int lZero = 0;		
	int lProbe = 0;
	
	float lVoltOffset = 0, lVoltOffs1 = 0, lVoltOffs2 = 0;	
	float lVoltFactor;

	int time = 0;
	float tfactor = 0;
	float timeoff = 0;			
	
	char BufferText[10];
	
	int channel = MenuStatus[MENU_CURSOR][0] - 26;

//printf("Calc Cursor Data\n\r");
			
	switch(channel)
	{
	 	case 1:	//Cursor Source 1 set (use CH1 voltage)
		{				
			lVoltRange = Selected_Voltage_CH1;
			lZero = ZeroLevelCH1;
			lProbe = MenuStatus[1][3] - 101;
			break;
		}
		case 2: //Cursor Source 2 set (use CH2 voltage)
		{				
			lVoltRange = Selected_Voltage_CH2;
			lZero = ZeroLevelCH2;
			lProbe = MenuStatus[2][3] - 101;
			break;
		}
		case 3: //Cursor Source 3 set (use CH3 voltage)
		{				
			lVoltRange = Selected_Voltage_CH3;
			lZero = ZeroLevelCH3;
			lProbe = MenuStatus[3][3] - 101;
			break;
		}
		case 4: //Cursor Source 4 set (use CH4 voltage)
		{				
			lVoltRange = Selected_Voltage_CH4;
			lZero = ZeroLevelCH4;
			lProbe = MenuStatus[4][3] - 101;
			break;	
		}
		case 5: //Cursor Source math set (use math voltage)
		{				
			lVoltRange = math_scale;
			lZero = ((GRID_HEIGHT/2) - Math_Offset);
			lProbe = 3;	// 1:1
			break;	
		}

	}
	//printf("VoltRange : %d    Probe : %d\n\r",lVoltRange,lProbe);	

	lVoltFactor =  VoltFactor[lVoltRange] * VoltFactor[lProbe] * 2;

	lCursorOffset = lZero - Cursor_Horizontal_Position_Real1;

	lVoltOffs1 =  (float)lCursorOffset * lVoltFactor;

	Cursor_Horizontal_Pos_1_Str.Write_Value(lVoltOffs1);
	Cursor_Horizontal_Pos_1_Str.RenderText();
		
	
	lCursorOffset = lZero - Cursor_Horizontal_Position_Real2;	
	
	lVoltOffs2 =  (float)lCursorOffset * lVoltFactor;

	Cursor_Horizontal_Pos_2_Str.Write_Value(lVoltOffs2);
	Cursor_Horizontal_Pos_2_Str.RenderText();	
	

	if (lVoltOffs1 > lVoltOffs2) lVoltOffset = lVoltOffs1 - lVoltOffs2;
	else lVoltOffset = lVoltOffs2 - lVoltOffs1;
	if (lVoltOffset < 0)lVoltOffset = -lVoltOffset;

	//display delta values?
	if(CRS_Delta)
	{	
		if (XY_Mode)
		{			
			sprintf(BufferText, "@Y = ");
		}
		else
		{			
			switch(channel)
			{
				case 1: sprintf(BufferText, "@Y [ = "); break;
				case 2: sprintf(BufferText, "@Y \\ = "); break;
				case 3: sprintf(BufferText, "@Y ] = "); break;
				case 4: sprintf(BufferText, "@Y ^ = "); break;
				case 5: sprintf(BufferText, "@Y(M) = "); break;
			}
		}
			
		Cursor_Delta_Y.Write_PreText(BufferText);
		Cursor_Delta_Y.Write_Value(lVoltOffset);
		Cursor_Delta_Y.RenderText();				
	}

	if (XY_Mode)
	{
		
		switch(channel)
		{
			case 1:	
			case 2: 
			{				
				lVoltRange = Selected_Voltage_CH2;
				lZero = ZeroLevelCH2;
				lProbe = MenuStatus[2][3] - 101;
				break;
			}
			case 3: 
			case 4: 
			{				
				lVoltRange = Selected_Voltage_CH4;
				lZero = ZeroLevelCH4;
				lProbe = MenuStatus[4][3] - 101;
				break;	
			}
		}

		lVoltFactor =  VoltFactor[lVoltRange] * VoltFactor[lProbe] * 2;
	
		lCursorOffset = lZero - Cursor_Vertical_Position_XY_1;
		
		lVoltOffs1 =  (float)lCursorOffset * lVoltFactor;
	
		Cursor_Vertical_Pos_XY_1_Str.Write_Value(lVoltOffs1);
		Cursor_Vertical_Pos_XY_1_Str.RenderText();
			
		
		lCursorOffset = lZero - Cursor_Vertical_Position_XY_2; 
		
		lVoltOffs2 =  (float)lCursorOffset * lVoltFactor;
	
		Cursor_Vertical_Pos_XY_2_Str.Write_Value(lVoltOffs2);
		Cursor_Vertical_Pos_XY_2_Str.RenderText();	
	
		//display delta values?
		if(CRS_Delta)
		{		
			if (lVoltOffs1 > lVoltOffs2) lVoltOffset = lVoltOffs1 - lVoltOffs2;
			else lVoltOffset = lVoltOffs2 - lVoltOffs1;
			if (lVoltOffset < 0) lVoltOffset = -lVoltOffset;
		
			sprintf(BufferText, "@X = ");
				
			Cursor_Delta_XY_X.Write_PreText(BufferText);
			Cursor_Delta_XY_X.Write_Value(lVoltOffset);
			Cursor_Delta_XY_X.RenderText();
		}
	
	}
	else	//main time mode
	{
		tfactor = TimeBaseFactor[MainTimebase+VirtualTimebase] / 1000000;
	
		lCursorOffset = Cursor_Vertical_Position_TY_1;
	
		timeoff =  (float)lCursorOffset * tfactor; 
		timeoff1 = timeoff;
			
		Cursor_Vertical_Pos_1_Str.Write_Value(timeoff);
		Cursor_Vertical_Pos_1_Str.RenderText();	
		
		lCursorOffset = Cursor_Vertical_Position_TY_2;
	
		timeoff =  (float)lCursorOffset * tfactor;
		timeoff2 = timeoff;
	
		Cursor_Vertical_Pos_2_Str.Write_Value(timeoff);	
		Cursor_Vertical_Pos_2_Str.RenderText();	
			
		//display delta values?
		if(CRS_Delta)
		{	
			if (timeoff1 > timeoff2) timeoff = timeoff1 - timeoff2;
			else timeoff = timeoff2 - timeoff1;
			if (timeoff < 0) timeoff = -timeoff;
			
			Cursor_Delta_X.Write_Value(timeoff);	
			Cursor_Delta_X.RenderText();
			
			timeoff = 1 / timeoff;
			Cursor_Delta_1X.Write_Value(timeoff);
			Cursor_Delta_1X.RenderText();
		}
	}
}
//##########################################################################################################################################################
// add new measure slot
void Display::QM_AddMeasurement(void)
{
	QM_Type_Old[0] = QM_Type[0];
	QM_Type_Old[1] = QM_Type[1];
	QM_Type_Old[2] = QM_Type[2];

	if (QM_Type[0] == 0)
	{
		QM_Type[0] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
		QM_Changed[0] = 1;

		if (QM_Type[0] == 2)		// delay
		{
			QM_Channel[0] = MenuStatus[MENU_QMDELAY][0] - 26;
			QM_Second_Channel[0] = MenuStatus[MENU_QMDELAY][2] - 26;
			QM_CHI_Edge[0] = MenuStatus[MENU_QMDELAY][1] - 1;            // 1 = positiv , 2 = negativ
			QM_CHII_Edge[0] = MenuStatus[MENU_QMDELAY][3] - 1;
		}
		else if (QM_Type[0] == 10)	// phase
		{
			QM_Channel[0] = MenuStatus[MENU_QMPHASE][0] - 26;
			QM_Second_Channel[0] = MenuStatus[MENU_QMPHASE][2] - 26;
		}
		else				// all others
		{ 
			QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
			QM_Second_Channel[0] = 0;
		}
	Quick_Measure_First_Draw = 1;

	}
	else if (QM_Type[1] == 0)
	{
		if ((QM_Type[0] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[0] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
		{
			QM_Type[1] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
			QM_Changed[1] = 1;

			if (QM_Type[1] == 2)		// delay
			{
				QM_Channel[1] = MenuStatus[MENU_QMDELAY][0] - 26;
				QM_Second_Channel[1] = MenuStatus[MENU_QMDELAY][2] - 26;
				QM_CHI_Edge[1] = MenuStatus[MENU_QMDELAY][1] - 1;            // 1 = positiv , 2 = negativ
				QM_CHII_Edge[1] = MenuStatus[MENU_QMDELAY][3] - 1;
			}
			else if (QM_Type[1] == 10)	// phase
			{
				QM_Channel[1] = MenuStatus[MENU_QMPHASE][0] - 26;
				QM_Second_Channel[1] = MenuStatus[MENU_QMPHASE][2] - 26;
			}
			else				// all others
			{
				QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				QM_Second_Channel[1] = 0;
			}
		}
	Quick_Measure_First_Draw = 1;

	}
	else if (QM_Type[2] == 0)
	{
		if ((QM_Type[1] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[1] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
		{
			QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
			QM_Changed[2] = 1;
			
			if (QM_Type[2] == 2)		// delay
			{
				QM_Channel[2] = MenuStatus[MENU_QMDELAY][0] - 26;
				QM_Second_Channel[2] = MenuStatus[MENU_QMDELAY][2] - 26;
				QM_CHI_Edge[2] = MenuStatus[MENU_QMDELAY][1] - 1;            // 1 = positiv , 2 = negativ
				QM_CHII_Edge[2] = MenuStatus[MENU_QMDELAY][3] - 1;
			}
			else if (QM_Type[2] == 10)	// phase
			{
				QM_Channel[2] = MenuStatus[MENU_QMPHASE][0] - 26;
				QM_Second_Channel[2] = MenuStatus[MENU_QMPHASE][2] - 26;
			}
			else				// all others
			{ 
				QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26; 
				QM_Second_Channel[2] = 0; 
			}
			
		}
	Quick_Measure_First_Draw = 1;

	}
	else	// all QM slots in use -> shift measurements to the left (fifo)
	{
		if ((QM_Type[2] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[2] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
		{
			QM_Type[0] = QM_Type[1];
			QM_Type[1] = QM_Type[2];
			QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;

			QM_Channel[0] = QM_Channel[1];
			QM_Channel[1] = QM_Channel[2];
			
			QM_Second_Channel[0] = QM_Second_Channel[1];
			QM_Second_Channel[1] = QM_Second_Channel[2];

			QM_CHI_Edge[0] = QM_CHI_Edge[1];
			QM_CHI_Edge[1] = QM_CHI_Edge[2];

			QM_CHII_Edge[0] = QM_CHII_Edge[1];
			QM_CHII_Edge[1] = QM_CHII_Edge[2];

			if (QM_Type[2] == 2)		// delay
			{
				QM_Channel[2] = MenuStatus[MENU_QMDELAY][0] - 26;
				QM_Second_Channel[2] = MenuStatus[MENU_QMDELAY][2] - 26;
				QM_CHI_Edge[2] = MenuStatus[MENU_QMDELAY][1] - 1;            // 1 = positiv , 2 = negativ
				QM_CHII_Edge[2] = MenuStatus[MENU_QMDELAY][3] - 1;
			}
			else if (QM_Type[2] == 10)	// phase
			{
				QM_Channel[2] = MenuStatus[MENU_QMPHASE][0] - 26;
				QM_Second_Channel[2] = MenuStatus[MENU_QMPHASE][2] - 26;
			}
			else				// all others
			{ 
				QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26; 
				QM_Second_Channel[2] = 0; 
			}

			QM_Changed[0] = 1;
			QM_Changed[1] = 1;
			QM_Changed[2] = 1;
		}
	}

//printf("MenuStatus = %d  Source = %d  QM_Ch[0] = %d  QM_Ch[1] = %d  QM_Ch[2] = %d\r\n",MenuStatus[MENU_QUICKMEASURE][0], MenuStatus[MENU_QUICKMEASURE][0]-26, QM_Channel[0], QM_Channel[1], QM_Channel[2]);
//printf("QT1 : %d QT2 : %d QT3 : %d MS19,1 : %d\n\r", QM_Type[0], QM_Type[1], QM_Type[2], MenuStatus[MENU_QUICKMEASURE][1]);


}

//##########################################################################################################################################################
// BF -> Quick Measure completely redesigned by Stefan
void Display::CALCQMDATA(void)
{
 //BF	#define _Debug_QM_
	
	float BufVal = 1;
	
	int step=0, ixs=0, ixss=0, cnt=0, mid_buf = 0;
	int off_buf = 0;
	short PBuf;

	short SIGNAL_THRES_PRE_POSITIV = -1;
	short SIGNAL_THRES_LOW_POSITIV = -1;
	short SIGNAL_THRES_MDL_POSITIV = -1;
	short SIGNAL_THRES_UP_POSITIV = -1;
	short SIGNAL_THRES_OVER_POSITIV = -1;
	
	short SIGNAL_THRES_PRE_NEGATIV = -1;
	short SIGNAL_THRES_LOW_NEGATIV = -1;
	short SIGNAL_THRES_MDL_NEGATIV = -1;
	short SIGNAL_THRES_UP_NEGATIV = -1;
	short SIGNAL_THRES_OVER_NEGATIV = -1;

	unsigned char *LPSIGNAL = 0;
	int channel=0;


	if (draw_factor==0)	// this must not occur!!! It will cause a crash because of divide by zero exception
	{ printf("QM -> draw_factor = 0 -> divide by zero exception will occur!\n\r"); return; }
	
	ixs  = draw_start;
	ixss = ixs + (GRID_WIDTH * draw_factor);
	step = draw_factor;

	for (channel=1;channel<=5;channel++)
	{
		SIGNAL_AVG_CNT[channel-1] = 0;
		SIGNAL_AVG[channel-1] = 0;
			
		if ((QM_Channel[0] == channel) || (QM_Channel[1] == channel) || (QM_Channel[2] == channel) || (QM_Second_Channel[0] == channel) || (QM_Second_Channel[1] == channel) || (QM_Second_Channel[2] == channel))
		{
		
			switch(channel){
				case 1: 
					if (!Channel_1_Active) continue;	//BF add #009
					
					if((MainTimebase+VirtualTimebase) < 4)	// interpolation or USTB BF #023
					LPSIGNAL = &SIGNAL1_Intpolate[0];
					else					//normal
					LPSIGNAL = S1Ptr;//SIGNAL1;

					break;
				case 2:
					if (!Channel_2_Active) continue;	//BF add #009

					if((MainTimebase+VirtualTimebase) < 4)	// interpolation or USTB BF #023
					LPSIGNAL = &SIGNAL2_Intpolate[0];
					else					//normal
					LPSIGNAL = S2Ptr;//SIGNAL2;

					break;
				case 3:
					if (!Channel_3_Active) continue;	//BF add #009
					if((MainTimebase+VirtualTimebase) < 4)	// interpolation or USTB BF #023
					LPSIGNAL = &SIGNAL3_Intpolate[0];
					else					//normal
					LPSIGNAL = S3Ptr;//SIGNAL3;

					break;
				case 4:
					if (!Channel_4_Active) continue;	//BF add #009

					if((MainTimebase+VirtualTimebase) < 4)	// interpolation or USTB BF #023
					LPSIGNAL = SIGNAL4_Intpolate;
					else					//normal
					LPSIGNAL = S4Ptr;//SIGNAL4;

					break;
				case 5:
					if (!Channel_Math_Active) continue;

					if((MainTimebase+VirtualTimebase) < 4)	// interpolation or USTB
					LPSIGNAL = SIGNALM_Intpolate;
					else					//normal
					LPSIGNAL = SMPtr;

					break;

			}

			//init buffers
			SIGNAL_MAX[channel-1] = 255;
			SIGNAL_MIN[channel-1] = 0;
			for (cnt = 0; cnt < 256; cnt++) SIGNAL_Histo[cnt+(channel-1)*256] = 0;	

			// get maxima and minima
			for (cnt = ixs; cnt < ixss; cnt+=step)
			{
				SIGNAL_Histo[LPSIGNAL[cnt]+(channel-1)*256]++;
	
				if (SIGNAL_MAX[channel-1] > LPSIGNAL[cnt]) SIGNAL_MAX[channel-1] = LPSIGNAL[cnt];
				if (SIGNAL_MIN[channel-1] < LPSIGNAL[cnt]) SIGNAL_MIN[channel-1] = LPSIGNAL[cnt];
			}
		

			if (SIGNAL_MAX[channel-1] > SIGNAL_MIN[channel-1])
			{
				PBuf = SIGNAL_MAX[channel-1];
				SIGNAL_MAX[channel-1] = SIGNAL_MIN[channel-1];
				SIGNAL_MIN[channel-1] = PBuf;
			}


		        SIGNAL_MDL[channel-1] = (SIGNAL_MIN[channel-1] + SIGNAL_MAX[channel-1]) >> 1;

			SIGNAL_TOP[channel-1] = 0;
			SIGNAL_BASE[channel-1] = 0;
			PBuf = 0;
		
			mid_buf = (int) ((SIGNAL_MIN[channel-1] + SIGNAL_MAX[channel-1]) / 2);

			for (cnt = 0; cnt < mid_buf; cnt++)
			{
				if (SIGNAL_Histo[cnt+(channel-1)*256] > PBuf)
				{
					PBuf = SIGNAL_Histo[cnt+(channel-1)*256];
					SIGNAL_TOP[channel-1] = cnt;
				}
			}

			PBuf = 0;
		
			for (cnt = 255; cnt > mid_buf; cnt--)
			{
				if (SIGNAL_Histo[cnt+(channel-1)*256] > PBuf)
				{
					PBuf = SIGNAL_Histo[cnt+(channel-1)*256];
					SIGNAL_BASE[channel-1] = cnt;
				}
			}

			if (SIGNAL_TOP[channel-1] > SIGNAL_BASE[channel-1])
			{
				PBuf = SIGNAL_TOP[channel-1];
				SIGNAL_TOP[channel-1] = SIGNAL_BASE[channel-1];
				SIGNAL_BASE[channel-1] = PBuf;
			}

			SIGNAL_THRES_UP[channel-1]  = (short) (SIGNAL_BASE[channel-1] - (((float) thres_up[channel-1] / 100) * (SIGNAL_BASE[channel-1] - SIGNAL_TOP[channel-1])));
			SIGNAL_THRES_MDL[channel-1] = (short) (SIGNAL_BASE[channel-1] - (((float) thres_mdl[channel-1] / 100) * (SIGNAL_BASE[channel-1] - SIGNAL_TOP[channel-1])));
			SIGNAL_THRES_LOW[channel-1] = (short) (SIGNAL_BASE[channel-1] - (((float) thres_low[channel-1] / 100) * (SIGNAL_BASE[channel-1] - SIGNAL_TOP[channel-1])));
/*
            printf("CH%d : tl %d  tm %d  tu %d\n\r", channel, thres_low[channel-1], thres_mdl[channel-1], thres_up[channel-1]);
            printf("CH%d : THR2L %d  THR2M %d  THR2U %d \n\r", channel, SIGNAL_THRES_LOW[channel-1], SIGNAL_THRES_MDL[channel-1], SIGNAL_THRES_UP[channel-1]);
            printf("CH%d : Top %d  Base %d \n\r", channel, SIGNAL_TOP[channel-1], SIGNAL_BASE[channel-1]);
            printf("CH%d : Min %d  Mdl %d  Max %d\n\r\n\r\n\r", channel, SIGNAL_MIN[channel-1], SIGNAL_MDL[channel-1], SIGNAL_MAX[channel-1]);
*/
			SIGNAL_THRES_PRE_POSITIV_1[channel-1] = -1;
			SIGNAL_THRES_LOW_POSITIV_1[channel-1] = -1;
			SIGNAL_THRES_MDL_POSITIV_1[channel-1] = -1;
			SIGNAL_THRES_UP_POSITIV_1[channel-1] = -1;
			SIGNAL_THRES_OVER_POSITIV_1[channel-1] = -1;
		
			SIGNAL_THRES_PRE_NEGATIV_1[channel-1] = -1;
			SIGNAL_THRES_LOW_NEGATIV_1[channel-1] = -1;
			SIGNAL_THRES_MDL_NEGATIV_1[channel-1] = -1;
			SIGNAL_THRES_UP_NEGATIV_1[channel-1] = -1;
			SIGNAL_THRES_OVER_NEGATIV_1[channel-1] = -1;
		
			SIGNAL_THRES_PRE_POSITIV_2[channel-1] = -1;
			SIGNAL_THRES_LOW_POSITIV_2[channel-1] = -1;
			SIGNAL_THRES_MDL_POSITIV_2[channel-1] = -1;
			SIGNAL_THRES_UP_POSITIV_2[channel-1] = -1;
			SIGNAL_THRES_OVER_POSITIV_2[channel-1] = -1;
		
			SIGNAL_THRES_PRE_NEGATIV_2[channel-1] = -1;
			SIGNAL_THRES_LOW_NEGATIV_2[channel-1] = -1;
			SIGNAL_THRES_MDL_NEGATIV_2[channel-1] = -1;
			SIGNAL_THRES_UP_NEGATIV_2[channel-1] = -1;
			SIGNAL_THRES_OVER_NEGATIV_2[channel-1] = -1;
		
			SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] = -1;
			SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] = -1;
			SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] = -1;
			SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] = -1;
			SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] = -1;

       
			for (cnt = ixs; cnt < ixss; cnt+=step)
			{
				if ((SIGNAL_THRES_MDL_POSITIV_1[channel-1] != 1) && (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] != -1))
				{
					SIGNAL_AVG[channel-1] += (LPSIGNAL[cnt] - SIGNAL_THRES_MDL[channel-1]);
					SIGNAL_AVG_CNT[channel-1]++;
				}
		
				if (SIGNAL_THRES_UP_POSITIV_1[channel-1] == -1)
				{
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_PRE_POSITIV_1[channel-1] = cnt;
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_1[channel-1] = cnt;
					else if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_1[channel-1] = cnt;
			
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] == -1))
					{
						SIGNAL_THRES_PRE_POSITIV_1[channel-1] = cnt ;
						SIGNAL_THRES_LOW_POSITIV_1[channel-1] = -1;
					}
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_1[channel-1] = cnt ;
					else if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_1[channel-1] = cnt ;
			
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_UP_POSITIV_1[channel-1] = cnt ;
				}


				if (SIGNAL_THRES_LOW_NEGATIV_1[channel-1] == -1)
				{
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_OVER_NEGATIV_1[channel-1] = cnt ;
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_1[channel-1] = cnt ;
					else if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_1[channel-1] = cnt ;
			
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] == -1))
					{
						SIGNAL_THRES_OVER_NEGATIV_1[channel-1] = cnt ;
						SIGNAL_THRES_UP_NEGATIV_1[channel-1] = -1;
					}
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_1[channel-1] = cnt ;
					else if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_1[channel-1] = cnt ;
			
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_LOW_NEGATIV_1[channel-1] = cnt ;
				}


				if ((SIGNAL_THRES_UP_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_2[channel-1] == -1))
				{
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_PRE_POSITIV_2[channel-1] = cnt ;
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_2[channel-1] = cnt ;
					else if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_2[channel-1] = cnt ;
			
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] == -1))
					{
						SIGNAL_THRES_PRE_POSITIV_2[channel-1] = cnt ;
						SIGNAL_THRES_LOW_POSITIV_2[channel-1] = -1;
					}
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_2[channel-1] = cnt ;
					else if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_2[channel-1] = cnt ;
			
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_UP_POSITIV_2[channel-1] = cnt ;
				}


				if ((SIGNAL_THRES_LOW_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] == -1))
				{
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_OVER_NEGATIV_2[channel-1] = cnt ;
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_2[channel-1] = cnt ;
					else if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_2[channel-1] = cnt ;
			
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] == -1))
					{
						SIGNAL_THRES_OVER_NEGATIV_2[channel-1] = cnt ;
						SIGNAL_THRES_UP_NEGATIV_2[channel-1] = -1;
					}
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_2[channel-1] = cnt ;
					else if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_2[channel-1] = cnt ;
			
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_LOW_NEGATIV_2[channel-1] = cnt ;
				}
		
		
				if ((SIGNAL_THRES_UP_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_2[channel-1] != -1))
				{
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV == -1)) SIGNAL_THRES_PRE_POSITIV = cnt ;
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_PRE_POSITIV != -1) && (SIGNAL_THRES_LOW_POSITIV == -1)) SIGNAL_THRES_LOW_POSITIV = cnt ;
					else if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_PRE_POSITIV != -1) && (SIGNAL_THRES_LOW_POSITIV == -1)) SIGNAL_THRES_LOW_POSITIV = cnt ;
			
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV != -1) && (SIGNAL_THRES_MDL_POSITIV == -1))
					{
						SIGNAL_THRES_PRE_POSITIV = cnt ;
						SIGNAL_THRES_LOW_POSITIV = -1;
					}
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV != -1) && (SIGNAL_THRES_MDL_POSITIV == -1)) SIGNAL_THRES_MDL_POSITIV = cnt ;
					else if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV != -1) && (SIGNAL_THRES_MDL_POSITIV == -1)) SIGNAL_THRES_MDL_POSITIV = cnt ;
			
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_MDL_POSITIV != -1) && (SIGNAL_THRES_UP_POSITIV == -1))
					{
						SIGNAL_THRES_UP_POSITIV = cnt ;
			
						SIGNAL_THRES_PRE_POSITIV_LAST[channel-1] = SIGNAL_THRES_PRE_POSITIV;
						SIGNAL_THRES_LOW_POSITIV_LAST[channel-1] = SIGNAL_THRES_LOW_POSITIV;
						SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] = SIGNAL_THRES_MDL_POSITIV;
						SIGNAL_THRES_UP_POSITIV_LAST[channel-1] = SIGNAL_THRES_UP_POSITIV;
						SIGNAL_THRES_OVER_POSITIV_LAST[channel-1] = SIGNAL_THRES_OVER_POSITIV;
			
						SIGNAL_THRES_PRE_POSITIV = -1;
						SIGNAL_THRES_LOW_POSITIV = -1;
						SIGNAL_THRES_MDL_POSITIV = -1;
						SIGNAL_THRES_UP_POSITIV  = -1;
						SIGNAL_THRES_OVER_POSITIV = -1;
					}
				}
		
		
				if ((SIGNAL_THRES_LOW_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] != -1))
				{
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV == -1)) SIGNAL_THRES_OVER_NEGATIV = cnt ;
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV != -1) && (SIGNAL_THRES_UP_NEGATIV == -1)) SIGNAL_THRES_UP_NEGATIV = cnt ;
					else if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV != -1) && (SIGNAL_THRES_UP_NEGATIV == -1)) SIGNAL_THRES_UP_NEGATIV = cnt ;
			
					if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV != -1) && (SIGNAL_THRES_MDL_NEGATIV == -1))
					{
						SIGNAL_THRES_OVER_NEGATIV = cnt ;
						SIGNAL_THRES_UP_NEGATIV = -1;
					}
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV != -1) && (SIGNAL_THRES_MDL_NEGATIV == -1)) SIGNAL_THRES_MDL_NEGATIV = cnt ;
					else if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV != -1) && (SIGNAL_THRES_MDL_NEGATIV == -1)) SIGNAL_THRES_MDL_NEGATIV = cnt ;
			
					if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_MDL_NEGATIV != -1) && (SIGNAL_THRES_LOW_NEGATIV == -1))
					{
						SIGNAL_THRES_LOW_NEGATIV = cnt ;
			
						SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] = SIGNAL_THRES_PRE_NEGATIV;
						SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] = SIGNAL_THRES_LOW_NEGATIV;
						SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] = SIGNAL_THRES_MDL_NEGATIV;
						SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] = SIGNAL_THRES_UP_NEGATIV;
						SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] = SIGNAL_THRES_OVER_NEGATIV;
			
						SIGNAL_THRES_PRE_NEGATIV = -1;
						SIGNAL_THRES_LOW_NEGATIV = -1;
						SIGNAL_THRES_MDL_NEGATIV = -1;
						SIGNAL_THRES_UP_NEGATIV = -1;
						SIGNAL_THRES_OVER_NEGATIV = -1;
					}
				}
		
				/*if ((SIGNAL_THRES_UP_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] != -1))
				{
				break;
				} */
			}

			if (SIGNAL_THRES_PRE_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_PRE_POSITIV_LAST[channel-1] = SIGNAL_THRES_PRE_POSITIV_2[channel-1];
			if (SIGNAL_THRES_LOW_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_LOW_POSITIV_LAST[channel-1] = SIGNAL_THRES_LOW_POSITIV_2[channel-1];
			if (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] = SIGNAL_THRES_MDL_POSITIV_2[channel-1];
			if (SIGNAL_THRES_UP_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_UP_POSITIV_LAST[channel-1] = SIGNAL_THRES_UP_POSITIV_2[channel-1];
			if (SIGNAL_THRES_OVER_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_OVER_POSITIV_LAST[channel-1] = SIGNAL_THRES_OVER_POSITIV_2[channel-1];
		
			if (SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] = SIGNAL_THRES_PRE_NEGATIV_2[channel-1];
			if (SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] = SIGNAL_THRES_LOW_NEGATIV_2[channel-1];
			if (SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] = SIGNAL_THRES_MDL_NEGATIV_2[channel-1];
			if (SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] = SIGNAL_THRES_UP_NEGATIV_2[channel-1];
			if (SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] = SIGNAL_THRES_OVER_NEGATIV_2[channel-1];

/*
printf("1 : ixs %d ixss %d tpud1 %d tpl1 %d tpm1 %d tpu1 %d\n", ixs, ixss, SIGNAL_THRES_PRE_POSITIV_1[channel-1], SIGNAL_THRES_LOW_POSITIV_1[channel-1], SIGNAL_THRES_MDL_POSITIV_1[channel-1], SIGNAL_THRES_UP_POSITIV_1[channel-1]);
printf("1 : ixs %d ixss %d tnov1 %d tnl1 %d tnm1 %d tnu1 %d \n", ixs, ixss, SIGNAL_THRES_OVER_NEGATIV_1[channel-1], SIGNAL_THRES_LOW_NEGATIV_1[channel-1], SIGNAL_THRES_MDL_NEGATIV_1[channel-1], SIGNAL_THRES_UP_NEGATIV_1[channel-1]);
printf("1 : ixs %d ixss %d tpud2 %d tpl2 %d tpm2 %d tpu2 %d\n", ixs, ixss, SIGNAL_THRES_PRE_POSITIV_2[channel-1], SIGNAL_THRES_LOW_POSITIV_2[channel-1], SIGNAL_THRES_MDL_POSITIV_2[channel-1], SIGNAL_THRES_UP_POSITIV_2[channel-1]);
printf("1 : ixs %d ixss %d tnov2 %d tnl2 %d tnm2 %d tnu2 %d \n", ixs, ixss, SIGNAL_THRES_OVER_NEGATIV_2[channel-1], SIGNAL_THRES_LOW_NEGATIV_2[channel-1], SIGNAL_THRES_MDL_NEGATIV_2[channel-1], SIGNAL_THRES_UP_NEGATIV_2[channel-1]);
printf("1 : ixs %d ixss %d tpovl %d tpll %d tpml %d tpul %d \n", ixs, ixss, SIGNAL_THRES_OVER_POSITIV_LAST[channel-1], SIGNAL_THRES_LOW_POSITIV_LAST[channel-1], SIGNAL_THRES_MDL_POSITIV_LAST[channel-1], SIGNAL_THRES_UP_POSITIV_LAST[channel-1]);
printf("1 : ixs %d ixss %d tnovl %d tnll %d tnml %d tnul %d \n", ixs, ixss, SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1], SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1], SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1], SIGNAL_THRES_UP_NEGATIV_LAST[channel-1]);
*/


		}	//BF end if QM-channel
	}	//BF end channel 1 - 5

       
		
	//-------------------------------------------------------
	//	prepare screen output 
	//-------------------------------------------------------
	QM_V_A_Buf[0] = 0;
	QM_H_A_Buf[0] = 0;

	if (QM_Type[0] > 0)
	{
		BufVal = Measure(0, (char) QM_Channel[0], (char) QM_Type[0], &BufPre[0], &BufUnit[0], &BufReturn[0], &QM_V_A_Buf[0], &QM_H_A_Buf[0]);
	
		QM_Slot1.Write_Value(BufVal);
		QM_Slot1.Write_Unit(BufUnit);
		QM_Slot1.Write_PreText(BufPre);
	
		QM_Slot1.RenderText();
	
		QM_Changed[0] = 1;
	}

	if (QM_Type[1] > 0)
	{
		BufVal = Measure(1, (char) QM_Channel[1], (char) QM_Type[1], &BufPre[0], &BufUnit[0], &BufReturn[0], &QM_V_A_Buf[0], &QM_H_A_Buf[0]);
	
		QM_Slot2.Write_Value(BufVal);
		QM_Slot2.Write_Unit(BufUnit);
		QM_Slot2.Write_PreText(BufPre);
	
		QM_Slot2.RenderText();
	
		QM_Changed[1] = 1;
	}

	if (QM_Type[2] > 0)
	{
		BufVal = Measure(2, (char) QM_Channel[2], (char) QM_Type[2], &BufPre[0], &BufUnit[0], &BufReturn[0], &QM_V_A_Buf[0], &QM_H_A_Buf[0]);
	
		QM_Slot3.Write_Value(BufVal);
		QM_Slot3.Write_Unit(BufUnit);
		QM_Slot3.Write_PreText(BufPre);
	
		QM_Slot3.RenderText();
	
		QM_Changed[2] = 1;
	}

	QM_Vertical_Active = QM_V_A_Buf[0];
	QM_Horizontal_Active = QM_H_A_Buf[0];
	
	DRAW_ALL_CURSOR();
	DrawQMData(1);

 
}
//##########################################################################################################################################################
// BF -> Measure changed by Stefan due to the changes in QM
float Display::Measure(char nr, char channel, char type, char *pretext, char *unittext, char *returntext, char *qm_vertical_active, char *qm_horizontal_active)
{
	float return_val = 0;
	int ixs, cnt, zero_buf = 0, off_buf = 0;

	char buf_text[30];
	char selectedVoltage=0,selectedVoltageSecondChannel=0;
	short s_max = 0;
	short s_mdl = 0;	
	short s_min = 0;
	short s_max_raw = 0;
	short s_mdl_raw = 0;	
	short s_min_raw = 0;	
	short s_top = 0;	
	short s_base = 0;

	short s_avg = 0;
	short s_avg_cnt = 0;
	
	short s_sec_mdl = 0;
	short s_sec_mdl_raw = 0;	
	
	short s_thres_up_negativ_1 = 0;
	short s_thres_up_positiv_1 = 0;

	short s_thres_low_negativ_1 = 0;
	short s_thres_low_positiv_1 = 0;

	short s_thres_mdl_negativ_1 = 0;
	short s_thres_mdl_positiv_1 = 0;

	short s_thres_mdl_negativ_2 = 0;
	short s_thres_mdl_positiv_2 = 0;

	short s_thres_mdl_negativ_last = 0;
	short s_thres_mdl_positiv_last = 0;	
    	
	short s_thres_sec_mdl_negativ_1 = 0;
	short s_thres_sec_mdl_positiv_1 = 0;

	short s_thres_sec_mdl_negativ_2 = 0;
	short s_thres_sec_mdl_positiv_2 = 0;	
	
   	
	short P1 = 0;
	short P2 = 0;
	short P3 = 0;
	short PBuf = 0;
	
	if (draw_factor==0)
		return 0;
	
	ixs = draw_start;  //BF #009 MemWinStart+Trigger_Offset_Calc;//left edge in mem


	switch(QM_Second_Channel[nr])	// nr -> QM slot
	{
		case 1:
			selectedVoltageSecondChannel = Selected_Voltage_CH1;
			break;
		case 2:
			selectedVoltageSecondChannel = Selected_Voltage_CH2;
			break;
		case 3:
			selectedVoltageSecondChannel = Selected_Voltage_CH3;
			break;
		case 4:
			selectedVoltageSecondChannel = Selected_Voltage_CH4;
			break;
		case 5:
			selectedVoltageSecondChannel = math_scale;
			break;
		
	}
	// Prepare for delay or phase measurment
	if ((type == 2) || (type == 10))
	{
		s_thres_sec_mdl_negativ_1 = (SIGNAL_THRES_MDL_NEGATIV_1[QM_Second_Channel[nr]-1]-ixs)/draw_factor;
		s_thres_sec_mdl_positiv_1 = (SIGNAL_THRES_MDL_POSITIV_1[QM_Second_Channel[nr]-1]-ixs)/draw_factor;
		s_thres_sec_mdl_negativ_2 = (SIGNAL_THRES_MDL_NEGATIV_2[QM_Second_Channel[nr]-1]-ixs)/draw_factor;
		s_thres_sec_mdl_positiv_2 = (SIGNAL_THRES_MDL_POSITIV_2[QM_Second_Channel[nr]-1]-ixs)/draw_factor;

		s_sec_mdl = (int)((float)(SIGNAL_MDL[QM_Second_Channel[nr]-1]-ADC_ZERO)*ScaleFactor[selectedVoltageSecondChannel][GainIdx])+GRID_HEIGHT/2;
		s_sec_mdl_raw = SIGNAL_MDL[QM_Second_Channel[nr]-1];

		if (QM_Second_Channel[nr] == 5)	// offset correction for math channel
		{ s_sec_mdl -= Math_Offset; }
	}	
		
	switch(channel)
	{
		case 1:
			selectedVoltage=Selected_Voltage_CH1;
			zero_buf=ZeroLevelCH1;
			break;
		case 2:
			selectedVoltage=Selected_Voltage_CH2;
			zero_buf=ZeroLevelCH2;
			break;
		case 3:
			selectedVoltage=Selected_Voltage_CH3;
			zero_buf=ZeroLevelCH3;
			break;
		case 4:
			selectedVoltage=Selected_Voltage_CH4;
			zero_buf=ZeroLevelCH4;
			break;
		case 5:
			selectedVoltage=math_scale;
			zero_buf=((GRID_HEIGHT/2) - Math_Offset);
			break;
	}

	s_max = (int)((float)(SIGNAL_MAX[channel-1]-ADC_ZERO)*ScaleFactor[selectedVoltage][GainIdx])+(GRID_HEIGHT/2);
	s_mdl = (int)((float)(SIGNAL_MDL[channel-1]-ADC_ZERO)*ScaleFactor[selectedVoltage][GainIdx])+(GRID_HEIGHT/2);;
	s_min = (int)((float)(SIGNAL_MIN[channel-1]-ADC_ZERO)*ScaleFactor[selectedVoltage][GainIdx])+(GRID_HEIGHT/2);

	if (channel == 5)	// offset correction for math channel
	{
		s_max -= Math_Offset;
		s_mdl -= Math_Offset;
		s_min -= Math_Offset;
	}

	s_max_raw = SIGNAL_MAX[channel-1];
	s_mdl_raw = SIGNAL_MDL[channel-1];
	s_min_raw = SIGNAL_MIN[channel-1];
	
	s_top = (int)((float)(SIGNAL_TOP[channel-1]-ADC_ZERO )*ScaleFactor[selectedVoltage][GainIdx])+(GRID_HEIGHT/2);
	s_base = (int)((float)(SIGNAL_BASE[channel-1]-ADC_ZERO)*ScaleFactor[selectedVoltage][GainIdx])+(GRID_HEIGHT/2);

	s_avg = SIGNAL_AVG[channel-1];
	s_avg_cnt = SIGNAL_AVG_CNT[channel-1];



	//BF speed up the calculation by different cases
	if (draw_factor == 1)
	{
		s_thres_up_negativ_1 = (SIGNAL_THRES_UP_NEGATIV_1[channel-1]-ixs);
		s_thres_up_positiv_1 = (SIGNAL_THRES_UP_POSITIV_1[channel-1]-ixs);
		
		s_thres_low_negativ_1 = (SIGNAL_THRES_LOW_NEGATIV_1[channel-1]-ixs);
		s_thres_low_positiv_1 = (SIGNAL_THRES_LOW_POSITIV_1[channel-1]-ixs);
		
		s_thres_mdl_negativ_1 = (SIGNAL_THRES_MDL_NEGATIV_1[channel-1]-ixs);
		s_thres_mdl_positiv_1 = (SIGNAL_THRES_MDL_POSITIV_1[channel-1]-ixs);
		
		s_thres_mdl_negativ_2 = (SIGNAL_THRES_MDL_NEGATIV_2[channel-1]-ixs);
		s_thres_mdl_positiv_2 = (SIGNAL_THRES_MDL_POSITIV_2[channel-1]-ixs);
		
		s_thres_mdl_negativ_last = (SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1]-ixs);
		s_thres_mdl_positiv_last = (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1]-ixs);
	}

	else if (draw_factor == 2)
	{
		s_thres_up_negativ_1 = (SIGNAL_THRES_UP_NEGATIV_1[channel-1]-ixs)>>1;
		s_thres_up_positiv_1 = (SIGNAL_THRES_UP_POSITIV_1[channel-1]-ixs)>>1;
		
		s_thres_low_negativ_1 = (SIGNAL_THRES_LOW_NEGATIV_1[channel-1]-ixs)>>1;
		s_thres_low_positiv_1 = (SIGNAL_THRES_LOW_POSITIV_1[channel-1]-ixs)>>1;
		
		s_thres_mdl_negativ_1 = (SIGNAL_THRES_MDL_NEGATIV_1[channel-1]-ixs)>>1;
		s_thres_mdl_positiv_1 = (SIGNAL_THRES_MDL_POSITIV_1[channel-1]-ixs)>>1;
		
		s_thres_mdl_negativ_2 = (SIGNAL_THRES_MDL_NEGATIV_2[channel-1]-ixs)>>1;
		s_thres_mdl_positiv_2 = (SIGNAL_THRES_MDL_POSITIV_2[channel-1]-ixs)>>1;
		
		s_thres_mdl_negativ_last = (SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1]-ixs)>>1;
		s_thres_mdl_positiv_last = (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1]-ixs)>>1;
	}

	else if (draw_factor == 4)
	{
		s_thres_up_negativ_1 = (SIGNAL_THRES_UP_NEGATIV_1[channel-1]-ixs)>>2;
		s_thres_up_positiv_1 = (SIGNAL_THRES_UP_POSITIV_1[channel-1]-ixs)>>2;
		
		s_thres_low_negativ_1 = (SIGNAL_THRES_LOW_NEGATIV_1[channel-1]-ixs)>>2;
		s_thres_low_positiv_1 = (SIGNAL_THRES_LOW_POSITIV_1[channel-1]-ixs)>>2;
		
		s_thres_mdl_negativ_1 = (SIGNAL_THRES_MDL_NEGATIV_1[channel-1]-ixs)>>2;
		s_thres_mdl_positiv_1 = (SIGNAL_THRES_MDL_POSITIV_1[channel-1]-ixs)>>2;
		
		s_thres_mdl_negativ_2 = (SIGNAL_THRES_MDL_NEGATIV_2[channel-1]-ixs)>>2;
		s_thres_mdl_positiv_2 = (SIGNAL_THRES_MDL_POSITIV_2[channel-1]-ixs)>>2;
		
		s_thres_mdl_negativ_last = (SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1]-ixs)>>2;
		s_thres_mdl_positiv_last = (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1]-ixs)>>2;
	}

	else
	{
		s_thres_up_negativ_1 = (SIGNAL_THRES_UP_NEGATIV_1[channel-1]-ixs)/draw_factor;
		s_thres_up_positiv_1 = (SIGNAL_THRES_UP_POSITIV_1[channel-1]-ixs)/draw_factor;
		
		s_thres_low_negativ_1 = (SIGNAL_THRES_LOW_NEGATIV_1[channel-1]-ixs)/draw_factor;
		s_thres_low_positiv_1 = (SIGNAL_THRES_LOW_POSITIV_1[channel-1]-ixs)/draw_factor;
		
		s_thres_mdl_negativ_1 = (SIGNAL_THRES_MDL_NEGATIV_1[channel-1]-ixs)/draw_factor;
		s_thres_mdl_positiv_1 = (SIGNAL_THRES_MDL_POSITIV_1[channel-1]-ixs)/draw_factor;
		
		s_thres_mdl_negativ_2 = (SIGNAL_THRES_MDL_NEGATIV_2[channel-1]-ixs)/draw_factor;
		s_thres_mdl_positiv_2 = (SIGNAL_THRES_MDL_POSITIV_2[channel-1]-ixs)/draw_factor;
		
		s_thres_mdl_negativ_last = (SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1]-ixs)/draw_factor;
		s_thres_mdl_positiv_last = (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1]-ixs)/draw_factor;
	}





	switch(type)
	{
		case 1:    // Average
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_mdl_negativ_last;
		
			QM_Horizontal_Position_Real1 = int (float (s_avg) / float (s_avg_cnt)) + s_mdl;
		
			//return_val = MEASUREVOLTAGE(channel, (int) (zero_buf - QM_Horizontal_Position_Real1), unittext);
			return_val = MEASUREVOLTAGE(channel, (int) (zero_buf - QM_Horizontal_Position_Real1));
			sprintf(unittext, "V");
		
			qm_horizontal_active[0] = 5;
			qm_vertical_active[0] = 3;
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Average [ = "); break;
				case 2 : sprintf(pretext, "Average \\ = "); break;
				case 3 : sprintf(pretext, "Average ] = "); break;
				case 4 : sprintf(pretext, "Average ^ = "); break;
				case 5 : sprintf(pretext, "Average (M) = "); break;
			}
		
			break;
		}

		case 2:  // Delay - Done
		{
			QM_Horizontal_Position_Real1 = s_mdl;
			QM_Horizontal_Position_Real2 = s_sec_mdl;
		
			if ((QM_CHI_Edge[nr] == 1) && (QM_CHII_Edge[nr] == 1))
			{
				QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
				QM_Vertical_Position_Real2 = s_thres_sec_mdl_positiv_1;
			}
			else if ((QM_CHI_Edge[nr] == 1) && (QM_CHII_Edge[nr] == 2))
			{
				QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
				QM_Vertical_Position_Real2 = s_thres_sec_mdl_negativ_1;
			}
			else if ((QM_CHI_Edge[nr] == 2) && (QM_CHII_Edge[nr] == 1))
			{
				QM_Vertical_Position_Real1 = s_thres_mdl_negativ_1;
				QM_Vertical_Position_Real2 = s_thres_sec_mdl_positiv_1;
			}
			else if ((QM_CHI_Edge[nr] == 2) && (QM_CHII_Edge[nr] == 2))
			{
				QM_Vertical_Position_Real1 = s_thres_mdl_negativ_1;
				QM_Vertical_Position_Real2 = s_thres_sec_mdl_negativ_1;
			}
		
			//return_val = MEASURETIME(1, (int) (QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1), unittext);
			return_val = MEASURETIME(1, (int) (QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1));
			sprintf(unittext, "s");
		
			qm_horizontal_active[0] = 3;
			qm_vertical_active[0] = 3;
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Delay [ = "); break;
				case 2 : sprintf(pretext, "Delay \\ = "); break;
				case 3 : sprintf(pretext, "Delay ] = "); break;
				case 4 : sprintf(pretext, "Delay ^ = "); break;
				case 5 : sprintf(pretext, "Delay (M) = "); break;
			}
		
			break;
		}

		case 3:  // Duty Cycle - Done
		{
			QM_Horizontal_Position_Real1 = s_mdl;
		
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
		
			qm_horizontal_active[0] = 5;
			qm_vertical_active[0] = 3;
		
			if (s_thres_mdl_negativ_1 > s_thres_mdl_positiv_1) return_val = (100 / (float (s_thres_mdl_positiv_2) - float (s_thres_mdl_positiv_1))) * (float (s_thres_mdl_negativ_1) - float (s_thres_mdl_positiv_1));
			else return_val = (100 / (float (s_thres_mdl_positiv_2) - float (s_thres_mdl_positiv_1))) * (float (s_thres_mdl_negativ_2) - float (s_thres_mdl_positiv_1));
		
			sprintf(unittext, "%%");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "DutyCycle [ = "); break;
				case 2 : sprintf(pretext, "DutyCycle \\ = "); break;
				case 3 : sprintf(pretext, "DutyCycle ] = "); break;
				case 4 : sprintf(pretext, "DutyCycle ^ = "); break;
				case 5 : sprintf(pretext, "DutyCycle (M) = "); break;
			}
	
			break;
		}

		case 4:  // Fall Time - Done
		{
			QM_Vertical_Position_Real1 = s_thres_up_negativ_1;
			QM_Vertical_Position_Real2 = s_thres_low_negativ_1;
		
			qm_horizontal_active[0] = 0;
			qm_vertical_active[0] = 3;
		
			//return_val = MEASURETIME(1, (int) abs(s_thres_low_negativ_1 - s_thres_up_negativ_1), unittext);
			return_val = MEASURETIME(1, (int) abs(s_thres_low_negativ_1 - s_thres_up_negativ_1));
			sprintf(unittext, "s");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "FallTime [ = "); break;
				case 2 : sprintf(pretext, "FallTime \\ = "); break;
				case 3 : sprintf(pretext, "FallTime ] = "); break;
				case 4 : sprintf(pretext, "FallTime ^ = "); break;
				case 5 : sprintf(pretext, "FallTime (M) = "); break;
			}
		
			break;
		}

		case 5:  // Frequency - Done
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
		
			qm_horizontal_active[0] = 0;
			qm_vertical_active[0] = 3;
		
			//return_val = MEASURETIME(2, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1), unittext);
			return_val = MEASURETIME(2, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1));
			sprintf(unittext, "Hz");
		
			int temp = (int) return_val * 100;
			sprintf(buf_text, "=%d.%2d", temp/100, temp%100);
		
			if (buf_text[0] == 'I') return_val = 0.0;
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Freq [ = "); break;
				case 2 : sprintf(pretext, "Freq \\ = "); break;
				case 3 : sprintf(pretext, "Freq ] = "); break;
				case 4 : sprintf(pretext, "Freq ^ = "); break;
				case 5 : sprintf(pretext, "Freq (M) = "); break;
			}
		
			break;
		}

		case 6:   // Maximum - Done
		{
			QM_Horizontal_Position_Real1 = s_max;
			QM_Horizontal_Position_Real2 = s_min;
		
			qm_horizontal_active[0] = 5;
			qm_vertical_active[0] = 0;
		
			//return_val = MEASUREVOLTAGE(channel, (int) abs(s_max - zero_buf), unittext);
			return_val = MEASUREVOLTAGE(channel, (int) abs(s_max - zero_buf));
		
			sprintf(unittext, "V");
		
			if (s_max > zero_buf) return_val = 0 - return_val;         // Verbesserbar. - Werte direkt verarbeiten
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Max [ = "); break;
				case 2 : sprintf(pretext, "Max \\ = "); break;
				case 3 : sprintf(pretext, "Max ] = "); break;
				case 4 : sprintf(pretext, "Max ^ = "); break;
				case 5 : sprintf(pretext, "Max (M) = "); break;
			}
			break;
		}

		case 7:  // Minimum - Done
		{
			QM_Horizontal_Position_Real1 = s_max;
			QM_Horizontal_Position_Real2 = s_min;
		
			qm_horizontal_active[0] = 6;
			qm_vertical_active[0] = 0;
		
			//return_val = MEASUREVOLTAGE(channel, (int) abs(s_min - zero_buf), unittext);
			return_val = MEASUREVOLTAGE(channel, (int) abs(s_min - zero_buf));
		
			sprintf(unittext, "V");
		
			if (s_min > zero_buf) return_val = 0 - return_val;          // Verbesserbar. - Werte direkt verarbeiten
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Min [ = "); break;
				case 2 : sprintf(pretext, "Min \\ = "); break;
				case 3 : sprintf(pretext, "Min ] = "); break;
				case 4 : sprintf(pretext, "Min ^ = "); break;
				case 5 : sprintf(pretext, "Min (M) = "); break;
			}
		
			break;
		}

		case 8:   // Peak-Peak - Done
		{
			QM_Horizontal_Position_Real1 = s_max;
			QM_Horizontal_Position_Real2 = s_min;
		
			qm_horizontal_active[0] = 3;
			qm_vertical_active[0] = 0;
		
			//return_val = MEASUREVOLTAGE(channel, (int) (s_min - s_max), unittext);
			return_val = MEASUREVOLTAGE(channel, (int) (s_min - s_max));
			sprintf(unittext, "V");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Pk-Pk [ = "); break;
				case 2 : sprintf(pretext, "Pk-Pk \\ = "); break;
				case 3 : sprintf(pretext, "Pk-Pk ] = "); break;
				case 4 : sprintf(pretext, "Pk-Pk ^ = "); break;
				case 5 : sprintf(pretext, "Pk-Pk (M) = "); break;
			}
		
			break;
		}

		case 9:   // Period - Done
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
		
			qm_horizontal_active[0] = 0;
			qm_vertical_active[0] = 3;
		
			//return_val = MEASURETIME(1, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1), unittext);
			return_val = MEASURETIME(1, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1));
			sprintf(unittext, "s");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Period [ = "); break;
				case 2 : sprintf(pretext, "Period \\ = "); break;
				case 3 : sprintf(pretext, "Period ] = "); break;
				case 4 : sprintf(pretext, "Period ^ = "); break;
				case 5 : sprintf(pretext, "Period (M) = "); break;
			}
		
			break;
		}

		case 10:  // Phase - Done
		{
			QM_Horizontal_Position_Real1 = s_mdl;
			QM_Horizontal_Position_Real2 = s_sec_mdl;

			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_sec_mdl_positiv_1;
		
			return_val = ((float) (s_thres_sec_mdl_positiv_1 - s_thres_mdl_positiv_1) / (float) (s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1)) * 360;
		
			qm_horizontal_active[0] = 3;
			qm_vertical_active[0] = 3;
		
			sprintf(unittext, "Deg");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "Phase [ = "); break;
				case 2 : sprintf(pretext, "Phase \\ = "); break;
				case 3 : sprintf(pretext, "Phase ] = "); break;
				case 4 : sprintf(pretext, "Phase ^ = "); break;
				case 5 : sprintf(pretext, "Phase (M) = "); break;
			}
		
			break;
		}

		case 11:  // Rise Time - Done
		{
			QM_Vertical_Position_Real1 = s_thres_low_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_up_positiv_1;
		
			qm_horizontal_active[0] = 0;
			qm_vertical_active[0] = 3;
		
			//return_val = MEASURETIME(1, (int) abs(s_thres_up_positiv_1 - s_thres_low_positiv_1), unittext);
			return_val = MEASURETIME(1, (int) abs(s_thres_up_positiv_1 - s_thres_low_positiv_1));
			sprintf(unittext, "s");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "RiseTime [ = "); break;
				case 2 : sprintf(pretext, "RiseTime \\ = "); break;
				case 3 : sprintf(pretext, "RiseTime ] = "); break;
				case 4 : sprintf(pretext, "RiseTime ^ = "); break;
				case 5 : sprintf(pretext, "RiseTime (M) = "); break;
			}
		
			break;
		}

		case 12:  // RMS -> BF new calculation #014 
		{
			// BF RMS calculation with 1.414 is valid only for sinusoid  signals! Calculation must be:
			// sum squared values -> calculate the mean -> calculate the square root => result is the Root Mean Square
			int square=0, value=0, rms=0, n, i, lVirtualZero=0, sum=0;
			unsigned char *lp_SIGNAL = NULL;	//pointer to signals
			char lVoltageRange=0;
			int lScaleIndex;
			//int IndexArray[256];	//BF optimized RMS calculation #025

			// point to the valid signal and get responding settings
			switch(channel)
			{
				case 1 : {lp_SIGNAL = &SIGNAL1[0]; lVirtualZero = Virtual_ZeroLevelCH1; lVoltageRange = Selected_Voltage_CH1;} break;
				case 2 : {lp_SIGNAL = &SIGNAL2[0]; lVirtualZero = Virtual_ZeroLevelCH2; lVoltageRange = Selected_Voltage_CH2;} break;
				case 3 : {lp_SIGNAL = &SIGNAL3[0]; lVirtualZero = Virtual_ZeroLevelCH3;  lVoltageRange = Selected_Voltage_CH3;} break;
				case 4 : {lp_SIGNAL = &SIGNAL4[0]; lVirtualZero = Virtual_ZeroLevelCH4; lVoltageRange = Selected_Voltage_CH4;} break;
				case 5 : {lp_SIGNAL = &SIGNALM[0]; lVirtualZero = math_scale; lVoltageRange = (char)math_scale;} break;	
			}

			lScaleIndex = ScaleIndexTable[lVoltageRange];

			//no period found? -> set cursors to beginning of displayed signal with an interval of 50 points
			if(SIGNAL_THRES_MDL_POSITIV_1[channel-1] < 0 || SIGNAL_THRES_MDL_POSITIV_2[channel-1] < 0 )
			{ 
				SIGNAL_THRES_MDL_POSITIV_1[channel-1] = (short)draw_start;
				SIGNAL_THRES_MDL_POSITIV_2[channel-1] = (short)(draw_start + (50 * draw_factor));

				s_thres_mdl_positiv_1 = (SIGNAL_THRES_MDL_POSITIV_1[channel-1]-ixs)/draw_factor;
				s_thres_mdl_positiv_2 = (SIGNAL_THRES_MDL_POSITIV_2[channel-1]-ixs)/draw_factor;
			}
			
			//set cursor position from period begin to period end
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
		
			qm_horizontal_active[0] = 0;	//switch off horizontal cursors
			qm_vertical_active[0] = 3;	//switch on vertical cursors


			//+++++++++++++++++++++++++++++
			//calculate RMS
			//+++++++++++++++++++++++++++++

			// 1. sum up squared values
			for(n=0, i=SIGNAL_THRES_MDL_POSITIV_1[channel-1];i<=SIGNAL_THRES_MDL_POSITIV_2[channel-1];n++, i+=draw_factor)
			{
/*				value = (int)(lp_SIGNAL[i] - ADC_ZERO);				//convert to signed integer 
				value = (int)(value * scale_factor[lVoltageRange][GainIdx]);	//scale -> can be done with shift operation to speed up
				value -= lVirtualZero;						//zero correction
*/				

				value = (int)ScaleLookupTable[lp_SIGNAL[i]][lScaleIndex] - lVirtualZero;	//new lookup table calculation

				square += (value * value);					//square and sum
//printf("ADC value #%d = %d \r\n",n,adc_value);
			}

			// 2. calculate mean
			square /= n;
//printf("mean square = %d \r\n",square);
			// 3. square root
			//rms = Signal::iSqrt(square);
			rms = Math_Sqrt(square);

//printf("rms         = %d \r\n",rms);
//printf("********************************\r\n");


/*BF new calculation from ROWUE start*/
/*			for (i=0;i<256;i++)
			IndexArray[i] = 0;


			// 1. sum up indexed values
			for(n=0, i=SIGNAL_THRES_MDL_POSITIV_1[channel-1];i<=SIGNAL_THRES_MDL_POSITIV_2[channel-1];n++, i+=draw_factor)
			{ IndexArray[lp_SIGNAL[i]]++; }

			// 2. square converted index and sum up
			for (i=0; i<256; i++)
			{
				value = (i - ADC_ZERO);						//convert index to signed integer 
				value = (int)(value * scale_factor[lVoltageRange][GainIdx]);	//scale -> can be done with shift operation to speed up
				value -= lVirtualZero;						//zero correction
				square += (value * value) * IndexArray[i];			//square and sum -> index² * sum of indexed values
			}
			
			// 2. calculate mean
			square /= 256;	//BF???   faster may be square *= 0.0039062  (1/256)
//printf("mean square = %d \r\n",square);

			// 3. square root
			rms = Signal::iSqrt(square);
//printf("rms         = %d \r\n",rms);
//printf("********************************\r\n");
*/
/*BF new calculation from ROWUE end*/


			return_val = MEASUREVOLTAGE(channel, rms);
			sprintf(unittext, "V");

			switch(channel)
			{
				case 1 : sprintf(pretext, "RMS [ = "); break;
				case 2 : sprintf(pretext, "RMS \\ = "); break;
				case 3 : sprintf(pretext, "RMS ] = "); break;
				case 4 : sprintf(pretext, "RMS ^ = "); break;
				case 5 : sprintf(pretext, "RMS (M) = "); break;
			}
		
			break;
		}

		case 13:  // + Width - Done
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			if (s_thres_mdl_positiv_1 < s_thres_mdl_negativ_1) QM_Vertical_Position_Real2 = s_thres_mdl_negativ_1;
			else QM_Vertical_Position_Real2 = s_thres_mdl_negativ_2;
		
			qm_horizontal_active[0] = 0;
			qm_vertical_active[0] = 3;
		
			//return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - s_thres_mdl_positiv_1), unittext);
			return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - s_thres_mdl_positiv_1));
			sprintf(unittext, "s");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "+Width [ = "); break;
				case 2 : sprintf(pretext, "+Width \\ = "); break;
				case 3 : sprintf(pretext, "+Width ] = "); break;
				case 4 : sprintf(pretext, "+Width ^ = "); break;
				case 5 : sprintf(pretext, "+Width (M) = "); break;
			}
		
			break;
		}

		case 14:  // - Width - Done
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_negativ_1;
			if (s_thres_mdl_negativ_1 < s_thres_mdl_positiv_1) QM_Vertical_Position_Real2 = s_thres_mdl_positiv_1;
			else QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
		
			qm_horizontal_active[0] = 0;
			qm_vertical_active[0] = 3;
		
			//return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1), unittext);
			return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1));
			sprintf(unittext, "s");
		
			switch(channel)
			{
				case 1 : sprintf(pretext, "-Width [ = "); break;
				case 2 : sprintf(pretext, "-Width \\ = "); break;
				case 3 : sprintf(pretext, "-Width ] = "); break;
				case 4 : sprintf(pretext, "-Width ^ = "); break;
				case 5 : sprintf(pretext, "-Width (M) = "); break;
			}
			break;
		}
	}
	return return_val;
}
//##########################################################################################################################################################

//float Display::MEASUREVOLTAGE(char channel, int points, char *UnitString)			// Calculate the Voltage String
float Display::MEASUREVOLTAGE(char channel, int points)						// Calculate the Voltage String
{
	short fprobe = 0;
	short funits = 0;	
	char fselected_voltage = 0;	
	
	char dim = 2;
	
	int cmpvar = 0;
	
	float sfactor = 0;
	float ffactor = 0;	
	float result = 0;	
	
	float floattempad;
	int inttempbd;
	int inttempad;
			
	int xe;
	
//printf("Display::MEASUREVOLTAGE(char channel, int points)\r\n");

	switch (channel)
	{
		case 1:
		{
			fprobe = MenuStatus[1][3];
			fselected_voltage = Selected_Voltage_CH1;
			break;
		}	
		case 2:
		{
			fprobe = MenuStatus[2][3];
			fselected_voltage = Selected_Voltage_CH2;
			break;
		}
		case 3:
		{
			fprobe = MenuStatus[3][3];
			fselected_voltage = Selected_Voltage_CH3;
			break;
		}
		case 4:
		{
			fprobe = MenuStatus[4][3];
			fselected_voltage = Selected_Voltage_CH4;
			break;
		}		
		case 5:
		{
			fprobe = 104;	// factor 1
			fselected_voltage = math_scale;
			break;
		}		
	}

	sfactor = VoltFactor[fselected_voltage];
/*
	switch (fselected_voltage)
	{
		case 0:
		{
			sfactor = 0.001;
			break;
		}
		case 1:
		{
			sfactor = 0.002;
			break;
		}
		case 2:
		{
			sfactor = 0.005;
			break;
		}
		case 3:
		{
			sfactor = 0.01;
			break;
		}
		case 4:
		{
			sfactor = 0.02;
			break;
		}
		case 5:
		{
			sfactor = 0.05;
			break;
		}
		case 6:
		{
			sfactor = 0.1;
			break;
		}
		case 7:
		{
			sfactor = 0.2;
			break;
		}
		case 8:
		{
			sfactor = 0.5;
			break;
		}
		case 9:
		{
			sfactor = 1;
			break;
		}
		case 10:
		{
			sfactor = 2;
			break;
		}
		case 11:
		{
			sfactor = 5;
			break;
		}		
		case 12:
		{
			sfactor = 10;
			break;
		}
		case 13:
		{
			sfactor = 20;
			break;
		}
		case 14:
		{
			sfactor = 50;
			break;
		}
		case 15:
		{
			sfactor = 100;
			break;
		}	
	}
*/	

	ffactor = VoltFactor[fprobe-95];

/*
	switch (fprobe)
	{
		case 101:
		{
			ffactor = 0.1;
			break;
		}
		case 102:
		{
			ffactor = 0.2;
			break;
		}
		case 103:
		{
			ffactor = 0.5;
			break;
		}
		case 104:
		{
			ffactor = 1;
			break;
		}
		case 105:
		{
			ffactor = 2;
			break;
		}
		case 106:
		{
			ffactor = 5;
			break;
		}
		case 107:
		{
			ffactor = 10;
			break;
		}
		case 108:
		{
			ffactor = 20;
			break;
		}
		case 109:
		{
			ffactor = 50;
			break;
		}
		case 110:
		{
			ffactor = 100;
			break;
		}
		case 111:
		{
			ffactor = 200;
			break;
		}
		case 112:
		{
			ffactor = 500;
			break;
		}
		case 113:
		{
			ffactor = 1000;
			break;
		}
	}
*/


	result = ((sfactor * ffactor) / 48) * points;	
	/*	
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result > 999)
	{
		result = result / 1000;
		dim++;
	}
	
	switch(dim)
	{
	   case 0 : sprintf(UnitString, "&V"); break;
	   case 1 : sprintf(UnitString, "mV"); break;
	   case 2 : sprintf(UnitString, "V"); break;
	   case 3 : sprintf(UnitString, "kV"); break;
    }
    */
    //sprintf(UnitString, "V");

#ifdef _Debug_QM_
    printf("MV dim %d  %s\n", dim, UnitString);
#endif

    return result;	
}
//##########################################################################################################################################################
// BF calculate time values
float Display::MEASURETIME(char sec_hz, int points)
{
	int time = 0;
	
	float tfactor = 0;
	float timeoff = 0;
	
	tfactor = TimeBaseFactor[MainTimebase+VirtualTimebase] / 1000000;	//BF 023
	
	timeoff = (float)(points) * tfactor;
	
	if (sec_hz != 1)
	{ timeoff = 1 / timeoff; }

    return timeoff;
}
//##########################################################################################################################################################

void Display::CALCTRIGGER(void)
{
	int volt = 0;		
	int voltmfactor = 0;
	
	int tpos = 0;
	double vfactor = 0;	
	double vfactor2 = 0;	
	float voltoff = 0;
			
	switch(Selected_Trigger_Source)
	{
		case 1:
		{	
			volt = Selected_Voltage_CH1;
			voltmfactor = MenuStatus[1][3];
			tpos = ZeroLevelCH1 - Trigger_Pos_CH1;
			break;
		}
		case 2:
		{				
			volt = Selected_Voltage_CH2;
			voltmfactor = MenuStatus[2][3];
			tpos = ZeroLevelCH2 - Trigger_Pos_CH2;
			break;
		}
		case 3:
		{				
			volt = Selected_Voltage_CH3;
			voltmfactor = MenuStatus[3][3];
			tpos = ZeroLevelCH3 - Trigger_Pos_CH3;
			break;
		}
		case 4:
		{				
			volt = Selected_Voltage_CH4;
			voltmfactor = MenuStatus[4][3];
			tpos = ZeroLevelCH4 - Trigger_Pos_CH4;
			break;
		}
		case 5:
		{				
			volt = 7;
			voltmfactor = MenuStatus[MENU_TRIGGERMODE][4];
			//BF del tpos = Trigger_Pos_CHE - 15;
			break;
		}		
	}
	
	
	if (Selected_Trigger_Source == 5)	//external triggerr
	{		
		switch(voltmfactor)
		{
			case 101: vfactor2 = 0.1; break;	
			case 102: vfactor2 = 0.2; break;
			case 103: vfactor2 = 0.5; break;
			case 104: vfactor2 = 1; break;
			case 105: vfactor2 = 2; break;
			case 106: vfactor2 = 5; break;
			case 107: vfactor2 = 10; break;
			case 108: vfactor2 = 20; break;
			case 109: vfactor2 = 50; break;
			case 110: vfactor2 = 100; break;
			case 111: vfactor2 = 200; break;
			case 112: vfactor2 = 500; break;
			case 113: vfactor2 = 1000; break;
		}
		
		voltoff = (Trigger_Pos_CHE * 0.1943 - 11.8523) * vfactor2;  // JK 5.9.11

		//voltoff = ExtTriggerDispl[Trigger_Pos_CHE] * vfactor2;
		
		Trigger_ExtLevel_Str.Write_Value(voltoff);	
		Trigger_ExtLevel_Str.RenderText();			
	}
	else
	{	  	
	
		if ((Selected_Trigger_Source != ct_Selected_Trigger_Source_buf) || (volt != ct_volt_buf) || (voltmfactor != ct_voltmfactor_buf))
		{	
			// Start calculate horizontal Data
						
			switch(volt)
			{
				case 0 : vfactor = 20.833333; break;
				case 1 : vfactor = 41.666666; break;
				case 2 : vfactor = 104.166666; break;
				case 3 : vfactor = 208.333333; break;
				case 4 : vfactor = 416.666666; break;
				case 5 : vfactor = 1041.666666; break;
				case 6 : vfactor = 2083.333333; break;
				case 7 : vfactor = 4166.666666; break;
				case 8 : vfactor = 10416.66666; break;
				case 9 : vfactor = 20833.33333; break;
				case 10 : vfactor = 41666.66666; break;
				case 11 : vfactor = 104166.6666; break;
			}
			
			vfactor = vfactor / 1000000;
				
			switch(voltmfactor)
			{
				case 101: vfactor2 = 0.1; break;	
				case 102: vfactor2 = 0.2; break;
				case 103: vfactor2 = 0.5; break;
				case 104: vfactor2 = 1; break;
				case 105: vfactor2 = 2; break;
				case 106: vfactor2 = 5; break;
				case 107: vfactor2 = 10; break;
				case 108: vfactor2 = 20; break;
				case 109: vfactor2 = 50; break;
				case 110: vfactor2 = 100; break;
				case 111: vfactor2 = 200; break;
				case 112: vfactor2 = 500; break;
				case 113: vfactor2 = 1000; break;
			}	
		
			ct_Selected_Trigger_Source_buf = Selected_Trigger_Source;
			ct_volt_buf = volt;
			ct_voltmfactor_buf = voltmfactor;
			ct_vfactor_buf = vfactor;
			ct_vfactor2_buf = vfactor2;			
		}
		else
		{
			vfactor = ct_vfactor_buf;
			vfactor2 = ct_vfactor2_buf;
		}

		voltoff = (float)(tpos) * vfactor;
		voltoff = voltoff * vfactor2;
	
		Trigger_Level_Str.Write_Value(voltoff);	
		Trigger_Level_Str.RenderText();	
   	}	
}
//##########################################################################################################################################################
// BF fixed wrong pre trigger calculation. Calculation and timebase table changed.
// BF -> changed to indexed array fetch!!
void Display::CALCPRETRIGGER(void)
{
	//float timeoff;

	PreTrigger = (float)((float)(Trig_Pos_Mem - MemStartOffs) / (float)SampleRate[MainTimebase]);
	Trigger_Offset_Str.Write_Value(PreTrigger);
	Trigger_Offset_Str.RenderText();

}
//##########################################################################################################################################################
// BF -> changed to indexed array fetch!!
/* -> not used
void Display::CALCTIMEBASE(void)
{
	int time = 0;
	
	float tfactor = 0;
	float timeoff = 0;
		
	tfactor = TimeBaseFactor[MainTimebase] / 1000000;
	
	timeoff = (float)(Timebase_Offset_Pos) * tfactor;  // Mitte ist 300
	
	Timebase_Offset_Str.Write_Value(timeoff);
	Timebase_Offset_Str.RenderText();
//BFTEST
/*
	printf("******************************************************************\r\n");
	printf("calculating timebase...\r\n");
	printf("timeoff = Timebase_Offset_Pos * tfactor  / 1000000\r\n\r\n");
	
	printf("Timeoffset          = "); floatprintf(timeoff); printf("\r\n");
	printf("Timebase_Offset_Pos = %d\r\n",Timebase_Offset_Pos);
	printf("tfactor             = "); floatprintf(tfactor); printf("\r\n");
	printf("******************************************************************\r\n");
*/
//}

//##########################################################################################################################################################

void Display::CALCVOLTAGE(char channel, char *String)				// Calculate the Voltage String
{
	short fprobe = 0;
	char fselected_voltage = 0;	
	char dim = 2;
	int cmpvar = 0;
	float sfactor = 0, ffactor = 0, result = 0;	
	float floattempad;
	int inttempbd, inttempad;
	
	char DimString[4];
	int xe;

	//BF set log dimension
	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	{
		sprintf(String, "10dBm/");
		return;
	}	

	switch (channel)
	{
		case 1:
		{
			fprobe = MenuStatus[1][3];
			fselected_voltage = Selected_Voltage_CH1;
			break;
		}	
		case 2:
		{
			fprobe = MenuStatus[2][3];
			fselected_voltage = Selected_Voltage_CH2;
			break;
		}
		case 3:
		{
			fprobe = MenuStatus[3][3];
			fselected_voltage = Selected_Voltage_CH3;
			break;
		}
		case 4:
		{
			fprobe = MenuStatus[4][3];
			fselected_voltage = Selected_Voltage_CH4;
			break;
		}
	}

	switch (fselected_voltage)
	{
		case 0:
		{ sfactor = 0.001; break; }
		case 1:
		{ sfactor = 0.002; break; }
		case 2:
		{ sfactor = 0.005; break; }
		case 3:
		{ sfactor = 0.01; break; }
		case 4:
		{ sfactor = 0.02; break; }
		case 5:
		{ sfactor = 0.05; break; }
		case 6:
		{ sfactor = 0.1; break; }
		case 7:
		{ sfactor = 0.2; break; }
		case 8:
		{ sfactor = 0.5; break; }
		case 9:
		{ sfactor = 1; break; }
		case 10:
		{ sfactor = 2; break; }
		case 11:
		{ sfactor = 5; break; }	
	}
	
	switch (fprobe)
	{
		case 101:
		{ ffactor = 0.1; break; }
		case 102:
		{ ffactor = 0.2; break; }
		case 103:
		{ ffactor = 0.5; break; }
		case 104:
		{ ffactor = 1; break; }
		case 105:
		{ ffactor = 2; break; }
		case 106:
		{ ffactor = 5; break; }
		case 107:
		{ ffactor = 10; break; }
		case 108:
		{ ffactor = 20; break; }
		case 109:
		{ ffactor = 50; break; }
		case 110:
		{ ffactor = 100; break; }
		case 111:
		{ ffactor = 200; break; }
		case 112:
		{ ffactor = 500; break; }
		case 113:
		{ ffactor = 1000; break; }
	}

	if(FFT_Mode != FFT_OFF )
	sfactor /= 2;

	result = sfactor * ffactor;	
		
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result > 500)
	{
		result = result / 1000;
		dim++;
	}

	//sprintf(DimString, "");
	for (xe = 0; xe < 3; xe++)
	{ DimString[xe] = VoltageData[dim][xe]; }

	DimString[3] = 0;	
	
	// copy float to integer
	cmpvar = (int) result;
	
	// compare if there is a after dot integer
	if ((float) cmpvar == result)
    	{ sprintf(String, "%3d %s", cmpvar, DimString); }
  /*	else if ((((float) cmpvar + 0) - result) < 0.0001)
    	{ sprintf(String, "%3d %s", cmpvar + 0, DimString); }    */
	else
	{
		inttempbd = (int) result;
		floattempad = result - (float) inttempbd;
		
		inttempad = (int) (floattempad * (float) 10);
		
		if (inttempad == 9)
		{
			inttempad = 0;
			inttempbd++;
		}
		
		sprintf(String, "%3d.%1d %s", inttempbd, inttempad, DimString);
	}	
}
//##########################################################################################################################################

void Display::RecalcTimeParameters(void)
{


	//------------------------------------------------------------
	//			Main TB
	//------------------------------------------------------------

	ZoomFactor_old = ZoomFactor;

	if (Run)
	{ 	ZoomFactor     = ZoomFactorTable[MainTimebase+VirtualTimebase]; }
	else														//BF #023 timebase logic for stop/recall/overlay
	{
		Timebase_Ratio = Timebase_Delayed_Factor_Table[MainTimebase] / Timebase_Delayed_Factor_Table[MainTimebase+VirtualTimebase];
		ZoomFactor     = ZoomFactorTable[MainTimebase] / Timebase_Ratio;
	}

	SignalMemSize = (int)(ZoomFactor * GRID_WIDTH);									// calculate the real length of the displayed signal in the memory #023

	if (MainTimebase < 26)	//-------------------------------------------------------				// normal timebase -> USTB off
	{
		if (MainTimebase < 11)											//memory length is 16K
		{
			MemStartOffs = 50;
			MemoryEnd    = 16280;
			TrigPosMax   = 16000;
		}
		else													//memory length is 4K
		{
			MemStartOffs = 25;
			MemoryEnd    = 4059;
			TrigPosMax   = 4000;
		}

		// adjust memory window and pretrigger
		if (ZoomFactor != ZoomFactor_old)
		{
			if (MenuStatus[MENU_TRIGGERSUB][4] == 277 || !Run)						//keep time value and let the memory window follow the pre trigger
			{
				Trig_Pos_Mem = (int)(PreTrigger * (float)SampleRate[MainTimebase]) + MemStartOffs;
			
				MemWinStart = Trig_Pos_Mem - (int)((float)Trig_Pos_Display * ZoomFactor);
		
				//printf("Trig_Pos_Mem = %d  MemWinStart = %d\r\n",Trig_Pos_Mem, MemWinStart);
			}
			else if (MenuStatus[MENU_TRIGGERSUB][4] == 276)							//keep time value
			{ 	Trig_Pos_Mem = (int)(PreTrigger * (float)SampleRate[MainTimebase]) + MemStartOffs; }
			else												//keep grid position
			{ 	Trig_Pos_Mem = (int)((float)Trig_Pos_Display * ZoomFactor) + MemWinStart; }		//hold screen position constant
		}
	
		//BF #023 limiter -> signal size in memory is zoom factor * grid width
		if ((MemWinStart + SignalMemSize) > MemoryEnd) { MemWinStart = MemoryEnd - SignalMemSize; }		// right edge limiter memory window	
		if (MemWinStart < MemStartOffs) { MemWinStart  = MemStartOffs; }					// left edge limiter memory window	
		if (Trig_Pos_Mem > TrigPosMax) { Trig_Pos_Mem = TrigPosMax; }						// right edge limiter trigger position
		if (Trig_Pos_Mem < MemStartOffs) { Trig_Pos_Mem = MemStartOffs; }					// left edge limiter trigger position

		// calculate drawing parameters
		if (((MainTimebase + VirtualTimebase) < 4) || FFT_Mode != FFT_OFF)					// 20ns + 10ns + 5ns + 2ns main mode - interpolated signal
		{
			draw_start = 0;
			draw_factor = 1;
		}
		else 													// >= 50ns main mode - true signal
		{
			draw_start = (short) MemWinStart + PreTrigComp;
			draw_factor = (short)ZoomFactor;
		}

	}
	else	//-------------------------------------------------------						// USTB
	{
		if(USTB_Mode == USTB_ROLL)										// roll mode
		{
			if (MenuStatus[MENU_USTB][2] == USTB_8KB)
			{ MemoryEnd = TrigPosMax = 8192; }
			else if (MenuStatus[MENU_USTB][2] == USTB_32KB)
			{ MemoryEnd = TrigPosMax = 32760; }
			else
			{ MemoryEnd = TrigPosMax = 16370; }								// 16KB as default
		}
		else													// shift mode
		{
			if (MenuStatus[MENU_USTB][2] == USTB_8KB)
			{ MemoryEnd = TrigPosMax = 8192; }
			else
			{ MemoryEnd = TrigPosMax = 16370; }								// 16KB as default
		}

		MemStartOffs = 10;

		draw_start = MemWinStart;
		draw_factor = 1;	//(short)ZoomFactor;
	}



	//------------------------------------------------------------
	//			Delayed TB
	//------------------------------------------------------------
	if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
	{
		Timebase_Ratio = Timebase_Delayed_Factor_Table[MainTimebase] / Timebase_Delayed_Factor_Table[MainTimebase - DelayedTimebase - 1];	//BF #003

		Cursor_Delayed_1 = ((GRID_WIDTH / 2) - (int) (((float) GRID_WIDTH / Timebase_Ratio) / 2)) + dmode_Window_Offset_Pos;			// calculate delayed window start

		if (Cursor_Delayed_1 < 0){ dmode_Window_Offset_Pos += (-1 * Cursor_Delayed_1);  Cursor_Delayed_1 = 0; }					// limiter

		Cursor_Delayed_2 = Cursor_Delayed_1 + (int) ((float) GRID_WIDTH / Timebase_Ratio);							// calculate delayed windows end

		if (Cursor_Delayed_2 > GRID_WIDTH)													// limiter
		{ Cursor_Delayed_1 -= (Cursor_Delayed_2 - GRID_WIDTH);
		  dmode_Window_Offset_Pos -= (Cursor_Delayed_2 - GRID_WIDTH);
		  Cursor_Delayed_2 = GRID_WIDTH; }			

		Cursor_Delayed_Size = Cursor_Delayed_2 - Cursor_Delayed_1;										// calculate delayed window width

		if (Timebase_Ratio > 0)
		ZoomFactorDel = ZoomFactor / Timebase_Ratio;
		else
		ZoomFactorDel = 0;

		// calculate drawing parameters
		if (ZoomFactorDel < 1) 											//20ns + 10ns delayed mode  - interpolated signal
		{
			draw_dm_ixstart  = 0;										// set to zero because whole interpolation buffer must be drawn
			draw_dm_ixfactor = (short) ZoomFactorDel;	
		}
		else													// >= 50ns delayed mode - true signal
		{
			draw_dm_ixstart  = MemWinStart + PreTrigComp + (short)((float)Cursor_Delayed_1 * ZoomFactor);	//BF #003
			draw_dm_ixfactor = (short) ZoomFactorDel;	
		}
	}
 

    	RecalcTriggerPos();
	//Hardware::SetupADC();
}
//##########################################################################################################################################
// calculate screen position of pretrigger and set pretrigger register
void Display::RecalcTriggerPos(void)
{
//    	printf("C1 pre : %x TPM : %d TMP : %d - %d\n\n", pre_reg, Trig_Pos_Mem, MemWinStart, Trig_Pos_Display);
    
	Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);
	Trig_Pos_Display_dmode = (int)((float)(Trig_Pos_Display - Cursor_Delayed_1) * Timebase_Ratio);

	if (MainTimebase < 11) pre_reg = (Trig_Pos_Mem >> 2) + PreReg_Offset;	// 16Kbyte
	else if (USTB_Mode != USTB_OFF) return;
	else pre_reg = (Trig_Pos_Mem) + PreReg_Offset;				//  4Kbyte

    	//printf("pre reg : %x MemWinStart : %d MemPos : %d GridPos : %d\n\r\n\r", pre_reg, MemWinStart, Trig_Pos_Mem, Trig_Pos_Display);
    
	if (pre_reg > 4096)
	{
	//BF del         Trig_Pos_Mem = GRID_WIDTH / 2;
	//BF del         MemWinStart = MemStartOffs;
   		printf("pre reg limit reached \n\r");

		MemWinStart = MemStartOffs;
		Trig_Pos_Mem = MemWinStart + (SignalMemSize/2);		//center trigger
	
		Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);
	
		if (MainTimebase < 11) pre_reg = (Trig_Pos_Mem >> 2) + PreReg_Offset;	// 16Kbyte
		else pre_reg = (Trig_Pos_Mem) + PreReg_Offset;				//  4Kbyte
	}
}
//##########################################################################################################################################################
// BF draw zero and trigger markers on left and right edge of screen
// BF changed -> new timer controlled triggerline
void Display::DRAWSIGNS(void)
{
	long Adr_Front_Old_1=0, Adr_Front_Old_2=0, Adr_Front_New_1, Adr_Front_New_2, Adr_Front_Old_3=0, Adr_Front_Old_4=0, Adr_Front_New_3, Adr_Front_New_4;
	long Adr_Back_Old_1, Adr_Back_Old_2, Adr_Back_New_1, Adr_Back_New_2, Adr_Back_Old_3, Adr_Back_Old_4, Adr_Back_New_3, Adr_Back_New_4;

//	long Adr_Front_New_1, Adr_Front_New_2, Adr_Front_New_3, Adr_Front_New_4;
//	long Adr_Back_New_1, Adr_Back_New_2, Adr_Back_New_3, Adr_Back_New_4;
	unsigned char *signbuff = 0;

	char lDraw,lCnt;			//BF new triggerline #026
	int lix,lTriggerPos,lTriggerPos_Old;	//BF new triggerline #026
	int lZeroLevel,lZeroLevel_Old;		//BF redesigned



	//if(USTB_Mode != USTB_OFF) return;

	if(FFT_Mode != FFT_OFF) return; 


	//-------------------------------------------------------------------------------------------------------------------------
	//                                                      Channel 1
	//-------------------------------------------------------------------------------------------------------------------------


	//---------------------------------------------------------------
	// Remove Channel 1 Zero and Trigger Signs
	//---------------------------------------------------------------
	if(VS_TrigLevelChanged == 1)
	{
			
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed mode
		{
			//remove delayed trigger sign 
			if (MenuStatus[MENU_CHANNEL1][2] == BTN_ON)	//Inverted Signal	BF
			{ lTriggerPos_Old = GRID_YOFFS + ((ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) >> 1) - 9; }
			else
			{ lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH1_Old >> 1) - 9; }
			
			Adr_Front_Old_1 = v_Channel_Plane1 + (lTriggerPos_Old * 80);
			Adr_Front_Old_2 = v_Buffer_Plane1 + (lTriggerPos_Old * 80);

			lTriggerPos_Old += (GRID_HEIGHT/2); 	//lower window

			Adr_Front_Old_3 = v_Channel_Plane1 + (lTriggerPos_Old * 80);
			Adr_Front_Old_4 = v_Buffer_Plane1 + (lTriggerPos_Old * 80);
		
			RemoveZeroSign(Adr_Front_Old_1);
			RemoveZeroSign(Adr_Front_Old_2);
			RemoveZeroSign(Adr_Front_Old_3);
			RemoveZeroSign(Adr_Front_Old_4);
		}
		else	//Main mode
		{
			//remove main trigger sign
			if (MenuStatus[MENU_CHANNEL1][2] == BTN_ON)	//Inverted Signal	BF
			{ lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) - 9;	}
			else
			{ lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH1_Old - 9; }
	
// limiter BF test #4711
			if (lTriggerPos_Old >= GRID_YOFFS)
			{
			Adr_Front_Old_1 = v_Channel_Plane1 + (lTriggerPos_Old * 80);
			Adr_Front_Old_2 = v_Buffer_Plane1 + (lTriggerPos_Old * 80);
	
			RemoveZeroSign(Adr_Front_Old_1);
			RemoveZeroSign(Adr_Front_Old_2);
			}
		}

	}

	if(VS_ZeroLevelChanged == 1)
	{
/*		// Remove Channel 1 Zero
		if (XY_Mode)	//Check XY-Mode
		{
			//DrawZeroSignXY(ZeroLevelCH1_Old, 0);
		}
		else
*/		{	
		
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed Mode
			{
				lZeroLevel_Old = (ZeroLevelCH1_Old >> 1) + GRID_YOFFS - 9;
	
				if (lZeroLevel_Old < 18) lZeroLevel_Old = 18; // avoid channel number overdrawing

				//remove delayed zero sign
				Adr_Front_Old_1 = v_Channel_Plane1 + (lZeroLevel_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane1 + (lZeroLevel_Old * 80);
				Adr_Back_Old_1 = v_Channel_Plane1 + (lZeroLevel_Old * 80);
				Adr_Back_Old_2 = v_Buffer_Plane1 + (lZeroLevel_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSignBack(Adr_Back_Old_1);
				RemoveZeroSignBack(Adr_Back_Old_2);

				lZeroLevel_Old += (GRID_HEIGHT/2); 	//lower window
			
				Adr_Front_Old_1 = v_Channel_Plane1 + (lZeroLevel_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane1 + (lZeroLevel_Old * 80);
				Adr_Back_Old_1 = v_Channel_Plane1 + (lZeroLevel_Old * 80);
				Adr_Back_Old_2 = v_Buffer_Plane1 + (lZeroLevel_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSignBack(Adr_Back_Old_1);
				RemoveZeroSignBack(Adr_Back_Old_2);	
			}
			else	//main mode
			{
				lZeroLevel_Old = ZeroLevelCH1_Old + GRID_YOFFS - 9;

				if (lZeroLevel_Old < 18) lZeroLevel_Old = 18;	// avoid channel number overdrawing

				//remove main zero sign
				Adr_Front_Old_1 = v_Channel_Plane1 + (lZeroLevel_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane1 + (lZeroLevel_Old * 80);
				Adr_Back_Old_1 = v_Channel_Plane1 + (lZeroLevel_Old * 80);
				Adr_Back_Old_2 = v_Buffer_Plane1 + (lZeroLevel_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSignBack(Adr_Back_Old_1);
				RemoveZeroSignBack(Adr_Back_Old_2);
			}

		}
	}


	//---------------------------------------------------------------
	// Draw Channel 1 Zero
	//---------------------------------------------------------------
/*
	//XY-Mode
	if ((Channel_1_Active) && (ZeroLevelCH1 > 0) && (ZeroLevelCH1 < 480) && (XY_Mode))
	{
		//DrawZeroSignXY(ZeroLevelCH1, 1);
		//ZeroLevelCH1_Old = ZeroLevelCH1;
	}
*/
	//Main + Delayed Mode
	if ((Channel_1_Active) && (ZeroLevelCH1 > 3) && (ZeroLevelCH1 <= GRID_HEIGHT) && (XY_Mode == false))	//level is in grid area
	{
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)													//Delayed Mode
		{
			lZeroLevel = (ZeroLevelCH1 >> 1) + GRID_YOFFS - 9;											//upper window

			Adr_Front_New_1 = v_Channel_Plane1 + (lZeroLevel * 80);
			Adr_Front_New_2 = v_Buffer_Plane1 + (lZeroLevel * 80);
			Adr_Back_New_1 = v_Channel_Plane1 + (lZeroLevel * 80);
			Adr_Back_New_2 = v_Buffer_Plane1 + (lZeroLevel * 80);
		
			lZeroLevel += (GRID_HEIGHT/2); 														//lower window

			Adr_Front_New_3 = v_Channel_Plane1 + (lZeroLevel * 80);
			Adr_Front_New_4 = v_Buffer_Plane1 + (lZeroLevel * 80);
			Adr_Back_New_3 = v_Channel_Plane1 + (lZeroLevel * 80);
			Adr_Back_New_4 = v_Buffer_Plane1 + (lZeroLevel * 80);
		
			if (ZeroLevelCH1 > 3){				// avoid channel number overdrawing
			DrawZeroSign(bitbmCH1, Adr_Front_New_1);
			DrawZeroSign(bitbmCH1, Adr_Front_New_2); }
			DrawZeroSign(bitbmCH1, Adr_Front_New_3);
			DrawZeroSign(bitbmCH1, Adr_Front_New_4);
		
			if (MenuStatus[MENU_CHANNEL1][0] == 6)													// GND 
			{
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_3);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_4);

				DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))	// DC, BW off, INV off 
			{
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))	// AC, BW off, INV off
			{
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))	// DC, BW off, INV on
			{
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))	// DC, BW on, INV off
			{
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))	// AC, BW off, INV on
			{
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))	// AC, BW on, INV off
			{
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))	// DC, BW on, INV on
			{
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))	// AC, BW on, INV on
			{
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
			}
		}
		else	// main mode
		{
			lZeroLevel = ZeroLevelCH1 + GRID_YOFFS - 9;

			Adr_Front_New_1 = v_Channel_Plane1 + (lZeroLevel * 80);
			Adr_Front_New_2 = v_Buffer_Plane1 + (lZeroLevel * 80);
			Adr_Back_New_1 = v_Channel_Plane1 + (lZeroLevel * 80);
			Adr_Back_New_2 = v_Buffer_Plane1 + (lZeroLevel * 80);
		
			if (ZeroLevelCH1 > 3){				// avoid channel number overdrawing
			DrawZeroSign(bitbmCH1, Adr_Front_New_1);
			DrawZeroSign(bitbmCH1, Adr_Front_New_2); }
		
			if (MenuStatus[MENU_CHANNEL1][0] == 6)														// GND 
			{
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);
				DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))		// DC, BW off, INV off  
			{
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))		// AC, BW off, INV off
			{
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))		// DC, BW off, INV on
			{
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))		// DC, BW on, INV off
			{
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))		// AC, BW off, INV on
			{
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF))		// AC, BW on, INV off
			{
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 8) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))		// DC, BW on, INV on
			{
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL1][0] == 7) && (MenuStatus[MENU_CHANNEL1][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL1][2] == BTN_ON))		// AC, BW on, INV on
			{
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
			}
		}
  
    	}
	else if ((Channel_1_Active) && (ZeroLevelCH1 < 4) && (XY_Mode == false))			//level on minimum -> draw arrow up, on channel 1 earlier because of conflicts with channel number
	{
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
		{
			Adr_Front_New_1 = v_Channel_Plane1 + (GRID_YOFFS * 80);
			Adr_Front_New_2 = v_Buffer_Plane1 + (GRID_YOFFS * 80);
			Adr_Front_New_3 = v_Channel_Plane1 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
			Adr_Front_New_4 = v_Buffer_Plane1 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
		
			DrawZeroSign(bitbmMin, Adr_Front_New_1);
			DrawZeroSign(bitbmMin, Adr_Front_New_2);
			DrawZeroSign(bitbmMin, Adr_Front_New_3);
			DrawZeroSign(bitbmMin, Adr_Front_New_4);
		}
		else											//main mode
		{
			Adr_Front_New_1 = v_Channel_Plane1 + (GRID_YOFFS * 80);
			Adr_Front_New_2 = v_Buffer_Plane1 + (GRID_YOFFS * 80);
		
			DrawZeroSign(bitbmMin, Adr_Front_New_1);
			DrawZeroSign(bitbmMin, Adr_Front_New_2);
		}
	}
	else if ((Channel_1_Active) && (ZeroLevelCH1 == (GRID_HEIGHT + 1)) && (XY_Mode == false))	//level on maximum -> draw arrow down
	{
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
		{
			Adr_Front_New_1 = v_Channel_Plane1 + (((GRID_HEIGHT/2) + 11) * 80);
			Adr_Front_New_2 = v_Buffer_Plane1 + (((GRID_HEIGHT/2) + 11) * 80);
			Adr_Front_New_3 = v_Channel_Plane1 + ((GRID_HEIGHT + 11) * 80);
			Adr_Front_New_4 = v_Buffer_Plane1 + ((GRID_HEIGHT + 11) * 80);
		
			DrawZeroSign(bitbmMax, Adr_Front_New_1);
			DrawZeroSign(bitbmMax, Adr_Front_New_2);
			DrawZeroSign(bitbmMax, Adr_Front_New_3);
			DrawZeroSign(bitbmMax, Adr_Front_New_4);
		}
		else											//main mode
		{
			Adr_Front_New_1 = v_Channel_Plane1 + ((GRID_HEIGHT + 11) * 80);
			Adr_Front_New_2 = v_Buffer_Plane1 + ((GRID_HEIGHT + 11) * 80);
		
			DrawZeroSign(bitbmMax, Adr_Front_New_1);
			DrawZeroSign(bitbmMax, Adr_Front_New_2);
		}
	}
      	ZeroLevelCH1_Old = ZeroLevelCH1;


	//---------------------------------------
	// Draw Trigger Channel 1	BF #026
	//---------------------------------------
	if (Selected_Trigger_Source == 1 && Channel_1_Active && XY_Mode == false && USTB_Mode == USTB_OFF && Trigger_Pos_CH1 <= GRID_HEIGHT && !LA_active)// && Trigger_Pos_CH1 >= 0)
	{

		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	// ***** Delayed Mode *****
		{
			if (MenuStatus[MENU_CHANNEL1][2] == BTN_ON) 	// inverted
			{
				lTriggerPos = GRID_YOFFS + (ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1)) >> 1;
				lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1_Old)) >> 1;
			}
			else
			{
				lTriggerPos = GRID_YOFFS + (Trigger_Pos_CH1 >> 1);
				lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH1_Old >> 1);
			}
			
			if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
			{

				Adr_Front_New_1 = v_Channel_Plane1 + ((lTriggerPos - 9) * 80);
				Adr_Front_New_2 = v_Buffer_Plane1 + ((lTriggerPos - 9) * 80);
				Adr_Front_New_3 = v_Channel_Plane1 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
				Adr_Front_New_4 = v_Buffer_Plane1 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
	
	
				if (MenuStatus[MENU_ACQUIRE][1] > 254)	// && !MenuStatus[MENU_CHANNEL1][0] == 6)
				{
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
				}
				else
				{
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
				}
	
				//-----------------------------------------------------------
				// 	draw triggerlevel as dotted line
				//-----------------------------------------------------------
				if (TriggerLevelActive)
				{
					//draw new line in upper window
					for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
					{
						if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
						else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
			
						if (lDraw)
						{
							if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
							{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane1); PixelOff(lix, lTriggerPos_Old, Channel_Plane1); }
							
							PixelOn(lix, lTriggerPos,Channel_Plane1);
							PixelOn(lix, lTriggerPos,Buffer_Plane1);
						}
					}
	
					lTriggerPos += GRID_HEIGHT/2;
					lTriggerPos_Old += GRID_HEIGHT/2;
	
					//draw new line in lower window
					for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
					{
						if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
						else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
			
						if (lDraw)
						{
							if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
							{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane1); PixelOff(lix, lTriggerPos_Old, Channel_Plane1); }
							
							PixelOn(lix, lTriggerPos, Channel_Plane1);
							PixelOn(lix, lTriggerPos, Buffer_Plane1);
						}
					}
	
				}
			}//BF test end
		}
		else	// ***** Main *****
		{
			if (MenuStatus[MENU_CHANNEL1][2] == BTN_ON) 	// inverted
			{
				lTriggerPos = GRID_YOFFS + ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1);
				lTriggerPos_Old = GRID_YOFFS + ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1_Old);
			}
			else
			{
				lTriggerPos = GRID_YOFFS + Trigger_Pos_CH1;
				lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH1_Old;
			}

			if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
			{

				Adr_Front_New_1 = v_Channel_Plane1 + ((lTriggerPos - 9) * 80);
				Adr_Front_New_2 = v_Buffer_Plane1 + ((lTriggerPos - 9) * 80);
	
				
				if (MenuStatus[MENU_ACQUIRE][1] > 254)
				{
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
				}
				else
				{
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
				}
	
				//-----------------------------------------------------------
				// 	draw triggerlevel as dotted line
				//-----------------------------------------------------------
				if (TriggerLevelActive)
				{
					//draw new line
					for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
					{
						if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
						else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
			
						if (lDraw)
						{
							if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
							{ PixelOff(lix, lTriggerPos_Old,Buffer_Plane1); PixelOff(lix, lTriggerPos_Old, Channel_Plane1); }
							
							PixelOn(lix, lTriggerPos,Channel_Plane1);
							PixelOn(lix, lTriggerPos,Buffer_Plane1);
						}
					}
				}

			}//BF test end
		}


		Trigger_Pos_CH1_Old = Trigger_Pos_CH1;
	}


	//-------------------------------------------------------------------------------------------------------------------------
	//                                                      Channel 2
	//-------------------------------------------------------------------------------------------------------------------------


	//---------------------------------------------------------------
	// Remove Channel 2 Zero and Trigger Signs
	//---------------------------------------------------------------
	if(VS_TrigLevelChanged == 2)
	{
			
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed mode
		{
			//remove delayed trigger sign 
			if (MenuStatus[MENU_CHANNEL2][2] == BTN_ON)	//Inverted Signal	BF
			{ lTriggerPos_Old = GRID_YOFFS + ((ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) >> 1) - 9; }
			else
			{ lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH2_Old >> 1) - 9; }
			
			Adr_Front_Old_1 = v_Channel_Plane2 + (lTriggerPos_Old * 80);
			Adr_Front_Old_2 = v_Buffer_Plane2 + (lTriggerPos_Old * 80);

			lTriggerPos_Old += (GRID_HEIGHT/2); 	//lower window

			Adr_Front_Old_3 = v_Channel_Plane2 + (lTriggerPos_Old * 80);
			Adr_Front_Old_4 = v_Buffer_Plane2 + (lTriggerPos_Old * 80);
		
			RemoveZeroSign(Adr_Front_Old_1);
			RemoveZeroSign(Adr_Front_Old_2);
			RemoveZeroSign(Adr_Front_Old_3);
			RemoveZeroSign(Adr_Front_Old_4);
		}
		else	//Main mode
		{
			//remove main trigger sign
			if (MenuStatus[MENU_CHANNEL2][2] == BTN_ON)	//Inverted Signal	BF
			{ lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) - 9;	}
			else
			{ lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH2_Old - 9; }
	
			Adr_Front_Old_1 = v_Channel_Plane2 + (lTriggerPos_Old * 80);
			Adr_Front_Old_2 = v_Buffer_Plane2 + (lTriggerPos_Old * 80);
	
			RemoveZeroSign(Adr_Front_Old_1);
			RemoveZeroSign(Adr_Front_Old_2);
		}

	}

	if(VS_ZeroLevelChanged == 2)
	{
/*		// Remove Channel 2 Zero
		if (XY_Mode)	//Check XY-Mode
		{
			//DrawZeroSignXY(ZeroLevelCH2_Old, 0);
		}
		else
*/		{	
		
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed Mode
			{
				lZeroLevel_Old = (ZeroLevelCH2_Old >> 1) + GRID_YOFFS - 9;
	
				//remove delayed zero sign
				Adr_Front_Old_1 = v_Channel_Plane2 + (lZeroLevel_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane2 + (lZeroLevel_Old * 80);
				Adr_Back_Old_1 = v_Channel_Plane2 + (lZeroLevel_Old * 80);
				Adr_Back_Old_2 = v_Buffer_Plane2 + (lZeroLevel_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSignBack(Adr_Back_Old_1);
				RemoveZeroSignBack(Adr_Back_Old_2);

				lZeroLevel_Old += (GRID_HEIGHT/2); 	//lower window
			
				Adr_Front_Old_1 = v_Channel_Plane2 + (lZeroLevel_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane2 + (lZeroLevel_Old * 80);
				Adr_Back_Old_1 = v_Channel_Plane2 + (lZeroLevel_Old * 80);
				Adr_Back_Old_2 = v_Buffer_Plane2 + (lZeroLevel_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSignBack(Adr_Back_Old_1);
				RemoveZeroSignBack(Adr_Back_Old_2);	
			}
			else	//main mode
			{
				lZeroLevel_Old = ZeroLevelCH2_Old + GRID_YOFFS - 9;

				//remove main zero sign
				Adr_Front_Old_1 = v_Channel_Plane2 + (lZeroLevel_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane2 + (lZeroLevel_Old * 80);
				Adr_Back_Old_1 = v_Channel_Plane2 + (lZeroLevel_Old * 80);
				Adr_Back_Old_2 = v_Buffer_Plane2 + (lZeroLevel_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSignBack(Adr_Back_Old_1);
				RemoveZeroSignBack(Adr_Back_Old_2);
			}

		}
	}


	//---------------------------------------------------------------
	// Draw Channel 2 Zero
	//---------------------------------------------------------------

	//Main + Delayed Mode
	if (Channel_2_Active && (ZeroLevelCH2 > 0) && (ZeroLevelCH2 < (GRID_HEIGHT + 1)) && (XY_Mode == false))	//level is in grid area
	{
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)			//Delayed Mode
		{
			lZeroLevel = (ZeroLevelCH2 >> 1) + GRID_YOFFS - 9;	//upper window

			Adr_Front_New_1 = v_Channel_Plane2 + (lZeroLevel * 80);
			Adr_Front_New_2 = v_Buffer_Plane2 + (lZeroLevel * 80);
			Adr_Back_New_1 = v_Channel_Plane2 + (lZeroLevel * 80);
			Adr_Back_New_2 = v_Buffer_Plane2 + (lZeroLevel * 80);
		
			lZeroLevel += (GRID_HEIGHT/2); 				//lower window

			Adr_Front_New_3 = v_Channel_Plane2 + (lZeroLevel * 80);
			Adr_Front_New_4 = v_Buffer_Plane2 + (lZeroLevel * 80);
			Adr_Back_New_3 = v_Channel_Plane2 + (lZeroLevel * 80);
			Adr_Back_New_4 = v_Buffer_Plane2 + (lZeroLevel * 80);
		
			DrawZeroSign(bitbmCH2, Adr_Front_New_1);
			DrawZeroSign(bitbmCH2, Adr_Front_New_2);
			DrawZeroSign(bitbmCH2, Adr_Front_New_3);
			DrawZeroSign(bitbmCH2, Adr_Front_New_4);
		
			if (MenuStatus[MENU_CHANNEL2][0] == 6)				// GND
			{
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_3);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_4);

				DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
			}
		}
		else	// main mode
		{
			lZeroLevel = ZeroLevelCH2 + GRID_YOFFS - 9;

			Adr_Front_New_1 = v_Channel_Plane2 + (lZeroLevel * 80);
			Adr_Front_New_2 = v_Buffer_Plane2 + (lZeroLevel * 80);
			Adr_Back_New_1 = v_Channel_Plane2 + (lZeroLevel * 80);
			Adr_Back_New_2 = v_Buffer_Plane2 + (lZeroLevel * 80);
		
			DrawZeroSign(bitbmCH2, Adr_Front_New_1);
			DrawZeroSign(bitbmCH2, Adr_Front_New_2);
		
			if (MenuStatus[MENU_CHANNEL2][0] == 6)				// GND
			{
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
				OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);

				DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF))
			{
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] != 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
			}
			else if ((MenuStatus[MENU_CHANNEL2][0] == 7) && (MenuStatus[MENU_CHANNEL2][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL2][2] == BTN_ON))
			{
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
				DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
			}
		}
  
    	}
	else if (Channel_2_Active && (ZeroLevelCH2 == 0) && (XY_Mode == false))			//level on minimum -> draw arrow up
	{
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
		{
			Adr_Front_New_1 = v_Channel_Plane2 + (GRID_YOFFS * 80);
			Adr_Front_New_2 = v_Buffer_Plane2 + (GRID_YOFFS * 80);
			Adr_Front_New_3 = v_Channel_Plane2 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
			Adr_Front_New_4 = v_Buffer_Plane2 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
		
			DrawZeroSign(bitbmMin, Adr_Front_New_1);
			DrawZeroSign(bitbmMin, Adr_Front_New_2);
			DrawZeroSign(bitbmMin, Adr_Front_New_3);
			DrawZeroSign(bitbmMin, Adr_Front_New_4);
		}
		else											//main mode
		{
			Adr_Front_New_1 = v_Channel_Plane2 + (GRID_YOFFS * 80);
			Adr_Front_New_2 = v_Buffer_Plane2 + (GRID_YOFFS * 80);
		
			DrawZeroSign(bitbmMin, Adr_Front_New_1);
			DrawZeroSign(bitbmMin, Adr_Front_New_2);
		}
	}
	else if (Channel_2_Active && (ZeroLevelCH2 == (GRID_HEIGHT + 1)) && (XY_Mode == false))	//level on maximum -> draw arrow down
	{
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
		{
			Adr_Front_New_1 = v_Channel_Plane2 + (((GRID_HEIGHT/2) + 11) * 80);
			Adr_Front_New_2 = v_Buffer_Plane2 + (((GRID_HEIGHT/2) + 11) * 80);
			Adr_Front_New_3 = v_Channel_Plane2 + ((GRID_HEIGHT + 11) * 80);
			Adr_Front_New_4 = v_Buffer_Plane2 + ((GRID_HEIGHT + 11) * 80);
		
			DrawZeroSign(bitbmMax, Adr_Front_New_1);
			DrawZeroSign(bitbmMax, Adr_Front_New_2);
			DrawZeroSign(bitbmMax, Adr_Front_New_3);
			DrawZeroSign(bitbmMax, Adr_Front_New_4);
		}
		else											//main mode
		{
			Adr_Front_New_1 = v_Channel_Plane2 + ((GRID_HEIGHT + 11) * 80);
			Adr_Front_New_2 = v_Buffer_Plane2 + ((GRID_HEIGHT + 11) * 80);
		
			DrawZeroSign(bitbmMax, Adr_Front_New_1);
			DrawZeroSign(bitbmMax, Adr_Front_New_2);
		}
	}

	ZeroLevelCH2_Old = ZeroLevelCH2;


	// Draw Trigger Channel 2	BF #026
	if (Selected_Trigger_Source == 2 && Channel_2_Active && XY_Mode == false  && USTB_Mode == USTB_OFF && Trigger_Pos_CH2 <= GRID_HEIGHT && !LA_active) // && Trigger_Pos_CH2 >= 0)
	{

		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)		//Delayed Mode
		{
			if (MenuStatus[MENU_CHANNEL2][2] == BTN_ON) // inverted
			{
				lTriggerPos = GRID_YOFFS + (ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2)) >> 1;
				lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2_Old)) >> 1;
			}
			else
			{
				lTriggerPos = GRID_YOFFS + (Trigger_Pos_CH2 >> 1);
				lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH2_Old >> 1);
			}

			if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
			{
				Adr_Front_New_1 = v_Channel_Plane2 + ((lTriggerPos - 9) * 80);
				Adr_Front_New_2 = v_Buffer_Plane2 + ((lTriggerPos - 9) * 80);
				Adr_Front_New_3 = v_Channel_Plane2 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
				Adr_Front_New_4 = v_Buffer_Plane2 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
	
	
				if (MenuStatus[MENU_ACQUIRE][1] > 254)
				{
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
				}
				else
				{
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
				}
	
				//-----------------------------------------------------------
				// 	draw triggerlevel as dotted line
				//-----------------------------------------------------------
				if (TriggerLevelActive)
				{
					//draw new line in upper window
					for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
					{
						if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
						else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
			
						if (lDraw)
						{
							if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
							{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane2); PixelOff(lix, lTriggerPos_Old,Channel_Plane2); }
							
							PixelOn(lix, lTriggerPos, Channel_Plane2);
							PixelOn(lix, lTriggerPos, Buffer_Plane2);
						}
					}
	
					lTriggerPos += GRID_HEIGHT/2;
					lTriggerPos_Old += GRID_HEIGHT/2;
	
					//draw new line in lower window
					for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
					{
						if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
						else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
			
						if (lDraw)
						{
							if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
							{ PixelOff(lix, lTriggerPos_Old,Buffer_Plane2); PixelOff(lix, lTriggerPos_Old,Channel_Plane2); }
							
							PixelOn(lix, lTriggerPos,Channel_Plane2);
							PixelOn(lix, lTriggerPos,Buffer_Plane2);
						}
					}
	
				}
			}
		}
		else	//Main
		{
			if (MenuStatus[MENU_CHANNEL2][2] == BTN_ON) // inverted
			{
				lTriggerPos = GRID_YOFFS + ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2);
				lTriggerPos_Old = GRID_YOFFS + ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2_Old);
			}
			else
			{
				lTriggerPos = GRID_YOFFS + Trigger_Pos_CH2;
				lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH2_Old;
			}

			if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
			{
				Adr_Front_New_1 = v_Channel_Plane2 + ((lTriggerPos - 9) * 80);
				Adr_Front_New_2 = v_Buffer_Plane2 + ((lTriggerPos - 9) * 80);
	
				
				if (MenuStatus[MENU_ACQUIRE][1] > 254)
				{
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
				}
				else
				{
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
					OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
				}
	
				//-----------------------------------------------------------
				// 	draw triggerlevel as dotted line
				//-----------------------------------------------------------
				if (TriggerLevelActive)
				{
					//draw new line
					for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
					{
						if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
						else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
			
						if (lDraw)
						{
							if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
							{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane2); PixelOff(lix, lTriggerPos_Old, Channel_Plane2); }
							
							PixelOn(lix, lTriggerPos, Channel_Plane2);
							PixelOn(lix, lTriggerPos, Buffer_Plane2);
						}
					}
				}
			}

		}

		Trigger_Pos_CH2_Old = Trigger_Pos_CH2;
	}
	

	//4 Channel version
	if (NumberOfChannels == 4)
	{
       
		//-------------------------------------------------------------------------------------------------------------------------
		//                                                      Channel 3
		//-------------------------------------------------------------------------------------------------------------------------
	
		//---------------------------------------------------------------
		// Remove Channel 3 Zero and Trigger Signs
		//---------------------------------------------------------------

		if(VS_TrigLevelChanged == 3)
		{
				
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed mode
			{
				//remove delayed trigger sign 
				if (MenuStatus[MENU_CHANNEL3][2] == BTN_ON)	//Inverted Signal	BF
				{ lTriggerPos_Old = GRID_YOFFS + ((ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) >> 1) - 9; }
				else
				{ lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH3_Old >> 1) - 9; }
				
				Adr_Front_Old_1 = v_Channel_Plane3 + (lTriggerPos_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane3 + (lTriggerPos_Old * 80);
	
				lTriggerPos_Old += (GRID_HEIGHT/2); 	//lower window
	
				Adr_Front_Old_3 = v_Channel_Plane3 + (lTriggerPos_Old * 80);
				Adr_Front_Old_4 = v_Buffer_Plane3 + (lTriggerPos_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSign(Adr_Front_Old_3);
				RemoveZeroSign(Adr_Front_Old_4);
			}
			else	//Main mode
			{
				//remove main trigger sign
				if (MenuStatus[MENU_CHANNEL3][2] == BTN_ON)	//Inverted Signal	BF
				{ lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) - 9;	}
				else
				{ lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH3_Old - 9; }
		
				Adr_Front_Old_1 = v_Channel_Plane3 + (lTriggerPos_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane3 + (lTriggerPos_Old * 80);
		
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
			}
	
		}
	
		if(VS_ZeroLevelChanged == 3)
		{
	/*		// Remove Channel 3 Zero
			if (XY_Mode)	//Check XY-Mode
			{
				//DrawZeroSignXY(ZeroLevelCH3_Old, 0);
			}
			else
	*/		{	
			
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed Mode
				{
					lZeroLevel_Old = (ZeroLevelCH3_Old >> 1) + GRID_YOFFS - 9;
		
					//remove delayed zero sign
					Adr_Front_Old_1 = v_Channel_Plane3 + (lZeroLevel_Old * 80);
					Adr_Front_Old_2 = v_Buffer_Plane3 + (lZeroLevel_Old * 80);
					Adr_Back_Old_1 = v_Channel_Plane3 + (lZeroLevel_Old * 80);
					Adr_Back_Old_2 = v_Buffer_Plane3 + (lZeroLevel_Old * 80);
				
					RemoveZeroSign(Adr_Front_Old_1);
					RemoveZeroSign(Adr_Front_Old_2);
					RemoveZeroSignBack(Adr_Back_Old_1);
					RemoveZeroSignBack(Adr_Back_Old_2);
	
					lZeroLevel_Old += (GRID_HEIGHT/2); 	//lower window
				
					Adr_Front_Old_1 = v_Channel_Plane3 + (lZeroLevel_Old * 80);
					Adr_Front_Old_2 = v_Buffer_Plane3 + (lZeroLevel_Old * 80);
					Adr_Back_Old_1 = v_Channel_Plane3 + (lZeroLevel_Old * 80);
					Adr_Back_Old_2 = v_Buffer_Plane3 + (lZeroLevel_Old * 80);
				
					RemoveZeroSign(Adr_Front_Old_1);
					RemoveZeroSign(Adr_Front_Old_2);
					RemoveZeroSignBack(Adr_Back_Old_1);
					RemoveZeroSignBack(Adr_Back_Old_2);	
				}
				else	//main mode
				{
					lZeroLevel_Old = ZeroLevelCH3_Old + GRID_YOFFS - 9;
	
					//remove main zero sign
					Adr_Front_Old_1 = v_Channel_Plane3 + (lZeroLevel_Old * 80);
					Adr_Front_Old_2 = v_Buffer_Plane3 + (lZeroLevel_Old * 80);
					Adr_Back_Old_1 = v_Channel_Plane3 + (lZeroLevel_Old * 80);
					Adr_Back_Old_2 = v_Buffer_Plane3 + (lZeroLevel_Old * 80);
				
					RemoveZeroSign(Adr_Front_Old_1);
					RemoveZeroSign(Adr_Front_Old_2);
					RemoveZeroSignBack(Adr_Back_Old_1);
					RemoveZeroSignBack(Adr_Back_Old_2);
				}
	
			}
		}

		//---------------------------------------------------------------
		// Draw Channel 3 Zero
		//---------------------------------------------------------------

		//Main + Delayed Mode
		if (Channel_3_Active && (ZeroLevelCH3 > 0) && (ZeroLevelCH3 < (GRID_HEIGHT + 1)) && (XY_Mode == false))	//level is in grid area
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)			//Delayed Mode
			{
				lZeroLevel = (ZeroLevelCH3 >> 1) + GRID_YOFFS - 9;	//upper window
	
				Adr_Front_New_1 = v_Channel_Plane3 + (lZeroLevel * 80);
				Adr_Front_New_2 = v_Buffer_Plane3 + (lZeroLevel * 80);
				Adr_Back_New_1 = v_Channel_Plane3 + (lZeroLevel * 80);
				Adr_Back_New_2 = v_Buffer_Plane3 + (lZeroLevel * 80);
			
				lZeroLevel += (GRID_HEIGHT/2); 				//lower window
	
				Adr_Front_New_3 = v_Channel_Plane3 + (lZeroLevel * 80);
				Adr_Front_New_4 = v_Buffer_Plane3 + (lZeroLevel * 80);
				Adr_Back_New_3 = v_Channel_Plane3 + (lZeroLevel * 80);
				Adr_Back_New_4 = v_Buffer_Plane3 + (lZeroLevel * 80);
			
				DrawZeroSign(bitbmCH3, Adr_Front_New_1);
				DrawZeroSign(bitbmCH3, Adr_Front_New_2);
				DrawZeroSign(bitbmCH3, Adr_Front_New_3);
				DrawZeroSign(bitbmCH3, Adr_Front_New_4);
			
				if (MenuStatus[MENU_CHANNEL3][0] == 6)				// GND
				{
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_3);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_4);

					DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
				}
			}
			else	// main mode
			{
				lZeroLevel = ZeroLevelCH3 + GRID_YOFFS - 9;
	
				Adr_Front_New_1 = v_Channel_Plane3 + (lZeroLevel * 80);
				Adr_Front_New_2 = v_Buffer_Plane3 + (lZeroLevel * 80);
				Adr_Back_New_1 = v_Channel_Plane3 + (lZeroLevel * 80);
				Adr_Back_New_2 = v_Buffer_Plane3 + (lZeroLevel * 80);
			
				DrawZeroSign(bitbmCH3, Adr_Front_New_1);
				DrawZeroSign(bitbmCH3, Adr_Front_New_2);
			
				if (MenuStatus[MENU_CHANNEL3][0] == 6)				// GND
				{
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);

					DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] != 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL3][0] == 7) && (MenuStatus[MENU_CHANNEL3][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL3][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
				}
			}
	
		}
		else if (Channel_3_Active && (ZeroLevelCH3 == 0) && (XY_Mode == false))			//level on minimum -> draw arrow up
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
			{
				Adr_Front_New_1 = v_Channel_Plane3 + (GRID_YOFFS * 80);
				Adr_Front_New_2 = v_Buffer_Plane3 + (GRID_YOFFS * 80);
				Adr_Front_New_3 = v_Channel_Plane3 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
				Adr_Front_New_4 = v_Buffer_Plane3 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
			
				DrawZeroSign(bitbmMin, Adr_Front_New_1);
				DrawZeroSign(bitbmMin, Adr_Front_New_2);
				DrawZeroSign(bitbmMin, Adr_Front_New_3);
				DrawZeroSign(bitbmMin, Adr_Front_New_4);
			}
			else											//main mode
			{
				Adr_Front_New_1 = v_Channel_Plane3 + (GRID_YOFFS * 80);
				Adr_Front_New_2 = v_Buffer_Plane3 + (GRID_YOFFS * 80);
			
				DrawZeroSign(bitbmMin, Adr_Front_New_1);
				DrawZeroSign(bitbmMin, Adr_Front_New_2);
			}
		}
		else if (Channel_3_Active && (ZeroLevelCH3 == (GRID_HEIGHT + 1)) && (XY_Mode == false))	//level on maximum -> draw arrow down
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
			{
				Adr_Front_New_1 = v_Channel_Plane3 + (((GRID_HEIGHT/2) + 11) * 80);
				Adr_Front_New_2 = v_Buffer_Plane3 + (((GRID_HEIGHT/2) + 11) * 80);
				Adr_Front_New_3 = v_Channel_Plane3 + ((GRID_HEIGHT + 11) * 80);
				Adr_Front_New_4 = v_Buffer_Plane3 + ((GRID_HEIGHT + 11) * 80);
			
				DrawZeroSign(bitbmMax, Adr_Front_New_1);
				DrawZeroSign(bitbmMax, Adr_Front_New_2);
				DrawZeroSign(bitbmMax, Adr_Front_New_3);
				DrawZeroSign(bitbmMax, Adr_Front_New_4);
			}
			else											//main mode
			{
				Adr_Front_New_1 = v_Channel_Plane3 + ((GRID_HEIGHT + 11) * 80);
				Adr_Front_New_2 = v_Buffer_Plane3 + ((GRID_HEIGHT + 11) * 80);
			
				DrawZeroSign(bitbmMax, Adr_Front_New_1);
				DrawZeroSign(bitbmMax, Adr_Front_New_2);
			}
		}
		ZeroLevelCH3_Old = ZeroLevelCH3;


		// Draw Trigger Channel 3	BF #026
		if (Selected_Trigger_Source == 3 && Channel_3_Active && XY_Mode == false  && USTB_Mode == USTB_OFF && Trigger_Pos_CH3 <= GRID_HEIGHT && !LA_active) // && Trigger_Pos_CH3 >= 0)
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)		//Delayed Mode
			{
				if (MenuStatus[MENU_CHANNEL3][2] == BTN_ON) // inverted
				{
					lTriggerPos = GRID_YOFFS + (ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3)) >> 1;
					lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3_Old)) >> 1;
				}
				else
				{
					lTriggerPos = GRID_YOFFS + (Trigger_Pos_CH3 >> 1);
					lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH3_Old >> 1);
				}
				
				if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
				{
					Adr_Front_New_1 = v_Channel_Plane3 + ((lTriggerPos - 9) * 80);
					Adr_Front_New_2 = v_Buffer_Plane3 + ((lTriggerPos - 9) * 80);
					Adr_Front_New_3 = v_Channel_Plane3 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
					Adr_Front_New_4 = v_Buffer_Plane3 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
		
		
					if (MenuStatus[MENU_ACQUIRE][1] > 254)
					{
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
					}
					else
					{
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
					}
		
					//-----------------------------------------------------------
					// 	draw triggerlevel as dotted line
					//-----------------------------------------------------------
					if (TriggerLevelActive)
					{
						//draw new line in upper window
						for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
						{
							if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
							else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
				
							if (lDraw)
							{
								if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
								{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane3); PixelOff(lix, lTriggerPos_Old, Channel_Plane3); }
								
								PixelOn(lix, lTriggerPos, Channel_Plane3);
								PixelOn(lix, lTriggerPos, Buffer_Plane3);
							}
						}
		
						lTriggerPos += GRID_HEIGHT/2;
						lTriggerPos_Old += GRID_HEIGHT/2;
		
						//draw new line in lower window
						for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
						{
							if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
							else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
				
							if (lDraw)
							{
								if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
								{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane3); PixelOff(lix, lTriggerPos_Old, Channel_Plane3); }
								
								PixelOn(lix, lTriggerPos, Channel_Plane3);
								PixelOn(lix, lTriggerPos, Buffer_Plane3);
							}
						}
		
					}
				}
			}
			else	//Main
			{
				if (MenuStatus[MENU_CHANNEL3][2] == BTN_ON) // inverted
				{
					lTriggerPos = GRID_YOFFS + ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3);
					lTriggerPos_Old = GRID_YOFFS + ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3_Old);
				}
				else
				{
					lTriggerPos = GRID_YOFFS + Trigger_Pos_CH3;
					lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH3_Old;
				}
	
				if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
				{
					Adr_Front_New_1 = v_Channel_Plane3 + ((lTriggerPos - 9) * 80);
					Adr_Front_New_2 = v_Buffer_Plane3 + ((lTriggerPos - 9) * 80);
		
					
					if (MenuStatus[MENU_ACQUIRE][1] > 254)
					{
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
					}
					else
					{
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
					}
		
					//-----------------------------------------------------------
					// 	draw triggerlevel as dotted line
					//-----------------------------------------------------------
					if (TriggerLevelActive)
					{
						//draw new line
						for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
						{
							if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
							else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
				
							if (lDraw)
							{
								if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
								{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane3); PixelOff(lix, lTriggerPos_Old, Channel_Plane3); }
								
								PixelOn(lix, lTriggerPos, Channel_Plane3);
								PixelOn(lix, lTriggerPos, Buffer_Plane3);
							}
						}
					}
				}
			}

			Trigger_Pos_CH3_Old = Trigger_Pos_CH3;
		}


		//-------------------------------------------------------------------------------------------------------------------------
		//                                                      Channel 4
		//-------------------------------------------------------------------------------------------------------------------------

		//---------------------------------------------------------------
		// Remove Channel 4 Zero and Trigger Signs
		//---------------------------------------------------------------
		if(VS_TrigLevelChanged == 4)
		{
			
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed mode
			{
				//remove delayed trigger sign 
				if (MenuStatus[MENU_CHANNEL4][2] == BTN_ON)	//Inverted Signal	BF
				{ lTriggerPos_Old = GRID_YOFFS + ((ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) >> 1) - 9; }
				else
				{ lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH4_Old >> 1) - 9; }
				
				Adr_Front_Old_1 = v_Channel_Plane4 + (lTriggerPos_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane4 + (lTriggerPos_Old * 80);
	
				lTriggerPos_Old += (GRID_HEIGHT/2); 	//lower window
	
				Adr_Front_Old_3 = v_Channel_Plane4 + (lTriggerPos_Old * 80);
				Adr_Front_Old_4 = v_Buffer_Plane4 + (lTriggerPos_Old * 80);
			
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
				RemoveZeroSign(Adr_Front_Old_3);
				RemoveZeroSign(Adr_Front_Old_4);
			}
			else	//Main mode
			{
				//remove main trigger sign
				if (MenuStatus[MENU_CHANNEL4][2] == BTN_ON)	//Inverted Signal	BF
				{ lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) - 9;	}
				else
				{ lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH4_Old - 9; }
		
				Adr_Front_Old_1 = v_Channel_Plane4 + (lTriggerPos_Old * 80);
				Adr_Front_Old_2 = v_Buffer_Plane4 + (lTriggerPos_Old * 80);
		
				RemoveZeroSign(Adr_Front_Old_1);
				RemoveZeroSign(Adr_Front_Old_2);
			}
	
		}
	
		if(VS_ZeroLevelChanged == 4)
		{
	/*		// Remove Channel 4 Zero
			if (XY_Mode)	//Check XY-Mode
			{
				//DrawZeroSignXY(ZeroLevelCH4_Old, 0);
			}
			else
	*/		{	
			
				if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed Mode
				{
					lZeroLevel_Old = (ZeroLevelCH4_Old >> 1) + GRID_YOFFS - 9;
		
					//remove delayed zero sign
					Adr_Front_Old_1 = v_Channel_Plane4 + (lZeroLevel_Old * 80);
					Adr_Front_Old_2 = v_Buffer_Plane4 + (lZeroLevel_Old * 80);
					Adr_Back_Old_1 = v_Channel_Plane4 + (lZeroLevel_Old * 80);
					Adr_Back_Old_2 = v_Buffer_Plane4 + (lZeroLevel_Old * 80);
				
					RemoveZeroSign(Adr_Front_Old_1);
					RemoveZeroSign(Adr_Front_Old_2);
					RemoveZeroSignBack(Adr_Back_Old_1);
					RemoveZeroSignBack(Adr_Back_Old_2);
	
					lZeroLevel_Old += (GRID_HEIGHT/2); 	//lower window
				
					Adr_Front_Old_1 = v_Channel_Plane4 + (lZeroLevel_Old * 80);
					Adr_Front_Old_2 = v_Buffer_Plane4 + (lZeroLevel_Old * 80);
					Adr_Back_Old_1 = v_Channel_Plane4 + (lZeroLevel_Old * 80);
					Adr_Back_Old_2 = v_Buffer_Plane4 + (lZeroLevel_Old * 80);
				
					RemoveZeroSign(Adr_Front_Old_1);
					RemoveZeroSign(Adr_Front_Old_2);
					RemoveZeroSignBack(Adr_Back_Old_1);
					RemoveZeroSignBack(Adr_Back_Old_2);	
				}
				else	//main mode
				{
					lZeroLevel_Old = ZeroLevelCH4_Old + GRID_YOFFS - 9;
	
					//remove main zero sign
					Adr_Front_Old_1 = v_Channel_Plane4 + (lZeroLevel_Old * 80);
					Adr_Front_Old_2 = v_Buffer_Plane4 + (lZeroLevel_Old * 80);
					Adr_Back_Old_1 = v_Channel_Plane4 + (lZeroLevel_Old * 80);
					Adr_Back_Old_2 = v_Buffer_Plane4 + (lZeroLevel_Old * 80);
				
					RemoveZeroSign(Adr_Front_Old_1);
					RemoveZeroSign(Adr_Front_Old_2);
					RemoveZeroSignBack(Adr_Back_Old_1);
					RemoveZeroSignBack(Adr_Back_Old_2);
				}
	
			}
		}


		//---------------------------------------------------------------
		// Draw Channel 4 Zero
		//---------------------------------------------------------------

		//Main + Delayed Mode
		if (Channel_4_Active && (ZeroLevelCH4 > 0) && (ZeroLevelCH4 < (GRID_HEIGHT + 1)) && (XY_Mode == false))	//level is in grid area
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)			//Delayed Mode
			{
				lZeroLevel = (ZeroLevelCH4 >> 1) + GRID_YOFFS - 9;	//upper window
	
				Adr_Front_New_1 = v_Channel_Plane4 + (lZeroLevel * 80);
				Adr_Front_New_2 = v_Buffer_Plane4 + (lZeroLevel * 80);
				Adr_Back_New_1 = v_Channel_Plane4 + (lZeroLevel * 80);
				Adr_Back_New_2 = v_Buffer_Plane4 + (lZeroLevel * 80);
			
				lZeroLevel += (GRID_HEIGHT/2); 				//lower window
	
				Adr_Front_New_3 = v_Channel_Plane4 + (lZeroLevel * 80);
				Adr_Front_New_4 = v_Buffer_Plane4 + (lZeroLevel * 80);
				Adr_Back_New_3 = v_Channel_Plane4 + (lZeroLevel * 80);
				Adr_Back_New_4 = v_Buffer_Plane4 + (lZeroLevel * 80);
			
				DrawZeroSign(bitbmCH4, Adr_Front_New_1);
				DrawZeroSign(bitbmCH4, Adr_Front_New_2);
				DrawZeroSign(bitbmCH4, Adr_Front_New_3);
				DrawZeroSign(bitbmCH4, Adr_Front_New_4);
			
				if (MenuStatus[MENU_CHANNEL4][0] == 6)				// GND
				{
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_3);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_4);

					DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
				}
			}
			else	// main mode
			{
				lZeroLevel = ZeroLevelCH4 + GRID_YOFFS - 9;
	
				Adr_Front_New_1 = v_Channel_Plane4 + (lZeroLevel * 80);
				Adr_Front_New_2 = v_Buffer_Plane4 + (lZeroLevel * 80);
				Adr_Back_New_1 = v_Channel_Plane4 + (lZeroLevel * 80);
				Adr_Back_New_2 = v_Buffer_Plane4 + (lZeroLevel * 80);
			
				DrawZeroSign(bitbmCH4, Adr_Front_New_1);
				DrawZeroSign(bitbmCH4, Adr_Front_New_2);
			
				if (MenuStatus[MENU_CHANNEL4][0] == 6)				// GND
				{
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_1);
					OverDrawZeroSign(bitbm_GND, Adr_Front_New_2);

					DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF))
				{
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] != 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
				}
				else if ((MenuStatus[MENU_CHANNEL4][0] == 7) && (MenuStatus[MENU_CHANNEL4][1] == BTN_ON) && (MenuStatus[MENU_CHANNEL4][2] == BTN_ON))
				{
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
					DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
				}
			}
	
		}
		else if (Channel_4_Active && (ZeroLevelCH4 == 0) && (XY_Mode == false))			//level on minimum -> draw arrow up
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
			{
				Adr_Front_New_1 = v_Channel_Plane4 + (GRID_YOFFS * 80);
				Adr_Front_New_2 = v_Buffer_Plane4 + (GRID_YOFFS * 80);
				Adr_Front_New_3 = v_Channel_Plane4 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
				Adr_Front_New_4 = v_Buffer_Plane4 + ((GRID_YOFFS + (GRID_HEIGHT/2)) * 80);
			
				DrawZeroSign(bitbmMin, Adr_Front_New_1);
				DrawZeroSign(bitbmMin, Adr_Front_New_2);
				DrawZeroSign(bitbmMin, Adr_Front_New_3);
				DrawZeroSign(bitbmMin, Adr_Front_New_4);
			}
			else											//main mode
			{
				Adr_Front_New_1 = v_Channel_Plane4 + (GRID_YOFFS * 80);
				Adr_Front_New_2 = v_Buffer_Plane4 + (GRID_YOFFS * 80);
			
				DrawZeroSign(bitbmMin, Adr_Front_New_1);
				DrawZeroSign(bitbmMin, Adr_Front_New_2);
			}
		}
		else if (Channel_4_Active && (ZeroLevelCH4 == (GRID_HEIGHT + 1)) && (XY_Mode == false))	//level on maximum -> draw arrow down
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//delayed mode
			{
				Adr_Front_New_1 = v_Channel_Plane4 + (((GRID_HEIGHT/2) + 11) * 80);
				Adr_Front_New_2 = v_Buffer_Plane4 + (((GRID_HEIGHT/2) + 11) * 80);
				Adr_Front_New_3 = v_Channel_Plane4 + ((GRID_HEIGHT + 11) * 80);
				Adr_Front_New_4 = v_Buffer_Plane4 + ((GRID_HEIGHT + 11) * 80);
			
				DrawZeroSign(bitbmMax, Adr_Front_New_1);
				DrawZeroSign(bitbmMax, Adr_Front_New_2);
				DrawZeroSign(bitbmMax, Adr_Front_New_3);
				DrawZeroSign(bitbmMax, Adr_Front_New_4);
			}
			else											//main mode
			{
				Adr_Front_New_1 = v_Channel_Plane4 + ((GRID_HEIGHT + 11) * 80);
				Adr_Front_New_2 = v_Buffer_Plane4 + ((GRID_HEIGHT + 11) * 80);
			
				DrawZeroSign(bitbmMax, Adr_Front_New_1);
				DrawZeroSign(bitbmMax, Adr_Front_New_2);
			}
		}
		ZeroLevelCH4_Old = ZeroLevelCH4;


		// Draw Trigger Channel 4	BF #024
		if (Selected_Trigger_Source == 4 && Channel_4_Active && XY_Mode == false  && USTB_Mode == USTB_OFF && Trigger_Pos_CH4 <= GRID_HEIGHT && !LA_active) // && Trigger_Pos_CH4 >= 0)
		{
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)		//Delayed Mode
			{
				if (MenuStatus[MENU_CHANNEL3][2] == BTN_ON) // inverted
				{
					lTriggerPos = GRID_YOFFS + (ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4)) >> 1;
					lTriggerPos_Old = GRID_YOFFS + (ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4_Old)) >> 1;
				}
				else
				{
					lTriggerPos = GRID_YOFFS + (Trigger_Pos_CH4 >> 1);
					lTriggerPos_Old = GRID_YOFFS + (Trigger_Pos_CH4_Old >> 1);
				}
				
				if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
				{
					Adr_Front_New_1 = v_Channel_Plane4 + ((lTriggerPos - 9) * 80);
					Adr_Front_New_2 = v_Buffer_Plane4 + ((lTriggerPos - 9) * 80);
					Adr_Front_New_3 = v_Channel_Plane4 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
					Adr_Front_New_4 = v_Buffer_Plane4 + ((lTriggerPos - 9 + (GRID_HEIGHT/2)) * 80);
		
		
					if (MenuStatus[MENU_ACQUIRE][1] > 254)
					{
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
					}
					else
					{
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
					}
		
					//-----------------------------------------------------------
					// 	draw triggerlevel as dotted line
					//-----------------------------------------------------------
					if (TriggerLevelActive)
					{
						//draw new line in upper window
						for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
						{
							if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
							else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
				
							if (lDraw)
							{
								if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
								{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane4); PixelOff(lix, lTriggerPos_Old, Channel_Plane4); }
								
								PixelOn(lix, lTriggerPos, Channel_Plane4);
								PixelOn(lix, lTriggerPos, Buffer_Plane4);
							}
						}
		
						lTriggerPos += GRID_HEIGHT/2;
						lTriggerPos_Old += GRID_HEIGHT/2;
		
						//draw new line in lower window
						for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
						{
							if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
							else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
				
							if (lDraw)
							{
								if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
								{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane4); PixelOff(lix, lTriggerPos_Old, Channel_Plane4); }
								
								PixelOn(lix, lTriggerPos, Channel_Plane4);
								PixelOn(lix, lTriggerPos, Buffer_Plane4);
							}
						}
		
					}
				}
			}
			else	//Main
			{
				if (MenuStatus[MENU_CHANNEL4][2] == BTN_ON) // inverted
				{
					lTriggerPos = GRID_YOFFS + ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4);
					lTriggerPos_Old = GRID_YOFFS + ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4_Old);
				}
				else
				{
					lTriggerPos = GRID_YOFFS + Trigger_Pos_CH4;
					lTriggerPos_Old = GRID_YOFFS + Trigger_Pos_CH4_Old;
				}
	
				if (lTriggerPos > GRID_YOFFS) 			// limiter to avoid status area overwriting
				{
					Adr_Front_New_1 = v_Channel_Plane4 + ((lTriggerPos - 9) * 80);
					Adr_Front_New_2 = v_Buffer_Plane4 + ((lTriggerPos - 9) * 80);
		
					
					if (MenuStatus[MENU_ACQUIRE][1] > 254)
					{
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
					}
					else
					{
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
						OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
					}
		
					//-----------------------------------------------------------
					// 	draw triggerlevel as dotted line
					//-----------------------------------------------------------
					if (TriggerLevelActive)
					{
						//draw new line
						for(lix = GRID_XOFFS+3,lDraw = 1,lCnt = 0; lix < (GRID_WIDTH + GRID_XOFFS - 3);lix++,lCnt++)
						{
							if (lCnt == 5 && lDraw) { lDraw = 0; lCnt = 0; }
							else if (lCnt == 5 && !lDraw) { lDraw = 1; lCnt = 0;} 
				
							if (lDraw)
							{
								if (lTriggerPos_Old != lTriggerPos)	//delete old line if level changed
								{ PixelOff(lix, lTriggerPos_Old, Buffer_Plane4); PixelOff(lix, lTriggerPos_Old, Channel_Plane4); }
								
								PixelOn(lix, lTriggerPos, Channel_Plane4);
								PixelOn(lix, lTriggerPos, Buffer_Plane4);
							}
						}
					}
				}
	
			}

			Trigger_Pos_CH4_Old = Trigger_Pos_CH4;
		}

    	}//end number of channels == 4

}
//##########################################################################################################################################################

void Display::RemoveZeroSign(long addressold)
{
    CLEAR2BYTE(addressold + 0x000);
    CLEAR2BYTE(addressold + 0x050);
    CLEAR2BYTE(addressold + 0x0A0);
    CLEAR2BYTE(addressold + 0x0F0);
    CLEAR2BYTE(addressold + 0x140);
    CLEAR2BYTE(addressold + 0x190);
    CLEAR2BYTE(addressold + 0x1E0);
    CLEAR2BYTE(addressold + 0x230);
    CLEAR2BYTE(addressold + 0x280);
    CLEAR2BYTE(addressold + 0x2D0);
    CLEAR2BYTE(addressold + 0x320);
    CLEAR2BYTE(addressold + 0x370);
    CLEAR2BYTE(addressold + 0x3C0);
    CLEAR2BYTE(addressold + 0x410);
    CLEAR2BYTE(addressold + 0x460);
    CLEAR2BYTE(addressold + 0x4B0);
}
//##########################################################################################################################################################

void Display::DrawZeroSign(unsigned char *sign, long addressnew)
{
    WRITE2BYTE(sign[2], sign[3], addressnew + 0x000);
    WRITE2BYTE(sign[4], sign[5], addressnew + 0x050);
    WRITE2BYTE(sign[6], sign[7], addressnew + 0x0A0);
    WRITE2BYTE(sign[8], sign[9], addressnew + 0x0F0);
    WRITE2BYTE(sign[10], sign[11], addressnew + 0x140);
    WRITE2BYTE(sign[12], sign[13], addressnew + 0x190);
    WRITE2BYTE(sign[14], sign[15], addressnew + 0x1E0);
    WRITE2BYTE(sign[16], sign[17], addressnew + 0x230);
    WRITE2BYTE(sign[18], sign[19], addressnew + 0x280);
    WRITE2BYTE(sign[20], sign[21], addressnew + 0x2D0);
    WRITE2BYTE(sign[22], sign[23], addressnew + 0x320);
    WRITE2BYTE(sign[24], sign[25], addressnew + 0x370);
    WRITE2BYTE(sign[26], sign[27], addressnew + 0x3C0);
    WRITE2BYTE(sign[28], sign[29], addressnew + 0x410);
    WRITE2BYTE(sign[30], sign[31], addressnew + 0x460);
    WRITE2BYTE(sign[32], sign[33], addressnew + 0x4B0);
}
//##########################################################################################################################################################

void Display::DrawZeroSignXY(int position, char set)
{
    int posiy = 20;

    DRAWLINEP(position + 80, posiy, position + 80, posiy + 6, set, Buffer_Plane1);

    DRAWLINEP(position + 80 - 1, posiy + 1, position + 80 + 2, posiy + 1, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 2, posiy + 2, position + 80 + 3, posiy + 2, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 3, posiy + 3, position + 80 + 4, posiy + 3, set, Buffer_Plane1);

    DRAWLINEP(position + 80 - 2, posiy + 6, position + 80 + 3, posiy + 6, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 1, posiy + 8, position + 80 + 2, posiy + 8, set, Buffer_Plane1);
    PIXELP(position + 80, posiy + 10, set, Buffer_Plane1);

    PIXELP(position + 80 - 7, posiy + 3, set, Buffer_Plane1);
    PIXELP(position + 80 - 6, posiy + 2, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 5, posiy + 1, position + 80 - 5, posiy + 7, set, Buffer_Plane1);
}
//##########################################################################################################################################################

void Display::OverDrawZeroSign(unsigned char *sign, long addressnew)
{
    OVERWRITE2BYTE(sign[2], sign[3], addressnew + 0x000);
    OVERWRITE2BYTE(sign[4], sign[5], addressnew + 0x050);
    OVERWRITE2BYTE(sign[6], sign[7], addressnew + 0x0A0);
    OVERWRITE2BYTE(sign[8], sign[9], addressnew + 0x0F0);
    OVERWRITE2BYTE(sign[10], sign[11], addressnew + 0x140);
    OVERWRITE2BYTE(sign[12], sign[13], addressnew + 0x190);
    OVERWRITE2BYTE(sign[14], sign[15], addressnew + 0x1E0);
    OVERWRITE2BYTE(sign[16], sign[17], addressnew + 0x230);
    OVERWRITE2BYTE(sign[18], sign[19], addressnew + 0x280);
    OVERWRITE2BYTE(sign[20], sign[21], addressnew + 0x2D0);
    OVERWRITE2BYTE(sign[22], sign[23], addressnew + 0x320);
    OVERWRITE2BYTE(sign[24], sign[25], addressnew + 0x370);
    OVERWRITE2BYTE(sign[26], sign[27], addressnew + 0x3C0);
    OVERWRITE2BYTE(sign[28], sign[29], addressnew + 0x410);
    OVERWRITE2BYTE(sign[30], sign[31], addressnew + 0x460);
    OVERWRITE2BYTE(sign[32], sign[33], addressnew + 0x4B0);
}
//##########################################################################################################################################################

void Display::RemoveZeroSignBack(long addressold)
{
    CLEAR2BYTEBACK(addressold + 0x04F);
    CLEAR2BYTEBACK(addressold + 0x09F);
    CLEAR2BYTEBACK(addressold + 0x0EF);
    CLEAR2BYTEBACK(addressold + 0x13F);
    CLEAR2BYTEBACK(addressold + 0x18F);
    CLEAR2BYTEBACK(addressold + 0x1DF);
    CLEAR2BYTEBACK(addressold + 0x22F);
    CLEAR2BYTEBACK(addressold + 0x27F);
    CLEAR2BYTEBACK(addressold + 0x2CF);
    CLEAR2BYTEBACK(addressold + 0x31F);
    CLEAR2BYTEBACK(addressold + 0x36F);
    CLEAR2BYTEBACK(addressold + 0x3BF);
    CLEAR2BYTEBACK(addressold + 0x40F);
    CLEAR2BYTEBACK(addressold + 0x45F);
    CLEAR2BYTEBACK(addressold + 0x4AF);
    CLEAR2BYTEBACK(addressold + 0x4FF);
    CLEAR2BYTEBACK(addressold + 0x54F);
    CLEAR2BYTEBACK(addressold + 0x59F);
    CLEAR2BYTEBACK(addressold + 0x5EF);
    CLEAR2BYTEBACK(addressold + 0x63F);
    CLEAR2BYTEBACK(addressold + 0x68F);
    CLEAR2BYTEBACK(addressold + 0x6DF);
    CLEAR2BYTEBACK(addressold + 0x72F);
    CLEAR2BYTEBACK(addressold + 0x77F);
    CLEAR2BYTEBACK(addressold + 0x7CF);
    CLEAR2BYTEBACK(addressold + 0x81F);
    CLEAR2BYTEBACK(addressold + 0x86F);
    CLEAR2BYTEBACK(addressold + 0x8BF);
    CLEAR2BYTEBACK(addressold + 0x90F);
}
//##########################################################################################################################################################

void Display::DrawZeroSignBack(unsigned char *sign, long addressnew)
{
    WRITE2BYTEBACK(sign[2], sign[3], addressnew + 0x04F);
    WRITE2BYTEBACK(sign[4], sign[5], addressnew + 0x09F);
    WRITE2BYTEBACK(sign[6], sign[7], addressnew + 0x0EF);
    WRITE2BYTEBACK(sign[8], sign[9], addressnew + 0x13F);
    WRITE2BYTEBACK(sign[10], sign[11], addressnew + 0x18F);
    WRITE2BYTEBACK(sign[12], sign[13], addressnew + 0x1DF);
    WRITE2BYTEBACK(sign[14], sign[15], addressnew + 0x22F);
    WRITE2BYTEBACK(sign[16], sign[17], addressnew + 0x27F);
    WRITE2BYTEBACK(sign[18], sign[19], addressnew + 0x2CF);
    WRITE2BYTEBACK(sign[20], sign[21], addressnew + 0x31F);
    WRITE2BYTEBACK(sign[22], sign[23], addressnew + 0x36F);
    WRITE2BYTEBACK(sign[24], sign[25], addressnew + 0x3BF);
    WRITE2BYTEBACK(sign[26], sign[27], addressnew + 0x40F);
    WRITE2BYTEBACK(sign[28], sign[29], addressnew + 0x45F);
    WRITE2BYTEBACK(sign[30], sign[31], addressnew + 0x4AF);
    WRITE2BYTEBACK(sign[32], sign[33], addressnew + 0x4FF);
    WRITE2BYTEBACK(sign[34], sign[35], addressnew + 0x54F);
    WRITE2BYTEBACK(sign[36], sign[37], addressnew + 0x59F);
    WRITE2BYTEBACK(sign[38], sign[39], addressnew + 0x5EF);
    WRITE2BYTEBACK(sign[40], sign[41], addressnew + 0x63F);
    WRITE2BYTEBACK(sign[42], sign[43], addressnew + 0x68F);
    WRITE2BYTEBACK(sign[44], sign[45], addressnew + 0x6DF);
    WRITE2BYTEBACK(sign[46], sign[47], addressnew + 0x72F);
    WRITE2BYTEBACK(sign[48], sign[49], addressnew + 0x77F);
    WRITE2BYTEBACK(sign[50], sign[51], addressnew + 0x7CF);
    WRITE2BYTEBACK(sign[52], sign[53], addressnew + 0x81F);
    WRITE2BYTEBACK(sign[54], sign[55], addressnew + 0x86F);
    WRITE2BYTEBACK(sign[56], sign[57], addressnew + 0x8BF);
    WRITE2BYTEBACK(sign[58], sign[59], addressnew + 0x90F);
}
//##########################################################################################################################################################

void Display::CLEAR2BYTE(long addressold)
{
    asm("
  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 2

  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 3
		");	
}
//##########################################################################################################################################################

void Display::WRITE2BYTE(unsigned char byte1, unsigned char byte2, long addressnew)
{
    asm("
           FILL8	%r0, %i1             			
           ST8S		[%i2], %r0, 2
  				
           FILL8	%r0, %i0             			
           ST8S		[%i2], %r0, 3
		");	
}
//##########################################################################################################################################################

void Display::OVERWRITE2BYTE(unsigned char byte1, unsigned char byte2, long addressnew)
{
    asm("
           LD       %r0, [%i2]
           EXT8S    %r0, 2
           OR       %r0, %i1
           FILL8	%r0, %r0
           ST8S		[%i2], %r0, 2

           LD       %r0, [%i2]
           EXT8S    %r0, 3
           OR       %r0, %i0
           FILL8	%r0, %r0             			
           ST8S		[%i2], %r0, 3
		");	
}
//######################################################################sn####################################################################################

void Display::CLEAR2BYTEBACK(long addressold)
{
    asm("
  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 0

  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 1
		");	
}
//##########################################################################################################################################################

void Display::WRITE2BYTEBACK(unsigned char byte1, unsigned char byte2, long addressnew)
{
    asm("
           FILL8	%r0, %i1             			
           ST8S		[%i2], %r0, 0
  				
           FILL8	%r0, %i0             			
           ST8S		[%i2], %r0, 1
		");	
}
//##########################################################################################################################################################
/*
void Display::DRAWZEROPOPUP(int channel)
{
	int x, y;
	int pos = 0;
	int volt = 0;
	
	
	float voltoff = 0;
	char voltstrn[20];
	char voltunit[3] = "uV";	
	
	unsigned char PixelBuffer;

	double factor = 0;
	double ffactor = 0;	
	
	short *fprobe = 0;
	int *fzeropos = 0;
	volatile char *fselected_voltage = 0;
	
	Hardware::ResetTimer3();

	switch (channel)
	{
		case 1:
		{
			fprobe = &MenuStatus[1][3];
			fselected_voltage = &Selected_Voltage_CH1;
			fzeropos = &ZeroLevelCH1;			
			break;
		}	
		case 2:
		{
			fprobe = &MenuStatus[2][3];
			fselected_voltage = &Selected_Voltage_CH2;
			fzeropos = &ZeroLevelCH2;
			break;
		}
		case 3:
		{
			fprobe = &MenuStatus[3][3];
			fselected_voltage = &Selected_Voltage_CH3;
			fzeropos = &ZeroLevelCH3;
			break;
		}
		case 4:
		{
			fprobe = &MenuStatus[4][3];
			fselected_voltage = &Selected_Voltage_CH4;
			fzeropos = &ZeroLevelCH4;
			break;
		}
	}
	
	if ((channel != dzp_channel_buf) || (*fprobe != dzp_fprobe_buf) || (*fselected_voltage != dzp_fselected_voltage_buf))
	{								
		switch((int) *fselected_voltage)
		{
			case 0:	 factor = 20.833333; break;
			case 1:	 factor = 41.666666; break;
			case 2:	 factor = 104.166666; break;
			case 3:	 factor = 208.333333; break;
			case 4:	 factor = 416.666666; break;
			case 5:	 factor = 1041.666666; break;
			case 6:	 factor = 2083.33333; break;
			case 7:	 factor = 4166.66666; break;
			case 8:	 factor = 10416.6666; break;
			case 9:	 factor = 20833.3333; break;
			case 10: factor = 41666.6666; break;
			case 11: factor = 104166.66; break;																						
		}

		switch ((int) *fprobe)
		{
			case 101: ffactor = 10000000; break;
			case 102: ffactor = 5000000; break;
			case 103: ffactor = 2000000; break;
			case 104: ffactor = 1000000; break;
			case 105: ffactor = 500000; break;
			case 106: ffactor = 200000; break;
			case 107: ffactor = 100000; break;
			case 108: ffactor = 50000; break;
			case 109: ffactor = 20000; break;
			case 110: ffactor = 10000; break;
			case 111: ffactor = 5000; break;
			case 112: ffactor = 2000; break;
			case 113: ffactor = 1000; break;
		}
			
		factor = factor / ffactor;
		
		dzp_factor_buf = factor;
		dzp_channel_buf = channel;
		dzp_fprobe_buf = *fprobe;
		dzp_fselected_voltage_buf = *fselected_voltage;
	}
	else factor = dzp_factor_buf;
		
// BF del	voltoff =  (float)(*fzeropos - 0xC0) * factor;  // Mitte ist (GRID_HEIGHT / 2) (0xC0) =>  Mitte 128 (0x80) * 1.5
	
	voltoff =  (float)(*fzeropos - (GRID_HEIGHT / 2)) * factor;  // Mitte ist (GRID_HEIGHT / 2) BF
				
	switch (channel)
	{
		case 1:			
		{
			Zero_Level1_Str.Write_Value(voltoff);	
			Zero_Level1_Str.RenderText();
			break;
		}
		case 2:	
		{
			Zero_Level2_Str.Write_Value(voltoff);	
			Zero_Level2_Str.RenderText();
			break;
		}
		case 3:			
		{
			Zero_Level3_Str.Write_Value(voltoff);	
			Zero_Level3_Str.RenderText();
			break;
		}
		case 4:			
		{
			Zero_Level4_Str.Write_Value(voltoff);	
			Zero_Level4_Str.RenderText();
			break;
		}
	}	
	if (ZeroPopupChanged == 0)
	{
		//Rect(450, 51, 160, 22, 1, UI_Plane1);	
		//Rect(450, 51, 160, 22, 1, Buffer_UI2Plane);
		
		DRAWROUNDBUTTON(447, 51, 166, 25, btnUnpushed, btnDraw);
		
	}
	else Rect(460, 51, 150, 21, 0, UI_Plane2);
	
	ZeroPopupChanged = 1;		
	
	switch (channel)
	{
		case 1:	TEXTOUTxvbig(Zero_Level1_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text	
		case 2:	TEXTOUTxvbig(Zero_Level2_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text	
		case 3:	TEXTOUTxvbig(Zero_Level3_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text	
		case 4:	TEXTOUTxvbig(Zero_Level4_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text
	}
	//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
}
//##########################################################################################################################################################

void Display::DRAWZEROPOPDOWN(void)
{
	char Ct;
	
	int xa = 50 * 20;
	
	for (Ct = 0; Ct < 24; Ct++)
	{			
		*(UI_Plane1 + xa + 14) = 0;
		*(UI_Plane1 + xa + 15) = 0; 
		*(UI_Plane1 + xa + 16) = 0; 
		*(UI_Plane1 + xa + 17) = 0; 
		*(UI_Plane1 + xa + 18) = 0; 
		*(UI_Plane1 + xa + 19) = *(UI_Plane1 + xa + 19) & 0x0000000F;

		*(Buffer_UI2Plane + xa + 14) = 0;
		*(Buffer_UI2Plane + xa + 15) = 0;
		*(Buffer_UI2Plane + xa + 16) = 0;
		*(Buffer_UI2Plane + xa + 17) = 0;
		*(Buffer_UI2Plane + xa + 18) = 0;
		*(Buffer_UI2Plane + xa + 19) = *(Buffer_UI2Plane + xa + 19) & 0x0000000F;

		*(UI_Plane3 + xa + 14) = 0;
		*(UI_Plane3 + xa + 15) = 0;
		*(UI_Plane3 + xa + 16) = 0;
		*(UI_Plane3 + xa + 17) = 0;
		*(UI_Plane3 + xa + 18) = 0;
		*(UI_Plane3 + xa + 19) = *(UI_Plane3 + xa + 19) & 0x0000000F;

		*(UI_Plane4 + xa + 14) = 0;
		*(UI_Plane4 + xa + 15) = 0;
		*(UI_Plane4 + xa + 16) = 0;
		*(UI_Plane4 + xa + 17) = 0;
		*(UI_Plane4 + xa + 18) = 0;
		*(UI_Plane4 + xa + 19) = *(UI_Plane4 + xa + 19) & 0x0000000F;

		*(UI_Plane5 + xa + 14) = 0;
		*(UI_Plane5 + xa + 15) = 0;
		*(UI_Plane5 + xa + 16) = 0;
		*(UI_Plane5 + xa + 17) = 0;
		*(UI_Plane5 + xa + 18) = 0;
		*(UI_Plane5 + xa + 19) = *(UI_Plane5 + xa + 19) & 0x0000000F;
		xa += 20;
	}	
	ZeroPopupChanged = 0;
	UpdateMenuTextPlane = true;
}
*/
//##########################################################################################################################################################
//BF completly redesigned
void Display::DrawSignals(void)	// Draw all active signals
{
	unsigned char *lPtr_Signal     = NULL;
	unsigned char *lPtr_SigIntpol  = NULL;
	unsigned char *lPtr_SigIntpDel = NULL;
	//unsigned char lvector = 0;

	//BF test if(UI_request) return;   //if interrupt from user interface occured don't draw signals

	//if (!Run && !SingleMode)
	//return;

	if(ZL_changed) UI_request = 0;			// if zero level changed the affected channel must be drawn

	if(Run && (!ACQ_NewData || UI_request)) 	// drawing only when new data are available and no UI-request occured
	return;

	ACQ_NewData = 0;

	//BF speed test
	FrameCount++;
	//printf("FCnt = %d\r",FrameCount);

	//---------------------------------------------------------------------------------------------------------------------------------------	
	//                                     draw x/y signal
	//---------------------------------------------------------------------------------------------------------------------------------------	
	if (XY_Mode)
	{ 
		if (Channel_1_Active && Channel_2_Active && !UI_request)
		{
			if ((MainTimebase + VirtualTimebase) < 4 || USTB_Mode != USTB_OFF) //Timebase 20nS & 10nS & 5nS & 2nS
			{ DRAWSIGNAL_XY( 1, 2, draw_start, SIGNAL1_Intpolate, SIGNAL2_Intpolate); }
			else
			{ DRAWSIGNAL_XY( 1, 2, draw_start, S1Ptr, S2Ptr); }
			
			DrawPlane = 0x01;
		}
		
		if (Channel_3_Active && Channel_4_Active && !UI_request)
		{
			if ((MainTimebase + VirtualTimebase) < 4 || USTB_Mode != USTB_OFF)  //Timebase 20nS & 10nS & 5nS & 2nS
			{ DRAWSIGNAL_XY( 3, 4, draw_start, SIGNAL3_Intpolate, SIGNAL4_Intpolate); }
			else
			{ DRAWSIGNAL_XY( 3, 4, draw_start, S3Ptr, S4Ptr); }

			DrawPlane = 0x04;
		}

		ClearPlane = DrawPlane | RemovePlane;
        	DrawPlane = 0;

		return;
	}

	//---------------------------------------------------------------------------------------------------------------------------------------	
	//                                  draw f/y spectrum (FFT)
	//---------------------------------------------------------------------------------------------------------------------------------------	
	if (FFT_Mode != FFT_OFF)
	{ 
		if(FFT_NewData || !Run)
		{ DRAWSPECTRUM_FY(); FFT_NewData = 0; }

		//set drawing planes for plane transfer
		if (Channel_1_Active) DrawPlane = 0x01;	
		else if (Channel_2_Active) DrawPlane = 0x02;	
		else if (Channel_3_Active) DrawPlane = 0x04;	
		else if (Channel_4_Active) DrawPlane = 0x08;
	
	        ClearPlane = DrawPlane | RemovePlane;
	        DrawPlane = 0x00;	
		return;
	}

	//---------------------------------------------------------------------------------------------------------------------------------------	
	//                            draw time signal t/y of active channels one after another
	//---------------------------------------------------------------------------------------------------------------------------------------	
	DrawPlane = 0x00;

//printf("drawing signal \n\r");	

	for (unsigned char lv_channel = 1 ; lv_channel <= 5 ; lv_channel ++ )
	{


      		if(ZL_changed && (ZL_changed != lv_channel))	// skip drawing if zero level changed but don't match the channel
        	continue;

 		if(UI_request)  				//if UI interrupt occured don't draw next signals
        	{ 
	  		ClearPlane = DrawPlane;
	        	DrawPlane = 0;
			return;
		}

		switch (lv_channel)
		{
			case 1: if(Channel_1_Active)
				{ lPtr_Signal = S1Ptr; lPtr_SigIntpol = SIGNAL1_Intpolate; lPtr_SigIntpDel = SIGNAL1_Intpolate_delayed; DrawPlane |= 0x01;}
				else continue; break;
			case 2: if(Channel_2_Active)
				{ lPtr_Signal = S2Ptr; lPtr_SigIntpol = SIGNAL2_Intpolate; lPtr_SigIntpDel = SIGNAL2_Intpolate_delayed; DrawPlane |= 0x02;}
				else continue; break;
			case 3: if(Channel_3_Active)
				{ lPtr_Signal = S3Ptr; lPtr_SigIntpol = SIGNAL3_Intpolate; lPtr_SigIntpDel = SIGNAL3_Intpolate_delayed; DrawPlane |= 0x04;}
				else continue; break;
			case 4: if(Channel_4_Active)
				{ lPtr_Signal = S4Ptr; lPtr_SigIntpol = SIGNAL4_Intpolate; lPtr_SigIntpDel = SIGNAL4_Intpolate_delayed; DrawPlane |= 0x08;}
				else continue; break;
			case 5: if(Channel_Math_Active)
				{ lPtr_Signal = SMPtr; lPtr_SigIntpol = SIGNALM_Intpolate; lPtr_SigIntpDel = SIGNALM_Intpolate_delayed; DrawPlane |= 0x10;}
				else continue; break;
		}

		if (NoDisplay[lv_channel-1]) continue;		// don't display this channel

		//-------------------------------------------------
		//draw T-Y time signal
		//-------------------------------------------------
		if ((MainTimebase + VirtualTimebase) < 4) 							//Timebase 20nS & 10nS & 5nS -> interpolated timebases
		{
			DRAWSIGNAL_TY(lv_channel, 1, draw_factor, draw_start, lPtr_SigIntpol);			//Draw main Signal (in delayed mode into top window (window = 1)

			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//Delayed mode -> draw into bottom window (window = 2)
			{ DRAWSIGNAL_TY(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lPtr_SigIntpDel); }
		}
		else //if ((MainTimebase + VirtualTimebase) >= 4)						//Timebase >= 50nS
		{
			DRAWSIGNAL_TY(lv_channel, 1, draw_factor, draw_start, lPtr_Signal);			//Draw main Signal (in delayed mode into top window (window = 1)
			
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON && USTB_Mode == USTB_OFF)			//Delayed mode -> draw into bottom window (window = 2)
			{
				if (ZoomFactorDel < 1)								//delayed timebase 20ns & 10ns & 5 ns
				{ DRAWSIGNAL_TY(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lPtr_SigIntpDel); }
				else										//delayed timebase >= 50ns
				{ DRAWSIGNAL_TY(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lPtr_Signal); }
			}
		}

		if (ZL_changed == lv_channel)									// if zerolevel changed, only draw the corresponding plane
        	{ ZL_changed = 0; break; }

	} //Channel loop end

       	ClearPlane = DrawPlane;	// | RemovePlane;
        DrawPlane = 0x00;	

	if (USTB_Mode != USTB_OFF)
	{
		DRAW_ALL_CURSOR();			// draw USTB-index position
		if (Memory_Window_visible) 		// if Memory Window visible
		DRAWMEMORY(0, 0, 1); 			// redraw Memory Window
	}

	if (Channel_Math_Active && Memory_Window_visible)
	Rect(106, 33, 430, 17, 0, Buffer_PlaneM);				// delete math layer under the browser


	if ((QM_Enabled) && (QM_Type[0] > 0)) Display::CALCQMDATA();


}

//##########################################################################################################################################################
/* BF del not used
void Display::Clear_Flips(void)
{
    return;

    if (screen_sel == 0)
    {
        if (NumberOfChannels == 2) Hardware::Planes_clear_asm_all(3, 0x009311F0, 0x0093A7F0, 0x009569F0, 0x00000000, 0x00000000);
        else Hardware::Planes_clear_asm_all(5, 0x009311F0, 0x0093A7F0, 0x00943DF0, 0x0094D3F0, 0x009569F0);
    }
    else
    {
        if (NumberOfChannels == 2) Hardware::Planes_clear_asm_all(3, 0x0098EDF0, 0x009983F0, 0x009B45F0, 0x00000000, 0x00000000);
        else Hardware::Planes_clear_asm_all(5, 0x0098EDF0, 0x009983F0, 0x009A19F0, 0x009AAFF0, 0x009B45F0);
    }
    if (Debug_Mode) printf("clear flips\n");
} */
//##########################################################################################################################################################

/* BF del not used
//void Display::CopySignal(unsigned long *Buffer_Adr1, unsigned long *Plane_Adr1, unsigned long *Buffer_Adr2, unsigned long *Plane_Adr2, unsigned long *Buffer_Adr3, unsigned long *Plane_Adr3, unsigned char count)
void Display::CopySignal(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
    return;

	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)

                    loopcs1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)
	
                    loopcs2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)
	
                    loopcs3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)

                    loopcs4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)

                    loopcs5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs5
                    NOP 	
                ");
            break;
        }
    }
}
*/

//##########################################################################################################################################################

// Draw Time Signal on T-Y axis		BF -> complete new drawing routine for all time signals incl. delayed signals
void Display::DRAWSIGNAL_TY(unsigned int channel, unsigned char windows, unsigned int timefactor, unsigned int ixstart, unsigned char *signal)
{
	short lZeroLevel = (GRID_HEIGHT / 2) + GRID_YOFFS;	//drawing zero is in the middle of the grid
;
//	int   alpha_cor = 0;
//	float beta_cor  = 1;

	unsigned long *plane = NULL;

	short P1 = 0;
	short P2 = 0;
	short P3 = 0;	

	short factor_buff = timefactor;	
	short display_min;
	short display_max;
	
	int   lix = ixstart; 		//signal index
	int   lposx = GRID_XOFFS;	//grid position

	unsigned char lInterpol = 0;

        char ltoggle = 0, lDelayedShiftFactor = 0;

	int lScaleIndex = 0;

	//----------------------------------------
	//set channel depending parameters
	//----------------------------------------
	if (channel == 1)
	{	
		plane = Buffer_Plane1;						// pointer to buffer layer of channel 1
		//plane = Channel_Plane1;					// pointer to display layer of channel 1
		
		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH1];		//get voltage range depending scale index
	}	
	else if (channel == 2)
	{	
		plane = Buffer_Plane2;						// pointer to buffer layer of channel 2
		//plane = Channel_Plane2;					// pointer to display layer of channel 2

		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH2];		//get voltage range depending scale index
	}
	else if (channel == 3)
	{		
		plane = Buffer_Plane3;						// pointer to buffer layer of channel 3
		//plane = Channel_Plane3;					// pointer to display layer of channel 3

		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH3];		//get voltage range depending scale index
	}
	else if (channel == 4)
	{	
		plane = Buffer_Plane4;						// pointer to buffer layer of channel 4
		//plane = Channel_Plane4;					// pointer to display layer of channel 4

		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH4];		//get voltage range depending scale index
	}		
	else if (channel == 5)	//Math
	{	
		plane     = Buffer_PlaneM;					// pointer to buffer layer of math channel
		//plane     = Channel_Math_Plane;				// pointer to display layer of math channel

		lScaleIndex = ScaleIndexTable[math_scale];
		lZeroLevel -= Math_Offset;					// calc drawing offset for math channel
	}

//printf("drawing channel %d \n\r", channel);



	//----------------------------------
	//Set drawing parameters
	//----------------------------------
	if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed mode
	{
		lDelayedShiftFactor = 1;
		
		if (windows == 1)	//draw main signal into upper delayed grid area
		{
			lZeroLevel = ((lZeroLevel - GRID_YOFFS) >> 1) + GRID_YOFFS;
			
			display_min = GRID_YOFFS;
			display_max = ((GRID_HEIGHT >> 1) - 2) + GRID_YOFFS;
		}
		else	//draw delayed signal into bottom grid area
		{
			lZeroLevel = ((lZeroLevel - GRID_YOFFS) >> 1) + (GRID_HEIGHT / 2) + GRID_YOFFS;
			
			display_min = ((GRID_HEIGHT >> 1) + 2) + GRID_YOFFS;
			display_max = GRID_HEIGHT + GRID_YOFFS;

			//if special case time factor 2.5 occurs -> switch toggle mode on
			if (ZoomFactorDel == 2.5){ ltoggle = 1;} 
		}
	}
	else	//Main mode
	{
		display_min = GRID_YOFFS;
		display_max = GRID_HEIGHT + GRID_YOFFS;	
	}

	//factor (time factor) is the step width of the loop index and must be minimum 1
	if(timefactor <= 0)
	{ timefactor = 1; }


//--------------------------------------------------------------------------------------------------------
//                         Signal drawing with vector or points
//--------------------------------------------------------------------------------------------------------

	
	//-----------------------------------------------------------
	// pixel connection drawing routine - fastest drawing
	//-----------------------------------------------------------
	if(MenuStatus[MENU_DISPLAY][4] == DRAW_FAST) //&& USTB_Mode == USTB_OFF)
	{
	
		//Get ADC-value of starting point and calculate correction, scaling and Y-positioning
		P2 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);
		lix += timefactor;
		P3 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);

		//limiter
		if (P2 > display_max) P2 = display_max;
		if (P2 < display_min) P2 = display_min;
		if (P3 > display_max) P3 = display_max;
		if (P3 < display_min) P3 = display_min;

		if (ltoggle)	//factor 2.5
		{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}
	
		//draw signal
		for (lix += timefactor; (lposx - GRID_XOFFS) < GRID_WIDTH-1; lix += timefactor)
		{
			lposx++;
	
			if (ltoggle)	//factor 2.5
			{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}

			P1 = P2;
			P2 = P3;
	
			//get next ADC-value, scaling and Y-positioning
			P3 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);

			//limiter
			if (P3 > display_max) P3 = display_max;
			if (P3 < display_min) P3 = display_min;

					
			//-----------------------------------------------------------
			//		Draw lines
			//-----------------------------------------------------------
			//Fall 1   ( 1 == 2 == 3 )
			if ((P1 == P2) && (P2 == P3))
			{ PixelOn(lposx, P1, plane); }
	
			//Fall 2   ( 1 < 2 < 3 )
			else if ((P1 < P2) && (P2 < P3))
			{ Connect_Pixels(lposx, P1, P2, 1, plane); }	
		
			//Fall 3   ( 1 > 2 > 3 )
			else if ((P1 > P2) && (P2 > P3))
			{ Connect_Pixels(lposx, P1, P2, 0, plane); }	
		
			//Fall 4   ( 1 < 2 = 3 )
			else if ((P1 < P2) && (P2 == P3))
			{ Connect_Pixels(lposx, P1, P2, 1, plane); }	
			
			//Fall 5   ( 1 > 2 = 3 )
			else if ((P1 > P2) && (P2 == P3))
			{ Connect_Pixels(lposx, P1, P2, 0, plane); }
			
			//Fall 6   ( 1 = 2 < 3 )
			else if ((P1 == P2) && (P2 < P3))
			{ PixelOn(lposx, P1, plane); }	
			
			//Fall 7   ( 1 = 2 > 3 )
			else if ((P1 == P2) && (P2 > P3))
			{ PixelOn(lposx, P1, plane); }	
		
			//Fall 8   ( 1 > 2 < 3 )
			else if ((P1 > P2) && (P2 < P3))
			{ Connect_Pixels(lposx, P1, P2, 0, plane); }	
			
			//Fall 9   ( 1 < 2 > 3 )
			else if ((P1 < P2) && (P2 > P3))
			{ Connect_Pixels(lposx, P1, P2, 1, plane); }	
			else //-> Fall 1
			{ PixelOn(lposx, P1, plane); }	
		}	
	
	}


	//---------------------------------------------------------------------
	// Line drawing with standard line function - 
	// new line() function which is nearly as fast as the pixel connection 
	// routine but shows more details
	//---------------------------------------------------------------------
	else if(MenuStatus[MENU_DISPLAY][4] == DRAW_ACC) //&& USTB_Mode == USTB_OFF)
	{
		
		//+++++++++++++++++ draw signal as vector line ++++++++++++++++++


		//Get ADC-value of starting point and calculate correction, scaling and Y-positioning
		P1 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);
		lix += timefactor;
		P2 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);


		//limiter
		if (P1 > display_max) P1 = display_max;
		if (P1 < display_min) P1 = display_min;
		if (P2 > display_max) P2 = display_max;
		if (P2 < display_min) P2 = display_min;

		if (ltoggle)	//factor 2.5
		{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}

		//draw signal
		for (lix += timefactor; (lposx - GRID_XOFFS) < GRID_WIDTH-1; lix += timefactor)
		{
			lposx++;
			
			if (ltoggle)	//toggle faktor between 2 and 3 to simulate 2,5
			{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}

			P1 = P2;

			//get next ADC-value, scaling and Y-positioning
			P2 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);


			//limiter
			if (P2 > display_max)
			{	
				if (P3 > display_max)		// if hole line segment is out of range -> don't draw
				{ P3 = P2; continue; }
				else				// if only one end of the line segment is out of range -> limiting
				{ P3 = P2; P2 = display_max; }
			}
			else if (P2 < display_min)
			{	
				if (P3 < display_min)		// if hole line segment is out of range -> don't draw
				{ P3 = P2; continue; }
				else				// if only one end of the line segment is out of range -> limiting
				{ P3 = P2; P2 = display_min; }
			}
			else
			P3 = P2;				// remember the value
	
			//-----------------------------------------------------------
			//		Draw lines
			//-----------------------------------------------------------
			//DRAWLINEP(X1, Y1, X2, Y2, on, plane);
			Line(lposx, P1, lposx + 1, P2, plane);
		}


	}
	else
	{
	//+++++++++++++ draw only single points +++++++++++++
	//BF -> in interpolated TB drop the interpolated values

		if ((MainTimebase + VirtualTimebase) == 3)
		lInterpol = 2;
		else if ((MainTimebase + VirtualTimebase) == 2)
		lInterpol = 4;
		else if ((MainTimebase + VirtualTimebase) == 1)
		lInterpol = 9;
		else if ((MainTimebase + VirtualTimebase) == 0)
		lInterpol = 24;
		else
		lInterpol = 0;

		char ip;

		for (ip=0; (lposx - GRID_XOFFS) < (GRID_WIDTH-1); lix += timefactor, ip--)
		{
			lposx++;
			
			if (ltoggle)	//toggle faktor between 2 and 3 to simulate 2,5
			{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}

			if (ip<=0)
			{
				if (lInterpol == 2)	//toggle faktor between 1 and 2 to simulate 1,5
				lInterpol = 1;
				if (lInterpol == 1)
				lInterpol = 2;

				ip = lInterpol;

				//get next ADC-value, scaling and Y-positioning
				P1 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);

				// if pixel is out of range -> don't draw
				if (P1 > display_max) continue;
				if (P1 < display_min) continue;
			
				PixelOn(lposx, P1, plane);
			}
		}
	}




}
//##########################################################################################################################################################
//BF complete new routine and interface
void Display::DRAWSIGNAL_XY(int channel_x, int channel_y, unsigned int start, unsigned char *signal_x, unsigned char *signal_y)
{
	int lsix,ldix; //Signal index and draw index

    	short lX_Ampl1, lX_Ampl2;
	short lY_Ampl1, lY_Ampl2;

	short ZeroLevel_X, ZeroLevel_Y;
	short display_X_max = GRID_XY_XOFFS + GRID_XY - 1;
	short display_Y_max = GRID_YOFFS + GRID_XY - 1;
	short display_X_min = GRID_XY_XOFFS + 1;
	short display_Y_min = GRID_YOFFS + 1;

	int lX_ScaleIndex = 0;
	int lY_ScaleIndex = 0;

	unsigned long *lp_plane = NULL;

	
	if (channel_x == 1)
	{	
    		lp_plane = Buffer_Plane1;	//yellow
		//ZeroLevel_X = GRID_XY_XOFFS + ZeroLevelCH1; 
		//ZeroLevel_Y = GRID_YOFFS + ZeroLevelCH2;
	}
	else
	{
		lp_plane = Buffer_Plane3;	//blue
		//ZeroLevel_X = GRID_XY_XOFFS + ZeroLevelCH3; 
		//ZeroLevel_Y = GRID_YOFFS + ZeroLevelCH4;
	}

	ZeroLevel_X = GRID_XY_XOFFS + (GRID_XY / 2); 
	ZeroLevel_Y = GRID_YOFFS + (GRID_XY / 2);

	// calculate amplitude scaling index for each Channel
	switch (channel_x)
	{	
		case 1: { lX_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH1]; break;}
		case 2: { lX_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH2]; break;}
		case 3: { lX_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH3]; break;}
		case 4: { lX_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH4]; break;}
	}	
	switch (channel_y)
	{	
		case 1: { lY_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH1]; break;}
		case 2: { lY_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH2]; break;}
		case 3: { lY_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH3]; break;}
		case 4: { lY_ScaleIndex = ScaleIndexTable[Selected_Voltage_CH4]; break;}
	}	


	if (MenuStatus[MENU_DISPLAY][3] == DRAW_PIX)	//draw single pixels
	{
		//now process the following values
		for (ldix = 0, lsix = start;(ldix < GRID_WIDTH) && !UI_request;ldix++, lsix += draw_factor)
		{
			//read next X and Y value, scaling and positioning 
			lX_Ampl1 = ZeroLevel_X - ScaleLookupTable[signal_x[lsix]][lX_ScaleIndex];
			lY_Ampl1 = ZeroLevel_Y + ScaleLookupTable[signal_y[lsix]][lY_ScaleIndex];

			//limiter
			if (lX_Ampl1 > display_X_max) lX_Ampl1 = display_X_max;
			if (lY_Ampl1 > display_Y_max) lY_Ampl1 = display_Y_max;
			if (lX_Ampl1 < display_X_min) lX_Ampl1 = display_X_min;
			if (lY_Ampl1 < display_Y_min) lY_Ampl1 = display_Y_min;

			PixelOn(lX_Ampl1, lY_Ampl1, lp_plane);
		}
	}
	else	// vector drawing
	{
		//initialize start values beginning with the second value because it will become the new starting point
		lsix = start;

		//scaling and positioning starting points
		lX_Ampl2 = ZeroLevel_X - ScaleLookupTable[signal_x[lsix]][lX_ScaleIndex];
		lY_Ampl2 = ZeroLevel_Y + ScaleLookupTable[signal_y[lsix]][lY_ScaleIndex];


		//limiter
		if (lX_Ampl2 > display_X_max) lX_Ampl2 = display_X_max;
		if (lY_Ampl2 > display_Y_max) lY_Ampl2 = display_Y_max;
		
		if (lX_Ampl2 < display_X_min) lX_Ampl2 = display_X_min;
		if (lY_Ampl2 < display_Y_min) lY_Ampl2 = display_Y_min;
		
		//now process the following values
		for (ldix = 0 , lsix += draw_factor;(ldix < GRID_WIDTH) && !UI_request;ldix++, lsix += draw_factor)
		{
			//the new start point is the old end point
			lX_Ampl1 = lX_Ampl2;
			lY_Ampl1 = lY_Ampl2;

			//read next X and Y value, scaling and positioning 
			lX_Ampl2 = ZeroLevel_X - ScaleLookupTable[signal_x[lsix]][lX_ScaleIndex];
			lY_Ampl2 = ZeroLevel_Y + ScaleLookupTable[signal_y[lsix]][lY_ScaleIndex];

			//limiter
			if (lX_Ampl2 > display_X_max) lX_Ampl2 = display_X_max;
			if (lY_Ampl2 > display_Y_max) lY_Ampl2 = display_Y_max;
			if (lX_Ampl2 < display_X_min) lX_Ampl2 = display_X_min;
			if (lY_Ampl2 < display_Y_min) lY_Ampl2 = display_Y_min;

			Line(lX_Ampl1, lY_Ampl1, lX_Ampl2, lY_Ampl2, lp_plane);
		}
	}


}
//##########################################################################################################################################################
//BF Draw spectral analysis
void Display::DRAWSPECTRUM_FY(void)
{
	int   lZeroLevel     = GRID_HEIGHT_FFT + GRID_YOFFS_FFT + 1;	//gridline is zero -> no signal output
	int   lSignalStart   = GRID_HEIGHT_FFT + GRID_YOFFS_FFT;	//first pixel position
	unsigned long *plane = NULL;

	int   lY = 0;		//amplitude / y position
	int   li = 0; 		//signal index
	int   lX = 0;		//x position

	int lScaleIndex = 0;


//printf("\r\ndraw FFT\r\n");

	//----------------------------------------
	//set channel depending parameters
	//----------------------------------------

	//get scaling index of active channel
	if(Channel_1_Active)
	{ 	
		plane = Buffer_Plane1;		//Calculate scaling factor
		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH1];
	}
	else if(Channel_2_Active)
	{ 
		plane = Buffer_Plane2;
		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH2];
 	}
	else if(Channel_3_Active)
	{ 
		plane = Buffer_Plane3;
		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH3];
	}
	else if(Channel_4_Active)
	{ 
		plane = Buffer_Plane4;
		lScaleIndex = ScaleIndexTable[Selected_Voltage_CH4];
	}

//----------------------------------------------------------------------------------------
//                   draw spectrum
//----------------------------------------------------------------------------------------

	lX = GRID_XOFFS_FFT;

	for (li = 0; (lX - GRID_XOFFS_FFT) < (GRID_WIDTH_FFT - 1); li ++)
	{
		lX++;

		//if(lScale_Int_Factor == 0)
//		if(FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
//		lY = lZeroLevel - SPECTRUM[li]; 	//without scaling - prescaled
//		else
		{
			//index limiter
			if (SPECTRUM[li] > 255) SPECTRUM[li] = 255;

			//scaling via lookup table
			lY = lZeroLevel - FFT_ScaleLookupTable[SPECTRUM[li]];

		}	

		// limiter
		if (lY >= lZeroLevel) continue;
		if (lY < GRID_YOFFS_FFT) lY = GRID_YOFFS_FFT;
			
		// Draw line
		if(lSignalStart > lY)
		Connect_Pixels(lX, (short)lZeroLevel, (short)lY,  0, plane);
		else
		{ PixelOn(lX, (short)lY, plane); }	
	}

}

//##########################################################################################################################################################

void Display::Test_Pixels(int x, int y, int y2, int dir, unsigned long *planeaddress)
{
    asm("
             MOV	%r1, %i0                       ; Load X to %r1

             MOV	%r2, %i0                       ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i1                       ; Load Y to %r3

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             ;MOV	%r4, %i4                       ; Load BufferAddress to %r4

             PFX	%hi(0x0093A200)                ; Load BufferAddress
             MOVI	%r4,%lo(0x0093A200)
             PFX	%xhi(0x0093A200)
             MOVHI	%r4,%xlo(0x0093A200)

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x80000000)                ; Load bitmask
             MOVI	%r5,%lo(0x80000000)
             PFX	%xhi(0x80000000)
             MOVHI	%r5,%xlo(0x80000000)

             LSR    %r5, %r1                       ; Calculate Bit to set


             MOV	%r6, %i2                       ; Load End Y to %r6

             SUB    %r6, %i1                       ; Get the Difference

             cp_loop4:

             LD     %r0, [%r4]                     ; Load Value from Memory
             OR     %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop4                       ; Jump to Loop
             NOP

         ");
}

//##########################################################################################################################################################

void Display::DrawColorDemoBox(int posx, int posy, int sizex, int sizey, unsigned long *planeaddress)							
{
    int x;

	for (x = 0; x <= sizex; x++)
	{  Connect_Pixels(posx + x, posy, posy + sizey, 1, planeaddress); }
}
//##########################################################################################################################################################

void Display::ColorDemo(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}	


    // All Colors
	for (x = 0; x < 15; x++)
	{
	    DrawColorDemoBox(x * 40, 0, 39, 39, (unsigned long *) (0x0095FA00 + (x * 0x00009600)));
	}

    // UI Blocks
	for (x = 0; x < 5; x++)
	{
	    DrawColorDemoBox(x * 128, 40, 127, 37, (unsigned long *) (0x0095FA00 + (x * 0x00009600)));
	}
	
	// UI Mix 1
	DrawColorDemoBox(0, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(32, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox(64, 46, 32, 27, UI_Plane4);
	DrawColorDemoBox(96, 46, 32, 27, UI_Plane5);
	
	// UI Mix 2
	DrawColorDemoBox(128, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(160, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox((GRID_HEIGHT / 2), 46, 32, 27, UI_Plane4);
	DrawColorDemoBox(224, 46, 32, 27, UI_Plane5);

	// UI Mix 3
	DrawColorDemoBox(256, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(288, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(320, 46, 32, 27, UI_Plane4);
	DrawColorDemoBox(352, 46, 32, 27, UI_Plane5);

	// UI Mix 4
	DrawColorDemoBox(GRID_HEIGHT, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(416, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(448, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox(480, 46, 32, 27, UI_Plane5);

	// UI Mix 5
	DrawColorDemoBox(512, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(544, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(576, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox(608, 46, 32, 27, UI_Plane4);
	
	// Channel 4 remix
	DrawColorDemoBox(0, 70, 639, 9, Channel_Plane4);
	
	
	Connect_Pixels(123, 210, 220, 1, UI_Plane1);
	Connect_Pixels(123, 220, 230, 1, UI_Plane2);
	Connect_Pixels(123, 230, 240, 1, UI_Plane3);
	Connect_Pixels(123, 240, 250, 1, UI_Plane4);
	Connect_Pixels(123, 250, 260, 1, UI_Plane5);
	Connect_Pixels(123, 260, 270, 1, Channel_Plane1);
	Connect_Pixels(123, 270, 280, 1, Channel_Plane2);
	Connect_Pixels(123, 280, 290, 1, Channel_Plane3);
	Connect_Pixels(123, 290, 300, 1, Channel_Plane4);
	Connect_Pixels(123, 300, 310, 1, Channel_Math_Plane);
//	Connect_Pixels(123, 310, 320, 1, Memory_Plane1);
//	Connect_Pixels(123, 320, 330, 1, Memory_Plane2);
//	Connect_Pixels(123, 330, 340, 1, Memory_Plane3);
	Connect_Pixels(123, 340, 350, 1, Marker_Plane1);
	Connect_Pixels(123, 350, 360, 1, Marker_Plane2);
	Connect_Pixels(123, 360, 370, 1, Grid_Plane);
	
	DRAWLINEP(223, 210, 232, 210, 1, UI_Plane1);
	DRAWLINEP(223, 211, 232, 211, 1, UI_Plane2);
	DRAWLINEP(223, 212, 232, 212, 1, UI_Plane3);
	DRAWLINEP(223, 213, 232, 213, 1, UI_Plane4);
	DRAWLINEP(223, 214, 232, 214, 1, UI_Plane5);
	DRAWLINEP(223, 215, 232, 215, 1, Channel_Plane1);
	DRAWLINEP(223, 216, 232, 216, 1, Channel_Plane2);
	DRAWLINEP(223, 217, 232, 217, 1, Channel_Plane3);
	DRAWLINEP(223, 218, 232, 218, 1, Channel_Plane4);
	DRAWLINEP(223, 219, 232, 219, 1, Channel_Math_Plane);
//	DRAWLINEP(223, 220, 232, 220, 1, Memory_Plane1);
//	DRAWLINEP(223, 221, 232, 221, 1, Memory_Plane2);
//	DRAWLINEP(223, 222, 232, 222, 1, Memory_Plane3);
	DRAWLINEP(223, 223, 232, 223, 1, Marker_Plane1);
	DRAWLINEP(223, 224, 232, 224, 1, Marker_Plane2);
	DRAWLINEP(223, 225, 232, 225, 1, Grid_Plane);
	
	
	
	
	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################
// BF color demo to check planes and colors
// BF -> UI_Plane1 has a shift error of 32 pixels to the right !!!!!!!!!!!!!!!!!!
// BF this error causes wrong lines at button drawing 
void Display::ColorDemo2(void)
{
    int x;
	UI_request = 0;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{ Planes[x] = 0; }

	TEXTOUTxvbig("UI_Plane1", 40, 5, 1, UI_Plane1);				// white/grey
	TEXTOUTxvbig("UI_Plane2", 40, 20, 1, UI_Plane2);			// black
	TEXTOUTxvbig("UI_Plane3", 40, 35, 1, UI_Plane3);			// light yellow
	TEXTOUTxvbig("UI_Plane4", 40, 50, 1, UI_Plane4);			// yellow
	TEXTOUTxvbig("UI_Plane5", 40, 65, 1, UI_Plane5);			// dark grey
	TEXTOUTxvbig("Channel_Plane1", 40, 80, 1, Channel_Plane1);		// neon yellow
	TEXTOUTxvbig("Channel_Plane2", 40, 95, 1, Channel_Plane2);		// neon green
	TEXTOUTxvbig("Channel_Plane3", 40, 110, 1, Channel_Plane3);		// neon blue
	TEXTOUTxvbig("Channel_Plane4", 40, 125, 1, Channel_Plane4);		// neon red
	TEXTOUTxvbig("Channel_Math_Plane", 40, 140, 1, Channel_Math_Plane);	// neon pink
	TEXTOUTxvbig("Marker_Plane1", 40, 155, 1, Marker_Plane1);		// neon orange
	TEXTOUTxvbig("Marker_Plane2", 40, 170, 1, Marker_Plane2);		// neon orange
	TEXTOUTxvbig("Grid_Plane", 40, 185, 1, Grid_Plane);			// dark grey - white


	//----------------------------------------------------
	
	DRAWLINEP(0, 200, 639, 200, 1, UI_Plane1);
	DRAWLINEP(0, 205, 639, 205, 1, UI_Plane2);
	DRAWLINEP(0, 210, 639, 210, 1, UI_Plane3);
	DRAWLINEP(0, 215, 639, 215, 1, UI_Plane4);
	DRAWLINEP(0, 220, 639, 220, 1, UI_Plane5);

	DRAWLINEP(0, 225, 639, 225, 1, Channel_Plane1);
	DRAWLINEP(0, 230, 639, 230, 1, Channel_Plane2);
	DRAWLINEP(0, 235, 639, 235, 1, Channel_Plane3);
	DRAWLINEP(0, 240, 639, 240, 1, Channel_Plane4);
	DRAWLINEP(0, 245, 639, 245, 1, Channel_Math_Plane);

	DRAWLINEP(0, 250, 639, 250, 1, Marker_Plane1);
	DRAWLINEP(0, 255, 639, 255, 1, Marker_Plane2);

	DRAWLINEP(0, 260, 639, 260, 1, Grid_Plane); 	

	//----------------------------------------------------
	
	DRAWLINEP(0, 300, 603, 300, 1, UI_Plane1);
	DRAWLINEP(0, 305, 603, 305, 1, UI_Plane2);
	DRAWLINEP(0, 310, 603, 310, 1, UI_Plane3);
	DRAWLINEP(0, 315, 603, 315, 1, UI_Plane4);
	DRAWLINEP(0, 320, 603, 320, 1, UI_Plane5);

	DRAWLINEP(0, 325, 603, 325, 1, Channel_Plane1);
	DRAWLINEP(0, 330, 603, 330, 1, Channel_Plane2);
	DRAWLINEP(0, 335, 603, 335, 1, Channel_Plane3);
	DRAWLINEP(0, 340, 603, 340, 1, Channel_Plane4);
	DRAWLINEP(0, 345, 603, 345, 1, Channel_Math_Plane);

	DRAWLINEP(0, 350, 603, 350, 1, Marker_Plane1);
	DRAWLINEP(0, 355, 603, 355, 1, Marker_Plane2);

	DRAWLINEP(0, 360, 603, 360, 1, Grid_Plane); 	

	//----------------------------------------------------

	DRAWLINEP(33, 400, 639, 400, 1, UI_Plane1);
	DRAWLINEP(33, 405, 639, 405, 1, UI_Plane2);
	DRAWLINEP(33, 410, 639, 410, 1, UI_Plane3);
	DRAWLINEP(33, 415, 639, 415, 1, UI_Plane4);
	DRAWLINEP(33, 420, 639, 420, 1, UI_Plane5);

	DRAWLINEP(33, 425, 639, 425, 1, Channel_Plane1);
	DRAWLINEP(33, 430, 639, 430, 1, Channel_Plane2);
	DRAWLINEP(33, 435, 639, 435, 1, Channel_Plane3);
	DRAWLINEP(33, 440, 639, 440, 1, Channel_Plane4);
	DRAWLINEP(33, 445, 639, 445, 1, Channel_Math_Plane);

	DRAWLINEP(33, 450, 639, 450, 1, Marker_Plane1);
	DRAWLINEP(33, 455, 639, 455, 1, Marker_Plane2);

	DRAWLINEP(33, 460, 639, 460, 1, Grid_Plane); 	



/*
	DRAWLINEP(0, 150, 639, 150, 1, Memory_Plane1);
	DRAWLINEP(0, 155, 639, 155, 1, Memory_Plane2);
	DRAWLINEP(0, 160, 639, 160, 1, Memory_Plane3);
*/

	// Stop the system
 	for(;;){}
 }
//##########################################################################################################################################################

void Display::ColorDemo3(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}
	
	PIXELP(0, 0, 1, UI_Plane1);
	PIXELP(16, 0, 1, UI_Plane1);
	PIXELP(1, 0, 1, UI_Plane2);
	PIXELP(17, 0, 1, UI_Plane2);
	PIXELP(2, 0, 1, UI_Plane3);
	PIXELP(18, 0, 1, UI_Plane3);
	PIXELP(3, 0, 1, UI_Plane4);
	PIXELP(19, 0, 1, UI_Plane4);
	PIXELP(4, 0, 1, UI_Plane5);
	PIXELP(20, 0, 1, UI_Plane5);
	
	PIXELP(5, 0, 1, Channel_Plane1);
	PIXELP(21, 0, 1, Channel_Plane1);
	PIXELP(6, 0, 1, Channel_Plane2);
	PIXELP(22, 0, 1, Channel_Plane2);
	PIXELP(7, 0, 1, Channel_Plane3);
	PIXELP(23, 0, 1, Channel_Plane3);
	PIXELP(8, 0, 1, Channel_Plane4);
	PIXELP(24, 0, 1, Channel_Plane4);
	PIXELP(9, 0, 1, Channel_Math_Plane);
	PIXELP(25, 0, 1, Channel_Math_Plane);        	
	
//	PIXELP(10, 0, 1, Memory_Plane1);
//	PIXELP(26, 0, 1, Memory_Plane1);   	
//	PIXELP(11, 0, 1, Memory_Plane2);
//	PIXELP(27, 0, 1, Memory_Plane2);   	
//	PIXELP(12, 0, 1, Memory_Plane3);
//	PIXELP(28, 0, 1, Memory_Plane3);   	
	
	PIXELP(13, 0, 1, Marker_Plane1);
	PIXELP(29, 0, 1, Marker_Plane1);   	
	PIXELP(14, 0, 1, Marker_Plane2);
	PIXELP(30, 0, 1, Marker_Plane2);
       	
	PIXELP(15, 0, 1, Grid_Plane);
	PIXELP(31, 0, 1, Grid_Plane);   	
	
	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################

void Display::ColorDemo5(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}

	// Clear test Plane
	for (x = 0; x < 9600; x++)
	{
        	Channel_Plane1[x] = 0;	
   		Buffer_Plane1[x] = 0;
	}
	
	DrawColorDemoBox(64, 64, 64, 64, Channel_Plane1);
	DrawColorDemoBox(172, 64, 64, 64, Buffer_Plane1);
	
    reset_watchdog->np_piodata = 0;
	
    screen_sel = 0;

	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################
// BF color demo to check planes and colors while sending a screenshot
void Display::ColorDemo6(void)
{

    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{ Planes[x] = 0; }

	TEXTOUTxvbig("UI_Plane1", 40, 5, 1, UI_Plane1);				// white/grey
	TEXTOUTxvbig("UI_Plane2", 40, 20, 1, UI_Plane2);			// black
	TEXTOUTxvbig("UI_Plane3", 40, 35, 1, UI_Plane3);			// light yellow
	TEXTOUTxvbig("UI_Plane4", 40, 50, 1, UI_Plane4);			// yellow
	TEXTOUTxvbig("UI_Plane5", 40, 65, 1, UI_Plane5);			// dark grey
	TEXTOUTxvbig("Channel_Plane1", 40, 80, 1, Channel_Plane1);		// neon yellow
	TEXTOUTxvbig("Channel_Plane2", 40, 95, 1, Channel_Plane2);		// neon green
	TEXTOUTxvbig("Channel_Plane3", 40, 110, 1, Channel_Plane3);		// neon blue
	TEXTOUTxvbig("Channel_Plane4", 40, 125, 1, Channel_Plane4);		// neon red
	TEXTOUTxvbig("Channel_Math_Plane", 40, 140, 1, Channel_Math_Plane);	// neon pink
	TEXTOUTxvbig("Marker_Plane1", 40, 155, 1, Marker_Plane1);		// neon orange
	TEXTOUTxvbig("Marker_Plane2", 40, 170, 1, Marker_Plane2);		// neon orange
	TEXTOUTxvbig("Grid_Plane", 40, 185, 1, Grid_Plane);			// dark grey - white


	//----------------------------------------------------
	
	DRAWLINEP(0, 200, 639, 200, 1, UI_Plane1);
	DRAWLINEP(0, 205, 639, 205, 1, UI_Plane2);
	DRAWLINEP(0, 210, 639, 210, 1, UI_Plane3);
	DRAWLINEP(0, 215, 639, 215, 1, UI_Plane4);
	DRAWLINEP(0, 220, 639, 220, 1, UI_Plane5);

	DRAWLINEP(0, 225, 639, 225, 1, Channel_Plane1);
	DRAWLINEP(0, 230, 639, 230, 1, Channel_Plane2);
	DRAWLINEP(0, 235, 639, 235, 1, Channel_Plane3);
	DRAWLINEP(0, 240, 639, 240, 1, Channel_Plane4);
	DRAWLINEP(0, 245, 639, 245, 1, Channel_Math_Plane);

	DRAWLINEP(0, 250, 639, 250, 1, Marker_Plane1);
	DRAWLINEP(0, 255, 639, 255, 1, Marker_Plane2);

	DRAWLINEP(0, 260, 639, 260, 1, Grid_Plane); 	

	//----------------------------------------------------
	
	DRAWLINEP(0, 300, 603, 300, 1, UI_Plane1);
	DRAWLINEP(0, 305, 603, 305, 1, UI_Plane2);
	DRAWLINEP(0, 310, 603, 310, 1, UI_Plane3);
	DRAWLINEP(0, 315, 603, 315, 1, UI_Plane4);
	DRAWLINEP(0, 320, 603, 320, 1, UI_Plane5);

	DRAWLINEP(0, 325, 603, 325, 1, Channel_Plane1);
	DRAWLINEP(0, 330, 603, 330, 1, Channel_Plane2);
	DRAWLINEP(0, 335, 603, 335, 1, Channel_Plane3);
	DRAWLINEP(0, 340, 603, 340, 1, Channel_Plane4);
	DRAWLINEP(0, 345, 603, 345, 1, Channel_Math_Plane);

	DRAWLINEP(0, 350, 603, 350, 1, Marker_Plane1);
	DRAWLINEP(0, 355, 603, 355, 1, Marker_Plane2);

	DRAWLINEP(0, 360, 603, 360, 1, Grid_Plane); 	

	//----------------------------------------------------

	DRAWLINEP(33, 400, 639, 400, 1, UI_Plane1);
	DRAWLINEP(33, 405, 639, 405, 1, UI_Plane2);
	DRAWLINEP(33, 410, 639, 410, 1, UI_Plane3);
	DRAWLINEP(33, 415, 639, 415, 1, UI_Plane4);
	DRAWLINEP(33, 420, 639, 420, 1, UI_Plane5);

	DRAWLINEP(33, 425, 639, 425, 1, Channel_Plane1);
	DRAWLINEP(33, 430, 639, 430, 1, Channel_Plane2);
	DRAWLINEP(33, 435, 639, 435, 1, Channel_Plane3);
	DRAWLINEP(33, 440, 639, 440, 1, Channel_Plane4);
	DRAWLINEP(33, 445, 639, 445, 1, Channel_Math_Plane);

	DRAWLINEP(33, 450, 639, 450, 1, Marker_Plane1);
	DRAWLINEP(33, 455, 639, 455, 1, Marker_Plane2);

	DRAWLINEP(33, 460, 639, 460, 1, Grid_Plane); 	




}

//##########################################################################################################################################################
/* BF */
// draw informations about FFT on right side of the screen
void Display::FFT_DrawStatus(unsigned char clear)
{

	float lValue = 0;
	int lTxtOffs = GRID_XOFFS_FFT + GRID_WIDTH_FFT + 9;


		//if (MenuPopupActive > -1)
		//nr_delay(1000);

	if(clear && !DrawMono) //FFT_Layout)
	{	
		//delete FFT-status area
		int xa = 19 * 20;		// Ypos * 20
		int xo = 16;	//512 / 32;	// Xpos / 32
	
		for (int Ct = 0; Ct < 404 ; Ct++)	// Ysize = 110
		{			
			*(UI_Plane1 + xo + xa)     = 0;	// Xsize + 1 (+32), + 2 (+ 2*32)...
			*(UI_Plane1 + xo + xa + 1) = 0;
			*(UI_Plane1 + xo + xa + 2) = 0;
			*(UI_Plane1 + xo + xa + 3) = 0;
	
			*(UI_Plane2 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane2 + xo + xa + 1) = 0;
			*(UI_Plane2 + xo + xa + 2) = 0;
			*(UI_Plane2 + xo + xa + 3) = 0;
	
			*(UI_Plane3 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane3 + xo + xa + 1) = 0;
			*(UI_Plane3 + xo + xa + 2) = 0;
			*(UI_Plane3 + xo + xa + 3) = 0;
	
			*(UI_Plane4 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane4 + xo + xa + 1) = 0;
			*(UI_Plane4 + xo + xa + 2) = 0;
			*(UI_Plane4 + xo + xa + 3) = 0;
	
			*(UI_Plane5 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane5 + xo + xa + 1) = 0;
			*(UI_Plane5 + xo + xa + 2) = 0;
			*(UI_Plane5 + xo + xa + 3) = 0;
	
			xa += 20;
		}
		return;
	}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	if(FFT_Mode == FFT_OFF) return;

	
	// SET FFT cursor data display
	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	{
		FFT_Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "dBm");
		FFT_Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "dBm");
		FFT_Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "dBm");
	}
	else
	{
		FFT_Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
		FFT_Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
		FFT_Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

			
/*
	//TEXTOUTxvbig(&string[0], GRID_XOFFS_FFT + GRID_WIDTH_FFT + 10, 40, 1,  Grid_Plane);	

	if (FFT_Mode == FFT_LOG)
	{
		TEXTOUTxvbig(" 0dB",    GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 25, 1,  Grid_Plane);	
		TEXTOUTxvbig("-10dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 95, 1,  Grid_Plane);	
		TEXTOUTxvbig("-20dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 175, 1,  Grid_Plane);	
		TEXTOUTxvbig("-30dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 255, 1,  Grid_Plane);
		TEXTOUTxvbig("-40dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 335, 1,  Grid_Plane);	
	}
*/


	
/*
	int xa = 70 * 20;		// Ypos * 20
	int xo = 17;	//544 / 32;	// Xpos / 32

	for (int Ct = 0; Ct < 110 ; Ct++)	// Ysize = 110
	{			
		*(Grid_Plane + xo + xa)     = 0;// Xsize + 1 , +2 ...
		*(Grid_Plane + xo + xa + 1) = 0;
//		*(Grid_Plane + xo + xa + 2) = 0;
		xa += 20;
	}
*/

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// calculate delta frequency
	lValue = (float)SampleRate[MainTimebase] / (float)FFT_Length;	

	// calculate normed ENBW for Power Spectrum Density (PSD)
	if (FFT_Windex > -1)				//rect window has ENBW 1.00
	lValue *= FFT_ENBW[FFT_Windex];

	FFT_NormENBW =  (int)(10 *log10f(lValue));	//10 * log10(ENBW * df)

	// FS = 400 = 50dB =>  Scaled ENBW = 400 * FFT_NormENBW / 50  => Scaled ENBW = 80 * FFT_NormENBW



	//FFT_NormENBW /= ( ScaleFactor[Selected_Voltage_Range][GainIdx] * FFT_ScaleCorrection[FFT_PWDN);

// -> selected voltage range is needed here!!!!!!!!!!!!!!!!!!



	if(!DrawMono) //FFT_Layout)	// display variant with buttons -> standard layout
	{
		Rect(517, 19, 123, 404, 1, UI_Plane3);	//draw FFT-status area background

		Display::DRAWROUNDBUTTON(516, 19, 124, 120, 0, 0);
		Display::DRAWROUNDBUTTON(516, 144, 124, 120, 0, 0);
		Display::DRAWROUNDBUTTON(516, 270, 124, 120, 0, 0);
	
		Line(519, 49, 638, 49, UI_Plane2);	// time under line
		Line(519, 174, 638, 174, UI_Plane2);	// frequency under line
		Line(519, 300, 638, 300, UI_Plane2);	// magnitude under line
	
	
		//--------------------------------------
		//	time status area
		//--------------------------------------
		Rect(546, 55, 92, 70, 0, UI_Plane2);	// delete 
	
		// time header
		TEXTOUTxvbig("Time Source", lTxtOffs + 10, 28, 1, UI_Plane2);
	
		// source channel
		TEXTOUTxvbig("Ch :", lTxtOffs, 60, 1, UI_Plane2);	
		TEXTOUTxvbig(&MenuPopupText[29][MenuStatus[27][0] - 136][0], lTxtOffs + 35, 60, 1, UI_Plane2);
	
		// FFT length
		TEXTOUTxvbig("Len:", lTxtOffs, 85, 1, UI_Plane2);
		TEXTOUTxvbig(&MenuPopupText[32][MenuStatus[27][3] - 82][0], lTxtOffs + 35, 85, 1, UI_Plane2);
		TEXTOUTxvbig("pts", lTxtOffs + 70, 85, 1, UI_Plane2);

		// time window
		TEXTOUTxvbig("Win:", lTxtOffs, 110, 1, UI_Plane2);	
		TEXTOUTxvbig(&MenuPopupText[30][MenuStatus[27][1] - 192][0], lTxtOffs + 35, 110, 1, UI_Plane2);
	
	
		//--------------------------------------
		//	frequency status area
		//--------------------------------------
		Rect(546, 180, 92, 80, 0, UI_Plane2);	//delete 
	
		// frequency header
		TEXTOUTxvbig("Frequency", lTxtOffs + 21, 153, 1, UI_Plane2);	
	
		// calculate delta frequency
		lValue = (float)SampleRate[MainTimebase] / (float)FFT_Length;	
		// start value , min value, max value, stepwidth , places afterdot, max places, Text, PreText, Unit
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "df : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 185, 1, UI_Plane2);	
	
		// calculate and display frequency per div
		if(!FFT_grid)
		lValue *= (float)(FFT_Length >> 4);
		else
		lValue *= ((float)(FFT_Length >> 2)/5);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "div: ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 210, 1, UI_Plane2);	
	
		// calculate and display fmax 
		lValue = (float)(SampleRate[MainTimebase] >> 1);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "fN : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 235, 1, UI_Plane2);	
	
	
	
		//--------------------------------------
		//	magnitude status area
		//--------------------------------------
		Rect(lTxtOffs+20, 278, 90, 18, 0, UI_Plane2);	//delete header
		Rect(lTxtOffs, 305, 110, 80, 0, UI_Plane2);	//delete lower part
	
		// magnitude header
		//TEXTOUTxvbig("Magnitude", lTxtOffs + 21, 279, 1, UI_Plane2);	
		TEXTOUTxvbig(&MenuPopupText[31][FFT_Mode][0], lTxtOffs+21, 279, 1, UI_Plane2);	
		// FFT mode
		//TEXTOUTxvbig(&MenuPopupText[31][FFT_Mode][0], lTxtOffs, 311, 1, UI_Plane2);	

		// linear - logarithmic
		if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
		TEXTOUTxvbig("Mag: log (dBm)", lTxtOffs, 311, 1, UI_Plane2);	
		else
		TEXTOUTxvbig("Mag: lin (Volt)", lTxtOffs, 311, 1, UI_Plane2);	

		//TEXTOUTxvbig("???: ????????", lTxtOffs, 336, 1, UI_Plane2);	

		//TEXTOUTxvbig("???: ????????", lTxtOffs, 362, 1, UI_Plane2);	

	}
	
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	else	// "black" display variant
	{
		//draw frame
		Line(518, 19, 638, 19, Text_Plane);	// time top line
		Line(518, 59, 638, 59, Text_Plane);	// time under line
	
		Line(518, 154, 638, 154, Text_Plane);	// frequency top line
		Line(518, 194, 638, 194, Text_Plane);	// frequency under line
	
		Line(518, 290, 638, 290, Text_Plane);	// magnitude top line
		Line(518, 330, 638, 330, Text_Plane);	// magnitude under line
	
		Line(638, 19, 638, 421, Text_Plane);	//right line
		Line(518, 421, 638, 421, Text_Plane);	//bottom line
		Line(518, 19, 518, 421, Text_Plane);	//left line
	
		//--------------------------------------
		//delete time status area
		//--------------------------------------
		Rect(546, 70, 92, 70, 0, Text_Plane);	
	
		// time header
		TEXTOUTxvbig("Time Source", lTxtOffs + 10, 33, 1, Text_Plane);	
	
		// source channel
		TEXTOUTxvbig("Ch :", lTxtOffs, 75, 1, Text_Plane);	
		TEXTOUTxvbig(&MenuPopupText[29][MenuStatus[27][0] - 136][0], lTxtOffs + 35, 75, 1, Text_Plane);
	
		// FFT length
		TEXTOUTxvbig("Len:", lTxtOffs, 100, 1, Text_Plane);
		TEXTOUTxvbig(&MenuPopupText[32][MenuStatus[27][3] - 82][0], lTxtOffs + 35, 100, 1, Text_Plane);
		TEXTOUTxvbig("pts", lTxtOffs + 70, 100, 1, Text_Plane);

		// time window
		TEXTOUTxvbig("Win:", lTxtOffs, 125, 1, Text_Plane);	
		TEXTOUTxvbig(&MenuPopupText[30][MenuStatus[27][1] - 192][0], lTxtOffs + 35, 125, 1, Text_Plane);



	
		//--------------------------------------
		//delete frequency status area
		//--------------------------------------
		Rect(546, 205, 92, 80, 0, Text_Plane);	
	
	
		// frequency header
		TEXTOUTxvbig("Frequency", lTxtOffs + 21, 168, 1, Text_Plane);	
	
		// calculate delta frequency
		lValue = (float)SampleRate[MainTimebase] / (float)FFT_Length;	
		// start value , min value, max value, stepwidth , places afterdot, max places, Text, PreText, Unit
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "df : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 210, 1, Text_Plane);	
	
		// calculate and display frequency per div
		if(!FFT_grid)
		lValue *= (float)(FFT_Length >> 4);
		else
		lValue *= ((float)(FFT_Length >> 2)/5);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "div: ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 235, 1, Text_Plane);	
	
		// calculate and display fmax 
		lValue = (float)(SampleRate[MainTimebase] >> 1);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "fN : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 260, 1, Text_Plane);	
	
		//--------------------------------------
		//delete magnitude status area
		//--------------------------------------
		Rect(lTxtOffs+20, 302, 90, 18, 0, Text_Plane);		//delete header
		Rect(lTxtOffs, 340, 92, 80, 0, Text_Plane);		//delete lower part
	
		// magnitude header
		//TEXTOUTxvbig("Magnitude", lTxtOffs + 21, 304, 1, Text_Plane);	
		TEXTOUTxvbig(&MenuPopupText[31][FFT_Mode][0], lTxtOffs+21, 304, 1, Text_Plane);	

		// linear - logarithmic
		if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
		TEXTOUTxvbig("Mag: log (dBm)", lTxtOffs, 346, 1, Text_Plane);	
		else
		TEXTOUTxvbig("Mag: lin (Volt)", lTxtOffs, 346, 1, Text_Plane);
	
		//TEXTOUTxvbig("???: ????????", lTxtOffs, 371, 1, Text_Plane);	
		//TEXTOUTxvbig("???: ????????", lTxtOffs, 396, 1, Text_Plane);	


	}

}

//##########################################################################################################################################################
//BF calculate cursor data for FFT
void Display::FFT_CalcCursorData(void)  								// channel = source im cursor menu
{
	int lCursorOffset = 0;	
	int lVoltRange = 0;		
	int lZero;		
	int lProbe = 0;
	
	float lVoltOffset = 0, lVoltOffs1 = 0, lVoltOffs2 = 0;	
	float lVoltFactor = 0;

	int time = 0;

	float frequ1, frequ2;
	float dfrequ;

	char BufferText[10];
	
	int channel = MenuStatus[MENU_FFT][0] - 136;

	//printf("calculating FFT-cursor\r\n");
	
	switch(channel)
	{
	 	case 1:
		{				
			lVoltRange = Selected_Voltage_CH1;
			lProbe = MenuStatus[1][3] - 101;
			break;
		}
		case 2:
		{				
			lVoltRange = Selected_Voltage_CH2;
			lProbe = MenuStatus[2][3] - 101;
			break;
		}
		case 3:
		{				
			lVoltRange = Selected_Voltage_CH3;
			lProbe = MenuStatus[3][3] - 101;
			break;
		}
		case 4:
		{				
			lVoltRange = Selected_Voltage_CH4;
			lProbe = MenuStatus[4][3] - 101;
			break;	
		}
	}
	
	lZero = GRID_HEIGHT_FFT + 1;

	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	{ lVoltFactor = 0.125; }// * probefact }
	else	//linear magnitude
	{ lVoltFactor = VoltFactor[lVoltRange] * VoltFactor[lProbe]; }

	lCursorOffset = lZero - Cursor_Horizontal_Position_Real1;
	//printf("Horizontal cursor 1 = %d",buf_int);	
	//printf(" | ");

	lVoltOffs1 =  (float)lCursorOffset * lVoltFactor; 
	
	// display horizontal cursor Y1 data
	FFT_Cursor_Horizontal_Pos_1_Str.Write_Value(lVoltOffs1);
	FFT_Cursor_Horizontal_Pos_1_Str.RenderText();
		
	
	lCursorOffset = lZero - Cursor_Horizontal_Position_Real2;	
	//printf("Horizontal cursor 2 = %d\r\n",buf_int);	

	lVoltOffs2 =  (float)lCursorOffset * lVoltFactor; 
	
	// display horizontal cursor Y2 data
	FFT_Cursor_Horizontal_Pos_2_Str.Write_Value(lVoltOffs2);
	FFT_Cursor_Horizontal_Pos_2_Str.RenderText();	
	
	//display delta values?
	if(CRS_Delta)
	{	
		if (lVoltOffs1 > lVoltOffs2)
		{ lVoltOffset = lVoltOffs1 - lVoltOffs2; }
		else
		{ lVoltOffset = lVoltOffs2 - lVoltOffs1; }
		
		if (lVoltOffset < 0) lVoltOffset = -lVoltOffset;
			
		switch(channel)
		{
			case 1: sprintf(BufferText, "@Y [ = "); break;
			case 2: sprintf(BufferText, "@Y \\ = "); break;
			case 3: sprintf(BufferText, "@Y ] = "); break;
			case 4: sprintf(BufferText, "@Y ^ = "); break;
			//case 5: sprintf(BufferText, "@Y(M) = "); break;
		}
	
		// display delta cursor Y data
		FFT_Cursor_Delta_Y.Write_PreText(BufferText);
		FFT_Cursor_Delta_Y.Write_Value(lVoltOffset);
		FFT_Cursor_Delta_Y.RenderText();				
	}


	//------------------------------------------------------------------------------------
	//		Vertical cursors - frequency
	//------------------------------------------------------------------------------------
/*BF limiting in rotation handler
	// limiter
	if(Cursor_Vertical_Position_FFT_1 > GRID_WIDTH_FFT + 1) Cursor_Vertical_Position_FFT_1 = GRID_WIDTH_FFT + 1;
	if(Cursor_Vertical_Position_FFT_2 > GRID_WIDTH_FFT + 1) Cursor_Vertical_Position_FFT_2 = GRID_WIDTH_FFT + 1;
*/

	// calculate delta frequency
	dfrequ =  (float)SampleRate[MainTimebase] / 1024.0;	//(float)FFT_Length;	
	
	// calculate frequency of cursor 1 position
	frequ1 = dfrequ * (float)(Cursor_Vertical_Position_FFT_1 - 1);

	// display vertical cursor X1 data 
	FFT_Cursor_Vertical_Pos_1_Str.Write_Value(frequ1);
	FFT_Cursor_Vertical_Pos_1_Str.RenderText();	
	//printf("freq1 = ");floatprintf(frequ1);printf("\r\n");	

	// calculate frequency of cursor 2 position
	frequ2 = dfrequ * (float)(Cursor_Vertical_Position_FFT_2 - 1);

	// display vertical cursor X2 data 
	FFT_Cursor_Vertical_Pos_2_Str.Write_Value(frequ2);	
	FFT_Cursor_Vertical_Pos_2_Str.RenderText();	
	//printf("freq2 = ");floatprintf(frequ2);printf("\r\n");	
	
	//display delta values?
	if(CRS_Delta)
	{	
		// calculate delta cursor 1 - cursor 2
		if (frequ1 > frequ2) dfrequ = frequ1 - frequ2;
		else dfrequ = frequ2 - frequ1;
		if (dfrequ < 0) dfrequ = -dfrequ;
		
		// display delta
		FFT_Cursor_Delta_X.Write_Value(dfrequ);	
		FFT_Cursor_Delta_X.RenderText();
		
		// calculate and display 1/delta
		dfrequ = 1 / dfrequ;
		FFT_Cursor_Delta_1X.Write_Value(dfrequ);
		FFT_Cursor_Delta_1X.RenderText();
	}
}
//##########################################################################################################################################################
//BF draw logic traces
void Display::LOGA_DrawTraces(void)	
{
	unsigned char *lPtr_Signal     = NULL;
	unsigned char *lPtr_SigIntpol  = NULL;
	unsigned char *lPtr_SigIntpDel = NULL;

	if(ZL_changed) UI_request = 0;			// if zero level changed the affected channel must be drawn

	if(Run && (!ACQ_NewData || UI_request)) 	// drawing only when new data are available and no UI-request occured
	return;

	ACQ_NewData = 0;

	FrameCount++;					//BF speed test
	//printf("FCnt = %d\r",FrameCount);


	//---------------------------------------------------------------------------------------------------------------------------------------	
	//                            draw time signal t/y of active channels one after another
	//---------------------------------------------------------------------------------------------------------------------------------------	
	DrawPlane = 0x00;

//printf("drawing signal \n\r");	

	for (unsigned char lv_channel = 1 ; lv_channel <= 5 ; lv_channel ++ )
	{
      		if(ZL_changed && (ZL_changed != lv_channel))	// skip drawing if zero level changed but don't match the channel
        	continue;

 		if(UI_request)  				//if UI interrupt occured don't draw next signals
        	{ 
	  		ClearPlane = DrawPlane;
	        	DrawPlane = 0;
			return;
		}

		switch (lv_channel)
		{
			case 1: if(Channel_1_Active)
				{ lPtr_Signal = S1Ptr; lPtr_SigIntpol = SIGNAL1_Intpolate; lPtr_SigIntpDel = SIGNAL1_Intpolate_delayed; DrawPlane |= 0x01;}
				else continue; break;
			case 2: if(Channel_2_Active)
				{ lPtr_Signal = S2Ptr; lPtr_SigIntpol = SIGNAL2_Intpolate; lPtr_SigIntpDel = SIGNAL2_Intpolate_delayed; DrawPlane |= 0x02;}
				else continue; break;
			case 3: if(Channel_3_Active)
				{ lPtr_Signal = S3Ptr; lPtr_SigIntpol = SIGNAL3_Intpolate; lPtr_SigIntpDel = SIGNAL3_Intpolate_delayed; DrawPlane |= 0x04;}
				else continue; break;
			case 4: if(Channel_4_Active)
				{ lPtr_Signal = S4Ptr; lPtr_SigIntpol = SIGNAL4_Intpolate; lPtr_SigIntpDel = SIGNAL4_Intpolate_delayed; DrawPlane |= 0x08;}
				else continue; break;
		}

		if (NoDisplay[lv_channel-1]) continue;								// don't display this channel

		//-------------------------------------------------
		//draw T-Y time signal
		//-------------------------------------------------
		if ((MainTimebase + VirtualTimebase) < 4) 							//Timebase 20nS & 10nS & 5nS -> interpolated timebases
		{
			DRAWLogicTrace(lv_channel, 1, draw_factor, draw_start, lPtr_SigIntpol);			//Draw main Signal (in delayed mode into top window (window = 1)

			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)						//Delayed mode -> draw into bottom window (window = 2)
			{ DRAWLogicTrace(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lPtr_SigIntpDel); }
		}
		else //if ((MainTimebase + VirtualTimebase) >= 4)						//Timebase >= 50nS
		{
			DRAWLogicTrace(lv_channel, 1, draw_factor, draw_start, lPtr_Signal);			//Draw main Signal (in delayed mode into top window (window = 1)
			
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON && USTB_Mode == USTB_OFF)			//Delayed mode -> draw into bottom window (window = 2)
			{
				if (ZoomFactorDel < 1)								//delayed timebase 20ns & 10ns & 5 ns
				{ DRAWLogicTrace(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lPtr_SigIntpDel); }
				else										//delayed timebase >= 50ns
				{ DRAWLogicTrace(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lPtr_Signal); }
			}
		}

		if (ZL_changed == lv_channel)									// if zerolevel changed, only draw the corresponding plane
        	{ ZL_changed = 0; break; }

	} //Channel loop end

       	ClearPlane = DrawPlane;	// | RemovePlane;
        DrawPlane = 0x00;	


	if ((QM_Enabled) && (QM_Type[0] > 0)) Display::CALCQMDATA();


}

//##########################################################################################################################################################

// Draw logical trace on T-Y axis
void Display::DRAWLogicTrace(unsigned int channel, unsigned char windows, unsigned int timefactor, unsigned int ixstart, unsigned char *signal)
{
	short lZeroLevel = (GRID_HEIGHT / 2) + GRID_YOFFS;	//drawing zero is in the middle of the grid
;
	unsigned long *plane = NULL;

	short P1 = 0;
	short P2 = 0;
	short P3 = 0;	

	short factor_buff = timefactor;	
	short display_min;
	short display_max;
	
	int   lix = ixstart; 		//signal index
	int   lposx = GRID_XOFFS;	//grid position

	unsigned char lInterpol = 0;

        char ltoggle = 0, lDelayedShiftFactor = 0;

	//----------------------------------------
	//set channel depending parameters
	//----------------------------------------
	if (channel == 1)
	{	
		plane = Buffer_Plane1;						// pointer to buffer layer of channel 1
		//plane = Channel_Plane1;					// pointer to display layer of channel 1
		
		lZeroLevel += Virtual_ZeroLevelCH1;
	}	
	else if (channel == 2)
	{	
		plane = Buffer_Plane2;						// pointer to buffer layer of channel 2
		//plane = Channel_Plane2;					// pointer to display layer of channel 2

		lZeroLevel += Virtual_ZeroLevelCH2;
	}
	else if (channel == 3)
	{		
		plane = Buffer_Plane3;						// pointer to buffer layer of channel 3
		//plane = Channel_Plane3;					// pointer to display layer of channel 3

		lZeroLevel += Virtual_ZeroLevelCH3;
	}
	else if (channel == 4)
	{	
		plane = Buffer_Plane4;						// pointer to buffer layer of channel 4
		//plane = Channel_Plane4;					// pointer to display layer of channel 4

		lZeroLevel += Virtual_ZeroLevelCH4;
	}		

//printf("drawing channel %d \n\r", channel);



	//----------------------------------
	//Set drawing parameters
	//----------------------------------
	if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed mode
	{
		lDelayedShiftFactor = 1;
		
		if (windows == 1)	//draw main signal into upper delayed grid area
		{
			lZeroLevel = ((lZeroLevel - GRID_YOFFS) >> 1) + GRID_YOFFS;
			
			display_min = GRID_YOFFS;
			display_max = ((GRID_HEIGHT >> 1) - 2) + GRID_YOFFS;
		}
		else	//draw delayed signal into bottom grid area
		{
			lZeroLevel = ((lZeroLevel - GRID_YOFFS) >> 1) + (GRID_HEIGHT / 2) + GRID_YOFFS;
			
			display_min = ((GRID_HEIGHT >> 1) + 2) + GRID_YOFFS;
			display_max = GRID_HEIGHT + GRID_YOFFS;

			//if special case time factor 2.5 occurs -> switch toggle mode on
			if (ZoomFactorDel == 2.5){ ltoggle = 1;} 
		}
	}
	else	//Main mode
	{
		display_min = GRID_YOFFS;
		display_max = GRID_HEIGHT + GRID_YOFFS;	
	}

	//factor (time factor) is the step width of the loop index and must be minimum 1
	if(timefactor <= 0)
	{ timefactor = 1; }


//--------------------------------------------------------------------------------------------------------
//                         Signal drawing with vector or points
//--------------------------------------------------------------------------------------------------------

	
	//-----------------------------------------------------------
	// pixel connection drawing routine - fastest drawing
	//-----------------------------------------------------------
	//if(MenuStatus[MENU_DISPLAY][4] == DRAW_FAST) 
	{
	
		//Get ADC-value of starting point and calculate correction, scaling and Y-positioning
		P2 = lZeroLevel + (ScaleLookupTable[signal[lix]][2] >> lDelayedShiftFactor);
		//P2 = (ScaleLookupTable[signal[lix]][2] >> lDelayedShiftFactor);
		lix += timefactor;
		P3 = lZeroLevel + (ScaleLookupTable[signal[lix]][2] >> lDelayedShiftFactor);
		//P3 = (ScaleLookupTable[signal[lix]][2] >> lDelayedShiftFactor);

		//limiter
		if (P2 > display_max) P2 = display_max;
		if (P2 < display_min) P2 = display_min;
		if (P3 > display_max) P3 = display_max;
		if (P3 < display_min) P3 = display_min;

		if (ltoggle)	//factor 2.5
		{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}
	
		//draw signal
		for (lix += timefactor; (lposx - GRID_XOFFS) < GRID_WIDTH-1; lix += timefactor)
		{
			lposx++;
	
			if (ltoggle)	//factor 2.5
			{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}

			P1 = P2;
			P2 = P3;
	
			//get next ADC-value, scaling and Y-positioning
			P3 = lZeroLevel + (ScaleLookupTable[signal[lix]][2] >> lDelayedShiftFactor);
			//P3 = (ScaleLookupTable[signal[lix]][2] >> lDelayedShiftFactor);

			//limiter
			if (P3 > display_max) P3 = display_max;
			if (P3 < display_min) P3 = display_min;

					
			//-----------------------------------------------------------
			//		Draw lines
			//-----------------------------------------------------------
			//Fall 1   ( 1 == 2 == 3 )
			if ((P1 == P2) && (P2 == P3))
			{ PixelOn(lposx, P1, plane); }
	
			//Fall 2   ( 1 < 2 < 3 )
			else if ((P1 < P2) && (P2 < P3))
			{ Connect_Pixels(lposx, P1, P2, 1, plane); }	
		
			//Fall 3   ( 1 > 2 > 3 )
			else if ((P1 > P2) && (P2 > P3))
			{ Connect_Pixels(lposx, P1, P2, 0, plane); }	
		
			//Fall 4   ( 1 < 2 = 3 )
			else if ((P1 < P2) && (P2 == P3))
			{ Connect_Pixels(lposx, P1, P2, 1, plane); }	
			
			//Fall 5   ( 1 > 2 = 3 )
			else if ((P1 > P2) && (P2 == P3))
			{ Connect_Pixels(lposx, P1, P2, 0, plane); }
			
			//Fall 6   ( 1 = 2 < 3 )
			else if ((P1 == P2) && (P2 < P3))
			{ PixelOn(lposx, P1, plane); }	
			
			//Fall 7   ( 1 = 2 > 3 )
			else if ((P1 == P2) && (P2 > P3))
			{ PixelOn(lposx, P1, plane); }	
		
			//Fall 8   ( 1 > 2 < 3 )
			else if ((P1 > P2) && (P2 < P3))
			{ Connect_Pixels(lposx, P1, P2, 0, plane); }	
			
			//Fall 9   ( 1 < 2 > 3 )
			else if ((P1 < P2) && (P2 > P3))
			{ Connect_Pixels(lposx, P1, P2, 1, plane); }	
			else //-> Fall 1
			{ PixelOn(lposx, P1, plane); }	
		}	
	
	}

/*
	//---------------------------------------------------------------------
	// Line drawing with standard line function - 
	// new line() function which is nearly as fast as the pixel connection 
	// routine but shows more details
	//---------------------------------------------------------------------
	else if(MenuStatus[MENU_DISPLAY][4] == DRAW_ACC) 
	{
		
		//+++++++++++++++++ draw signal as vector line ++++++++++++++++++


		//Get ADC-value of starting point and calculate correction, scaling and Y-positioning
		P1 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);
		lix += timefactor;
		P2 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);


		//limiter
		if (P1 > display_max) P1 = display_max;
		if (P1 < display_min) P1 = display_min;
		if (P2 > display_max) P2 = display_max;
		if (P2 < display_min) P2 = display_min;

		if (ltoggle)	//factor 2.5
		{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}

		//draw signal
		for (lix += timefactor; (lposx - GRID_XOFFS) < GRID_WIDTH-1; lix += timefactor)
		{
			lposx++;
			
			if (ltoggle)	//toggle faktor between 2 and 3 to simulate 2,5
			{if (timefactor == 3){timefactor = 2;} else {timefactor = 3;}}

			P1 = P2;

			//get next ADC-value, scaling and Y-positioning
			P2 = lZeroLevel + (ScaleLookupTable[signal[lix]][lScaleIndex] >> lDelayedShiftFactor);


			//limiter
			if (P2 > display_max)
			{	
				if (P3 > display_max)		// if hole line segment is out of range -> don't draw
				{ P3 = P2; continue; }
				else				// if only one end of the line segment is out of range -> limiting
				{ P3 = P2; P2 = display_max; }
			}
			else if (P2 < display_min)
			{	
				if (P3 < display_min)		// if hole line segment is out of range -> don't draw
				{ P3 = P2; continue; }
				else				// if only one end of the line segment is out of range -> limiting
				{ P3 = P2; P2 = display_min; }
			}
			else
			P3 = P2;				// remember the value
	
			//-----------------------------------------------------------
			//		Draw lines
			//-----------------------------------------------------------
			//DRAWLINEP(X1, Y1, X2, Y2, on, plane);
			Line(lposx, P1, lposx + 1, P2, plane);
		}

	}
*/


}






