
#ifndef hardware_t_h
#define hardware_t_h

#include "nios.h"

class Hardware
{

	public:	
	static void Init(void);	
									// Init the WatchDog
	static void Reset_the_Watchdog(void);				// Resets the WatchDog
//	static void Restart_Record(void);				// Restart Recording
	static void Start_Record(void);                                 // Restart Recording	
	static void Stop_Record(void);				        // Stop Recording	
	static void Read_Version(void);                                 // Read out the hardware version
	static void Setup_Vars(void);					// Setup Variables with standart Values
	static void Setup_Hardware(void);				// Setup the Hardware
	static void Setup_Interrupts(void);                             // Setup the Interrupts
	static void Disable_All_Interrupts(void);		// Disable the Interrupts BF #010
	static void Set_Vars_Default(void);                             // Set Vars to default values
	//static char SearchZero(char channel, char level, int *DAC_Offset, int *ZeroSign);
	//static char SearchZeros(void);                                	// Search Signals for correct difference
//	static void GenerateFLASH(void);				// Generate FLASH content

//	Keyboard functions	
	static void DoEnableKeyInterrupt(void);				// Declare Enable PIO ISR
	static void DoDisableKeyInterrupt(void);			// Declare Disable PIO ISR
	static void ISR_KEY(int context);				// Declare Button Interrupt subroutine
	
	static void SetupTrigger(void);					// setup trigger modus
	
	static void Set_LED(int LED);					// Set LED On
	static void Reset_LED(int LED);					// Set LED Off
	//BF not needed static void Clear_LED(void);					// Clear all LED�s
	static void Send_LED(void);					// Send Shift Value for LED�s to Keyboard

	static void DoEnableRotInterrupt(void);				// Declare Enable PIO ISR
	static void DoDisableRotInterrupt(void);			// Declare Disable PIO ISR
	static void ISR_ROT(int context);				// Declare Button Interrupt subroutine

	static void Zero_Levels_Center(void);				// 
	static void Zero_Levels_Restore(void);				// 

	static void DoEnableRotReadyInterrupt(void);			// Declare Enable PIO ISR
	static void DoDisableRotReadyInterrupt(void);			// Declare Disable PIO ISR
	static void ISR_ROTREADY(int context);				// Declare Button Interrupt subroutine

	static void DoEnableUARTInterrupt(void);			// Declare Enable UART2 ISR
	static void DoDisableUARTInterrupt(void);			// Declare Disable UART2 ISR
	static void ISR_UART(int context);				// Declare UART2 Interrupt subroutine
	
//**** Noch zu verbessern
	static void DoEnableUART2Interrupt(void);			// Declare Enable UART2 ISR
	static void DoDisableUART2Interrupt(void);			// Declare Disable UART2 ISR
	static void ISR_UART2(int context);				// Declare UART2 Interrupt subroutine
//****
	static void DoEnableTimer1Interrupt(void);			// Enable service routine
	static void DoDisableTimer1Interrupt(void);			// Disable service routine
	static void Start_Timer1(void);					// Start Timer1
	static void Stop_Timer1(void);					// Stop Timer1
	static void ISR_TIMER1(int context);				// Timer1 ISR for combi trigger

	static void DoEnableTimer2Interrupt(void);			// Enable service routine Timer2
	static void DoDisableTimer2Interrupt(void);			// Disable service routine Timer2
	static void Start_Timer2(void);					//BF new start function
	static void Stop_Timer2(void);					//BF new stop function
	static void Reset_Timer2(void);					//BF new reset function
	static void ISR_TIMER2(int context);				//Timer2 ISR
	

	//BF -> not needed static void Copy_in_asm(int cnt, unsigned char *DataArray_in, unsigned char *DataArray_out); // Copy the Roll Mode array 1 position
	
	static void DoEnableTimer3Interrupt(void);						// Enable service routine Timer3
	static void DoDisableTimer3Interrupt(void);						// Disable service routine Timer3
	static void ISR_TIMER3(int context);							// Timer3 ISR for menu popups
	static void ResetTimer3(int period);							// Reset Timer3

	static void SetSwitches(char channel, int voltage);					// Set Switches for voltage devider
	static void ADDON_SetSwitches(char channel, int voltage);				// new input stage
	static void Sleep_us(unsigned long us);                         			// busy wait with microsecond resolution
//BF new
	static void SetDacOffset(char channel);							// Set the DAC Offset of a Channel
//BF test	static void SetCHDacOffset(char channel);						// Set the DAC Offset of a Channel	
	static void SetupADC(void);								// Send Config Data to the ADCs
//
	static void WRITEADC(unsigned char which, unsigned long value);	// Write Value to ADC (which)
	static unsigned long READADC(unsigned char which);				// Read Value from ADC (which)
	
	static void PREPARE_READADC(unsigned char correct1, unsigned char correct2, unsigned char correct3, unsigned char correct4, unsigned int count); //Prepare registers for read_all
	//static void READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed);
	static void READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char highspeed);
	static void READADC_ALL2(unsigned char which, unsigned long *DataArray1, unsigned int count);
	//static void READADC3_Average(unsigned char which, unsigned char *DataArray1, int AverageMax);
	
//-------------------------------------------------------------------------------------------------------------------------------------------------------------

	static void ADC_ReadData(unsigned char which, unsigned long *DataArray1, unsigned int count);
	static void ADC_ProcessData(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed);

//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	static void DoEnableADCInterrupt(void);							// Declare Enable ADC ISR
	static void DoDisableADCInterrupt(void);						// Declare Disable ADC ISR
	static void ISR_ADC_INT(int context);							// Declare ADC Interrupt subroutine
	static int Read_IRQ(void);                                      			// red the status of the irq
	static void Handle_ADC(void);							        // Declare ADC Interrupt subroutine	
	static void ReadOut_Signal(char channel);						//BF deleted unused parameters
	

//static void Build_Trigo_Tables(void);
	
	//BF not used static void Do_Gen_Signal(void);	
	//BF not used static void Do_Gen_Signal2(void);	

	static int TriggerCorrection(unsigned char channel, unsigned char negativ, int TriggerPos);	// Search the Trigger
	static int AutoScale(char slow_tb);                                       				// Make Autoscale
	static int FindTimebase(char channel, char slow_tb);
	static int FindVoltage(char channel); 
	//BF del static void FindSlope(void);
	
	static void DoEnableReadVSyncInterrupt(void);					// Declare Enable ReadVSync ISR
	static void DoDisableReadVSyncInterrupt(void);					// Declare Disable ReadVSync ISR
	static void ISR_ReadVSync_INT(int context);						// Declare ReadVSync Interrupt subroutine

	static void TransferPlanes(void);                               // Transfer Backbuffer to Planes
	static void ClearPlanes(void);                               // Clears and Transfer Backbuffer to Planes
	static void TransferDataPlane_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1);
	static void TransferPlane_Set_Buffer_Adr(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2);
	static void TransferPlanes_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count);
	static void TransferPlanes_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count);
	static void TransferPlanes_clear_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count);
	static void Planes_clear_asm(unsigned long Buffer_Adr1);
	static void Planes_clear_asm_all(unsigned char count, unsigned long Buffer_Adr1, unsigned long Buffer_Adr2, unsigned long Buffer_Adr3, unsigned long Buffer_Adr4, unsigned long Buffer_Adr5);
//BF del not used    	static void DoEnableLogicAnalyserInterrupt(void);	            // Declare Enable LogicAnalyser ISR
//BF del not used	static void DoDisableLogicAnalyserInterrupt(void);	            // Declare Disable LogicAnalyser ISR
//BF del not used	static void ISR_LogicAnalyser(int context);	                    // Declare LogicAnalyser Interrupt subroutine
	
	static void Calc_ADC_Offset(int channel);				//BF added
	static int Calc_DAC_Correction(int channel, int *Correction);		//BF added
	static void Calibrate_ADC_ZeroOffsets(void);				//BF added
	static void Calibrate_DAC_ZeroOffsets(void);				//BF added

	static void FFT_Set_Channel(unsigned char backup);
	static void FFT_Restore_Channels(void);
	static void Reset_To_Default(void);
	static void Restore_From_Flash(void);
	static void Start_Up(void);
	static void LED_FunctionTest(char tmode);

	static void CenterTrace(int channel);
	static void DispatchTraces(void);
	static void TRIG_AutoLevel(void);
	static void TRIG_AutoPretrigger(void);


};




#endif //tc_classes_h

