
#ifndef signal_t_h
#define signal_t_h

#include "nios.h"

#define FIR_LENGTH 	15
#define SINC_LENGTH	25

/**
	Methods for digital signal processing like filtering, 
	sprectral analysis, interpolation and any other form
	of signal manipulation.
*/

class Signal
{
	protected:
	
	static const short _FIR_COEFFS[3][FIR_LENGTH];
	static const short _SINC_COEFFS[4][SINC_LENGTH];

	static int _FirLookup[FIR_LENGTH][256];
	static int _SincLookup[SINC_LENGTH][256];

	static unsigned char _SincLength;				// filter length, number of coefficients, order + 1, depends on cutoff/samplerate
	static unsigned char _SincIntWidth;				// integer size in bit

	static int _SinTab[2048];
	static int _CosTab[2048];
	static int _RevTab[2048];
	static int _WinTab[2048];


	public:	
//	static void Template(void);	
 
	static void processSignal(void); 								// BF new level 1 routine for signal processing
													// and math functions

	//----------------------------------------------------------------------------------------------------------------------------------------------------------
	static void USTB_clearBuffer(void);
	static void USTB_resetShiftBuffer(void);
	static void USTB_insertSample(short invert, unsigned char ADC_VirtualZero, unsigned char *USTB_buff ,unsigned char *Signal);
	static void USTB_invertSignal(unsigned char ADC_VirtualZero ,unsigned char *Signal);
	static void USTB_recalcMath(void);
	//----------------------------------------------------------------------------------------------------------------------------------------------------------

    	static void interpolate(int timebase, int start, unsigned char *SignalData, unsigned char *InterpolateResult);	//BF new interpolation routine
	static void interpolateLinear(int x1, int y1, int x2, int y2, unsigned char *interpolation);	

	// Math calculation
	static void calcMathMul(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData);
	static void calcMathSub(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData);
	static void calcMathAdd(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData);

	static void generateTestSignal(void);


	static void FFT_buildTrigoTables(void);
	static void FFT_calcSpectrum(unsigned char *Signal, int *Spectrum);

	//----------------------------------------------------------------------------------------------------------------------------------------------------------
	//static void LowPassFilter(unsigned char *RawData, int start, int stop, unsigned char *DisplayData);

	static void calcMinMax(int start, int stop, int stepwidth ,unsigned char *SignalData1,  unsigned char *min, unsigned char *max);

	static void buildScaleLookupTable(void);
	static void FFT_buildScaleLookupTable(void);
	static void LowPassFilter(int start, int stop, char strength, unsigned char *input, unsigned char *output);
	static void IIR_Filter(int start, int stop, char stage, unsigned char *input, unsigned char *output);
	//static void Average(int start, int stop, char steps, unsigned char *input, unsigned char *avrg_buffer);
	static void LOGA_LogicProcessor(void);

	static void FIR_NoiseFilter(int start, int stop, unsigned char *input, unsigned char *output);
	static void FIR_SincFilter(int start, int stop, unsigned char *input, unsigned char *output);
	static void FIR_buildNoiseFilterLookupTable(void);
	static void FIR_buildSincLookupTable(void);
};



#endif //signal_t_h
