/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * main.c - demo main module to test irmp decoder
 *
 * Copyright (c) 2009-2011 Frank Meyer - frank(at)fli4l.de
 *
 * $Id: main.c,v 1.10 2011/09/08 13:22:16 fm Exp $
 *
 * ATMEGA88 @ 8 MHz
 *
 * Fuses: lfuse: 0xE2 hfuse: 0xDC efuse: 0xF9
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include <inttypes.h>
#include <avr/io.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>

#include "irmpconfig.h"
#include "irmp.h"
#include "../irsnd/irsnd.h"


#ifndef F_CPU
#error F_CPU unkown
#endif


IRMP_DATA irmp_data;


void
timer1_init (void)
{
#if defined (__AVR_ATtiny45__) || defined (__AVR_ATtiny85__)                // ATtiny45 / ATtiny85:
    OCR1C   =  (F_CPU / F_INTERRUPTS / 4) - 1;                              // compare value: 1/15000 of CPU frequency, presc = 4
    TCCR1   = (1 << CTC1) | (1 << CS11) | (1 << CS10);                      // switch CTC Mode on, set prescaler to 4
#else                                                                       // ATmegaXX:
    OCR1A   =  (F_CPU / F_INTERRUPTS) - 1;                                  // compare value: 1/15000 of CPU frequency
    TCCR1B  = (1 << WGM12) | (1 << CS10);                                   // switch CTC Mode on, set prescaler to 1
#endif

#ifdef TIMSK1
    TIMSK1  = 1 << OCIE1A;                                                  // OCIE1A: Interrupt by timer compare
#else
    TIMSK   = 1 << OCIE1A;                                                  // OCIE1A: Interrupt by timer compare
#endif
}


/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Timer 1 output compare A interrupt service routine, called every 1/15000 sec
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#ifdef TIM1_COMPA_vect                                                      // ATtiny84
ISR(TIM1_COMPA_vect)
#else
ISR(TIMER1_COMPA_vect)
#endif
{
  if (!irsnd_ISR())         	// call irsnd ISR
  {                           // if not busy...
		irmp_ISR();            		// call irmp ISR
  }
}


int main (void)
{
	uint32_t led = 0;
	DDRC = 0xff;


  irmp_init();                                                            // initialize irmp
  irsnd_init();               																						// initialize irsnd
  timer1_init();                                                          // initialize timer 1
  sei ();                                                                 // enable interrupts


	
	while (1)
  {
		if (((++led & 0xfffff) & 0x80000) == 0x80000)
			PORTC = 1;
		else
			PORTC = 2;

		if (irmp_get_data (&irmp_data))
    {
      // ir signal decoded, do something here...
      // irmp_data.protocol is the protocol, see irmp.h
      // irmp_data.address is the address/manufacturer code of ir sender
      // irmp_data.command is the command code
      // irmp_protocol_names[irmp_data.protocol] is the protocol name (if enabled, see irmpconfig.h)

			// ignore the received code, always send this one...
			irmp_data.protocol = 21; 
			irmp_data.address = 0x46;
			irmp_data.command = 0xc;
			irmp_data.flags = 0;

			irsnd_send_data (&irmp_data, 1);

    }
	}
}
