//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ELV Elektronik AG
// ELV STI 100 Example Code
//
// File:					VNC1L.c
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//#include <inavr.h>
#include <avr/io.h>  //<ioavr.h>
//#include <iom32.h>  //<ioavr.h>
//#include "tools.h"
#include <util/delay.h>
#include "defines.h"
#include "uart.h"
#include "VNC1L.h"

extern volatile unsigned int uiTimeOut;
//extern unsigned char mode;

unsigned char vnc1l_init(void)
{
	unsigned char error = 0;
	
	_delay_ms(1500);
	switch_to_short_instruction_set();
	_delay_ms(500);
	switch_to_short_instruction_set();
	wait_for_vnc1l();
	_delay_ms(100);
	set_vnc1l_baudrate();
	wait_for_vnc1l();
	_delay_ms(100);
	set_baudrate();
	send_vnc1l_instruction(SUSPEND);
	wait_for_vnc1l();
			
	return error;
}
unsigned char set_vnc1l_baudrate(void)
// 38 41 00 = 9600; 03 00 00 = 1000000
{
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	uart_putchar(0x14);
	uart_putchar(0x20);
	uart_putchar(0x03);//03//38
	uart_putchar(0x00);//00//41
	uart_putchar(0x00);//00//00
	uart_putchar(CR);
	wait_uart_complete();
	return 0;
}


unsigned char send_vnc1l_instruction(unsigned char instruction)
{
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	uart_putchar(instruction);
	uart_putchar(CR);
	return 0;	
}

unsigned char open_file_to_write(unsigned char *name, unsigned char length)
{
	unsigned char error = 0, size;

	size = sizeof(name);
	if(size > 8)
		size = 8;
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	
	uart_putchar(OPEN_TO_WRITE);
	uart_putchar(0x20); //Space
	for(unsigned char i = 0; i < (length); i++)
		uart_putchar(name[i]);	
	
	uart_putchar(CR);
	return error;
}

unsigned char write_data_to_file(unsigned char size, unsigned char *data)
{
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	uart_putchar(WRITE);
	uart_putchar(0x20); //Space
	uart_putchar(0x00); 
	uart_putchar(0x00); 
	uart_putchar(0x00); 
	uart_putchar(size);
	uart_putchar(CR);
	
	for(unsigned char i = 0; i < size; i++)
		uart_putchar(data[i]);
	uart_putchar(CR);
	
	return 0;
}


unsigned char switch_to_short_instruction_set(void)
{
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	uart_putchar('S'); 
	uart_putchar('C'); 
	uart_putchar('S'); 
	uart_putchar(CR); 
	return 0;
}

unsigned char close_file(unsigned char *name, unsigned char length)
{
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	uart_putchar(CLOSE);
	uart_putchar(0x20); //Space
	for(unsigned char i = 0; i < (length); i++)
		uart_putchar(name[i]);	
	
	uart_putchar(CR);
	wait_for_vnc1l();

	if( ucRXI == BAD_COMMAND )
		return 1;
	return 0;
}

unsigned char delete_file(unsigned char *name, unsigned char length)
{
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	uart_putchar(DELETE);
	uart_putchar(0x20); //Space
	for(unsigned char i = 0; i < (length); i++)
		uart_putchar(name[i]);	
	
	uart_putchar(CR);
	wait_for_vnc1l();

	if( ucRXI == BAD_COMMAND )
		return 1;
	return 0;
}

unsigned char read_file(unsigned char *name, unsigned char length)
{
	ucRXI = WAIT_STATE;
	ucSioPointer = 0;
	uart_putchar(READ);
	
	uart_putchar(0x20); //Space
	for(unsigned char i = 0; i < (length); i++)
		uart_putchar(name[i]);	
	uart_putchar(CR);
	
	wait_for_vnc1l();

	if(ucRXI == PROMPT_DETECTED)
	{
		//data in ucSioBuffer
		return 1;
	}
	return 0;
}

unsigned char wait_for_vnc1l(void)
{
	uiTimeOut = 50;	// Timeout
	while( (ucRXI == WAIT_STATE) && (uiTimeOut) );
	if(uiTimeOut == 0)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}
