//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ELV Elektronik AG
// ELV STI 100 Example Code
//
// File:					VNC1L.h
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#ifndef VNC1L_h
#define VNC1L_h 1

//****************************************************************************
//VNC1L-Befehle
#define		SUSPEND					0x15			//Suspend Mode on
#define		WAKE					0x16			//Wake Disk (Suspend permanent off)
#define		SHORT_INSTRUCTION		0x10			//Short Instruction Set on
#define		DIR						0x01
#define 	OPEN_TO_WRITE			0x09			//Open a File in Write mode
#define 	OPEN_TO_READ			0x0e			//Open a File in Read mode
#define		WRITE					0x08	
#define 	READ					0x04
#define		CLOSE					0x0a			//Closes a File which was opened in write mode
#define		DELETE					0x07			//Delete a File
#define		SET_BAUD_RATE			0x14		
#define		FREE_SPACE				0x12
#define		IDENTIFY_DISK			0x0f


#define		CR						0x0d			//Carriage Return
#define		VNC1L_9600_BAUD			0x384100
#define		VNC1L_19200_BAUD		0x9c8000
#define		VNC1L_38400_BAUD		0x4ec000
#define		VNC1L_1000000_BAUD		0x030000

unsigned char vnc1l_init(void);

unsigned char set_vnc1l_baudrate(void);

unsigned char send_vnc1l_instruction(unsigned char instruction);

unsigned char open_file_to_write(unsigned char *name, unsigned char length);

unsigned char write_data_to_file(unsigned char size, unsigned char *data);

unsigned char close_file(unsigned char *name, unsigned char length);

unsigned char delete_file(unsigned char *name, unsigned char length);

unsigned char switch_to_short_instruction_set(void);

unsigned char read_file(unsigned char *name, unsigned char length);

unsigned char wait_for_vnc1l(void);


#endif
