//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ELV Elektronik AG
// ELV STI 100 Example Code
//
// File:					main.c
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//#include <inavr.h>
//#include <ioavr.h>
#include <avr/io.h>
#include <stdint.h>  //my_uitoa
//#include <avr/iom32.h>
//#include <stdlib.h>
// include user-defined header files
#include <avr/interrupt.h>
#include "defines.h"									// general definitions
//#include "tools.h"
#include "uart.h"
#include "VNC1L.h"

#include "i2clcd.h"

//#include "test.h"

volatile unsigned int uiTimeOut = 0;
unsigned char vncl1_mode = 0;
unsigned char xyz[];  
unsigned int Laufnummer = 0;


//Variablen fr Test und I2C-Empfang von CII
unsigned char Value[] = "Wert "; 
unsigned int I_2_Daten[20] = {1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000};

#include "module.h"//ntzliche Funktionen, Unterprogramme

//++++++++++++++++++++++++++++++++++++++++++++++
// Initialise all special-function-registers
// of the MCU
void init(void)
{
//	TCCR0B = 0x05;									// prescaler = CLK/1024
	TCCR0 = 0x05;									// prescaler = CLK/1024
//	TIMSK0 = 0x01;									// enable T0_OVF interrupt	
	TIMSK = 0x01;									// enable T0_OVF interrupt
}

//+++++++++++++++++++++++++++++++++++++++++++++
// Timer 0 interrupt: Scheduler
//#pragma vector=TIMER0_OVF_vect
//__interrupt void TIMER0_OVF_isr(void)
//void TIMER0_OVF_isr(void)
ISR(TIMER0_OVF_vect)
{
	if(uiTimeOut)
	{
		uiTimeOut--;
	}
}

//******************************************************
uint8_t debounce(volatile uint8_t *port, uint8_t pin)
{
//	if (  ! (*port &  (1<< pin)) )
	if (*port &  (1<< pin)) 
	{
	// Pin wurde auf High gezogen
	_delay_ms(100);
//		if (*port & (1<< pin))
		if (  ! (*port & (1<< pin))  )
			{
			//Anwender Zeit zum Loslassen
			_delay_ms(100);
			return 1;
			}
	
	}
	return 0;
}
//******************************************************



//Testprogramm
void Test()
{
/*
    char a;
	char b;

	uint8_t  bPortD;

    bPortD = PIND;

    a = bPortD & 0x04;
	b  = a << 3;


	DDRD = 0x60;

//    PORTD = b  |= 0x40;
    PORTD = b  ;
*/

//	DDRD = 0x60;
 
   if ( (debounce (&PIND, PD2)) &  (PD5 == 1) );
   {
   PORTD = (1 << PD5);
   }

   if ( (debounce (&PIND, PD2)) &  (PD5 == 0) );
   {
   PORTD = ~(1 << PD5);
   }   

}


//Testprogramm
/* wandelt Zahlen in Bytefolgen um und gibt die einzelnen Stellen aus*/
void Number(uint16_t Zahl)
{
    char a; uint16_t c;

    c = Zahl; uint16_t Divisor = 10000;

	do 
	 { 
	 c = Zahl / Divisor; 
	 Divisor = Divisor /10;
		lcd_putchar (0x20);
	 }
	while ( c == 0);

	Divisor = Divisor * 10;

    do
     {
		c = Zahl / Divisor;
		Zahl = Zahl - ( c * Divisor);
 		Divisor = Divisor /10;

        a = c + 48;
		lcd_putchar (a);
//		_delay_ms(1000);

	  }
	  while (Divisor > 1); 

	    a = Zahl + 48;
		lcd_putchar (a);
//		_delay_ms(1000);

	

//	return a;

}


int main(void)
{//Hauptschleife
	init();
	uart_init();  //UART initialisieren

	i2c_init();		//I2C initialisieren
	lcd_init();		//LCD initialisieren

//LCD Testprogramm
//	unsigned char string[] = "uitoa: ";
//	lcd_print(string);				//-	Print a string
	lcd_print(Value);				//-	Print a string
//	lcd_nextline();
    lcd_gotolr(2,1);

	unsigned char string2[] = "WEBi & USB-Log";
	lcd_print(string2);				//-	Print a string

	//-	Turn cursor off and activate blinking
//	lcd_command(LCD_DISPLAYON | LCD_CURSOROFF | LCD_BLINKINGON);
	lcd_command(LCD_DISPLAYON | LCD_CURSOROFF );

// Testvar
	int z  = 0;
	int y = 0; //Schleifenvariable fr Testausgabe
//	int x1  = 0;

//PD5, PD6 und PD7 als Ausgang
//	DDRD = 0x60;
//    DDRD = 0b11100000;
	DDRD = (1<<DDB5) | (1<<DDB6) | (1<<DDB5) ;



//VNCL1-Programm
//   vncl1_begin();
//	vncl1_call_neu();


//Hauptschleife	
	while(1)
	{

 Laufnummer = Laufnummer + 1;
 	//z = z + 10;
   
    if(y >= 10) //Schleifenzhler begrenzen
		{

		y = 0; //Schleifenzhler lschen
	
		}

    z = I_2_Daten[y] + 10 +y ;  //Wert testweise verndern
	I_2_Daten[y] = z ;
	y = y + 1;		//Schleifenzhler


//	vncl1_call();
	if( vnc1l_init() < 2 )
		{
//		vncl1_call_open_close();
		vncl1_number(z,Laufnummer);
		}


		lcd_gotolr(1,6);	//Ausgabe der Nr. des Werts
		lcd_putchar(y+'0');		
		lcd_gotolr(1,8);  	//Ausgabe des Werts
//		Number(z);
		my_uitoa(z,xyz);	//Wandlung int in char
		lcd_print(xyz);
		_delay_ms(1000); 	//Pause




	}//Hauptachleife
  }


