//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ELV Elektronik AG
// ELV STI 100 Example Code
//
// File:					uart.c
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#include <inavr.h>
//#include <ioavr.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include "defines.h"
#include "uart.h"

// global variables for transmission
unsigned char ucSioBuffer[SIO_BUFFER_SIZE];	// Buffer for USART-transmissions
volatile unsigned char ucSioPointer=0;								// Pointer to an element of ucSioBuffer
unsigned char ucSioCnt=0;										// Counter for USART-transmissions
volatile unsigned char ucRXI=0;											// 1, if a new instruction was received
extern unsigned char mode;

void uart_init(void)
{
//	__disable_interrupt();
//	cli();
	// Set baudrate
#ifdef DOUBLE_SPEED
	UBRRH = ((((((long)MCU_CLOCK)*2)/(8*((long)BAUDRATE))+1)/2-1)>>8)&0xff;	//ergibt nur den halben Wert, wenn double speed aktiviert ist
	UBRRL = (((((long)MCU_CLOCK)*2)/(8*((long)BAUDRATE))+1)/2-1)&0xff;
#else	

//    UBRRH =  0x00;//(103 >>8)&0xff;
//    UBRRL =  103;  //&0xff;

	UBRRH = ((( ((long)MCU_CLOCK)*2)/(16*((long)BAUDRATE))+1)/2-1)>>8)&0xff;	//ergibt nur den halben Wert, wenn double speed aktiviert ist
	UBRRL = (( ((long)MCU_CLOCK)*2)/(16*((long)BAUDRATE))+1)/2-1)&0xff;
#endif

	DOUBLE_SPEED
	// Enable Receiver and Transmitter
	UCSRB = (1<<RXEN)|(1<<TXEN)|(1<<RXCIE);
	// Set frame format: 8data, 1stop bit, no parity
	UCSRC = (ASYNCHRON | ONESTOPBIT | EIGHTBIT | NOPARITY | 1<<URSEL );
//	__enable_interrupt();
	sei();
}

void uart_putchar(char data)
{
  /* Wait for empty transmit buffer */
  while ( !( UCSRA & (1<<UDRE)) );
  /* Put data into buffer, sends the data */
  UDR = data;
  UCSRA |= (1<<TXC);
}


void wait_uart_complete(void)
{
  while (!(UCSRA & (1<<TXC)));
}

void set_baudrate(void)
{
	cli();
//	__disable_interrupt();
	UCSRB = 0x00;
	UBRRH = ((((((long)MCU_CLOCK)*2)/(8*((long)BAUDRATE2))+1)/2-1)>>8)&0xff;	//ergibt nur den halben Wert, wenn double speed aktiviert ist
	UBRRL = (((((long)MCU_CLOCK)*2)/(8*((long)BAUDRATE2))+1)/2-1)&0xff;
	DOUBLE_SPEED
	// Enable Receiver and Transmitter
	UCSRB = (1<<RXEN)|(1<<TXEN)|(1<<RXCIE);
	// Set frame format: 8data, 1stop bit, no parity
	UCSRC = (ASYNCHRON | ONESTOPBIT | EIGHTBIT | NOPARITY | 1<<URSEL );
//	__enable_interrupt();
	sei();
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ISR for receiving data
//#pragma vector=USART_RX_vect
ISR(USART_RXC_vect)// void rx_buffer_full(void)
{
     unsigned char ucValue;
	static unsigned char ucRXPrompt = 0;
												// yes -> reset transmission
		ucValue = UDR;															// read character from RX-buffer
//		if(ucRXI == WAIT_STATE)															// last instruction evaluated?
//		{
				if( ucValue == 0x3e )	// Prompt (>) detected
				{
					ucRXPrompt = 1;														// set flag, that prompt was received
				}
				if( (ucValue == 0x0d) && (ucRXPrompt == 1) )	// Carriage Return detected
				{
					ucRXI = PROMPT_DETECTED;						// set flag, that answer was received completely
					ucRXPrompt = 0;
					ucSioPointer = 0;
				}
				else if(ucValue == 0x0d)
				{
//					PORTB ^= (1<<PB5);
					if( (ucSioBuffer[ucSioPointer-2] == 'B') && ( ucSioBuffer[ucSioPointer-1] == 'C') )
					{	
//						PORTB ^= (1<<PB5);
						ucRXI = BAD_COMMAND;
					}
					else if( (ucSioBuffer[ucSioPointer-2] == 'C') && ( ucSioBuffer[ucSioPointer-1] == 'F') )
					{
//						PORTB ^= (1<<PB5);
						ucRXI = COMMAND_FAILURE;
					}
					else if( (ucSioBuffer[ucSioPointer-2] == 'N') && ( ucSioBuffer[ucSioPointer-1] == 'D') )
					{
//						PORTB ^= (1<<PB5);
						mode = 3;
						ucRXI = NO_DISK;
//						PORTB ^= (1<<PB5);
					}
					ucSioPointer = 0;
				}
				else
				{
					if(ucSioPointer < SIO_BUFFER_SIZE)			// buffer full?
						ucSioBuffer[ucSioPointer++] = ucValue;// no->save character
					else																		// yes -> buffer overflow (error)
					{
						ucRXI = WAIT_STATE;
						ucRXPrompt = 0;
						ucSioPointer = 0;
					}
				}
//		}	
}

