//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ELV Elektronik AG
// ELV STI 100 Example Code
//
// File:					uart.h
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _uart_h_
#define _uart_h_ 1

// prototypes of the global variables for the transmission
extern unsigned char ucSioBuffer[];
extern volatile unsigned char ucSioPointer;
extern unsigned char ucSioCnt;
extern volatile unsigned char ucRXI;

// defines constants for transmission
#define ASYNCHRON			0x00	// Asynchronous mode of operation
#define SYNCHRON			0x40	// Synchronous mode of operation
#define ONESTOPBIT			0x00	// Frame contains 1 stopbit
#define TWOSTOPBIT			0x08	// Frame contains 2 stopbits
#define NOPARITY			0x00	// Parity disabled
#define EVENPARITY			0x20	// Generate an even parity bit
#define ODDPARITY			0x30	// Generate an odd parity bit
#define FIVEBIT				0x00	// Frame contains 5 data bits
#define SIXBIT				0x02	// Frame contains 6 data bits
#define SEVENBIT			0x04	// Frame contains 7 data bits
#define EIGHTBIT			0x06	// Frame contains 8 data bits
#define BAUDRATE			9600	// Baudrate for USART
#define SIO_BUFFER_SIZE 	25		// Size of the transmission-buffer
#define DOUBLE_SPEED		UCSRA |= (1<<U2X); // double speed mode
#define BAUDRATE2			1000000	//Baudrate for VNC1L-Communication

#define WAIT_STATE		0
#define PROMPT_DETECTED	2
#define BAD_COMMAND		3
#define COMMAND_FAILURE	4
#define NO_DISK			5

void uart_init(void);
void uart_putchar(char c);
void set_baudrate(void);
void wait_uart_complete(void);


#endif
