#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <stdlib.h>
#include "global.h"
#include "rf12.h"     

#define F_CPU 16000000UL
#include <util/delay.h>

void send(void);
void receive(void);

// LEDs sind active-high geschaltet
#define LED_AN(LED)	(PORTD |=  (1<<(LED)))
#define LED_AUS(LED)	(PORTD &= ~(1<<(LED)))
#define LED_TOGGLE(LED)	(PORTD ^=  (1<<(LED)))
#define LED1		PD6
#define LED2		PD5
#define TASTER	        PB1


int main(void)
{
	DDRD |= (1<<LED1) | (1<<LED2); // Port D: Ausgang fr LED1 und LED2

 	LED_AN(LED1);
  	LED_AUS(LED2);

	rf12_init();					// ein paar Register setzen (z.B. CLK auf 10MHz)
	rf12_setfreq(1660);	//RF12FREQ(433.92) Sende/Empfangsfrequenz auf 433,92MHz einstellen
	rf12_setbandwidth(4, 1, 4);		// 200kHz Bandbreite, -6dB Verstrkung, DRSSI threshold: -79dBm 
	rf12_setbaud(19200);			// 19200 baud
	rf12_setpower(0, 6);			// 1mW Ausgangangsleistung, 120kHz Frequenzshift


	for (;;)
	{
			
	/*	send();

		for (unsigned char i=0; i<100; i++)
		{
				_delay_ms(10);
		}
		LED_TOGGLE(LED1);
    	LED_TOGGLE(LED2);
	*/

		receive();

	}
}

void receive(void)
{	unsigned char test[32];	

	test[0] = 0;

	rf12_rxdata(test,32);	
	// daten verarbeiten

	if(test[0] != 255)

		LED_TOGGLE(LED1);
		LED_AN(LED2);
}

void send(void)
{	unsigned char test[]="Dies ist ein 433MHz Test !!!\n   ";	
	rf12_txdata(test,32);
}

