#ifndef CONFIG_H_
#define CONFIG_H_

#include <stdint.h>
#include <stdbool.h>

typedef struct 
{
  int16_t SollTemp;
  int16_t Hysterese;
  uint16_t Timeout;
  int8_t LFMin;
  int8_t LFMax;
  uint8_t AlarmVolume;

  uint8_t CaseOpen:1;
  uint8_t Regulate:1;
  uint8_t AlarmEnabled:1;
} CConfiguration;

static volatile CConfiguration gConfig;

extern void config_init(void);
extern void config_save(void);


#endif // CONFIG_H_
