/************************************************************************/
/*                                                                      */
/*                      Reading rotary encoder                          */
/*                      one, two and four step encoders supported       */
/*                                                                      */
/*              Author: Peter Dannegger                                 */
/*                                                                      */
/************************************************************************/

#ifndef ENCODER_H_
#define ENCODER_H_

#include <avr/io.h>
#include <stdint.h>
#include <stdbool.h>
 
#define ENCODER_DDR         DDRD
#define ENCODER_PORT        PORTD
#define ENCODER_PIN         PIND

#define ENCODER_PHASE_A     PD2
#define ENCODER_PHASE_B     PD3
#define ENCODER_KEY         PD6

extern volatile int8_t enc_delta;          // -128 ... 127

extern void encode_init(void);
extern int8_t encode_read1(void);         // read single step encoders
extern int8_t encode_read2(void);         // read two step encoders
extern int8_t encode_read4(void);         // read four step encoders
extern bool encode_readKey(void);

extern void encode_cycle(void);           // timer cycle, call every millisecond

#endif // ENCODER_H_
