// Piezo an OC1A und OC1B

#include "piezo.h"
#include <avr/io.h>
#include <avr/interrupt.h>

//static volatile bool gLoud = false;
static volatile bool gActive = false;
static volatile uint8_t gVolume = 100;

const uint8_t  coPins = _BV(PIEZO_PIN1) | _BV(PIEZO_PIN2);
const uint16_t coCounterLimit = (uint16_t)(F_CPU / 140800.0 - 0.5);  // F_CPU / (2.200 Hz * divisor);
const uint8_t  coT1ClockSource = _BV(CS11) | _BV(CS10);

void piezo_init(void)
{
  PIEZO_DDR  |= coPins;
  PIEZO_PORT &= ~coPins;

    // timer 1: 2.2 kHz
    // Piezo: RDI DMT-1206, f = 2200 Hz

    // Fast PWM mode (mode 14)
    // prescaler 64
  TCCR1A = _BV(WGM11) | _BV(COM1A1) | _BV(COM1B1) | _BV(COM1B0);
  TCCR1B = _BV(WGM13) | _BV(WGM12); 
  
  ICR1 = coCounterLimit;
  piezo_setVolume(gVolume);
}

/*
void piezo_setLoud(const bool aLoud)
{
  gLoud = aLoud;

  if ( gActive )
  {
    if ( gLoud )
      TCCR1A |= _BV(COM1B1) | _BV(COM1B0);
    else  
      TCCR1A &= ~(_BV(COM1B1) | _BV(COM1B0));
  }
}
*/

void piezo_setVolume(const uint8_t aVolume)
{
  gVolume = aVolume;

  OCR1A = (uint16_t)((coCounterLimit * gVolume) / 200);
  OCR1B = OCR1A;
}

void piezo_setActive(const bool aActive)
{
  gActive = aActive;

  if ( gActive )
  {
      // enable timer clock source
    TCCR1B |= coT1ClockSource;


    //TCCR1A |= _BV(COM1A1) | _BV(COM1B1) | _BV(COM1B0);

    //if ( gLoud )
    //  TCCR1A |= _BV(COM1B1) | _BV(COM1B0);
  }
  else
    TCCR1B &= ~coT1ClockSource;
    //TCCR1A &= ~(_BV(COM1B1) | _BV(COM1B0) | _BV(COM1A1) | _BV(COM1A0));
}

