# 1 "../dht11.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "../dht11.c"
# 1 "../dht11.h" 1
# 10 "../dht11.h"
# 1 "/usr/local/lib/gcc/avr/4.6.2/include/stdint.h" 1 3 4


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 1 3 4
# 121 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef signed int int8_t __attribute__((__mode__(__QI__)));
typedef unsigned int uint8_t __attribute__((__mode__(__QI__)));
typedef signed int int16_t __attribute__ ((__mode__ (__HI__)));
typedef unsigned int uint16_t __attribute__ ((__mode__ (__HI__)));
typedef signed int int32_t __attribute__ ((__mode__ (__SI__)));
typedef unsigned int uint32_t __attribute__ ((__mode__ (__SI__)));

typedef signed int int64_t __attribute__((__mode__(__DI__)));
typedef unsigned int uint64_t __attribute__((__mode__(__DI__)));
# 142 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int16_t intptr_t;




typedef uint16_t uintptr_t;
# 159 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int8_t int_least8_t;




typedef uint8_t uint_least8_t;




typedef int16_t int_least16_t;




typedef uint16_t uint_least16_t;




typedef int32_t int_least32_t;




typedef uint32_t uint_least32_t;







typedef int64_t int_least64_t;






typedef uint64_t uint_least64_t;
# 213 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int8_t int_fast8_t;




typedef uint8_t uint_fast8_t;




typedef int16_t int_fast16_t;




typedef uint16_t uint_fast16_t;




typedef int32_t int_fast32_t;




typedef uint32_t uint_fast32_t;







typedef int64_t int_fast64_t;






typedef uint64_t uint_fast64_t;
# 273 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int64_t intmax_t;




typedef uint64_t uintmax_t;
# 4 "/usr/local/lib/gcc/avr/4.6.2/include/stdint.h" 2 3 4
# 11 "../dht11.h" 2
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 1 3
# 99 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 1 3
# 126 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 1 3
# 77 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 3
typedef int32_t int_farptr_t;



typedef uint32_t uint_farptr_t;
# 127 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 2 3
# 100 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 238 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 1 3
# 639 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 3
       
# 640 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 3

       

       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
# 239 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 432 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/portpins.h" 1 3
# 433 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3

# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/common.h" 1 3
# 435 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3

# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/version.h" 1 3
# 437 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/fuse.h" 1 3
# 248 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/fuse.h" 3
typedef struct
{
    unsigned char low;
    unsigned char high;
} __fuse_t;
# 440 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/lock.h" 1 3
# 443 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 12 "../dht11.h" 2






void initDHT11(void);
int16_t getTemp(void);
int16_t getHumidity(void);
int readDHT11(void);
# 2 "../dht11.c" 2
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 1 3
# 43 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay_basic.h" 1 3
# 40 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay_basic.h" 3
static inline void _delay_loop_1(uint8_t __count) __attribute__((always_inline));
static inline void _delay_loop_2(uint16_t __count) __attribute__((always_inline));
# 80 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay_basic.h" 3
void
_delay_loop_1(uint8_t __count)
{
 __asm__ volatile (
  "1: dec %0" "\n\t"
  "brne 1b"
  : "=r" (__count)
  : "0" (__count)
 );
}
# 102 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay_basic.h" 3
void
_delay_loop_2(uint16_t __count)
{
 __asm__ volatile (
  "1: sbiw %0,1" "\n\t"
  "brne 1b"
  : "=w" (__count)
  : "0" (__count)
 );
}
# 44 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 2 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 1 3
# 127 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern double cos(double __x) __attribute__((__const__));





extern double sin(double __x) __attribute__((__const__));





extern double tan(double __x) __attribute__((__const__));






extern double fabs(double __x) __attribute__((__const__));






extern double fmod(double __x, double __y) __attribute__((__const__));
# 168 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern double modf(double __x, double *__iptr);



extern float modff (float __x, float *__iptr);




extern double sqrt(double __x) __attribute__((__const__));





extern double cbrt(double __x) __attribute__((__const__));
# 194 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern double hypot (double __x, double __y) __attribute__((__const__));







extern double square(double __x) __attribute__((__const__));






extern double floor(double __x) __attribute__((__const__));






extern double ceil(double __x) __attribute__((__const__));
# 234 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern double frexp(double __x, int *__pexp);







extern double ldexp(double __x, int __exp) __attribute__((__const__));





extern double exp(double __x) __attribute__((__const__));





extern double cosh(double __x) __attribute__((__const__));





extern double sinh(double __x) __attribute__((__const__));





extern double tanh(double __x) __attribute__((__const__));







extern double acos(double __x) __attribute__((__const__));







extern double asin(double __x) __attribute__((__const__));






extern double atan(double __x) __attribute__((__const__));
# 298 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern double atan2(double __y, double __x) __attribute__((__const__));





extern double log(double __x) __attribute__((__const__));





extern double log10(double __x) __attribute__((__const__));





extern double pow(double __x, double __y) __attribute__((__const__));






extern int isnan(double __x) __attribute__((__const__));
# 333 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern int isinf(double __x) __attribute__((__const__));






__attribute__((__const__)) static inline int isfinite (double __x)
{
    unsigned char __exp;
    __asm__ (
 "mov	%0, %C1		\n\t"
 "lsl	%0		\n\t"
 "mov	%0, %D1		\n\t"
 "rol	%0		"
 : "=r" (__exp)
 : "r" (__x) );
    return __exp != 0xff;
}






__attribute__((__const__)) static inline double copysign (double __x, double __y)
{
    __asm__ (
 "bst	%D2, 7	\n\t"
 "bld	%D0, 7	"
 : "=r" (__x)
 : "0" (__x), "r" (__y) );
    return __x;
}
# 376 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern int signbit (double __x) __attribute__((__const__));






extern double fdim (double __x, double __y) __attribute__((__const__));
# 392 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern double fma (double __x, double __y, double __z) __attribute__((__const__));







extern double fmax (double __x, double __y) __attribute__((__const__));







extern double fmin (double __x, double __y) __attribute__((__const__));






extern double trunc (double __x) __attribute__((__const__));
# 426 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern double round (double __x) __attribute__((__const__));
# 439 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern long lround (double __x) __attribute__((__const__));
# 453 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/math.h" 3
extern long lrint (double __x) __attribute__((__const__));
# 45 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 2 3
# 84 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 3
static inline void _delay_us(double __us) __attribute__((always_inline));
static inline void _delay_ms(double __ms) __attribute__((always_inline));
# 141 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 3
void
_delay_ms(double __ms)
{
 uint16_t __ticks;
 double __tmp ;
# 167 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 3
 __tmp = ((16000000UL) / 4e3) * __ms;
 if (__tmp < 1.0)
  __ticks = 1;
 else if (__tmp > 65535)
 {

  __ticks = (uint16_t) (__ms * 10.0);
  while(__ticks)
  {

   _delay_loop_2(((16000000UL) / 4e3) / 10);
   __ticks --;
  }
  return;
 }
 else
  __ticks = (uint16_t)__tmp;
 _delay_loop_2(__ticks);

}
# 223 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 3
void
_delay_us(double __us)
{
 uint8_t __ticks;
 double __tmp ;
# 249 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/delay.h" 3
 __tmp = ((16000000UL) / 3e6) * __us;
 if (__tmp < 1.0)
  __ticks = 1;
 else if (__tmp > 255)
 {
  _delay_ms(__us / 1000.0);
  return;
 }
 else
  __ticks = (uint8_t)__tmp;
 _delay_loop_1(__ticks);

}
# 3 "../dht11.c" 2
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/atomic.h" 1 3
# 38 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/atomic.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/interrupt.h" 1 3
# 39 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/util/atomic.h" 2 3



static __inline__ uint8_t __iSeiRetVal(void)
{
    __asm__ __volatile__ ("sei" ::: "memory");
    return 1;
}

static __inline__ uint8_t __iCliRetVal(void)
{
    __asm__ __volatile__ ("cli" ::: "memory");
    return 1;
}

static __inline__ void __iSeiParam(const uint8_t *__s)
{
    __asm__ __volatile__ ("sei" ::: "memory");
    __asm__ volatile ("" ::: "memory");
    (void)__s;
}

static __inline__ void __iCliParam(const uint8_t *__s)
{
    __asm__ __volatile__ ("cli" ::: "memory");
    __asm__ volatile ("" ::: "memory");
    (void)__s;
}

static __inline__ void __iRestore(const uint8_t *__s)
{
    (*(volatile uint8_t *)((0x3F) + 0x20)) = *__s;
    __asm__ volatile ("" ::: "memory");
}
# 4 "../dht11.c" 2



static uint8_t gDHT11_data[5] = {0, 0, 0, 0};

uint8_t read_dht11_dat(void)
{
 int i = 0;
 uint8_t result = 0;

  for(i=0; i < 8; i++)
  {
  while( ! ((*(volatile uint8_t *)((0x19) + 0x20)) & (1 << (0))) )
      ;

    _delay_us(30);

  if ( (*(volatile uint8_t *)((0x19) + 0x20)) & (1 << (0)) )
   result |= (1<<(7-i));

    while( ((*(volatile uint8_t *)((0x19) + 0x20)) & (1 << (0))) )
      ;
 }

 return result;
}


void initDHT11(void)
{

 (*(volatile uint8_t *)((0x1A) + 0x20)) |= (1 << (0));

 (*(volatile uint8_t *)((0x1B) + 0x20)) |= (1 << (0));
}

int readDHT11(void)
{
 uint8_t dht11_in;



 (*(volatile uint8_t *)((0x1B) + 0x20)) &= ~(1 << (0));
 _delay_ms(18);
 (*(volatile uint8_t *)((0x1B) + 0x20)) |= (1 << (0));
 _delay_us(40);

 (*(volatile uint8_t *)((0x1A) + 0x20)) &= ~(1 << (0));
 _delay_us(40);

 dht11_in = (*(volatile uint8_t *)((0x19) + 0x20)) & (1 << (0));

 if (dht11_in)
  {
    (*(volatile uint8_t *)((0x1A) + 0x20)) |= (1 << (0));
   (*(volatile uint8_t *)((0x1B) + 0x20)) |= (1 << (0));
  return -1;
 }
 _delay_us(80);

 dht11_in = (*(volatile uint8_t *)((0x19) + 0x20)) & (1 << (0));

 if (!dht11_in)
  {
    (*(volatile uint8_t *)((0x1A) + 0x20)) |= (1 << (0));
   (*(volatile uint8_t *)((0x1B) + 0x20)) |= (1 << (0));

    return -1;
 }
 _delay_us(80);


 for (int i=0; i < 5; i++)
  {
  gDHT11_data[i] = read_dht11_dat();
  }

 (*(volatile uint8_t *)((0x1A) + 0x20)) |= (1 << (0));
 (*(volatile uint8_t *)((0x1B) + 0x20)) |= (1 << (0));

  uint8_t dht11_check_sum = gDHT11_data[0]+gDHT11_data[1]+gDHT11_data[2]+gDHT11_data[3];


 if (gDHT11_data[4] != dht11_check_sum)
 {
  return -2;
 }

 return 0;
}

int16_t getTemp(void)
{
  return ((uint16_t)gDHT11_data[2]) << 8 | gDHT11_data[3];
}

int16_t getHumidity(void)
{
  return ((uint16_t)gDHT11_data[0]) << 8 | gDHT11_data[1];
}
