# 1 "../ds18x20.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "../ds18x20.c"
# 24 "../ds18x20.c"
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 1 3
# 47 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/include/stddef.h" 1 3 4
# 212 "/usr/local/lib/gcc/avr/4.6.2/include/stddef.h" 3 4
typedef unsigned int size_t;
# 324 "/usr/local/lib/gcc/avr/4.6.2/include/stddef.h" 3 4
typedef int wchar_t;
# 48 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 2 3
# 68 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
typedef struct {
 int quot;
 int rem;
} div_t;


typedef struct {
 long quot;
 long rem;
} ldiv_t;


typedef int (*__compar_fn_t)(const void *, const void *);
# 106 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern void abort(void) __attribute__((__noreturn__));




extern int abs(int __i) __attribute__((__const__));
# 120 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern long labs(long __i) __attribute__((__const__));
# 143 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern void *bsearch(const void *__key, const void *__base, size_t __nmemb,
       size_t __size, int (*__compar)(const void *, const void *));







extern div_t div(int __num, int __denom) __asm__("__divmodhi4") __attribute__((__const__));





extern ldiv_t ldiv(long __num, long __denom) __asm__("__divmodsi4") __attribute__((__const__));
# 175 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern void qsort(void *__base, size_t __nmemb, size_t __size,
    __compar_fn_t __compar);
# 208 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern long strtol(const char *__nptr, char **__endptr, int __base);
# 242 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern unsigned long strtoul(const char *__nptr, char **__endptr, int __base);
# 254 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern long atol(const char *__s) __attribute__((__pure__));
# 266 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern int atoi(const char *__s) __attribute__((__pure__));
# 278 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern void exit(int __status) __attribute__((__noreturn__));
# 290 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern void *malloc(size_t __size) __attribute__((__malloc__));






extern void free(void *__ptr);




extern size_t __malloc_margin;




extern char *__malloc_heap_start;




extern char *__malloc_heap_end;






extern void *calloc(size_t __nele, size_t __size) __attribute__((__malloc__));
# 338 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern void *realloc(void *__ptr, size_t __size) __attribute__((__malloc__));

extern double strtod(const char *__nptr, char **__endptr);

extern double atof(const char *__nptr);
# 364 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern int rand(void);



extern void srand(unsigned int __seed);






extern int rand_r(unsigned long *__ctx);
# 406 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern char *itoa(int __val, char *__s, int __radix);
# 434 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern char *ltoa(long int __val, char *__s, int __radix);
# 460 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern char *utoa(unsigned int __val, char *__s, int __radix);
# 486 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern char *ultoa(unsigned long int __val, char *__s, int __radix);
# 504 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern long random(void);




extern void srandom(unsigned long __seed);







extern long random_r(unsigned long *__ctx);
# 563 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern char *dtostre(double __val, char *__s, unsigned char __prec,
       unsigned char __flags);
# 580 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdlib.h" 3
extern char *dtostrf(double __val, signed char __width,
                     unsigned char __prec, char *__s);
# 25 "../ds18x20.c" 2
# 1 "/usr/local/lib/gcc/avr/4.6.2/include/stdint.h" 1 3 4


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 1 3 4
# 121 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef signed int int8_t __attribute__((__mode__(__QI__)));
typedef unsigned int uint8_t __attribute__((__mode__(__QI__)));
typedef signed int int16_t __attribute__ ((__mode__ (__HI__)));
typedef unsigned int uint16_t __attribute__ ((__mode__ (__HI__)));
typedef signed int int32_t __attribute__ ((__mode__ (__SI__)));
typedef unsigned int uint32_t __attribute__ ((__mode__ (__SI__)));

typedef signed int int64_t __attribute__((__mode__(__DI__)));
typedef unsigned int uint64_t __attribute__((__mode__(__DI__)));
# 142 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int16_t intptr_t;




typedef uint16_t uintptr_t;
# 159 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int8_t int_least8_t;




typedef uint8_t uint_least8_t;




typedef int16_t int_least16_t;




typedef uint16_t uint_least16_t;




typedef int32_t int_least32_t;




typedef uint32_t uint_least32_t;







typedef int64_t int_least64_t;






typedef uint64_t uint_least64_t;
# 213 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int8_t int_fast8_t;




typedef uint8_t uint_fast8_t;




typedef int16_t int_fast16_t;




typedef uint16_t uint_fast16_t;




typedef int32_t int_fast32_t;




typedef uint32_t uint_fast32_t;







typedef int64_t int_fast64_t;






typedef uint64_t uint_fast64_t;
# 273 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int64_t intmax_t;




typedef uint64_t uintmax_t;
# 4 "/usr/local/lib/gcc/avr/4.6.2/include/stdint.h" 2 3 4
# 26 "../ds18x20.c" 2

# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 1 3
# 99 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 1 3
# 126 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 1 3
# 77 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 3
typedef int32_t int_farptr_t;



typedef uint32_t uint_farptr_t;
# 127 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 2 3
# 100 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 238 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 1 3
# 639 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 3
       
# 640 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 3

       

       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
# 239 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 432 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/portpins.h" 1 3
# 433 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3

# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/common.h" 1 3
# 435 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3

# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/version.h" 1 3
# 437 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/fuse.h" 1 3
# 248 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/fuse.h" 3
typedef struct
{
    unsigned char low;
    unsigned char high;
} __fuse_t;
# 440 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/lock.h" 1 3
# 443 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 28 "../ds18x20.c" 2
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/pgmspace.h" 1 3
# 87 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/pgmspace.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/include/stddef.h" 1 3 4
# 88 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/pgmspace.h" 2 3
# 1037 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/pgmspace.h" 3
extern const void * memchr_P(const void *, int __val, size_t __len) __attribute__((__const__));
extern int memcmp_P(const void *, const void *, size_t) __attribute__((__pure__));
extern void *memccpy_P(void *, const void *, int __val, size_t);
extern void *memcpy_P(void *, const void *, size_t);
extern void *memmem_P(const void *, size_t, const void *, size_t) __attribute__((__pure__));
extern const void * memrchr_P(const void *, int __val, size_t __len) __attribute__((__const__));
extern char *strcat_P(char *, const char *);
extern const char * strchr_P(const char *, int __val) __attribute__((__const__));
extern const char * strchrnul_P(const char *, int __val) __attribute__((__const__));
extern int strcmp_P(const char *, const char *) __attribute__((__pure__));
extern char *strcpy_P(char *, const char *);
extern int strcasecmp_P(const char *, const char *) __attribute__((__pure__));
extern char *strcasestr_P(const char *, const char *) __attribute__((__pure__));
extern size_t strcspn_P(const char *__s, const char * __reject) __attribute__((__pure__));
extern size_t strlcat_P (char *, const char *, size_t );
extern size_t strlcpy_P (char *, const char *, size_t );
extern size_t __strlen_P(const char *) __attribute__((__const__));
extern size_t strnlen_P(const char *, size_t) __attribute__((__const__));
extern int strncmp_P(const char *, const char *, size_t) __attribute__((__pure__));
extern int strncasecmp_P(const char *, const char *, size_t) __attribute__((__pure__));
extern char *strncat_P(char *, const char *, size_t);
extern char *strncpy_P(char *, const char *, size_t);
extern char *strpbrk_P(const char *__s, const char * __accept) __attribute__((__pure__));
extern const char * strrchr_P(const char *, int __val) __attribute__((__const__));
extern char *strsep_P(char **__sp, const char * __delim);
extern size_t strspn_P(const char *__s, const char * __accept) __attribute__((__pure__));
extern char *strstr_P(const char *, const char *) __attribute__((__pure__));
extern char *strtok_P(char *__s, const char * __delim);
extern char *strtok_rP(char *__s, const char * __delim, char **__last);

extern size_t strlen_PF (uint_farptr_t src) __attribute__((__const__));
extern size_t strnlen_PF (uint_farptr_t src, size_t len) __attribute__((__const__));
extern void *memcpy_PF (void *dest, uint_farptr_t src, size_t len);
extern char *strcpy_PF (char *dest, uint_farptr_t src);
extern char *strncpy_PF (char *dest, uint_farptr_t src, size_t len);
extern char *strcat_PF (char *dest, uint_farptr_t src);
extern size_t strlcat_PF (char *dst, uint_farptr_t src, size_t siz);
extern char *strncat_PF (char *dest, uint_farptr_t src, size_t len);
extern int strcmp_PF (const char *s1, uint_farptr_t s2) __attribute__((__pure__));
extern int strncmp_PF (const char *s1, uint_farptr_t s2, size_t n) __attribute__((__pure__));
extern int strcasecmp_PF (const char *s1, uint_farptr_t s2) __attribute__((__pure__));
extern int strncasecmp_PF (const char *s1, uint_farptr_t s2, size_t n) __attribute__((__pure__));
extern char *strstr_PF (const char *s1, uint_farptr_t s2);
extern size_t strlcpy_PF (char *dst, uint_farptr_t src, size_t siz);
extern int memcmp_PF(const void *, uint_farptr_t, size_t) __attribute__((__pure__));


__attribute__((__always_inline__)) static inline size_t strlen_P(const char * s);
static inline size_t strlen_P(const char *s) {
  return __builtin_constant_p(__builtin_strlen(s))
     ? __builtin_strlen(s) : __strlen_P(s);
}
# 29 "../ds18x20.c" 2

# 1 "../ds18x20.h" 1
# 84 "../ds18x20.h"
extern uint8_t DS18X20_find_sensor(uint8_t *diff, uint8_t id[]);
extern uint8_t DS18X20_get_power_status(uint8_t id[]);
extern uint8_t DS18X20_start_meas( uint8_t with_external, uint8_t id[]);


extern uint8_t DS18X20_conversion_in_progress(void);




extern uint8_t DS18X20_read_decicelsius_single( uint8_t familycode, int16_t *decicelsius );
extern uint8_t DS18X20_format_from_decicelsius( int16_t decicelsius, char s[], uint8_t n);
# 31 "../ds18x20.c" 2
# 1 "../onewire.h" 1
# 67 "../onewire.h"
extern uint8_t ow_reset(void);

extern uint8_t ow_bit_io( uint8_t b );
extern uint8_t ow_byte_wr( uint8_t b );
extern uint8_t ow_byte_rd( void );

extern uint8_t ow_rom_search( uint8_t diff, uint8_t *id );

extern void ow_command( uint8_t command, uint8_t *id );
extern void ow_command_with_parasite_enable( uint8_t command, uint8_t *id );

extern void ow_parasite_enable( void );
extern void ow_parasite_disable( void );
extern uint8_t ow_input_pin_state( void );


extern void ow_set_bus( volatile uint8_t* in,
 volatile uint8_t* out,
 volatile uint8_t* ddr,
 uint8_t pin );
# 32 "../ds18x20.c" 2
# 1 "../crc8.h" 1
# 10 "../crc8.h"
uint8_t crc8( uint8_t* data, uint16_t number_of_bytes_in_data );
# 33 "../ds18x20.c" 2
# 282 "../ds18x20.c"
uint8_t DS18X20_find_sensor( uint8_t *diff, uint8_t id[] )
{
 uint8_t go;
 uint8_t ret;

 ret = 0x00;
 go = 1;
 do {
  *diff = ow_rom_search( *diff, &id[0] );
  if ( *diff == 0xFF || *diff == 0xFE ||
       *diff == 0x00 ) {
   go = 0;
   ret = 0x01;
  } else {
   if ( id[0] == 0x28 || id[0] == 0x10 ||
        id[0] == 0x22 ) {
    go = 0;
   }
  }
 } while (go);

 return ret;
}




uint8_t DS18X20_get_power_status( uint8_t id[] )
{
 uint8_t pstat;

 ow_reset();
 ow_command( 0xB4, id );
 pstat = ow_bit_io( 1 );
 ow_reset();
 return ( pstat ) ? 0x01 : 0x00;
}



uint8_t DS18X20_start_meas( uint8_t with_power_extern, uint8_t id[])
{
 uint8_t ret;

 ow_reset();
 if( ow_input_pin_state() ) {
  if ( with_power_extern != 0x01 ) {
   ow_command_with_parasite_enable( 0x44, id );

  } else {
   ow_command( 0x44, id );
  }
  ret = 0x00;
 }
 else {
  ;
  ret = 0x02;
 }

 return ret;
}



uint8_t DS18X20_conversion_in_progress(void)
{
 return ow_bit_io( 1 ) ? 0x00 : 0x01;
}

static uint8_t read_scratchpad( uint8_t id[], uint8_t sp[], uint8_t n )
{
 uint8_t i;
 uint8_t ret;

 ow_command( 0xBE, id );
 for ( i = 0; i < n; i++ ) {
  sp[i] = ow_byte_rd();
 }
 if ( crc8( &sp[0], 9 ) ) {
  ret = 0x03;
 } else {
  ret = 0x00;
 }

 return ret;
}





static int16_t DS18X20_raw_to_decicelsius( uint8_t familycode, uint8_t sp[] )
{
 uint16_t measure;
 uint8_t negative;
 int16_t decicelsius;
 uint16_t fract;

 measure = sp[0] | (sp[1] << 8);



 if( familycode == 0x10 ) {

  measure &= (uint16_t)0xfffe;
  measure <<= 3;
  measure += (16 - sp[6]) - 4;
 }


 if ( measure & 0x8000 ) {
  negative = 1;
  measure ^= 0xffff;
  measure++;
 }
 else {
  negative = 0;
 }


 if ( familycode == 0x28 || familycode == 0x22 ) {
  switch( sp[4] & ((1<<6)|(1<<5)) ) {
  case 0:
   measure &= ~(((1<<0)|(1<<1)|(1<<2)));
   break;
  case (1<<5):
   measure &= ~(((1<<0)|(1<<1)));
   break;
  case (1<<6):
   measure &= ~(((1<<0)));
   break;
  default:

   break;
  }
 }

 decicelsius = (measure >> 4);
 decicelsius *= 10;



 fract = ( measure & 0x000F ) * 640;
 if ( !negative ) {
  fract += 512;
 }
 fract /= 1024;
 decicelsius += fract;

 if ( negative ) {
  decicelsius = -decicelsius;
 }

 if ( decicelsius < -550 || decicelsius > 1250 ) {
  return 2000;
 } else {
  return decicelsius;
 }
}





uint8_t DS18X20_format_from_decicelsius( int16_t decicelsius, char str[], uint8_t n)
{
 uint8_t sign = 0;
 char temp[7];
 int8_t temp_loc = 0;
 uint8_t str_loc = 0;
 div_t dt;
 uint8_t ret;


 if ( n >= (6+1) && decicelsius > -1000 && decicelsius < 10000 ) {

  if ( decicelsius < 0) {
   sign = 1;
   decicelsius = -decicelsius;
  }


  do {
   dt = div(decicelsius,10);
   temp[temp_loc++] = dt.rem + '0';
   decicelsius = dt.quot;
  } while ( decicelsius > 0 );

  if ( sign ) {
   temp[temp_loc] = '-';
  } else {

   temp[temp_loc] = '+';
  }


  while ( temp_loc >=0 ) {
   str[str_loc++] = temp[(uint8_t)temp_loc--];
   if ( temp_loc == 0 ) {
    str[str_loc++] = '.';
   }
  }
  str[str_loc] = '\0';

  ret = 0x00;
 } else {
  ret = 0x01;
 }

 return ret;
}
# 515 "../ds18x20.c"
uint8_t DS18X20_read_decicelsius_single( uint8_t familycode, int16_t *decicelsius )
{
 uint8_t sp[9];
 uint8_t ret;

 ret = read_scratchpad( ((void *)0), sp, 9 );
 if ( ret == 0x00 ) {
  *decicelsius = DS18X20_raw_to_decicelsius( familycode, sp );
 }
 return ret;
}
