# 1 "../encoder.c"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "../encoder.c"
# 11 "../encoder.c"
# 1 "../encoder.h" 1
# 13 "../encoder.h"
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 1 3
# 99 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 1 3
# 126 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 1 3
# 37 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/include/stdint.h" 1 3 4


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 1 3 4
# 121 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef signed int int8_t __attribute__((__mode__(__QI__)));
typedef unsigned int uint8_t __attribute__((__mode__(__QI__)));
typedef signed int int16_t __attribute__ ((__mode__ (__HI__)));
typedef unsigned int uint16_t __attribute__ ((__mode__ (__HI__)));
typedef signed int int32_t __attribute__ ((__mode__ (__SI__)));
typedef unsigned int uint32_t __attribute__ ((__mode__ (__SI__)));

typedef signed int int64_t __attribute__((__mode__(__DI__)));
typedef unsigned int uint64_t __attribute__((__mode__(__DI__)));
# 142 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int16_t intptr_t;




typedef uint16_t uintptr_t;
# 159 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int8_t int_least8_t;




typedef uint8_t uint_least8_t;




typedef int16_t int_least16_t;




typedef uint16_t uint_least16_t;




typedef int32_t int_least32_t;




typedef uint32_t uint_least32_t;







typedef int64_t int_least64_t;






typedef uint64_t uint_least64_t;
# 213 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int8_t int_fast8_t;




typedef uint8_t uint_fast8_t;




typedef int16_t int_fast16_t;




typedef uint16_t uint_fast16_t;




typedef int32_t int_fast32_t;




typedef uint32_t uint_fast32_t;







typedef int64_t int_fast64_t;






typedef uint64_t uint_fast64_t;
# 273 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/stdint.h" 3 4
typedef int64_t intmax_t;




typedef uint64_t uintmax_t;
# 4 "/usr/local/lib/gcc/avr/4.6.2/include/stdint.h" 2 3 4
# 38 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 2 3
# 77 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/inttypes.h" 3
typedef int32_t int_farptr_t;



typedef uint32_t uint_farptr_t;
# 127 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/sfr_defs.h" 2 3
# 100 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 238 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 1 3
# 639 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 3
       
# 640 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/iom16.h" 3

       

       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
# 239 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 432 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 3
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/portpins.h" 1 3
# 433 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3

# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/common.h" 1 3
# 435 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3

# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/version.h" 1 3
# 437 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/fuse.h" 1 3
# 248 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/fuse.h" 3
typedef struct
{
    unsigned char low;
    unsigned char high;
} __fuse_t;
# 440 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3


# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/lock.h" 1 3
# 443 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/io.h" 2 3
# 14 "../encoder.h" 2

# 1 "/usr/local/lib/gcc/avr/4.6.2/include/stdbool.h" 1 3 4
# 16 "../encoder.h" 2
# 25 "../encoder.h"
extern volatile int8_t enc_delta;

extern void encode_init(void);
extern int8_t encode_read1(void);
extern int8_t encode_read2(void);
extern int8_t encode_read4(void);
extern _Bool encode_readKey(void);

extern void encode_cycle(void);
# 12 "../encoder.c" 2
# 1 "/usr/local/lib/gcc/avr/4.6.2/../../../../avr/include/avr/interrupt.h" 1 3
# 13 "../encoder.c" 2

volatile int8_t enc_delta;
volatile _Bool enc_key;
volatile _Bool enc_newkey;
static int8_t last;

void encode_init( void )
{
  const uint8_t coBits = (1 << (2)) | (1 << (3)) | (1 << (6));


  (*(volatile uint8_t *)((0x11) + 0x20)) &= ~coBits;

  (*(volatile uint8_t *)((0x12) + 0x20)) |= coBits;

  int8_t new;

  new = 0;
  if( (*(volatile uint8_t *)((0x10) + 0x20)) & (1 << (2)) )
    new = 3;
  if( (*(volatile uint8_t *)((0x10) + 0x20)) & (1 << (3)) )
    new ^= 1;
  last = new;
  enc_delta = 0;
  enc_key = 0;
}

void encode_cycle(void)
{
  int8_t new, diff;

  new = 0;
  if( (*(volatile uint8_t *)((0x10) + 0x20)) & (1 << (2)) )
    new = 3;
  if( (*(volatile uint8_t *)((0x10) + 0x20)) & (1 << (3)) )
    new ^= 1;

  diff = last - new;

  if( diff & 1 )
  {
    last = new;
    enc_delta += (diff & 2) - 1;
  }

  static _Bool lastKey = 0;
  lastKey = enc_key;
  enc_key = 0 != ((*(volatile uint8_t *)((0x10) + 0x20)) & (1 << (6)));

  if ( !lastKey && enc_key )
    enc_newkey = 1;
}

int8_t encode_read1( void )
{
  int8_t val;

  __asm__ __volatile__ ("cli" ::: "memory");
  val = enc_delta;
  enc_delta = 0;
  __asm__ __volatile__ ("sei" ::: "memory");
  return val;
}

int8_t encode_read2( void )
{
  int8_t val;

  __asm__ __volatile__ ("cli" ::: "memory");
  val = enc_delta;
  enc_delta = val & 1;
  __asm__ __volatile__ ("sei" ::: "memory");
  return val >> 1;
}


int8_t encode_read4( void )
{
  int8_t val;

  __asm__ __volatile__ ("cli" ::: "memory");
  val = enc_delta;
  enc_delta = val & 3;
  __asm__ __volatile__ ("sei" ::: "memory");
  return val >> 2;
}


_Bool encode_readKey(void)
{
  _Bool lKeyState = enc_newkey;

  enc_newkey = 0;

  return lKeyState;
}
