#include "dht11.h"
#include <util/delay.h>
#include <util/atomic.h>
#include <avr/io.h>
#include <avr/interrupt.h>

static uint8_t gDHT11_data[5] = {0, 0, 0, 0};

uint8_t read_dht11_dat(void)
{
	int i = 0;
	uint8_t result = 0;
	
  for(i=0; i < 8; i++)
  {
		while( ! (DHT11_IN & _BV(DHT11_PIN)) )
      ;  // wait for 50us
		
    _delay_us(30);

		if ( DHT11_IN & _BV(DHT11_PIN) )
			result |= (1<<(7-i));

    while( (DHT11_IN & _BV(DHT11_PIN)) )
      ;  // wait '1' finish
	}

	return result;
}


void initDHT11(void)
{
    // input
	DHT11_DDR |= _BV(DHT11_PIN);
    // pull up
	DHT11_OUT |= _BV(DHT11_PIN);
}

int readDHT11(void)
{
	uint8_t dht11_in;

	// start condition
	// 1. pull-down i/o pin for 18ms  
	DHT11_OUT &= ~_BV(DHT11_PIN);
	_delay_ms(18);
	DHT11_OUT |= _BV(DHT11_PIN);
	_delay_us(40);

	DHT11_DDR &= ~_BV(DHT11_PIN);
	_delay_us(40);

	dht11_in = DHT11_IN & _BV(DHT11_PIN);

	if (dht11_in)
  {
   	DHT11_DDR |= _BV(DHT11_PIN);
	  DHT11_OUT |= _BV(DHT11_PIN);
		return -1;
	}
	_delay_us(80);

	dht11_in = DHT11_IN & _BV(DHT11_PIN);

	if (!dht11_in)
  {
   	DHT11_DDR |= _BV(DHT11_PIN);
	  DHT11_OUT |= _BV(DHT11_PIN);
    //return -2;
    return -1;
	}
	_delay_us(80);

	// now ready for data reception
	for (int i=0; i < 5; i++)
  {
		gDHT11_data[i] = read_dht11_dat();
  }

	DHT11_DDR |= _BV(DHT11_PIN);
	DHT11_OUT |= _BV(DHT11_PIN);

  uint8_t dht11_check_sum = gDHT11_data[0]+gDHT11_data[1]+gDHT11_data[2]+gDHT11_data[3];
	
  // check check_sum
	if (gDHT11_data[4] != dht11_check_sum)
	{
		return -2;
	}

	return 0;
}

int16_t getTemp(void)
{
  return ((uint16_t)gDHT11_data[2]) << 8 | gDHT11_data[3];
}

int16_t getHumidity(void)
{
  return ((uint16_t)gDHT11_data[0]) << 8 | gDHT11_data[1];
}


 
