//
// encoder - Auswerten Drehencoder
//  
// Original Code: (c) Peter Dannegger
// Erweiterung: Thomas Koos
//
//  - Einlesen des Tasters eingefgt
//  - Timer ausgelagert
//

#include "encoder.h"
#include <avr/interrupt.h>

volatile int8_t enc_delta;          // -128 ... 127
volatile bool enc_key;
volatile bool enc_newkey;
static int8_t last;

void encode_init( void )
{
  const uint8_t coBits = _BV(ENCODER_PHASE_A) | _BV(ENCODER_PHASE_B) | _BV(ENCODER_KEY);

    // input
  ENCODER_DDR  &= ~coBits;
    // enable pull ups
  ENCODER_PORT |= coBits;
  
  int8_t new;
 
  new = 0;
  if( ENCODER_PIN & _BV(ENCODER_PHASE_A) )
    new = 3;
  if( ENCODER_PIN & _BV(ENCODER_PHASE_B) )
    new ^= 1;                   // convert gray to binary
  last = new;                   // power on state
  enc_delta = 0;
  enc_key = false;
}
 
void encode_cycle(void)           // timer cycle, call every millisecond
{
  int8_t new, diff;
 
  new = 0;
  if( ENCODER_PIN & _BV(ENCODER_PHASE_A) )
    new = 3;
  if( ENCODER_PIN & _BV(ENCODER_PHASE_B) )
    new ^= 1;                       // convert gray to binary

  diff = last - new;                // difference last - new

  if( diff & 1 )                    // bit 0 = value (1)
  {
    last = new;                     // store new as next last
    enc_delta += (diff & 2) - 1;    // bit 1 = direction (+/-)
  }

  static bool lastKey = false;
  lastKey = enc_key;
  enc_key = 0 !=  (ENCODER_PIN & _BV(ENCODER_KEY));

  if ( !lastKey && enc_key )
    enc_newkey = true;
}
 
int8_t encode_read1( void )         // read single step encoders
{
  int8_t val;
 
  cli();
  val = enc_delta;
  enc_delta = 0;
  sei();
  return val;                   // counts since last call
}

int8_t encode_read2( void )         // read two step encoders
{
  int8_t val;
 
  cli();
  val = enc_delta;
  enc_delta = val & 1;
  sei();
  return val >> 1;
}
 
 
int8_t encode_read4( void )         // read four step encoders
{
  int8_t val;
 
  cli();
  val = enc_delta;
  enc_delta = val & 3;
  sei();
  return val >> 2;
}


bool encode_readKey(void)
{
  bool lKeyState = enc_newkey;

  enc_newkey = false;

  return lKeyState;
}
 

