
#include "m50530.h"
#include <util/delay.h>
#include <avr/pgmspace.h>

void LCDToggleEX(void)
{
  //_delay_us(5);

  LCDCTRLPORT |= _BV(LCDPIN_EX);
  
  _delay_us(2);  // 10

  LCDCTRLPORT &= ~_BV(LCDPIN_EX);

  //_delay_us(5);
}

int LCDIsBusy(void)
{
  unsigned char lInpData = 0;
  int lBusyFlag = 0;
  int l4BitFlag = 0;

    // data port set up to input
  LCDDATADIR &= 0xf0;
  
    // set RW signal
  LCDCTRLPORT |= _BV(LCDPIN_RW);

    // delay?
  //_delay_us(5);  

    // set EX signal
  LCDCTRLPORT |= _BV(LCDPIN_EX);

    // delay?
  //_delay_us(2); // 10

    // read 1st nibble
  lInpData = LCDDATAPIN;

    // clear EX signal
  LCDCTRLPORT &= ~_BV(LCDPIN_EX);

  lBusyFlag =  ( lInpData & (1 << 3) );
  l4BitFlag = !( lInpData & (1 << 2) );

    // delay?
  //_delay_us(5);  

    // read 2nd nibble
  if ( l4BitFlag )
  {
      // set EX signal
    LCDCTRLPORT |= _BV(LCDPIN_EX);

      // delay?
    //_delay_us(2);  // 10

      // read 2nd nibble
    LCDDATAPIN;

      // clear EX signal
    LCDCTRLPORT &= ~_BV(LCDPIN_EX);
  }

  //_delay_us(10);

    // clear RW signal
  LCDCTRLPORT &= ~_BV(LCDPIN_RW);

    // set data port back to output
  LCDDATADIR |= 0x0f;
    // clear data outputs
  LCDDATAPORT &= 0xf0;

  return lBusyFlag;
}

void LCDSend(const uint8_t aControl, char aData)
{
  unsigned char lHN = ( aData & 0xf0 ) >> 4;
  unsigned char lLN = ( aData & 0x0f );
  
  while ( LCDIsBusy() ) 
    ;

  LCDCTRLPORT &= ~(_BV(LCDPIN_RW) | _BV(LCDPIN_IOC1) | _BV(LCDPIN_IOC2) | _BV(LCDPIN_EX));
  LCDCTRLPORT |= aControl;

  LCDDATAPORT &= 0xf0;
  LCDDATAPORT |= lHN;

  LCDToggleEX();

  LCDDATAPORT &= 0xf0;
  LCDDATAPORT |= lLN;
  
  LCDToggleEX();

  LCDDATAPORT &= 0xf0;
  LCDCTRLPORT &= ~aControl;

  _delay_us(10);
}

void LCDInit(void)
{
    // port setup
  LCDDATADIR |= 0x0f;
  LCDCTRLDIR |= _BV(LCDPIN_RW) | _BV(LCDPIN_IOC1) | _BV(LCDPIN_IOC2) | _BV(LCDPIN_EX);
  
    // SF - Set Function Mode
	//  >> 4 Bit I/O, 5x8 Font, 1/32 duty
	//	>> 4 lines x 40 words, 96 words CG RAM (12 UDF)
  LCDSend( 0, LCD_CMD_SETFUNCTIONMODE | sfIO4BIT | sfFont5x8 | 0x0B );

    // SE - Set Entry Mode
  LCDSend( 0, LCD_CMD_SETENTRYMODE | emCursorIncWrite );

    // SU - Set Underline Mode
  LCDSend( 0, LCD_CMD_SETUNDERLINEMODE | suNoUnderline );

    // SB - Set Blinking Frequency
  LCDSend( 0, LCD_CMD_SETBLINKINGFREQUENCY | sbNormal );

    // SD - Set Display Mode
  LCDSend( 0, LCD_CMD_SETDISPLAYMODE | dmDisplayOn /*| dmCursorOn*/ | dmCursorBlink);

    // CH - Clear Cursor of DD RAM display data home & display start address home
  LCDSend( 0, LCD_CMD_CLEARCURSORDATAADDRHOME ); 

  _delay_ms(2);
}

  // setzt den Cursor an die angegebene Position (y = Zeile, x = Spalte)
void LCDSetCursorPos(const uint8_t y, const uint8_t x)
{
    // Adresse aus x und y berechnen
    // Adressen sind wie folgt: Zeile 0 = 0; Zeile 1 = 40; Zeile 2 = 80; Zeile 3 = 120; Zeile 4 = 160; Zeile 5 = 64+24; Zeile 6 = 128+24; Zeile 7 = 192+24
  const uint8_t address = x + (y*40);

  LCDSend(_BV(LCDPIN_IOC1)|_BV(LCDPIN_IOC2), address);
}

  // schreibt die bergebene Zeichenkette an die aktuelle Cursor-Position
void LCDWrite(const char * c)
{
  while (*c) 
    LCDWriteChar(*c++);
}

  // schreibt die bergebene Zeichenkette aus dem Programmspeicher 
  // an die aktuelle Cursor-Position
void LCDWritePGM(const char * c)
{
  uint8_t b;

  while ( (b = pgm_read_byte(c++)) )
	  LCDWriteChar(b);
}

void LCDWriteBuffer(const uint8_t aAddress, const uint8_t * aBuffer, const uint8_t aBufferSize)
{
  LCDSend(_BV(LCDPIN_IOC1)|_BV(LCDPIN_IOC2), aAddress);
  for (uint8_t i = 0; i < aBufferSize; ++i)
    LCDWriteChar(*aBuffer++);
}

void LCDWriteBufferPGM(const uint8_t aAddress, const uint8_t * aBuffer, const uint8_t aBufferSize)
{
  LCDSend(_BV(LCDPIN_IOC1)|_BV(LCDPIN_IOC2), aAddress);
  for (uint8_t i = 0; i < aBufferSize; ++i)
    LCDWriteChar(pgm_read_byte(aBuffer++));
}

void LCDWriteLoop(const char c, uint8_t aCount)
{
  while ( aCount-- )
    LCDWriteChar(c);
}

