#ifndef M50530_H
#define M50530_H

#include <avr/io.h>
#include <stdint.h>


  // Data and Control signals can be connected to different ports!

  // data port, LCD signals DB4-DB7 have to be connected to P0-P3
#define LCDDATAPORT PORTC
#define LCDDATADIR  DDRC
#define LCDDATAPIN  PINC

  // control port, LCD signals RW, EX, I/OC1, I/OC2
#define LCDCTRLPORT PORTC
#define LCDCTRLDIR  DDRC
//#define LCDCTRLPIN  PINC
#define LCDPIN_RW   PC6
#define LCDPIN_IOC1 PC7
#define LCDPIN_IOC2 PC4
#define LCDPIN_EX   PC5


  // display commands
#define LCD_CMD_SETFUNCTIONMODE          0xc0  // SF
#define LCD_CMD_SETENTRYMODE             0x40  // SE
#define LCD_CMD_SETDISPLAYMODE           0x20  // SD
#define LCD_CMD_SHIFTCURDISPADDRESS      0x10  // MA
#define LCD_CMD_SETUNDERLINEMODE         0x0C  // SU
#define LCD_CMD_WRITERAMUNDERLINEBIT     0x08  // WU
#define LCD_CMD_SETBLINKINGFREQUENCY     0x04  // SB
#define LCD_CMD_CURSORHOMESTARTADDR      0x03  // MH
#define LCD_CMD_CLEARCURSORDATAADDRHOME  0x01  // CH
#define LCD_CMD_NOOPERATION              0x00  // NOP


  // SF - Set Function Mode constants
#define sfIO8BIT         0x20  // bit 5
#define sfIO4BIT         0x00
#define sfFont5x8        0x10  // bit 4
#define sfFont5x12       0x00
  
  // SD - Set Display Mode constants
#define dmDisplayOn      0x10
#define dmCursorOn       0x08
#define dmUnderline      0x04
#define dmCursorBlink    0x02
#define dmCharacterBlink 0x01

  // SU - Set Underline Mode constants
#define suSetUnderline   0x03
#define suResetUnderline 0x02
#define suNoUnderline    0x00

  // SB - Set Blinking Frequency constants
#define sbSlow           0x00
#define sbNormal         0x01
#define sbFast           0x02
#define sbFastest        0x03

  // SE - Set Entry Mode constants

  // base definitions cursor
#define LCD_EM_CursorRead 0x08
#define LCD_EM_CursorWrite 0x10 
#define LCD_EM_CursorIncrement 0x00
#define LCD_EM_CursorDecrement 0x20

  // base definitions display
#define LCD_EM_DisplayRead 0x01
#define LCD_EM_DisplayWrite 0x02 
#define LCD_EM_DisplayIncrement 0x00
#define LCD_EM_DisplayDecrement 0x04

  // constants for cursor
#define emCursorNoChange       0x00
#define emCursorIncRead        LCD_EM_CursorIncrement | LCD_EM_CursorRead
#define emCursorIncWrite       LCD_EM_CursorIncrement | LCD_EM_CursorWrite
#define emCursorIncReadWrite   LCD_EM_CursorIncrement | LCD_EM_CursorRead | LCD_EM_CursorWrite
#define emCursorDecRead        LCD_EM_CursorDecrement | LCD_EM_CursorRead
#define emCursorDecWrite       LCD_EM_CursorDecrement | LCD_EM_CursorWrite
#define emCursorDecReadWrite   LCD_EM_CursorDecrement | LCD_EM_CursorRead | LCD_EM_CursorWrite

  // constants for display start address                                                
#define emDisplayNoChange      0x00
#define emDisplayIncRead       LCD_EM_DisplayIncrement | LCD_EM_DisplayRead
#define emDisplayIncWrite      LCD_EM_DisplayIncrement | LCD_EM_DisplayWrite
#define emDisplayIncReadWrite  LCD_EM_DisplayIncrement | LCD_EM_DisplayRead | LCD_EM_DisplayWrite
#define emDisplayDecRead       LCD_EM_DisplayDecrement | LCD_EM_DisplayRead
#define emDisplayDecWrite      LCD_EM_DisplayDecrement | LCD_EM_DisplayWrite
#define emDisplayDecReadWrite  LCD_EM_DisplayDecrement | LCD_EM_DisplayRead | LCD_EM_DisplayWrite


//extern int LCDIsBusy(void);
extern void LCDSend(const uint8_t AControl, char AData);
extern void LCDInit(void);
extern void LCDSetCursorPos(const uint8_t y, const uint8_t x);
extern void LCDWrite(const char * c);
extern void LCDWritePGM(const char * c);
extern void LCDWriteBuffer(const uint8_t aAddress, const uint8_t * aBuffer, const uint8_t aBufferSize);
extern void LCDWriteBufferPGM(const uint8_t aAddress, const uint8_t * aBuffer, const uint8_t aBufferSize);
extern void LCDWriteLoop(const char c, uint8_t aCount);

  // schreibt das bergebene Zeichen an die aktuelle Cursor-Position
#define LCDWriteChar(c)            LCDSend(_BV(LCDPIN_IOC2), c)

  // setzt den Display-Modus
  // man verwende die oben deklarierten Konstanten ;)
//#define LCDSetDisplayMode(mode)    LCDSend(0, mode | 32)

  // setzt den Cursor an die angegebene Adresse
//#define LCDSetCursorAddress(address)   LCDSend((1<<LCDPIN_IOC1) | (1<<LCDPIN_IOC2), address)

#define cls(void)      LCDSend(0, LCD_CMD_CLEARCURSORDATAADDRHOME);


#endif 
