/*
 * Brutkasten
 *
 * CPU: Atmel ATMega 16
 *
 * timer 0: encoder [timer0.c -> encoder.c]
 * timer 1: piezo [piezo.c]
 * timer 2: 
 *
 *
 */


#include <stdbool.h>
#include <stdint.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <avr/sleep.h>
#include <util/delay.h>

#include "dht11.h"
#include "onewire.h"
#include "ds18x20.h"
#include "m50530.h"
#include "timer0.h"
#include "encoder.h"
#include "piezo.h"
#include "menu.h"
#include "config.h"

static void LCD_put_temp(int16_t decicelsius)
{
	char s[10];

	//uart_put_int( decicelsius );
	//COMOutStr(" deciC, ");
	DS18X20_format_from_decicelsius( decicelsius, s, 10 );
	LCDWrite( s );
  LCDWrite(" C");
}

void LCDOutDec(int8_t aNumber)
{
  if ( 0 > aNumber )
  {
    LCDWriteChar('-');
    aNumber = -aNumber;
  }

  if ( 99 < aNumber )
    LCDWriteChar('0' + ((aNumber / 100) % 10));
  if ( 9 < aNumber )
    LCDWriteChar('0' + ((aNumber / 10) % 10));
  LCDWriteChar('0' + (aNumber % 10));
}

int main(void)
{
  wdt_disable();
  set_sleep_mode(SLEEP_MODE_IDLE);

  config_init();
  LCDInit();
  initDHT11();
  encode_init();
  piezo_init();
  timer0_init();
  menu_init();

  sei();
  sleep_enable();

  LCDSetCursorPos(0, 0);
  for (uint8_t i=0xf4; i < 0xff; i++)
    LCDWriteChar(i);

  while ( true )
  {
    /*
    if ( ! readDHT11() )
    {
      uint16_t lValue = getHumidity();
      
      LCDSetCursorPos(0, 0);
      LCDOutDec(lValue >> 8);
      LCDWriteChar('.');
      LCDOutDec(lValue & 0xff);
      LCDWrite(" %");

      lValue = getTemp();
      LCDSetCursorPos(0, (0 > lValue) ? 8 : 9);
      LCDOutDec(lValue >> 8);
      LCDWriteChar('.');
      LCDOutDec(lValue & 0xff);
      //LCDWrite(" \xdfC");
      LCDWriteChar(' ');
      LCDWriteChar(0xdf);
      LCDWriteChar('C');
    }

		if ( DS18X20_start_meas( DS18X20_POWER_EXTERN, NULL ) == DS18X20_OK) 
    {
			_delay_ms( DS18B20_TCONV_12BIT );
      int16_t decicelsius;

      if ( DS18X20_read_decicelsius_single( DS18B20_FAMILY_CODE, &decicelsius ) == DS18X20_OK ) 
      {
        LCDSetCursorPos(1, 8);
			  LCD_put_temp( decicelsius );
			}
    }
    */

    menu_cycle();

    menu_output();
    
    sleep_cpu();
  }
}
